/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/Device','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/field/FieldBaseRenderer','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Condition','sap/ui/mdc/field/ConditionType','sap/ui/mdc/field/ConditionsType','sap/ui/mdc/enum/BaseType','sap/ui/mdc/util/DateUtil','sap/ui/core/library','sap/ui/mdc/Control','sap/ui/core/LabelEnablement','sap/ui/core/message/MessageMixin','sap/base/util/ObjectPath','sap/base/util/deepEqual','sap/base/util/merge','sap/base/Log','sap/base/util/isEmptyObject','sap/ui/dom/containsOrEquals','sap/ui/model/Filter','sap/ui/model/BindingMode','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/restricted/_debounce','sap/ui/events/KeyCodes'],function(q,D,E,F,a,b,C,c,d,B,e,f,g,L,M,O,h,m,k,l,n,o,p,r,P,V,s,t,S,u,K){"use strict";var v=f.ValueState;var w=f.CalendarType;var T=f.TextAlign;var x=f.TextDirection;var y=g.extend("sap.ui.mdc.field.FieldBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:'sap.ui.model.type.String'},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enum.EditMode",group:"Data",defaultValue:E.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enum.FieldDisplay",defaultValue:F.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:x.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:v.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},_fieldHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.field.FieldHelpBase",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},_oManagedObjectModel:null});M.call(y.prototype);var z={Default:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],editMultiLine:"sap/m/TextArea",display:"sap/m/Text",createEdit:u1,createEditMulti:w1,createEditMultiLine:x1,createDisplay:y1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:false},defaultEnterHandler:true},Search:{edit:"sap/m/SearchField",display:"sap/m/Text",createEdit:v1,createDisplay:y1,useDefaultFieldHelp:false,defaultEnterHandler:false},Date:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/DatePicker",create:z1},"BT":{name:"sap/m/DateRangeSelection",create:A1}},createEdit:u1,createEditMulti:w1,createDisplay:y1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},Time:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/TimePicker",create:z1}},createEdit:u1,createEditMulti:w1,createDisplay:y1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},DateTime:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/DateTimePicker",create:z1}},createEdit:u1,createEditMulti:w1,createDisplay:y1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},Link:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],editMultiLine:"sap/m/TextArea",display:"sap/m/Link",createEdit:u1,createEditMulti:w1,createEditMultiLine:x1,createDisplay:B1,useDefaultFieldHelp:false,defaultEnterHandler:true},Boolean:{edit:"sap/ui/mdc/field/FieldInput",display:"sap/m/Text",createEdit:C1,createDisplay:y1,useDefaultFieldHelp:{name:"bool",oneOperatorSingle:true,oneOperatorMulti:true},defaultEnterHandler:true},Unit:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/ui/mdc/field/FieldInput","sap/m/Token"],display:"sap/m/Text",createEdit:D1,createEditMulti:E1,createDisplay:y1,useDefaultFieldHelp:false,defaultEnterHandler:true}};var A={onsapprevious:G1,onsapnext:G1,onsapup:G1,onsapdown:G1,onsapbackspace:G1};var G={onsapenter:Q};var H;var I;y._init=function(){H={};if(I&&I.bool&&I.bool.control){I.bool.control.destroy();}if(I&&I.defineConditions&&I.defineConditions.control){I.defineConditions.control.destroy();}I={bool:{name:"sap/ui/mdc/field/BoolFieldHelp",id:"BoolDefaultHelp",getDelegate:"getDefaultFieldHelpBaseDelegate",properties:{},control:undefined},defineConditions:{name:"sap/ui/mdc/field/FieldValueHelp",id:"Field-DefineConditions-Help",getDelegate:"getDefaultFieldValueHelpDelegate",properties:{showConditionPanel:true},control:undefined}};};y._init();y.prototype.init=function(){g.prototype.init.apply(this,arguments);this._oManagedObjectModel=new s(this);this._oObserver=new t(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","ariaLabelledBy"]});this._oDatePickerRequested={};this.attachEvent("modelContextChange",this._handleModelContextChange,this);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;};y.prototype.exit=function(){var i=this.getFieldInfo();if(i){i.detachEvent("dataUpdate",i2,this);}var j=this.getContent();if(j){n1.call(this,j);}var u2=this.getContentEdit();if(u2){n1.call(this,u2);}var v2=this.getContentDisplay();if(v2){n1.call(this,v2);}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;this._oObserver.disconnect();this._oObserver=undefined;if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();this._oConditionType=undefined;}if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();this._oConditionsType=undefined;}var w2=Y1.call(this);if(w2){w2.detachEvent("dataUpdate",c2,this);if(this._bConnected){d2.call(this);w2.connect();}}T1.call(this);delete this._fnLiveChangeTimer;};y.prototype.applySettings=function(){g.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoaded){this.initControlDelegate();}return this;};y.prototype.setProperty=function(i,j,u2){if(i!=="width"&&i!=="editMode"&&i!=="multipleLines"){u2=true;}return g.prototype.setProperty.apply(this,[i,j,u2]);};y.prototype.onBeforeRendering=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){p1.call(this);}.bind(this));return;}p1.call(this);};y.prototype.onAfterRendering=function(){};y.prototype.onfocusin=function(i){e2.call(this);};y.prototype.onsapfocusleave=function(i){T1.call(this);};function _(i){var j=i.getParameters().fieldGroupIds;if(j.indexOf(this.getId())>-1){i.bCancelBubble=true;if(this._bPendingChange){var u2=document.activeElement;var v2=Y1.call(this);if(!(u2&&v2&&n(v2.getDomRef(),u2))){var w2=q2.call(this);if(w2){N.call(this,undefined,undefined,undefined,w2);}else{N.call(this,this.getConditions(),!this._bParseError);}}}}}y.prototype.onsapup=function(i){var j=Y1.call(this);var u2=i.srcControl;if(j&&(!this._bIsMeasure||u2.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.navigate(-1);}};y.prototype.onsapdown=function(i){var j=Y1.call(this);var u2=i.srcControl;if(j&&(!this._bIsMeasure||u2.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.navigate(1);}};y.prototype.onsapenter=function(i){var j=Y1.call(this);if(j&&j.isOpen(true)){j.close();}};y.prototype.onsapescape=function(i){this.onsapenter(i);};y.prototype.ontap=function(i){var j=Y1.call(this);if(j&&j.openByClick()&&!j.isOpen(true)){j.open(true);}};y.prototype.clone=function(i,j){this.detachEvent("modelContextChange",this._handleModelContextChange,this);var u2=this.getContent();if(u2){n1.call(this,u2);}var v2=this.getContentEdit();if(v2){n1.call(this,v2);}var w2=this.getContentDisplay();if(w2){n1.call(this,w2);}var x2=this.getFieldInfo();if(x2){x2.detachEvent("dataUpdate",i2,this);}var y2=g.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this._handleModelContextChange,this);if(u2){m1.call(this,u2);}if(v2){m1.call(this,v2);}if(w2){m1.call(this,w2);}if(x2){x2.attachEvent("dataUpdate",i2,this);}return y2;};y.prototype.getFieldPath=function(){var i=this.getBindingPath("conditions");if(i&&i.startsWith("/conditions/")){return i.slice(12);}else{return"";}};function J(i,j,u2,v2){if(this._getContent().length>1){this._bPendingChange=true;}else{N.call(this,i,j,u2,v2);}}function N(i,j,u2,v2){if(!v2){if(j){v2=Promise.resolve(this._getResultForPromise(i));}else{v2=Promise.reject(u2);}}this._fireChange(i,j,u2,v2);this._bPendingChange=false;}y.prototype._fireChange=function(i,j,u2,v2){};function Q(i){var j=this.getEditMode();if(b1(j)&&(this.hasListeners("submit")||this._bPendingChange)){var u2=q2.call(this);var v2=false;if(u2){v2=true;}else if(this._bParseError){u2=Promise.reject();}else{u2=Promise.resolve(this._getResultForPromise(this.getConditions()));}if(this._bPendingChange){if(v2){N.call(this,undefined,undefined,undefined,u2);}else{N.call(this,this.getConditions(),!this._bParseError,undefined,u2);}}this.fireSubmit({promise:u2});}}function R(){if(!this._oDataType){var i=this.getDataType();if(typeof i==="string"){this._oDataType=this.getTypeUtil().getDataTypeInstance(i,this.getDataTypeFormatOptions(),this.getDataTypeConstraints());this._oDataType._bCreatedByField=true;}}return this._oDataType;}y.prototype._initDataType=function(){if(this._oDataType){this._oDataType.destroy();this._oDataType=undefined;}if(this._oDateOriginalType){if(this._oDateOriginalType._bCreatedByField){this._oDateOriginalType.destroy();}this._oDateOriginalType=undefined;}if(this._oUnitOriginalType){if(this._oUnitOriginalType._bCreatedByField){this._oUnitOriginalType.destroy();}this._oUnitOriginalType=undefined;}delete this._sDisplayFormat;delete this._sValueFormat;delete this._sCalendarType;};function U(){if(this._oDataType&&typeof this._oDataType==="object"){return this._oDataType.getMetadata().getName();}else if(this.bDelegateInitialized){return this.getControlDelegate().getDataTypeClass(this.getPayload(),this.getDataType());}else{return this.getDataType();}}function W(){if(this._oDataType&&typeof this._oDataType==="object"&&this._oDataType.oConstraints){return this._oDataType.oConstraints;}else{return this.getDataTypeConstraints();}}function X(){if(this._oDataType&&typeof this._oDataType==="object"&&this._oDataType.oFormatOptions){return this._oDataType.oFormatOptions;}else{return this.getDataTypeFormatOptions();}}function Y(i,j,u2){var v2=this.getTypeUtil().getBaseType(i,j,u2);switch(v2){case B.Date:this._sValueFormat="yyyy-MM-dd";break;case B.DateTime:this._sValueFormat="yyyy-MM-dd'T'HH:mm:ss";break;case B.Time:this._sValueFormat="HH:mm:ss";break;default:return;}this._sDisplayFormat="medium";if(j){if(j.style){this._sDisplayFormat=j.style;}else if(j.pattern){this._sDisplayFormat=j.pattern;}if(j.calendarType){this._sCalendarType=j.calendarType;}}}function Z(){var i=R.call(this);var j=i.getMetadata().getName();var u2=i.oFormatOptions;var v2=i.oConstraints;Y.call(this,j,u2,v2);if(!u2||u2.style||!u2.pattern||u2.pattern!==this._sValueFormat||!u2.calendarType||u2.calendarType!==w.Gregorian){this._oDateOriginalType=this._oDataType;this._oDataType=e.createInternalType(i,this._sValueFormat);k2.call(this);}}function $(){var i=R.call(this);var j=i.getMetadata().getName();var u2=i.oFormatOptions;var v2=l(i.oConstraints)?undefined:i.oConstraints;if(!u2||!u2.hasOwnProperty("showMeasure")||u2.showMeasure){u2=m({},u2);u2.showMeasure=false;u2.strictParsing=true;if(u2.hasOwnProperty("parseAsString")&&i.hasOwnProperty("bParseAsString")){u2.parseAsString=i.bParseAsString;}if(u2.customCurrencies){delete u2.customCurrencies;}if(u2.customUnits){delete u2.customUnits;}var w2=O.get(j);this._oUnitOriginalType=this._oDataType;this._oDataType=new w2(u2,v2);this.getControlDelegate().initializeInternalUnitType(this.getPayload(),this._oDataType,this._oTypeInitialization);k2.call(this);}}function a1(i,j){var u2=Y1.call(this);if(u2&&this._bConnected){Z1.call(this,i,u2);}}y.prototype._getContent=function(){var i=this.getContent();if(!i){if(this.getEditMode()===E.Display){i=this.getContentDisplay();}else{i=this.getContentEdit();}}if(i){return[i];}else{return this.getAggregation("_content",[]);}};function b1(i){if(i===E.Editable||i===E.EditableReadOnly||i===E.EditableDisplay){return true;}else{return false;}}function c1(i){if(i===E.Editable){return true;}else{return false;}}function d1(i){if(i&&i!==E.Disabled){return true;}else{return false;}}function e1(i){if(i&&i!==E.Editable){return true;}else{return false;}}y.prototype._handleModelContextChange=function(i){};function f1(i){this.setValueState(v.Error);this.setValueStateText(i);}function g1(){this.setValueState(v.None);this.setValueStateText();}y.prototype._observeChanges=function(j){var u2=function(){if(this.getAggregation("_content",[]).length>0){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){p1.call(this);}.bind(this));}else{p1.call(this);}}};if(j.name==="dataType"){if(this._oDataType){var v2=function(y2){var z2=this.getTypeUtil().getDataTypeClass(j.current);if(!(this._oDataType instanceof z2)){this._initDataType();this.destroyAggregation("_content");k2.call(this);}}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){v2.call(this,j.current);}.bind(this));return;}v2.call(this,j.current);}}if(j.name==="dataTypeFormatOptions"||j.name==="dataTypeConstraints"){if(this._oDataType){this._initDataType();this.destroyAggregation("_content");k2.call(this);}}if(j.name==="maxConditions"){u2.call(this);k2.call(this);}if(j.name==="conditions"){this._bParseError=false;a1.call(this,j.current,j.old);var w2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var x2=this._aAsyncChanges[i];if(x2.waitForUpdate&&h(x2.result,j.current)){Q1.call(this,x2);w2=true;break;}}if(w2){this._aAsyncChanges.splice(i,1);}}if(j.name==="display"){r1.call(this);k2.call(this);}if(j.name==="fieldHelp"&&j.ids){W1.call(this,j.ids,j.mutation);k2.call(this);}if(j.name==="fieldInfo"&&j.child){h2.call(this,j.child,j.mutation);}if(j.name==="content"&&j.child){l1.call(this,j.child,j.mutation,j.name);}if(j.name==="contentEdit"&&j.child){l1.call(this,j.child,j.mutation,j.name);}if(j.name==="contentDisplay"&&j.child){l1.call(this,j.child,j.mutation,j.name);}if(j.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoaded){this.initControlDelegate.call(this);}if(j.name==="ariaLabelledBy"&&j.ids){h1.call(this,j.ids,j.mutation);}};y.prototype.getFocusDomRef=function(){var i=this._getContent();if(i.length>0){return i[0].getFocusDomRef();}else{return this.getDomRef();}};y.prototype.getIdForLabel=function(){var i;var j=this._getContent();if(j.length>0){i=j[0].getIdForLabel();}else{i=q1.call(this);}return i;};y.prototype.getControlForSuggestion=function(){var i=this._getContent();if(i.length>0){if(this._bIsMeasure){return i[1];}else{return i[0];}}else{return this;}};y.prototype.getMaxConditionsForHelp=function(){if(this._bIsMeasure){return 1;}else{return this.getMaxConditions();}};y.prototype.enhanceAccessibilityState=function(i,j){var u2=this.getParent();if(u2&&u2.enhanceAccessibilityState){u2.enhanceAccessibilityState(this,j);}return j;};y.prototype.getAccessibilityInfo=function(){var i=this._getContent();if(i.length>0&&i[0].getAccessibilityInfo){return i[0].getAccessibilityInfo();}else{return{};}};function h1(j,u2){var v2=this.getAggregation("_content",[]);var w2=this.getContent();if(w2){v2.push(w2);}w2=this.getContentDisplay();if(w2){v2.push(w2);}w2=this.getContentEdit();if(w2){v2.push(w2);}for(var i=0;i<v2.length;i++){w2=v2[i];if(w2.getMetadata().getAllAssociations().ariaLabelledBy){if(u2==="remove"){w2.removeAriaLabelledBy(j);}else if(u2==="insert"){w2.addAriaLabelledBy(j);}}}}function i1(j){var u2=this.getAriaLabelledBy();for(var i=0;i<u2.length;i++){var v2=u2[i];j.addAriaLabelledBy(v2);}}function j1(i,j){var u2={aria:{}};var v2=Y1.call(this);if(v2){var w2=v2.getRoleDescription(this.getMaxConditionsForHelp());u2["role"]="combobox";if(w2){u2.aria["roledescription"]=w2;}u2.aria["haspopup"]="listbox";u2["autocomplete"]="off";if(i){u2.aria["expanded"]="true";u2.aria["controls"]=v2.getContentId();if(j){u2.aria["activedescendant"]=j;}}else{u2.aria["expanded"]="false";}}this.setProperty("_ariaAttributes",u2,true);}y.prototype.connectLabel=function(i){t1.call(this,i);i.bindProperty("text",{path:"$field>/label"});i.setLabelFor(this);return this;};function k1(){var j=L.getReferencingLabels(this);for(var i=0;i<j.length;i++){var u2=sap.ui.getCore().byId(j[i]);u2.invalidate();}}function l1(i,j,u2){if(j==="remove"){n1.call(this,i);I1.call(this,i);if(this._oContentConditionTypes){delete this._oContentConditionTypes[u2];}i.setModel(null,"$field");}else if(j==="insert"){H1.call(this,i,true);m1.call(this,i);if(this.getAggregation("_content",[]).length>0){r1.call(this);}if(!this._oContentConditionTypes){this._oContentConditionTypes={};}if(!this._oContentConditionTypes[u2]){this._oContentConditionTypes[u2]={};}var v2;var w2;for(w2 in i.getMetadata().getAllProperties()){if(i.getBindingPath(w2)==="/conditions"){v2=i.getBindingInfo(w2);if(v2&&v2.type&&v2.type instanceof d){this._oContentConditionTypes[u2].oConditionsType=v2.type;}this._sBoundProperty=w2;}if(w2==="editable"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/editMode",formatter:b1});}if(w2==="enabled"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/editMode",formatter:d1});}if(w2==="displayOnly"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/editMode",formatter:e1});}if(w2==="required"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/required"});}if(w2==="textAlign"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/textAlign"});}if(w2==="textDirection"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/textDirection"});}if(w2==="valueState"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/valueState"});}if(w2==="valueStateText"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/valueStateText"});}if(w2==="placeholder"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/placeholder"});}}for(var x2 in i.getMetadata().getAllAggregations()){if(i.getBindingPath(x2)==="/conditions"){v2=i.getBindingInfo(x2);if(v2&&v2.template){for(w2 in v2.template.getMetadata().getAllProperties()){var y2=v2.template.getBindingInfo(w2);if(y2&&y2.type&&y2.type instanceof c){this._oContentConditionTypes[u2].oConditionType=y2.type;break;}}}}if(x2==="tooltip"&&!i.getBindingPath(x2)&&!i.getAggregation(x2)){i.bindProperty(x2,{path:"$field>/tooltip"});}}if(i.getMetadata().getAllAssociations().ariaLabelledBy){i1.call(this,i);}}}function m1(i){if(i.getMetadata().getEvents().change){i.attachEvent("change",P1,this);}if(i.getMetadata().getEvents().liveChange){i.attachEvent("liveChange",S1,this);}if(i.getMetadata().getEvents().press){i.attachEvent("press",U1,this);}}function n1(i){if(i.getMetadata().getEvents().change){i.detachEvent("change",P1,this);}if(i.getMetadata().getEvents().liveChange){i.detachEvent("liveChange",S1,this);}if(i.getMetadata().getEvents().press){i.detachEvent("press",U1,this);}}function o1(){if(this._oConditionType&&!this._oConditionType._bCreatedByField){this._oConditionType=undefined;}if(this._oConditionsType&&!this._oConditionsType._bCreatedByField){this._oConditionsType=undefined;}var i=this.getEditMode();var j;var u2;if(this.getContent()){if(this._oContentConditionTypes.content){j=this._oContentConditionTypes.content.oConditionType;u2=this._oContentConditionTypes.content.oConditionsType;}}else if(i===E.Display&&this.getContentDisplay()){if(this._oContentConditionTypes.contentDisplay){j=this._oContentConditionTypes.contentDisplay.oConditionType;u2=this._oContentConditionTypes.contentDisplay.oConditionsType;}}else if(i!==E.Display&&this.getContentEdit()){if(this._oContentConditionTypes.contentEdit){j=this._oContentConditionTypes.contentEdit.oConditionType;u2=this._oContentConditionTypes.contentEdit.oConditionsType;}}if(j){if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();}this._oConditionType=j;}if(u2){if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();}this._oConditionsType=u2;}k2.call(this);}function p1(){o1.call(this);X1.call(this,this.getFieldHelp());j1.call(this,false);var j=this.getEditMode();if(this.getContent()||this._bIsBeingDestroyed||(j===E.Display&&this.getContentDisplay())||(j!==E.Display&&this.getContentEdit())){r1.call(this);var u2=this._getContent();if(u2.length===1){t1.call(this,u2[0]);}return;}var v2=U.call(this);var w2=W.call(this);var x2=X.call(this);var y2=this.getTypeUtil().getBaseType(v2,x2,w2);var z2=this.getMaxConditions();var A2=this._getOperators();var B2;var C2;var D2;var E2=this.getAggregation("_content",[]);var F2;var G2;if(E2.length>0){F2=E2[0];G2=F2.getMetadata().getName().replace(/\./g,"/");}B2=z[y2];if(!B2){if(this.getFieldInfo()&&this._bTriggerable){B2=z.Link;}else{var H2=new RegExp("^\\*(.*)\\*|\\$search$");if(H2.test(this.getFieldPath())&&this.getMaxConditions()===1){B2=z.Search;}else{B2=z.Default;}}}if(j===E.Display){C2=B2.display;D2=B2.createDisplay;}else if(z2!==1){C2=B2.editMulti;D2=B2.createEditMulti;}else if(this.getMultipleLines()){C2=B2.editMultiLine;D2=B2.createEditMultiLine;}else if(A2.length===1&&B2.editOperator&&B2.editOperator[A2[0]]){C2=B2.editOperator[A2[0]].name;D2=B2.editOperator[A2[0]].create;}else{C2=B2.edit;D2=B2.createEdit;}if(!C2){throw new Error("No control defined for type "+v2+" in "+this);}var I2;if(Array.isArray(C2)){I2=C2;C2=I2[0];}else{I2=[C2];}if(C2!==G2){this._bHideOperator=M1.call(this,A2);if(F2){r1.call(this);if(F2.isA("sap.m.DateTimeField")){this._initDataType();}k2.call(this);}var J2;var i=0;for(i=0;i<I2.length;i++){var K2=I2[i];if(!H[K2]){H[K2]={};}if(!H[K2].control){H[K2].control=sap.ui.require(K2);if(!H[K2].control){J2=undefined;}}if(i===0){J2=H[K2].control;}}if(!J2){if(H[C2].promise){H[C2].promise.then(p1.bind(this));return;}else{H[C2].promise=new Promise(function(O2){H[C2].resolve=O2;sap.ui.require(I2,s1.bind(this));}.bind(this)).then(p1.bind(this));return;}}if(L1.call(this,B2,A2,j,z2)){J1.call(this,B2.useDefaultFieldHelp.name);}else if(this._sDefaultFieldHelp){delete this._sDefaultFieldHelp;}var L2=q1.call(this);var M2=D2.call(this,J2,L2);for(i=0;i<M2.length;i++){var N2=M2[i];N2.attachEvent("parseError",N1,this);N2.attachEvent("validationError",O1,this);H1.call(this,N2,B2.defaultEnterHandler);t1.call(this,N2);if(this._bConnected&&((i===0&&!this._bIsMeasure)||(i===1&&this._bIsMeasure))){f2.call(this,N2);}this.addAggregation("_content",N2);}k1.call(this);if(M2.length>1){this.attachValidateFieldGroup(_,this);}}}function q1(){return this.getId()+"-inner";}function r1(){if(this._getContent().length>1){this.detachValidateFieldGroup(_,this);}this.destroyAggregation("_content");if(this._oDateOriginalType){this._oDataType=this._oDateOriginalType;this._oDateOriginalType=undefined;}else if(this._oUnitOriginalType){this._oDataType=this._oUnitOriginalType;this._oUnitOriginalType=undefined;}if(this._bParseError){this._bParseError=false;g1.call(this);}if(this._bIsMeasure){this._bIsMeasure=false;}}function s1(){for(var i=0;i<arguments.length;i++){var j=arguments[i];var u2=j.getMetadata().getName();u2=u2.replace(/\./g,"/");H[u2].control=j;if(H[u2].resolve){H[u2].resolve();delete H[u2].resolve;}}}function t1(i){i.setModel(this._oManagedObjectModel,"$field");}function u1(i,j){var u2=m2.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",valueHelpIconSrc:g2.call(this),showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",change:P1.bind(this),liveChange:S1.bind(this),valueHelpRequest:$1.bind(this)});v2._setPreferUserInteraction(true);i1.call(this,v2);this._sBoundProperty="value";return[v2];}function v1(i,j){this._bHideOperator=true;var u2=m2.call(this);k2.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2,mode:p.OneWay},placeholder:"{$field>/placeholder}",width:"100%",tooltip:"{$field>/tooltip}",search:Q.bind(this),change:P1.bind(this),liveChange:S1.bind(this)});i1.call(this,v2);this._sBoundProperty="value";return[v2];}function w1(i,j){var u2=sap.ui.require("sap/m/Token");var v2=l2.call(this);var w2=new u2(j+"-token",{text:{path:'$field>',type:v2}});var x2=new i(j,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",valueHelpIconSrc:g2.call(this),ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:w2},dependents:[w2],change:P1.bind(this),liveChange:S1.bind(this),tokenUpdate:V1.bind(this),valueHelpRequest:$1.bind(this)});x2._setPreferUserInteraction(true);i1.call(this,x2);return[x2];}function x1(i,j){var u2=m2.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",rows:4,tooltip:"{$field>/tooltip}",change:P1.bind(this),liveChange:S1.bind(this)});v2._setPreferUserInteraction(true);i1.call(this,v2);this._sBoundProperty="value";return[v2];}function y1(i,j){var u2=m2.call(this);var v2=new i(j,{text:{path:"$field>/conditions",type:u2},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",wrapping:"{$field>/multipleLines}",width:"100%",tooltip:"{$field>/tooltip}"});this._sBoundProperty="text";return[v2];}function z1(i,j){this._bHideOperator=true;var u2=m2.call(this);Z.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2},displayFormat:this._sDisplayFormat,valueFormat:this._sValueFormat,placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:P1.bind(this)});if(v2.setDisplayFormatType){v2.setDisplayFormatType(this._sCalendarType);}v2._setPreferUserInteraction(true);i1.call(this,v2);this._sBoundProperty="value";return[v2];}function A1(i,j){var u2=m2.call(this);Z.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2},displayFormat:this._sDisplayFormat,valueFormat:this._sValueFormat,delimiter:"...",displayFormatType:this._sCalendarType,placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:P1.bind(this)});v2._setPreferUserInteraction(true);i1.call(this,v2);this._sBoundProperty="value";return[v2];}function B1(i,j){var u2=this.getFieldInfo();var v2=m2.call(this);var w2=new i(j,{text:{path:"$field>/conditions",type:v2},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",press:U1.bind(this),wrapping:true});if(u2){u2.getDirectLinkHrefAndTarget().then(j2.bind(this));}i1.call(this,w2);this._sBoundProperty="text";return[w2];}function C1(i,j){return u1.call(this,i,j);}function D1(i,j){$.call(this);this._bIsMeasure=true;var u2=m2.call(this);var v2=[];var w2=new i(j,{value:{path:"$field>/conditions",type:u2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",valueHelpIconSrc:"sap-icon://slim-arrow-down",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",fieldGroupIds:[this.getId()],change:P1.bind(this),liveChange:S1.bind(this)});w2._setPreferUserInteraction(true);i1.call(this,w2);v2.push(w2);v2=F1.call(this,v2,j,i);this._sBoundProperty="value";return v2;}function E1(i,j){$.call(this);this._bIsMeasure=true;var u2=sap.ui.require("sap/m/Token");var v2=sap.ui.require("sap/m/Input");var w2=l2.call(this);var x2=[];var y2=new u2(j+"-token",{text:{path:'$field>',type:w2}});var z2=new o({path:"values",test:function(B2){if(!Array.isArray(B2[0])||B2[0][0]){return true;}else{return false;}}});var A2=new i(j,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",fieldGroupIds:[this.getId()],tokens:{path:"$field>/conditions",template:y2,filters:[z2]},dependents:[y2],change:P1.bind(this),liveChange:S1.bind(this),tokenUpdate:V1.bind(this)});A2._setPreferUserInteraction(true);i1.call(this,A2);x2.push(A2);x2=F1.call(this,x2,j,v2);this._sBoundProperty="value";return x2;}function F1(i,j,u2){var v2=n2.call(this);if(this.getEditMode()===E.EditableDisplay){i[0].bindProperty("description",{path:"$field>/conditions",type:v2});i[0].setWidth("100%");i[0].setFieldWidth("70%");}else{var w2=new u2(j+"-unit",{value:{path:"$field>/conditions",type:v2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:c1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueHelpIconSrc:g2.call(this),valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"30%",tooltip:"{$field>/tooltip}",fieldGroupIds:[this.getId()],change:P1.bind(this),liveChange:S1.bind(this),valueHelpRequest:$1.bind(this)});w2._setPreferUserInteraction(true);i1.call(this,w2);i.push(w2);}return i;}function G1(i){var j=false;var u2=Y1.call(this);if(!u2){return;}else if(u2.isOpen()){j=true;}else{switch(i.type){case"sapprevious":case"sapup":if(i.keyCode===K.ARROW_UP){j=true;}break;case"sapnext":case"sapdown":if(i.keyCode===K.ARROW_DOWN){j=true;}break;default:break;}}if(j){i.stopPropagation();i.stopImmediatePropagation(true);switch(i.type){case"sapup":this.onsapup(i);break;case"sapdown":this.onsapdown(i);break;default:break;}}}function H1(i,j){i.addDelegate(A,true,this);if(j){i.addDelegate(G,false,this);}}function I1(i){i.removeDelegate(A);i.removeDelegate(G);}function J1(i){this.setProperty("_fieldHelpEnabled",true,true);this._sDefaultFieldHelp=I[i].id;var j=I[i].control;if(j&&j.bIsDestroyed){I[i].control=undefined;j=undefined;}if(!j){if(I[i].promise){I[i].promise.then(K1.bind(this));}var u2=sap.ui.require(I[i].name);if(!u2&&!I[i].promise){I[i].promise=new Promise(function(x2){I[i].resolve=x2;sap.ui.require([I[i].name],function(y2){J1.call(this,i);}.bind(this));}.bind(this)).then(K1.bind(this));}if(u2){var v2=this.bDelegateInitialized&&this.getControlDelegate()[I[i].getDelegate]();var w2=m({delegate:v2},I[i].properties);j=new u2(I[i].id,w2);I[i].control=j;j.connect(this);if(I[i].resolve){I[i].resolve();delete I[i].resolve;}if(!I[i].promise){K1.call(this);}}}else{K1.call(this);}}function K1(){W1.call(this,"BoolDefaultHelp","insert");var i=this.getAggregation("_content",[])[0];if(i){i.setValueHelpIconSrc(g2.call(this));}}function L1(i,j,u2,v2){if(i.useDefaultFieldHelp&&!this.getFieldHelp()&&u2!==E.Display){if(j.length===1){var w2=M1.call(this,j);if(v2===1){if(!(i.editOperator&&i.editOperator[j[0]])&&(i.useDefaultFieldHelp.oneOperatorSingle||!w2)){return true;}}else if(i.useDefaultFieldHelp.oneOperatorMulti||!w2){return true;}}else{return true;}}return false;}function M1(i){if(i.length===1){var j=b.getOperator(i[0]);return!j||j.isSingleValue();}else{return false;}}function N1(i){this._bParseError=true;}function O1(u2){this._bParseError=true;var v2=u2.getParameter("newValue");var w2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var x2=this._aAsyncChanges[i];if(x2.waitForUpdate&&Array.isArray(x2.result)){if(x2.result.length===0&&v2===""){x2.reject(u2.getParameter("exception"));w2=true;}else{for(var j=0;j<x2.result.length;j++){var y2=x2.result[j];if(h(y2.values[0],v2)||(y2.operator==="BT"&&h(y2.values[1],v2))){x2.reject(u2.getParameter("exception"));w2=true;break;}}}if(w2){break;}}}if(w2){this._aAsyncChanges.splice(i,1);}}function P1(i){var j={parameters:m({},i.getParameters()),source:i.getSource()};var u2=this._aAsyncChanges.length;if(u2>0&&!this._aAsyncChanges[u2-1].changeFired){this._aAsyncChanges[u2-1].changeFired=true;this._aAsyncChanges[u2-1].changeEvent=j;J.call(this,undefined,undefined,undefined,this._aAsyncChanges[u2-1].promise);return;}var v2={changeEvent:j};Q1.call(this,v2);}function Q1(i){var j=this.getConditions();var u2;var v2=true;var w2;var x2;var y2=i.changeEvent.source;var z2=false;var A2=true;var B2=false;if(i.changeEvent.parameters.hasOwnProperty("valid")){v2=i.changeEvent.parameters["valid"];if(!v2&&i.changeEvent.parameters.hasOwnProperty("value")){w2=i.changeEvent.parameters["value"];}}var C2=false;var D2=this._sBoundProperty&&y2.getBinding(this._sBoundProperty);if(D2&&D2.getBindingMode()!==p.OneWay&&D2.getPath()==="/conditions"&&v2){x2=j[0];u2=j[0]&&j[0].values[0];}else if(i.changeEvent.parameters.hasOwnProperty("value")){u2=i.changeEvent.parameters["value"];if(v2){C2=true;}}else{x2=j[0];u2=j[0]&&j[0].values[0];}if(C2){g1.call(this);var E2;var F2;if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;y2.setDOMValue("");return;}x2=S.resolve().then(function(){var H2=this.getMaxConditions();if(this._oNavigateCondition){v2=true;return this._oNavigateCondition;}else if(u2===""&&H2!==1){return null;}else{E2=l2.call(this);var I2=E2.parseValue(u2);var J2=this._aAsyncChanges.length;if(J2>0&&!this._aAsyncChanges[J2-1].changeFired){F2=this._aAsyncChanges[J2-1];F2.changeFired=true;F2.changeEvent=i.changeEvent;J.call(this,undefined,undefined,undefined,F2.promise);}return I2;}}.bind(this)).then(function(x2){A2=R1.call(this,x2,j,E2,v2,u2,y2,F2||i);A2=A2||B2;return x2;}.bind(this)).catch(function(H2){if(H2&&!(H2 instanceof P)&&!(H2 instanceof r)&&!(H2 instanceof V)){throw H2;}v2=false;w2=u2;this._bParseError=true;f1.call(this,H2.message);if(F2&&F2.reject){if(s2.call(this,F2)){F2.reject(H2);}}else if(z2){J.call(this,j,v2,w2);}}.bind(this)).unwrap();if(x2 instanceof Promise){z2=true;}}else if(!i.changeEvent.parameters.hasOwnProperty("valid")&&this._bParseError){w2=i.changeEvent.parameters["value"];v2=false;}var G2=Y1.call(this);if(G2&&this._bConnected){if(sap.ui.getCore().getCurrentFocusedControlId()===y2.getId()){G2.close();}G2.setFilterValue("");if(!z2&&v2){Z1.call(this,j,G2);G2.onFieldChange();}T1.call(this);}if(this._oNavigateCondition){this._oNavigateCondition=undefined;k2.call(this);}if(i.resolve){r2.call(this,i);}else if(!z2&&A2){J.call(this,j,v2,w2);}}function R1(i,j,u2,v2,w2,x2,y2){var z2=this.getMaxConditions();var A2=false;if(i===null&&z2!==1){return true;}if(u2){u2.validateValue(i);}if(v2){if(i){if(this._bIsMeasure&&j.length===1&&j[0].values[0][0]===undefined){j=[];}if(z2!==1&&b.indexOfCondition(i,j)>=0){throw new P(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[w2]));}else{if(z2>0&&z2<=j.length){j.splice(0,j.length-z2+1);}j.push(i);}}else if(z2===1){j=[];}if(!h(j,this.getConditions())){this.setProperty("conditions",j,true);A2=true;}if(z2!==1){x2.setValue("");}}if(y2.resolve){var B2=Y1.call(this);if(B2&&this._bConnected){Z1.call(this,j,B2);B2.onFieldChange();}y2.result=j;r2.call(this,y2);s2.call(this,y2);}return A2;}function S1(j){var u2;var v2;var w2=false;var x2=j.getSource();this._oNavigateCondition=undefined;k2.call(this);if("value"in j.getParameters()){u2=j.getParameter("value");}else if("newValue"in j.getParameters()){u2=j.getParameter("newValue");}if("escPressed"in j.getParameters()){w2=j.getParameter("escPressed");}if("previousValue"in j.getParameters()){v2=j.getParameter("previousValue");}else{var y2=this.getConditions();v2=y2[0]&&y2[0].values[0];}this._bParseError=false;var z2=Y1.call(this);if(z2&&(!this._bIsMeasure||x2.getShowValueHelp())){if(w2){if(z2.isOpen(true)){z2.close();T1.call(this);}}else{var A2=this._getOperators();var B2=false;for(var i=0;i<A2.length;i++){var C2=b.getOperator(A2[i]);if(C2.validateInput){B2=true;break;}}if(B2){this._bIgnoreInputValue=false;this._vLiveChangeValue=u2;if(!this._fnLiveChangeTimer){this._fnLiveChangeTimer=u(function(){var E2=this.getDisplay();var F2="";if(this._vLiveChangeValue){var C2=b.getEQOperator();var G2=C2.getValues(this._vLiveChangeValue,E2,true);if(G2[0]){F2=G2[0];if(G2[1]){F2=F2+" ";}}if(G2[1]){F2=F2+G2[1];}}var D2=z2.openByTyping();if(this._bConnected&&this._getContent()[0]&&D2&&!(D2 instanceof Promise)&&(sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId()||(this._getContent()[1]&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[1].getId()))){z2.setFilterValue(F2);if(this.getMaxConditionsForHelp()===1&&z2.getConditions().length>0){z2.setConditions([]);}z2.open(true);j1.call(this,true);delete this._vLiveChangeValue;}}.bind(this),300,{leading:false,trailing:true});z2.initBeforeOpen(true);}var D2=z2.openByTyping();if(D2 instanceof Promise){D2.then(function(){var E2=document.activeElement;if(E2&&(n(this.getDomRef(),E2))&&this._fnLiveChangeTimer){this._fnLiveChangeTimer();}}.bind(this));}this._fnLiveChangeTimer();}}}this.fireLiveChange({value:u2,escPressed:w2,previousValue:v2});}function T1(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue;}}function U1(i){var j=this.getFieldInfo();if(j){j.getTriggerHref().then(function(u2){if(!u2){j.open(this._getContent()[0]);j1.call(this,true);}}.bind(this));}this.firePress();}function V1(j){if(j.getParameter("type")==="removed"){var u2=j.getParameter("removedTokens");var v2=this.getConditions();var w2;var i;for(i=0;i<u2.length;i++){var x2=u2[i];var y2=x2.getBindingContext("$field").sPath;var z2=parseInt(y2.slice(y2.lastIndexOf("/")+1));v2[z2].delete=true;}for(i=v2.length-1;i>=0;i--){if(v2[i].delete){if(this._bIsMeasure){w2=v2[i].values[0][1];}v2.splice(i,1);}}if(this._bIsMeasure&&w2&&v2.length===0){v2=[C.createItemCondition([undefined,w2],undefined)];}this.setProperty("conditions",v2,true);N.call(this,v2,true);j.preventDefault(true);}}function W1(i,j){if(j==="remove"){var u2=sap.ui.getCore().byId(i);if(u2){u2.detachEvent("select",_1,this);u2.detachEvent("navigate",a2,this);u2.detachEvent("dataUpdate",c2,this);u2.detachEvent("disconnect",d2,this);u2.detachEvent("afterClose",b2,this);}this.setProperty("_fieldHelpEnabled",false,true);}else if(j==="insert"){X1.call(this,i);}a1.call(this,this.getConditions());}function X1(i){if(i&&!this.getProperty("_fieldHelpEnabled")){var j=sap.ui.getCore().byId(i);if(j){j.attachEvent("dataUpdate",c2,this);this.setProperty("_fieldHelpEnabled",true,true);}}}function Y1(){var i=this.getFieldHelp();var j;if(!i&&this._sDefaultFieldHelp){i=this._sDefaultFieldHelp;}if(i){j=sap.ui.getCore().byId(i);}return j;}function Z1(j,u2){if(!u2){u2=Y1.call(this);}if(this._bIsMeasure){var v2=[];for(var i=0;i<j.length;i++){var w2=j[i];if(w2.values[0]&&w2.values[0][1]){var x2=C.createItemCondition(w2.values[0][1],undefined,w2.inParameters,w2.outParameters);v2.push(x2);}}u2.setConditions(v2);}else{u2.setConditions(j);}}function $1(i){var j=Y1.call(this);if(j){j.setFilterValue("");var u2=this.getConditions();Z1.call(this,u2,j);j.toggleOpen(false);j1.call(this,true);if(!j.isFocusInHelp()){var v2=i.getSource();if(v2.bValueHelpRequested){v2.bValueHelpRequested=false;}}}}function _1(j){var u2=this.getConditions();var v2=j.getParameter("conditions");var w2=j.getParameter("add");var x2=j.getParameter("close");var y2=j.oSource;var z2=this.getMaxConditions();var A2;var B2=this.getControlForSuggestion();var C2;var i=0;if(this._bIsMeasure){if(v2.length>1){throw new Error("Only one item must be selected! "+this);}if(v2[0].operator!=="EQ"){throw new Error("Only EQ allowed! "+this);}if(u2.length>0){for(i=0;i<u2.length;i++){u2[i].values[0][1]=v2[0].values[0];if(u2[i].operator==="BT"){u2[i].values[1][1]=v2[0].values[0];}if(v2[0].inParameters){u2[i].inParameters=v2[0].inParameters;}if(v2[0].outParameters){u2[i].outParameters=v2[0].outParameters;}}}else{A2=m({},v2[0]);A2.values[0]=[undefined,A2.values[0]];A2.values[1]=undefined;u2.push(A2);if(this._oConditionType){C2=this._oConditionType.formatValue(A2);}else if(this._oConditionsType){C2=this._oConditionsType.formatValue(u2);}}}else{if(!w2){u2=[];}for(i=0;i<v2.length;i++){A2=v2[i];if(!t2.call(this,A2.operator)){continue;}var D2=w2?-1:b.indexOfCondition(A2,u2);if(D2===-1){u2.push(A2);}else if(A2.values[1]!==u2[D2].values[1]&&u2[D2].values[1]){u2[D2].values[1]=A2.values[1];}}}if(z2>0&&z2<u2.length){u2.splice(0,u2.length-z2);}if(B2&&B2.setDOMValue){if(this.getMaxConditionsForHelp()===1&&u2.length>0){if(this._bIsMeasure&&this._oUnitConditionsType){C2=this._oUnitConditionsType.formatValue(u2);}else if(this._oConditionType){C2=this._oConditionType.formatValue(u2[0]);}else if(this._oConditionsType){C2=this._oConditionsType.formatValue(u2);}if(C2 instanceof Promise){C2.then(function(F2){B2.setDOMValue("");B2.setDOMValue(F2);});}else{B2.setDOMValue("");B2.setDOMValue(C2);}}else if(x2){B2.setDOMValue("");y2.setFilterValue("");this._bIgnoreInputValue=false;}else{this._bIgnoreInputValue=true;}}var E2=this.getConditions();if(!h(u2,E2)){this._oNavigateCondition=undefined;k2.call(this);this.setProperty("conditions",u2,true);if(!b.compareConditionsArray(u2,E2)){y2.onFieldChange();J.call(this,u2,true);}}}function a2(i){var j=i.getParameter("value");var u2=i.getParameter("key");var v2=i.getParameter("condition");var w2=i.getParameter("itemId");var x2;var y2;var z2=this.getControlForSuggestion();if(v2){this._oNavigateCondition=m({},v2);u2=v2.values[0];j=v2.values[1];}else{this._oNavigateCondition=C.createItemCondition(u2,j);}if(this._bIsMeasure){var A2=this.getConditions();if(A2.length>0){this._oNavigateCondition.operator=A2[0].operator;this._oNavigateCondition.values[0]=[A2[0].values[0][0],this._oNavigateCondition.values[0]];if(A2[0].operator==="BT"){this._oNavigateCondition.values[1]=[A2[0].values[1][0],this._oNavigateCondition.values[0][1]];}else{this._oNavigateCondition.values[1]=undefined;}}else{this._oNavigateCondition.values=[[undefined,this._oNavigateCondition.values[0]],undefined];}}this._bPreventGetDescription=true;k2.call(this);if(this.getDisplay()!==F.Value){x2=u2;}else if(j){x2=j;}else{x2=u2;}if(z2&&z2.setDOMValue){if(!y2){if(this._bIsMeasure&&this._oUnitConditionsType&&this._oNavigateCondition){y2=this._oUnitConditionsType.formatValue([this._oNavigateCondition]);}else if(this._oConditionType&&this._oNavigateCondition){y2=this._oConditionType.formatValue(this._oNavigateCondition);}else if(this._oConditionsType&&this._oNavigateCondition){y2=this._oConditionsType.formatValue([this._oNavigateCondition]);}else{y2=j||u2;}}z2.setDOMValue(y2);z2._doSelect();}this._bPreventGetDescription=false;k2.call(this);j1.call(this,true,w2);this._bIgnoreInputValue=false;this.fireLiveChange({value:x2});}function b2(i){if(this._bIgnoreInputValue){var j=this.getControlForSuggestion();this._bIgnoreInputValue=false;j.setDOMValue("");}j1.call(this,false);}function c2(i){var j=this.getEditMode()===E.Editable&&this._getContent().length>0&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId();if(!j&&!this._bPendingConditionUpdate&&this.getConditions().length>0&&(this.getMaxConditions()!==1||(this.getDisplay()!==F.Value&&!this._bParseError))){this._oManagedObjectModel.checkUpdate(true);}}function d2(i){var j=Y1.call(this);j.detachEvent("select",_1,this);j.detachEvent("navigate",a2,this);j.detachEvent("disconnect",d2,this);j.detachEvent("afterClose",b2,this);this._bConnected=false;}function e2(){var i=Y1.call(this);if(i&&!this._bConnected){i.connect(this);this._bConnected=true;i.attachEvent("select",_1,this);i.attachEvent("navigate",a2,this);i.attachEvent("disconnect",d2,this);i.attachEvent("afterClose",b2,this);var j=this.getConditions();Z1.call(this,j,i);var u2=this.getControlForSuggestion();f2.call(this,u2);}}function f2(i){if(i&&!i.orgOnsapfocusleave&&i.onsapfocusleave){i.orgOnsapfocusleave=i.onsapfocusleave;i.onsapfocusleave=function(j){var u2=Y1.call(this.getParent());if(u2){var v2=sap.ui.getCore().byId(j.relatedControlId);if(v2){if(n(u2.getDomRef(),v2.getFocusDomRef())){j.stopPropagation();return;}else{u2.skipOpening();}}}this.orgOnsapfocusleave(j);};}}function g2(){var i=Y1.call(this);if(i){return i.getIcon();}}function h2(i,j){if(j==="remove"){i.detachEvent("dataUpdate",i2,this);}else if(j==="insert"){i.attachEvent("dataUpdate",i2,this);i2.call(this);}}function i2(){var i=this.getFieldInfo();var j=this;i.isTriggerable().then(function(u2){j._bTriggerable=u2;if(j.getAggregation("_content",[]).length>0&&j.getEditMode()===E.Display){p1.call(j);if(j._bTriggerable){i.getDirectLinkHrefAndTarget().then(j2.bind(j));}}});}function j2(i){if(i){var j=this.getAggregation("_content",[])[0];j.setHref(i.href);j.setTarget(i.target);}}y.prototype._getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=p2.bind(this);}return{valueType:R.call(this),originalDateType:this._oDateOriginalType||this._oUnitOriginalType,display:this._bIsMeasure?F.Value:this.getDisplay(),fieldHelpID:this._bIsMeasure?undefined:this.getFieldHelp()||this._sDefaultFieldHelp,operators:this._getOperators(),hideOperator:this._bHideOperator,maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription};};function k2(){if(this._oConditionType||this._oConditionsType){var i=this._getFormatOptions();if(this._oConditionType){this._oConditionType.setFormatOptions(i);}if(this._oConditionsType){this._oConditionsType.setFormatOptions(i);}if(this._oUnitConditionsType){i=o2.call(this);this._oUnitConditionsType.setFormatOptions(i);}}}y.prototype._updateConditionType=function(){k2.call(this);};function l2(){if(!this._oConditionType){var i=this._getFormatOptions();this._oConditionType=new c(i);this._oConditionType._bCreatedByField=true;}return this._oConditionType;}function m2(){if(!this._oConditionsType){var i=this._getFormatOptions();this._oConditionsType=new d(i);this._oConditionsType._bCreatedByField=true;}return this._oConditionsType;}y.prototype._checkValueInitial=function(i){if(i===null||i===undefined){return true;}if(i===""||(typeof(i)==="string"&&i.match(/^0+$/))){var j=R.call(this);var u2=j.parseValue("","string");if(u2===i){return true;}else{try{j.validateValue(u2);}catch(v2){return true;}}}else{var w2=U.call(this);if(this.getTypeUtil().getBaseType(w2)===B.Unit&&Array.isArray(i)&&i.length>1&&(i[0]===undefined||i[0]===null)&&!i[1]){return true;}}return false;};function n2(){if(!this._oUnitConditionsType){var i=o2.call(this);this._oUnitConditionsType=new d(i);this._oUnitConditionsType._bCreatedByField=true;}return this._oUnitConditionsType;}function o2(){if(!this._asyncParsingCall){this._asyncParsingCall=p2.bind(this);}return{valueType:undefined,originalDateType:R.call(this),display:this.getDisplay(),fieldHelpID:this.getFieldHelp()||this._sDefaultFieldHelp,operators:["EQ"],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,isUnit:true,getConditions:this.getConditions.bind(this)};}function p2(i){var j=Y1.call(this);if(j&&j.isOpen()){var u2=document.activeElement;if(u2&&(n(this.getDomRef(),u2)||n(j.getDomRef(),u2))){j.close();}}var v2={};var w2=new Promise(function(x2,y2){v2.resolve=x2;v2.reject=y2;i.then(function(z2){v2.result=z2;this._bParseError=false;var A2=this.getConditions();if(h(z2,A2)){r2.call(this,v2);s2.call(this,v2);}else{v2.waitForUpdate=true;}}.bind(this)).catch(function(z2){if(z2&&!(z2 instanceof P)&&!(z2 instanceof r)&&!(z2 instanceof V)){throw z2;}this._bParseError=true;y2(z2);s2.call(this,v2);}.bind(this));}.bind(this));v2.promise=w2;this._aAsyncChanges.push(v2);}function q2(){var j=[];for(var i=0;i<this._aAsyncChanges.length;i++){j.push(this._aAsyncChanges[i].promise);}if(j.length>0){return Promise.all(j).then(function(){return this._getResultForPromise(this.getConditions());}.bind(this));}return null;}y.prototype._getResultForPromise=function(i){return i;};function r2(i){i.resolve(this._getResultForPromise(i.result));}function s2(j){var u2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(j===this._aAsyncChanges[i]){u2=true;break;}}if(u2){this._aAsyncChanges.splice(i,1);}return u2;}y.prototype._getOperators=function(){var i=new RegExp("^\\*(.*)\\*|\\$search$");if(i.test(this.getFieldPath())&&this.getMaxConditions()===1){return["Contains"];}var j=U.call(this);var u2=W.call(this);var v2=X.call(this);var w2=this.getTypeUtil().getBaseType(j,v2,u2);if(w2===B.Unit){w2=B.Numeric;}return b.getOperatorsForType(w2);};function t2(j){var u2=this._getOperators();for(var i=0;i<u2.length;i++){if(j===u2[i]){return true;}}return false;}return y;});
