/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/enum/OutParameterMode','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/condition/FilterConverter','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/ObjectPath','sap/base/util/deepEqual','sap/base/util/merge','sap/ui/model/resource/ResourceModel','sap/ui/model/Context','sap/ui/Device','sap/m/library','sap/ui/core/library'],function(F,C,a,O,b,c,M,S,d,e,m,R,f,D,g,h){"use strict";var k;var B;var V;var l;var n;var o;var p=g.ButtonType;var q=h.OpenState;var r=F.extend("sap.ui.mdc.field.FieldValueHelp",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/field/FieldValueHelpDelegate"}},filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},showConditionPanel:{type:"boolean",defaultValue:false},title:{type:"string",group:"Appearance",defaultValue:""},noDialog:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.mdc.field.FieldValueHelpContentWrapperBase",multiple:false},filterBar:{type:"sap.ui.mdc.filterbar.FilterBarBase",multiple:false},inParameters:{type:"sap.ui.mdc.field.InParameter",group:"Data",multiple:true},outParameters:{type:"sap.ui.mdc.field.OutParameter",group:"Data",multiple:true},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"}},defaultAggregation:"content",events:{dataRequested:{}}}});r._init=function(){F._init.apply(this,arguments);k=undefined;B=undefined;V=undefined;l=undefined;n=undefined;o=undefined;};r.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(s.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions","showConditionPanel","title","filterFields"],aggregations:["content","filterBar","inParameters"]});this.setBindingContext(null);};r.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;}if(this._oFilterConditionModel){this._oFilterConditionModel.destroy();delete this._oFilterConditionModel;}this._oObserver.disconnect();this._oObserver=undefined;};r.prototype.invalidate=function(i){if(i){var j=this.getContent();var v1=this.getAggregation("_dialog");if(j&&i===j){var w1=this.getAggregation("_popover");if(v1&&v1.isOpen()){var x1=v1.getContent()[0];x1.invalidate(i);}else if(w1&&w1.isOpen()){w1.invalidate(i);}return;}var y1=this.getFilterBar();if((v1&&i===v1)||(y1&&i===y1)){if(i.bOutput&&!this._bIsBeingDestroyed){var z1=this.getParent();if(z1){z1.invalidate(this);}}return;}}F.prototype.invalidate.apply(this,arguments);};r.prototype.connect=function(i){F.prototype.connect.apply(this,arguments);t1.call(this);o1.call(this,this.getShowConditionPanel());return this;};r.prototype.getIcon=function(){if(this.getNoDialog()){return"sap-icon://slim-arrow-down";}else{return"sap-icon://value-help";}};r.prototype._createPopover=function(){var i=F.prototype._createPopover.apply(this,arguments);if(i){var j=this.getContent();if(j){j.initialize(true);}i._getAllContent=function(){var v1=this.getParent();var w1=[];if(v1){var x1=s1.call(v1);if(x1){w1.push(x1);}}return w1;};if(this._bNavigate){this.navigate(this._iStep);}}return i;};r.prototype._handleAfterOpen=function(i){F.prototype._handleAfterOpen.apply(this,arguments);var j=this.getContent();if(j){j.fieldHelpOpen(true);}};r.prototype.open=function(i){if(this.getNoDialog()&&!i){i=true;}this._bUseFilterBar=!i;t1.call(this);if(this._bOpenAfterPromise){this._bSuggestion=i;return;}var j=this.getContent();var v1=function(){if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(this._bSuggestion);delete this._bSuggestion;}}.bind(this);var w1=this._bOpen?this._callContentRequest(!!i,v1):this._fireOpen(!!i,v1);delete this._bOpen;if(!w1){this._bSuggestion=i;if(i){this._getPopover();}else{j1.call(this);}if(j&&j.getFilterEnabled()&&!this._oFilterConditionModel){a1.call(this);}this._bOpenAfterPromise=true;return;}this._bOpenHandled=true;j=this.getContent();if(j&&j.getFilterEnabled()&&!this._bNavigateRunning){if(!j.isSuspended()||i){this._bApplyFilter=true;}if(!this._oFilterConditionModel){a1.call(this);}else{r1.call(this);}}if(this._bUpdateFilterAfterClose){this._bUpdateFilterAfterClose=false;H.call(this,this.getFilterValue());}if(i){if(!j){this._bOpenIfContent=true;}else{j.fieldHelpOpen(i);if(this._oFilterConditionModel&&!this.getFilterValue()&&!this._bNavigateRunning){this._oFilterConditionModel.checkUpdate(true,true);}F.prototype.open.apply(this,[i]);}}else{q1.call(this);var x1=this.getAggregation("_popover");if(x1){if(x1.isOpen()){this.close();}x1.$().remove();}var y1=j1.call(this);if(y1){var z1=y1.getContent()[0];z1.setShowTokenizer(this.getMaxConditions()!==1&&!!j);z1.setFormatOptions(this._getFormatOptions());z1.bindProperty("conditions",{path:"$help>/conditions"});var A1=this.getFilterFields();if(A1){z1.bindProperty("filterConditions",{path:"filter>/conditions/"+A1});}if(j){j.fieldHelpOpen(false);G.call(this);}this._aOldConditions=this.getConditions();y1.open();this._bDialogOpen=true;}else{this._bOpen=true;}}this._bOpenHandled=false;return;};r.prototype.toggleOpen=function(i){if(this.getNoDialog()&&!i){i=true;}if(i){F.prototype.toggleOpen.apply(this,[i]);}else if(this._bOpen||this._bOpenIfContent||this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}else{var j=j1.call(this);if(j){if(j.isOpen()){var v1=j.oPopup.getOpenState();if(v1!=="CLOSED"&&v1!=="CLOSING"){this.close();}else{this._bReopen=true;}}else{this.open(i);}}else{this.open(i);}}};r.prototype.close=function(){if(!this._bDialogOpen){F.prototype.close.apply(this,arguments);}else{this._bUseFilterBar=false;var i=this.getAggregation("_dialog");if(i){this._bClosing=true;i.close();var j=i.getContent()[0];j.unbindProperty("conditions",true);j.unbindProperty("filterConditions",true);}this._bReopen=false;delete this._bOpen;delete this._bOpenAfterPromise;}};r.prototype.isOpen=function(i){var j=F.prototype.isOpen.apply(this,arguments);if(!j&&(!i||!this._bClosing)){var v1=this.getAggregation("_dialog");if(v1){j=v1.isOpen();}}return j;};r.prototype.getDomRef=function(){if(!this._bDialogOpen){return F.prototype.getDomRef.apply(this,arguments);}else{this._bUseFilterBar=false;var i=this.getAggregation("_dialog");if(i){return i.getDomRef();}}};function _(){if(!this._oFilterConditionModel){return;}var i=this._oFilterConditionModel.getAllConditions();var j=false;for(var v1 in i){if(i[v1].length>0){j=true;break;}}if(j){this._oFilterConditionModel.removeAllConditions();}}r.prototype._handleAfterClose=function(i){var j=this.getContent();if(j){if(!j.getAsyncKeyText()){_.call(this);}j.fieldHelpClose();}this._bApplyFilter=false;F.prototype._handleAfterClose.apply(this,arguments);};function s(i){if(i.object==this){var j;if(i.name==="content"){i1.call(this,i.mutation,i.child);}if(i.name==="filterBar"){p1.call(this,i.mutation,i.child);}if(i.name==="conditions"){E.call(this,i.current);}if(i.name==="filterValue"){if(this._bClosing){this._bUpdateFilterAfterClose=true;}else{H.call(this,i.current);}}if(i.name==="showConditionPanel"){o1.call(this,i.current);}if(i.name==="title"){j=this.getAggregation("_dialog");if(j){j.setTitle(i.current);}}if(i.name==="filterFields"){j=this.getAggregation("_dialog");if(j){var v1=j.getContent()[0];v1.setSearchEnabled(!!i.current);if(j.isOpen()){if(i.current){v1.bindProperty("filterConditions",{path:"filter>/conditions/"+i.current});}else{v1.unbindProperty("filterConditions",true);}}}}if(i.name==="inParameters"){I.call(this,i.child,i.mutation);}}else if(i.object.isA("sap.ui.mdc.field.InParameter")){if(i.name==="value"){L.call(this,i.object.getHelpPath(),i.current,i.old,i.object.getUseConditions());}if(i.name==="helpPath"){N.call(this,i.current,i.old,i.object.getValue(),i.object.getUseConditions());}}}r.prototype.openByTyping=function(){if(!this._bDetermineSearchSupportedCalled&&!this.isOpen()&&!this._bOpen&&!this._bOpenIfContent&&!this._bOpenAfterPromise){this.initControlDelegate();if(this.bDelegateInitialized){return t.call(this);}else{this._bDetermineSearchSupportedCalled=true;return this.awaitControlDelegate().then(function(){return t.call(this);}.bind(this));}}return!!this.getFilterFields();};function t(){this.fireOpen({suggestion:true});this._bDetermineSearchSupportedCalled=true;var i=this.getControlDelegate().determineSearchSupported(this.getPayload(),this);if(i instanceof Promise){return i.then(function(){return!!this.getFilterFields();}.bind(this));}else{return!!this.getFilterFields();}}r.prototype.isFocusInHelp=function(){if(!this.getNoDialog()){var i=this.getAggregation("_dialog");if((i&&i.isOpen())||(this._bDialogRequested&&this._bOpen)){return true;}}if(this._bFocusPopover){return true;}return false;};r.prototype.navigate=function(i){var j=this.getContent();var v1=this.getAggregation("_popover");t1.call(this);if(!v1||!v1.isOpen()){var w1=function(){this.navigate(i);}.bind(this);var x1=this._bNavigate?this._callContentRequest(true,w1):this._fireOpen(true,w1);if(!x1){j=this.getContent();this._bNavigate=false;this._iStep=null;if(j){this._getPopover();if(!this._oFilterConditionModel){a1.call(this);}}return;}}this._bNavigate=false;this._iStep=null;j=this.getContent();if(j){v1=this._getPopover();this._bApplyFilter=true;this._bNavigateRunning=true;if(!this._oFilterConditionModel){a1.call(this);}else{P.call(this);}this._oFilterConditionModel.checkUpdate(true,true);}if(!v1){this._bNavigate=true;this._iStep=i;return;}if(j){j.navigate(i);}};function u(i){var j=this._getPopover();var v1=i.getParameter("key");var w1=i.getParameter("description");var x1=i.getParameter("inParameters");var y1=i.getParameter("outParameters");var z1=i.getParameter("leave");var A1=i.getParameter("itemId");var B1;if(z1){this._oField.focus();return;}if(v1===undefined){this._bFocusPopover=true;}if(!j.isOpen()){this._bOpenHandled=true;this.open(true);this._bOpenHandled=false;}this._bNavigateRunning=false;if(v1===undefined){this._bFocusPopover=false;return;}B1=C.createItemCondition(v1,w1);B1.validated=b.Validated;if(x1){B1.inParameters=Q.call(this,x1);}if(y1){B1.outParameters=T.call(this,y1);}this.setProperty("conditions",[B1],true);this.fireNavigate({value:w1,key:v1,condition:B1,itemId:A1});}r.prototype._getTextOrKey=function(i,j,v1,w1,x1,y1){var z1="";var A1=this.getContent();if(A1){var B1=A1.getListBinding();if(!B1){this.fireDataRequested();}if(v1&&!v1.getModel()){return null;}var C1=this.oBindingContexts[undefined];var D1=this.getInParameters();var E1=false;if(v1&&f.hasChanged(C1,v1)){E1=true;}var F1=v.call(this,D1,E1,v1,C1);z1=S.resolve().then(function(){return x.call(this,F1);}.bind(this)).then(function(){return S.resolve().then(function(){if(j){return A1.getTextForKey(i,Y.call(this,w1,D1,false,F1,v1),X.call(this,x1,true),y1);}else{return A1.getKeyForText(i,Y.call(this,undefined,D1,false,F1,v1),y1);}}.bind(this)).then(function(z1){w.call(this,F1,E1);return y.call(this,z1);}.bind(this)).unwrap();}.bind(this)).unwrap();}return z1;};function v(j,v1,w1,x1){var y1=[];for(var i=0;i<j.length;i++){var z1=j[i];var A1=z1.getBinding("value");if(A1){var B1=A1.getPath();var C1=A1.getContext();if(v1&&(C1===x1||(!C1&&x1))){if(w1.getProperty(B1)===undefined){var D1=A1.getModel();y1.push(D1.bindProperty(B1,w1));}}else{if(!C1||C1.getProperty(B1)===undefined||A1.getValue()===undefined||!e(z1.validateProperty("value",C1.getProperty(B1)),z1.getValue())){y1.push(A1);}}}}return y1;}function w(j,v1){if(!v1){return;}for(var i=0;i<j.length;i++){j[i].destroy();}}function x(i){if(i.length===0){return null;}this.initControlDelegate();if(this.bDelegateInitialized){return this.getControlDelegate().checkBindingsPending(this.getPayload(),i);}else{return this.awaitControlDelegate().then(function(){return this.getControlDelegate().checkBindingsPending(this.getPayload(),i);}.bind(this));}}function y(i){if(i&&typeof i==="object"){i=m({},i);if(i.inParameters){i.inParameters=Q.call(this,i.inParameters);}if(i.outParameters){i.outParameters=T.call(this,i.outParameters);}}return i;}r.prototype._isTextOrKeyRequestSupported=function(){var i=this.getContent();return!!i;};r.prototype.isUsableForValidation=function(){var i=this.getContent();return!!i;};function z(v1){var w1=v1.getParameter("selectedItems");var x1=v1.getParameter("itemPress");var y1;var z1=this.getConditions();var A1;var i=0;var j=0;var B1=false;var C1=this.getMaxConditions();for(i=z1.length-1;i>=0;i--){A1=z1[i];A1.inParameters=W.call(this,A1.inParameters);A1.outParameters=X.call(this,A1.outParameters);if(A1.validated===b.Validated){B1=false;for(j=0;j<w1.length;j++){y1=w1[j];if(A1.values[0]===y1.key&&(!A1.inParameters||!y1.inParameters||e(A1.inParameters,y1.inParameters))&&(!A1.outParameters||!y1.outParameters||e(A1.outParameters,y1.outParameters))){B1=true;if(A1.values[1]!==y1.description&&y1.description){if(A1.values.length===1){A1.values.push(y1.description);}else{A1.values[1]=y1.description;}}break;}}if(!B1){z1.splice(i,1);}}}for(i=0;i<w1.length;i++){y1=w1[i];B1=false;for(j=0;j<z1.length;j++){A1=z1[j];if(A1.validated===b.Validated&&A1.values[0]===y1.key&&(!A1.inParameters||e(A1.inParameters,y1.inParameters))&&(!A1.outParameters||e(A1.outParameters,y1.outParameters))){B1=true;A1.inParameters=y1.inParameters;A1.outParameters=y1.outParameters;break;}}if(!B1){A1=C.createItemCondition(y1.key,y1.description,y1.inParameters,y1.outParameters);A1.validated=b.Validated;z1.push(A1);}}if(C1>0&&z1.length>C1){z1.splice(0,z1.length-C1);}for(i=0;i<z1.length;i++){A1=z1[i];if(A1.inParameters){A1.inParameters=Q.call(this,A1.inParameters);}else{delete A1.inParameters;}if(A1.outParameters){A1.outParameters=T.call(this,A1.outParameters);}else{delete A1.outParameters;}}if(this._bDialogOpen){this.setProperty("conditions",z1,true);}else{var D1=false;var E1=false;if(this.getMaxConditions()===1||x1){this.close();E1=true;}if(this.getMaxConditions()===1){D1=true;}this.setProperty("conditions",z1,true);this.fireSelect({conditions:z1,add:D1,close:E1});}}function A(i){var j=i.getParameter("contentChange");var v1=this.getContent();var w1=v1.getAsyncKeyText();if(j){var x1=this.getAggregation("_popover");var y1=this.getAggregation("_dialog");if(v1){if(v1.getFilterEnabled()&&!this._oFilterConditionModel&&((x1&&this._bOpenIfContent)||y1)){a1.call(this);}if(x1&&this._bOpenIfContent){var z1=this._getField();if(z1){v1.fieldHelpOpen(true);x1.openBy(this._getControlForSuggestion());Z.call(this);}this._bOpenIfContent=false;}else if(y1){var A1=y1.getContent()[0];h1.call(this,A1,v1.getDialogContent());}}}if(!w1){this.fireDataUpdate();}}function E(j){var v1=false;for(var i=0;i<j.length;i++){var w1=j[i];if(!w1.validated){a.checkConditionValidated(w1);v1=true;}}if(v1){this.setConditions(j);}else{G.call(this);}}function G(){if(!this._oField){return;}var j=this.getContent();if(j){var v1=this.getConditions();var w1=[];for(var i=0;i<v1.length;i++){var x1=v1[i];if(x1.validated===b.Validated){w1.push({key:x1.values[0],description:x1.values[1],inParameters:W.call(this,x1.inParameters),outParameters:X.call(this,x1.outParameters)});}}if(!e(w1,j.getSelectedItems())){j.setSelectedItems(w1);}}}function H(i){if(!this._oFilterConditionModel){return;}var j=this.getFilterFields();if(!j){return;}var v1=this._oFilterConditionModel.getConditions(j);var w1=v1.length>0?v1[0].values[0]:"";if(i===w1){return;}if(i){this._bOwnFilterChange=true;}this._oFilterConditionModel.removeAllConditions(j);i=i.trim();if(i){this._bOwnFilterChange=false;var x1=C.createCondition("StartsWith",[i],undefined,undefined,b.NotValidated);this._oFilterConditionModel.addCondition(j,x1);}}function I(i,j){var v1=i.getHelpPath();var w1=false;if(j==="remove"){this._oObserver.unobserve(i);if(this._getField()&&this.isOpen()){w1=K.call(this,v1);}}else{this._oObserver.observe(i,{properties:true});if(this._getField()&&this.isOpen()){var x1=i.getValue();var y1=i.getUseConditions();w1=K.call(this,v1);w1=J.call(this,v1,x1,y1)||w1;G.call(this);}}}function J(j,v1,w1){var x1;var y1;var z1;var A1=false;if(this._oFilterConditionModel&&j&&v1){x1=this.getFilterBar();if(this._bUseFilterBar&&x1){y1=x1.getInternalConditions();if(!y1[j]){y1[j]=[];}}if(w1){if(Array.isArray(v1)){for(var i=0;i<v1.length;i++){z1=m({},v1[i]);if(z1.inParameters){z1.inParameters=W.call(this,z1.inParameters);}if(z1.outParameters){z1.outParameters=X.call(this,z1.outParameters);}this._oFilterConditionModel.addCondition(j,z1);if(this._bUseFilterBar&&x1){y1[j].push(z1);}A1=true;}}}else{z1=C.createItemCondition(v1);z1.validated=b.Validated;this._oFilterConditionModel.addCondition(j,z1);if(this._bUseFilterBar&&x1){y1[j].push(z1);}A1=true;}}if(A1&&this._bUseFilterBar&&x1){x1.setInternalConditions(y1);}return A1;}function K(i){var j=false;if(this._oFilterConditionModel&&i&&this._oFilterConditionModel.getConditions(i).length>0){this._oFilterConditionModel.removeAllConditions(i);j=true;}var v1=this.getFilterBar();if(this._bUseFilterBar&&v1){var w1=v1.getInternalConditions();if(w1[i]&&w1[i].length>0){w1[i]=[];v1.setInternalConditions(w1);j=true;}}return j;}function L(i,j,v1,w1){if(this._bNoInOutFilterUpdate){return;}if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.sUpdateTimer=undefined;this.fireDataUpdate();}.bind(this),0);}if(!this._getField()||!this.isOpen()){return;}var x1=false;x1=K.call(this,i);x1=J.call(this,i,j,w1)||x1;G.call(this);}function N(i,j,v1,w1){if(!this._getField()||!this.isOpen()){return;}var x1=false;x1=K.call(this,j);x1=J.call(this,i,v1,w1)||x1;}function P(){var j=this.getInParameters();var v1=false;for(var i=0;i<j.length;i++){var w1=j[i];var x1=w1.getHelpPath();var y1=w1.getValue();var z1=w1.getUseConditions();v1=K.call(this,x1)||v1;v1=J.call(this,x1,y1,z1)||v1;}if(this._oFilterConditionModel&&!v1&&this._bApplyFilter&&this._bPendingFilterUpdate){this._bPendingFilterUpdate=false;this._oFilterConditionModel.checkUpdate(true,true);}}r.prototype.onFieldChange=function(){var v1=this.getOutParameters();t1.call(this);var w1=v.call(this,v1,false);S.resolve().then(function(){return x.call(this,w1);}.bind(this)).then(function(){if(this.bIsDestroyed){return;}var x1=this.getConditions();for(var i=0;i<x1.length;i++){var y1=x1[i];if(y1.outParameters){for(var z1 in y1.outParameters){for(var j=0;j<v1.length;j++){var A1=v1[j];var B1=A1.getValue();var C1=A1.getUseConditions();var D1=true;if(A1.getMode()===O.WhenEmpty){if(C1){D1=!B1||(Array.isArray(B1)&&B1.length===0);}else{D1=!B1;}}if(D1){if(C1){var E1;if(!A1.getHelpPath()){E1=C.createCondition("EQ",[A1.getFixedValue()],undefined,undefined,b.NotValidated);}else if(A1.getFieldPath()===z1){E1=C.createCondition("EQ",[y1.outParameters[z1]],undefined,undefined,b.Validated);}else{continue;}if(!B1){B1=[];}if(!Array.isArray(B1)){throw new Error("Value on OutParameter must be an array "+A1);}if(a.indexOfCondition(E1,B1)<0){E1.validated=b.Validated;B1.push(E1);A1.setValue(B1);}}else{if(!A1.getHelpPath()){A1.setValue(A1.getFixedValue());}else if(A1.getFieldPath()===z1){A1.setValue(y1.outParameters[z1]);}}}}}}}}.bind(this)).unwrap();};function Q(i){return U.call(this,i,this.getInParameters());}function T(i){return U.call(this,i,this.getOutParameters());}function U(j,v1){if(!j||v1.length===0){return null;}var w1={};for(var i=0;i<v1.length;i++){var x1=v1[i];var y1=x1.getHelpPath();var z1=x1.getFieldPath();if(y1&&z1){for(var A1 in j){if(y1===A1){w1[z1]=j[A1];break;}}}else if(!y1&&z1&&x1.getFixedValue){w1[z1]=x1.getFixedValue();}}return w1;}function W(i){return Y.call(this,i,this.getInParameters());}function X(i,j){return Y.call(this,i,this.getOutParameters(),j);}function Y(v1,w1,x1,y1,z1){var A1;var B1;var C1;var D1;var i=0;if(w1.length>0){if(!v1){if(!x1){var E1=this.getBindingContext();for(i=0;i<w1.length;i++){B1=w1[i];C1=B1.getHelpPath();var F1=B1.getValue();if(y1||z1){var G1=B1.getBinding("value");var H1=false;if(G1){for(var j=0;j<y1.length;j++){if(G1.getPath()===y1[j].getPath()){F1=y1[j].getValue();H1=true;break;}}if(!H1&&z1&&G1.getContext()!==z1&&G1.getContext()===E1){F1=z1.getProperty(G1.getPath());}}}if(C1&&F1){if(!A1){A1={};}if(B1.getUseConditions()){if(F1.length>0){A1[C1]=F1[0].values[0];}}else{A1[C1]=F1;}}}}}else{for(var I1 in v1){for(i=0;i<w1.length;i++){B1=w1[i];C1=B1.getHelpPath();D1=B1.getFieldPath();if(D1&&D1===I1&&C1){if(!A1){A1={};}A1[C1]=v1[I1];}}}}}return A1;}function Z(){if(!this._oFilterConditionModel||(!this.isOpen()&&!this._bNavigateRunning&&!this._bOpen)||this._bClosing||!this._bApplyFilter){this._bPendingFilterUpdate=true;return;}if(this._bFilterWaitingForBinding){return;}var i=this.getInParameters();var j=v.call(this,i,false);var v1=x.call(this,j);if(v1 instanceof Promise){v1.then(function(){this._bFilterWaitingForBinding=false;this._oFilterConditionModel.checkUpdate(true,true);}.bind(this));this._bFilterWaitingForBinding=true;return;}var w1=this.getContent();if(w1){var x1=this._oFilterConditionModel.getAllConditions();var y1=c.createConditionTypesMapFromFilterBar(x1,this.getFilterBar());var z1=c.createFilters(x1,y1);var A1=[];var B1=this._oFilterConditionModel.getConditions("$search");var C1;if(z1){A1.push(z1);}if(B1.length>0){C1=B1[0].values[0];}w1.applyFilters(A1,C1);}}function $(i){if(this._bOwnFilterChange){return;}var j=this.getFilterFields();if(j&&!this._bUpdateFilterAfterClose){var v1=this._oFilterConditionModel.getConditions(j);var w1=v1.length>0?v1[0].values[0]:"";if(w1!==this.getFilterValue()){this.setProperty("filterValue",w1,true);}}Z.call(this);}function a1(){if(!n&&!this._bFilterConditionModelRequested){n=sap.ui.require("sap/ui/mdc/condition/ConditionModel");if(!n){sap.ui.require(["sap/ui/mdc/condition/ConditionModel"],b1.bind(this));this._bFilterConditionModelRequested=true;}}if(n){var i=this.getFilterValue();this._oFilterConditionModel=new n();if(i){H.call(this,i);}P.call(this);var j=this._oFilterConditionModel.bindProperty("/conditions",this._oFilterConditionModel.getContext("/conditions"));j.attachChange($.bind(this));this.setModel(this._oFilterConditionModel,"filter");}}function b1(i){n=i;this._bFilterConditionModelRequested=false;if(!this._bIsBeingDestroyed){a1.call(this);}}r.prototype.getMaxConditions=function(){if(this._oField&&this._oField.getMaxConditionsForHelp){return this._oField.getMaxConditionsForHelp();}else if(this._oField&&this._oField.getMaxConditions){return this._oField.getMaxConditions();}else{return 1;}};r.prototype.getDisplay=function(){if(this._oField&&this._oField.getDisplay){return this._oField.getDisplay();}};r.prototype.getRequired=function(){if(this._oField&&this._oField.getRequired){return this._oField.getRequired();}else{return false;}};r.prototype.getDataType=function(){if(this._oField.getDataType){return this._oField.getDataType();}else{return"sap.ui.model.type.String";}};r.prototype._getFormatOptions=function(){if(this._oField&&this._oField._getFormatOptions){return this._oField._getFormatOptions();}else{return{};}};r.prototype._getKeyPath=function(){var i=this.getKeyPath();if(!i&&this._oField&&this._oField.getFieldPath&&this._oField.getFieldPath()){i=this._oField.getFieldPath();}return i;};r.prototype.clone=function(i,j){var v1=this.getContent();var w1=this.getFilterBar();if(v1){v1.detachEvent("navigate",u,this);v1.detachEvent("selectionChange",z,this);v1.detachEvent("dataUpdate",A,this);}if(w1){w1.detachEvent("search",q1,this);}var x1=F.prototype.clone.apply(this,arguments);if(v1){v1.attachEvent("navigate",u,this);v1.attachEvent("selectionChange",z,this);v1.attachEvent("dataUpdate",A,this);}if(w1){w1.attachEvent("search",q1,this);}return x1;};function c1(){var i;if((!k||!B||!V||!l)&&!this._bDialogRequested){k=sap.ui.require("sap/m/Dialog");B=sap.ui.require("sap/m/Button");V=sap.ui.require("sap/ui/mdc/field/ValueHelpPanel");l=sap.ui.require("sap/ui/mdc/field/DefineConditionPanel");o=sap.ui.require("sap/ui/model/base/ManagedObjectModel");if(!k||!B||!V||!l||!o){sap.ui.require(["sap/m/Dialog","sap/m/Button","sap/ui/mdc/field/ValueHelpPanel","sap/ui/mdc/field/DefineConditionPanel","sap/ui/model/base/ManagedObjectModel"],f1.bind(this));this._bDialogRequested=true;}}if(k&&B&&V&&l&&o&&!this._bDialogRequested){if(!this._oResourceBundle){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}var j=new B(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),type:p.Emphasized,press:k1.bind(this)});var v1=new B(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:l1.bind(this)});this._oManagedObjectModel=new o(this);var w1=g1.call(this);i=new k(this.getId()+"-dialog",{contentHeight:d1(),contentWidth:e1(),horizontalScrolling:false,verticalScrolling:false,title:this.getTitle(),resizable:true,draggable:true,content:[w1],afterOpen:m1.bind(this),afterClose:n1.bind(this),buttons:[j,v1]});i.isPopupAdaptationAllowed=function(){return false;};this.setAggregation("_dialog",i,true);i.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");o1.call(this,this.getShowConditionPanel());}return i;}function d1(){if(D.system.desktop){return"700px";}if(D.system.tablet){return D.orientation.landscape?"600px":"600px";}}function e1(){if(D.system.desktop){return"1080px";}if(D.system.tablet){return D.orientation.landscape?"920px":"600px";}}function f1(i,j,v1,w1,x1){k=i;B=j;V=v1;l=w1;o=x1;this._bDialogRequested=false;if(!this._bIsBeingDestroyed){c1.call(this);if(this._bOpen){this.open();}}}function g1(){var i=this.getContent();var j=this.getFilterBar();var v1=new V(this.getId()+"-VHP",{height:"100%",showFilterbar:!!j,searchEnabled:!!this.getFilterFields(),formatOptions:this._getFormatOptions(),search:u1.bind(this)});v1.setModel(this._oManagedObjectModel,"$help");if(i){i.initialize(false);h1.call(this,v1,i.getDialogContent());}if(j){v1.setFilterbar(j);}return v1;}function h1(i,j){i.setTable(j);}function i1(i,j){var v1=this.getAggregation("_popover");var w1=this.getAggregation("_dialog");if(i==="remove"){j.detachEvent("navigate",u,this);j.detachEvent("selectionChange",z,this);j.detachEvent("dataUpdate",A,this);j=undefined;}else{j.attachEvent("navigate",u,this);j.attachEvent("selectionChange",z,this);j.attachEvent("dataUpdate",A,this);G.call(this);}this.fireDataUpdate();if(this._bNavigate){this.navigate(this._iStep);}else if(v1){v1.invalidate();var x1=this.getFilterValue();if(x1){H.call(this,x1);}P.call(this);if(j&&j.getFilterEnabled()&&!this._oFilterConditionModel){a1.call(this);}if(j&&this._bOpenIfContent){j.initialize(true);var y1=this._getField();if(y1){j.fieldHelpOpen(true);v1.openBy(this._getControlForSuggestion());}this._bOpenIfContent=false;}}else if(j&&this._bOpenIfContent){this._bOpenIfContent=false;this.open(true);}if(w1){if(j){j.initialize(false);if(j.getFilterEnabled()&&!this._oFilterConditionModel){a1.call(this);}var z1=w1.getContent()[0];z1.setShowTokenizer(this.getMaxConditions()!==1);h1.call(this,z1,j.getDialogContent());if(w1.isOpen()||this._bOpen){j.fieldHelpOpen(false);}}}}function j1(){var i=this.getAggregation("_dialog");if(!i){i=c1.call(this);}return i;}function k1(i){this.close();var j=this.getConditions();j=C._removeEmptyConditions(j);a.updateConditionsValues(j,this._getFormatOptions().operators);this._bNoConditionModelUpdate=true;this.setProperty("conditions",j,true);this._bOK=true;}function l1(i){this.close();this.setProperty("conditions",this._aOldConditions,true);}function m1(i){}function n1(i){this._bDialogOpen=false;this._aOldConditions=undefined;this._bUseFilterBar=false;this._bApplyFilter=false;this._handleAfterClose(i);if(this._bOK){var j=this.getConditions();this.fireSelect({conditions:j,add:false,close:true});}this._bOK=undefined;}function o1(i){var j=this.getAggregation("_dialog");if(j&&this._oField){var v1=j.getContent()[0];if(i){if(!v1._oDefineConditionPanel){var w1=new l(this.getId()+"-DCP",{label:"{$help>/title}"});v1.setDefineConditions(w1);}}else{v1.setDefineConditions();}}}function p1(i,j){if(i==="remove"){j.detachEvent("search",q1,this);j=undefined;}else{j.attachEvent("search",q1,this);}var v1=this.getAggregation("_dialog");if(v1){var w1=v1.getContent()[0];w1.setFilterbar(j);w1.setShowFilterbar(!!j);P.call(this);q1.call(this);}}function q1(j){if(!this._oFilterConditionModel||!this._bUseFilterBar){return;}var v1=this.getFilterBar();if(v1){var w1=this._oFilterConditionModel.getAllConditions();var x1=v1.getInternalConditions();var y1=this.getFilterFields();var i=0;var z1;var A1;for(z1 in w1){if(z1!==y1){for(i=0;i<w1[z1].length;i++){A1=m({},w1[z1][i]);if(!x1[z1]||a.indexOfCondition(A1,x1[z1])<0){this._oFilterConditionModel.removeCondition(z1,A1);}}}}for(z1 in x1){for(i=0;i<x1[z1].length;i++){A1=m({},x1[z1][i]);if(!w1[z1]||a.indexOfCondition(A1,w1[z1])<0){this._oFilterConditionModel.addCondition(z1,A1);}}}if(!this._bApplyFilter&&(j||v1.getLiveMode())){this._bApplyFilter=true;this._oFilterConditionModel.checkUpdate(true,true);}}}function r1(){if(!this._oFilterConditionModel){return;}var i=this.getFilterBar();if(i){var j=this._oFilterConditionModel.getAllConditions();var v1=i.getInternalConditions();var w1=this.getFilterFields();var x1=false;var y1;for(y1 in v1){if(y1!==w1){if(j[y1]&&j[y1].length>0){this._oFilterConditionModel.removeAllConditions(y1);}if(v1[y1].length>0){v1[y1]=[];x1=true;}}}j=this._oFilterConditionModel.getAllConditions();for(y1 in j){if(y1!==w1){if(j[y1].length>0){this._oFilterConditionModel.removeAllConditions(y1);}}}if(x1){i.setInternalConditions(v1);}}P.call(this);}function s1(){var i=this.getContent();if(i){return i.getSuggestionContent();}}function t1(){var i=this._oField?this._oField.getBindingContext():null;this.setBindingContext(i);}function u1(i){this._bApplyFilter=true;this._oFilterConditionModel.checkUpdate(true,true);}r.prototype.getScrollDelegate=function(){var i=this.getAggregation("_dialog");if(i&&(i.isOpen()||i.oPopup.getOpenState()===q.OPENING)){var j=this.getContent();var v1=j&&j.getDialogContent();if(v1&&v1.getScrollDelegate){return v1.getScrollDelegate();}else{return undefined;}}else{return F.prototype.getScrollDelegate.apply(this,arguments);}};r.prototype._fireOpen=function(i){if(!this._bOpenHandled){return F.prototype._fireOpen.apply(this,arguments);}return true;};r.prototype.getRoleDescription=function(i){if(!i||i===1){return null;}else if(!this.getContent()&&this.getShowConditionPanel()&&!this.getNoDialog()){return null;}else{if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m");}return this._oResourceBundleM.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION");}};return r;});
