/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BasePanel","sap/m/Label","sap/m/CustomListItem","sap/m/Panel","sap/m/Select","sap/ui/core/Item","sap/m/Toolbar","sap/m/List",'sap/ui/model/Filter',"sap/ui/layout/FixFlex","sap/m/Page","sap/m/ColumnListItem","sap/m/HBox","sap/ui/core/Icon","sap/m/Text","sap/m/Column","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/Table"],function(B,L,C,P,S,I,T,a,F,b,c,d,H,e,f,g,h,i,j){"use strict";var G=B.extend("sap.ui.mdc.p13n.panels.GroupPanelBase",{library:"sap.ui.mdc",metadata:{properties:{itemFactory:{type:"function"},expandFirstGroup:{type:"boolean"},allowSelection:{type:"boolean",defaultValue:true},grouping:{type:"boolean",defaultValue:true},enableReorder:{type:"boolean",defaultValue:true},enableListView:{type:"boolean",defaultValue:true},defaultView:{type:"String"}},aggregations:{footerToolbar:{type:"sap.m.IBar",multiple:false}}},renderer:{}});G.prototype.GROUP_KEY="group";G.prototype.LIST_KEY="list";G.prototype.init=function(){this._mView={};B.prototype.init.apply(this,arguments);this._sView=this.LIST_KEY;};G.prototype.addCustomView=function(v){var o=v.item;var k=o.getKey();var l=v.content;var O=v.search;if(O){this._getSearchField().attachLiveChange(O);}this._mView[k]=l;if(this._oViewSwitch&&!this._oViewSwitch.getVisible()){this._oViewSwitch.setVisible(true);}this._oViewSwitch.addItem(o);};G.prototype._setInnerLayout=function(){if(!this._oGroupModeSelect){this._oGroupModeSelect=new S({items:[new I({key:"all",text:this.getResourceText("p13nDialog.GROUPMODE_ALL")}),new I({key:"visible",text:this.getResourceText("p13nDialog.GROUPMODE_VISIBLE")}),new I({key:"active",text:this.getResourceText("p13nDialog.GROUPMODE_ACTIVE")}),new I({key:"visibleactive",text:this.getResourceText("p13nDialog.GROUPMODE_VISIBLE_ACTIVE")})],change:this._onGroupModeChange.bind(this)});}if(!this._oViewSwitch){this._oViewSwitch=new h({visible:false,items:[new i({tooltip:this.getResourceText("filterbar.ADAPT_LIST_VIEW"),icon:"sap-icon://list",key:this.LIST_KEY}),new i({tooltip:this.getResourceText("filterbar.ADAPT_GROUP_VIEW"),icon:"sap-icon://group-2",key:this.GROUP_KEY})],selectionChange:function(E){var k=E.getParameter("item").getKey();this.switchViewMode(k);}.bind(this)});}var o=this._createContainer();this.addStyleClass("sapUiMDCGroupPanelBase");this.setAggregation("_content",o);};G.prototype._createContainer=function(){var o=new c({showHeader:false,content:[new b({minFlexSize:1,fixContent:[new H({justifyContent:"SpaceBetween",items:[new H({items:[this._oGroupModeSelect]}),this._oViewSwitch]}),this._getSearchField()],flexContent:[this._oListControl]})]});return o;};G.prototype.setItemFactory=function(k){this.setProperty("itemFactory",k);this._createInnerListControl();return this;};G.prototype.setAllowSelection=function(A){this.setProperty("allowSelection",A);this._oGroupModeSelect.setVisible(A);this._updateTemplate();return this;};G.prototype.setEnableReorder=function(r){this.setProperty("enableReorder",r);this._oReorderList.removeDragDropConfig();return this;};G.prototype.setEnableListView=function(E){this.setProperty("enableListView",E);this._oViewSwitch.setVisible(E);if(E){this._mView[this.LIST_KEY]=this._oReorderList;}else{var o=this._oViewSwitch.getItems()[0];this._oViewSwitch.removeItem(o);this._sView=this.GROUP_KEY;}return this;};G.prototype._getDefaultGroupTemplate=function(){var k=this.getItemFactory();var E=this.getExpandFirstGroup();var l=new a({selectionChange:function(r){var s=r.getParameter("listItem").getBindingContext(this.P13N_MODEL).sPath;var t=this.getP13nModel().getProperty(s);this.fireChange({reason:t.selected?"Add":"Remove",item:t});}.bind(this),showSeparators:"None",mode:this.getAllowSelection()?"MultiSelect":"None",items:{path:this.P13N_MODEL+">items",key:"name",factory:k}});var m=this.P13N_MODEL;var p=new P({expandable:true,expanded:{path:this.P13N_MODEL+">group",formatter:function(){if(this.getBindingContext(m)){var r=E&&(this.getBindingContext(m).sPath.split("/")[2]==="0");return r;}else{return false;}}},width:"100%",headerToolbar:[new T({content:[new L({text:"{"+this.P13N_MODEL+">groupLabel}",design:"Bold"})]})],content:[l]});var n=this.getGrouping();if(!n&&!l.hasStyleClass("sapUiMDCPanelPadding")){l.addStyleClass("sapUiMDCPanelPadding");}else{l.removeStyleClass("sapUiMDCPanelPadding");}var o=n?p:l;var q=new C({visible:"{"+this.P13N_MODEL+">groupVisible}",content:[o]});return q;};G.prototype._updateTemplate=function(){var o=this.getPanelMode()?this._getSimpleLayout():this._getDefaultGroupTemplate();this.setTemplate(o);};G.prototype._getSearchField=function(){var s=B.prototype._getSearchField.apply(this,arguments);s.setPlaceholder(this.getResourceText("p13nDialog.ADAPT_FILTER_SEARCH"));return s;};G.prototype.setGrouping=function(A){this.setProperty("grouping",A);this._updateTemplate();return this;};G.prototype._createInnerListControl=function(){var r=this.getPanelMode();if(!this._oReorderList){this._oReorderList=new j(this._getListControlConfig());this._oReorderList.bPreventMassSelection=true;this._oReorderList.setMode("MultiSelect");this._mView[this.LIST_KEY]=this._oReorderList;}if(!this._oGroupList){this._oGroupList=new a(this._getListControlConfig());this._oGroupList.setMode("None");this._mView[this.GROUP_KEY]=this._oGroupList;}this._oListControl=r?this._oReorderList:this._oGroupList;this._setMoveButtonVisibility(r);this._updateContainer(r);return this._oListControl;};G.prototype.setFooterToolbar=function(o){this.setAggregation("footerToolbar",o);this.getAggregation("_content").setFooter(o.clone());return this;};G.prototype.setGroupExpanded=function(s,E){this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];var k=p.getBindingContext(this.P13N_MODEL).sPath;var l=this.getP13nModel().getProperty(k);if(l.group===s){p.setExpanded(E);}},this);};G.prototype._onGroupModeChange=function(E){this._sModeKey=E.getParameters().selectedItem.getKey();this._filterByModeAndSearch();};G.prototype._togglePanelVisibility=function(p){var o=p.getContent()[0];var s=p.getBindingContext(this.P13N_MODEL).sPath;var k=this.getP13nModel().getProperty(s);k.groupVisible=o.getVisibleItems().length<1?false:true;this.getP13nModel().setProperty(s,k);};G.prototype._onSearchFieldLiveChange=function(E){this._sSearchString=E.getSource().getValue();this._filterByModeAndSearch();};G.prototype._isCustomView=function(){return this._sView!=this.GROUP_KEY&&this._sView!=this.LIST_KEY;};G.prototype._filterByModeAndSearch=function(){var k=[],o;var l;if(this._isCustomView()){return;}if(this._sSearchString){k=[new F("label","Contains",this._sSearchString),new F("tooltip","Contains",this._sSearchString)];l=new F(k,false);}var A=function(){if(l){l=new F([new F(k),o],true);}else{l=o;}};if(this._sModeKey==="visible"){o=new F("selected","EQ",true);A();}if(this._sModeKey==="active"){o=new F("isFiltered","EQ",true);A();}if(this._sModeKey==="visibleactive"){o=o=new F([new F("isFiltered","EQ",true),new F("selected","EQ",true)],true);A();}l=l?l:[];this._getSearchField().setValue(this._sSearchString);if(!this.getPanelMode()){if(this.getGrouping()){this._oListControl.getItems().forEach(function(O){var p=O.getContent()[0];var m=p.getContent()[0];m.getBinding("items").filter(l,true);this._togglePanelVisibility(p);}.bind(this));}}else{this._oListControl.getBinding("items").filter(l,true);}};G.prototype.getSelectedFields=function(){if(!this.getAllowSelection()){return;}var s=[];if(this.getPanelMode()){this._loopItems(this._oListControl,function(o,k){if(o.getSelected()){s.push(k);}});}else{this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];var k=p.getContent()[0];this._loopItems(k,function(l,K){if(l.getSelected()){s.push(K);}});}.bind(this));}return s;};G.prototype._loopItems=function(l,k){l.getItems().forEach(function(o){var p=o.getBindingContextPath();var K=this.getP13nModel().getProperty(p).name;k.call(this,o,K);}.bind(this));};G.prototype.switchListMode=function(){return;};G.prototype._filterBySelected=function(s,l){return;};G.prototype.switchViewMode=function(v){var k=true;if(!this._mView[v]){throw new Error("Please provide either 'Group' or 'List' as view mode or define a custom view via 'addCustomView'");}if(v==this._sView){return;}else{this._sView=v;this._oViewSwitch.setSelectedKey(v);if(this._isCustomView()){k=false;var o=this._createContainer();o.getContent()[0].setFlexContent(this._mView[v]);this.setAggregation("_content",o);}else{var r=this.getPanelMode();if(v==this.LIST_KEY&&r||v==this.GROUP_KEY&&!r){this._createInnerListControl();}else{this._togglePanelMode();}}}this._oGroupModeSelect.setVisible(k&&this.getAllowSelection());};G.prototype.getViewMode=function(){return this._sView;};G.prototype._togglePanelMode=function(){if(this._moveTopButton.getParent()){this._moveTopButton.getParent().removeAllItems();}var r=!this.getPanelMode();this.setPanelMode(r);this._createInnerListControl();this._filterByModeAndSearch();this._getSearchField().setVisible(true);};G.prototype._updateContainer=function(r){if(r){var o=this._createContainer();this.setAggregation("_content",o);this.setPanelColumns([this.getResourceText("p13nDialog.LIST_VIEW_COLUMN"),new g({width:"25%",hAlign:"Center",vAlign:"Middle",header:new f({text:this.getResourceText("p13nDialog.LIST_VIEW_ACTIVE")})})]);}else{this._setInnerLayout();}this._updateTemplate();};G.prototype._getSimpleLayout=function(){this._bDefaultTemplateUsed=true;var p=new d({selected:"{"+this.P13N_MODEL+">selected}",type:"Active",cells:[new L({wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"}),new H({justifyContent:"Center",items:[new e({src:"sap-icon://circle-task-2",size:"0.5rem",color:sap.ui.core.IconColor.Neutral,visible:{path:this.P13N_MODEL+">isFiltered",formatter:function(k){if(k){return true;}else{return false;}}}})]})]});var t=this;if(this.getEnableReorder()){p.attachBrowserEvent("mouseenter",function(E){var o=this.getCells()[1].getItems()[0];o.setVisible(false);t._oSelectedItem=this;t._updateEnableOfMoveButtons(this);});p.attachBrowserEvent("mouseleave",function(E){var v=!!t.getP13nModel().getProperty(this.getBindingContextPath()).isFiltered;var o=this.getCells()[1].getItems()[0];if(t._oSelectedItem){t._oSelectedItem.getCells()[1].removeItem(t._moveTopButton);t._oSelectedItem.getCells()[1].removeItem(t._moveUpButton);t._oSelectedItem.getCells()[1].removeItem(t._moveDownButton);t._oSelectedItem.getCells()[1].removeItem(t._moveBottomButton);}o.setVisible(v);});}return p;};G.prototype._updateEnableOfMoveButtons=function(t){if(!this.getEnableReorder()){return;}B.prototype._updateEnableOfMoveButtons.apply(this,arguments);t.getCells()[1].addItem(this._moveTopButton);t.getCells()[1].addItem(this._moveUpButton);t.getCells()[1].addItem(this._moveDownButton);t.getCells()[1].addItem(this._moveBottomButton);};G.prototype._checkAllPanels=function(){this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];this._togglePanelVisibility(p);}.bind(this));};G.prototype.getPanelMode=function(){if(!this.getEnableListView()){return false;}else{return this.getP13nModel()?this.getP13nModel().getProperty("/reorderMode"):true;}};G.prototype.setP13nModel=function(p){var k=!!this.getP13nModel();B.prototype.setP13nModel.apply(this,arguments);if(!k){this.setPanelMode(true);}if(this.getGrouping()&&!this.getPanelMode()){this._checkAllPanels();}this._bindListItems();var D=this.getDefaultView();if(D){this.switchViewMode(D);}};G.prototype._bindListItems=function(){var r=this.getPanelMode();this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+(r===true?">/items":">/itemsGrouped"),key:"name",templateShareable:false,template:this.getTemplate().clone()}));};G.prototype.exit=function(){Object.keys(this._mView).forEach(function(k){if((this._sView!==k)&&this._mView[k]){this._mView[k].destroy();}}.bind(this));B.prototype.exit.apply(this,arguments);this._oGroupList=null;this._oReorderList=null;this._sSearchString=null;this._oResetBtn=null;this._mView=null;this._sView=null;};return G;});
