/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterProcessor','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','sap/ui/model/TreeAutoExpandMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo','sap/base/util/isEmptyObject','sap/base/util/uid','sap/ui/thirdparty/jquery','sap/base/Log'],function(T,C,F,a,b,c,S,d,f,t,B,A,u,v,Q,L){"use strict";var w="sap.ui.model.analytics.AnalyticalBinding",x=L.getLogger(w);function y(o){var e=new t.QueryResultRequest(o.oAnalyticalQueryResult),g,s,h,i,j,m,n,p,k=o.mParameters.select.split(","),l=E(k,o.sPath);e.setAggregationLevel(o.aMaxAggregationLevel);e.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(q){h=o.oDimensionDetailsSet[q];e.includeDimensionKeyTextAttributes(q,true,h.textPropertyName!==undefined,h.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(M){m=o.oMeasureDetailsSet[M];e.includeMeasureRawFormattedValueUnit(M,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=e.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=k.indexOf(p);if(j<0){x.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath);l=true;}else{k.splice(j,1);}}}for(i=0,n=k.length;i<n;i++){p=k[i];h=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(h&&o.oDimensionDetailsSet[h.getName()]===undefined){D(o.sPath,p,h);l=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){D(o.sPath,p,m);l=true;}}return l?[]:k;}function D(p,s,o){var e=o instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(o.getName()===s){x.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p);}else{x.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+o.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p);}}function E(s,p){var e,g=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){x.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p);s.splice(i,1);g=true;}}return g;}var G=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==d.None){x.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==d.Request||P.countMode==d.Both)){x.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==d.Request){x.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){x.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});function H(o,e){return function(){if(!o.__supportUID){o.__supportUID=v();}return{type:w,analyticalError:e,analyticalBindingId:o.__supportUID};};}G.prototype.setContext=function(o){var r;if(this.oContext!==o){this.oContext=o;if(!this.isRelative()){return;}this.oDataState=null;this.bApplySortersToGroups=true;this.iTotalSize=-1;this._abortAllPendingRequests();r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}else{this.bInitial=true;}}};G.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};G.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};G.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(G._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(G._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){x.fatal("assertion failed: grand total represented by a single entry");}return r;};G.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,e,n,g;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;e=p.level;n=p.numberOfExpandedLevels;g=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];e=arguments[4];n=arguments[5];g=arguments[6];}var h=this._getContextsForParentContext(o,s,l,i,e,n,g);return h;};G.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};G.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return G.prototype.ContextsAvailabilityStatus.ALL;}else{return G.prototype.ContextsAvailabilityStatus.SOME;}}else{return G.prototype.ContextsAvailabilityStatus.NONE;}};G.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};G.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){x.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};G.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1;};G.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};G.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};G.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};G.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};G.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};G.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};G.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};G.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};G.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};G.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};G.prototype.isMeasure=function(p){return this.aMeasureName&&this.aMeasureName.indexOf(p)!==-1;};G.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==c.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:C.Filter});return this;};G.prototype.getFilterInfo=function(i){var o=b.combineFilters(this.aControlFilter,this.aApplicationFilter);if(o){return o.getAST(i);}return null;};G.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};G.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],e=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),s,h,i,j,k,m,n,q;if(e&&this.oDimensionDetailsSet[g].textPropertyName){k=e.getTextProperty();}if(k){m=k.name;q=this.mAnalyticalInfoByProperty[m]&&this.mAnalyticalInfoByProperty[m].formatter;n=o.getProperty(m);s=V?V(p,n):p;h=q?q(n,p):n;}else{s=V?V(p):p;}j=e.getLabelText&&e.getLabelText();i=(j?j+': ':'')+s;if(h){i+=' - '+h;}return i;};G.prototype.updateAnalyticalInfo=function(e,g){var h,o,k,l,m=this;function n(N){var O=N.level,R=N.name;l=l||k.getAllHierarchyPropertyNames();l.forEach(function(V){var W=m.oAnalyticalQueryResult.findDimensionByPropertyName(V).getHierarchy(),X=null,Y=W.getNodeIDProperty().name,Z;if(Y===R){X=p(W);}else{Z=W.getNodeExternalKeyProperty();if(Z&&Z.name===R){X=p(W);X.nodeExternalKeyName=R;}else{Z=k.getTextPropertyOfProperty(Y);if(Z&&Z.name===R){X=p(W);X.nodeTextName=R;}}}if(X&&"level"in N){if(typeof O==="number"){if("level"in X&&X.level!==O){throw new Error("Multiple different level filter for hierarchy '"+Y+"' defined");}X.level=O;X.grouped=!!N.grouped;}else{throw new Error("The level of '"+Y+"' has to be an integer value");}}});}function p(N){var O=N.getNodeIDProperty().name,R,V=m.mHierarchyDetailsByName[O];if(!V){R=N.getNodeLevelProperty();V={dimensionName:N.getNodeValueProperty().name,nodeIDName:O,nodeLevelName:R&&R.name};m.mHierarchyDetailsByName[O]=V;}return V;}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}h=t.helper.deepEqual(this._aLastChangedAnalyticalInfo,e,function(N){m.mAnalyticalInfoByProperty[N.name].formatter=N.formatter;});if(h){this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}}if(h<2){if(g||h){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}var P=this.oDimensionDetailsSet||{},q=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};k=this.oAnalyticalQueryResult.getEntityType();for(var i=0;i<e.length;i++){var r=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(r&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=r.getName();o=this.oDimensionDetailsSet[r.getName()];if(!o){o={};o.name=r.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[r.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(!this.getSortablePropertyNames()||this.getSortablePropertyNames().indexOf(r.getName())==-1){x.fatal("property "+r.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(r.getName()==e[i].name){o.keyPropertyName=e[i].name;}var s=r.getTextProperty();if(s&&s.name==e[i].name){o.textPropertyName=e[i].name;}if(r.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var M=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(M&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=M.getName();var z=this.oMeasureDetailsSet[M.getName()];if(!z){z={};z.name=M.getName();this.oMeasureDetailsSet[M.getName()]=z;this.aMeasureName.push(z.name);}if(M.getRawValueProperty().name==e[i].name){z.rawValuePropertyName=e[i].name;}var I=M.getFormattedValueProperty();if(I&&I.name==e[i].name){z.formattedValuePropertyName=e[i].name;}z.analyticalInfo=e[i];}if(!r&&!M){n(e[i]);}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}Object.keys(this.mHierarchyDetailsByName).forEach(function(N){var O=m.mHierarchyDetailsByName[N];if(!("level"in O)){delete m.mHierarchyDetailsByName[N];if(x.isLoggable(L.Level.INFO)){x.info("No level specified for hierarchy node '"+N+"'; ignoring hierarchy","");}}else if(!m.oDimensionDetailsSet[N]){m.oDimensionDetailsSet[N]={aAttributeName:[],grouped:O.grouped,isHierarchyDimension:true,name:N};m.aMaxAggregationLevel.push(N);if(O.grouped){m.aAggregationLevel.push(N);}}});for(var J in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(J).getUnitProperty();if(U){this.oMeasureDetailsSet[J].unitPropertyName=U.name;}}var K=Object.keys(P).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(K){this.iTotalSize=-1;}if(K||Object.keys(q).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=y(this);}if(g){this._fireChange({reason:C.Change});}};G.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};G.prototype.loadGroups=function(g){var e=[];for(var s in g){e.push(s);this._resetData(s);var h=g[s];for(var i=0;i<h.length;i++){var o=h[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,k;(k=e[++j])!==undefined;){r.push(this._getRequestId(G._requestType.groupMembersQuery,{groupId:k}));}this._considerRequestGrouping(r);}};G.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};G._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};G._artificialRootContextGroupId="artificialRootContext";G._addHierarchyLevelFilters=function(e,o){e.forEach(function(g){o.removeConditions(g.propertyName);o.addCondition(g.propertyName,a.EQ,g.level);});};G.prototype._getContextsForParentContext=function(p,s,l,i,e,n,g){if(p===undefined){return[];}if(p&&p.getPath()=="/"+G._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,e);return this._getContextsForParentGroupId(P,s,l,i,n,g);};G.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){x.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){x.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){x.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],k,o,m,q;var r=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[r]){this.aMultiUnitLoadFactor[r]=1;}var z=n>0&&p!=null;if(z){var M=this._getGroupIdLevel(p);var I=M+n;var J=true;if(!g){m=this._calculateRequiredGroupExpansion(p,I,s,l+e);J=m.groupId_Missing==null;J=J||m.groupId_Missing.length<p.length||m.groupId_Missing.substring(0,p.length)!=p;}if(J){h=this._getLoadedContextsForGroup(p,s,l);}else{q=l+e;}k=!J;q=Math.ceil(q*this.aMultiUnitLoadFactor[r]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);k=false;if(!g){if(this._oWatermark&&p===this._oWatermark.groupID){e=10000;}o=this._calculateRequiredGroupSection(p,s,l,e);var P=o.length>0&&l<o.length;k=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;o.length=Math.ceil(o.length*this.aMultiUnitLoadFactor[r]);}}if(!k){this._cleanupGroupingForCompletedRequest(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));}var K=false;if(this.oModel.getServiceMetadata()){if(k){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(G._requestType.totalSizeQuery));K=true;var O;if(this.bUseBatchRequests){if(z){O=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=O[++i])!==undefined;){if(this._isRequestPending(R)){K=false;break;}}if(K){this.aBatchRequestQueue.push([G._requestType.groupMembersAutoExpansionQuery,p,m,q,n]);}}else{K=o.length&&!this._isRequestPending(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));if(K){this.aBatchRequestQueue.push([G._requestType.groupMembersQuery,p,o.startIndex,o.length]);O=[this._getRequestId(G._requestType.groupMembersQuery,{groupId:p})];}}if(K&&N){O.push(this._getRequestId(G._requestType.totalSizeQuery));this._considerRequestGrouping(O);this.aBatchRequestQueue.push([G._requestType.totalSizeQuery]);}if(K){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(G.prototype._processRequestQueue.bind(this));}}else{var U;if(z){O=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,V;(V=O[++j])!==undefined;){if(this._isRequestPending(V)){K=false;break;}}if(K){U=this._prepareGroupMembersAutoExpansionQueryRequest(G._requestType.groupMembersAutoExpansionQuery,p,m,q,n);}}else{K=o.length&&!this._isRequestPending(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));if(K){U=this._prepareGroupMembersQueryRequest(G._requestType.groupMembersQuery,p,o.startIndex,o.length);O=[U.sRequestId];}}if(K){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(U);if(N&&!U.bIsFlatListRequest){O.push(this._getRequestId(G._requestType.totalSizeQuery));this._considerRequestGrouping(O);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(G._requestType.totalSizeQuery));}}}}}return h;};G.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(o,g){var h,e=[],i=this;if(g===null){return e;}h=Object.keys(this.mHierarchyDetailsByName);if(h.length>0&&g!=="/"){x.error("Hierarchy cannot be requested for members of a group",g);return e;}h.forEach(function(s){var j=i.mHierarchyDetailsByName[s];o.addRecursiveHierarchy(j.dimensionName,!!j.nodeExternalKeyName,!!j.nodeTextName);e.push({propertyName:j.nodeLevelName,level:j.level});});return e;};G.prototype._getNonHierarchyDimensions=function(e){var g=this;return e.filter(function(s){return!g.oDimensionDetailsSet[s].isHierarchyDimension;});};G.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==G._requestType.groupMembersQuery){o=G.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case G._requestType.groupMembersQuery:continue;case G._requestType.totalSizeQuery:if(!e){o=G.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case G._requestType.groupMembersAutoExpansionQuery:o=G.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case G._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:x.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};G.prototype._prepareGroupMembersQueryRequest=function(r,g,s,e){var h=[],m=[],o;var p=new t.QueryResultRequest(this.oAnalyticalQueryResult);p.setResourcePath(this._getResourcePath());p.getSortExpression().clear();var q=0,z=-1;if(g){h=this._getGroupIdComponents(g);q=z=h.length;var U=0;for(var j=0,I=0;j<q;I++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[I]].grouped==false){++U;}else{++j;}}q=z=q+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[z]].grouped==false){if(++z==this.aMaxAggregationLevel.length){break;}}}}var J=z>=this.aMaxAggregationLevel.length-1;o=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(p,g);var K=this.aMaxAggregationLevel.slice(0,z+1);var M=this._getNonHierarchyDimensions(K);p.setAggregationLevel(M);for(var i=0;i<M.length;i++){var N=this.oDimensionDetailsSet[M[i]];var O=(N.textPropertyName!=undefined);p.includeDimensionKeyTextAttributes(N.name,true,O,N.aAttributeName);if(N.grouped){m.push({sPath:M[i],bDescending:false});}}var P=p.getFilterExpression();P.clear();if(this.aApplicationFilter){P.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){P.addUI5FilterConditions(this.aControlFilter);}if(q>=1){for(var k=0,l=h.length;k<l;k++){P.removeConditions(this.aAggregationLevel[k]);P.addCondition(this.aAggregationLevel[k],a.EQ,h[k]);}}G._addHierarchyLevelFilters(o,P);var R;var V;var W;var X;var Y=[];if(g!=null||this.bProvideGrandTotals||(this._canApplySortersToGroups()&&this.aSorter.length>0)){p.setMeasures(this.aMeasureName);for(var Z in this.oMeasureDetailsSet){X=this.oMeasureDetailsSet[Z];if(!J&&this.mAnalyticalInfoByProperty[Z].total==false){R=false;V=false;W=false;}else{R=(X.rawValuePropertyName!=undefined);V=(X.formattedValuePropertyName!=undefined);W=(X.unitPropertyName!=undefined);if(W){if(Y.indexOf(X.unitPropertyName)==-1){Y.push(X.unitPropertyName);}}}p.includeMeasureRawFormattedValueUnit(X.name,R,V,W);}for(var n in M){var $;if(($=Y.indexOf(M[n]))!=-1){Y.splice($,1);}}}if(g){this._addSorters(p.getSortExpression(),m);}if(e==0){x.fatal("unhandled case: load 0 entities of sub group");}var _=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){p.setResultPageBoundaries(_.iServiceKeyIndex+1,_.iServiceKeyIndex+e);}p.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:p,sGroupId:g,aSelectedUnitPropertyName:Y,aAggregationLevel:K,bIsFlatListRequest:J&&q==0,bIsLeafGroupsRequest:J,iStartIndex:s,iLength:e,oKeyIndexMapping:_};};G.prototype._prepareTotalSizeQueryRequest=function(r){var h;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,"/");o.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}G._addHierarchyLevelFilters(h,e);o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};G.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,o,e,n){var h=this;var p=function(o,s){var J=[];if(o.groupId_Missing==null){x.fatal("missing group Id not present");return J;}var z=h._getGroupIdComponents(o.groupId_Missing);var I=z.length;if(I>s){x.fatal("the given group ID is too deep for requested level for auto expansion");return J;}var k=[];for(var i=0;i<I;i++){var l=h.aAggregationLevel[i];var Z=z[i];var $=h._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,$,Z);}var _=null;if(o.startIndex_Missing>0){var a1=h._getKey(o.groupId_Missing,o.startIndex_Missing-1);var b1=h.oModel.getObject("/"+a1);var c1=h.aAggregationLevel[I];var d1=b1[c1];_=new F(c1,h._getFilterOperatorMatchingPropertySortOrder(c1,false),d1);}for(var M=0;M<s;M++){var e1=[];var f1=Math.min(I,M+1);for(var g1=0;g1<f1;g1++){var h1=[];var i1=Math.min(I,g1+1);var j1=o.startIndex_Missing>0;for(var k1=0;k1<i1;k1++){var l1=new F("x",a.EQ,"x");l1=Q.extend(true,l1,k[k1]);if(i1>1&&k1<i1-1){l1.sOperator=a.EQ;}if(k1==I-1&&M>I-1&&!j1){if(l1.sOperator==a.GT){l1.sOperator=a.GE;}else{l1.sOperator=a.LE;}}h1.push(l1);}if(h1.length>0){e1.push(new F(h1,true));if(M>I-1&&g1==I-1&&j1){var m1=[];for(var j=0;j<h1.length;j++){var n1=new F("x",a.EQ,"x");n1=Q.extend(true,n1,h1[j]);m1.push(n1);}m1[I-1].sOperator=a.EQ;m1.push(_);e1.push(new F(m1,true));break;}}}if(e1.length>0){J[M]=new F(e1,false);}else{J[M]=null;}}return J;};var m=function(r,g,M,Z,N,e,$,_){var a1;var b1=new t.QueryResultRequest(h.oAnalyticalQueryResult);b1.setResourcePath(h._getResourcePath());b1.getSortExpression().clear();var c1=0,d1=-1;c1=d1=M-1;var e1=0;for(var i=0,f1=0;i<c1;f1++){if(h.oDimensionDetailsSet[h.aMaxAggregationLevel[f1]].grouped==false){++e1;}else{++i;}}c1=d1=c1+e1;if(h.aMaxAggregationLevel.length>0){while(h.aMaxAggregationLevel[d1]&&h.oDimensionDetailsSet[h.aMaxAggregationLevel[d1]].grouped==false){if(++d1==h.aMaxAggregationLevel.length){break;}}}var g1=d1>=h.aMaxAggregationLevel.length-1;a1=h._getHierarchyLevelFiltersAndAddRecursiveHierarchy(b1,g);var h1=h.aMaxAggregationLevel.slice(0,d1+1);b1.setAggregationLevel(h1);for(var l=0;l<h1.length;l++){var i1=h.oDimensionDetailsSet[h1[l]];var j1=(i1.textPropertyName!=undefined);b1.includeDimensionKeyTextAttributes(i1.name,true,j1,i1.aAttributeName);if(i1.grouped){b1.getSortExpression().addSorter(h1[l],t.SortOrder.Ascending);}}var k1=b1.getFilterExpression();k1.clear();if(h.aApplicationFilter){k1.addUI5FilterConditions(h.aApplicationFilter);}if(h.aControlFilter){k1.addUI5FilterConditions(h.aControlFilter);}if(Z){k1.addUI5FilterConditions([Z]);}G._addHierarchyLevelFilters(a1,k1);var l1;var m1;var n1;var o1;var p1=[];b1.setMeasures(h.aMeasureName);for(var q1 in h.oMeasureDetailsSet){o1=h.oMeasureDetailsSet[q1];if(!g1&&h.mAnalyticalInfoByProperty[q1].total==false){l1=false;m1=false;n1=false;}else{l1=(o1.rawValuePropertyName!=undefined);m1=(o1.formattedValuePropertyName!=undefined);n1=(o1.unitPropertyName!=undefined);if(n1){if(p1.indexOf(o1.unitPropertyName)==-1){p1.push(o1.unitPropertyName);}}}b1.includeMeasureRawFormattedValueUnit(o1.name,l1,m1,n1);}for(var j in h1){var r1;if((r1=p1.indexOf(h1[j]))!=-1){p1.splice(r1,1);}}var s1=b1.getSortExpression();for(var k=0;k<h.aSorter.length;k++){if(h.aSorter[k]){s1.addSorter(h.aSorter[k].sPath,h.aSorter[k].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);}}if(e==0){x.fatal("unhandled case: load 0 entities of sub group");}var t1=N;if(!_){t1=0;}else{var u1=0;for(var v1 in h.mServiceKey){if(v1.split("/").length===M+1){u1+=h.mServiceKey[v1].length;}}t1=Math.max(t1,u1);}if(!h.bNoPaging){b1.setResultPageBoundaries(t1+1,t1+e);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:b1,iLevel:M,aSelectedUnitPropertyName:p1,aAggregationLevel:h1,bIsFlatListRequest:g1,bIsLeafGroupsRequest:g1,iStartIndex:N,iLength:e,bAvoidLengthUpdate:$};};var q=[];var R=[];if(!o){x.fatal("no first missing group member specified");}var s=this._getGroupIdLevel(g)+n+1;var z=h._getGroupIdComponents(o.groupId_Missing);var I=z.length;var J=p(o,s);var K;for(var M=1;M<=s;M++){var N;if(M>=I+2){N=0;K=undefined;}else if(M==I+1){N=o.startIndex_Missing;K=o.groupId_Missing;}else if(I>0){if(M==I){K=o.groupId_Missing;}else{K=this._getGroupIdAncestors(o.groupId_Missing,-(I-M))[0];}var O=this._getGroupIdAncestors(o.groupId_Missing,-(I-M+1))[0];if(!O){x.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+M);}N=this._findKeyIndex(O,this.mEntityKey[K]);if(N==-1){x.fatal("failed to determine position of value "+K+" in group "+O);}K=O;N++;}var P=e>M?Math.ceil((e-M)/(s-M+1)):e;var U=J[M-1];if(this.bUseAcceleratedAutoExpand){var V=m(G._requestType.levelMembersQuery,g,M,U,N,P,false,U==null?true:false);V.sGroupId_Missing_AtLevel=K;V.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:M});q.push(V);R.push(V.sRequestId);}else if(U&&U.aFilters.length>0){if(!U._bMultiFilter||U.bAnd){x.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<U.aFilters.length;i++){var W=U.aFilters[i];var X=m(G._requestType.levelMembersQuery,g,M,W,N,P,false,U==null?true:false);X.sGroupId_Missing_AtLevel=K;X.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:M,tupleIndex:i});q.push(X);R.push(X.sRequestId);}}else{var Y=m(G._requestType.levelMembersQuery,g,M,null,N,P,false,U==null?true:false);Y.sGroupId_Missing_AtLevel=K;Y.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:M});q.push(Y);R.push(Y.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:q,sGroupId:g,iLength:e};};G.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var z in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[z];if(!m.aReloadMeasurePropertyName||m.aReloadMeasurePropertyName.indexOf(M.name)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[z].total==false){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(s.indexOf(M.unitPropertyName)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var J;if((J=s.indexOf(e[j]))!=-1){s.splice(J,1);}}return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};G.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};G.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){x.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var j=o.getURIQueryOptionValue("$skip");var k=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){if(h===null){h=this.mParameters["filter"];}else{h+="and ("+this.mParameters["filter"]+")";}}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(O!==null){P.push("$orderby="+O);}if(j!==null){P.push("$skip="+j);}if(k!==null){P.push("$top="+k);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};G.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],l=[];function m(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function n(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var p=0;p<r.length;p++){var q=r[p];if(q.aAggregationLevel&&q.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,z;(z=r[++i])!==undefined;){var I=z.oAnalyticalQueryRequest,J=z.sGroupId;if(I.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});J=null;this.mServiceLength[J]=this.mLength[J]=1;this.mServiceFinalLength[J]=true;this._setServiceKey(this._getKeyIndexMapping(J,0),G._artificialRootContextGroupId);setTimeout(m);this.bArtificalRootContext=true;continue;}var P=I.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(z.sRequestId)){this._registerNewRequest(z.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(I,z.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var K=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:n,context:this.oContext,urlParameters:U});h.push(K);}l.push(z);}}if(h.length>0){x.debug("AnalyticalBinding: executing batch request with "+l.length+" operations");var M;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);M=this.oModel.submitBatch(N,O,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{M={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:l,binding:this,success:N,error:O});}this._registerNewRequestHandle(R,M);}function N(V,W){g._deregisterHandleOfCompletedRequest(R);if(l.length!=V.__batchResponses.length){x.fatal("assertion failed: received "+V.__batchResponses.length+" responses for "+l.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<l.length;j++){var X=l[j].sRequestId;if(X!==undefined){g._deregisterCompletedRequest(X);g._cleanupGroupingForCompletedRequest(X);}}g.fireDataReceived({data:[]});return;}var Y=0;for(var k=0;k<V.__batchResponses.length;k++){if(V.__batchResponses[k].data!=undefined){if(V.__batchResponses[k].data.results.length==0){Y++;}switch(l[k].iRequestType){case G._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(l[k],V.__batchResponses[k].data);break;case G._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(l[k],V.__batchResponses[k].data);break;case G._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(l[k],V.__batchResponses[k].data);break;case G._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(l[k],V.__batchResponses[k].data);break;default:x.fatal("invalid request type "+l[k].iRequestType);continue;}}g._deregisterCompletedRequest(l[k].sRequestId);g._cleanupGroupingForCompletedRequest(l[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(Y==V.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var Z=true;var $;g.fireDataReceived({data:V});var _={};if(g.iModelVersion===A.V1){$=g.oModel._getBatchErrors(V);if($.length>0){Z=false;_=g.oModel._handleError($[0]);}g.oModel.fireRequestCompleted({url:W.requestUri,type:"POST",async:true,info:"",infoObject:{},success:Z,errorobject:Z?{}:_});if(Z){g.oModel.checkUpdate();}}}function O(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,V;(V=l[++j])!==undefined;){g._deregisterCompletedRequest(V.sRequestId);g._cleanupGroupingForCompletedRequest(V.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var W=k;if(g.iModelVersion===A.V1){W=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:W});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(W);}g.fireDataReceived();}};G.prototype._executeQueryRequest=function(r){if(r.iRequestType==G._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,s=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});s=null;this.mServiceLength[s]=this.mLength[s]=1;this.mServiceFinalLength[s]=true;this._setServiceKey(this._getKeyIndexMapping(s,0),G._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}x.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,l,n,false,U,m);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p.replace(/ /g,"%20"),{success:l,error:n,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function l(q){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case G._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,q);break;case G._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,q);break;case G._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,q);break;case G._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,q);break;default:x.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){m(q);}}function m(q){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:q});}}function n(q){if(q&&q.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};G.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};G.prototype._processGroupMembersQueryResponse=function(R,e){var s,n=R.sGroupId,z=this.aSorter.length>0,I=R.aSelectedUnitPropertyName,J=R.aAggregationLevel,K=R.oKeyIndexMapping.iIndex,M=R.oKeyIndexMapping.iServiceKeyIndex,N=R.iLength,O=R.oKeyIndexMapping,P=n==null?0:this._getGroupIdLevel(n)+1,U=(I.length>0),V,W,X,Y=0,Z,$,_=[];var a1=e.results.length;if(n===null&&a1>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(z?"binding is refreshed":undefined);if(z){setTimeout(this.refresh.bind(this),0);return;}}var b1=this._getServiceKeys(n,O.iIndex-1);V=undefined;if(b1&&b1.length>0){for(var i=0,c1=b1.length;i<c1;i++){e.results[i-c1]=this.oModel.getObject("/"+b1[i]);}var d1=e.results[-b1.length];V="";for(var j=0;j<J.length;j++){V+=d1[J[j]]+"|";}}Z=b1&&b1.length==1;for(var h=0;h<a1;h++){var e1=e.results[h];if(U){W="";for(var g=0;g<J.length;g++){W+=e1[J[g]]+"|";}if(V==W){this._warnNoSortingOfGroups();if(X===undefined){if(h==0){X=-b1.length;O.iServiceKeyIndex-=b1.length-1;}else{X=h-1;}}var f1=-1,g1=e.results[h-1];for(var k=0;k<I.length;k++){if(g1[I[k]]!=e1[I[k]]){f1=k;break;}}if(f1==-1){x.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,H(this,"NO_DEVIATING_UNITS"));}}if((V!=W||h==a1-1)&&X!==undefined){var h1=[];for(var l=X;l<h;l++){h1.push(e.results[l]);}if(V==W){h1.push(e.results[h]);}var i1=[];for(var m=0;m<I.length;m++){var j1=I[m];for(var o=1;o<h1.length;o++){if(h1[o-1][j1]!=h1[o][j1]){i1.push(j1);break;}}}var k1=this._createMultiUnitRepresentativeEntry(n,e.results[X],I,i1,R.bIsFlatListRequest);if(k1.aReloadMeasurePropertyName.length>0){$=this._prepareReloadMeasurePropertiesQueryRequest(G._requestType.reloadMeasuresQuery,R,k1);if($.oAnalyticalQueryRequest&&$.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){_.push($);}}var l1=this._setAdjacentMultiUnitKeys(O,k1,h1);var m1;if(k1.bIsNewEntry){m1=h1.length-1;}else{m1=l1;}if(Z){Z=false;}if(m1<0){x.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}Y+=m1;var n1=this.oModel._getKey(k1.oEntry);var o1=this.oModel.getContext('/'+n1);this._getGroupIdFromContext(o1,P);this.mEntityKey[s]=n1;X=undefined;if(V!=W){Z=this._setServiceKey(O,this.oModel._getKey(e1));}}else if(V!=W){Z=this._setServiceKey(O,this.oModel._getKey(e1));}V=W;}else{this._setServiceKey(O,this.oModel._getKey(e1));}if(!R.bIsLeafGroupsRequest){var p1=this._getKey(n,O.iIndex-1);s=this._getGroupIdFromContext(this.oModel.getContext('/'+p1),P);this.mEntityKey[s]=p1;}}var q1=[];if(this.bReloadSingleUnitMeasures&&_.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([G._requestType.reloadMeasuresQuery,_]);Promise.resolve().then(G.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<_.length;q++){var r1=_[q];this._executeQueryRequest(r1);}}for(var p=0;p<_.length;p++){var s1=_[p];q1.push(s1.sRequestId);}this._considerRequestGrouping(q1);}if(b1&&b1.length>0){for(var r=0,t1=b1.length;r<t1;r++){delete e.results[r-t1];}}if(U){Y+=this._mergeLoadedKeyIndexWithSubsequentIndexes(O,J,I,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var u1=false;if(e.__count){this.mServiceLength[n]=parseInt(e.__count);this.mLength[n]=this.mServiceLength[n]-Y;this.mFinalLength[n]=true;if(R.bIsFlatListRequest){this.iTotalSize=e.__count;}u1=true;}if(!(n in this.mServiceLength)||this.mServiceLength[n]<M+a1){this.mServiceLength[n]=M+a1;this.mLength[n]=K+a1-Y;this.mFinalLength[n]=false;}if(a1<N||N===undefined){this.mServiceLength[n]=M+a1;this.mLength[n]=K+O.iIndex-K;this.mFinalLength[n]=true;u1=true;}if(a1==0){this.mLength[n]=this.mServiceLength[n]=0;this.mFinalLength[n]=true;u1=true;}if(!u1&&this.mLength[n]!==undefined&&Y>0){this.mLength[n]-=Y;}}this.bNeedsUpdate=true;if(Y>0){if(e.results.length-Y>0){this.aMultiUnitLoadFactor[J.length]=e.results.length/(e.results.length-Y);}if(this.aMultiUnitLoadFactor[J.length]<1.5){this.aMultiUnitLoadFactor[J.length]=2;}}x.info("MultiUnit Situation in Group ("+n+"), discarded: "+Y+", load-factor is now: "+this.aMultiUnitLoadFactor[J.length]);};G.prototype._processTotalSizeQueryResponse=function(r,o){if(o.__count==undefined){x.fatal("missing entity count in query result");return;}this.iTotalSize=o.__count;};G.prototype._processLevelMembersQueryResponse=function(r,o){var e=this;var p,P;var g=function(h,I){var l={iRequestType:G._requestType.groupMembersQuery,sRequestId:e._getRequestId(G._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=l.sGroupId||e._getKeys(l.sGroupId)===undefined)){var s=e._getParentGroupId(l.sGroupId);var m=e._findKeyIndex(s,e.mEntityKey[l.sGroupId]);if(m<0){x.fatal("assertion failed: failed to determine position of "+l.sGroupId+" in group "+s);}else if(!m){e.mFinalLength[r.sGroupId_Missing_AtLevel]=true;}else if(e._getKey(s,m-1)!==undefined){var n=e._getKey(s,m-1);var q=e._getGroupIdFromContext(e.oModel.getContext('/'+n),e._getGroupIdLevel(l.sGroupId));e.mFinalLength[q]=true;l.iStartIndex=0;}}if(I){l.iLength=P.length;}l.oKeyIndexMapping=e._getKeyIndexMapping(l.sGroupId,l.iStartIndex);var z=Q.extend(true,{},o);z.results=P;e._processGroupMembersQueryResponse(l,z);};if(o.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(o.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<o.results.length;i++){var j=o.results[i];var k=this.oModel.getContext("/"+this.oModel._getKey(o.results[i]));var s=this._getGroupIdFromContext(k,r.iLevel-1);if(p==s){P.push(j);if(i<o.results.length-1){continue;}}g(h,o.results.length==r.iLength&&i==o.results.length-1);h=false;if(p!=s){P=[j];}p=s;}if(o.results.length>1&&P.length==1){g(h,o.results.length==r.iLength);}};G.prototype._processReloadMeasurePropertiesQueryResponse=function(r,o){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(o.results.length!=1){x.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=o.results[0];var e=this.oModel.getObject("/"+M);if(!e){x.fatal("assertion failed: no entity found with key "+M);return;}var g=m.aReloadMeasurePropertyName;for(var i=0;i<g.length;i++){e[g[i]]=R[g[i]];}};G.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};G.prototype._calculateRequiredGroupSection=function(g,s,l,i){var e=this._getKeys(g);if(s>=i){s-=i;l+=i;}else{l+=s;s=0;}l+=i;if(this.mFinalLength[g]&&s+l>this.mLength[g]){l=this.mLength[g]-s;}if(e){while(l&&e(s)){s+=1;l-=1;}while(l&&e(s+l-1)){l-=1;}}return{startIndex:s,length:l};};G.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var k=h._getGroupIdLevel(g);if(k==e){var I=h._getLoadedContextsForGroup(g,s,l);var J=s+I.length-1;if(I.length>=l){return n;}else if(h.mFinalLength[g]){if(I.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-I.length};}else{return{groupId_Missing:g,startIndex_Missing:J+1,length_Missing:l-I.length};}}else{return{groupId_Missing:g,startIndex_Missing:J+1,length_Missing:l-I.length};}}var K=h._getLoadedContextsForGroup(g,s,l);var m=l,M=s+K.length-1;for(var i=-1,N;(N=K[++i])!==undefined;){m--;var p=j(h._getGroupIdFromContext(N,k+1),e,0,m);if(p.groupId_Missing==null){if(p.length_Missing==0){return p;}else{m=p.length_Missing;}}else{return p;}if(m==0){break;}}if(h.mFinalLength[g]||m==0){return{groupId_Missing:null,length_Missing:m};}else{return{groupId_Missing:g,startIndex_Missing:M+1,length_Missing:m};}};var k=this._getGroupIdLevel(g);if(k==e+1){g=this._getParentGroupId(g);--k;}if(g==null||k>e){return n;}var m=l,o=s;while(g!=null){var p=j(g,e,o,m);if(p.groupId_Missing!=null){return p;}else if(p.length_Missing==0){return p;}else{var q=false;while(!q){var P=this._getParentGroupId(g);if(P==null){g=P;--k;break;}var r=this.mEntityKey[g];if(!r){return n;}var z=this._findKeyIndex(P,r);if(z==-1){return n;}if(z==this._getKeyCount(P)-1){if(this.mFinalLength[P]){g=P;--k;continue;}else{return{groupId_Missing:P,startIndex_Missing:z+1,length_Missing:m};}}else{r=this._getKey(P,z+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+r),k);q=true;}}o=0;m=p.length_Missing;}}return{groupId_Missing:null,length_Missing:m};};G.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};G.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};G.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending;}}return null;};G.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case t.SortOrder.Ascending:if(W){s=a.GE;}else{s=a.GT;}break;case t.SortOrder.Descending:if(W){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};G.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};G.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var s=null;if(l>this.aAggregationLevel.length){x.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){s=o.getProperty(this.aAggregationLevel[i]);if(s!=null){if(s.__edmType==="Edm.Time"){s=s.ms;}g+=encodeURIComponent(s)+"/";}else{g+="@/";}}return g;};G.prototype._getGroupIdLevel=function(g){if(g==null){x.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};G.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var e=g.split("/");var h=[];for(var i=1;i<e.length-1;i++){if(e[i]=="@"){h[i-1]=null;}else{h[i-1]=decodeURIComponent(e[i]);}}return h;};G.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){x.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{x.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var e=g.split("/");var h=[],s="";var k=0,l=e.length-3;if(n>0){if(n-1>l){x.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{l=n-1;}}else if(-(n+1)>l){x.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=l+1+n;for(var i=0;i<k;i++){s+=e[i]+"/";}}for(var j=k;j<=l;j++){s+=e[j]+"/";h.push(s);}return h;};G.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};G.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};G.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};G.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){x.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};G.prototype._deregisterHandleOfCompletedRequest=function(r){if(u(this.oPendingRequestHandle)){x.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){x.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};G.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};G.prototype._getRequestId=function(r,p){switch(r){case G._requestType.groupMembersQuery:if(p.groupId===undefined){x.fatal("missing group ID");}return G._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case G._requestType.levelMembersQuery:if(p.level===undefined){x.fatal("missing level");}if(p.groupId===undefined){x.fatal("missing groupId");}return""+G._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case G._requestType.totalSizeQuery:return G._requestType.totalSizeQuery;case G._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){x.fatal("missing multi unit entry key");}return G._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:x.fatal("invalid request type "+r);return-1;}};G.prototype._registerNewRequest=function(r){if(r==undefined||r==""){x.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};G.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};G.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};G.prototype._deregisterCompletedRequest=function(r){if(u(this.oPendingRequests)){x.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){x.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};G.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};G.prototype._getKeyIndexMapping=function(g,s){var i,l,e,k=this.mKeyIndex[g],K={sGroupId:g,iIndex:s,iServiceKeyIndex:s},h=this.mServiceKey[g];if(k!==undefined){if(k[s]!==undefined){K.iServiceKeyIndex=k[s]==="ZERO"?0:Math.abs(k[s]);return K;}l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}if(l==0){e=0;}else{if(k[l]>=0){e=k[l];}else if(k[l+1]===undefined){e=-k[l];while(h[e+1]!==undefined){++e;}}else{e=Math.abs(k[l+1])-1;}if(h[e]===undefined){x.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+e);}}i=s-l;K.iServiceKeyIndex=e+i;}return K;};G.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};G.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){x.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){x.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};G.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};G.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var h=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){h.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){h.push(s[i]);}}return h;};G.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};G.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0||K[i]==="ZERO"){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};G.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};G.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};G.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],h=0,n=k.iServiceKeyIndex,j=k.iIndex;var M,o;if(K===undefined){return h;}var N=false;var p=g[n-1],l=g[n];if(l===undefined){return h;}if(p===undefined){x.fatal("assertion failed: missing expected entry before given key index");return h;}var P=this.oModel.getObject("/"+p);var q=this.oModel.getObject("/"+l);var r="",z="";for(var i=0;i<e.length;i++){r+=P[e[i]]+"|";z+=q[e[i]]+"|";}N=r==z;var J=j;if(J>=this.mLength[k.sGroupId]){x.fatal("assertion failed: service key exists,but no corresponding key index found");return h;}while(K[J]===undefined||Math.abs(K[J])<n){++J;}if(N){if(Math.abs(K[J])==n&&K[J]<0){if(J>j){if(K[j-1]<0){m[J]=undefined;K.splice(j,J-j+1);m.splice(j,J-j+1);}else{K[j-1]=-K[j-1];m[j-1]=m[J];m[J]=undefined;K.splice(j,J-j+1);m.splice(j,J-j+1);h=1;}}}else if(Math.abs(K[J])>n){var O=J-1;if(K[O]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[O]=-K[O];m[O]=o;if(O>j){K.splice(j,O-j);m.splice(j,O-j);}if(M.bIsNewEntry){h=1;}else{h=0;}}else if(K[j-1]<0){if(J>j){m[O]=undefined;K.splice(j,O-j+1);m.splice(j,O-j+1);}}else{K[j-1]=-K[j-1];m[j-1]=m[O];m[O]=undefined;K.splice(j,O-j+1);m.splice(j,O-j+1);}}else if(K[J]==n){if(J>j){if(K[j-1]<0){K.splice(j,J-j+1);m.splice(j,J-j+1);h=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){x.fatal("assertion failed: multi-unit entry already existed before");}K[j-1]=-K[j-1];m[j-1]=o;K.splice(j,J-j+1);m.splice(j,J-j+1);h=1;}}}else{x.fatal("assertion failed: uncovered case detected");return h;}}else if(K[J]>n){x.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(J-j>0){K.splice(j,J-j);m.splice(j,J-j);}return h;};G.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,e,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(e){if(!o.unitPropertyName||e.indexOf(o.unitPropertyName)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(e.indexOf(s[k])!=-1){m[s[k]]="*";}}var h="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var j=m[this.aAllDimensionSortedByName[l]];var n=j===""?'""':j;n=n===undefined?"":n;h+=(encodeURIComponent(n)+",");}h+="-multiple-units-not-dereferencable";var p;if(this.mMultiUnitKey[g]&&(p=this.mMultiUnitKey[g].indexOf(h))!=-1){return{oEntry:this.oModel.getObject("/"+h),bIsNewEntry:false,iIndex:p,aReloadMeasurePropertyName:R};}m.__metadata.uri=h;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var q=this.oModel._getKey(m);this.oModel.getContext('/'+q)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};G.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};G.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};G.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};G.prototype.refresh=function(e){G.prototype._refresh.apply(this,arguments);};G.prototype._refresh=function(e,m,g){var h=false;if(!e){if(g){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in g)){h=true;}}if(m&&!h){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){h=true;return false;}});if(h){return false;}});}if(!m&&!g){h=true;}}if(e||h){this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};G.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};G.prototype.getDownloadUrl=function(s){var e,p,z;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var n in this.oDimensionDetailsSet){g.push(n);}o.setAggregationLevel(g);for(var q in this.oDimensionDetailsSet){var r=this.oDimensionDetailsSet[q];var I=(r.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(r.name,true,I,r.aAttributeName);}for(var M in this.oMeasureDetailsSet){h.push(M);}o.setMeasures(h);for(var J in this.oMeasureDetailsSet){var K=this.oMeasureDetailsSet[J];var N=(K.rawValuePropertyName!=undefined);var O=(K.formattedValuePropertyName!=undefined);var P=(K.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(K.name,N,O,P);}var R=o.getSortExpression();R.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){R.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);}}var U=o.getFilterExpression();U.clear();if(this.aApplicationFilter){U.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){U.addUI5FilterConditions(this.aControlFilter);}var V=o.getURIToQueryResultEntitySet();var W=this._getQueryODataRequestOptions(o,true);if(!W){return undefined;}var X=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var Y=this.aAnalyticalInfo[k];if((Y.visible||Y.inResult)&&Y.name!==""&&Y.name!==X[X.length-1]){X.push(Y.name);if(this.oMeasureDetailsSet[Y.name]!=undefined&&this.oMeasureDetailsSet[Y.name].unitPropertyName!=undefined){X.push(this.oMeasureDetailsSet[Y.name].unitPropertyName);}}}for(var j=0,l=W.length;j<l;j++){if(/^\$select/i.test(W[j])){if(this.mParameters.select){e=W[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(X.indexOf(p)===-1){X.push(p);}}}W[j]="$select="+X.join(",");break;}}if(s){W.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){W.push(this.sCustomParams);}if(V){return this.oModel._createRequestUrl(V,null,W).replace(/ /g,"%20");}};G.prototype._addSorters=function(s,g){var e=this._canApplySortersToGroups()?[].concat(this.aSorter).concat(g):[].concat(g).concat(this.aSorter);e.forEach(function(o){s.addSorter(o.sPath,o.bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);});};G.prototype._canApplySortersToGroups=function(){var s=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(s!==this.sLastAutoExpandMode&&s!==f.Sequential){x.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+s,this.sPath);}this.sLastAutoExpandMode=s;}return s===f.Sequential;}return false;};G.prototype._warnNoSortingOfGroups=function(s){var m;if(this.bApplySortersToGroups){m="Detected a multi-unit case, so sorting is only possible on leaves";if(s){m+="; "+s;}x.warning(m,this.sPath);}this.bApplySortersToGroups=false;};G.Logger=x;return G;});
