/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/Sorter','./AnalyticalVersionInfo',"sap/base/security/encodeURL"],function(F,c,S,A,e){"use strict";var o=o||{},d=/^\d+$/;o.constants={};o.constants["SAP_NAMESPACE"]="http://www.sap.com/Protocols/SAPData";o.constants["VERSION"]="0.7";o.helper={deepEqual:function(O,N,f){var a,b,r=0,i,n;if(!O||O.length!==N.length){return 2;}if(O!==N){for(i=0,n=O.length;i<n;i+=1){b=O[i];a=N[i];if(b.grouped!==a.grouped||b.inResult!==a.inResult||b.level!==a.level||b.name!==a.name||b.total!==a.total||b.visible!==a.visible){return 2;}if(b.formatter!==a.formatter){r=1;if(f){f(a);}}}}return r;},tokenizeNametoLabelText:function(n){var l="";l=n.replace(/^P_(.*)/,"$1");l=l.replace(/([^A-Z0-9_]+)([A-Z0-9_])/g,"$1 $2");l=l.replace(/([A-Z0-9_]{2,})([A-Z0-9_])([^A-Z0-9_]+)/g,"$1 $2$3");l=l.replace(/(.*) _E$/,"$1");l=l.replace(/(.*) _(.*)/g,"$1 $2");return l;}};o.Model=function(m,p){this._init(m,p);};o.Model.ReferenceByURI=function(u){return{sServiceURI:u};};o.Model.ReferenceByModel=function(m){return{oModel:m};};o.Model.ReferenceWithWorkaround=function(m,w){return{oModelReference:m,aWorkaroundID:w};};o.Model.prototype={_init:function(m,p){if(typeof p=="string"){throw"Deprecated second argument: Adjust your invocation by passing an object with a property sAnnotationJSONDoc as a second argument instead";}this._mParameter=p;var t=this;this._oActivatedWorkarounds={};if(m&&m.aWorkaroundID){for(var i=-1,I;(I=m.aWorkaroundID[++i])!==undefined;){this._oActivatedWorkarounds[I]=true;}m=m.oModelReference;}if(!m||(!m.sServiceURI&&!m.oModel)){throw"Usage with oModelReference being an instance of Model.ReferenceByURI or Model.ReferenceByModel";}if(m.oModel){this._oModel=m.oModel;this._iVersion=A.getVersion(this._oModel);a();}else if(p&&p.modelVersion===A.V2){var V=sap.ui.requireSync("sap/ui/model/odata/v2/ODataModel");this._oModel=new V(m.sServiceURI);this._iVersion=A.V2;a();}else{var O=sap.ui.requireSync("sap/ui/model/odata/ODataModel");this._oModel=new O(m.sServiceURI);this._iVersion=A.V1;a();}if(this._oModel.getServiceMetadata()&&this._oModel.getServiceMetadata().dataServices==undefined){throw"Model could not be loaded";}function a(){if(!t._oModel.getServiceMetadata()){t._oModel.attachMetadataLoaded(b);}else{b();}}function b(){if(t.bIsInitialized){return;}t.bIsInitialized=true;if(p&&p.sAnnotationJSONDoc){t.mergeV2Annotations(p.sAnnotationJSONDoc);}t._interpreteMetadata(t._oModel.getServiceMetadata().dataServices);}},_interpreteMetadata:function(M){this._oQueryResultSet={};this._oParameterizationSet={};this._oEntityTypeSet={};this._oEntitySetSet={};this._oEntityTypeNameToEntitySetMap={};var a=this._oModel.getServiceMetadata().dataServices.schema[0];for(var j=-1,C;(C=a.entityContainer[++j])!==undefined;){if(C.isDefaultEntityContainer=="true"){this._oDefaultEntityContainer=C;break;}}var E=a.entityType;var q=[],P=[],u=[];for(var k=-1,T;(T=E[++k])!==undefined;){var b=false;if(T.extensions!=undefined){for(var l=-1,f;(f=T.extensions[++l])!==undefined;){if(f.namespace==o.constants.SAP_NAMESPACE&&f.name=="semantics"){b=true;switch(f.value){case"aggregate":q.push(T);break;case"parameters":P.push(T);break;default:u.push(T);}}if(b){continue;}}if(!b){u.push(T);}}else{u.push(T);}}for(var m=-1,g;(g=u[++m])!==undefined;){var h=new o.EntityType(this._oModel.getServiceMetadata(),a,g);this._oEntityTypeSet[h.getQName()]=h;var i=this._getEntitySetsOfType(a,h.getQName());if(i.length==0){throw"Invalid consumption model: No entity set for entity type "+h.getQName()+" found";}if(i.length>1){throw"Unsupported consumption model: More than one entity set for entity type "+h.getQName()+" found";}var v=new o.EntitySet(this._oModel.getServiceMetadata(),a,i[0][0],i[0][1],h);this._oEntitySetSet[v.getQName()]=v;this._oEntityTypeNameToEntitySetMap[h.getQName()]=v;}var w={};for(var n=-1,x;(x=P[++n])!==undefined;){var y=new o.EntityType(this._oModel.getServiceMetadata(),a,x);this._oEntityTypeSet[y.getQName()]=y;var z=this._getEntitySetsOfType(a,y.getQName());if(z.length==0){throw"Invalid consumption model: No entity set for parameter entity type "+y.getQName()+" found";}if(z.length>1){throw"Unsupported consumption model: More than one entity set for parameter entity type "+y.getQName()+" found";}var B=new o.EntitySet(this._oModel.getServiceMetadata(),a,z[0][0],z[0][1],y);this._oEntitySetSet[B.getQName()]=B;this._oEntityTypeNameToEntitySetMap[y.getQName()]=B;var D=new o.Parameterization(y,B);this._oParameterizationSet[D.getName()]=D;w[y.getQName()]=D;var G=y.getQName();if(a.association!=undefined){for(var p=-1,H;(H=a.association[++p])!==undefined;){if(H.referentialConstraint==undefined){continue;}var I=null;if(H.end[0].type==G&&H.end[0].multiplicity=="*"&&H.end[1].multiplicity=="1"){I=H.end[1].type;}else if(H.end[1].type==G&&H.end[1].multiplicity=="*"&&H.end[0].multiplicity=="1"){I=H.end[0].type;}if(!I){continue;}if(H.referentialConstraint.dependent.propertyRef.length!=1){continue;}var J=D.findParameterByName(H.referentialConstraint.dependent.propertyRef[0].name);if(J==null){continue;}var V=this._oEntityTypeSet[I];var K=this._oEntityTypeNameToEntitySetMap[I];J.setValueSetEntity(V,K);}}}for(var r=-1,L;(L=q[++r])!==undefined;){var N=new o.EntityType(this._oModel.getServiceMetadata(),a,L);this._oEntityTypeSet[N.getQName()]=N;var Q=N.getQName();var O=null;var R=null;if(a.association!=undefined){for(var s=-1,U;(U=a.association[++s])!==undefined;){var W=null;if(U.end[0].type==Q){W=U.end[1].type;}else if(U.end[1].type==Q){W=U.end[0].type;}else{continue;}var X=null;X=w[W];if(X!=null){if(O!=null){throw"LIMITATION: Unable to handle multiple parameter entity types of query entity "+N.name;}else{O=X;R=U;}}}}var Y=this._getEntitySetsOfType(a,N.getQName());if(Y.length!=1){throw"Invalid consumption model: There must be exactly one entity set for an entity type annotated with aggregating semantics";}var Z=new o.EntitySet(this._oModel.getServiceMetadata(),a,Y[0][0],Y[0][1],N);this._oEntitySetSet[Z.getQName()]=Z;this._oEntityTypeNameToEntitySetMap[N.getQName()]=Z;var $=new o.QueryResult(this,N,Z,O);this._oQueryResultSet[$.getName()]=$;if(O){O.setTargetQueryResult($,R);}if(a.association!=undefined){for(var t=-1,_;(_=a.association[++t])!==undefined;){if(_.referentialConstraint==undefined){continue;}var a1=null;if(_.end[0].type==Q&&_.end[0].multiplicity=="*"&&_.end[1].multiplicity=="1"){a1=_.end[1].type;}else if(_.end[1].type==Q&&_.end[1].multiplicity=="*"&&_.end[0].multiplicity=="1"){a1=_.end[0].type;}if(!a1){continue;}if(_.referentialConstraint.dependent.propertyRef.length!=1){continue;}var b1=$.findDimensionByName(_.referentialConstraint.dependent.propertyRef[0].name);if(b1==null){continue;}var c1=this._oEntityTypeNameToEntitySetMap[a1];b1.setMembersEntitySet(c1);}}}},oUI5ODataModelAnnotatableObject:{objectName:"schema",keyPropName:"namespace",extensions:true,aSubObject:[{objectName:"entityType",keyPropName:"name",extensions:true,aSubObject:[{objectName:"property",keyPropName:"name",aSubObject:[],extensions:true}]},{objectName:"entityContainer",keyPropName:"name",extensions:false,aSubObject:[{objectName:"entitySet",keyPropName:"name",extensions:true,aSubObject:[]}]}]},mergeV2Annotations:function(a){var b=null;try{b=JSON.parse(a);}catch(f){return;}var m;try{m=this._oModel.getServiceMetadata().dataServices;}catch(f){return;}for(var p in b){if(!(this.oUI5ODataModelAnnotatableObject.objectName==p)){continue;}if(!(b[p]instanceof Array)){continue;}this.mergeV2AnnotationLevel(m[this.oUI5ODataModelAnnotatableObject.objectName],b[this.oUI5ODataModelAnnotatableObject.objectName],this.oUI5ODataModelAnnotatableObject);break;}return;},mergeV2AnnotationLevel:function(M,a,u){for(var i=-1,b;(b=a[++i])!==undefined;){for(var j=-1,f;(f=M[++j])!==undefined;){if(!(b[u.keyPropName]==f[u.keyPropName])){continue;}if(b["extensions"]!=undefined){if(f["extensions"]==undefined){f["extensions"]=[];}for(var l=-1,g;(g=b["extensions"][++l])!==undefined;){var h=false;for(var m=-1,n;(n=f["extensions"][++m])!==undefined;){if(g.name==n.name&&g.namespace==n.namespace){n.value=g.value;h=true;break;}}if(!h){f["extensions"].push(g);}}}for(var k=-1,U;(U=u.aSubObject[++k])!==undefined;){for(var p in b){if(!(U.objectName==p)){continue;}if(!(b[U.objectName]instanceof Array)){continue;}if((f[U.objectName]==undefined)||(!(f[U.objectName]instanceof Array))){continue;}this.mergeV2AnnotationLevel(f[U.objectName],b[U.objectName],U);break;}}}}return;},findQueryResultByName:function(n){var q=this._oQueryResultSet[n];if(!q&&this._oDefaultEntityContainer){var Q=this._oDefaultEntityContainer.name+"."+n;q=this._oQueryResultSet[Q];}return q;},getAllQueryResultNames:function(){if(this._aQueryResultNames){return this._aQueryResultNames;}this._aQueryResultNames=new Array(0);for(var n in this._oQueryResultSet){this._aQueryResultNames.push(this._oQueryResultSet[n].getName());}return this._aQueryResultNames;},getAllQueryResults:function(){return this._oQueryResultSet;},getODataModel:function(){return this._oModel;},_getEntitySetsOfType:function(s,q){var E=[];for(var i=-1,a;(a=s.entityContainer[++i])!==undefined;){for(var j=-1,b;(b=a.entitySet[++j])!==undefined;){if(b.entityType==q){E.push([a,b]);}}}return E;},_mParameter:null,_oModel:null,_oDefaultEntityContainer:null,_aQueryResultNames:null,_oQueryResultSet:null,_oParameterizationSet:null,_oEntityTypeSet:null,_oEntitySetSet:null,_oEntityTypeNameToEntitySetMap:null,_oActivatedWorkarounds:null};o.QueryResult=function(m,E,a,p){this._init(m,E,a,p);};o.QueryResult.prototype={_init:function(m,E,a,p,b){this._oModel=m;this._oEntityType=E;this._oEntitySet=a;this._oParameterization=p;this._oDimensionSet={};this._oMeasureSet={};var P=E.getTypeDescription().property;var f={};for(var i=-1,g;(g=P[++i])!==undefined;){if(g.extensions==undefined){continue;}for(var j=-1,h;(h=g.extensions[++j])!==undefined;){if(!h.namespace==o.constants.SAP_NAMESPACE){continue;}switch(h.name){case"aggregation-role":switch(h.value){case"dimension":{var D=new o.Dimension(this,g);this._oDimensionSet[D.getName()]=D;break;}case"measure":{var M=new o.Measure(this,g);this._oMeasureSet[M.getName()]=M;break;}case"totaled-properties-list":this._oTotaledPropertyListProperty=g;break;default:}break;case"attribute-for":{var k=new o.DimensionAttribute(this,g);var K=k.getKeyProperty();f[K.name]=k;break;}default:}}}for(var s in f){var l=f[s];l.getDimension().addAttribute(l);}if(m._oActivatedWorkarounds.IdentifyTextPropertiesByName){var n=[];for(var q in this._oDimensionSet){var r=this._oDimensionSet[q];if(!r.getTextProperty()){var T=null;T=E.findPropertyByName(q+"Name");if(!T){T=E.findPropertyByName(q+"Text");}if(!T){T=E.findPropertyByName(q+"Desc");}if(!T){T=E.findPropertyByName(q+"Description");}if(T){r.setTextProperty(T);n.push(T.name);}}}for(var t=-1,u;(u=n[++t])!==undefined;){delete this._oDimensionSet[u];}}},getName:function(){return this.getEntitySet().getQName();},getParameterization:function(){return this._oParameterization;},getAllDimensionNames:function(){if(this._aDimensionNames){return this._aDimensionNames;}this._aDimensionNames=[];for(var n in this._oDimensionSet){this._aDimensionNames.push(this._oDimensionSet[n].getName());}return this._aDimensionNames;},getAllDimensions:function(){return this._oDimensionSet;},getAllMeasureNames:function(){if(this._aMeasureNames){return this._aMeasureNames;}this._aMeasureNames=[];for(var n in this._oMeasureSet){this._aMeasureNames.push(this._oMeasureSet[n].getName());}return this._aMeasureNames;},getAllMeasures:function(){return this._oMeasureSet;},findDimensionByName:function(n){return this._oDimensionSet[n];},findDimensionByPropertyName:function(n){if(this._oDimensionSet[n]){return this._oDimensionSet[n];}for(var D in this._oDimensionSet){var a=this._oDimensionSet[D];var t=a.getTextProperty();if(t&&t.name==n){return a;}if(a.findAttributeByName(n)){return a;}}return null;},getTotaledPropertiesListProperty:function(){return this._oTotaledPropertyListProperty;},findMeasureByName:function(n){return this._oMeasureSet[n];},findMeasureByPropertyName:function(n){if(this._oMeasureSet[n]){return this._oMeasureSet[n];}for(var m in this._oMeasureSet){var M=this._oMeasureSet[m];var f=M.getFormattedValueProperty();if(f&&f.name==n){return M;}}return null;},getModel:function(){return this._oModel;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oModel:null,_oEntityType:null,_oEntitySet:null,_oParameterization:null,_aDimensionNames:null,_oDimensionSet:null,_aMeasureNames:null,_oMeasureSet:null,_oTotaledPropertyListProperty:null};o.Parameterization=function(E,a){this._init(E,a);};o.Parameterization.prototype={_init:function(E,a){this._oEntityType=E;this._oEntitySet=a;this._oParameterSet={};var p=E.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){if(P.extensions==undefined){continue;}for(var j=-1,b;(b=P.extensions[++j])!==undefined;){if(!b.namespace==o.constants.SAP_NAMESPACE){continue;}switch(b.name){case"parameter":{var f=new o.Parameter(this,P);this._oParameterSet[f.getName()]=f;break;}default:}}}},setTargetQueryResult:function(q,a){this._oQueryResult=q;var Q=this._oEntityType.getSchema().namespace+"."+a.name;var n=this._oEntityType.getTypeDescription().navigationProperty;if(!n){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}for(var i=-1,N;(N=n[++i])!==undefined;){if(N.relationship==Q){this._oNavPropToQueryResult=N.name;}}if(!this._oNavPropToQueryResult){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}},getTargetQueryResult:function(){if(!this._oQueryResult){throw"No target query result set";}return this._oQueryResult;},getName:function(){return this.getEntitySet().getQName();},getAllParameterNames:function(){if(this._aParameterNames){return this._aParameterNames;}this._aParameterNames=[];for(var n in this._oParameterSet){this._aParameterNames.push(this._oParameterSet[n].getName());}return this._aParameterNames;},getAllParameters:function(){return this._oParameterSet;},findParameterByName:function(n){return this._oParameterSet[n];},getNavigationPropertyToQueryResult:function(){return this._oNavPropToQueryResult;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oEntityType:null,_oEntitySet:null,_oQueryResult:null,_oNavPropToQueryResult:null,_aParameterNames:null,_oParameterSet:null};o.Parameter=function(p,P){this._init(p,P);};o.Parameter.prototype={_init:function(p,P){this._oParameterization=p;this._oProperty=P;var E=p.getEntityType();if(P.extensions!=undefined){for(var i=-1,a;(a=P.extensions[++i])!==undefined;){if(!a.namespace==o.constants.SAP_NAMESPACE){continue;}switch(a.name){case"parameter":switch(a.value){case"mandatory":this._bRequired=true;break;case"optional":this._bRequired=false;break;default:throw"Invalid annotation value for parameter property";}break;case"label":this._sLabelText=a.value;break;case"text":this._oTextProperty=E.findPropertyByName(a.value);break;case"upper-boundary":this._bIntervalBoundaryParameter=true;this._oUpperIntervalBoundaryParameterProperty=E.findPropertyByName(a.value);break;case"lower-boundary":this._bIntervalBoundaryParameter=true;this._oLowerIntervalBoundaryParameterProperty=E.findPropertyByName(a.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},setValueSetEntity:function(E,a){this._oValueSetEntityType=E;this._oValueSetEntitySet=a;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oParameterization._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isOptional:function(){return(!this._bRequired);},isIntervalBoundary:function(){return this._bIntervalBoundaryParameter;},isLowerIntervalBoundary:function(){return(this._oUpperIntervalBoundaryParameterProperty?true:false);},getPeerIntervalBoundaryParameter:function(){var p=null;if(this._oLowerIntervalBoundaryParameterProperty){p=this._oLowerIntervalBoundaryParameterProperty.name;}else{p=this._oUpperIntervalBoundaryParameterProperty.name;}if(!p){throw"Parameter is not an interval boundary";}return this._oParameterization.findParameterByName(p);},isValueSetAvailable:function(){return(this._oValueSetEntityType?true:false);},getName:function(){return this._oProperty.name;},getProperty:function(){return this._oProperty;},getContainingParameterization:function(){return this._oParameterization;},getURIToValueEntitySet:function(s){var u=null;u=(s?s:"")+"/"+this._oValueSetEntitySet.getQName();return u;},_oParameterization:null,_oProperty:null,_sLabelText:null,_oTextProperty:null,_bRequired:false,_bIntervalBoundaryParameter:false,_oLowerIntervalBoundaryParameterProperty:null,_oUpperIntervalBoundaryParameterProperty:null,_oValueSetEntityType:null,_oValueSetEntitySet:null};o.Dimension=function(q,p){this._init(q,p);};o.Dimension.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;this._oAttributeSet={};},setMembersEntitySet:function(E){this._oMembersEntitySet=E;},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){if(!this._oTextProperty){this._oTextProperty=this._oQueryResult.getEntityType().getTextPropertyOfProperty(this.getName());}return this._oTextProperty;},setTextProperty:function(t){this._oTextProperty=t;},getLabelText:function(){if(!this._sLabelText){this._sLabelText=this._oQueryResult.getEntityType().getLabelOfProperty(this.getName());}if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return(this._sLabelText==null?"":this._sLabelText);},getSuperOrdinateDimension:function(){if(!this._sSuperOrdinateDimension){var s=this._oQueryResult.getEntityType().getSuperOrdinatePropertyOfProperty(this.getName());if(s){this._sSuperOrdinateDimension=this._oQueryResult.findDimensionByName(s.name);}}return this._sSuperOrdinateDimension;},getHierarchy:function(){if(!this._oHierarchy){this._oHierarchy=this._oQueryResult.getEntityType().getHierarchy(this._oProperty.name);}return this._oHierarchy;},getAllAttributeNames:function(){if(this._aAttributeNames){return this._aAttributeNames;}this._aAttributeNames=[];for(var n in this._oAttributeSet){this._aAttributeNames.push(this._oAttributeSet[n].getName());}return this._aAttributeNames;},getAllAttributes:function(){return this._oAttributeSet;},findAttributeByName:function(n){return this._oAttributeSet[n];},addAttribute:function(D){this._oAttributeSet[D.getName()]=D;},getContainingQueryResult:function(){return this._oQueryResult;},hasMasterData:function(){return this._oMembersEntitySet!=null?true:false;},getMasterDataEntitySet:function(){return this._oMembersEntitySet;},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sSuperOrdinateDimension:null,_aAttributeNames:null,_oAttributeSet:null,_oMembersEntitySet:null,_oHierarchy:null};o.DimensionAttribute=function(q,p){this._init(q,p);};o.DimensionAttribute.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,E;(E=p.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"attribute-for":this._sDimensionName=E.value;break;case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=q.getEntityType().findPropertyByName(E.value);break;default:}}}},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},getDimension:function(){return this._oQueryResult.findDimensionByName(this._sDimensionName);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sDimensionName:null};o.Measure=function(q,p){this._init(q,p);};o.Measure.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,E;(E=p.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=q.getEntityType().findPropertyByName(E.value);break;case"unit":this._oUnitProperty=q.getEntityType().findPropertyByName(E.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},getName:function(){return this._oProperty.name;},getRawValueProperty:function(){return this._oProperty;},getFormattedValueProperty:function(){return this._oTextProperty;},getUnitProperty:function(){return this._oUnitProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isUpdatable:function(){if(this._bIsUpdatable!=null){return this._bIsUpdatable;}var u=this._oQueryResult.getEntitySet().getUpdatablePropertyNameSet();return(u[this.getName()]!=undefined);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_oUnitProperty:null,_bIsUpdatable:null};o.EntitySet=function(m,s,C,E,a){this._init(m,s,C,E,a);};o.EntitySet.prototype={_init:function(m,s,C,E,a){this._oEntityType=a;this._oEntitySet=E;this._oContainer=C;this._oSchema=s;this._oModel=m;if(s.entityContainer.length>1){this._sQName=C.name+"."+E.name;}else{this._sQName=E.name;}},getQName:function(){return this._sQName;},getSetDescription:function(){return this._oEntitySet;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},getUpdatablePropertyNameSet:function(){if(this._oUpdatablePropertyNames){return this._oUpdatablePropertyNames;}this._oUpdatablePropertyNames={};var s=true;if(this._oEntitySet.extensions!=undefined){for(var j=-1,E;(E=this._oEntitySet.extensions[++j])!==undefined;){if(E.namespace==o.constants.SAP_NAMESPACE&&E.name=="updatable"){if(E.value=="false"){s=false;break;}}}}if(!s){return this._oUpdatablePropertyNames;}var p=this._oEntityType.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){var b=true;if(P.extensions==undefined){continue;}for(var k=-1,a;(a=P.extensions[++k])!==undefined;){if(a.namespace!=o.constants.SAP_NAMESPACE){continue;}if(a.name=="updatable"){if(a.value=="false"){b=false;break;}}}if(b){this._oUpdatablePropertyNames[P.name]=true;}}return this._oUpdatablePropertyNames;},_oEntityType:null,_oEntitySet:null,_oContainer:null,_oSchema:null,_oModel:null,_sQName:null,_oUpdatablePropertyNames:null};o.EntityType=function(m,s,E){this._init(m,s,E);};o.EntityType.propertyFilterRestriction={SINGLE_VALUE:"single-value",MULTI_VALUE:"multi-value",INTERVAL:"interval"};o.EntityType.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aKeyProperties=[];this._oPropertySet={};this._aFilterablePropertyNames=[];this._aSortablePropertyNames=[];this._aRequiredFilterPropertyNames=[];this._oPropertyFilterRestrictionSet={};this._oPropertyHeadingsSet={};this._oPropertyQuickInfosSet={};this._sQName=s.namespace+"."+E.name;var r={};function g(K){var R=r[K];if(!R){R=r[K]={};}return R;}for(var i=-1,p;(p=E.key.propertyRef[++i])!==undefined;){this._aKeyProperties.push(p.name);}for(var k=-1,P;(P=E.property[++k])!==undefined;){this._oPropertySet[P.name]=P;this._aFilterablePropertyNames.push(P.name);this._aSortablePropertyNames.push(P.name);if(P.extensions==undefined){continue;}for(var j=-1,a;(a=P.extensions[++j])!==undefined;){if(a.namespace!==o.constants.SAP_NAMESPACE){continue;}switch(a.name){case"filterable":if(a.value=="false"){this._aFilterablePropertyNames.pop(P.name);}break;case"sortable":if(a.value=="false"){this._aSortablePropertyNames.pop(P.name);}break;case"required-in-filter":if(a.value=="true"){this._aRequiredFilterPropertyNames.push(P.name);}break;case"filter-restriction":if(a.value==o.EntityType.propertyFilterRestriction.SINGLE_VALUE||a.value==o.EntityType.propertyFilterRestriction.MULTI_VALUE||a.value==o.EntityType.propertyFilterRestriction.INTERVAL){this._oPropertyFilterRestrictionSet[P.name]=a.value;}break;case"hierarchy-node-external-key-for":g(a.value).externalKeyProperty=P;break;case"hierarchy-node-for":g(P.name).dimensionName=a.value;break;case"hierarchy-parent-node-for":case"hierarchy-parent-nod":g(a.value).parentNodeIDProperty=P;break;case"hierarchy-level-for":g(a.value).levelProperty=P;break;case"hierarchy-drill-state-for":case"hierarchy-drill-stat":g(a.value).drillStateProperty=P;break;default:}}}this._oRecursiveHierarchySet={};for(var h in r){var H=r[h];var b=this._oPropertySet[h];var D=this._oPropertySet[H.dimensionName];if(D==null){D=b;}this._oRecursiveHierarchySet[D.name]=new o.RecursiveHierarchy(E,b,H.parentNodeIDProperty,H.levelProperty,D,H.externalKeyProperty);}},getProperties:function(){return this._oPropertySet;},findPropertyByName:function(p){return this._oPropertySet[p];},getKeyProperties:function(){return this._aKeyProperties;},getLabelOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="label"){return E.value;}}}return null;},getHeadingOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="heading"){return E.value;}if(E.name=="label"){s=E.value;}}}return s;},getQuickInfoOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="quickinfo"){return E.value;}if(E.name=="label"){s=E.value;}}}return s;},getTextPropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(E.name=="text"){return this.findPropertyByName(E.value);}}}return null;},getSuperOrdinatePropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(E.name=="super-ordinate"){return this.findPropertyByName(E.value);}}}return null;},getFilterablePropertyNames:function(){return this._aFilterablePropertyNames;},getSortablePropertyNames:function(){return this._aSortablePropertyNames;},getRequiredFilterPropertyNames:function(){return this._aRequiredFilterPropertyNames;},getPropertiesWithFilterRestrictions:function(){return this._oPropertyFilterRestrictionSet;},getAllHierarchyPropertyNames:function(){if(this._aHierarchyPropertyNames){return this._aHierarchyPropertyNames;}this._aHierarchyPropertyNames=[];for(var n in this._oRecursiveHierarchySet){this._aHierarchyPropertyNames.push(this._oRecursiveHierarchySet[n].getNodeValueProperty().name);}return this._aHierarchyPropertyNames;},getHierarchy:function(n){if(this._oRecursiveHierarchySet[n]==undefined){return null;}return this._oRecursiveHierarchySet[n];},getQName:function(){return this._sQName;},getTypeDescription:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_sQName:null,_aKeyProperties:null,_oPropertySet:null,_aFilterablePropertyNames:null,_aRequiredFilterPropertyNames:null,_oPropertyFilterRestrictionSet:null,_aHierarchyPropertyNames:null,_oRecursiveHierarchySet:null};o.RecursiveHierarchy=function(E,n,p,N,a,b){this._init(E,n,p,N,a,b);};o.RecursiveHierarchy.prototype={_init:function(E,n,p,N,a,b){this._oEntityType=E;this._oNodeIDProperty=n;this._oParentNodeIDProperty=p;this._oNodeLevelProperty=N;this._oNodeValueProperty=a;this._oNodeExternalKeyProperty=b;},isRecursiveHierarchy:function(){return true;},isLeveledHierarchy:function(){return false;},getNodeExternalKeyProperty:function(){return this._oNodeExternalKeyProperty;},getNodeIDProperty:function(){return this._oNodeIDProperty;},getParentNodeIDProperty:function(){return this._oParentNodeIDProperty;},getNodeLevelProperty:function(){return this._oNodeLevelProperty;},getNodeValueProperty:function(){return this._oNodeValueProperty;},_oEntityType:null,_oNodeIDProperty:null,_oParentNodeIDProperty:null,_oNodeLevelProperty:null,_oNodeValueProperty:null,_oNodeExternalKeyProperty:null};o.FilterExpression=function(m,s,E){this._init(m,s,E);};o.FilterExpression.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_renderPropertyFilterValue:function(f,p){if(p==="Edm.Time"&&d.test(f)){f={ms:parseInt(f),__edmType:"Edm.Time"};}return e(this._oModel.getODataModel().formatValue(f,p));},clear:function(){this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_addCondition:function(p,O,v,V){for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(u.sPath==p&&u.sOperator==O&&u.oValue1==v&&u.oValue2==V){return;}}this._aConditionUI5Filter.push(new F(p,O,v,V));},_addUI5FilterArray:function(u){this._aUI5FilterArray.push(u);},addCondition:function(p,O,v,V){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(((f?Array.prototype.indexOf.call(f,p):-1))===-1){throw"Cannot add filter condition for not filterable property name "+p;}this._addCondition(p,O,v,V);return this;},removeConditions:function(p){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot remove filter conditions for unknown property name "+p;}for(var i=0;i<this._aConditionUI5Filter.length;i++){var u=this._aConditionUI5Filter[i];if(u.sPath==p){this._aConditionUI5Filter.splice(i--,1);}}return this;},addSetCondition:function(p,v){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(((f?Array.prototype.indexOf.call(f,p):-1))===-1){throw"Cannot add filter condition for not filterable property name "+p;}for(var i=-1,V;(V=v[++i])!==undefined;){this._addCondition(p,c.EQ,V);}return this;},addUI5FilterConditions:function(u){if(!Array.isArray(u)){throw"Argument is not an array";}if(u.length==0){return this;}var h=false;for(var i=0;i<u.length;i++){if(u[i].aFilters!=undefined){h=true;break;}}if(h){this._addUI5FilterArray(u);}else{for(var j=0;j<u.length;j++){this.addCondition(u[j].sPath,u[j].sOperator,u[j].oValue1,u[j].oValue2);}}return this;},getExpressionAsUI5FilterArray:function(){var f=this._aConditionUI5Filter.concat([]);for(var i=-1,a;(a=this._aUI5FilterArray[++i])!==undefined;){for(var j=-1,b;(b=a[++j])!==undefined;){f.push(b);}}return f;},getPropertiesReferencedByUI5FilterArray:function(u,r){for(var i=-1,U;(U=u[++i])!==undefined;){if(U.aFilters!=undefined){this.getPropertiesReferencedByUI5FilterArray(U.aFilters,r);}else{if(r[U.sPath]==undefined){r[U.sPath]=[];}r[U.sPath].push(U);}}},getReferencedProperties:function(){var r={};for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(r[u.sPath]==undefined){r[u.sPath]=[];}r[u.sPath].push(u);}for(var j=-1,U;(U=this._aUI5FilterArray[++j])!==undefined;){this.getPropertiesReferencedByUI5FilterArray(U,r);}return r;},renderUI5Filter:function(u){var f=null,p=this._oEntityType.findPropertyByName(u.sPath);if(p==null){throw"Cannot add filter condition for unknown property name "+u.sPath;}switch(u.sOperator){case c.BT:f="("+u.sPath+" ge "+this._renderPropertyFilterValue(u.oValue1,p.type)+" and "+u.sPath+" le "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case c.NB:f="("+u.sPath+" lt "+this._renderPropertyFilterValue(u.oValue1,p.type)+" or "+u.sPath+" gt "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case c.Contains:case c.NotContains:f=(u.sOperator[0]==="N"?"not ":"")+"substringof("+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+","+u.sPath+")";break;case c.StartsWith:case c.EndsWith:case c.NotStartsWith:case c.NotEndsWith:f=u.sOperator.toLowerCase().replace("not","not ")+"("+u.sPath+","+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+")";break;default:f=u.sPath+" "+u.sOperator.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type);}return f;},renderUI5MultiFilter:function(u){var U=[];var O="";var l=u.bAnd==true?" and ":" or ";for(var i=-1,a;(a=u.aFilters[++i])!==undefined;){if(a.aFilters!=undefined){U.push(a);continue;}O+=(O==""?"":l)+"("+this.renderUI5Filter(a)+")";}if(U.length>0){for(var j=-1,m;(m=U[++j])!==undefined;){O+=(O==""?"":l)+"("+this.renderUI5MultiFilter(m)+")";}}return O;},renderUI5FilterArray:function(u){if(u.length==0){return"";}var O="";u.sort(function(a,b){if(a.sPath==b.sPath){return 0;}if(a.sPath>b.sPath){return 1;}else{return-1;}});var p=u[0].sPath;var s="";var n=[],U=[];for(var i=-1,f;(f=u[++i])!==undefined;){if(f.aFilters!=undefined){U.push(f);continue;}if(p!=f.sPath){if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}s="";if(n.length>0){for(var j=-1,N;(N=n[++j])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(N);}O+=(O==""?"":" and ")+"("+s+")";s="";}p=f.sPath;n=[];}if(f.sOperator==c.NE){n.push(f);continue;}s+=(s==""?"":" or ")+this.renderUI5Filter(f);}if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}if(n.length>0){s="";for(var k=-1,g;(g=n[++k])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(g);}O+=(O==""?"":" and ")+"("+s+")";}if(U.length>0){for(var l=-1,m;(m=U[++l])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5MultiFilter(m)+")";}}return O;},getURIFilterOptionValue:function(){var O=this.renderUI5FilterArray(this._aConditionUI5Filter);for(var i=-1,u;(u=this._aUI5FilterArray[++i])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5FilterArray(u)+")";}return O;},checkValidity:function(){var r=this._oEntityType.getRequiredFilterPropertyNames();var p=this.getReferencedProperties();for(var i=-1,P;(P=r[++i])!==undefined;){if(p[P]==undefined){throw"filter expression does not contain required property "+P;}}var a=this._oEntityType.getPropertiesWithFilterRestrictions();for(var s in a){var f=a[s];if(f==o.EntityType.propertyFilterRestriction.SINGLE_VALUE){if(p[s]!=undefined){if(p[s].length>1){var t=p[s][0].oValue1;for(var j=0;j<p[s].length;j++){if(p[s][j].oValue1!=t||p[s][j].sOperator!=c.EQ){throw"filter expression may use "+s+" only with a single EQ condition";}}}}}}return true;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aFilterCondition:null};o.SortOrder={Ascending:"asc",Descending:"desc"};o.SortExpression=function(m,s,E){this._init(m,s,E);};o.SortExpression.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aSortCondition=[];},_containsSorter:function(p){var r=null;for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(C.property.name===p){r={sorter:C,index:i};break;}}return r;},_removeFromArray:function(a,f,t){var r=a.slice((t||f)+1||a.length);a.length=f<0?a.length+f:f;return a.push.apply(a,r);},clear:function(){this._aSortCondition=[];},addSorter:function(p,s){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add sort condition for unknown property name "+p;}var E=this._containsSorter(p);if(E!=null){E.sorter.order=s;return this;}var a=this._oEntityType.getSortablePropertyNames();if(((a?Array.prototype.indexOf.call(a,p):-1))===-1){throw"Cannot add sort condition for not sortable property name "+p;}this._aSortCondition.push({property:P,order:s});return this;},removeSorter:function(p){if(!p){return;}var s=this._containsSorter(p);if(s){this._removeFromArray(this._aSortCondition,s.index);}},getExpressionsAsUI5SorterArray:function(){var s=[];for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){s.push(new S(C.property.name,C.order==o.SortOrder.Descending));}return s;},getExpressionAsUI5Sorter:function(){var s=this.getExpressionsAsUI5SorterArray();if(s.length==0){return null;}else{return s[0];}},getURIOrderByOptionValue:function(s){if(this._aSortCondition.length==0){return"";}var O="";for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(!s[C.property.name]){continue;}O+=(O==""?"":",")+C.property.name+" "+C.order;}return O;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aSortCondition:null};o.ParameterizationRequest=function(p){this._init(p);};o.ParameterizationRequest.prototype={_init:function(p){if(!p){throw"No parameterization given";}this._oParameterization=p;this._oParameterValueAssignment=[];},_renderParameterKeyValue:function(k,p){return e(this._oParameterization.getTargetQueryResult().getModel().getODataModel().formatValue(k,p));},getParameterization:function(){return this._oParameterization;},setParameterValue:function(p,v,t){var P=this._oParameterization.findParameterByName(p);if(!P){throw"Invalid parameter name "+p;}if(t!=null){if(!P.isIntervalBoundary()){throw"Range value cannot be applied to parameter "+p+" accepting only single values";}if(!P.isLowerIntervalBoundary()){throw"Range value given, but parameter "+p+" does not hold the lower boundary";}}if(!P.isIntervalBoundary()){if(v==null){delete this._oParameterValueAssignment[p];}else{this._oParameterValueAssignment[p]=v;}}else{if(v==null&&t!=null){throw"Parameter "+p+": An upper boundary cannot be given without the lower boundary";}if(v==null){delete this._oParameterValueAssignment[p];t=null;}else{this._oParameterValueAssignment[p]=v;}var u=P.getPeerIntervalBoundaryParameter();if(t==null){t=v;}if(v==null){delete this._oParameterValueAssignment[u.getName()];}else{this._oParameterValueAssignment[u.getName()]=t;}}return;},getURIToParameterizationEntitySet:function(s){return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName();},getURIToParameterizationEntry:function(s){var D=this._oParameterization.getAllParameters();for(var a in D){if(this._oParameterValueAssignment[a]==undefined){throw"Parameter "+a+" has no value assigned";}}var k="",f=true;for(var p in this._oParameterValueAssignment){k+=(f?"":",")+p+"="+this._renderParameterKeyValue(this._oParameterValueAssignment[p],D[p].getProperty().type);f=false;}return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName()+"("+k+")";},_oParameterization:null,_oParameterValueAssignment:null};o.QueryResultRequest=function(q,p){this._init(q,p);};o.QueryResultRequest.prototype={_init:function(q,p){this._oQueryResult=q;this._oParameterizationRequest=p;this._oAggregationLevel={};this._oDimensionHierarchies={};this._oMeasures={};this._bIncludeEntityKey=false;this._oFilterExpression=null;this._oSortExpression=null;this._oSelectedPropertyNames=null;},addRecursiveHierarchy:function(h,i,I){var D;if(!h){return;}D=this._oQueryResult.findDimensionByName(h);if(!D){throw new Error("'"+h+"' is not a dimension property");}if(!D.getHierarchy()){throw new Error("Dimension '"+h+"' does not have a hierarchy");}this._oSelectedPropertyNames=null;this._oDimensionHierarchies[h]={externalKey:i,id:true,text:I};},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},setResourcePath:function(r){this._sResourcePath=r;if(this._sResourcePath.indexOf("/")!=0){throw"Missing leading / (slash) for resource path";}if(this._oQueryResult.getParameterization()){var l=r.lastIndexOf("/");if(l==-1){throw"Missing navigation from parameter entity set to query result in resource path";}var n=r.substring(l+1);if(n!=this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()){throw"Invalid navigation property from parameter entity set to query result in resource path";}}},getParameterizationRequest:function(){return this._oParameterizationRequest;},getQueryResult:function(){return this._oQueryResult;},setAggregationLevel:function(D){this._oAggregationLevel={};if(!D){D=this._oQueryResult.getAllDimensionNames();}this.addToAggregationLevel(D);this._oSelectedPropertyNames=null;},addToAggregationLevel:function(D){if(!D){return;}this._oSelectedPropertyNames=null;for(var i=-1,s;(s=D[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(s)){throw s+" is not a valid dimension name";}this._oAggregationLevel[s]={key:true,text:false,attributes:null};}},removeFromAggregationLevel:function(D){if(!D){return;}this._oSelectedPropertyNames=null;for(var i=-1,s;(s=D[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(s)){throw s+" is not a valid dimension name";}if(this._oAggregationLevel[s]!=undefined){delete this._oAggregationLevel[s];this.getSortExpression().removeSorter(s);}}},getAggregationLevel:function(){var D=[];for(var s in this._oAggregationLevel){D.push(s);}return D;},getAggregationLevelDetails:function(D){if(this._oAggregationLevel[D]==undefined){throw"Aggregation level does not include dimension "+D;}return this._oAggregationLevel[D];},setMeasures:function(m){if(!m){m=this._oQueryResult.getAllMeasureNames();}this._oSelectedPropertyNames=null;this._oMeasures={};for(var i=-1,M;(M=m[++i])!==undefined;){if(!this._oQueryResult.findMeasureByName(M)){throw M+" is not a valid measure name";}this._oMeasures[M]={value:true,text:false,unit:false};}},getMeasureNames:function(){var m=[];for(var M in this._oMeasures){m.push(M);}return m;},includeDimensionKeyTextAttributes:function(D,I,b,a){this._oSelectedPropertyNames=null;var f=[];if(D){if(this._oAggregationLevel[D]==undefined){throw D+" is not included in the aggregation level";}f.push(D);}else{for(var n in this._oAggregationLevel){f.push(n);}a=null;}for(var i=-1,s;(s=f[++i])!==undefined;){if(I!=null){this._oAggregationLevel[s].key=I;}if(b!=null){this._oAggregationLevel[s].text=b;}if(a!=null){this._oAggregationLevel[s].attributes=a;}}},includeMeasureRawFormattedValueUnit:function(m,I,b,a){this._oSelectedPropertyNames=null;var M=[];if(m){if(this._oMeasures[m]==undefined){throw m+" is not part of the query result";}M.push(m);}else{for(var n in this._oMeasures){M.push(n);}}for(var i=-1,s;(s=M[++i])!==undefined;){if(I!=null){this._oMeasures[s].value=I;}if(b!=null){this._oMeasures[s].text=b;}if(a!=null){this._oMeasures[s].unit=a;}}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oQueryResult.getEntityType();this._oFilterExpression=new o.FilterExpression(this._oQueryResult.getModel(),E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var E=this._oQueryResult.getEntityType();this._oSortExpression=new o.SortExpression(E.getModel(),E.getSchema(),E);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i,I,r){if(i!=null){this._bIncludeEntityKey=i;}if(I!=null){this._bIncludeCount=I;}if(r!=null){this._bReturnNoEntities=r;}},setResultPageBoundaries:function(s,a){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(a!==null&&typeof a!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(a==null?s:a)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(a!=null)?(a-s+1):null;},getResultPageBoundaries:function(){var E=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){E=1;}else{E=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:E};},getURIToQueryResultEntitySet:function(s){var u=null;if(this._sResourcePath!=null){u=(s?s:"")+this._sResourcePath;}else if(this._oQueryResult.getParameterization()){if(!this._oParameterizationRequest){throw"Missing parameterization request";}else{u=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult();}}else{u=(s?s:"")+"/"+this._oQueryResult.getEntitySet().getQName();}return u;},getURIOrderByOptionValue:function(){var a,C,O=null,s=this._oSortExpression?this._oSortExpression._aSortCondition:[],i,n=s.length;if(n){a=this._oQueryResult.getAllMeasureNames();for(i=0;i<n;i+=1){C=s[i];if(!this._oSelectedPropertyNames[C.property.name]&&a.indexOf(C.property.name)<0){continue;}O=(O?O+",":"")+C.property.name+" "+C.order;}}return O;},getURIQueryOptionValue:function(q){var n,Q=null,s,t=this;function a(p){var P;if(!p){return;}P=typeof p==="string"?p:p.name;if(!t._oSelectedPropertyNames[P]){s+=(s==""?"":",")+P;t._oSelectedPropertyNames[P]=true;}}switch(q){case"$select":{s="";this._oSelectedPropertyNames={};for(n in this._oAggregationLevel){var D=this._oQueryResult.findDimensionByName(n);var b=this._oAggregationLevel[n];if(b.key==true){a(D.getKeyProperty());}if(b.text==true){a(D.getTextProperty());}if(b.attributes){for(var i=-1,f;(f=b.attributes[++i])!==undefined;){a(D.findAttributeByName(f).getName());}}}for(n in this._oMeasures){var m=this._oQueryResult.findMeasureByName(n);var M=this._oMeasures[n];if(M.value==true){a(m.getRawValueProperty());}if(M.text==true){a(m.getFormattedValueProperty());}if(M.unit==true){a(m.getUnitProperty());}}for(n in this._oDimensionHierarchies){var h=this._oQueryResult.findDimensionByName(n).getHierarchy();var H=this._oDimensionHierarchies[n];if(H.id){a(h.getNodeIDProperty());}if(H.externalKey){a(h.getNodeExternalKeyProperty());}if(H.text){a(this._oQueryResult.getEntityType().getTextPropertyOfProperty(h.getNodeIDProperty().name));}}if(this._bIncludeEntityKey){var k=this._oQueryResult.getEntityType().getTypeDescription().key.propertyRef;for(var j=-1,K;(K=k[++j])!==undefined;){s+=(s==""?"":",")+K.name;}}Q=(s?s:null);break;}case"$filter":{var g=null;if(this._oFilterExpression){g=this._oFilterExpression.getURIFilterOptionValue();}Q=(g?g:null);break;}case"$orderby":{Q=this.getURIOrderByOptionValue();break;}case"$top":{Q=null;if(this._bReturnNoEntities){Q=0;}else if(this._iTopRequestOption!==null){Q=this._iTopRequestOption;}break;}case"$skip":{Q=null;if(!this._bReturnNoEntities){Q=this._iSkipRequestOption;}break;}case"$inlinecount":{Q=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return Q;},getURIToQueryResultEntries:function(s,r){if(!r){r=this.getURIToQueryResultEntitySet(s);}this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var g=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var q=false;if(a!==null){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}if((this._iTopRequestOption||this._bReturnNoEntities)&&t!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&g!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$skip="+g;}if(this._bIncludeCount&&i!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oQueryResult:null,_oParameterizationRequest:null,_sResourcePath:null,_oAggregationLevel:null,_oDimensionHierarchies:null,_oMeasures:null,_bIncludeEntityKey:null,_bIncludeCount:null,_bReturnNoEntities:null,_oFilterExpression:null,_oSortExpression:null,_iSkipRequestOption:null,_iTopRequestOption:null};o.ParameterValueSetRequest=function(p){this._init(p);};o.ParameterValueSetRequest.prototype={_init:function(p){this._oParameter=p;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;},includeParameterText:function(i){if(i!=null){this._oValueSetResult.text=i;}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oParameter.getContainingParameterization().getEntityType();var m=this._oParameter.getContainingParameterization().getTargetQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var E=this._oParameter.getContainingParameterization().getEntityType();this._oSortExpression=new o.SortExpression(E.getModel(),E.getSchema(),E);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},getURIQueryOptionValue:function(q){var Q=null;switch(q){case"$select":{var s="";s+=(s==""?"":",")+this._oParameter.getProperty().name;if(this._oValueSetResult.text==true&&this._oParameter.getTextProperty()){s+=(s==""?"":",")+this._oParameter.getTextProperty().name;}Q=(s?s:null);break;}case"$filter":{var f=null;if(this._oFilterExpression){f=this._oFilterExpression.getURIFilterOptionValue();}Q=(f?f:null);break;}case"$orderby":{var a=null;if(this._oSortExpression){a=this._oSortExpression.getURIOrderByOptionValue();}Q=(a?a:null);break;}default:break;}return Q;},getURIToParameterValueSetEntries:function(s){var r=null;r=(s?s:"")+"/"+this._oParameter.getContainingParameterization().getEntitySet().getQName();this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var u=r;var q=false;if(a){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}return u;},_oParameter:null,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null};o.DimensionMemberSetRequest=function(D,p,u){this._init(D,p,u);};o.DimensionMemberSetRequest.prototype={_init:function(D,p,u){this._oDimension=D;this._oParameterizationRequest=p;this._bUseMasterData=u;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;if(this._oParameterizationRequest!=null&&this._bUseMasterData==true){throw"LIMITATION: parameterized master data entity sets are not yet implemented";}if(this._bUseMasterData){this._oEntitySet=this._oDimension.getMasterDataEntitySet();}else{this._oEntitySet=this._oDimension.getContainingQueryResult().getEntitySet();if(this._oDimension.getContainingQueryResult().getParameterization()&&!this._oParameterizationRequest){throw"Missing parameterization request";}}},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},includeDimensionTextAttributes:function(i,I){this._oValueSetResult.text={text:false,attributes:false};if(i==true){this._oValueSetResult.text=true;}if(I==true){this._oValueSetResult.attributes=true;}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oEntitySet.getEntityType();var m=this._oDimension.getContainingQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){this._oSortExpression=new o.SortExpression(this._oEntityType.getModel(),this._oEntityType.getSchema(),this._oEntityType);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i){if(i!=null){this._bIncludeCount=i;}},setResultPageBoundaries:function(s,a){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(a!==null&&typeof a!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(a==null?s:a)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(a!=null)?(a-s+1):null;},getResultPageBoundaries:function(){var E=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){E=1;}else{E=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:E};},getURIQueryOptionValue:function(q){var Q=null;switch(q){case"$select":{var s="";var E=this._oEntitySet.getEntityType();var K=E.getKeyProperties();var a=[];if(this._bUseMasterData){for(var i=-1,b;(b=K[++i])!==undefined;){s+=(s==""?"":",")+b;var f=E.getTextPropertyOfProperty(b);if(f){if(this._oValueSetResult.text==true){s+=","+f.name;}a.push(f.name);}}}else{s+=(s==""?"":",")+this._oDimension.getKeyProperty().name;if(this._oValueSetResult.text==true&&this._oDimension.getTextProperty()){s+=(s==""?"":",")+this._oDimension.getTextProperty().name;}}if(this._oValueSetResult.attributes){if(this._bUseMasterData){var g=E.getProperties();for(var p in g){var I=false;for(var j=-1,h;(h=K[++j])!==undefined;){if(p==h){I=true;break;}}if(I){continue;}for(var k=-1,m;(m=a[++k])!==undefined;){if(p==m){I=true;break;}}if(!I){s+=","+p;}}}else{var n=this._oDimension.getAllAttributeNames();for(var l=-1,r;(r=n[++l])!==undefined;){s+=(s==""?"":",")+this._oDimension.findAttributeByName(r).getName();}}}Q=(s?s:null);break;}case"$filter":{var t=null;if(this._oFilterExpression){t=this._oFilterExpression.getURIFilterOptionValue();}Q=(t?t:null);break;}case"$orderby":{var u=null;if(this._oSortExpression){u=this._oSortExpression.getURIOrderByOptionValue();}Q=(u?u:null);break;}case"$top":{if(this._iTopRequestOption!==null){Q=this._iTopRequestOption;}break;}case"$skip":{Q=this._iSkipRequestOption;break;}case"$inlinecount":{Q=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return Q;},getURIToDimensionMemberEntitySet:function(s){var r=null;if(!this._bUseMasterData&&this._oParameterizationRequest){r=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oDimension.getContainingQueryResult().getParameterization().getNavigationPropertyToQueryResult();}else{r=(s?s:"")+"/"+this._oEntitySet.getQName();}return r;},getURIToDimensionMemberEntries:function(s){var r=this.getURIToDimensionMemberEntitySet(s);this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var g=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var q=false;if(a){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}if(this._iTopRequestOption&&t){if(!q){u+="?";q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&g){if(!q){u+="?";q=true;}else{u+="&";}u+="$skip="+g;}if(this._bIncludeCount&&i){if(!q){u+="?";q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oDimension:null,_oParameterizationRequest:null,_oEntitySet:null,_bUseMasterData:false,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null,_bIncludeCount:null,_iSkipRequestOption:0,_iTopRequestOption:null};return o;},true);
