/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/BindingMode','sap/ui/base/BindingParser','sap/ui/model/Context','sap/ui/base/ManagedObject','sap/ui/model/ClientContextBinding','sap/ui/model/FilterProcessor','sap/ui/model/json/JSONModel','sap/ui/model/json/JSONListBinding','sap/ui/model/json/JSONPropertyBinding','sap/ui/model/json/JSONTreeBinding','sap/ui/model/MetaModel','./_ODataMetaModelUtils','sap/ui/performance/Measurement','sap/base/Log','sap/base/util/extend','sap/base/util/isEmptyObject'],function(B,a,C,M,b,F,J,c,d,e,f,U,g,L,h,k){"use strict";var o="sap.ui.model.odata.ODataMetaModel",p=[o],P=o+"/load",r=/^((\/dataServices\/schema\/\d+)\/(?:complexType|entityType)\/\d+)\/property\/\d+$/;var O=c.extend("sap.ui.model.odata.ODataMetaListBinding"),R=M.extend("sap.ui.model.odata._resolver",{metadata:{properties:{any:"any"}}});O.prototype.applyFilter=function(){var t=this,i=F.combineFilters(this.aFilters,this.aApplicationFilters);this.aIndices=F.apply(this.aIndices,i,function(v,s){return s==="@sapui.name"?v:t.oModel.getProperty(s,t.oList[v]);},this.mNormalizeCache);this.iLength=this.aIndices.length;};var l=f.extend("sap.ui.model.odata.ODataMetaModel",{constructor:function(m,A,i){var t=this;function j(){var D;if(t.bDestroyed){throw new Error("Meta model already destroyed");}g.average(P,"",p);D=JSON.parse(JSON.stringify(m.getServiceMetadata()));t.oModel=new J(D);t.oModel.setDefaultBindingMode(t.sDefaultBindingMode);U.merge(A?A.getAnnotationsData():{},D,t);g.end(P);}i=i||{};f.apply(this);this.oModel=null;this.mContext2Promise={};this.sDefaultBindingMode=B.OneTime;this.oLoadedPromise=i.annotationsLoadedPromise?i.annotationsLoadedPromise.then(j):new Promise(function(n,q){j();n();});this.oMetadata=m;this.oODataModelInterface=i;this.mQueryCache={};this.mQName2PendingRequest={};this.oResolver=undefined;this.mSupportedBindingModes={"OneTime":true};}});l.prototype._getObject=function(s,j){var m=j,n,q,i,E,N,v,t,u=s||"",w;if(!j||j instanceof C){u=this.resolve(s||"",j);if(!u){L.error("Invalid relative path w/o context",s,o);return null;}}if(u.charAt(0)==="/"){m=this.oModel._getObject("/");u=u.slice(1);}t="/";N=m;while(u){v=undefined;n=undefined;if(u.charAt(0)==='['){try{w=a.parseExpression(u,1);E=w.at;if(u.length===E+1||u.charAt(E+1)==='/'){n=w.result;v=u.slice(0,E+1);u=u.slice(E+2);}}catch(x){if(!(x instanceof SyntaxError)){throw x;}}}if(v===undefined){E=u.indexOf("/");if(E<0){v=u;u="";}else{v=u.slice(0,E);u=u.slice(E+1);}}if(!N){if(L.isLoggable(L.Level.WARNING,o)){L.warning("Invalid part: "+v,"path: "+s+", context: "+(j instanceof C?j.getPath():j),o);}break;}if(n){if(m===j){L.error("A query is not allowed when an object context has been given",s,o);return null;}if(!Array.isArray(N)){L.error("Invalid query: '"+t+"' does not point to an array",s,o);return null;}q=t+v;v=this.mQueryCache[q];if(v===undefined){this.oResolver=this.oResolver||new R({models:this.oModel});for(i=0;i<N.length;i+=1){this.oResolver.bindObject(t+i);this.oResolver.bindProperty("any",n);try{if(this.oResolver.getAny()){this.mQueryCache[q]=v=i;break;}}finally{this.oResolver.unbindProperty("any");this.oResolver.unbindObject();}}}}N=N[v];t=t+v+"/";}return N;};l.prototype._mergeMetadata=function(i){var E=this.getODataEntityContainer(),m=U.getChildAnnotations(i.annotations,E.namespace+"."+E.name,true),j=E.entitySet.length,s=this.oModel.getObject("/dataServices/schema"),t=this;i.entitySets.forEach(function(n){var q,S,T=n.entityType,N=T.slice(0,T.lastIndexOf("."));if(!t.getODataEntitySet(n.name)){E.entitySet.push(JSON.parse(JSON.stringify(n)));if(!t.getODataEntityType(T)){q=t.oMetadata._getEntityTypeByName(T);S=U.getSchema(s,N);S.entityType.push(JSON.parse(JSON.stringify(q)));U.visitParents(S,i.annotations,"entityType",U.visitEntityType,S.entityType.length-1);}}});U.visitChildren(E.entitySet,m,"EntitySet",s,null,j);};l.prototype._sendBundledRequest=function(){var q=this.mQName2PendingRequest,Q=Object.keys(q),t=this;if(!Q.length){return;}this.mQName2PendingRequest={};Q=Q.sort();Q.forEach(function(s,i){Q[i]=encodeURIComponent(s);});this.oODataModelInterface.addAnnotationUrl("$metadata?sap-value-list="+Q.join(",")).then(function(i){var s;t._mergeMetadata(i);for(s in q){try{q[s].resolve(i);}catch(E){q[s].reject(E);}}},function(E){var s;for(s in q){q[s].reject(E);}});};l.prototype.bindContext=function(s,i,m){return new b(this,s,i,m);};l.prototype.bindList=function(s,i,S,j,m){return new O(this,s,i,S,j,m);};l.prototype.bindProperty=function(s,i,m){return new d(this,s,i,m);};l.prototype.bindTree=function(s,i,j,m){return new e(this,s,i,j,m);};l.prototype.destroy=function(){f.prototype.destroy.apply(this,arguments);return this.oModel&&this.oModel.destroy.apply(this.oModel,arguments);};l.prototype.getMetaContext=function(s){var A,E,i,j,m,n,q,t,Q;function u(S){var v=S.indexOf("(");return v>=0?S.slice(0,v):S;}if(!s){return null;}t=s.split("/");if(t[0]!==""){throw new Error("Not an absolute path: "+s);}t.shift();q=u(t[0]);E=this.getODataEntitySet(q);if(E){Q=E.entityType;}else{j=this.getODataFunctionImport(q);if(j){if(t.length===1){m=this.getODataFunctionImport(q,true);}Q=j.returnType;if(Q.lastIndexOf("Collection(",0)===0){Q=Q.slice(11,-1);}}else{throw new Error("Entity set or function import not found: "+q);}}t.shift();while(t.length){i=this.getODataEntityType(Q);if(i){n=u(t[0]);A=this.getODataAssociationEnd(i,n);}else{i=this.getODataComplexType(Q);}if(A){Q=A.type;if(A.multiplicity==="1"&&n!==t[0]){throw new Error("Multiplicity is 1: "+t[0]);}t.shift();}else{m=this.getODataProperty(i,t,true);if(t.length){throw new Error("Property not found: "+t.join("/"));}break;}}m=m||this.getODataEntityType(Q,true);return this.createBindingContext(m);};l.prototype.getODataAssociationEnd=function(E,n){var N=E?U.findObject(E.navigationProperty,n):null,A=N?U.getObject(this.oModel,"association",N.relationship):null,i=A?U.findObject(A.end,N.toRole,"role"):null;return i;};l.prototype.getODataAssociationSetEnd=function(E,n){var A,i=null,j=this.getODataEntityContainer(),N=E?U.findObject(E.navigationProperty,n):null;if(j&&N){A=U.findObject(j.associationSet,N.relationship,"association");i=A?U.findObject(A.end,N.toRole,"role"):null;}return i;};l.prototype.getODataComplexType=function(q,A){return U.getObject(this.oModel,"complexType",q,A);};l.prototype.getODataEntityContainer=function(A){var v=A?undefined:null,s=this.oModel.getObject("/dataServices/schema");if(s){s.forEach(function(S,i){var j=U.findIndex(S.entityContainer,"true","isDefaultEntityContainer");if(j>=0){v=A?"/dataServices/schema/"+i+"/entityContainer/"+j:S.entityContainer[j];return false;}});if(!v&&s.length===1&&s[0].entityContainer&&s[0].entityContainer.length===1){v=A?"/dataServices/schema/0/entityContainer/0":s[0].entityContainer[0];}}return v;};l.prototype.getODataEntitySet=function(n,A){return U.getFromContainer(this.getODataEntityContainer(),"entitySet",n,A);};l.prototype.getODataEntityType=function(q,A){return U.getObject(this.oModel,"entityType",q,A);};l.prototype.getODataFunctionImport=function(n,A){var i=n&&n.indexOf('/')>=0?n.split('/'):undefined,E=i?U.getObject(this.oModel,"entityContainer",i[0]):this.getODataEntityContainer();return U.getFromContainer(E,"functionImport",i?i[1]:n,A);};l.prototype.getODataProperty=function(t,n,A){var i,j=Array.isArray(n)?n:[n],m=null,s;while(t&&j.length){i=U.findIndex(t.property,j[0]);if(i<0){break;}j.shift();m=t.property[i];s=t.$path+"/property/"+i;if(j.length){t=this.getODataComplexType(m.type);}}return A?s:m;};l.prototype.getODataValueLists=function(i){var j=false,m,s=i.getPath(),n=this.mContext2Promise[s],t=this;if(n){return n;}m=r.exec(s);if(!m){throw new Error("Unsupported property context with path "+s);}n=new Promise(function(q,u){var v=i.getObject(),Q,V=U.getValueLists(v);if(!(""in V)&&v["sap:value-list"]&&t.oODataModelInterface.addAnnotationUrl){j=true;Q=t.oModel.getObject(m[2]).namespace+"."+t.oModel.getObject(m[1]).name;t.mQName2PendingRequest[Q+"/"+v.name]={resolve:function(w){h(v,(w.annotations.propertyAnnotations[Q]||{})[v.name]);V=U.getValueLists(v);if(k(V)){u(new Error("No value lists returned for "+s));}else{delete t.mContext2Promise[s];q(V);}},reject:u};setTimeout(t._sendBundledRequest.bind(t),0);}else{q(V);}});if(j){this.mContext2Promise[s]=n;}return n;};l.prototype.getProperty=function(){return this._getObject.apply(this,arguments);};l.prototype.isList=function(){return this.oModel.isList.apply(this.oModel,arguments);};l.prototype.loaded=function(){return this.oLoadedPromise;};l.prototype.refresh=function(){throw new Error("Unsupported operation: ODataMetaModel#refresh");};l.prototype.setLegacySyntax=function(i){if(i){throw new Error("Legacy syntax not supported by ODataMetaModel");}};l.prototype.setProperty=function(){throw new Error("Unsupported operation: ODataMetaModel#setProperty");};return l;});
