/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ODataAnnotations","./ODataContextBinding","./ODataListBinding","./ODataTreeBinding","sap/base/assert","sap/base/Log","sap/base/security/encodeURL","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/uid","sap/base/util/UriParameters","sap/ui/core/library","sap/ui/core/message/Message","sap/ui/core/message/MessageParser","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/FilterProcessor","sap/ui/model/Model","sap/ui/model/odata/CountMode","sap/ui/model/odata/MessageScope","sap/ui/model/odata/ODataMetadata","sap/ui/model/odata/ODataMetaModel","sap/ui/model/odata/ODataMessageParser","sap/ui/model/odata/ODataPropertyBinding","sap/ui/model/odata/ODataUtils","sap/ui/model/odata/OperationMode","sap/ui/model/odata/UpdateMethod","sap/ui/thirdparty/datajs","sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI"],function(O,a,b,c,d,L,e,f,g,h,l,m,u,U,o,M,p,B,C,F,q,r,s,t,v,w,x,y,z,A,D,Q,E){"use strict";var G="sap.ui.model.odata.v2.ODataModel",H=o.MessageType,I={};I[H.Error]=0;I[H.Warning]=1;I[H.Success]=2;I[H.Information]=3;I[H.None]=4;var J=q.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(S,P){q.apply(this,arguments);var i,j,k,T,W,n,N,R,V,X,Y,Z,$,_,a1,b1,c1,d1,e1,f1,g1,h1,i1,j1,k1,l1,m1,n1,o1,p1,q1=this;if(typeof(S)==="object"){P=S;S=P.serviceUrl;}if(P){i=P.user;j=P.password;k=P.headers;T=P.tokenHandling;W=P.withCredentials;n=P.maxDataServiceVersion;N=P.useBatch;R=P.refreshAfterChange;V=P.annotationURI;X=P.loadAnnotationsJoined;$=P.defaultBindingMode;Y=P.defaultCountMode;Z=P.preliminaryContext;_=P.defaultOperationMode;a1=P.metadataNamespaces;b1=P.serviceUrlParams;c1=P.metadataUrlParams;d1=P.json;e1=P.messageParser;f1=P.skipMetadataAnnotationParsing;g1=P.defaultUpdateMethod;h1=P.disableHeadRequestForToken;i1=P.sequentializeRequests;j1=P.disableSoftStateHeader;k1=P.bindableResponseHeaders;l1=P.warmupUrl;m1=P.canonicalRequests;n1=P.tokenHandlingForGet;o1=P.earlyTokenRequest;p1=P.persistTechnicalMessages;}this.mPathCache={};this.mInvalidatedPaths={};this.bCanonicalRequests=!!m1;this.bTokenHandlingForGet=!!n1;this.sMessageScope=s.RequestedObjects;this.sWarmupUrl=l1;this.bWarmup=!!l1;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.sDefaultBindingMode=$||B.OneWay;this.bIsMessageScopeSupported=false;this.iPendingDeferredRequests=0;this.bJSON=d1!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=g1||A.Merge;this.bTokenHandling=T!==false;this.bWithCredentials=W===true;this.bUseBatch=N!==false;this.bRefreshAfterChange=R!==false;this.sMaxDataServiceVersion=n;this.bLoadAnnotationsJoined=X!==false;this.sAnnotationURI=V;this.sDefaultCountMode=Y||r.Request;this.sDefaultOperationMode=_||z.Default;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!f1;this.bDisableHeadRequestForToken=!!h1;this.bSequentializeRequests=!!i1;this.bDisableSoftStateHeader=!!j1;this.aBindableResponseHeaders=k1?k1:null;this.bPreliminaryContext=Z||false;this.mMetadataUrlParams=c1||{};this.mChangedEntities4checkUpdate={};this.bPersistTechnicalMessages=p1===undefined?undefined:!!p1;if(e1){e1.setProcessor(this);}this.oMessageParser=e1;this.sDefaultChangeGroup="changes";this.setDeferredGroups([this.sDefaultChangeGroup]);this.setChangeGroups({"*":{groupId:this.sDefaultChangeGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();this.sServiceUrl=S;var r1=S.split("?");if(r1.length>1){this.sServiceUrl=r1[0];if(r1[1]){this.aUrlParams.push(r1[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=i;this.sPassword=j;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(k);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header";}var s1=this._getServerUrl();var t1=this.sWarmupUrl||this._createMetadataUrl("/$metadata");this.oSharedServerData=J._getSharedData("server",s1);this.oSharedServiceData=J._getSharedData("service",this.sServiceUrl);this.oSharedMetaData=J._getSharedData("meta",t1);this.bUseCache=this._cacheSupported(t1);if(!this.oSharedMetaData.oMetadata||this.oSharedMetaData.oMetadata.bFailed){this.oMetadata=new t(t1,{async:true,cacheKey:this.bUseCache?t1:undefined,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:a1,withCredentials:this.bWithCredentials});if(!this.bWarmup){this.oSharedMetaData.oMetadata=this.oMetadata;}}else{this.oMetadata=this.oSharedMetaData.oMetadata;}this.oAnnotations=new O(this.oMetadata,{source:this.sAnnotationURI,skipMetadata:this.bSkipMetadataAnnotationParsing,headers:this.mCustomHeaders,combineEvents:true,cacheKey:this._getAnnotationCacheKey(t1),useCache:this.bUseCache});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"];}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(b1){this.aUrlParams=this.aUrlParams.concat(y._createUrlParamsArray(b1));}this.onMetadataFailed=function(u1){q1.fireMetadataFailed(u1.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed);}this.oMetadata.loaded().then(function(){q1._initializeMetadata();});if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";}if(this.bTokenHandling){if(this.oSharedServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}else if(this.oSharedServerData.securityToken){this.oSharedServiceData.securityToken=this.oSharedServerData.securityToken;this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}if(o1){this.securityTokenAvailable();}}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","getPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});J.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};J.prototype.attachBatchRequestFailed=function(i,j,k){this.attachEvent("batchRequestFailed",i,j,k);return this;};J.prototype.detachBatchRequestFailed=function(i,j){this.detachEvent("batchRequestFailed",i,j);return this;};J.prototype.fireBatchRequestFailed=function(P){this.fireEvent("batchRequestFailed",P);return this;};J.prototype.attachBatchRequestSent=function(i,j,k){this.attachEvent("batchRequestSent",i,j,k);return this;};J.prototype.detachBatchRequestSent=function(i,j){this.detachEvent("batchRequestSent",i,j);return this;};J.prototype.fireBatchRequestSent=function(P){this.fireEvent("batchRequestSent",P);return this;};J.prototype.attachBatchRequestCompleted=function(i,j,k){this.attachEvent("batchRequestCompleted",i,j,k);return this;};J.prototype.detachBatchRequestCompleted=function(i,j){this.detachEvent("batchRequestCompleted",i,j);return this;};J.prototype.fireBatchRequestCompleted=function(P){this.fireEvent("batchRequestCompleted",P);return this;};J.mSharedData={server:{},service:{},meta:{}};J._getSharedData=function(S,k){var i=this.mSharedData[S][k];if(!i){i={};this.mSharedData[S][k]=i;}return i;};J.prototype._initializeMetadata=function(){if(this.bDestroyed){return;}this.bIsMessageScopeSupported=this.oMetadata._isMessageScopeSupported();var i=function(){this.fireMetadataLoaded({metadata:this.oMetadata});L.debug(this+" - metadataloaded fired");}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(i,this.fireMetadataFailed.bind(this));}else{i();}};J.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};J.prototype.fireAnnotationsLoaded=function(P){this.fireEvent("annotationsLoaded",P);return this;};J.prototype.attachAnnotationsLoaded=function(i,j,k){this.attachEvent("annotationsLoaded",i,j,k);return this;};J.prototype.detachAnnotationsLoaded=function(i,j){this.detachEvent("annotationsLoaded",i,j);return this;};J.prototype.fireAnnotationsFailed=function(P){this.fireEvent("annotationsFailed",P);L.debug(this+" - annotationsfailed fired");return this;};J.prototype.attachAnnotationsFailed=function(i,j,k){this.attachEvent("annotationsFailed",i,j,k);return this;};J.prototype.detachAnnotationsFailed=function(i,j){this.detachEvent("annotationsFailed",i,j);return this;};J.prototype.fireMetadataLoaded=function(P){this.fireEvent("metadataLoaded",P);return this;};J.prototype.attachMetadataLoaded=function(i,j,k){this.attachEvent("metadataLoaded",i,j,k);return this;};J.prototype.detachMetadataLoaded=function(i,j){this.detachEvent("metadataLoaded",i,j);return this;};J.prototype.fireMetadataFailed=function(P){this.fireEvent("metadataFailed",P);return this;};J.prototype.attachMetadataFailed=function(i,j,k){this.attachEvent("metadataFailed",i,j,k);return this;};J.prototype.detachMetadataFailed=function(i,j){this.detachEvent("metadataFailed",i,j);return this;};J.prototype._createEventInfo=function(R,k,n){var N={};N.url=R.requestUri;N.method=R.method;N.async=R.async;N.headers=R.headers;if(n){N.requests=[];for(var i=0;i<n.length;i++){var P={};if(Array.isArray(n[i])){var S=n[i];for(var j=0;j<S.length;j++){var R=S[j].request;var T=n[i][j].response;P={};P.url=R.requestUri;P.method=R.method;P.headers=R.headers;if(T){P.response={};if(R._aborted){P.success=false;P.response.statusCode=0;P.response.statusText="abort";}else{P.success=true;if(T.message){P.response.message=T.message;T=T.response;P.response.responseText=T.body;P.success=false;}P.response.headers=T.headers;P.response.statusCode=T.statusCode;P.response.statusText=T.statusText;}}N.requests.push(P);}}else{var R=n[i].request;var T=n[i].response;P.url=R.requestUri;P.method=R.method;P.headers=R.headers;if(T){P.response={};if(R._aborted){P.success=false;P.response.statusCode=0;P.response.statusText="abort";}else{P.success=true;if(T.message){P.response.message=T.message;T=T.response;P.response.responseText=T.body;P.success=false;}P.response.headers=T.headers;P.response.statusCode=T.statusCode;P.response.statusText=T.statusText;}}N.requests.push(P);}}}if(k){N.response={};N.success=true;if(k.message){N.response.message=k.message;N.success=false;}if(k.response){k=k.response;}if(k&&k.statusCode!=undefined){N.response.headers=k.headers;N.response.statusCode=k.statusCode;N.response.statusText=k.statusText;N.response.responseText=k.body!==undefined?k.body:k.responseText;if(k.expandAfterCreateFailed){N.response.expandAfterCreateFailed=true;}if(k.expandAfterFunctionCallFailed){N.response.expandAfterFunctionCallFailed=true;}}}N.ID=R.requestID;return N;};J.prototype._createRequestID=function(){var R;R=u();return R;};J.prototype._getServerUrl=function(){var S,i;S=new E(this.sServiceUrl).absoluteTo(document.baseURI);i=new E("/").absoluteTo(S).toString();return i;};J.prototype._createMetadataUrl=function(i){if(i.indexOf(this.sServiceUrl)==-1){if(!i.startsWith("/")){i="/"+i;}i=this.sServiceUrl+i;}var j=U.fromURL(i||window.location.href);var k=Object.assign({},this.mMetadataUrlParams);Array.from(j.keys()).forEach(function(P){k[P]=j.get(P);});var n=y._createUrlParamsArray(k);var N=i.split("?");if(N.length>1){i=N[0];}return this._addUrlParams(i,n);};J.prototype._addUrlParams=function(i,j){var k=[];if(this.aUrlParams){k=k.concat(this.aUrlParams);}if(j){k=k.concat(j);}if(k&&k.length>0){i+="?"+k.join("&");}return i;};J.prototype._createRequestUrl=function(P,i,j,k){return this._createRequestUrlWithNormalizedPath(this._normalizePath(P,i),j,k);};J.prototype._createRequestUrlWithNormalizedPath=function(n,i,j){var k="";if(!j){k=this.sServiceUrl+n;}else{k=n.substr(n.indexOf('/')+1);}return this._addUrlParams(k,i);};J.prototype._importData=function(j,k,R,P,n,N,S,T){var V=this,W,X,Y,Z;P=P||"";N=N||"";if(j.results&&Array.isArray(j.results)){W=[];g(j.results,function(i,e1){var N=V._getKey(e1);N=V._importData(e1,k,R,P.substr(0,P.lastIndexOf("/")),n,N);if(N){W.push(N);}});return W;}else{if(N){P="/"+N;n+=N.substr(N.indexOf("("));}else{N=this._getKey(j);}if(!N){return N;}Y=this._getEntity(N);Z=Y;if(!Y||(Y.__metadata&&Y.__metadata.invalid)){if(!Z){Z=j;}Y=j;N=this._addEntity(Y);}if(this.aBindableResponseHeaders){var $={};for(var _ in R.headers){var a1=_.toLowerCase();if(this.aBindableResponseHeaders.indexOf(a1)>-1){$[a1]=R.headers[_];}}if(!h($)){if(!j.__metadata){j.__metadata={};}j.__metadata.headers=$;}}g(j,function(i,e1){if(e1&&(e1.__metadata&&e1.__metadata.uri||e1.results)&&!e1.__deferred){var f1=P+"/"+i;var g1=n+"/"+i;X=V._importData(e1,k,R,f1,g1,undefined,false,"/"+N+"/"+i);if(Array.isArray(X)){Y[i]={__list:X};}else{if(Z[i]&&Z[i].__ref){if(Z[i].__ref!==X){V.mInvalidatedPaths[P.substr(P.lastIndexOf("("))+"/"+i]="/"+X;}}Y[i]={__ref:X};}}else if(!e1||!e1.__deferred){if(Z[i]&&e1===null){V.mInvalidatedPaths[P.substr(P.lastIndexOf("("))+"/"+i]=null;}Y[i]=e1;}});var b1={};b1[N]=Y;if(this.hasContext("/"+N)&&this.getContext("/"+N).isPreliminary()){var c1=this.getContext("/"+N);c1.setUpdated(true);c1.setPreliminary(false);}this._updateChangedEntities(b1);k[N]=true;P=P||'/'+N;n=n||P;var d1=this.resolveFromCache(n);if(d1==="/"+N||(d1&&d1.split("/").length>2)){this._writePathCache(d1,"/"+N,S);}this._writePathCache(P,"/"+N,S);this._writePathCache(n,"/"+N,S,true);if(T){this._writePathCache(T,"/"+N,S);}return N;}};J.prototype._writePathCache=function(P,i,j,k){var n,N,R,S,T,V;if(P&&i){if(!this.mPathCache[P]){this.mPathCache[P]={};}if(!j&&P.lastIndexOf("/")===0){i=P;}this.mPathCache[P].canonicalPath=i;if(k){T=P.split("/");for(V=3;V<T.length;V+=1){R=T.slice(0,V).join("/");S=this.mPathCache[R];if(S){n=S.canonicalPath+P.slice(R.length);N=this.mPathCache[n];if(N){N.canonicalPath=i;}}}}}};J.prototype._removeReferences=function(j){var k=this,n;if(!j){return j;}if(j.results){n=[];g(j.results,function(i,N){n.push(k._removeReferences(N));});return n;}else{g(j,function(P,i){if(i){if(i["__ref"]||i["__list"]){delete j[P];}}});return j;}};J.prototype._restoreReferences=function(j,V){var k=this,n,N,R;function P(n){var N=V[n];if(!N){N=k._getObject("/"+n);d(N,"ODataModel inconsistent: "+n+" not found!");if(N){N=m({},N);V[n]=N;k._restoreReferences(N,V);}}return N;}if(!V){V={};}g(j,function(S,T){if(T){if(T.__ref){n=T.__ref;N=P(n);if(N){j[S]=N;}delete T.__ref;}else if(T.__list){R=[];g(T.__list,function(i,n){N=P(n);if(N){R.push(N);}});delete T.__list;T.results=R;}}});return j;};J.prototype.removeData=function(){this.oData={};};J.prototype.initialize=function(){var i=this.getBindings();i.forEach(function(j){j.initialize();});};J.prototype.invalidate=function(i){var j;for(var k in this.oData){j=this.oData[k];if(!i||i(k,j)){j.__metadata.invalid=true;}}};J.prototype.invalidateEntry=function(i){var j;if(typeof i==="string"){if(i.indexOf("/")===0){j=this._getObject(i);}else{j=this.oData[i];}}else if(i instanceof C){j=this._getObject(i.getPath());}if(j&&j.__metadata){j.__metadata.invalid=true;}};J.prototype.invalidateEntityType=function(i){var j;for(var k in this.oData){j=this.oData[k];if(j.__metadata.type===i){j.__metadata.invalid=true;}}};J.prototype.refresh=function(i,R,j){if(typeof i==="string"){j=i;i=false;R=false;}if(R){this.removeData();}this._refresh(i,j);};J.prototype._refresh=function(i,j,k,n){var N=this.getBindings();this.sRefreshGroupId=j;N.forEach(function(P){P._refresh(i,k,n);});this.sRefreshGroupId=undefined;};J.prototype.checkUpdate=function(i,j,k,n){if(j){this.bForceUpdate=this.bForceUpdate||i;Object.assign(this.mChangedEntities4checkUpdate,k);if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(this.bForceUpdate,false,this.mChangedEntities4checkUpdate);}.bind(this),0);}return;}if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;this.bForceUpdate=undefined;this.mChangedEntities4checkUpdate={};}var N=this.getBindings();N.forEach(function(P){if(!n||this.isMetaModelPath(P.getPath())){P.checkUpdate(i,k);}}.bind(this));this._processAfterUpdate();};J.prototype.checkDataState=function(i){var j=this.getBindings();j.forEach(function(k){if(k.checkDataState){k.checkDataState(i);}});};J.prototype.bindProperty=function(P,i,j){var k=new x(this,P,i,j);return k;};J.prototype.bindList=function(P,i,S,j,k){var n=new b(this,P,i,S,j,k);return n;};J.prototype.bindTree=function(P,i,j,k,S){var n=new c(this,P,i,j,k,S);return n;};J.prototype.createBindingContext=function(P,i,j,k,R){var n,N,S,T,V,W=this,X;if(i!==null&&typeof i==="object"&&!(i instanceof sap.ui.model.Context)){R=k;k=j;j=i;i=undefined;}if(typeof i=="function"){R=j;k=i;j=undefined;i=undefined;}if(typeof i=="boolean"){R=i;k=undefined;j=undefined;i=undefined;}if(typeof j=="function"){R=k;k=j;j=undefined;}if(typeof j=="boolean"){R=j;k=undefined;j=undefined;}if(typeof k=="boolean"){R=k;k=undefined;}if(j){X=j.canonicalRequest;}X=this._isCanonicalRequestNeeded(X);n=this.resolve(P,i,X);if(!n&&X){n=this.resolve(P,i);}V=this.resolveDeep(P,i);if(!n){if(k){k(null);}return null;}if(R===undefined){R=this._isReloadNeeded(n,j);}if(!R){N=this.resolve(P,i,true);if(N){S=this.getContext(N,V);}else{S=null;}if(k){k(S);}return S;}function Y(b1){var c1=b1?W._getKey(b1):null,d1=!(P===""||P.indexOf("/")>0),e1=null,f1,g1;S=null;if(c1){S=W.getContext('/'+c1,V);e1={__ref:c1};}if(i&&$&&d1){f1=i.getPath();f1=f1.substr(1);g1=W._getEntity(f1);if(g1){g1[P]=e1;}}k(S);}function Z(b1){var c1;if(b1.statusCode=='404'&&i&&$){var d1=i.getPath();d1=d1.substr(1);c1=W._getEntity(d1);if(c1){c1[P]={__ref:null};}}k(null);}if(k){var $=!P.startsWith("/");if(n){var _=[],a1=this.createCustomParams(j);if(a1){_.push(a1);}if(j&&(j.batchGroupId||j.groupId)){T=j.groupId||j.batchGroupId;}this.read(P,{canonicalRequest:X,context:i,error:Z,groupId:T,success:Y,updateAggregatedMessages:true,urlParameters:_});}else{k(null);}}if(j&&j.createPreliminaryContext){n=this.resolve(P,i,X);if(!n&&X){n=this.resolve(P,i);}S=this.getContext(n,V);return S;}};J.prototype._updateContext=function(i,P){if(!P.startsWith("/")){throw new Error("Path "+P+" must start with a / ");}i.sPath=P;this.mContexts[P]=i;};J.prototype._splitEntries=function(i){return i.replace(/\s/g,"").split(',').map(function(j){return j.split("/");});};J.prototype._filterOwnSelect=function(S,i){var j,k;if(!i){return[];}k=i.map(function(P){return P.name;});j=S.filter(function(n){return n.length===1;}).map(function(n){return n[0];});if(S.length===0||j.indexOf("*")!==-1||j.indexOf("**")!==-1){return k;}else{return j.filter(function(n){return k.indexOf(n)!==-1;});}};J.prototype._filterOwnExpand=function(i,S){return i.map(function(j){return j[0];}).filter(function(V,j,k){return k.indexOf(V)===j;}).filter(function(V){return S.length===0||S.some(function(j){return j.indexOf(V)===0||j.indexOf("**")===0;});});};J.prototype._filterSelectByNavProp=function(i,n){return i.filter(function(S){return S[0]===n;}).map(function(S){return S.length>1?S.slice(1):["**"];});};J.prototype._filterExpandByNavProp=function(i,n){return i.filter(function(S){return S.length>1&&S[0]===n;}).map(function(S){return S.slice(1);});};J.prototype._isReloadNeeded=function(P,k){var n=this,N=this.oMetadata,R,S=this._getObject(P),T=[],V=[];if(!this.oMetadata.isLoaded()){return true;}R=this.oMetadata._getEntityTypeByPath(P);if(this._isCreatedEntity(S)){return false;}function W(R,S,V,T){var X,Y,Z,$,_,a1,b1,c1,d1;if(!R){return false;}if(S===null){return false;}if(!S){return true;}if(S.__metadata&&S.__metadata.invalid){return true;}X=n._filterOwnSelect(V,R.property);for(var i=0;i<X.length;i++){d1=X[i];if(S[d1]===undefined){return true;}}Y=n._filterOwnExpand(T,V);for(var i=0;i<Y.length;i++){c1=Y[i];Z=S[c1];if(Z===null){continue;}if(Z===undefined||Z.__deferred){return true;}$=N._getEntityTypeByNavProperty(R,c1);a1=n._filterSelectByNavProp(V,c1);b1=n._filterExpandByNavProp(T,c1);if(Z.__ref){_=n._getEntity(Z.__ref);if(W($,_,a1,b1)){return true;}}if(Z.__list){for(var j=0;j<Z.__list.length;j++){_=n._getEntity(Z.__list[j]);if(W($,_,a1,b1)){return true;}}}}return false;}if(k){if(k.select){V=this._splitEntries(k.select);}if(k.expand){T=this._splitEntries(k.expand);}}return W(R,S,V,T);};J.prototype.createCustomParams=function(P){var i=[],j,S={expand:true,select:true};for(var n in P){if(n in S){i.push("$"+n+"="+e(P[n]));}if(n==="custom"){j=P[n];for(n in j){if(n.indexOf("$")===0){L.warning(this+" - Trying to set OData parameter '"+n+"' as custom query option!");}else if(typeof j[n]==='string'){i.push(n+"="+e(j[n]));}else{i.push(n);}}}}return i.join("&");};J.prototype.bindContext=function(P,i,j){var k=new a(this,P,i,j);return k;};J.prototype.setDefaultCountMode=function(i){this.sDefaultCountMode=i;};J.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};J.prototype._addEntity=function(i){var k=this._getKey(i);this.oData[k]=i;return k;};J.prototype._removeEntity=function(k){k=k&&y._normalizeKey(k);delete this.oData[k];delete this.mChangedEntities[k];delete this.mContexts["/"+k];};J.prototype._getEntity=function(k){var i=this.oData[k];if(!i){k=k&&y._normalizeKey(k);i=this.oData[k];}return i;};J.prototype._getKey=function(V){var k,i;if(V instanceof C){k=V.getPath().substr(1);}else if(V&&V.__metadata&&V.__metadata.uri){i=V.__metadata.uri;k=i.substr(i.lastIndexOf("/")+1);}else if(typeof V==='string'){k=V.substr(V.lastIndexOf("/")+1);}if(!this.oData[k]){k=k&&y._normalizeKey(k);}return k;};J.prototype.getKey=function(V){return this._getKey(V);};J.prototype.createKey=function(j,k){var n=this.oMetadata._getEntityTypeByPath(j),N=j,P=this,R,S;d(n,"Could not find entity type of collection \""+j+"\" in service metadata!");N+="(";if(n.key.propertyRef.length===1){R=n.key.propertyRef[0].name;d(R in k,"Key property \""+R+"\" is missing in object!");S=this.oMetadata._getPropertyMetadata(n,R);N+=encodeURIComponent(y.formatValue(k[R],S.type));}else{g(n.key.propertyRef,function(i,T){if(i>0){N+=",";}R=T.name;d(R in k,"Key property \""+R+"\" is missing in object!");S=P.oMetadata._getPropertyMetadata(n,R);N+=R;N+="=";N+=encodeURIComponent(y.formatValue(k[R],S.type));});}N+=")";return N;};J.prototype.getProperty=function(P,i,j){var V=this._getObject(P,i);if(!j){return V;}if(!l(V)){return V;}V=m({},V);if(j===true){return this._restoreReferences(V);}else{return this._removeReferences(V);}};J.prototype.getObject=function(P,n,N){if(l(n)){N=n;n=undefined;}var R=this,S=this.resolve(P,n),V=this._getObject(S),T=this.oMetadata._getEntityTypeByPath(S),W=[],X=[];if(!T||!l(V)||!V.__metadata||!V.__metadata.uri){return V;}if(!N||!(N.select||N.expand)){return m({},V);}function Y(T,V,X,W){var Z,$,_,a1,b1,c1,d1,e1,f1,g1,h1,i1,j1;if(!V){return undefined;}if(!T){return undefined;}_=R._filterOwnSelect(X,T.property);$={};for(var i=0;i<_.length;i++){i1=_[i];if(V[i1]!==undefined){$[i1]=V[i1];}else{L.fatal("No data loaded for select property: "+i1+" of entry: "+R.getKey(V));return undefined;}}if(V.__metadata){$.__metadata=V.__metadata;}Z=R._filterOwnExpand(W,X);for(var i=0;i<Z.length;i++){h1=Z[i];b1=V[h1];c1=R.oMetadata._getEntityTypeByNavProperty(T,h1);f1=R._filterSelectByNavProp(X,h1);g1=R._filterExpandByNavProp(W,h1);if(b1&&b1.__ref){e1=R._getObject("/"+b1.__ref);d1=Y(c1,e1,f1,g1);if(d1!==undefined){$[h1]=d1;}else{L.fatal("No data loaded for expand property: "+h1+" of entry: "+R.getKey(d1));return undefined;}}if(b1&&b1.__list){j1=[];for(var j=0;j<b1.__list.length;j++){e1=R._getObject("/"+b1.__list[j]);d1=Y(c1,e1,f1,g1);if(d1!==undefined){j1.push(d1);}else{L.fatal("No data loaded for expand property: "+h1+" of entry: "+R.getKey(d1));return undefined;}}$[h1]=j1;}}a1=R._filterOwnSelect(X,T.navigationProperty);for(var k=0;k<a1.length;k++){h1=a1[k];if(Z.indexOf(h1)===-1){var k1=$.__metadata.uri+"/"+h1;$[h1]={__deferred:{uri:k1}};}}return $;}if(N.select){X=this._splitEntries(N.select);}if(N.expand){W=this._splitEntries(N.expand);}V=Y(T,V,X,W);return V;};J.prototype._getObject=function(P,i,j){var n=this.isLegacySyntax()?this.oData:null,k,N,R,S,T,V,W,X,Y;R=this.resolve(P,i,this.bCanonicalRequests);if(!R&&this.bCanonicalRequests){R=this.resolve(P,i);}if(!R){return n;}if(this._isMetadataPath(R)){if(this.oMetadata&&this.oMetadata.isLoaded()){if(this.isMetaModelPath(R)){S=R.indexOf('/##');Y=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}T=R.substr(0,S);V=R.substr(S+3);W=Y.getMetaContext(T);n=Y.getProperty(V,W);}else{n=this.oMetadata._getAnnotation(R);}}}else{if(R==="/"){return this.oData;}var Z=R.split("/"),$=0;X=Z[1];Z.splice(0,2);k=this.mChangedEntities[X];N=this._getEntity(X);n=j?N:k||N;while(n&&Z[$]){var _=k&&k.hasOwnProperty(Z[$]);k=k&&k[Z[$]];N=N&&N[Z[$]];n=j||!_?N:k;if(n){if(n.__ref){k=this.mChangedEntities[n.__ref];N=this._getEntity(n.__ref);n=j?N:k||N;}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}$++;}}if(l(k)){n=j?N:m({},N,k);}return n;};J.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oSharedServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}}};J.prototype.resetSecurityToken=function(){delete this.oSharedServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken;};J.prototype.getSecurityToken=function(){var T=this.oSharedServiceData.securityToken;if(!T){this.refreshSecurityToken();T=this.oSharedServiceData.securityToken;}return T;};J.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oSharedServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oSharedServiceData.securityToken);}else{this.pSecurityToken=new Promise(function(i,j){this.refreshSecurityToken(function(){i(this.oSharedServiceData.securityToken);}.bind(this),function(){j();},true);}.bind(this));}}return this.pSecurityToken;};J.prototype.refreshSecurityToken=function(S,i,j){var T;var k=this;var n=this._createRequestUrlWithNormalizedPath("/");var N={abort:function(){this.request.abort();}};function P(X,Y){if(Y){T=k._getHeader("x-csrf-token",Y.headers);k._setSessionContextIdHeader(k._getHeader("sap-contextid",Y.headers));if(T){k.oSharedServerData.securityToken=T;k.oSharedServiceData.securityToken=T;k.pSecurityToken=Promise.resolve(T);k.oHeaders["x-csrf-token"]=T;}else{k.resetSecurityToken();k.bTokenHandling=false;}}if(S){S(X,Y);}}function R(X){k.resetSecurityToken();k.bTokenHandling=false;k._handleError(X);if(i){i(X);}}function V(X){N.request=W("GET",R);}function W(X,i){var Y=k._createRequest(n,"",X,k._getHeaders(undefined,true),null,null,!!j);Y.headers["x-csrf-token"]="Fetch";return k._request(Y,P,i,undefined,undefined,k.getServiceMetadata());}if(this.bDisableHeadRequestForToken){N.request=W("GET",R);}else{N.request=W("HEAD",V);}return N;};J.prototype._submitRequest=function(R,S,j){var k=this,n,N,P,T,V;T=new Promise(function(i,a1){V=i;});function W(i,a1){if(S){S(i,a1);}V();}function X(i){if(k.bTokenHandling&&i.response){var a1=k._getHeader("x-csrf-token",i.response.headers);if(!R.bTokenReset&&i.response.statusCode=='403'&&a1&&a1.toLowerCase()==="required"){k.resetSecurityToken();R.bTokenReset=true;Z();return;}}if(j){j(i);}V();}function Y(R){if(k.bTokenHandling&&(R.method!=="GET"||k.bTokenHandlingForGet)){k.pReadyForRequest=k.securityTokenAvailable();}return k.pReadyForRequest;}function Z(){if(k.bTokenHandling){delete R.headers["x-csrf-token"];}Y(R).then(function(i){if(k.bTokenHandling&&(R.method!=="GET"||k.bTokenHandlingForGet)){R.headers["x-csrf-token"]=i;}_();},function(){_();});}function $(a1,R,b1){var c1,d1=R.eventInfo.requests;if(d1){g(d1,function(i,R){if(Array.isArray(R)){R.forEach(function(R){g(R.parts,function(i,e1){c1=k._createEventInfo(R.request,e1.fnError);k["fireRequest"+a1](c1);});});}else{if(R.parts){g(R.parts,function(i,e1){c1=k._createEventInfo(R.request,e1.fnError);k["fireRequest"+a1](c1);});}else{c1=k._createEventInfo(R.request,R.fnError);k["fireRequest"+a1](c1);}}});if(R.eventInfo.batch){c1=k._createEventInfo(R,b1,d1);k["fireBatchRequest"+a1](c1);}}}function _(){if(k.sSessionContextId){R.headers["sap-contextid"]=k.sSessionContextId;}N=k._request(R,W,X,n,undefined,k.getServiceMetadata());if(R.eventInfo){$("Sent",R,null);delete R.eventInfo;}if(P){N.abort();}}n=k._getODataHandler(R.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){Z();});this.pSequentialRequestCompleted=T;}else{Z();}return{abort:function(){if(N){N.abort();}P=true;}};};J.prototype._setSessionContextIdHeader=function(S){if(S){this.sSessionContextId=S;}};J.prototype._submitSingleRequest=function(R){var j=this,k,n={},N={},P={};function S(V,W){if(V===undefined&&W.statusCode===200){T({message:"Response did not contain a valid OData result",response:W});return;}function X(V,W){for(var i=0;i<R.parts.length;i++){if(R.parts[i].request._aborted){j._processAborted(R.parts[i].request,W);}else if(R.parts[i].fnSuccess){R.parts[i].fnSuccess(V,W);}}if(R.request.requestUri.indexOf("$count")===-1){j.checkUpdate(false,false,N);if(R.bRefreshAfterChange){j._refresh(false,undefined,n,P);}}}j._processSuccess(R.request,W,X,N,n,P);j._invalidatePathCache();j._setSessionContextIdHeader(j._getHeader("sap-contextid",W.headers));}function T(V){if(V.message=="Request aborted"){for(var i=0;i<R.parts.length;i++){j._processAborted(R.parts[i].request,V);}}else{for(var i=0;i<R.parts.length;i++){j._processError(R.parts[i].request,V,R.parts[i].fnError);}}j._processAfterUpdate();}R.request.eventInfo={requests:R.parts,batch:false};k=this._submitRequest(R.request,S,T);return k;};J.prototype._submitBatchRequest=function(k,R,S,n){var N=this,P={},T={},V={},W={};function X(j,b1,c1){var d1,e1,i;for(i=0;i<j.parts.length;i++){if(c1||j.parts[i].request._aborted){N._processAborted(j.parts[i].request,b1);}else if(b1.message){N._processError(j.parts[i].request,b1,j.parts[i].fnError);}else{if(j.request.withContentID){d1=j.request.withContentID;if(j.request.created||j.request.functionMetadata){e1=N._getKey(b1.data);T[d1]={key:e1,deepPath:j.request.deepPath.replace("('"+d1+"')",e1.slice(e1.indexOf("(")))};}else{e1=T[d1].key;j.request.requestUri=j.request.requestUri.replace("$"+d1,e1);j.request.deepPath=T[d1].deepPath;}}N._processSuccess(j.parts[i].request,b1,j.parts[i].fnSuccess,V,P,W,false,undefined,T);}}}function Y(b1,c1){if(b1===undefined&&c1.statusCode===200){Z({message:"Response did not contain a valid OData batch result",response:c1});return;}var d1,e1,f1,g1=b1.__batchResponses;if(g1){var i,j;for(i=0;i<g1.length;i++){d1=g1[i];if(Array.isArray(R[i])){if(d1.message){for(j=0;j<R[i].length;j++){d1.$reported=false;e1=R[i][j];X(e1,d1);e1.response=d1;}}else{f1=d1.__changeResponses;for(j=0;j<f1.length;j++){var h1=f1[j];e1=R[i][j];X(e1,h1);e1.response=h1;}}}else{e1=R[i];X(e1,d1);e1.response=d1;}}N._invalidatePathCache();N.checkUpdate(false,false,V);}N._processSuccess(k,c1,S,V,P,W,true,R);N._setSessionContextIdHeader(N._getHeader("sap-contextid",c1.headers));}function Z(j){var b1=j.message=="Request aborted";j.$reported=true;g(R,function(i,c1){if(Array.isArray(c1)){c1.forEach(function(c1){X(c1,j,b1);});}else{X(c1,j,b1);}});N._processAfterUpdate();if(b1){N._processAborted(k,j,true);}else{j.$reported=false;N._processError(k,j,n,true,R);}}k.eventInfo={requests:R,batch:true};var $=this._submitRequest(k,Y,Z);function _(j){var n;for(var i=0;i<j.parts.length;i++){n=j.parts[i].fnError;if(!j.parts[i].request._aborted&&n){n(K);}}}var a1={abort:function(j){g(R,function(i,b1){if(Array.isArray(b1)){b1.forEach(function(b1){_(b1);});}else{_(b1);}});if(n&&!j){n(K);}$.abort();}};return a1;};J.prototype._invalidatePathCache=function(){var i=this,j;if(Object.keys(this.mInvalidatedPaths).length>0){Object.keys(this.mPathCache).forEach(function(k){for(var n in i.mInvalidatedPaths){j=k.indexOf(n);if(j>-1){if(j+n.length!==k.length){var N=k.substr(j+n.length);i.mPathCache[k].canonicalPath=i.mInvalidatedPaths[n]===null?null:i.mInvalidatedPaths[n]+N;}else{i.mPathCache[k].canonicalPath=i.mInvalidatedPaths[n];}}}});}this.mInvalidatedPaths={};};J.prototype._createBatchRequest=function(i){var j,R,k={},P={},n=true;P.__batchRequests=i;for(var N in i){if(i[N]&&i[N].__changeRequests||i[N]&&i[N].headers&&!i[N].headers['sap-cancel-on-close']){n=false;break;}}j=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){j+="?"+this.aUrlParams.join("&");}Q.extend(k,this.mCustomHeaders,this.oHeaders);k["Accept"]="multipart/mixed";delete k["Content-Type"];k['sap-cancel-on-close']=n;R={headers:k,requestUri:j,method:"POST",data:P,user:this.sUser,password:this.sPassword,async:true};R.withCredentials=this.bWithCredentials;return R;};J.prototype.abortInternalRequest=function(j,P){var R=this.mRequests;var k,n;if(P){k=P.requestKey;n=P.path;}if(j in this.mDeferredGroups){R=this.mDeferredRequests;}var N=function(T){for(var i=0;i<T.parts.length;i++){T.parts[i].requestHandle.abort();}};var S=R[j];if(S){if(k in S.map){N(S.map[k]);}else if(n){g(S.map,function(k,i){if(k.indexOf(n)>=0){N(i);}});}else if(j&&!P){g(S.map,function(i,T){N(T);});}}};J.prototype._pushToRequestQueue=function(R,i,j,k,S,n,N,P){var T=R[i],V=k.key?k.key:k.method+":"+k.requestUri;if(this.bWarmup){return;}if(!T){T={};T.map={};T.requests=[];R[i]=T;}if(V in T.map&&(k.key||k.method==='GET')){var W=T.map[V];var X=W.request;k.deepPath=X.deepPath;if(this.sMessageScope===s.BusinessObject){k.headers["sap-message-scope"]=X.headers["sap-message-scope"];}if(W.bRefreshAfterChange===undefined){W.bRefreshAfterChange=P;}if(!k.key){W.parts.push({request:k,fnSuccess:S,fnError:n,requestHandle:N});}if(k.method==="GET"){delete X.data;}else{X.method=k.method;X.headers=k.headers;X.data=k.data;if(k.method==="PUT"){delete X.headers["x-http-method"];}if(X._aborted){delete X._aborted;}}if(k.functionTarget){X.requestUri=k.requestUri;X.functionTarget=k.functionTarget;}}else{var W={request:k,bRefreshAfterChange:P,parts:[{request:k,fnSuccess:S,fnError:n,requestHandle:N}]};if(k.method==="GET"){T.requests.push(W);}else{if(!T.changes){T.changes={};}var Y=T.changes[j];if(!Y){Y=[];T.changes[j]=Y;}W.changeSetId=j;Y.push(W);}T.map[V]=W;}};J.prototype._collectChangedEntities=function(j,k,n){var N=this;if(j.changes){g(j.changes,function(P,R){for(var i=0;i<R.length;i++){if(R[i].bRefreshAfterChange){var S=R[i].request,T="/"+S.requestUri.split("?")[0],V,W;if(S.method==="POST"||S.method==="DELETE"){var X=N.oMetadata._getEntityTypeByPath(T);if(X){n[X.entityType]=true;}}else{V=N._getObject(T);if(V){W=N._getKey(V);}else if(T.lastIndexOf("/")===0){W=N._getKey(T);}if(W){k[W]=true;}}}}});}};J.prototype._processRequestQueue=function(R,j,S,k){var n=this,P,N=[];function T(W,X){for(var i=0;i<W.parts.length;i++){var Y=W.parts[i];if(Y.request._aborted){n._processAborted(W.request,null);W.parts.splice(i,1);i--;}else if(X){Y.request._handle=X;X.iRelevantRequests++;}}}function V(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort(true);if(S){S({},undefined);}}}};}if(this.bUseBatch){g(R,function(i,W){if(i===j||!j){var X={},Y={};n._collectChangedEntities(W,X,Y);if(Object.keys(X).length||Object.keys(Y).length){n.bIncludeInCurrentBatch=true;n._refresh(false,i,X,Y);n.bIncludeInCurrentBatch=false;}}});g(R,function(W,X){if(W===j||!j){var Y=[],Z=[],$,_;var a1=V();if(X.changes){g(X.changes,function(d1,e1){var f1,i,g1;$={__changeRequests:[]};_=[];for(i=0;i<e1.length;i++){f1=e1[i].request;P='/'+n.getKey(f1.data);n.increaseLaundering(P,f1.data);T(e1[i],a1);if(e1[i].parts.length>0){n.removeInternalMetadata(f1.data);$.__changeRequests.push(f1);if(f1.expandRequest){g1=e1[i].parts[0];n._pushToRequestQueue(R,W,undefined,f1.expandRequest,g1.fnSuccess,g1.fnError,g1.requestHandle,false);}_.push(e1[i]);}}if($.__changeRequests&&$.__changeRequests.length>0){Y.push($);Z.push(_);}});}if(X.requests){var b1=X.requests;for(var i=0;i<b1.length;i++){T(b1[i],a1);if(b1[i].parts.length>0){Y.push(b1[i].request);Z.push(b1[i]);}}}if(Y.length>0){var c1=n._createBatchRequest(Y);a1.oRequestHandle=n._submitBatchRequest(c1,Z,S,k);N.push(a1.oRequestHandle);}delete R[W];}});}else{g(R,function(W,X){if(W===j||!j){if(X.changes){g(X.changes,function($,_){for(var i=0;i<_.length;i++){var Z=V();P='/'+n.getKey(_[i].request.data);n.increaseLaundering(P,_[i].request.data);T(_[i],Z);if(_[i].parts.length>0){n.removeInternalMetadata(_[i].request.data);Z.oRequestHandle=n._submitSingleRequest(_[i]);N.push(Z.oRequestHandle);}}});}if(X.requests){var Y=X.requests;for(var i=0;i<Y.length;i++){var Z=V();T(Y[i],Z);if(Y[i].parts.length>0){Z.oRequestHandle=n._submitSingleRequest(Y[i]);N.push(Z.oRequestHandle);}}}delete R[W];}});}this.checkDataState(this.mLaunderingState);return N.length==1?N[0]:N;};J.prototype._processRequestQueueAsync=function(R){var i=this;if(!this.pCallAsync){this.pCallAsync=this.oMetadata.loaded().then(function(){return Promise.resolve().then(function(){i._processRequestQueue(R);i.pCallAsync=undefined;});});}};J.prototype._processSuccess=function(R,i,S,j,k,n,N,P,T){var V,W,X,Y,Z,$,_,a1,b1,c1,d1,e1,f1,g1={},h1={},i1=i.data,j1=this;if(!N){W=!(i.statusCode===204||i.statusCode==='204');f1=R.requestUri;d1=f1.replace(this.sServiceUrl,"");if(!d1.startsWith('/')){d1='/'+d1;}b1=this._normalizePath(d1);Z=this.oMetadata._getEntityTypeByPath(b1);a1=Z&&Z.isFunction;d1=this._normalizePath(d1,undefined,!a1);this.decreaseLaundering(d1,R.data);this._decreaseDeferredRequestCount(R);if(R.functionMetadata){if(i.headers&&i.headers.location){$=i.headers.location;e1=$.lastIndexOf(this.sServiceUrl);if(e1>-1){V=$.slice(e1+this.sServiceUrl.length);if(R.functionTarget===V){X=this.getDeepPathForCanonicalPath(V);if(X){R.deepPath=X;}}R.functionTarget=V;}}if(R.adjustDeepPath){R.deepPath=R.adjustDeepPath({deepPath:X||R.functionTarget,response:m({},i)});}else if(!X){R.deepPath=R.functionTarget;}if(T&&R.withContentID){T[R.withContentID].deepPath=R.deepPath;}}if(W&&i1===undefined&&i){this._parseResponse(i,R);L.fatal(this+" - No data was retrieved by service: '"+i.requestUri+"'");j1.fireRequestCompleted({url:i.requestUri,type:"GET",async:i.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(i1&&!i1.__metadata&&i1.results&&!Array.isArray(i1.results)){i1=i1.results;}if(!i._imported&&i1&&(Array.isArray(i1)||typeof i1=='object')){_=m({},i1);if(R.key||R.created){j1._importData(_,h1,i,undefined,undefined,undefined,a1);}else{j1._importData(_,h1,i,d1,R.deepPath,undefined,a1);}i._imported=true;}Y=this._getEntity(R.key);if(h1&&Y&&Y.__metadata.created&&Y.__metadata.created.functionImport){var k1=[];var l1=Y["$result"];if(l1&&l1.__list){g(h1,function(n1){k1.push(n1);});l1.__list=k1;}else if(l1&&l1.__ref){g(h1,function(n1){l1.__ref=n1;});}}if(!W){c1=d1.split("/");if(c1[1]){g1[c1[1]]=R;var m1={};m1[c1[1]]=R.data;this._updateChangedEntities(m1);}if(R.method==="DELETE"&&c1[2]!=="$links"){this._removeEntity(c1[1]);}}if(W&&R.method==="POST"||R.functionMetadata){if(Z){n[Z.entityType]=true;}if(R.key){if(R.created){var n1=this._getKey(i1);var o1=this.getContext("/"+R.key);this._updateContext(o1,'/'+n1);X=R.deepPath;if(o1.bCreated&&X.endsWith(")")){R.deepPath=X.slice(0,X.lastIndexOf("("))+n1.slice(n1.indexOf("("));}o1.bCreated=false;o1.setUpdated(true);this.callAfterUpdate(function(){o1.setUpdated(false);});Y=this._getEntity(n1);if(Y){delete Y.__metadata.created;}}this._removeEntity(R.key);}}this._parseResponse(i,R,h1,g1);Q.extend(j,h1);Q.extend(k,g1);this._updateETag(R,i);}if(S){S(i1,i);}var p1=this._createEventInfo(R,i,P);if(N){this.fireBatchRequestCompleted(p1);}else{this.fireRequestCompleted(p1);}return true;};J.prototype._processError=function(R,i,j,k,n){var P,N=this._handleError(i,R);if(!k){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);this._decreaseDeferredRequestCount(R);}if(j){j(N);}var S=this._createEventInfo(R,N,n);if(k){this.fireBatchRequestCompleted(S);this.fireBatchRequestFailed(S);}else{this.fireRequestCompleted(S);this.fireRequestFailed(S);}};var K={message:"Request aborted",statusCode:0,statusText:"abort",headers:{},responseText:""};J.prototype._processAborted=function(R,i,j){var P;if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);this._decreaseDeferredRequestCount(R);}if(i){var k=this._createEventInfo(R,K);k.success=false;if(j){this.fireBatchRequestCompleted(k);}else{this.fireRequestCompleted(k);}}};J.prototype._processAfterUpdate=function(){var j=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<j.length;i++){j[i]();}};J.prototype._processChange=function(k,i,j,N){var P,R,S,T,V,W,X,Y,Z,$,_,a1,b1,c1=this;if(N&&this.mChangedEntities[k]&&this.mChangedEntities[k].__metadata){this.mChangedEntities[k].__metadata.deepPath=N;}else if(!N&&this.mChangedEntities[k]&&this.mChangedEntities[k].__metadata&&this.mChangedEntities[k].__metadata.deepPath){N=this.mChangedEntities[k].__metadata.deepPath;}R=this.oMetadata._getEntityTypeByPath(k);if(!j){j="MERGE";}Y=m({},this._getObject('/'+k,true),i);if(i.__metadata&&i.__metadata.created){W=i.__metadata.created.method?i.__metadata.created.method:"POST";k=i.__metadata.created.key;P=true;X=i.__metadata.created;T=i.__metadata.created.expandRequest;b1=i.__metadata.created.withContentID;if(i.__metadata.created.functionImport){X.urlParameters=this._createFunctionImportParameters(i.__metadata.created.key,W,Y);Y=undefined;}else{delete Y.__metadata['uri'];}}else if(j==="MERGE"){W="MERGE";$=this._getEntity(k);}else{W="PUT";}if(Y&&Y.__metadata){for(var n in Y.__metadata){if(n!=='type'&&n!=='uri'&&n!=='etag'&&n!=='content_type'&&n!=='media_src'){delete Y.__metadata[n];}}}if(Y&&R){var d1=this.oMetadata._getNavigationPropertyNames(R);d1.forEach(function(g1){delete Y[g1];});}if(W==="MERGE"&&R&&$){g(Y,function(g1,h1){if(g1!=='__metadata'){if(f($[g1],h1)&&!c1.isLaundering('/'+k+'/'+g1)){delete Y[g1];}}});var e1="/"+k,f1;g(Y,function(g1,h1){if(g1!=='__metadata'){f1=c1.getProperty(e1+"/"+g1+"/#@sap:unit");if(f1){if(Y[f1]===undefined){Y[f1]=$[f1];}}}});if($.__metadata.etag){Y.__metadata.etag=$.__metadata.etag;}}Y=this._removeReferences(Y);a1=X&&X.urlParameters?y._createUrlParamsArray(X.urlParameters):undefined;V=X?this._getHeaders(X.headers):this._getHeaders();S=X&&X.eTag?X.eTag:this.getETag(Y);_=this._createRequestUrl('/'+k,null,a1,this.bUseBatch);Z=this._createRequest(_,N,W,V,Y,S,undefined,true);if(P){Z.created=true;if(T){Z.expandRequest=T;Z.withContentID=b1;}if(i.__metadata.created.functionMetadata){Z.functionTarget=this.oMetadata._getCanonicalPathOfFunctionImport(i.__metadata.created.functionMetadata,X.urlParameters);}}if(this.bUseBatch){Z.requestUri=Z.requestUri.replace(this.sServiceUrl+'/','');}return Z;};J.prototype._resolveGroup=function(k){var i,j,P,n,N,R;j=this.oMetadata._getEntityTypeByPath(k);R=this._getObject('/'+k);if(R){P=R.__metadata.created;if(P){return{groupId:P.groupId,changeSetId:P.changeSetId};}}if(this.mChangeGroups[j.name]){i=this.mChangeGroups[j.name];n=i.groupId;N=i.single?u():i.changeSetId;}else if(this.mChangeGroups['*']){i=this.mChangeGroups['*'];n=i.groupId;N=i.single?u():i.changeSetId;}return{groupId:n,changeSetId:N};};J.prototype._updateETag=function(R,i){var j,k,n;j=R.requestUri.replace(this.sServiceUrl+'/','');if(!j.startsWith("/")){j="/"+j;}k=this._getObject(j.split("?")[0],undefined,true);n=this._getHeader("etag",i.headers);if(k&&k.__metadata&&n){k.__metadata.etag=n;}};J.prototype._handleError=function(i,R){var j,P={message:i.message},T;if(i.response){if(!i.$reported){this._parseResponse(i.response,R);if(this.bTokenHandling){T=this._getHeader("x-csrf-token",i.response.headers);if(i.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){this.resetSecurityToken();}}j=i.message+" ("+i.response.statusCode+" "+i.response.statusText+"): "+i.response.body;}P.statusCode=i.response.statusCode;P.statusText=i.response.statusText;P.headers=i.response.headers;P.responseText=i.response.body;}else{j="The following problem occurred: "+i.message;}if(!i.$reported){L.error(j,undefined,G);}i.$reported=true;return P;};J.prototype.getData=function(P,i,j){return this.getProperty(P,i,j);};J.prototype._getODataHandler=function(i){if(i.indexOf("$batch")>-1){return D.batchHandler;}else if(i.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return D.jsonHandler;}else{return D.atomHandler;}};J.prototype.getETag=function(P,i,j){if(typeof P=="object"){j=P;P="";}return this._getETag(P,i,j);};J.prototype._getETag=function(P,i,j){if(!j||!j.__metadata){j=this._getObject(P,i);}if(j&&j.__metadata){return j.__metadata.etag;}return null;};J.prototype.forceEntityUpdate=function(k){var i=this.mChangedEntities[k];if(i&&i.__metadata){i.__metadata.etag='*';}else{L.error(this+" - Entity with key "+k+" does not exist or has no change");}};J.prototype._createRequest=function(i,j,k,n,N,P,R,S){R=R!==false;if(P&&k!=="GET"){n["If-Match"]=P;}if(!n["Content-Type"]&&k!=="DELETE"&&k!=="GET"){if(this.bJSON){n["Content-Type"]="application/json";}else{n["Content-Type"]="application/atom+xml";}}if(i.indexOf("$count")>-1){n["Accept"]="text/plain, */*;q=0.5";}if(k==="MERGE"&&!this.bUseBatch){n["x-http-method"]="MERGE";k="POST";}if(this.sMessageScope===s.BusinessObject){if(this.bIsMessageScopeSupported){n["sap-message-scope"]=this.sMessageScope;}else{L.error("Message scope 'sap.ui.model.odata.MessageScope.BusinessObject' is not"+" supported by the service: "+this.sServiceUrl,undefined,G);}}S=S&&this.sMessageScope===s.BusinessObject&&this.bIsMessageScopeSupported;var T={headers:n,requestUri:i,method:k,user:this.sUser,password:this.sPassword,async:R,deepPath:j,updateAggregatedMessages:S};if(N){T.data=N;}if(this.bWithCredentials){T.withCredentials=this.bWithCredentials;}T.requestID=this._createRequestID();return T;};J.prototype._processRequest=function(P,i,j){var R,k,n=false,N=this;if(this.bWarmup){return{abort:function(){}};}if(j){this.iPendingDeferredRequests++;}R={abort:function(){if(j&&!n){N.iPendingDeferredRequests--;}if(!n&&i){i(K);}if(k){k._aborted=true;if(k._handle){k._handle.abort();}}n=true;}};this.oMetadata.loaded().then(function(){k=P(R);if(k){k.deferred=!!j;}N._processRequestQueueAsync(N.mRequests);if(n){R.abort();}});return R;};J.prototype.update=function(P,i,j){var S,k,R,n,N,T,V,W,X,Y,Z,$,_,a1,b1,c1=this,d1,e1,f1;if(j){W=j.groupId||j.batchGroupId;X=j.changeSetId;N=j.context;S=j.success;k=j.error;T=j.eTag;Z=j.headers;Y=j.urlParameters;a1=j.refreshAfterChange;f1=j.canonicalRequest;if(j.merge!==undefined){$=j.merge?"MERGE":"PUT";}}f1=this._isCanonicalRequestNeeded(f1);b1=W in c1.mDeferredGroups;a1=this._getRefreshAfterChange(a1,W);V=y._createUrlParamsArray(Y);Z=this._getHeaders(Z);$=$?$:this.sDefaultUpdateMethod;T=T||this._getETag(P,N,i);d1=this._normalizePath(P,N,f1);e1=this.resolveDeep(P,N);return this._processRequest(function(g1){n=c1._createRequestUrlWithNormalizedPath(d1,V,c1.bUseBatch);R=c1._createRequest(n,e1,$,Z,i,T);_=c1.mRequests;if(b1){_=c1.mDeferredRequests;}c1._pushToRequestQueue(_,W,X,R,S,k,g1,a1);return R;},k,b1);};J.prototype.create=function(P,i,j){var R,k,n,N,S,T,V,W,X,Y,Z,$,_,a1,b1,c1,d1=this,e1,f1,g1;if(j){N=j.context;V=j.urlParameters;S=j.success;T=j.error;$=j.groupId||j.batchGroupId;a1=j.changeSetId;Z=j.eTag;X=j.headers;b1=j.refreshAfterChange;g1=j.canonicalRequest;}g1=this._isCanonicalRequestNeeded(g1);b1=this._getRefreshAfterChange(b1,$);Y=y._createUrlParamsArray(V);X=this._getHeaders(X);_="POST";c1=$ in d1.mDeferredGroups;e1=d1._normalizePath(P,N,g1);f1=this.resolveDeep(P,N);return this._processRequest(function(h1){k=d1._createRequestUrlWithNormalizedPath(e1,Y,d1.bUseBatch);R=d1._createRequest(k,f1,_,X,i,Z);R.created=true;n=d1.oMetadata._getEntityTypeByPath(e1);R.entityTypes={};if(n){R.entityTypes[n.entityType]=true;}W=d1.mRequests;if(c1){W=d1.mDeferredRequests;}d1._pushToRequestQueue(W,$,a1,R,S,T,h1,b1);return R;},T,c1);};J.prototype.remove=function(P,i){var j,k,S,n,R,N,T,V,W,X,Y,Z,$,_,a1,b1,c1=this,d1,e1,f1=this.bCanonicalRequests;if(i){T=i.groupId||i.batchGroupId;V=i.changeSetId;j=i.context;S=i.success;n=i.error;W=i.eTag;Z=i.headers;Y=i.urlParameters;X=i.refreshAfterChange;f1=i.canonicalRequest;}f1=this._isCanonicalRequestNeeded(f1);X=this._getRefreshAfterChange(X,T);$=y._createUrlParamsArray(Y);Z=this._getHeaders(Z);_="DELETE";W=W||this._getETag(P,j);b1=T in c1.mDeferredGroups;d1=this._normalizePath(P,j,f1);e1=this.resolveDeep(P,j);function g1(h1,i1){k=N.substr(N.lastIndexOf('/')+1);if(k.indexOf('?')!==-1){k=k.substr(0,k.indexOf('?'));}c1._removeEntity(k);if(S){S(h1,i1);}}return this._processRequest(function(h1){N=c1._createRequestUrlWithNormalizedPath(d1,$,c1.bUseBatch);R=c1._createRequest(N,e1,_,Z,undefined,W,undefined,true);a1=c1.mRequests;if(b1){a1=c1.mDeferredRequests;}c1._pushToRequestQueue(a1,T,V,R,g1,n,h1,X);return R;},n,b1);};J.prototype.callFunction=function(i,P){var j,k,n,N,R,S,T,V,W,X,Y,Z,$,_,a1=this;if(!i.startsWith("/")){L.fatal("callFunction: sFunctionName has to be absolute, but the given '"+i+"' is not absolute",this,G);return undefined;}P=P||{};j=P.changeSetId;n=P.error;N=P.eTag;R=P.expand;S=P.groupId||P.batchGroupId;T=P.headers;V=P.method||"GET";W=P.refreshAfterChange;$=P.success;_=Object.assign({},P.urlParameters);if(R){if(!this.bUseBatch){throw new Error("Use 'expand' parameter only with 'useBatch' set to 'true'");}if(V!=="POST"){throw new Error("Use 'expand' parameter only with HTTP method 'POST'");}}W=this._getRefreshAfterChange(W,S);k=new Promise(function(b1,c1){Z=b1;X=c1;});Y=this._processRequest(function(b1){var c1,d1,e1,f1,g1,h1,i1,j1,k1,l1,m1,n1={},o1=n,p1=false,q1=$;e1=a1.oMetadata._getFunctionImportMetadata(i,V);if(!e1){L.error("Function '"+i+"' not found in the metadata",a1,G);X();return undefined;}if(e1.entitySet||e1.entitySetPath){n1.$result={__list:[]};if(e1.returnType&&!e1.returnType.startsWith("Collection")){n1.$result={__ref:{}};}}if(R&&(!n1.$result||!n1.$result.__ref)){X(new Error("Use 'expand' parameter only for functions returning a single"+" entity"));return undefined;}if(e1.parameter!=null){e1.parameter.forEach(function(r1){n1[r1.name]=a1._createPropertyValue(r1.type);if(_[r1.name]!==undefined){n1[r1.name]=_[r1.name];_[r1.name]=y.formatValue(_[r1.name],r1.type);}else{L.warning("No value given for parameter '"+r1.name+"' of function import '"+i+"'",a1,G);}});}k1=u();if(R){T=Object.assign({},T,{"Content-ID":k1,"sap-messages":"transientOnly"});$=function(n1,r1){if(!g1){g1=n1;f1=r1;return;}if(q1){n1=Object.assign({},g1,n1);q1(n1,f1);}};n=function(r1){if(g1){f1.expandAfterFunctionCallFailed=true;r1.expandAfterFunctionCallFailed=true;L.error("Function '"+i+"' was called successfully, but"+" expansion of navigation properties ("+R+") failed",r1,G);if(q1){q1(g1,f1);}return;}if(!p1){p1=true;if(o1){o1(r1);}}else{r1.expandAfterFunctionCallFailed=true;}};}n1.__metadata={uri:a1.sServiceUrl+i+"('"+k1+"')",created:{changeSetId:j,error:n,eTag:N,functionImport:true,groupId:S,headers:Object.assign({},T),key:i.substring(1),method:V,success:$}};h1=a1._addEntity(n1);c1=a1.getContext("/"+h1);a1._writePathCache("/"+h1,"/"+h1);Z(c1);m1=y._createUrlParamsArray(_);l1=a1._createRequestUrlWithNormalizedPath(i,m1,a1.bUseBatch);i1=a1._createRequest(l1,i,V,a1._getHeaders(T),undefined,N,undefined,true);i1.adjustDeepPath=P.adjustDeepPath;i1.functionMetadata=e1;n1.__metadata.created.functionMetadata=e1;i1.functionTarget=a1.oMetadata._getCanonicalPathOfFunctionImport(e1,_);i1.key=h1;if(R){d1=a1._createRequest("$"+k1+"?"+y._encodeURLParameters({$expand:R,$select:R}),"/$"+k1,"GET",a1._getHeaders(undefined,true),undefined,undefined,undefined,true);d1.withContentID=k1;i1.expandRequest=d1;i1.withContentID=k1;}j1=a1.mRequests;if(S in a1.mDeferredGroups){j1=a1.mDeferredRequests;}a1._pushToRequestQueue(j1,S,j,i1,$,n,b1,W);return i1;},n);Y.contextCreated=function(){return k;};return Y;};J.prototype._createFunctionImportParameters=function(i,j,P){var k=Q.extend(true,{},P);delete k.__metadata;delete k["$result"];var n=this.oMetadata._getFunctionImportMetadata(i,j);d(n,this+": Function "+i+" not found in the metadata !");if(!n){return;}if(n.parameter!=null){g(n.parameter,function(N,R){if(k&&k[R.name]!==undefined){k[R.name]=y.formatValue(k[R.name],R.type);}});}return k;};J.prototype.read=function(P,i){var j,k,n,N,R,S,T,V,W,X,Y,Z,$,_,a1,b1,c1,d1,e1,f1,g1,h1,i1,j1=this;if(i){_=i.canonicalRequest;a1=i.context;b1=i.error;c1=i.filters;d1=i.groupId||i.batchGroupId;e1=i.headers;f1=i.sorters;g1=i.success;h1=i.updateAggregatedMessages;i1=i.urlParameters;}_=this._isCanonicalRequestNeeded(_);if(this.sRefreshGroupId){d1=this.sRefreshGroupId;}$=y._createUrlParamsArray(i1);e1=this._getHeaders(e1,true);S="GET";n=this._getETag(P,a1);var k1={abort:function(){if(W){W._aborted=true;}}};var l1=P;var m1=P.indexOf("$count");if(m1!==-1){l1=P.substring(0,m1-1);}V=this._normalizePath(l1,a1,_);T=this._normalizePath(P,a1,_);j=this.resolveDeep(P,a1);function n1(o1){Y=y.createSortParams(f1);if(Y){$.push(Y);}k=j1.oMetadata._getEntityTypeByPath(V);N=F.groupFilters(c1);R=y.createFilterParams(N,j1.oMetadata,k);if(R){$.push(R);}Z=j1._createRequestUrlWithNormalizedPath(T,$,j1.bUseBatch);W=j1._createRequest(Z,j,S,e1,null,n,undefined,h1);X=j1.mRequests;if(d1 in j1.mDeferredGroups){X=j1.mDeferredRequests;}j1._pushToRequestQueue(X,d1,null,W,g1,b1,o1,false);return W;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){W=n1(k1);return k1;}else{return this._processRequest(n1,b1);}};J.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};J.prototype.metadataLoaded=function(R){var i=this.oMetadata.loaded(R);if(this.bLoadAnnotationsJoined){if(R){return Promise.all([i,this.pAnnotationsLoaded]);}var j=function(){return i;};return this.pAnnotationsLoaded.then(j,j);}else{return i;}};J.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded;};J.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed();};J.prototype.getServiceAnnotations=function(){var i=this.oAnnotations.getData();return h(i)?null:i;};J.prototype.onAnnotationsFailed=function(i){this.fireAnnotationsFailed(i.getParameters());};J.prototype.onAnnotationsLoaded=function(i){this.fireAnnotationsLoaded(i.getParameters());};J.prototype.addAnnotationUrl=function(i){var j=[].concat(i),k=[],n=[],N=[],P=this;j.forEach(function(R){var S=R.indexOf("$metadata");if(S>=0){R=P._createMetadataUrl(R);k.push(R);}else{n.push(R);}});return this.oMetadata._addUrl(k).then(function(R){return Promise.all(R.map(function(S){N=N.concat(S.entitySets);return P.oAnnotations.addSource({type:"xml",data:S["metadataString"]});}));}).then(function(){return P.oAnnotations.addSource(n);}).then(function(R){return{annotations:P.oAnnotations.getData(),entitySets:N};});};J.prototype.addAnnotationXML=function(X,S){return this.oAnnotations.addSource({type:"xml",data:X});};J.prototype.submitChanges=function(P){var R,j,k,S,n,N,T,V=false,W,X,Y=this.bRefreshAfterChange,Z,$=this;if(P){j=P.groupId||P.batchGroupId;S=P.success;n=P.error;if(P.merge!==undefined){W=P.merge?"MERGE":"PUT";}}if(j&&!this.mDeferredGroups[j]){L.fatal(this+" submitChanges: \""+j+"\" is not a deferred group!");}X=m({},$.mChangedEntities);this.oMetadata.loaded().then(function(){g(X,function(e1,f1){k=$._resolveGroup(e1);if(k.groupId===j||!j){R=$._processChange(e1,f1,W||$.sDefaultUpdateMethod);R.key=e1;Z=f1.__metadata&&f1.__metadata.created?f1.__metadata.created:{};var N={abort:function(){R._aborted=true;}};if(k.groupId in $.mDeferredGroups){$._pushToRequestQueue($.mDeferredRequests,k.groupId,k.changeSetId,R,Z.success,Z.error,N,Y);}}});var _,a1,b1,c1,d1,i;for(_ in $.mDeferredRequests){b1=$.mDeferredRequests[_];for(a1 in b1.changes){c1=b1.changes[a1];for(i=c1.length-1;i>=0;i--){d1=c1[i];if(d1.bRefreshAfterChange===undefined){d1.bRefreshAfterChange=Y;}}}}T=$._processRequestQueue($.mDeferredRequests,j,S,n);if(V){N.abort();}if(Array.isArray(T)&&T.length==0&&S){S({},undefined);}});N={abort:function(){if(T){if(Array.isArray(T)){T.forEach(function(N){N.abort();});}else{T.abort();}}else{V=true;}}};return N;};J.prototype._updateChangedEntities=function(i){var j=this,R,k,n;function N(P,S,T){g(S,function(V){var W=T+'/'+V;if(l(S[V])&&l(P[V])){N(P[V],S[V],W);if(h(S[V])){delete S[V];}}else if(T.endsWith("__metadata")||f(S[V],P[V])&&!j.isLaundering(W)){delete S[V];if(T===R){k=j.oMetadata._getEntityTypeByPath(R);n=k&&j.oMetadata._getNavPropertyRefInfo(k,V);if(n&&S[n.name]){P[n.name]=S[n.name];delete S[n.name];}}}});}g(i,function(P,S){if(P in j.mChangedEntities){var T=j._getObject('/'+P,null,true);var V=j._getObject('/'+P);m(T,S);R='/'+P;var W=j.removeInternalMetadata(V).deepPath;N(T,V,R);if(h(V)){delete j.mChangedEntities[P];j.abortInternalRequest(j._resolveGroup(P).groupId,{requestKey:P});}else{j.mChangedEntities[P]=V;V.__metadata={deepPath:W};Q.extend(V.__metadata,T.__metadata);}}});};J.prototype.resetChanges=function(P,j){var k=this,n,N={},R,S;if(j){if(P){P.forEach(function(i){k.oMetadata.loaded().then(function(){g(k.mDeferredGroups,function(T){k.abortInternalRequest(T,{path:i.substring(1)});});});});}else{this.oMetadata.loaded().then(function(){g(k.mDeferredGroups,function(i){k.abortInternalRequest(i);});});}}if(P){g(P,function(T,V){k.getEntityByPath(V,null,N);if(N&&N.propertyPath!==undefined){n=N.propertyPath.split("/");var W=N.key;R=k.mChangedEntities[W];for(var i=0;i<n.length-1;i++){if(R.hasOwnProperty(n[i])){R=R[n[i]];}else{R=undefined;}}if(R){delete R[n[n.length-1]];}if(k.mChangedEntities[W]){S=k.mChangedEntities[W].__metadata;delete k.mChangedEntities[W].__metadata;if(h(k.mChangedEntities[W])||!N.propertyPath){k.oMetadata.loaded().then(function(){k.abortInternalRequest(k._resolveGroup(W).groupId,{requestKey:W});});delete k.mChangedEntities[W];sap.ui.getCore().getMessageManager().removeMessages(k.getMessagesByEntity(W,true));}else{k.mChangedEntities[W].__metadata=S;}}else{L.warning(k+" - resetChanges: "+V+" is not changed");}}});}else{g(this.mChangedEntities,function(i,T){k.oMetadata.loaded().then(function(){k.abortInternalRequest(k._resolveGroup(i).groupId,{requestKey:i});});delete k.mChangedEntities[i];sap.ui.getCore().getMessageManager().removeMessages(k.getMessagesByEntity(i,true));});}this.checkUpdate(true);return this.oMetadata.loaded();};J.prototype.setProperty=function(P,V,j,k){var n,N,R,S,T,W,X,Y,Z,$,_,a1,b1={},c1={},d1,e1,f1,g1=false,h1=this,i1,j1,k1,l1,m1,n1,o1;function p1(r1,s1){g(s1,function(Z){if(l(s1[Z])&&l(r1[Z])){p1(r1[Z],s1[Z]);if(h(s1[Z])){delete s1[Z];}}else if(f(s1[Z],r1[Z])){delete s1[Z];}});}X=this.resolve(P,j);o1=this.resolveDeep(P,j);W=this.getEntityByPath(X,null,c1);if(!W){return false;}N=X.substring(X.lastIndexOf("/")+1);Z=c1.key;T=this._getObject('/'+Z,null,true);n=this._getObject(P,j,true);if(!this.mChangedEntities[Z]){a1=W.__metadata;W={};W.__metadata=Object.assign({},a1);if(c1.propertyPath.length>0){var q1=o1.lastIndexOf(c1.propertyPath);W.__metadata.deepPath=o1.substring(0,q1-1);}this.mChangedEntities[Z]=W;}e1=this.mChangedEntities[Z];Y=c1.propertyPath.split("/");for(var i=0;i<Y.length-1;i++){if(!e1.hasOwnProperty(Y[i])){e1[Y[i]]={};}e1=e1[Y[i]];}g1=T.__metadata.created&&T.__metadata.created.functionImport;e1[N]=V;j1=this.oMetadata._getEntityTypeByPath(c1.key);k1=j1&&this.oMetadata._getNavPropertyRefInfo(j1,N);l1=k1&&T[k1.name]&&T[k1.name].__ref;if(l1&&k1.keys.length===1){if(V===null){n1=null;}else{m1={};k1.keys.forEach(function(r1){m1[r1]=W[r1]!==undefined?W[r1]:T[r1];});m1[k1.keys[0]]=V;n1=this.createKey(k1.entitySet,m1);}e1[k1.name]={__ref:n1};}if(f(V,n)&&!this.isLaundering('/'+Z)&&!g1){a1=this.mChangedEntities[Z].__metadata;i1=a1&&a1.created;delete this.mChangedEntities[Z].__metadata;if(!i1){p1(T,this.mChangedEntities[Z]);}if(h(this.mChangedEntities[Z])){delete this.mChangedEntities[Z];b1[Z]=true;this.checkUpdate(false,k,b1);h1.oMetadata.loaded().then(function(){h1.abortInternalRequest(h1._resolveGroup(Z).groupId,{requestKey:Z});});return true;}this.mChangedEntities[Z].__metadata=a1;}$=this._resolveGroup(Z);R=this.mRequests;if($.groupId in this.mDeferredGroups){R=this.mDeferredRequests;S=this._processChange(Z,{__metadata:W.__metadata},this.sDefaultUpdateMethod);}else{S=this._processChange(Z,this._getObject('/'+Z),this.sDefaultUpdateMethod);}S.key=Z;d1=e1.__metadata&&e1.__metadata.created?e1.__metadata.created:{};f1=this._getRefreshAfterChange(undefined,$.groupId);this.oMetadata.loaded().then(function(){_={abort:function(){S._aborted=true;}};h1._pushToRequestQueue(R,$.groupId,$.changeSetId,S,d1.success,d1.error,_,f1);h1._processRequestQueueAsync(h1.mRequests);});b1[Z]=true;this.checkUpdate(false,k,b1);return true;};J.prototype._isHeaderPrivate=function(i){switch(i.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false;}};J.prototype.setHeaders=function(i){var j={},k=this;this.mCustomHeaders={};if(i){g(i,function(n,N){if(k._isHeaderPrivate(n)){L.warning(this+" - modifying private header: '"+n+"' not allowed!");}else{j[n]=N;}});this.mCustomHeaders=j;}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};J.prototype._getHeaders=function(i,j){var k={},n=this;if(i){g(i,function(N,P){if(n._isHeaderPrivate(N)){L.warning(this+" - modifying private header: '"+N+"' not allowed!");}else{k[N]=P;}});}return Q.extend({'sap-cancel-on-close':!!j},this.mCustomHeaders,k,this.oHeaders);};J.prototype.getHeaders=function(){return Q.extend({},this.mCustomHeaders,this.oHeaders);};J.prototype._getHeader=function(i,j){var k;for(k in j){if(k.toLowerCase()===i.toLowerCase()){return j[k];}}return null;};J.prototype.hasPendingChanges=function(i){var j=!h(this.mChangedEntities);if(i){j=j||this.iPendingDeferredRequests>0;}return j;};J.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0;};J.prototype.getPendingChanges=function(){return m({},this.mChangedEntities);};J.prototype.updateBindings=function(i){this.checkUpdate(i);};J.prototype.setTokenHandlingEnabled=function(T){this.bTokenHandling=T;};J.prototype.setUseBatch=function(i){this.bUseBatch=i;};J.prototype.formatValue=function(V,T){return y.formatValue(V,T);};J.prototype.deleteCreatedEntry=function(i){var j=this,k,n;if(i){var k=i.getPath().substr(1);n=this._resolveGroup(k).groupId;j.oMetadata.loaded().then(function(){j.abortInternalRequest(n,{requestKey:k});});j._removeEntity(k);sap.ui.getCore().getMessageManager().removeMessages(this.getMessagesByEntity(i.getPath(),true));}};J.prototype.createEntry=function(P,j){var k,n,N,R,S,T,V,W,X,Y,Z,$,_,a1,b1,c1,d1,e1,f1,g1,h1={},i1="POST",j1=this;if(j){_=j.properties;X=j.groupId||j.batchGroupId;n=j.changeSetId;N=j.context;d1=j.success;T=j.error;R=j.created;V=j.eTag;Y=j.headers;g1=j.urlParameters;a1=j.refreshAfterChange;k=j.canonicalRequest;W=j.expand;}if(W&&!this.bUseBatch){throw new Error("The 'expand' parameter is only supported if batch mode is used");}k=this._isCanonicalRequestNeeded(k);Y=Y||{};a1=this._getRefreshAfterChange(a1,X);X=X?X:this.sDefaultChangeGroup;f1=y._createUrlParamsArray(g1);var k1={abort:function(){if(b1){b1._aborted=true;if(b1.expandRequest){b1.expandRequest._aborted=true;}}}};if(!P.startsWith("/")&&!N){P="/"+P;}$=j1._normalizePath(P,N,k);S=j1.resolveDeep(P,N);function l1(){var m1,n1,o1,p1,q1,r1,s1=false,t1=T,u1=d1;var v1=j1.oMetadata._getEntityTypeByPath($);if(!v1){d(v1,"No Metadata for collection "+$+" found");return undefined;}if(typeof _==="object"&&!Array.isArray(_)){h1=m({},_);}else{for(var i=0;i<v1.property.length;i++){var w1=v1.property[i];var x1=(_?_.indexOf(w1.name):-1)>-1;if(!_||x1){h1[w1.name]=j1._createPropertyValue(w1.type);if(x1){_.splice(_.indexOf(w1.name),1);}}}if(_){d(_.length===0,"No metadata for the following properties found: "+_.join(","));}}p1=j1.oMetadata._getEntitySetByType(v1);r1=u();Z=p1.name+"('"+r1+"')";if(S&&j1.oMetadata._isCollection(S)){S=S+"('"+r1+"')";}if(W){Y=Object.assign({},Y,{"Content-ID":r1,"sap-messages":"transientOnly"});d1=function(y1,z1){if(!m1){m1=y1;o1=z1;return;}if(u1){y1=Object.assign({},m1,y1);u1(y1,o1);}};T=function(y1){if(m1){o1.expandAfterCreateFailed=true;y1.expandAfterCreateFailed=true;L.error("Entity creation was successful but expansion of navigation"+" properties failed",y1,G);if(u1){u1(m1,o1);}return;}if(!s1){s1=true;if(t1){t1(y1);}}else{y1.expandAfterCreateFailed=true;s1=false;}};}h1.__metadata={type:""+v1.entityType,uri:j1.sServiceUrl+'/'+Z,created:{key:$.substring(1),success:d1,error:T,headers:Y,urlParameters:g1,groupId:X,changeSetId:n,eTag:V},deepPath:S};Z=j1._addEntity(m({},h1));j1.mChangedEntities[Z]=h1;e1=j1._createRequestUrlWithNormalizedPath($,f1,j1.bUseBatch);b1=j1._createRequest(e1,S,i1,Y,h1,V);if(W){q1=j1._createRequest("$"+r1+"?"+y._encodeURLParameters({$expand:W,$select:W}),"/$"+r1,"GET",j1._getHeaders(undefined,true),null,undefined,undefined,true);q1.withContentID=r1;b1.expandRequest=q1;b1.withContentID=r1;h1.__metadata.created.expandRequest=q1;h1.__metadata.created.withContentID=r1;}n1=j1.getContext("/"+Z,S);n1.bCreated=true;b1.key=Z;b1.created=true;c1=j1.mRequests;if(X in j1.mDeferredGroups){c1=j1.mDeferredRequests;}j1.oMetadata.loaded().then(function(){j1._pushToRequestQueue(c1,X,n,b1,d1,T,k1,a1);j1._processRequestQueueAsync(j1.mRequests);});return n1;}if(R){this.oMetadata.loaded().then(function(){R(l1());});}else if(this.oMetadata.isLoaded()){return l1();}else{L.error("Tried to use createEntry without created-callback, before metadata is available!");}};J.prototype._isCreatedEntity=function(i){return!!(i&&i.__metadata&&i.__metadata.created);};J.prototype._createPropertyValue=function(T){var j=this.oMetadata._splitName(T);var n=j.namespace;var k=j.name;if(n.toUpperCase()!=='EDM'){var N={};var P=this.oMetadata._getObjectMetadata("complexType",k,n);d(P,"Complex type "+T+" not found in the metadata !");for(var i=0;i<P.property.length;i++){var R=P.property[i];N[R.name]=this._createPropertyValue(R.type);}return N;}else{return this._getDefaultPropertyValue(k,n);}};J.prototype._getDefaultPropertyValue=function(T,n){return undefined;};J.prototype._normalizePath=function(P,i,j){if(P&&P.indexOf('?')!==-1){P=P.substr(0,P.indexOf('?'));}if(!i&&!P.startsWith("/")){L.fatal(this+" path "+P+" must be absolute if no Context is set");}return this.resolve(P,i,j)||this.resolve(P,i);};J.prototype.getRefreshAfterChange=function(){return this.bRefreshAfterChange;};J.prototype.setRefreshAfterChange=function(R){this.bRefreshAfterChange=R;};J.prototype.isList=function(P,i){P=this.resolve(P,i);return P&&P.substr(P.lastIndexOf("/")).indexOf("(")===-1;};J.prototype._isMetadataPath=function(P){var i=false;if(P&&P.indexOf('/#')>-1){i=true;}return i;};J.prototype.isMetaModelPath=function(P){return P.indexOf("##")==0||P.indexOf("/##")>-1;};J.prototype._request=function(R,S,i,j,k,n){var N;if(this.bDestroyed){return{abort:function(){}};}var P=this;function T(V){return function(){if(P.aPendingRequestHandles){var W=P.aPendingRequestHandles.indexOf(N);if(W>-1){P.aPendingRequestHandles.splice(W,1);}}if(!(N&&N.bSuppressErrorHandlerCall)){V.apply(this,arguments);}};}N=D.request(R,T(S||D.defaultSuccess),T(i||D.defaultError),j,k,n);if(R.async!==false){this.aPendingRequestHandles.push(N);}return N;};J.prototype.destroy=function(){this.bDestroyed=true;q.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var R=this.aPendingRequestHandles[i];if(R&&R.abort){R.bSuppressErrorHandlerCall=true;R.abort();}}delete this.aPendingRequestHandles;}if(this.sMetadataLoadEvent){clearTimeout(this.sMetadataLoadEvent);}if(this.oMetadataFailedEvent){clearTimeout(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oSharedMetaData.oMetadata;}delete this.oMetadata;delete this.pMetadataLoaded;}if(this.oMetaModel){this.oMetaModel.destroy();delete this.oMetaModel;}if(this.oAnnotations){this.oAnnotations.detachSomeLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachAllFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;delete this.pAnnotationsLoaded;}};J.prototype.setDeferredBatchGroups=function(i){this.setDeferredGroups(i);};J.prototype.setDeferredGroups=function(i){var j=this;this.mDeferredGroups={};g(i,function(k,n){j.mDeferredGroups[n]=n;});};J.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups();};J.prototype.getDeferredGroups=function(){return Object.keys(this.mDeferredGroups);};J.prototype.setChangeBatchGroups=function(i){g(i,function(j,k){k.groupId=k.batchGroupId;});this.setChangeGroups(i);};J.prototype.setChangeGroups=function(i){this.mChangeGroups=i;};J.prototype.getChangeBatchGroups=function(){return this.getChangeGroups();};J.prototype.getChangeGroups=function(){return this.mChangeGroups;};J.prototype.setMessageParser=function(P){if(!(P instanceof p)){L.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return this;}P.setProcessor(this);this.oMessageParser=P;return this;};J.prototype._parseResponse=function(R,i,j,k){try{if(!this.oMessageParser){this.oMessageParser=new w(this.sServiceUrl,this.oMetadata,!!this.bPersistTechnicalMessages);this.oMessageParser.setProcessor(this);}this.oMessageParser.parse(R,i,j,k,this.bIsMessageScopeSupported);}catch(n){L.error("Error parsing OData messages: "+n);}};J.prototype.callAfterUpdate=function(i){this.aCallAfterUpdate.push(i);};J.prototype.getMetaModel=function(){var i=this;if(!this.oMetaModel){this.oMetaModel=new v(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){i.bMetaModelLoaded=true;i.checkUpdate(false,false,null,true);},function(j){var k=j.message,n;if(!k&&j.xmlDoc&&j.xmlDoc.parseError){k=j.xmlDoc.parseError.reason;n=j.xmlDoc.parseError.srcText;}L.error("error in ODataMetaModel.loaded(): "+k,n,G);});}return this.oMetaModel;};J.prototype.getOriginalProperty=function(P,i){return this._getObject(P,i,true);};J.prototype.getEntityByPath=function(P,i,j){var R=q.prototype.resolve.call(this,P,i);if(!R){return null;}var k=R.split("/"),n=null,N=[];while(k.length>0){var S=k.join("/"),T=this._getObject(S);if(l(T)){var V=this._getKey(T);if(V){n=T;break;}}N.unshift(k.pop());}if(n){j.propertyPath=N.join("/");j.key=V;return n;}return null;};J.prototype.resolveFromCache=function(P){if(!this.mPathCache){return undefined;}var S,i="",j,n,k;j=this.mPathCache[P]?this.mPathCache[P].canonicalPath:undefined;if(P&&j!==P){S=j||P;if(!j){k=S.lastIndexOf("/");i=S.substr(k);S=S.substr(0,k);}n=this.resolveFromCache(S);if(n&&n!==S){j=n+i;}}return j;};J.prototype.resolve=function(P,i,j){var R=q.prototype.resolve.call(this,P,i);if(R&&!this._isMetadataPath(R)&&j){var k=this.resolveFromCache(R);if(!k){k=this.oMetadata._calculateCanonicalPath(R);k=this.resolveFromCache(k)||k;}this._writePathCache(R,k);return k;}return R;};J.prototype.resolveDeep=function(P,i){var R=q.prototype.resolve.call(this,P,i);if(P&&!P.startsWith("/")){R=i?i.sDeepPath+'/'+P:R;}if(P===""){R=i?i.sDeepPath:R;}return R;};J.prototype.isLaundering=function(P,i){var R=this.resolve(P,i);return(R in this.mLaunderingState)&&this.mLaunderingState[R]>0;};J.prototype.increaseLaundering=function(P,i){if(!l(i)){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n];if(l(j)){this.increaseLaundering(P+"/"+n,j);}else{var T=P+"/"+n;if(!(T in this.mLaunderingState)){this.mLaunderingState[T]=0;}this.mLaunderingState[T]++;}}if(!(P in this.mLaunderingState)){this.mLaunderingState[P]=0;}this.mLaunderingState[P]++;};J.prototype.decreaseLaundering=function(P,i){if(!l(i)){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n],T=P+"/"+n;if(l(j)){this.decreaseLaundering(T,j);}else{if(T in this.mLaunderingState){this.mLaunderingState[T]--;if(this.mLaunderingState[T]===0){delete this.mLaunderingState[T];}}}}this.mLaunderingState[P]--;if(this.mLaunderingState[P]===0){delete this.mLaunderingState[P];}};J.prototype._getRefreshAfterChange=function(R,i){if(R===undefined&&!(i in this.mDeferredGroups)){return this.bRefreshAfterChange;}return R;};J.prototype.getMessagesByEntity=function(j,k){var n=j,N=[],P;function R(N){var S=[];for(var i=0;i<N.length;i++){if(!k||(k&&!N[i].persistent)){S.push(N[i]);}}return S;}if(!n.startsWith('/')){n='/'+n;}if(this.mMessages){for(P in this.mMessages){if(typeof n=="string"&&n.length>0&&P.startsWith(n)){N=N.concat(R(this.mMessages[P]));}}return N;}return null;};J.prototype._cacheSupported=function(i){var j=/\/~[\w\-]+~[A-Z0-9]?/;var k=[i];if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI];}k=k.concat(this.sAnnotationURI);}k=k.filter(function(n){return n.indexOf("sap-context-token")===-1;});k=k.filter(function(n){return!j.test(n);});return k.length===0?true:false;};J.prototype._getAnnotationCacheKey=function(i){var j;if(this.bUseCache){if(!this.bSkipMetadataAnnotationParsing){j=i+"#annotations";}if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI];}this.sAnnotationURI=this.sAnnotationURI.map(function(k){return k+"#annotations";});j=this.bSkipMetadataAnnotationParsing?this.sAnnotationURI.join("_"):j+"_"+this.sAnnotationURI.join("_");}}return j;};J.prototype.canonicalRequestsEnabled=function(){return this.bCanonicalRequests;};J.prototype._decreaseDeferredRequestCount=function(R){if(R.deferred){this.iPendingDeferredRequests--;}};J.prototype.enableCanonicalRequests=function(i){this.bCanonicalRequests=!!i;};J.prototype.getMessageScope=function(){return this.sMessageScope;};J.prototype.setMessageScope=function(i){if(i!==s.RequestedObjects&&i!==s.BusinessObject){throw new Error("Unsupported message scope: "+i);}this.sMessageScope=i;};J.prototype.messageScopeSupported=function(){var i=this;return this.metadataLoaded().then(function(){return i.bIsMessageScopeSupported;});};J.prototype.getContext=function(P,i){var j=q.prototype.getContext.apply(this,arguments);if(i){j.sDeepPath=i;}else if(!i&&!j.sDeepPath){j.sDeepPath=P;}return j;};J.prototype.hasContext=function(P){return this.mContexts[P];};J.prototype.removeInternalMetadata=function(i){var j,k,n,V;if(i&&i.__metadata){j=i.__metadata.created;k=i.__metadata.deepPath;delete i.__metadata.created;delete i.__metadata.deepPath;}for(n in i){V=i[n];if(Array.isArray(V)){V.forEach(J.prototype.removeInternalMetadata);}else if(typeof V==="object"){J.prototype.removeInternalMetadata(V);}}return{created:j,deepPath:k};};J.prototype._isCanonicalRequestNeeded=function(i){if(i!==undefined){return!!i;}else{return!!this.bCanonicalRequests;}};J.prototype.filterMatchingMessages=function(i,P){var j=this;return this.mMessages[i].filter(function(k){return j.isMessageMatching(k,P);});};J.prototype.isMessageMatching=function(i,P){var j=P.length;return i.aFullTargets.some(function(k){return k===P||k.startsWith(P)&&(P==="/"||k[j]==="/"||k[j]==="(");});};J.prototype.getMessages=function(i){return this.getMessagesByPath(i.sDeepPath,true).sort(M.compare);};J.prototype.getDeepPathForCanonicalPath=function(j){var k,N,P,R,S,i,n,T=j.slice(j.indexOf("("));S=this.aBindings.filter(function(V){return(V instanceof a||V instanceof b)&&V.isResolved();});for(i=0,n=S.length;i<n;i+=1){k=S[i];P=this.resolveDeep(k instanceof b?k.sPath+T:k.sPath,k.oContext);N=this.resolveFromCache(P);if(N===j){if(R&&R!==P){return undefined;}R=P;}}return R;};J.prototype.getPersistTechnicalMessages=function(){return this.bPersistTechnicalMessages;};J.prototype.setPersistTechnicalMessages=function(P){P=!!P;if(this.bPersistTechnicalMessages===P){return;}if(this.bPersistTechnicalMessages!==undefined){L.warning("The flag whether technical messages should always be treated as persistent"+" has been overwritten to "+P,undefined,G);}this.bPersistTechnicalMessages=P;if(this.oMessageParser){this.oMessageParser._setPersistTechnicalMessages(P);}};return J;});
