/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/rta/toolbar/FioriLike","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/ControlVariant","sap/ui/rta/plugin/iframe/AddIFrame","sap/ui/dt/plugin/ToolHooks","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/library","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/model/json/JSONModel","sap/ui/core/Fragment","sap/ui/rta/util/validateFlexEnabled"],function(q,M,F,S,P,a,D,O,C,b,L,R,c,d,e,f,g,A,h,i,j,k,l,m,n,o,p,T,r,s,U,t,E,u,v,w,x,y,z,V,B,G,H,I,J,K,N,Q,W,X,Y,Z,$,_,a1,b1,c1,d1,e1,f1){"use strict";var g1="STARTING";var h1="STARTED";var i1="STOPPED";var j1="FAILED";var k1="SERVICE_STARTING";var l1="SERVICE_STARTED";var m1="SERVICE_FAILED";var n1=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{customFieldUrl:"string",showCreateCustomField:"boolean",showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},plugins:{type:"any",defaultValue:{}},flexSettings:{type:"object",defaultValue:{layer:x.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:i1,constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new I(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}if(this._shouldValidateFlexEnabled()){this.attachEvent("start",f1.bind(null,this));}},_RELOAD:{NOT_NEEDED:"NO_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION",RELOAD_PAGE:"HARD_RELOAD"}});n1.prototype._shouldValidateFlexEnabled=function(){var r1=document.location.hostname;var s1=r1.endsWith(".sap"+".corp")||r1==="localhost";if(s1){var t1=_.fromQuery(window.location.search).get("sap-ui-rta-skip-flex-validation");s1=t1!=="true";}return s1;};n1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var r1=new b({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:r1,multiSelectionRequiredPlugins:[j.getMetadata().getName(),f.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var s1=new d({commandFactory:r1});this._mDefaultPlugins["dragDrop"]=new c({elementMover:s1,commandFactory:r1,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:r1,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:r1,analyzer:i,dialog:new h()});this._mDefaultPlugins["createContainer"]=new g({commandFactory:r1});this._mDefaultPlugins["remove"]=new f({commandFactory:r1});this._mDefaultPlugins["cutPaste"]=new e({elementMover:s1,commandFactory:r1});this._mDefaultPlugins["settings"]=new m({commandFactory:r1});this._mDefaultPlugins["combine"]=new j({commandFactory:r1});this._mDefaultPlugins["split"]=new k({commandFactory:r1});this._mDefaultPlugins["contextMenu"]=new r();this._mDefaultPlugins["tabHandling"]=new s();this._mDefaultPlugins["stretch"]=new n();this._mDefaultPlugins["controlVariant"]=new o({commandFactory:r1});this._mDefaultPlugins["addIFrame"]=new p({commandFactory:r1});this._mDefaultPlugins["toolHooks"]=new T();}return q.extend({},this._mDefaultPlugins);};n1.prototype.addDependent=function(r1,s1,t1){t1=typeof t1==='undefined'?true:!!t1;if(!(s1 in this._dependents)){if(s1&&t1){this['get'+$(s1,0)]=this.getDependent.bind(this,s1);}this._dependents[s1||r1.getId()]=r1;}else{throw t.createError("RuntimeAuthoring#addDependent",t.printf("Can't add dependency with same key '{0}'",s1),"sap.ui.rta");}};n1.prototype.getDependent=function(r1){return this._dependents[r1];};n1.prototype.getDependents=function(){return this._dependents;};n1.prototype.removeDependent=function(r1){delete this._dependents[r1];};n1.prototype._destroyDefaultPlugins=function(r1){for(var s1 in this._mDefaultPlugins){var t1=this._mDefaultPlugins[s1];if(t1&&!t1.bIsDestroyed){if(!r1||r1[s1]!==t1){t1.destroy();}}}if(!r1){this._mDefaultPlugins=null;}};n1.prototype.onPopupOpen=function(r1){var s1=r1.getParameters().getSource();if(s1.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};n1.prototype.onPopupClose=function(r1){if(r1.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};n1.prototype.setPlugins=function(r1){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",r1);};n1.prototype.setFlexSettings=function(r1){var s1=_.fromQuery(window.location.search);var t1=s1.get("sap-ui-layer");r1=q.extend({},this.getFlexSettings(),r1);if(t1){r1.layer=t1.toUpperCase();}if(r1.scenario||r1.baseId){var u1=v.buildLrepRootNamespace(r1.baseId,r1.scenario,r1.projectId);r1.rootNamespace=u1;r1.namespace=u1+"changes/";}U.setRtaStyleClassName(r1.layer);this.setProperty("flexSettings",r1);};n1.prototype.getLayer=function(){return this.getFlexSettings().layer;};n1.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};n1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};n1.prototype._setVersionsModel=function(r1){this._oVersionsModel=r1;};n1.prototype._initVersioning=function(){return V.initialize({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(this._setVersionsModel.bind(this));};n1.prototype.start=function(){this._sStatus=g1;var r1;var s1;var t1=this.getRootControlInstance();if(!this._oDesignTime){if(!t1){s1=new Error("Root control not found");b1.error(s1);return Promise.reject(s1);}return this._initVersioning().then(this._determineReload.bind(this)).then(function(u1){if(u1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(x1){if(this.getPlugins()[x1].attachElementModified){this.getPlugins()[x1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var v1=Object.keys(this.getPlugins());var w1=v1.map(function(x1){return this.getPlugins()[x1];},this);r1=new Promise(function(x1,y1){a1.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:w1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()===x.USER){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}else{q("body").addClass("sapUiRtaMode");}this._oDesignTime.getSelectionManager().attachChange(function(z1){this.fireSelectionChange({selection:z1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){x1();a1.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(z1){y1(z1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){var u1={selector:this.getRootControlInstance(),layer:this.getLayer()};return B.getResetAndPublishInfo(u1).then(function(v1){this.bInitialResetEnabled=v1.isResetEnabled;this.bInitialPublishEnabled=v1.isPublishEnabled;}.bind(this));}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getToolbarButtonsVisibility().then(this._createToolsMenu.bind(this));}}.bind(this)).then(this._onStackModified.bind(this)).then(function(){N.loadStyles('InPageStyles').then(function(u1){var v1=u1.replace(/%scrollWidth%/g,K.getScrollbarWidth()+'px');K.insertStyles(v1,O.getOverlayContainer().get(0));});}).then(function(){return r1;}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){if(W.browser.name==="ff"){q(document).on('contextmenu',o1);}}).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);var u1=Z.getOverlay(this.getRootControl());this._$RootControl=u1.getAssociatedDomRef();if(this._$RootControl){this._$RootControl.addClass("sapUiRtaRoot");}}.bind(this)).then(function(){this._sStatus=h1;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this)).catch(function(s1){if(s1!=="Reload triggered"){this._sStatus=j1;this.fireFailed(s1);}if(s1){this.destroy();return Promise.reject(s1);}}.bind(this));}};function o1(){return false;}n1.prototype._getToolbarButtonsVisibility=function(){return z.isPublishAvailable().then(function(r1){return Q.isSaveAsAvailable(this.getRootControlInstance(),this.getLayer(),this._oSerializer).then(function(s1){return{publishAvailable:r1,saveAsAvailable:r1&&s1};});}.bind(this));};n1.prototype._isOldVersionDisplayed=function(){return V.isOldVersionDisplayed({selector:this.getRootControlInstance(),layer:this.getLayer()});};n1.prototype._isDraftAvailable=function(){return V.isDraftAvailable({selector:this.getRootControlInstance(),layer:this.getLayer()});};var p1=function(r1){J.hide();var s1=r1.userMessage||r1.stack||r1.message||r1.status||r1;var t1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");b1.error("Failed to transfer changes",s1);var u1=t1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+t1.getText("MSG_ERROR_REASON",s1);G.error(u1,{styleClass:U.getRtaStyleClassName()});};n1.prototype.setCommandStack=function(r1){var s1=this.getProperty("commandStack");if(s1){s1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var t1=this.setProperty("commandStack",r1);if(r1){r1.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(r1);}return t1;};n1.prototype.getCommandStack=function(){var r1=this.getProperty("commandStack");if(!r1){r1=new C();this._oInternalCommandStack=r1;this.setCommandStack(r1);}return r1;};n1.prototype._onStackModified=function(){var r1=this._oVersionsModel.getProperty("/backendDraft");var s1=this._oVersionsModel.getProperty("/displayedVersion")===sap.ui.fl.Versions.Draft;var t1=this.getCommandStack();var u1=t1.canUndo();if(!this.getShowToolbars()||!u1||this._bUserDiscardedDraft||s1||!r1){return this._modifyStack();}return U.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_DIALOG",actions:[G.Action.OK,G.Action.CANCEL],emphasizedAction:G.Action.OK}).then(function(v1){if(v1===G.Action.OK){this._discardDraftConfirmed();}else{this.undo();}}.bind(this));};n1.prototype._discardDraftConfirmed=function(){this._bUserDiscardedDraft=true;this._modifyStack();};n1.prototype._modifyStack=function(){if(this.getShowToolbars()){var r1=this.getCommandStack();var s1=r1.canUndo();var t1=r1.canRedo();this._oVersionsModel.setDirtyChanges(s1);this._oToolbarControlsModel.setProperty("/undoEnabled",s1);this._oToolbarControlsModel.setProperty("/redoEnabled",t1);this._oToolbarControlsModel.setProperty("/publishEnabled",this.bInitialPublishEnabled||s1);this._oToolbarControlsModel.setProperty("/restoreEnabled",this.bInitialResetEnabled||s1);}this.fireUndoRedoStackModified();return Promise.resolve();};n1.prototype._checkToolbarAndExecuteFunction=function(r1,s1){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[r1](s1);}};n1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}return[];};n1.prototype.stop=function(r1,s1){this._checkToolbarAndExecuteFunction("setBusy",true);return this._handleReloadOnExit(s1).then(function(t1){return((r1)?Promise.resolve():this._serializeToLrep(this)).then(this._checkToolbarAndExecuteFunction.bind(this,"hide")).then(function(){this.fireStop();if(t1.reloadMethod&&(t1.reloadMethod!==this._RELOAD.NOT_NEEDED)){t1.deleteMaxLayer=true;t1.triggerHardReload=(t1.reloadMethod===this._RELOAD.RELOAD_PAGE);return this._handleUrlParameterOnExit(t1);}}.bind(this));}.bind(this)).catch(p1).then(function(){this._checkToolbarAndExecuteFunction("setBusy",false);this._sStatus=i1;q("body").removeClass("sapUiRtaMode");}.bind(this));};n1.prototype.restore=function(){return this._onRestore();};n1.prototype.transport=function(){return this._onTransport();};n1.prototype.undo=function(){return this._onUndo();};n1.prototype.redo=function(){return this._onRedo();};n1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};n1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};n1.prototype._onKeyDown=function(r1){var s1=W.os.macintosh;var t1=O.getOverlayContainer().get(0).contains(document.activeElement);var u1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var v1=false;q(".sapUiDtContextMenu").each(function(z1,A1){if(A1.contains(document.activeElement)){v1=true;}});var w1=document.body===document.activeElement;var x1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((t1||u1||v1||w1)&&!x1){var y1=s1?r1.metaKey:r1.ctrlKey;if(r1.keyCode===c1.Z&&r1.shiftKey===false&&r1.altKey===false&&y1===true){this._onUndo().then(r1.stopPropagation.bind(r1));}else if(((s1&&r1.keyCode===c1.Z&&r1.shiftKey===true)||(!s1&&r1.keyCode===c1.Y&&r1.shiftKey===false))&&r1.altKey===false&&y1===true){this._onRedo().then(r1.stopPropagation.bind(r1));}}};n1.prototype._onUnload=function(){var r1=this.getCommandStack();var s1=r1.canUndo()||r1.canRedo();if(s1&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES");}window.onbeforeunload=this._oldUnloadHandler;};n1.prototype._serializeAndSave=function(){return this._oSerializer.saveCommands(this._oVersionsModel.getProperty("/versioningEnabled"));};n1.prototype._serializeToLrep=function(){if(!this._bReloadNeeded){return this._oSerializer.needsReload().then(function(r1){this._bReloadNeeded=r1;return this._serializeAndSave();}.bind(this));}return this._serializeAndSave();};n1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};n1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};n1.prototype._onActivate=function(r1){var s1=r1.getParameter("versionTitle");if(this._isOldVersionDisplayed()&&this._isDraftAvailable()){return U.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[G.Action.OK,G.Action.CANCEL],emphasizedAction:G.Action.OK}).then(function(t1){if(t1===G.Action.OK){this._activate(s1);}}.bind(this));}return this._activate(s1);};n1.prototype._activate=function(r1){var s1=this.getLayer();var t1=this.getRootControlInstance();return V.activate({layer:s1,selector:t1,title:r1}).then(function(){this._showMessageToast("MSG_DRAFT_ACTIVATION_SUCCESS");this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restoreEnabled",true);this.getCommandStack().removeAllCommands();}.bind(this)).catch(function(u1){U.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:u1});});};n1.prototype._handleDiscard=function(){var r1=this.getLayer();n1.enableRestart(r1,this.getRootControlInstance());if(!v.getUshellContainer()){var s1={hasDraftChanges:false,layer:r1};this.getCommandStack().removeAllCommands();return this._triggerHardReload(s1);}var t1=true;this.getCommandStack().removeAllCommands();var u1=this._removeVersionParameterForFLP(v.getParsedURLHash(),t1);this._triggerCrossAppNavigation(u1);return this.stop(true,true);};n1.prototype._onDiscardDraft=function(){return U.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[G.Action.OK,G.Action.CANCEL],emphasizedAction:G.Action.OK}).then(function(r1){if(r1===G.Action.OK){return V.discardDraft({layer:this.getLayer(),selector:this.getRootControlInstance(),updateState:true}).then(this._handleDiscard.bind(this));}}.bind(this));};n1.prototype._onSwitchVersion=function(r1){var s1=r1.getParameter("version");var t1=this._oVersionsModel.getProperty("/displayedVersion");if(s1===t1){return;}if(this.canUndo()){this._nSwitchToVersion=s1;return U.showMessageBox("warning","MSG_SWITCH_VERSION_DIALOG",{titleKey:"TIT_SWITCH_VERSION_DIALOG",actions:[G.Action.YES,G.Action.NO,G.Action.CANCEL],emphasizedAction:G.Action.YES}).then(function(u1){switch(u1){case G.Action.YES:return this._serializeToLrep(this).then(this._switchVersion.bind(this,this._nSwitchToVersion));case G.Action.NO:this.getCommandStack().removeAllCommands(true);this._switchVersion(this._nSwitchToVersion);}}.bind(this));}this._switchVersion(s1);};n1.prototype._switchVersion=function(r1){var s1=r1.toString();n1.enableRestart(this.getLayer(),this.getRootControlInstance());if(!v.getUshellContainer()){var t1={versionSwitch:true,version:s1};return this._triggerHardReload(t1);}var u1=v.getParsedURLHash();V.loadVersionForApplication({selector:this.getRootControlInstance(),layer:this.getLayer(),version:r1});var v1=u1.params[sap.ui.fl.Versions.UrlParameter];if(v1&&v1[0]===s1){v.getUshellContainer().getService("AppLifeCycle").reloadCurrentApp();}else{u1.params[sap.ui.fl.Versions.UrlParameter]=s1;this._triggerCrossAppNavigation(u1);}};n1.prototype._setUriParameter=function(r1){document.location.search=r1;};n1.prototype._createToolsMenu=function(r1){if(!this.getDependent('toolbar')){var s1;if(this.getLayer()===x.USER){s1=P;}else if(U.isOriginalFioriToolbarAccessible()){s1=F;}else if(U.getFiori2Renderer()){s1=a;}else{s1=S;}var t1;if(this.getLayer()===x.USER){t1=new s1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)});}else{t1=new s1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:Q.onGetOverview.bind(null,true,this.getLayer()),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:Q.onSaveAs.bind(Q,true,true,this.getLayer(),null),activate:this._onActivate.bind(this),discardDraft:this._onDiscardDraft.bind(this),switchVersion:this._onSwitchVersion.bind(this)});}this.addDependent(t1,'toolbar');return t1.onFragmentLoaded().then(function(){var u1=r1.saveAsAvailable;var v1=u1&&Q.isOverviewExtended();var w1=_.fromQuery(window.location.search);var x1=w1.get("sap-ui-rta-xx-changeVisualization")==="true";this._oToolbarControlsModel=new d1({undoEnabled:false,redoEnabled:false,publishVisible:r1.publishAvailable,publishEnabled:this.bInitialPublishEnabled,restoreEnabled:this.bInitialResetEnabled,appVariantsOverviewVisible:u1&&v1,appVariantsOverviewEnabled:u1&&v1,saveAsVisible:u1,saveAsEnabled:false,manageAppsVisible:u1&&!v1,manageAppsEnabled:u1&&!v1,showChangesVisible:x1,rtaRootControlId:this.getRootControl(),modeSwitcher:this.getMode()});if(u1){Q.isManifestSupported().then(function(y1){this._oToolbarControlsModel.setProperty("/saveAsEnabled",y1);this._oToolbarControlsModel.setProperty("/appVariantsOverviewEnabled",y1);this._oToolbarControlsModel.setProperty("/manageAppsEnabled",y1);}.bind(this));}this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");}.bind(this));}return Promise.resolve();};n1.prototype._onGetAppVariantOverview=function(r1){var s1=r1.getParameter("item");var t1=s1.getId()==='keyUser';return Q.onGetOverview(t1,this.getLayer());};n1.prototype.destroy=function(){q.map(this._dependents,function(r1,s1){this.removeDependent(s1);r1.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(r1){this.stopService(r1);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._$RootControl){this._$RootControl.removeClass("sapUiRtaRoot");}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(W.browser.name==="ff"){q(document).off("contextmenu",o1);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};n1.prototype._onTransport=function(){this._handleStopCutPaste();J.show(500);return this._serializeToLrep().then(function(){J.hide();var r1=v.isApplicationVariant(this._oRootControl)&&!v.isVariantByStartupParameter(this._oRootControl);return((r1)?Q.getAppVariantDescriptor(this._oRootControl):Promise.resolve()).then(function(s1){var t1=[];if(s1){t1.push(s1);}return B.publish({selector:this.getRootControlInstance(),styleClass:U.getRtaStyleClassName(),layer:this.getLayer(),appVariantDescriptors:t1}).then(function(u1){if(u1!=="Error"&&u1!=="Cancel"){H.show(u1);if(this.getShowToolbars()){B.getResetAndPublishInfo({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(v1){this._oToolbarControlsModel.setProperty("/publishEnabled",v1.isPublishEnabled);this._oToolbarControlsModel.setProperty("/restoreEnabled",v1.isResetEnabled);}.bind(this));}}}.bind(this));}.bind(this));}.bind(this))['catch'](p1);};n1.prototype._deleteChanges=function(){var r1=this.getLayer();return B.reset({selector:v.getAppComponentForControl(this.getRootControlInstance()),layer:r1,generator:"Change.createInitialFileContent"}).then(function(){var s1={hasDraftChanges:y.hasVersionParameterWithValue({value:r1}),layer:r1,deleteMaxLayer:false,triggerHardReload:true};return this._handleUrlParameterOnExit(s1);}.bind(this)).catch(function(s1){if(s1!=="cancel"){U.showMessageBox("error","MSG_RESTORE_FAILED",{error:s1});}});};n1.prototype._reloadPage=function(){window.location.reload();};n1.prototype._showMessageToast=function(r1){var s1=this._getTextResources().getText(r1);H.show(s1);};n1.needsRestart=function(r1){return!!window.sessionStorage.getItem("sap.ui.rta.restart."+r1);};n1.enableRestart=function(r1,s1){var t1=v.getComponentClassName(s1);var u1=t1||true;window.sessionStorage.setItem("sap.ui.rta.restart."+r1,u1);};n1.disableRestart=function(r1){window.sessionStorage.removeItem("sap.ui.rta.restart."+r1);};n1.prototype._onRestore=function(){var r1=this.getLayer();var s1=r1===x.USER?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var t1=r1===x.USER?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");this._handleStopCutPaste();return U.showMessageBox("warning",s1,{titleKey:t1,actions:[G.Action.OK,G.Action.CANCEL],emphasizedAction:G.Action.OK}).then(function(u1){if(u1===G.Action.OK){n1.enableRestart(r1,this.getRootControlInstance());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this));};n1.prototype._scheduleOnCreated=function(r1,s1){function t1(u1){var v1=u1.getParameter("elementOverlay");if(v1.getElement().getId()===r1){this._oDesignTime.detachEvent("elementOverlayCreated",t1,this);s1(v1);}}this._oDesignTime.attachEvent("elementOverlayCreated",t1,this);};n1.prototype._scheduleOnCreatedAndVisible=function(r1,s1){function t1(v1){var w1=v1.getSource();if(w1.getGeometry()&&w1.getGeometry().visible){w1.detachEvent("geometryChanged",t1);s1(w1);}}function u1(v1){if(!v1.getGeometry()||!v1.getGeometry().visible){v1.attachEvent('geometryChanged',t1);}else{s1(v1);}}this._scheduleOnCreated(r1,function(v1){if(v1.isRendered()){u1(v1);}else{v1.attachEventOnce('afterRendering',function(w1){u1(w1.getSource());});}});};n1.prototype._scheduleRenameOnCreatedContainer=function(r1,s1){var t1=function(u1){u1.setSelected(true);this.getPlugins()["rename"].startEdit(u1);}.bind(this);this._scheduleOnCreatedAndVisible(s1,function(u1){var v1=this.getPlugins()["createContainer"].getCreatedContainerId(r1,u1.getElement().getId());var w1=Z.getOverlay(v1);if(w1){t1(w1);}else{this._scheduleOnCreatedAndVisible(v1,t1);}}.bind(this));};n1.prototype._handleElementModified=function(r1){this._handleStopCutPaste();var s1=r1.getParameter("action");var t1=r1.getParameter("newControlId");var u1=r1.getParameter("command");if(u1 instanceof sap.ui.rta.command.BaseCommand){if(t1){this._scheduleOnCreated(t1,function(v1){var w1=v1.getDesignTimeMetadata();var x1=w1.getData().select;if(typeof x1==="function"){x1(v1.getElement());}});if(s1){this._scheduleRenameOnCreatedContainer(s1,t1);}}return this.getCommandStack().pushAndExecute(u1).catch(function(v1){if(v1&&v1.message&&v1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:v1});}b1.error("sap.ui.rta: "+v1.message);});}return Promise.resolve();};n1.prototype._onElementEditableChange=function(r1){var s1=r1.getParameter("editable");if(s1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};n1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};n1.prototype._buildNavigationArguments=function(r1){return{target:{semanticObject:r1.semanticObject,action:r1.action,context:r1.contextRaw},params:r1.params,appSpecificRoute:r1.appSpecificRoute,writeHistory:false};};n1.prototype._triggerCrossAppNavigation=function(r1){if(this.getLayer()!==x.USER){return v.ifUShellContainerThen(function(s1){s1[0].toExternal(this._buildNavigationArguments(r1));return Promise.resolve(true);}.bind(this),["CrossApplicationNavigation"]);}};n1.prototype._removeVersionParameterForFLP=function(r1,s1){var t1=this.getLayer();if(t1===x.USER){return r1;}var u1=v.getParameter(u.Versions.UrlParameter);if(u1){delete r1.params[u.Versions.UrlParameter];}else if(this._isDraftAvailable()||s1){v.getUshellContainer().getService("AppLifeCycle").reloadCurrentApp();}return r1;};n1.prototype._removeMaxLayerParameterForFLP=function(r1,s1){if(r1.deleteMaxLayer&&r1.hasHigherLayerChanges){delete s1.params[w.FL_MAX_LAYER_PARAM];}return s1;};n1.prototype._handleUrlParameterOnExit=function(r1){if(!v.getUshellContainer()){return this._triggerHardReload(r1);}var s1=v.getParsedURLHash();if(!s1){return;}s1=this._removeMaxLayerParameterForFLP(r1,s1);s1=this._removeVersionParameterForFLP(s1);this._triggerCrossAppNavigation(s1);if(r1.triggerHardReload){this._reloadPage();}};n1.prototype._getReloadMessageOnStart=function(r1){var s1;var t1=r1.layer===x.CUSTOMER;if(r1.hasHigherLayerChanges&&r1.hasDraftChanges){s1=t1?"MSG_PERSONALIZATION_AND_DRAFT_EXISTS":"MSG_HIGHER_LAYER_CHANGES_AND_DRAFT_EXISTS";}else if(r1.hasHigherLayerChanges){s1=t1?"MSG_PERSONALIZATION_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";}else if(r1.hasDraftChanges){s1="MSG_DRAFT_EXISTS";}return s1;};n1.prototype._getReloadMessageOnExit=function(r1){var s1=r1.layer===x.CUSTOMER;if(r1.hasHigherLayerChanges){if(!s1){return"MSG_RELOAD_WITH_ALL_CHANGES";}if(r1.hasDraft){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_WITHOUT_DRAFT";}return"MSG_RELOAD_WITH_PERSONALIZATION";}if(r1.initialDraftGotActivated){return"MSG_RELOAD_ACTIVATED_DRAFT";}if(r1.hasDraft){return"MSG_RELOAD_WITHOUT_DRAFT";}if(r1.changesNeedReload){return"MSG_RELOAD_NEEDED";}};n1.prototype._handleReloadMessageBoxOnExit=function(r1){var s1=this._getReloadMessageOnExit(r1);if(s1){return U.showMessageBox("information",s1,{titleKey:"HEADER_RELOAD_NEEDED"});}return Promise.resolve();};n1.prototype._triggerReloadOnStart=function(r1){v.ifUShellContainerThen(function(){if(r1.hasDraftChanges){V.loadDraftForApplication({selector:r1.selector,layer:r1.layer});}else{V.loadVersionForApplication({selector:r1.selector,layer:r1.layer});}},["CrossApplicationNavigation"]);var s1=this._getReloadMessageOnStart(r1);if(!s1){return Promise.resolve();}return U.showMessageBox("information",s1).then(function(){n1.enableRestart(r1.layer);if(v.getUshellContainer()){var t1=y.handleParametersOnStart(r1);return this._triggerCrossAppNavigation(t1);}return this._triggerHardReload(r1);}.bind(this));};n1.prototype._determineReload=function(){var r1={hasHigherLayerChanges:false,hasDraftChanges:false,layer:this.getLayer(),selector:this.getRootControlInstance(),ignoreMaxLayerParameter:false};return y.getReloadReasonsForStart(r1).then(function(r1){if(r1.hasHigherLayerChanges||r1.hasDraftChanges){return this._triggerReloadOnStart(r1);}}.bind(this));};n1.prototype._triggerHardReload=function(r1){r1.parameters=document.location.search;var s1=y.handleUrlParametersForStandalone(r1);if(document.location.search!==s1){this._setUriParameter(s1);return Promise.resolve();}return this._reloadPage();};n1.prototype._handleReloadOnExit=function(r1){if(r1){return Promise.resolve({reloadMethod:this._RELOAD.NOT_NEEDED});}var s1=this._bReloadNeeded?Promise.resolve(this._bReloadNeeded):this._oSerializer.needsReload();return s1.then(function(t1){var u1={layer:this.getLayer(),selector:this.getRootControlInstance(),changesNeedReload:t1,hasDirtyDraftChanges:this._oVersionsModel.getProperty("/draftAvailable")&&this._oVersionsModel.getProperty("/dirtyChanges"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion")};u1=y.getReloadMethod(u1);return this._handleReloadMessageBoxOnExit(u1).then(function(){return u1;});}.bind(this));};n1.prototype._onModeChange=function(r1){this.setMode(r1.getParameter("item").getKey());};n1.prototype.setMode=function(r1){if(this.getMode()!==r1){var s1=r1==='adaptation';this._oDesignTime.setEnabled(s1);this.getPlugins()['tabHandling'][s1?'removeTabIndex':'restoreTabIndex']();this._oToolbarControlsModel.setProperty("/modeSwitcher",r1);this.setProperty('mode',r1);this.fireModeChanged({mode:r1});}};n1.prototype.setMetadataScope=function(r1){if(this._oDesignTime){b1.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',r1);};function q1(r1){if(X.hasOwnProperty(r1)){return X[r1].replace(/\./g,'/');}}n1.prototype.startService=function(r1){if(this._sStatus!==h1){return new Promise(function(u1,v1){this.attachEventOnce('start',u1);this.attachEventOnce('failed',v1);}.bind(this)).then(function(){return this.startService(r1);}.bind(this),function(){return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Can't start the service '{0}' while RTA has been failed during a startup",r1),"sap.ui.rta"));});}var s1=q1(r1);var t1;if(!s1){return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Unknown service. Can't find any registered service by name '{0}'",r1),"sap.ui.rta"));}t1=this._mServices[r1];if(t1){switch(t1.status){case l1:{return Promise.resolve(t1.exports);}case k1:{return t1.initPromise;}case m1:{return t1.initPromise;}default:{return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Unknown service status. Service name = '{0}'",r1),"sap.ui.rta"));}}}else{this._mServices[r1]=t1={status:k1,location:s1,initPromise:new Promise(function(u1,v1){sap.ui.require([s1],function(w1){t1.factory=w1;if(!this._oServiceEventBus){this._oServiceEventBus=new Y();}t.wrapIntoPromise(w1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,r1)).then(function(x1){if(this.bIsDestroyed){throw t.createError("RuntimeAuthoring#startService",t.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",r1),"sap.ui.rta");}if(!q.isPlainObject(x1)){throw t.createError("RuntimeAuthoring#startService",t.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",r1),"sap.ui.rta");}t1.service=x1;t1.exports={};if(Array.isArray(x1.events)&&x1.events.length>0){q.extend(t1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,r1),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,r1),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,r1)});}var y1=x1.exports||{};q.extend(t1.exports,Object.keys(y1).reduce(function(z1,A1){var B1=y1[A1];z1[A1]=typeof B1==="function"?t.waitForSynced(this._oDesignTime,B1):B1;return z1;}.bind(this),{}));t1.status=l1;u1(Object.freeze(t1.exports));}.bind(this)).catch(v1);}.bind(this),function(w1){t1.status=m1;v1(t.propagateError(w1,"RuntimeAuthoring#startService",t.printf("Can't load service '{0}' by its name: {1}",r1,s1),"sap.ui.rta"));});}.bind(this)).catch(function(u1){t1.status=m1;return Promise.reject(t.propagateError(u1,"RuntimeAuthoring#startService",t.printf("Error during service '{0}' initialisation.",r1),"sap.ui.rta"));})};return t1.initPromise;}};n1.prototype.stopService=function(r1){var s1=this._mServices[r1];if(s1){if(s1.status===l1){if(typeof s1.service.destroy==="function"){s1.service.destroy();}}delete this._mServices[r1];}else{throw t.createError("RuntimeAuthoring#stopService",t.printf("Can't destroy service: unable to find service with name '{0}'",r1),"sap.ui.rta");}};n1.prototype.getService=function(r1){return this.startService(r1);};return n1;});
