//@ui5-bundle sap/ui/rta/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/rta/api/startAdaptation',["sap/ui/rta/util/adaptationStarter","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/base/util/merge"],function(a,L,b,m){"use strict";
function c(l){if(!b.isValidLayer(l)){throw new Error("An invalid layer is passed");}}
function s(o,l,d,e,f){var D={flexSettings:{developerMode:false,layer:L.CUSTOMER}};o=m(D,o);return Promise.resolve().then(c.bind(this,o.flexSettings.layer)).then(a.bind(this,o,l,d,e,f));}
return s;});
sap.ui.predefine('sap/ui/rta/api/startKeyUserAdaptation',["sap/ui/rta/util/adaptationStarter","sap/ui/fl/Layer"],function(a,L){"use strict";
function s(p){var o={rootControl:p.rootControl,flexSettings:{developerMode:false,layer:L.CUSTOMER}};return a(o);}
return s;});
sap.ui.predefine('sap/ui/rta/util/adaptationStarter',["sap/ui/rta/RuntimeAuthoring","sap/ui/core/Element","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/write/api/FeaturesAPI","sap/ui/core/UIComponent","sap/base/Log"],function(R,E,F,L,a,U,b){"use strict";
function c(l){if(L.CUSTOMER===l){return a.isKeyUser().then(function(i){if(!i){throw new Error("Key user rights have not been granted to the current user");}});}return Promise.resolve();}
function d(o,l,e,f,g){if(!(o.rootControl instanceof E)&&!(o.rootControl instanceof U)){return Promise.reject(new Error("An invalid root control was passed"));}var r;return c(o.flexSettings.layer).then(function(){o.rootControl=F.getAppComponentForControl(o.rootControl);r=new R(o);if(e){r.attachEvent("start",e);}if(f){r.attachEvent("failed",f);}var O=g||function(){r.destroy();};r.attachEvent("stop",O);if(l){return l(r);}}).then(function(){return r.start();}).then(function(){return r;}).catch(function(h){b.error("UI Adaptation could not be started",h.message);throw h;});}
return d;});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/rta/Client',["sap/ui/base/ManagedObject","sap/ui/core/postmessage/Bus","sap/base/util/uid","sap/base/util/merge","sap/ui/rta/util/ServiceEventBus","sap/ui/thirdparty/URI"],function(M,P,u,m,S,U){"use strict";var C='sap.ui.rta.service.receiver';var a='pending';var b='accepted';var c='declined';
var d=M.extend("sap.ui.rta.Client",{
metadata:{library:"sap.ui.rta",properties:{window:"object",origin:"string"}},
_bInit:false,
constructor:function(){M.apply(this,arguments);if(!this.getWindow()){throw new TypeError("sap.ui.rta.Client: window parameter is required");}if(!this.getOrigin()){throw new TypeError("sap.ui.rta.Client: origin parameter is required");}this._oPostMessageBus=P.getInstance();this._sStatus=a;this._mPendingRequests={};this._aRequestQueue=[];this._oServiceEventBus=null;this._mEventHandlerIds={};this._oPostMessageBus.subscribeOnce(C,P.event.READY,function(e){if(!this._isValidMessage(e)){return;}this._oPostMessageBus.subscribeOnce(C,P.event.ACCEPTED,function(e){if(!this._isValidMessage(e)){return;}this._sStatus=b;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(this._sendRequest,this);this._oPostMessageBus.subscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'event',this._receiverEvents,this);},this);this._oPostMessageBus.subscribeOnce(C,P.event.DECLINED,function(e){if(!this._isValidMessage(e)){return;}this._sStatus=c;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(function(R){R.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));});},this);this._oPostMessageBus.publish({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:P.event.CONNECT,data:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("SERVICE_NAME")});},this);this._bInit=true;}
});
d.prototype.destroy=function(){this._oPostMessageBus.unsubscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'event',this._receiverEvents,this);M.prototype.destroy.apply(this,arguments);};
d.prototype.getService=function(s){if(typeof s!=="string"){throw new TypeError('sap.ui.rta.Client.getService(): invalid service name specified');}return this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'getService',data:{arguments:[s]}}));};
d.prototype._createRequest=function(p){var r=u();var R={id:r,request:{target:p.target,origin:p.origin,channelId:C,eventId:p.eventId,data:{id:r,type:'request',body:p.data}}};R.promise=new Promise(function(f,e){R.resolve=f;R.reject=e;});return R;};
d.prototype._sendRequest=function(r){switch(this._sStatus){case b:this._mPendingRequests[r.id]=r;this._oPostMessageBus.publish(r.request);break;case a:this._aRequestQueue.push(r);break;case c:r.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));break;}return r.promise;};
d.prototype._isValidMessage=function(e){return this.getWindow()===e.source&&this.getOrigin()===e.origin;};
d.prototype._receiverMethods=function(e){if(!this._isValidMessage(e)){return;}var D=e.data;if(D.type!=='response'){return;}var r=this._mPendingRequests[D.id];switch(e.eventId){case'getService':var s=r.request.data.body.arguments[0];var f=D.body.methods||[];var E=D.body.events;var g=m(f.reduce(function(R,h){R[h]=function(){return this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:C,eventId:'callMethod',data:{service:s,method:h,arguments:Array.prototype.slice.call(arguments)}}));}.bind(this);return R;}.bind(this),{}),D.body.properties);if(Array.isArray(E)&&E.length>0){if(!this._oServiceEventBus){this._oServiceEventBus=new S();}m(g,{attachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling attachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling attachEvent() for a service");}var j=this._oServiceEventBus.getChannel(s);var k=!j||!j.hasListeners(h);this._oServiceEventBus.subscribe(s,h,i,o);if(k){this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:C,eventId:'subscribe',data:{service:s,event:h}})).then(function(R){this._mEventHandlerIds[s+','+h]=R.id;this._checkIfEventAlive(s,h);}.bind(this));}}.bind(this),detachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling detachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling detachEvent() for a service");}this._oServiceEventBus.unsubscribe(s,h,i,o);this._checkIfEventAlive(s,h);}.bind(this),attachEventOnce:function(h,i,o){function O(){g.detachEvent(h,O);i.apply(o,arguments);}g.attachEvent(h,O);}});}r.resolve(g);delete this._mPendingRequests[D.id];break;case'callMethod':if(D.status==='success'){r.resolve(D.body);}else{r.reject(D.body);}delete this._mPendingRequests[D.id];break;case'subscribe':case'unsubscribe':r.resolve(D.body);delete this._mPendingRequests[D.id];break;}};
d.prototype._checkIfEventAlive=function(s,e){var E=this._oServiceEventBus.getChannel(s);var f=this._mEventHandlerIds[s+','+e];if((!E||!E.hasListeners(e))&&f){this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'unsubscribe',data:{service:s,event:e,id:f}}));}};
d.prototype._receiverEvents=function(e){if(!this._isValidMessage(e)){return;}var r=e.data.body;this._oServiceEventBus.publish(r.service,r.event,r.data);};
d.prototype.setWindow=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Window parameter cannot be changed at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Window parameter is required");}if(v===window){throw new TypeError("sap.ui.rta.Client: Window object has to be different from the one where Client is running");}this.setProperty('window',v);return this;};
d.prototype.setOrigin=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Cannot change origin parameter at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Origin parameter is required");}if(typeof v!=='string'){throw new TypeError("sap.ui.rta.Client: Origin parameter has to be a string");}if(new U(v).origin()!==v){throw new TypeError("sap.ui.rta.Client: Origin string is invalid");}this.setProperty('origin',v);return this;};
return d;});
sap.ui.predefine('sap/ui/rta/RuntimeAuthoring',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/rta/toolbar/FioriLike","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/ControlVariant","sap/ui/rta/plugin/iframe/AddIFrame","sap/ui/dt/plugin/ToolHooks","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/library","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/model/json/JSONModel","sap/ui/core/Fragment","sap/ui/rta/util/validateFlexEnabled"],function(q,M,F,S,P,a,D,O,C,b,L,R,c,d,e,f,g,A,h,i,j,k,l,m,n,o,p,T,r,s,U,t,E,u,v,w,x,y,z,V,B,G,H,I,J,K,N,Q,W,X,Y,Z,$,_,a1,b1,c1,d1,e1,f1){"use strict";var g1="STARTING";var h1="STARTED";var i1="STOPPED";var j1="FAILED";var k1="SERVICE_STARTING";var l1="SERVICE_STARTED";var m1="SERVICE_FAILED";
var n1=M.extend("sap.ui.rta.RuntimeAuthoring",{
metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{customFieldUrl:"string",showCreateCustomField:"boolean",showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},plugins:{type:"any",defaultValue:{}},flexSettings:{type:"object",defaultValue:{layer:x.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},
_sAppTitle:null,
_dependents:null,
_sStatus:i1,
constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new I(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}if(this._shouldValidateFlexEnabled()){this.attachEvent("start",f1.bind(null,this));}},
_RELOAD:{NOT_NEEDED:"NO_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION",RELOAD_PAGE:"HARD_RELOAD"}
});
n1.prototype._shouldValidateFlexEnabled=function(){var r1=document.location.hostname;var s1=r1.endsWith(".sap"+".corp")||r1==="localhost";if(s1){var t1=_.fromQuery(window.location.search).get("sap-ui-rta-skip-flex-validation");s1=t1!=="true";}return s1;};
n1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var r1=new b({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:r1,multiSelectionRequiredPlugins:[j.getMetadata().getName(),f.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var s1=new d({commandFactory:r1});this._mDefaultPlugins["dragDrop"]=new c({elementMover:s1,commandFactory:r1,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:r1,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:r1,analyzer:i,dialog:new h()});this._mDefaultPlugins["createContainer"]=new g({commandFactory:r1});this._mDefaultPlugins["remove"]=new f({commandFactory:r1});this._mDefaultPlugins["cutPaste"]=new e({elementMover:s1,commandFactory:r1});this._mDefaultPlugins["settings"]=new m({commandFactory:r1});this._mDefaultPlugins["combine"]=new j({commandFactory:r1});this._mDefaultPlugins["split"]=new k({commandFactory:r1});this._mDefaultPlugins["contextMenu"]=new r();this._mDefaultPlugins["tabHandling"]=new s();this._mDefaultPlugins["stretch"]=new n();this._mDefaultPlugins["controlVariant"]=new o({commandFactory:r1});this._mDefaultPlugins["addIFrame"]=new p({commandFactory:r1});this._mDefaultPlugins["toolHooks"]=new T();}return q.extend({},this._mDefaultPlugins);};
n1.prototype.addDependent=function(r1,s1,t1){t1=typeof t1==='undefined'?true:!!t1;if(!(s1 in this._dependents)){if(s1&&t1){this['get'+$(s1,0)]=this.getDependent.bind(this,s1);}this._dependents[s1||r1.getId()]=r1;}else{throw t.createError("RuntimeAuthoring#addDependent",t.printf("Can't add dependency with same key '{0}'",s1),"sap.ui.rta");}};
n1.prototype.getDependent=function(r1){return this._dependents[r1];};
n1.prototype.getDependents=function(){return this._dependents;};
n1.prototype.removeDependent=function(r1){delete this._dependents[r1];};
n1.prototype._destroyDefaultPlugins=function(r1){for(var s1 in this._mDefaultPlugins){var t1=this._mDefaultPlugins[s1];if(t1&&!t1.bIsDestroyed){if(!r1||r1[s1]!==t1){t1.destroy();}}}if(!r1){this._mDefaultPlugins=null;}};
n1.prototype.onPopupOpen=function(r1){var s1=r1.getParameters().getSource();if(s1.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};
n1.prototype.onPopupClose=function(r1){if(r1.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};
n1.prototype.setPlugins=function(r1){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",r1);};
n1.prototype.setFlexSettings=function(r1){var s1=_.fromQuery(window.location.search);var t1=s1.get("sap-ui-layer");r1=q.extend({},this.getFlexSettings(),r1);if(t1){r1.layer=t1.toUpperCase();}if(r1.scenario||r1.baseId){var u1=v.buildLrepRootNamespace(r1.baseId,r1.scenario,r1.projectId);r1.rootNamespace=u1;r1.namespace=u1+"changes/";}U.setRtaStyleClassName(r1.layer);this.setProperty("flexSettings",r1);};
n1.prototype.getLayer=function(){return this.getFlexSettings().layer;};
n1.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};
n1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
n1.prototype._setVersionsModel=function(r1){this._oVersionsModel=r1;};
n1.prototype._initVersioning=function(){return V.initialize({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(this._setVersionsModel.bind(this));};
n1.prototype.start=function(){this._sStatus=g1;var r1;var s1;var t1=this.getRootControlInstance();if(!this._oDesignTime){if(!t1){s1=new Error("Root control not found");b1.error(s1);return Promise.reject(s1);}return this._initVersioning().then(this._determineReload.bind(this)).then(function(u1){if(u1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(x1){if(this.getPlugins()[x1].attachElementModified){this.getPlugins()[x1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var v1=Object.keys(this.getPlugins());var w1=v1.map(function(x1){return this.getPlugins()[x1];},this);r1=new Promise(function(x1,y1){a1.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:w1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()===x.USER){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}else{q("body").addClass("sapUiRtaMode");}this._oDesignTime.getSelectionManager().attachChange(function(z1){this.fireSelectionChange({selection:z1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){x1();a1.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(z1){y1(z1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){var u1={selector:this.getRootControlInstance(),layer:this.getLayer()};return B.getResetAndPublishInfo(u1).then(function(v1){this.bInitialResetEnabled=v1.isResetEnabled;this.bInitialPublishEnabled=v1.isPublishEnabled;}.bind(this));}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getToolbarButtonsVisibility().then(this._createToolsMenu.bind(this));}}.bind(this)).then(this._onStackModified.bind(this)).then(function(){N.loadStyles('InPageStyles').then(function(u1){var v1=u1.replace(/%scrollWidth%/g,K.getScrollbarWidth()+'px');K.insertStyles(v1,O.getOverlayContainer().get(0));});}).then(function(){return r1;}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){if(W.browser.name==="ff"){q(document).on('contextmenu',o1);}}).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);var u1=Z.getOverlay(this.getRootControl());this._$RootControl=u1.getAssociatedDomRef();if(this._$RootControl){this._$RootControl.addClass("sapUiRtaRoot");}}.bind(this)).then(function(){this._sStatus=h1;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this)).catch(function(s1){if(s1!=="Reload triggered"){this._sStatus=j1;this.fireFailed(s1);}if(s1){this.destroy();return Promise.reject(s1);}}.bind(this));}};
function o1(){return false;}
n1.prototype._getToolbarButtonsVisibility=function(){return z.isPublishAvailable().then(function(r1){return Q.isSaveAsAvailable(this.getRootControlInstance(),this.getLayer(),this._oSerializer).then(function(s1){return{publishAvailable:r1,saveAsAvailable:r1&&s1};});}.bind(this));};
n1.prototype._isOldVersionDisplayed=function(){return V.isOldVersionDisplayed({selector:this.getRootControlInstance(),layer:this.getLayer()});};
n1.prototype._isDraftAvailable=function(){return V.isDraftAvailable({selector:this.getRootControlInstance(),layer:this.getLayer()});};
var p1=function(r1){J.hide();var s1=r1.userMessage||r1.stack||r1.message||r1.status||r1;var t1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");b1.error("Failed to transfer changes",s1);var u1=t1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+t1.getText("MSG_ERROR_REASON",s1);G.error(u1,{styleClass:U.getRtaStyleClassName()});};
n1.prototype.setCommandStack=function(r1){var s1=this.getProperty("commandStack");if(s1){s1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var t1=this.setProperty("commandStack",r1);if(r1){r1.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(r1);}return t1;};
n1.prototype.getCommandStack=function(){var r1=this.getProperty("commandStack");if(!r1){r1=new C();this._oInternalCommandStack=r1;this.setCommandStack(r1);}return r1;};
n1.prototype._onStackModified=function(){var r1=this._oVersionsModel.getProperty("/backendDraft");var s1=this._oVersionsModel.getProperty("/displayedVersion")===sap.ui.fl.Versions.Draft;var t1=this.getCommandStack();var u1=t1.canUndo();if(!this.getShowToolbars()||!u1||this._bUserDiscardedDraft||s1||!r1){return this._modifyStack();}return U.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_DIALOG",actions:[G.Action.OK,G.Action.CANCEL],emphasizedAction:G.Action.OK}).then(function(v1){if(v1===G.Action.OK){this._discardDraftConfirmed();}else{this.undo();}}.bind(this));};
n1.prototype._discardDraftConfirmed=function(){this._bUserDiscardedDraft=true;this._modifyStack();};
n1.prototype._modifyStack=function(){if(this.getShowToolbars()){var r1=this.getCommandStack();var s1=r1.canUndo();var t1=r1.canRedo();this._oVersionsModel.setDirtyChanges(s1);this._oToolbarControlsModel.setProperty("/undoEnabled",s1);this._oToolbarControlsModel.setProperty("/redoEnabled",t1);this._oToolbarControlsModel.setProperty("/publishEnabled",this.bInitialPublishEnabled||s1);this._oToolbarControlsModel.setProperty("/restoreEnabled",this.bInitialResetEnabled||s1);}this.fireUndoRedoStackModified();return Promise.resolve();};
n1.prototype._checkToolbarAndExecuteFunction=function(r1,s1){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[r1](s1);}};
n1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}return[];};
n1.prototype.stop=function(r1,s1){this._checkToolbarAndExecuteFunction("setBusy",true);return this._handleReloadOnExit(s1).then(function(t1){return((r1)?Promise.resolve():this._serializeToLrep(this)).then(this._checkToolbarAndExecuteFunction.bind(this,"hide")).then(function(){this.fireStop();if(t1.reloadMethod&&(t1.reloadMethod!==this._RELOAD.NOT_NEEDED)){t1.deleteMaxLayer=true;t1.triggerHardReload=(t1.reloadMethod===this._RELOAD.RELOAD_PAGE);return this._handleUrlParameterOnExit(t1);}}.bind(this));}.bind(this)).catch(p1).then(function(){this._checkToolbarAndExecuteFunction("setBusy",false);this._sStatus=i1;q("body").removeClass("sapUiRtaMode");}.bind(this));};
n1.prototype.restore=function(){return this._onRestore();};
n1.prototype.transport=function(){return this._onTransport();};
n1.prototype.undo=function(){return this._onUndo();};
n1.prototype.redo=function(){return this._onRedo();};
n1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};
n1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};
n1.prototype._onKeyDown=function(r1){var s1=W.os.macintosh;var t1=O.getOverlayContainer().get(0).contains(document.activeElement);var u1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var v1=false;q(".sapUiDtContextMenu").each(function(z1,A1){if(A1.contains(document.activeElement)){v1=true;}});var w1=document.body===document.activeElement;var x1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((t1||u1||v1||w1)&&!x1){var y1=s1?r1.metaKey:r1.ctrlKey;if(r1.keyCode===c1.Z&&r1.shiftKey===false&&r1.altKey===false&&y1===true){this._onUndo().then(r1.stopPropagation.bind(r1));}else if(((s1&&r1.keyCode===c1.Z&&r1.shiftKey===true)||(!s1&&r1.keyCode===c1.Y&&r1.shiftKey===false))&&r1.altKey===false&&y1===true){this._onRedo().then(r1.stopPropagation.bind(r1));}}};
n1.prototype._onUnload=function(){var r1=this.getCommandStack();var s1=r1.canUndo()||r1.canRedo();if(s1&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES");}window.onbeforeunload=this._oldUnloadHandler;};
n1.prototype._serializeAndSave=function(){return this._oSerializer.saveCommands(this._oVersionsModel.getProperty("/versioningEnabled"));};
n1.prototype._serializeToLrep=function(){if(!this._bReloadNeeded){return this._oSerializer.needsReload().then(function(r1){this._bReloadNeeded=r1;return this._serializeAndSave();}.bind(this));}return this._serializeAndSave();};
n1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};
n1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};
n1.prototype._onActivate=function(r1){var s1=r1.getParameter("versionTitle");if(this._isOldVersionDisplayed()&&this._isDraftAvailable()){return U.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[G.Action.OK,G.Action.CANCEL],emphasizedAction:G.Action.OK}).then(function(t1){if(t1===G.Action.OK){this._activate(s1);}}.bind(this));}return this._activate(s1);};
n1.prototype._activate=function(r1){var s1=this.getLayer();var t1=this.getRootControlInstance();return V.activate({layer:s1,selector:t1,title:r1}).then(function(){this._showMessageToast("MSG_DRAFT_ACTIVATION_SUCCESS");this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restoreEnabled",true);this.getCommandStack().removeAllCommands();}.bind(this)).catch(function(u1){U.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:u1});});};
n1.prototype._handleDiscard=function(){var r1=this.getLayer();n1.enableRestart(r1,this.getRootControlInstance());if(!v.getUshellContainer()){var s1={hasDraftChanges:false,layer:r1};this.getCommandStack().removeAllCommands();return this._triggerHardReload(s1);}var t1=true;this.getCommandStack().removeAllCommands();var u1=this._removeVersionParameterForFLP(v.getParsedURLHash(),t1);this._triggerCrossAppNavigation(u1);return this.stop(true,true);};
n1.prototype._onDiscardDraft=function(){return U.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[G.Action.OK,G.Action.CANCEL],emphasizedAction:G.Action.OK}).then(function(r1){if(r1===G.Action.OK){return V.discardDraft({layer:this.getLayer(),selector:this.getRootControlInstance(),updateState:true}).then(this._handleDiscard.bind(this));}}.bind(this));};
n1.prototype._onSwitchVersion=function(r1){var s1=r1.getParameter("version");var t1=this._oVersionsModel.getProperty("/displayedVersion");if(s1===t1){return;}if(this.canUndo()){this._nSwitchToVersion=s1;return U.showMessageBox("warning","MSG_SWITCH_VERSION_DIALOG",{titleKey:"TIT_SWITCH_VERSION_DIALOG",actions:[G.Action.YES,G.Action.NO,G.Action.CANCEL],emphasizedAction:G.Action.YES}).then(function(u1){switch(u1){case G.Action.YES:return this._serializeToLrep(this).then(this._switchVersion.bind(this,this._nSwitchToVersion));case G.Action.NO:this.getCommandStack().removeAllCommands(true);this._switchVersion(this._nSwitchToVersion);}}.bind(this));}this._switchVersion(s1);};
n1.prototype._switchVersion=function(r1){var s1=r1.toString();n1.enableRestart(this.getLayer(),this.getRootControlInstance());if(!v.getUshellContainer()){var t1={versionSwitch:true,version:s1};return this._triggerHardReload(t1);}var u1=v.getParsedURLHash();V.loadVersionForApplication({selector:this.getRootControlInstance(),layer:this.getLayer(),version:r1});var v1=u1.params[sap.ui.fl.Versions.UrlParameter];if(v1&&v1[0]===s1){v.getUshellContainer().getService("AppLifeCycle").reloadCurrentApp();}else{u1.params[sap.ui.fl.Versions.UrlParameter]=s1;this._triggerCrossAppNavigation(u1);}};
n1.prototype._setUriParameter=function(r1){document.location.search=r1;};
n1.prototype._createToolsMenu=function(r1){if(!this.getDependent('toolbar')){var s1;if(this.getLayer()===x.USER){s1=P;}else if(U.isOriginalFioriToolbarAccessible()){s1=F;}else if(U.getFiori2Renderer()){s1=a;}else{s1=S;}var t1;if(this.getLayer()===x.USER){t1=new s1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)});}else{t1=new s1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:Q.onGetOverview.bind(null,true,this.getLayer()),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:Q.onSaveAs.bind(Q,true,true,this.getLayer(),null),activate:this._onActivate.bind(this),discardDraft:this._onDiscardDraft.bind(this),switchVersion:this._onSwitchVersion.bind(this)});}this.addDependent(t1,'toolbar');return t1.onFragmentLoaded().then(function(){var u1=r1.saveAsAvailable;var v1=u1&&Q.isOverviewExtended();var w1=_.fromQuery(window.location.search);var x1=w1.get("sap-ui-rta-xx-changeVisualization")==="true";this._oToolbarControlsModel=new d1({undoEnabled:false,redoEnabled:false,publishVisible:r1.publishAvailable,publishEnabled:this.bInitialPublishEnabled,restoreEnabled:this.bInitialResetEnabled,appVariantsOverviewVisible:u1&&v1,appVariantsOverviewEnabled:u1&&v1,saveAsVisible:u1,saveAsEnabled:false,manageAppsVisible:u1&&!v1,manageAppsEnabled:u1&&!v1,showChangesVisible:x1,rtaRootControlId:this.getRootControl(),modeSwitcher:this.getMode()});if(u1){Q.isManifestSupported().then(function(y1){this._oToolbarControlsModel.setProperty("/saveAsEnabled",y1);this._oToolbarControlsModel.setProperty("/appVariantsOverviewEnabled",y1);this._oToolbarControlsModel.setProperty("/manageAppsEnabled",y1);}.bind(this));}this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");}.bind(this));}return Promise.resolve();};
n1.prototype._onGetAppVariantOverview=function(r1){var s1=r1.getParameter("item");var t1=s1.getId()==='keyUser';return Q.onGetOverview(t1,this.getLayer());};
n1.prototype.destroy=function(){q.map(this._dependents,function(r1,s1){this.removeDependent(s1);r1.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(r1){this.stopService(r1);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._$RootControl){this._$RootControl.removeClass("sapUiRtaRoot");}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(W.browser.name==="ff"){q(document).off("contextmenu",o1);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};
n1.prototype._onTransport=function(){this._handleStopCutPaste();J.show(500);return this._serializeToLrep().then(function(){J.hide();var r1=v.isApplicationVariant(this._oRootControl)&&!v.isVariantByStartupParameter(this._oRootControl);return((r1)?Q.getAppVariantDescriptor(this._oRootControl):Promise.resolve()).then(function(s1){var t1=[];if(s1){t1.push(s1);}return B.publish({selector:this.getRootControlInstance(),styleClass:U.getRtaStyleClassName(),layer:this.getLayer(),appVariantDescriptors:t1}).then(function(u1){if(u1!=="Error"&&u1!=="Cancel"){H.show(u1);if(this.getShowToolbars()){B.getResetAndPublishInfo({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(v1){this._oToolbarControlsModel.setProperty("/publishEnabled",v1.isPublishEnabled);this._oToolbarControlsModel.setProperty("/restoreEnabled",v1.isResetEnabled);}.bind(this));}}}.bind(this));}.bind(this));}.bind(this))['catch'](p1);};
n1.prototype._deleteChanges=function(){var r1=this.getLayer();return B.reset({selector:v.getAppComponentForControl(this.getRootControlInstance()),layer:r1,generator:"Change.createInitialFileContent"}).then(function(){var s1={hasDraftChanges:y.hasVersionParameterWithValue({value:r1}),layer:r1,deleteMaxLayer:false,triggerHardReload:true};return this._handleUrlParameterOnExit(s1);}.bind(this)).catch(function(s1){if(s1!=="cancel"){U.showMessageBox("error","MSG_RESTORE_FAILED",{error:s1});}});};
n1.prototype._reloadPage=function(){window.location.reload();};
n1.prototype._showMessageToast=function(r1){var s1=this._getTextResources().getText(r1);H.show(s1);};
n1.needsRestart=function(r1){return!!window.sessionStorage.getItem("sap.ui.rta.restart."+r1);};
n1.enableRestart=function(r1,s1){var t1=v.getComponentClassName(s1);var u1=t1||true;window.sessionStorage.setItem("sap.ui.rta.restart."+r1,u1);};
n1.disableRestart=function(r1){window.sessionStorage.removeItem("sap.ui.rta.restart."+r1);};
n1.prototype._onRestore=function(){var r1=this.getLayer();var s1=r1===x.USER?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var t1=r1===x.USER?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");this._handleStopCutPaste();return U.showMessageBox("warning",s1,{titleKey:t1,actions:[G.Action.OK,G.Action.CANCEL],emphasizedAction:G.Action.OK}).then(function(u1){if(u1===G.Action.OK){n1.enableRestart(r1,this.getRootControlInstance());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this));};
n1.prototype._scheduleOnCreated=function(r1,s1){function t1(u1){var v1=u1.getParameter("elementOverlay");if(v1.getElement().getId()===r1){this._oDesignTime.detachEvent("elementOverlayCreated",t1,this);s1(v1);}}this._oDesignTime.attachEvent("elementOverlayCreated",t1,this);};
n1.prototype._scheduleOnCreatedAndVisible=function(r1,s1){function t1(v1){var w1=v1.getSource();if(w1.getGeometry()&&w1.getGeometry().visible){w1.detachEvent("geometryChanged",t1);s1(w1);}}function u1(v1){if(!v1.getGeometry()||!v1.getGeometry().visible){v1.attachEvent('geometryChanged',t1);}else{s1(v1);}}this._scheduleOnCreated(r1,function(v1){if(v1.isRendered()){u1(v1);}else{v1.attachEventOnce('afterRendering',function(w1){u1(w1.getSource());});}});};
n1.prototype._scheduleRenameOnCreatedContainer=function(r1,s1){var t1=function(u1){u1.setSelected(true);this.getPlugins()["rename"].startEdit(u1);}.bind(this);this._scheduleOnCreatedAndVisible(s1,function(u1){var v1=this.getPlugins()["createContainer"].getCreatedContainerId(r1,u1.getElement().getId());var w1=Z.getOverlay(v1);if(w1){t1(w1);}else{this._scheduleOnCreatedAndVisible(v1,t1);}}.bind(this));};
n1.prototype._handleElementModified=function(r1){this._handleStopCutPaste();var s1=r1.getParameter("action");var t1=r1.getParameter("newControlId");var u1=r1.getParameter("command");if(u1 instanceof sap.ui.rta.command.BaseCommand){if(t1){this._scheduleOnCreated(t1,function(v1){var w1=v1.getDesignTimeMetadata();var x1=w1.getData().select;if(typeof x1==="function"){x1(v1.getElement());}});if(s1){this._scheduleRenameOnCreatedContainer(s1,t1);}}return this.getCommandStack().pushAndExecute(u1).catch(function(v1){if(v1&&v1.message&&v1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:v1});}b1.error("sap.ui.rta: "+v1.message);});}return Promise.resolve();};
n1.prototype._onElementEditableChange=function(r1){var s1=r1.getParameter("editable");if(s1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};
n1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};
n1.prototype._buildNavigationArguments=function(r1){return{target:{semanticObject:r1.semanticObject,action:r1.action,context:r1.contextRaw},params:r1.params,appSpecificRoute:r1.appSpecificRoute,writeHistory:false};};
n1.prototype._triggerCrossAppNavigation=function(r1){if(this.getLayer()!==x.USER){return v.ifUShellContainerThen(function(s1){s1[0].toExternal(this._buildNavigationArguments(r1));return Promise.resolve(true);}.bind(this),["CrossApplicationNavigation"]);}};
n1.prototype._removeVersionParameterForFLP=function(r1,s1){var t1=this.getLayer();if(t1===x.USER){return r1;}var u1=v.getParameter(u.Versions.UrlParameter);if(u1){delete r1.params[u.Versions.UrlParameter];}else if(this._isDraftAvailable()||s1){v.getUshellContainer().getService("AppLifeCycle").reloadCurrentApp();}return r1;};
n1.prototype._removeMaxLayerParameterForFLP=function(r1,s1){if(r1.deleteMaxLayer&&r1.hasHigherLayerChanges){delete s1.params[w.FL_MAX_LAYER_PARAM];}return s1;};
n1.prototype._handleUrlParameterOnExit=function(r1){if(!v.getUshellContainer()){return this._triggerHardReload(r1);}var s1=v.getParsedURLHash();if(!s1){return;}s1=this._removeMaxLayerParameterForFLP(r1,s1);s1=this._removeVersionParameterForFLP(s1);this._triggerCrossAppNavigation(s1);if(r1.triggerHardReload){this._reloadPage();}};
n1.prototype._getReloadMessageOnStart=function(r1){var s1;var t1=r1.layer===x.CUSTOMER;if(r1.hasHigherLayerChanges&&r1.hasDraftChanges){s1=t1?"MSG_PERSONALIZATION_AND_DRAFT_EXISTS":"MSG_HIGHER_LAYER_CHANGES_AND_DRAFT_EXISTS";}else if(r1.hasHigherLayerChanges){s1=t1?"MSG_PERSONALIZATION_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";}else if(r1.hasDraftChanges){s1="MSG_DRAFT_EXISTS";}return s1;};
n1.prototype._getReloadMessageOnExit=function(r1){var s1=r1.layer===x.CUSTOMER;if(r1.hasHigherLayerChanges){if(!s1){return"MSG_RELOAD_WITH_ALL_CHANGES";}if(r1.hasDraft){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_WITHOUT_DRAFT";}return"MSG_RELOAD_WITH_PERSONALIZATION";}if(r1.initialDraftGotActivated){return"MSG_RELOAD_ACTIVATED_DRAFT";}if(r1.hasDraft){return"MSG_RELOAD_WITHOUT_DRAFT";}if(r1.changesNeedReload){return"MSG_RELOAD_NEEDED";}};
n1.prototype._handleReloadMessageBoxOnExit=function(r1){var s1=this._getReloadMessageOnExit(r1);if(s1){return U.showMessageBox("information",s1,{titleKey:"HEADER_RELOAD_NEEDED"});}return Promise.resolve();};
n1.prototype._triggerReloadOnStart=function(r1){v.ifUShellContainerThen(function(){if(r1.hasDraftChanges){V.loadDraftForApplication({selector:r1.selector,layer:r1.layer});}else{V.loadVersionForApplication({selector:r1.selector,layer:r1.layer});}},["CrossApplicationNavigation"]);var s1=this._getReloadMessageOnStart(r1);if(!s1){return Promise.resolve();}return U.showMessageBox("information",s1).then(function(){n1.enableRestart(r1.layer);if(v.getUshellContainer()){var t1=y.handleParametersOnStart(r1);return this._triggerCrossAppNavigation(t1);}return this._triggerHardReload(r1);}.bind(this));};
n1.prototype._determineReload=function(){var r1={hasHigherLayerChanges:false,hasDraftChanges:false,layer:this.getLayer(),selector:this.getRootControlInstance(),ignoreMaxLayerParameter:false};return y.getReloadReasonsForStart(r1).then(function(r1){if(r1.hasHigherLayerChanges||r1.hasDraftChanges){return this._triggerReloadOnStart(r1);}}.bind(this));};
n1.prototype._triggerHardReload=function(r1){r1.parameters=document.location.search;var s1=y.handleUrlParametersForStandalone(r1);if(document.location.search!==s1){this._setUriParameter(s1);return Promise.resolve();}return this._reloadPage();};
n1.prototype._handleReloadOnExit=function(r1){if(r1){return Promise.resolve({reloadMethod:this._RELOAD.NOT_NEEDED});}var s1=this._bReloadNeeded?Promise.resolve(this._bReloadNeeded):this._oSerializer.needsReload();return s1.then(function(t1){var u1={layer:this.getLayer(),selector:this.getRootControlInstance(),changesNeedReload:t1,hasDirtyDraftChanges:this._oVersionsModel.getProperty("/draftAvailable")&&this._oVersionsModel.getProperty("/dirtyChanges"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion")};u1=y.getReloadMethod(u1);return this._handleReloadMessageBoxOnExit(u1).then(function(){return u1;});}.bind(this));};
n1.prototype._onModeChange=function(r1){this.setMode(r1.getParameter("item").getKey());};
n1.prototype.setMode=function(r1){if(this.getMode()!==r1){var s1=r1==='adaptation';this._oDesignTime.setEnabled(s1);this.getPlugins()['tabHandling'][s1?'removeTabIndex':'restoreTabIndex']();this._oToolbarControlsModel.setProperty("/modeSwitcher",r1);this.setProperty('mode',r1);this.fireModeChanged({mode:r1});}};
n1.prototype.setMetadataScope=function(r1){if(this._oDesignTime){b1.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',r1);};
function q1(r1){if(X.hasOwnProperty(r1)){return X[r1].replace(/\./g,'/');}}
n1.prototype.startService=function(r1){if(this._sStatus!==h1){return new Promise(function(u1,v1){this.attachEventOnce('start',u1);this.attachEventOnce('failed',v1);}.bind(this)).then(function(){return this.startService(r1);}.bind(this),function(){return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Can't start the service '{0}' while RTA has been failed during a startup",r1),"sap.ui.rta"));});}var s1=q1(r1);var t1;if(!s1){return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Unknown service. Can't find any registered service by name '{0}'",r1),"sap.ui.rta"));}t1=this._mServices[r1];if(t1){switch(t1.status){case l1:{return Promise.resolve(t1.exports);}case k1:{return t1.initPromise;}case m1:{return t1.initPromise;}default:{return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Unknown service status. Service name = '{0}'",r1),"sap.ui.rta"));}}}else{this._mServices[r1]=t1={status:k1,location:s1,initPromise:new Promise(function(u1,v1){sap.ui.require([s1],function(w1){t1.factory=w1;if(!this._oServiceEventBus){this._oServiceEventBus=new Y();}t.wrapIntoPromise(w1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,r1)).then(function(x1){if(this.bIsDestroyed){throw t.createError("RuntimeAuthoring#startService",t.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",r1),"sap.ui.rta");}if(!q.isPlainObject(x1)){throw t.createError("RuntimeAuthoring#startService",t.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",r1),"sap.ui.rta");}t1.service=x1;t1.exports={};if(Array.isArray(x1.events)&&x1.events.length>0){q.extend(t1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,r1),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,r1),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,r1)});}var y1=x1.exports||{};q.extend(t1.exports,Object.keys(y1).reduce(function(z1,A1){var B1=y1[A1];z1[A1]=typeof B1==="function"?t.waitForSynced(this._oDesignTime,B1):B1;return z1;}.bind(this),{}));t1.status=l1;u1(Object.freeze(t1.exports));}.bind(this)).catch(v1);}.bind(this),function(w1){t1.status=m1;v1(t.propagateError(w1,"RuntimeAuthoring#startService",t.printf("Can't load service '{0}' by its name: {1}",r1,s1),"sap.ui.rta"));});}.bind(this)).catch(function(u1){t1.status=m1;return Promise.reject(t.propagateError(u1,"RuntimeAuthoring#startService",t.printf("Error during service '{0}' initialisation.",r1),"sap.ui.rta"));})};return t1.initPromise;}};
n1.prototype.stopService=function(r1){var s1=this._mServices[r1];if(s1){if(s1.status===l1){if(typeof s1.service.destroy==="function"){s1.service.destroy();}}delete this._mServices[r1];}else{throw t.createError("RuntimeAuthoring#stopService",t.printf("Can't destroy service: unable to find service with name '{0}'",r1),"sap.ui.rta");}};
n1.prototype.getService=function(r1){return this.startService(r1);};
return n1;});
sap.ui.predefine('sap/ui/rta/Utils',["sap/ui/thirdparty/jquery","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/registry/Settings","sap/ui/dt/OverlayUtil","sap/ui/dt/DOMUtil","sap/m/MessageBox","sap/ui/rta/util/BindingsExtractor","sap/base/Log","sap/base/util/UriParameters","sap/base/util/restricted/_omit","sap/ui/model/json/JSONModel"],function(q,F,L,a,S,O,D,M,B,b,U,_,J){"use strict";var c={};c.RESOLVED_PROMISE=Promise.resolve(true);c._sFocusableOverlayClass=".sapUiDtOverlaySelectable";c._sRtaStyleClassName='';
c.getRtaStyleClassName=function(){return c._sRtaStyleClassName;};
c.setRtaStyleClassName=function(l){if(l===L.USER){c._sRtaStyleClassName="";}else if(a.getLayerIndex(l)>-1){c._sRtaStyleClassName="sapUiRTABorder";}};
c.isExtensibilityEnabledInSystem=function(C){var s=F.getComponentClassName(C);if(!s||s===""){return Promise.resolve(false);}return S.getInstance(s).then(function(o){if(o.isModelS){return o.isModelS();}return false;});};
c.isServiceUpToDate=function(C){return this.isExtensibilityEnabledInSystem(C).then(function(e){if(e){return new Promise(function(r,R){sap.ui.require(["sap/ui/fl/fieldExt/Access"],function(A){var o=C.getModel();if(o){var s=A.isServiceOutdated(o.sServiceUrl);if(s){A.setServiceValid(o.sServiceUrl);sap.ui.getCore().getEventBus().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{});return R();}}return r();});});}});};
function g(o,p){return o.oMetadata&&o.oMetadata._getEntityTypeByPath(p);}
function d(e,o){o||(o=e.getModel());var f=e.getBindingContext();if(f){return g(o,f.getPath())||{};}return{};}
c.isCustomFieldAvailable=function(C){return this.isExtensibilityEnabledInSystem(C).then(function(s){if(!s||!C.getModel()){return false;}return new Promise(function(r,R){sap.ui.require(["sap/ui/fl/fieldExt/Access"],function(A){var e=C.getModel().sServiceUrl;var E=d(C).name;var $;try{$=A.getBusinessContexts(e,E);}catch(o){b.error("exception occured in sap.ui.fl.fieldExt.Access.getBusinessContexts",o);r(false);}return Promise.resolve($).then(function(f){if(f&&Array.isArray(f.BusinessContexts)&&f.BusinessContexts.length>0){f.EntityType=E;return r(f);}return r(false);}).catch(function(o){if(o){if(Array.isArray(o.errorMessages)){for(var i=0;i<o.errorMessages.length;i++){b.error(o.errorMessages[i].text);}}}return r(false);});},R);});});};
c.openRemoveConfirmationDialog=function(e,t){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var s;return new Promise(function(r){s=T.getText("CTX_REMOVE_TITLE");var f={messageText:t,titleText:s,icon:"sap-icon://question-mark",removeText:T.getText("BTN_FREP_REMOVE"),cancelText:T.getText("BTN_FREP_CANCEL")};var o=new J();o.setData(f);var h;var C=function(){if(h){h.close();h.destroy();h=null;}};var i={removeField:function(){C();r(true);},closeDialog:function(){C();r(false);}};if(!h){h=sap.ui.xmlfragment("sap.ui.rta.view.RemoveElementDialog",i);h.setModel(o);}h.addStyleClass(c.getRtaStyleClassName());h.open();});};
c.isOverlaySelectable=function(o){return o.isSelectable()&&D.isVisible(o.getDomRef());};
c.getPropertyValue=function(e,p){var o=e.getMetadata().getPropertyLikeSetting(p);var P=o._sGetter;return e[P]();};
c.getOverlayInstanceForDom=function(o){var i=q(o).attr("id");if(i){return sap.ui.getCore().byId(i);}};
c.getFocusedOverlay=function(){if(document.activeElement){var e=sap.ui.getCore().byId(document.activeElement.id);if(e instanceof sap.ui.dt.ElementOverlay){return e;}}};
c.getFocusableParentOverlay=function(o){if(!o){return undefined;}var f=o.getParentElementOverlay();while(f&&!f.getSelectable()){f=f.getParentElementOverlay();}return f;};
c.getFirstFocusableDescendantOverlay=function(o){return O.getFirstDescendantByCondition(o,this.isOverlaySelectable);};
c.getLastFocusableDescendantOverlay=function(o){return O.getLastDescendantByCondition(o,this.isOverlaySelectable);};
c.getNextFocusableSiblingOverlay=function(o){var N=true;var n=O.getNextSiblingOverlay(o);while(n&&!this.isOverlaySelectable(n)){n=O.getNextSiblingOverlay(n);}if(!n){n=this._findSiblingOverlay(o,N);}return n;};
c.getPreviousFocusableSiblingOverlay=function(o){var P=false;var p=O.getPreviousSiblingOverlay(o);while(p&&!this.isOverlaySelectable(p)){p=O.getPreviousSiblingOverlay(p);}if(!p){p=this._findSiblingOverlay(o,P);}return p;};
c._findSiblingOverlay=function(o,n){var p=o.getParentElementOverlay();if(p){var s=n?O.getNextSiblingOverlay(p):O.getPreviousSiblingOverlay(p);if(!s){return this._findSiblingOverlay(p,n);}var e=n?this.getFirstFocusableDescendantOverlay(s):this.getLastFocusableDescendantOverlay(s);return e;}return undefined;};
c.getIndex=function(p,C,A,G){var i;if(G&&typeof G==="function"){i=G(p,C);}else{var o=p.getMetadata();var e=o.getAggregation(A);var s=e._sGetter;var f=p[s]();if(Array.isArray(f)&&C){i=f.indexOf(C)+1;}else{i=0;}}return i;};
c.createFieldLabelId=function(p,e,s){return(p.getId()+"_"+e+"_"+s).replace("/","_");};
c.openNewWindow=function(u){window.open(u,"_blank","noopener noreferrer");};
c.getElementBindingPaths=function(e){var p={};if(e.mBindingInfos){for(var i in e.mBindingInfos){var P=e.mBindingInfos[i].parts[0].path?e.mBindingInfos[i].parts[0].path:"";P=P.split("/")[P.split("/").length-1];p[P]={valueProperty:i};}}return p;};
c.isOriginalFioriToolbarAccessible=function(){var r=c.getFiori2Renderer();return r&&r.getRootControl&&r.getRootControl().getOUnifiedShell().getHeader();};
c.getFiori2Renderer=function(){var C=F.getUshellContainer()||{};return typeof C.getRenderer==="function"?C.getRenderer("fiori2"):undefined;};
c.extendWith=function(e,s,C){if(!(typeof C==="function")){throw new Error('In order to use extendWith() utility function fnCustomizer should be provided!');}for(var f in s){if(s.hasOwnProperty(f)){if(C(e[f],s[f],f,e,s)){e[f]=s[f];}}}};
c.isElementInViewport=function(o){if(o instanceof q){o=o.get(0);}var r=o.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&r.right<=(window.innerWidth||document.documentElement.clientWidth));};
c.showMessageBox=function(s,e,p){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta",true).then(function(r){p=p||{};var f=r.getText(e,p.error?[p.error.userMessage||p.error.message||p.error]:undefined);var t=r.getText(p.titleKey);var o=_(p,["titleKey","error"]);o.title=t;o.styleClass=c.getRtaStyleClassName();return m(s,f,o);});};
function m(s,e,o){return new Promise(function(r){o.onClose=r;M[s](e,o);});}
c.checkSourceTargetBindingCompatibility=function(s,t,o){o=o||s.getModel();var e=B.collectBindingPaths(s,o);var f;var T;if(e.bindingPaths.length===0){return true;}f=B.getBindingContextPath(s);T=B.getBindingContextPath(t);if(f===T){return true;}return false;};
c.doIfAllControlsAreAvailable=function(C,f){if(C.every(function(o){return o&&!o._bIsBeingDestroyed;})){return f();}};
c.buildHashMapFromArray=function(A,k,v){return A.reduce(function(e,i){e[i[k]]=i[v];return e;},{});};
return c;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantDialog',["sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/m/GenericTile","sap/m/ImageContent","sap/m/Input","sap/m/Label","sap/m/SelectDialog","sap/m/StandardListItem","sap/m/TextArea","sap/m/TileContent","sap/m/VBox","sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/Title","sap/ui/layout/form/SimpleForm","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/layout/form/ResponsiveGridLayout"],function(B,D,a,G,I,b,L,S,c,T,d,V,e,f,g,h,F,i,J,R){"use strict";var j=e.ValueState;var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var o;var t;var k;var s;var l;var m;var n;var p;var q;var u;var v;var C;var w;
function _(){o=new G("tile",{header:"{/title}",subheader:"{/subtitle}",ariaLabel:r.getText("APP_VARIANT_TILE_ARIA_LABEL"),tileContent:[new d({content:[new I({src:"{/icon}"})]})]}).addStyleClass("sapUiMediumMarginBegin").addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom");}
function x(M){var N=M.getParameter("value");var O=new F("name",i.Contains,N);var P=M.getSource().getBinding("items");P.filter([O]);}
function y(M){var N=M.getParameter("selectedContexts");if(N&&N.length){N.forEach(function(O){var P=O.getObject().name;q.setValue(P);C.setProperty("/icon",O.getObject().icon);});}M.getSource().getBinding("items").filter([]);}
function z(){if(!v){v=new S("selectDialog",{noDataText:r.getText("APP_VARIANT_ICON_NO_DATA"),title:r.getText("APP_VARIANT_ICON_SELECT_ICON"),search:function(N){x(N);},confirm:function(N){y(N);},cancel:function(N){y(N);}});}v.addStyleClass(R.getRtaStyleClassName());v.bindAggregation("items",{path:"/icons",template:new c({title:"{name}",description:"",icon:"{icon}",iconDensityAware:false,iconInset:false,type:"Active"})});var U=f.getIconNames();var M=[];U.forEach(function(N){M.push({icon:f.getIconInfo(N).uri,name:N.toLowerCase()});});w.setProperty("/icons",M);v.setModel(w);v.getBinding("items").filter([]);v.open();}
function A(){t=new L({required:true,text:r.getText("APP_DIALOG_TITLE_TEXT"),textAlign:"Left"});k=new b("titleInput",{value:"{/title}",valueLiveUpdate:true,placeholder:r.getText("SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT"),liveChange:function(){var M=sap.ui.getCore().byId("saveButton");if(this.getValue()===""){this.setValueState(j.Error);M.setEnabled(false);}else{this.setValueState(j.None);M.setEnabled(true);}}});s=new L({text:r.getText("APP_DIALOG_SUB_TITLE_TEXT"),textAlign:"Left"});l=new b({value:"{/subtitle}",valueLiveUpdate:true});m=new L({text:r.getText("APP_DIALOG_DESCRIPTION_TEXT"),textAlign:"Left"});n=new T({rows:4});p=new L({text:r.getText("APP_DIALOG_ICON_TEXT"),textAlign:"Left"});q=new b("selectInput",{showValueHelp:true,liveChange:function(M){z(M);},valueHelpRequest:function(M){z(M);},value:"{/iconname}",valueLiveUpdate:true});}
function E(){u=new h({editable:true,layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:4,adjustLabelSpan:false,emptySpanXL:0,emptySpanL:0,emptySpanM:0,emptySpanS:0,columnsXL:2,columnsL:2,columnsM:2,singleContainerFullSize:false,content:[new g("title1"),t,k,s,l,p,q,m,n,new g("title2"),o]});return u;}
function H(){var M=new V({items:[E()]}).addStyleClass("sapUISmallMargin");return M;}
var K=D.extend("sap.ui.rta.appVariant.AppVariantDialog",{
metadata:{library:"sap.ui.rta",events:{create:{},cancel:{}}},
init:function(){D.prototype.init.apply(this);this.setTitle(r.getText("CREATE_APP_VARIANT_DIALOG_TITLE"));this.setContentWidth("620px");this.setContentHeight("250px");C=new J({title:null,subtitle:null,icon:" ",iconname:null});w=new J({icons:null});sap.ui.getCore().setModel(C);_();A();this.addContent(H());this._createButtons();this.addStyleClass(R.getRtaStyleClassName());},
onAfterRendering:function(){document.getElementById('title1').style.height="0px";document.getElementById('title2').style.height="0px";document.getElementById('tile').style.float="left";},
_onCreate:function(){var M=k.getValue()||" ";var N=l.getValue()||" ";var O=n.getValue()||" ";var P=q.getValue()?f.getIconInfo(q.getValue()).uri:" ";this.fireCreate({title:M,subTitle:N,description:O,icon:P});this.close();this.destroy();},
_createButtons:function(){this.addButton(new B("saveButton",{text:r.getText("APP_VARIANT_DIALOG_SAVE"),tooltip:r.getText("TOOLTIP_APP_VARIANT_DIALOG_SAVE"),enabled:false,press:function(){this._onCreate();}.bind(this)}));this.addButton(new B({text:r.getText("SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),tooltip:r.getText("TOOLTIP_SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),press:function(){this.fireCancel();this.close();this.destroy();}.bind(this)}));},
destroy:function(){if(C){C.destroy();}D.prototype.destroy.apply(this,arguments);},
renderer:a.render
});
return K;});
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantManager',["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend"],function(M,A,a,R,S){"use strict";
var b=M.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{commandSerializer:{type:"object"},layer:{type:"string"}}}});
b.prototype._openDialog=function(c,C){var d=new A("appVariantDialog");d.attachCreate(c);d.attachCancel(C);d.attachAfterClose(function(){this.destroy();});d.open();return d;};
b.prototype._prepareAppVariantData=function(d,p){return{referenceAppId:d["sap.app"].id,title:p.title,subTitle:p.subTitle,description:p.description,icon:p.icon,inbounds:d["sap.app"].crossNavigation&&d["sap.app"].crossNavigation.inbounds?d["sap.app"].crossNavigation.inbounds:null};};
b.prototype.createAllInlineChanges=function(o,s){var c=a.getId(o.referenceAppId);var d=[];var p={};p.content=a.prepareTextsChange("title",o.title);d.push(a.createInlineChange(p,"appdescr_app_setTitle",s));p.content=a.prepareTextsChange("subtitle",o.subTitle);d.push(a.createInlineChange(p,"appdescr_app_setSubTitle",s));p.content=a.prepareTextsChange("description",o.description);d.push(a.createInlineChange(p,"appdescr_app_setDescription",s));p=a.getInlineChangeInputIcon(o.icon);d.push(a.createInlineChange(p,"appdescr_ui_setIcon",s));var i=a.getInboundInfo(o.inbounds);var C=i.currentRunningInbound;if(i.addNewInboundRequired){p=a.prepareAddNewInboundChange(C,c,o);d.push(a.createInlineChange(p,"appdescr_app_addNewInbound",s));p=a.prepareRemoveAllInboundsExceptOneChange(C);d.push(a.createInlineChange(p,"appdescr_app_removeAllInboundsExceptOne",s));}else{p=a.prepareChangeInboundChange(C,c,o);d.push(a.createInlineChange(p,"appdescr_app_changeInbound",s));}return Promise.all(d);};
b.prototype.createAppVariant=function(s,v){var p={id:s,layer:this.getLayer()};return a.createAppVariant(v,p);};
b.prototype.deleteAppVariant=function(s){return a.deleteAppVariant({appId:s},this.getLayer());};
b.prototype.processSaveAsDialog=function(d,s){return new Promise(function(r,c){var C=function(o){var p=o.getParameters();var e=this._prepareAppVariantData(d,p);r(e);}.bind(this);var f=function(){if(!s){return R.onGetOverview(true,this.getLayer());}c();}.bind(this);return this._openDialog(C,f);}.bind(this));};
b.prototype._clearRTACommandStack=function(){return this.getCommandSerializer().clearCommandStack();};
b.prototype.clearRTACommandStack=function(c){var C=this.getCommandSerializer().getCommandStack();if(c&&C.getAllExecutedCommands().length){return this._clearRTACommandStack();}return Promise.resolve();};
b.prototype.triggerCatalogPublishing=function(s,r,c){var t=c?a.triggerCatalogAssignment:a.triggerCatalogUnAssignment;return t(s,this.getLayer(),r).catch(function(e){var m=c?"MSG_CATALOG_ASSIGNMENT_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";return a.catchErrorDialog(e,m,s);});};
b.prototype.notifyKeyUserWhenPublishingIsReady=function(i,s,c){var o=new S();return o.notifyFlpCustomizingIsReady(i,c).catch(function(e){var m=c?"MSG_TILE_CREATION_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";if(!c&&e.error==="locked"){m="MSG_CATALOGS_LOCKED";}return a.catchErrorDialog(e,m,s);});};
b.prototype.showSuccessMessage=function(s){return a.showRelevantDialog(s,true);};
return b;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantOverviewDialog',["sap/ui/core/ComponentContainer","sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/ui/rta/appVariant/manageApps/webapp/Component","sap/ui/rta/Utils"],function(C,B,D,a,M,R){"use strict";
var A=D.extend("sap.ui.rta.appVariant.AppVariantOverviewDialog",{
metadata:{library:"sap.ui.rta",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"},events:{cancel:{}}},
constructor:function(){D.prototype.constructor.apply(this,arguments);this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this.oManageAppsComponent=new M("sap.ui.rta.appVariant.manageApps",{idRunningApp:this.getIdRunningApp(),isOverviewForKeyUser:this.getIsOverviewForKeyUser(),layer:this.getLayer()});this.oManageAppsComponentContainer=new C({component:this.oManageAppsComponent});this.addContent(this.oManageAppsComponentContainer);this._createButton();this.setContentWidth("1000px");this.setContentHeight("450px");this.setHorizontalScrolling(false);this.setTitle(this._oTextResources.getText("APP_VARIANT_OVERVIEW_DIALOG_TITLE"));this.addStyleClass(R.getRtaStyleClassName());},
destroy:function(){D.prototype.destroy.apply(this,arguments);},
renderer:a.render
});
A.prototype._createButton=function(){this.addButton(new B({text:this._oTextResources.getText("APP_VARIANT_DIALOG_CLOSE"),press:function(){this.close();this.fireCancel();}.bind(this)}));};
return A;});
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantUtils',["sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/core/BusyIndicator","sap/base/util/uid","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI"],function(F,M,R,B,u,L,P,A,C){"use strict";var a={};var H=56;a._newAppVariantId=null;
a.getManifirstSupport=function(r){var m='/sap/bc/ui2/app_index/ui5_app_mani_first_supported/?id='+r;return new Promise(function(b,c){var x=new XMLHttpRequest();x.open("GET",m);x.send();x.onload=function(){if(x.status>=200&&x.status<400){b(x.response);}else{c({status:x.status,message:x.statusText});}};});};
a.getNewAppVariantId=function(){return a._newAppVariantId;};
a.setNewAppVariantId=function(n){a._newAppVariantId=n;};
a.trimIdIfRequired=function(i){if(i.length>H){var I=i.split('.');var t;var g=I[I.length-1].length;var G=I.pop();t=I.join(".");if(t.length>g){t=t.substring(0,t.length-g);}else{return i.substr(0,H);}if(t[t.length-1]==='.'){t=t+G;}else{t=t+"."+G;}return this.trimIdIfRequired(t);}return i;};
a.getId=function(b){var c;var i=b.split('.');if(i[0]!=="customer"){i[0]="customer."+i[0];}var r=false;var d=/^id.*/i;i.forEach(function(s,e,f){if(s.match(d)){s=s.replace(d,u().replace(/-/g,"_"));f[e]=s;r=true;}});c=i.join(".");if(!r){c=c+"."+u().replace(/-/g,"_");}c=this.trimIdIfRequired(c);this.setNewAppVariantId(c);return c;};
a.createAppVariant=function(s,p){p.version="1.0.0";return A.saveAs(Object.assign({selector:s},p));};
a.getInlineChangeInput=function(v,c){return{type:"XTIT",maxLength:50,comment:c,value:{"":v}};};
a.prepareTextsChange=function(p,s){var c="New "+p+" entered by a key user via RTA tool";return this.getInlineChangeInput(s,c);};
a.getInlineChangeInputIcon=function(i){return{content:{icon:i}};};
a.prepareRemoveAllInboundsExceptOneChange=function(i){return{content:{inboundId:i}};};
a.getInboundInfo=function(i){var I={};if(!i){I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;return I;}var p=F.getParsedURLHash();var b=Object.keys(i);var c=[];if(b.length===1&&b[0]==="customer.savedAsAppVariant"){return{currentRunningInbound:"customer.savedAsAppVariant",addNewInboundRequired:false};}b.forEach(function(s){if((i[s].action===p.action)&&(i[s].semanticObject===p.semanticObject)){c.push(s);}});switch(c.length){case 0:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;case 1:I.currentRunningInbound=c[0];I.addNewInboundRequired=false;break;default:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;}return I;};
a.getInboundPropertiesKey=function(s,c,p){return s+"_sap.app.crossNavigation.inbounds."+c+"."+p;};
a.getInlineChangeForInboundPropertySaveAs=function(c,s){return{inboundId:c,entityPropertyChange:{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}}};};
a.prepareAddNewInboundChange=function(c,s,o){var p=F.getParsedURLHash();var b={content:{inbound:{}},texts:{}};var i=this.getInboundPropertiesKey(o.referenceAppId,c,"title");var I=this.getInboundPropertiesKey(o.referenceAppId,c,"subTitle");b.content.inbound[c]={semanticObject:p.semanticObject,action:p.action,title:"{{"+i+"}}",subTitle:"{{"+I+"}}",icon:o.icon,signature:{parameters:{"sap-appvar-id":{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}},additionalParameters:"ignored"}};b.texts[i]=this.prepareTextsChange("title",o.title);b.texts[I]=this.prepareTextsChange("subTitle",o.subTitle);return b;};
a.prepareChangeInboundChange=function(c,s,o){var p={content:{},texts:{}};var i=this.getInboundPropertiesKey(o.referenceAppId,c,"title");var I=this.getInboundPropertiesKey(o.referenceAppId,c,"subTitle");p.content={inboundId:c,entityPropertyChange:[{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}},{propertyPath:"title",operation:"UPSERT",propertyValue:"{{"+i+"}}"},{propertyPath:"subTitle",operation:"UPSERT",propertyValue:"{{"+I+"}}"},{propertyPath:"icon",operation:"UPSERT",propertyValue:o.icon}]};p.texts[i]=this.prepareTextsChange("title",o.title);p.texts[I]=this.prepareTextsChange("subTitle",o.subTitle);return p;};
a.createInlineChange=function(p,i,s){var c={changeType:i,content:p.content};if(p.texts){c.texts=p.texts;}return C.create({changeSpecificData:c,selector:s});};
a.addChangesToPersistence=function(b,s){b.forEach(function(c){return P.add({change:c,selector:s});});return Promise.resolve();};
a.getTransportInput=function(p,n,N,t){return{getPackage:function(){return p;},getNamespace:function(){return n;},getId:function(){return N;},getDefinition:function(){return{fileType:t};}};};
a.triggerCatalogAssignment=function(s,l,r){return A.assignCatalogs({selector:{appId:s},action:"assignCatalogs",assignFromAppId:r,layer:l});};
a.triggerCatalogUnAssignment=function(s,l){return A.unassignCatalogs({selector:{appId:s},action:"unassignCatalogs",layer:l});};
a.isS4HanaCloud=function(s){return s.isAtoEnabled()&&s.isAtoAvailable();};
a.copyId=function(i){var t=document.createElement("textarea");t.value=i;document.body.appendChild(t);t.select();document.execCommand('copy');document.body.removeChild(t);return true;};
a.getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
a.getText=function(m,t){var T=this.getTextResources();return t?T.getText(m,t):T.getText(m);};
a._getErrorMessageText=function(e){var E;if(e.messages&&e.messages.length){E=e.messages.map(function(e){return e.text;}).join("\n");}else if(e.iamAppId){E="IAM App Id: "+e.iamAppId;}else{E=e.stack||e.message||e.status||e;}return E;};
a.buildErrorInfo=function(m,e,s){var E=this._getErrorMessageText(e);var b=a.getText(m)+"\n\n";if(s){b+=a.getText("MSG_APP_VARIANT_ID",s)+"\n";}b+=a.getText("MSG_TECHNICAL_ERROR",E);L.error("App variant error: ",E);return{text:b,appVariantId:s,error:true};};
a.buildSuccessInfo=function(s,S,i){var b=i?"CLOUD":"ON_PREMISE";var o=S?"":"_OVERVIEW_LIST";var t=i?undefined:s;var m=a.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")+"\n\n";m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_"+b+"_MESSAGE"+o,t);return{text:m,appVariantId:s,copyId:!i};};
a.buildFinalSuccessInfoS4HANACloud=function(){var m=a.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");return{text:m};};
a.buildDeleteSuccessMessage=function(s,i){var m=i?"DELETE_APP_VARIANT_SUCCESS_MESSAGE_CLOUD":"DELETE_APP_VARIANT_SUCCESS_MESSAGE";var b=a.getText(m,s);return{text:b};};
a.showRelevantDialog=function(i,s){B.hide();var t;var r;var o;var c;var b=[];if(s){t=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");r=this.getText("SAVE_APP_VARIANT_OK_TEXT");}else{t=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");r=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT");}if(i&&i.copyId){c=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");b.push(c);}else if(i&&i.deleteAppVariant){t=this.getText("DELETE_APP_VARIANT_INFO_MESSAGE_TITLE");o=this.getText("DELETE_APP_VARIANT_OK_TEXT");b.push(o);r=this.getText("DELETE_APP_VARIANT_CLOSE_TEXT");}b.push(r);return new Promise(function(d,e){var f=function(g){if(g===c){a.copyId(i.appVariantId);}if(s){d();}else if(i.overviewDialog){d(false);}else if(i.deleteAppVariant&&g===o){d();}else if(i.deleteAppVariant&&g===r){e(i.deleteAppVariant);}else if(i.error){e(i.error);}else{d();}};M.show(i.text,{icon:(s||i.deleteAppVariant)?M.Icon.INFORMATION:M.Icon.ERROR,onClose:f,title:t,actions:b,styleClass:R.getRtaStyleClassName()});});};
a.closeOverviewDialog=function(){sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate");};
a.navigateToFLPHomepage=function(){var o=sap.ushell.services.AppConfiguration.getCurrentApplication();var c=o.componentHandle.getInstance();if(c){F.ifUShellContainerThen(function(s){var b=s[0];if(b&&b.toExternal){b.toExternal({target:{shellHash:"#"}},c);}},["CrossApplicationNavigation"]);}return Promise.resolve();};
a.deleteAppVariant=function(s,l){B.hide();return A.deleteAppVariant({selector:s,layer:l});};
a.handleBeforeUnloadEvent=function(){var m=a.getText("MSG_DO_NOT_CLOSE_BROWSER");return m;};
a.showMessage=function(m){var s=a.getText(m);var i={text:s,copyId:false};return a.showRelevantDialog(i,true);};
a.catchErrorDialog=function(e,m,i){B.hide();var E=a.buildErrorInfo(m,e,i);return a.showRelevantDialog(E,false);};
return a;},true);
sap.ui.predefine('sap/ui/rta/appVariant/Feature',["sap/ui/fl/Utils","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/core/BusyIndicator","sap/base/util/UriParameters","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/api/FeaturesAPI","sap/base/util/merge"],function(F,A,B,U,S,a,b,m){"use strict";var o;var c;var r;var C;var _;var g=function(){return F.getAppDescriptor(r);};var G=function(){return S.getInstance();};var s=function(){window.onbeforeunload=_;};var f=function(i){var M=i?"MSG_DO_NOT_CLOSE_BROWSER_CURRENTLY_ADAPTING":"MSG_DO_NOT_CLOSE_BROWSER";_=window.onbeforeunload;window.onbeforeunload=A.handleBeforeUnloadEvent;return A.showMessage(M);};var t=function(i,j){return c.triggerCatalogPublishing(i,j,true);};var T=function(i){return c.triggerCatalogPublishing(i,null,false);};var R=function(i,j){if(o){A.closeOverviewDialog();return this.onGetOverview(true,j);}else if(!o&&i){B.hide();return this.onGetOverview(true,j);}return Promise.resolve();};var d=function(i,I,j){return i?A.navigateToFLPHomepage():R.call(this,!I,j);};var e=function(i,j){if(i&&i.response&&i.response.IAMId){return c.notifyKeyUserWhenPublishingIsReady(i.response.IAMId,j,true);}return Promise.resolve();};var h=function(i,j){if(i&&i.response&&i.response.IAMId&&i.response.inProgress){return c.notifyKeyUserWhenPublishingIsReady(i.response.IAMId,j,false);}return Promise.resolve();};sap.ui.getCore().getEventBus().subscribe("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate",function(){if(o){o.destroy();o=null;}});return{onGetOverview:function(i,l){var D=g();return new Promise(function(j){var k=function(){A.closeOverviewDialog();};sap.ui.require(["sap/ui/rta/appVariant/AppVariantOverviewDialog"],function(n){if(!o){o=new n({idRunningApp:D["sap.app"].id,isOverviewForKeyUser:i,layer:l});}o.attachCancel(k);o.oPopup.attachOpened(function(){j(o);});o.open();});});},isOverviewExtended:function(){var u=U.fromQuery(window.location.search);var M=u.get("sap-ui-xx-app-variant-overview-extended");if(!M){return false;}return M.toLowerCase()==='true';},isManifestSupported:function(){var D=g();return A.getManifirstSupport(D["sap.app"].id).then(function(i){return i.response;}).catch(function(E){var i=A.buildErrorInfo("MSG_APP_VARIANT_FEATURE_FAILED",E);i.overviewDialog=true;return A.showRelevantDialog(i,false);});},isSaveAsAvailable:function(i,j,l){r=i;C=l;var D=g();if(D["sap.app"]&&D["sap.app"].id){return b.isSaveAsAvailable(j).then(function(I){if(I){var k;if(D["sap.app"].crossNavigation&&D["sap.app"].crossNavigation.inbounds){k=A.getInboundInfo(D["sap.app"].crossNavigation.inbounds);}else{k=A.getInboundInfo();}if(k){return true;}}return false;});}return Promise.resolve(false);},getAppVariantDescriptor:function(i){r=i;var D=g();if(D["sap.app"]&&D["sap.app"].id){return a.load({id:D["sap.app"].id});}return Promise.resolve(false);},_determineSelector:function(i,D){return i?r:{appId:D["sap.app"].id,appVersion:D["sap.app"].applicationVersion.version};},onSaveAs:function(i,j,k,l){var I;var n;var D=g();var p=true;if(l&&l["sap.app"].id===D["sap.app"].id){j=true;D=m({},l);l=null;}else if(l){p=false;D=m({},l);l=null;}var v=this._determineSelector(p,D);return new Promise(function(q){var P=function(){return c.processSaveAsDialog(D,i);};var u=function(K){B.show();return c.createAllInlineChanges(K,v);};var w=function(K){var L=K.slice();return A.addChangesToPersistence(L,v);};var x=function(){var K=A.getNewAppVariantId();return c.createAppVariant(K,v).catch(function(L){var M=L.messageKey;if(!M){M="MSG_SAVE_APP_VARIANT_FAILED";}return A.catchErrorDialog(L,M,K);});};var y=function(K){n=null;n=m({},K.response);return c.clearRTACommandStack(j);};var z=function(){var K=F.getUshellContainer();if(K&&j){K.setDirtyFlag(false);}};var E=function(K){z();I=A.isS4HanaCloud(K);var L=A.buildSuccessInfo(n.id,i,I);return c.showSuccessMessage(L);};var H=function(){var K=A.buildFinalSuccessInfoS4HANACloud();return c.showSuccessMessage(K);};var J=function(){B.show();if(I){var K;return f().then(function(){return t(n.id,n.reference);}).then(function(L){K=Object.assign({},L);B.hide();return d.call(this,i,null,k);}.bind(this)).then(function(){return e(K,n.id);}).then(function(){s();return H();}).then(function(){return i?q():d.call(this,i,I,k);}.bind(this));}B.hide();return d.call(this,i,I,k);};sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(K){if(!c){c=new K({commandSerializer:C,layer:k});}return P().then(u).then(w).then(x).then(y).then(G).then(E).then(J.bind(this)).then(q).catch(function(L){if(!L){return false;}if(I){s();}return d.call(this,null,I,k).then(q);}.bind(this));}.bind(this));}.bind(this));},onDeleteFromOverviewDialog:function(i,j,k){var I;return new Promise(function(l){sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(n){if(!c){c=new n({rootControl:r,commandSerializer:C,layer:k});}var D=function(){return c.deleteAppVariant(i).catch(function(E){if(E==='cancel'){return Promise.reject("cancel");}var M=E.messageKey;if(!M){M="MSG_DELETE_APP_VARIANT_FAILED";}return A.catchErrorDialog(E,M,i);});};var p=function(){A.closeOverviewDialog();var v=A.buildDeleteSuccessMessage(i,I);return c.showSuccessMessage(v);};var q=function(v){I=A.isS4HanaCloud(v);if(I){var w;return f(j).then(function(){return T(i);}).then(function(x){w=Object.assign({},x);return R.call(this,!j,k);}.bind(this)).then(function(){return h(w,i);});}B.show();return Promise.resolve();};var u=function(){if(I){s();}B.hide();return j?l():R.call(this,!I,I,k).then(l);};if(j){A.closeOverviewDialog();A.navigateToFLPHomepage();}return G().then(q.bind(this)).then(D).then(p).then(u.bind(this)).catch(function(E){if(E==='cancel'){return false;}if(I){s();}return R.call(this,null,I,k).then(l);}.bind(this));}.bind(this));}.bind(this));}};});
sap.ui.predefine('sap/ui/rta/appVariant/S4HanaCloudBackend',["sap/ui/base/ManagedObject","sap/ui/model/odata/v2/ODataModel","sap/base/Log"],function(M,O,L){"use strict";var m;
var S=M.extend("sap.ui.rta.appVariant.S4HanaCloudBackend",{
metadata:{library:"sap.ui.rta"},
constructor:function(){M.apply(this,arguments);}
});
S.prototype.notifyFlpCustomizingIsReady=function(i,a,c,b){var t=this;return new Promise(function(r,d){function e(n){return!isNaN(parseFloat(n))&&isFinite(n);}var f=e(c)?c:2500;var R=e(b)?b:-1;function g(){if(R===0){r({iamAppId:i,customizingIsReady:false});return;}else if(R>0){R=R-1;}this.checkCatalogCustomizingIsReady(i,a).then(function(I){if(I){r({iamAppId:i,customizingIsReady:true});}else{setTimeout(g.bind(t),f);}}).catch(function(E){var T=a?"creation":"deletion";L.error("Catalog publishing failed for app variant "+T+". AppVarStatus is "+E.message);d({iamAppId:i,error:E.message});});}setTimeout(g.bind(t),f);});};
S._isAppReady=function(a,A){var c=a.data.results;if(!Array.isArray(c)){throw new Error(a.requestUri+" returned unexpected result: "+a);}var i=c.every(function(C){return C.ActualStatus===1;});var I=c.every(function(C){return C.ActualStatus===2;});var e=c.some(function(C){return C.ActualStatus===5;});var b=c.some(function(C){return C.ActualStatus===4;});if(e||b){var t=e?"error":"locked";throw new Error(t);}return A?I:i;};
S._getODataModel=function(){if(!m){m=new Promise(function(r,a){var o=new O("/sap/opu/odata/sap/APS_IAM_APP_SRV");o.attachMetadataFailed(function(e){a(e);m=null;});o.metadataLoaded().then(function(){r(o);});});}return m;};
S._readODataModel=function(o,i){return new Promise(function(r,a){var s=function(d,R){r(R);};var f=function(e){a(e);};return o.read("/aps_iam_app_ddl('"+i+"')/to_BusinessCatalogAssignment",{success:s,error:f});});};
S.prototype.checkCatalogCustomizingIsReady=function(i,a){return S._getODataModel().then(function(o){return S._readODataModel(o,i);}).then(function(A){return S._isAppReady(A,a);});};
return S;});
sap.ui.predefine('sap/ui/rta/appVariant/Utils',["sap/ui/rta/appVariant/AppVariantUtils","sap/ui/fl/registry/Settings","sap/base/i18n/ResourceBundle","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/core/IconPool"],function(A,S,R,a,I){"use strict";var U={};var m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";var i=R.create({url:m+"/i18n/i18n.properties"});
U._checkNavigationSupported=function(n){var N=sap.ushell.Container.getService("CrossApplicationNavigation");return N.getLinks(n);};
U._checkAppType=function(o,b){if(o&&b){return i.getText("MAA_ORIGINAL_TYPE");}else if(b){return i.getText("MAA_APP_VARIANT_TYPE");}else if(o){return i.getText("MAA_ORIGINAL_TYPE");}return undefined;};
U._calculateCurrentStatus=function(s,b){var n=A.getNewAppVariantId();if(b==='R'){return i.getText("MAA_OPERATION_IN_PROGRESS");}else if(n===s){A.setNewAppVariantId(null);if(b!=='E'){return i.getText("MAA_NEW_APP_VARIANT");}}};
U._checkMenuItemOptions=function(p,b){var o={};if(p.isKeyUser){if(p.isOriginal){o.delAppVarButtonVisibility=false;o.adaptUIButtonVisibility=false;return o;}if(p.appVarStatus==='U'||p.appVarStatus==='E'||p.appVarStatus==='R'){o.saveAsButtonEnabled=false;}o.adaptUIButtonVisibility=true;if(b){if(p.isS4HanaCloud){o.delAppVarButtonEnabled=true;o.delAppVarButtonVisibility=true;}else{o.delAppVarButtonEnabled=false;o.delAppVarButtonVisibility=true;}}else{o.delAppVarButtonVisibility=true;if(p.appVarStatus==='R'){o.delAppVarButtonEnabled=false;}else{o.delAppVarButtonEnabled=true;}}}else{o.delAppVarButtonVisibility=false;o.adaptUIButtonVisibility=false;}return o;};
U._getNavigationInfo=function(p){var n={};var s=p.startWith.semanticObject;var b=p.startWith.action;var P=p.startWith.parameters;var N={semanticObject:s,action:b,params:P};return this._checkNavigationSupported(N).then(function(r){var d;if(r.length&&p.isKeyUser){n.adaptUIButtonEnabled=true;if(p.appVarStatus==='R'||p.appVarStatus==='U'||p.appVarStatus==='E'){n.adaptUIButtonEnabled=false;n.appVarStatus=p.appVarStatus;}}else{n.adaptUIButtonEnabled=false;}d=this._checkMenuItemOptions(p,n.adaptUIButtonEnabled);n.semanticObject=s;n.action=b;if(P){Object.keys(P).forEach(function(c){if(P[c].value){P[c]=P[c].value;}});n.params=P;}n=Object.assign({},n,d);return n;}.bind(this));};
U._prepareAppVariantAttributes=function(o){return{appId:o.appId,title:o.title||'',subTitle:o.subTitle||'',description:o.description||'',icon:o.iconUrl||'',iconText:o.iconText,isOriginal:o.isOriginal,isAppVariant:o.isAppVariant,descriptorUrl:o.descriptorUrl,appVarStatus:o.appVarStatus};};
U.getAppVariantOverviewAttributes=function(o,k){var b;var s=o.iconUrl;if(s&&I.isIconURI(s)){o.iconText=s.split('//')[1];}b=this._prepareAppVariantAttributes(o);b.isKeyUser=k;b.typeOfApp=this._checkAppType(o.isOriginal,o.isAppVariant);b.currentStatus=this._calculateCurrentStatus(o.appId,o.appVarStatus);var c;return S.getInstance().then(function(d){c=A.isS4HanaCloud(d);b.isS4HanaCloud=c;var p={isKeyUser:k,isOriginal:o.isOriginal,isS4HanaCloud:c,appVarStatus:o.appVarStatus};if(o.hasStartableIntent){p.startWith=o.startWith;return this._getNavigationInfo(p).then(function(n){b=Object.assign({},b,n);return b;});}b.adaptUIButtonEnabled=false;var D=this._checkMenuItemOptions(p,false);b=Object.assign({},b,D);return Promise.resolve(b);}.bind(this));};
U.getAppVariantOverview=function(r,k){var l=k?'CUSTOMER*':'VENDOR';var p={selector:{appId:r},layer:l};return a.listAllAppVariants(p).then(function(o){var b=[];var c;if(o.response&&o.response.items){c=o.response.items;}else{return Promise.resolve([]);}c.forEach(function(d){if(!d.isDescriptorVariant){b.push(this.getAppVariantOverviewAttributes(d,k));}},this);return Promise.all(b).then(function(d){return d;});}.bind(this));};
U.getDescriptor=function(p){return a.getManifest(p).then(function(r){return r.response;});};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/Component',["sap/ui/core/UIComponent"],function(U){"use strict";var _;var a;var b;return U.extend("sap.ui.rta.appVariant.manageApps.webapp.Component",{metadata:{manifest:"json",library:"sap.ui.rta",version:"0.9",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"}},constructor:function(){_=arguments[1].idRunningApp;a=arguments[1].isOverviewForKeyUser;b=arguments[1].layer;U.prototype.constructor.apply(this,arguments);},init:function(){this.setIdRunningApp(_);this.setIsOverviewForKeyUser(a);this.setLayer(b);U.prototype.init.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller',["sap/ui/core/mvc/Controller","sap/ui/fl/Layer","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/base/i18n/ResourceBundle"],function(C,L,M,A,a,b,R,c,d,B,e){"use strict";var _;var f;var g;var m;var i;return C.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit:function(){_=this.getOwnerComponent().getIdRunningApp();f=this.getOwnerComponent().getIsOverviewForKeyUser();g=this.getOwnerComponent().getLayer();if(!i){this._createResourceBundle();}B.show();return a.getAppVariantOverview(_,f).then(function(h){B.hide();if(h.length){return this._arrangeOverviewDataAndBindToModel(h).then(function(h){return this._highlightNewCreatedAppVariant(h);}.bind(this));}A.closeOverviewDialog();return this._showMessageWhenNoAppVariantsExist();}.bind(this))["catch"](function(E){A.closeOverviewDialog();var o=A.buildErrorInfo("MSG_MANAGE_APPS_FAILED",E);o.overviewDialog=true;B.hide();return A.showRelevantDialog(o,false);});},_createResourceBundle:function(){m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";i=e.create({url:m+"/i18n/i18n.properties"});},_showMessageWhenNoAppVariantsExist:function(){return R.showMessageBox(b.Icon.INFORMATION,"MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER",{titleKey:"TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER"});},_highlightNewCreatedAppVariant:function(h){var t=this.byId("Table1");h.forEach(function(o,j){if(o.currentStatus===i.getText("MAA_NEW_APP_VARIANT")||o.currentStatus===i.getText("MAA_OPERATION_IN_PROGRESS")){if(t.getItems().length>=j){t.getItems()[j].focus();}}});return Promise.resolve();},_arrangeOverviewDataAndBindToModel:function(h){var j=h.filter(function(p){return p.appId===_;});var o=j[0];if(o&&o.appVarStatus!=="R"){o.currentStatus=i.getText("MAA_CURRENTLY_ADAPTING");}h=h.filter(function(p){return p.appId!==_;});h.unshift(o);var r=h.filter(function(p){return p.isOriginal;});var k=r[0];h=h.filter(function(p){return!p.isOriginal;});h.unshift(k);var l={appVariants:h};var n=M.createModel(l);this.getView().setModel(n);return Promise.resolve(h);},formatRowHighlight:function(v){if(v===i.getText("MAA_CURRENTLY_ADAPTING")){return"Success";}else if(v===i.getText("MAA_NEW_APP_VARIANT")){return"Information";}else if(v===i.getText("MAA_OPERATION_IN_PROGRESS")){return"Warning";}return"None";},formatDelButtonTooltip:function(D,I){if(!i){this._createResourceBundle();}if(!D&&!I){return i.getText("TOOLTIP_DELETE_APP_VAR");}return undefined;},formatAdaptUIButtonTooltip:function(h,s){if(!i){this._createResourceBundle();}if(!h){switch(s){case'R':return i.getText("TOOLTIP_ADAPTUI_STATUS_RUNNING");case'U':return i.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case'E':return i.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case'P':return i.getText("TOOLTIP_ADAPTUI_STATUS_PUBLISHED");case undefined:return i.getText("TOOLTIP_ADAPTUI_ON_PREMISE");default:}}},formatAdaptUIButtonVisibility:function(v,k){return v&&k;},getModelProperty:function(s,h){return this.getView().getModel().getProperty(s,h);},onMenuAction:function(E){var I=E.getParameter("item");var s="";while(I instanceof sap.m.MenuItem){s=I.getText()+" > "+s;I=I.getParent();}s=s.substr(0,s.lastIndexOf(" > "));if(!i){this._createResourceBundle();}if(s===i.getText("MAA_DIALOG_ADAPT_UI")){return this.handleUiAdaptation(E);}else if(s===i.getText("MAA_DIALOG_COPY_ID")){return this.copyId(E);}else if(s===i.getText("MAA_DIALOG_DELETE_APPVAR")){return this.deleteAppVariant(E);}else if(s===i.getText("MAA_DIALOG_SAVE_AS_APP")){return this.saveAsAppVariant(E);}return undefined;},handleUiAdaptation:function(E){var n=sap.ushell.Container.getService("CrossApplicationNavigation");var s=this.getModelProperty("semanticObject",E.getSource().getBindingContext());var h=this.getModelProperty("action",E.getSource().getBindingContext());var p=this.getModelProperty("params",E.getSource().getBindingContext());var N;if(s&&h&&p){N={target:{semanticObject:s,action:h},params:p,writeHistory:false};d.enableRestart(L.CUSTOMER);n.toExternal(N);A.closeOverviewDialog();return true;}return false;},saveAsAppVariant:function(E){A.closeOverviewDialog();var D=this.getModelProperty("descriptorUrl",E.getSource().getBindingContext());B.show();return a.getDescriptor({appVarUrl:D,layer:g}).then(function(o){B.hide();return c.onSaveAs(false,false,g,o);});},copyId:function(E){var s=this.getModelProperty("appId",E.getSource().getBindingContext());A.copyId(s);},deleteAppVariant:function(E){var I={};if(!i){this._createResourceBundle();}var s=i.getText("MSG_APP_VARIANT_DELETE_CONFIRMATION");I.text=s;I.deleteAppVariant=true;var h=this.getModelProperty("appId",E.getSource().getBindingContext());var j=this.getModelProperty("currentStatus",E.getSource().getBindingContext());var k=j===i.getText("MAA_CURRENTLY_ADAPTING");return A.showRelevantDialog(I).then(function(){return c.onDeleteFromOverviewDialog(h,k,g);}).catch(function(){return true;});}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/model/models',["sap/ui/model/json/JSONModel"],function(J){"use strict";return{createModel:function(d){var m=new J(d);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/rta/command/AddIFrame',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddIFrame",{metadata:{library:"sap.ui.rta",properties:{baseId:{type:"string",group:"content"},targetAggregation:{type:"string",group:"content"},index:{type:"int",group:"content"},url:{type:"string",group:"content"},width:{type:"string",group:"content"},height:{type:"string",group:"content"},changeType:{type:"string",defaultValue:"addIFrame"}},associations:{},events:{}}});
A.prototype.applySettings=function(s){var S={};Object.keys(s).filter(function(b){return b!=="url";}).forEach(function(b){S[b]=s[b];});var a=[].slice.call(arguments);a[0]=S;F.prototype.applySettings.apply(this,a);this.setUrl(s.url);};
A.prototype._getChangeSpecificData=function(){var c=F.prototype._getChangeSpecificData.call(this);var C=c.changeType;delete c.changeType;return{changeType:C,content:c};};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddProperty',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddProperty",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},bindingString:{type:"string"},entityType:{type:"string"},parentId:{type:"string"},oDataServiceVersion:{type:"string"},oDataServiceUri:{type:"string"},modelType:{type:"string"},relevantContainerId:{type:"string"},propertyName:{type:"string"}}}});
A.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),bindingPath:this.getBindingString(),parentId:this.getParentId(),modelType:this.getModelType(),relevantContainerId:this.getRelevantContainerId(),oDataServiceVersion:this.getODataServiceVersion(),oDataInformation:{oDataServiceUri:this.getODataServiceUri(),propertyName:this.getPropertyName(),entityType:this.getEntityType()}};};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddXML',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddXML",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string",group:"content"},fragmentPath:{type:"string",group:"content"},targetAggregation:{type:"string",group:"content"},index:{type:"int",group:"content"},changeType:{type:"string",defaultValue:"addXML"}},associations:{},events:{}}});
A.prototype.bindProperty=function(n,b){if(n==="fragment"){return this.setFragment(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
A.prototype._applyChange=function(c){var m={};m[c.getModuleName()]=this.getFragment();sap.ui.require.preload(m);return F.prototype._applyChange.apply(this,arguments);};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddXMLAtExtensionPoint',["sap/ui/rta/command/FlexCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/ui/fl/Utils"],function(F,J,C,E,U){"use strict";
var A=F.extend("sap.ui.rta.command.AddXMLAtExtensionPoint",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string",group:"content"},fragmentPath:{type:"string",group:"content"},changeType:{type:"string",defaultValue:"addXMLAtExtensionPoint"}},associations:{},events:{}}});
A.prototype.bindProperty=function(n,b){if(n==="fragment"){return this.setFragment(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
A.prototype.getAppComponent=function(){var v=this.getSelector().view;return U.getAppComponentForControl(v);};
A.prototype._applyChange=function(c){var m={};m[c.getModuleName()]=this.getFragment();sap.ui.require.preload(m);var o=c.change||c;var a=this.getAppComponent();var s=o.getSelector();var v=J.bySelector(s.viewSelector,a);var e=E.getExtensionPointInfo({name:s.name,view:v});var S=e.targetControl;o.setExtensionPointInfo(e);var p={modifier:J,appComponent:a,view:v};return C.apply(Object.assign({change:o,element:S},p)).then(function(r){if(!r.success){return Promise.reject(r.error);}});};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AppDescriptorCommand',["sap/ui/rta/command/BaseCommand","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory"],function(B,A,D){"use strict";
var a=B.extend("sap.ui.rta.command.AppDescriptor",{metadata:{library:"sap.ui.rta",properties:{reference:{type:"string"},appComponent:{type:"object"},layer:{type:"string"},changeType:{type:"string"},parameters:{type:"object"},texts:{type:"object"}},events:{}}});
a.prototype.needsReload=true;
a.prototype.prepare=function(f){this.setLayer(f.layer);return true;};
a.prototype.getPreparedChange=function(){return this._oPreparedChange;};
a.prototype.createAndStoreChange=function(){return A.createDescriptorInlineChange({changeType:this.getChangeType(),content:this.getParameters(),texts:this.getTexts()}).then(function(o){return new D().createNew(this.getReference(),o,this.getLayer(),this.getAppComponent());}.bind(this)).then(function(o){var c=o.store();this._oPreparedChange=c;}.bind(this));};
return a;});
sap.ui.predefine('sap/ui/rta/command/BaseCommand',["sap/ui/base/ManagedObject"],function(M){"use strict";
var B=M.extend("sap.ui.rta.command.BaseCommand",{metadata:{library:"sap.ui.rta",properties:{name:{type:"string"},runtimeOnly:{type:"boolean"}},associations:{element:{type:"sap.ui.core.Element"}},events:{}}});
B.prototype.getElement=function(){var i=this.getAssociation("element");return sap.ui.getCore().byId(i);};
B.prototype.prepare=function(){return true;};
B.prototype.execute=function(){return Promise.resolve();};
B.prototype.getVariantChange=function(){return this._oVariantChange;};
B.prototype.undo=function(){return Promise.resolve();};
B.prototype.isEnabled=function(){return true;};
return B;});
sap.ui.predefine('sap/ui/rta/command/BindProperty',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var B=F.extend("sap.ui.rta.command.BindProperty",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newBinding:{type:"string"},changeType:{type:"string",defaultValue:"propertyBindingChange"}},associations:{},events:{}}});
B.prototype.bindProperty=function(n,b){if(n==="newBinding"){return this.setNewBinding(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
B.prototype._getChangeSpecificData=function(){var e=this.getElement();var s={changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newBinding:this.getNewBinding()}};return s;};
return B;});
sap.ui.predefine('sap/ui/rta/command/Combine',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.Combine",{metadata:{library:"sap.ui.rta",properties:{source:{type:"any"},combineElements:{type:"any[]"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(){var f=[];this.getCombineElements().forEach(function(o){f.push(o.getId());});var s={changeType:this.getChangeType(),sourceControlId:this.getSource().getId(),combineElementIds:f};return s;};
return C;});
sap.ui.predefine('sap/ui/rta/command/CommandFactory',["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/dt/Util","sap/base/util/merge"],function(M,E,O,F,L,D,m){"use strict";
function e(z){var B=E.getAggregationInformation(z.getElement());if(B.elementId){var A=O.getOverlay(B.elementId);var P=A.getParentElementOverlay();var G=P?!!E.getAggregationInformation(P.getElement()).templateId:false;if(G){throw D.createError("CommandFactory#evaluateTemplateBinding","Multiple template bindings are not supported","sap.ui.rta");}var T=E.extractTemplateId(B);if(T){return{templateSelector:B.elementId,originalSelector:T,content:{boundAggregation:B.aggregation}};}}return undefined;}
function g(z,I){var A=(typeof z==="string")?sap.ui.getCore().byId(z):z;var B=O.getOverlay(A);if(B){var G=E.getAggregationInformation(A);if(typeof I==="number"){G.stack[0].index=I;}return E.extractTemplateId(G);}return A.getId();}
function a(z){if(!z){throw new Error("adjustment for template failed");}}
function c(z,A,B){var G;var J=false;if(typeof(B)==="string"){G=B;}else{G=B&&B.changeType;J=B&&B.jsOnly;}if(!G){return false;}A.setChangeType(G);A.setJsOnly(J);return true;}
function b(z,S,A){var B={changeType:S.name};if(A){jQuery.extend(B,A.getAction(S.name,z));}return B;}
function d(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);}
function f(z,S,A){var N=S.element||sap.ui.getCore().byId(S.element.id);var B=A.getActionDataFromAggregations("createContainer",N)[0];return B;}
function h(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.parentId=g(S.parentId);a(S.parentId);}
function i(z,S,A){var B=S.movedElements[0].element||sap.ui.getCore().byId(S.movedElements[0].id);var G=A.getAction("move",B);return G;}
function j(S){var T=S.movedElements.map(function(z){var A=sap.ui.getCore().byId(g(z.element,z.sourceIndex));a(A);return A;});S.movedElements.forEach(function(z,A){z.element=T[A];});S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.source.parent=sap.ui.getCore().byId(g(S.source.parent));a(S.source.parent);S.target.parent=sap.ui.getCore().byId(g(S.target.parent));a(S.target.parent);}
function k(z,S,A){var R=S.renamedElement;var B=A.getAction("rename",R);return B;}
function l(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.renamedElement=sap.ui.getCore().byId(g(S.renamedElement));a(S.renamedElement);}
function n(z,S,A){var R=S.removedElement;if(!R){R=z;}else if(!(R instanceof M)){throw new Error("No valid 'removedElement' found");}var B=A.getAction("remove",R);return B;}
function o(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.removedElement=sap.ui.getCore().byId(g(S.removedElement));a(S.removedElement);}
function p(z,S,A){var B=S.source;var G=A.getAction("combine",B);return G;}
function q(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.source=sap.ui.getCore().byId(g(S.source));a(S.source);var T=S.combineElements.map(function(z){z=sap.ui.getCore().byId(g(z));a(z);return z;});S.combineElements=T;}
function r(z,S,A){var B=S.source;var G=A.getAction("split",B);return G;}
function s(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.parentElement=sap.ui.getCore().byId(g(S.parentElement));a(S.parentElement);S.source=sap.ui.getCore().byId(g(S.source));a(S.source);}
function t(z,S,A){var N=S.element;return A.getAction("add",N,"delegate");}
function u(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.parentId=g(S.parentId);a(S.parentId);}
function v(z,S,A){var R=S.element;var B=A.getAction("reveal",R);return B;}
function w(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);if(S.revealedElementId){S.revealedElementId=g(S.revealedElementId);a(S.revealedElementId);}if(S.directParent){S.directParent=sap.ui.getCore().byId(g(S.directParent));a(S.directParent);}}
function x(z,S,A){var B=A.getAction("add",S.element);if(B&&B.custom&&typeof B.custom.getItems==="function"){var G={changeOnRelevantContainer:S.changeOnRelevantContainer,changeType:S.changeType};delete S["changeOnRelevantContainer"];return G;}}
var C={composite:{clazz:'sap.ui.rta.command.CompositeCommand',noSelector:true},property:{clazz:'sap.ui.rta.command.Property',adjustForBinding:d},bindProperty:{clazz:'sap.ui.rta.command.BindProperty'},addXML:{clazz:'sap.ui.rta.command.AddXML',configure:b,adjustForBinding:d},addXMLAtExtensionPoint:{clazz:'sap.ui.rta.command.AddXMLAtExtensionPoint',configure:b,adjustForBinding:d},createContainer:{clazz:'sap.ui.rta.command.CreateContainer',configure:f,adjustForBinding:h},move:{clazz:'sap.ui.rta.command.Move',configure:i,adjustForBinding:j},remove:{clazz:'sap.ui.rta.command.Remove',configure:n,adjustForBinding:o},rename:{clazz:'sap.ui.rta.command.Rename',configure:k,adjustForBinding:l},addDelegateProperty:{clazz:'sap.ui.rta.command.AddProperty',configure:t,adjustForBinding:u},reveal:{clazz:'sap.ui.rta.command.Reveal',configure:v,adjustForBinding:w},customAdd:{clazz:'sap.ui.rta.command.CustomAdd',configure:x},combine:{clazz:'sap.ui.rta.command.Combine',configure:p,adjustForBinding:q},split:{clazz:'sap.ui.rta.command.Split',configure:r,adjustForBinding:s},"switch":{clazz:'sap.ui.rta.command.ControlVariantSwitch'},duplicate:{clazz:'sap.ui.rta.command.ControlVariantDuplicate'},setTitle:{clazz:'sap.ui.rta.command.ControlVariantSetTitle'},configure:{clazz:'sap.ui.rta.command.ControlVariantConfigure'},settings:{clazz:'sap.ui.rta.command.Settings'},addLibrary:{clazz:'sap.ui.rta.command.appDescriptor.AddLibrary',noSelector:true},appDescriptor:{clazz:'sap.ui.rta.command.AppDescriptorCommand',noSelector:true},addIFrame:{clazz:'sap.ui.rta.command.AddIFrame'}};
function _(z,A,S,B,G,V){A=A[0].toLowerCase()+A.slice(1);var H=C[A];var I=G;if(!H){return Promise.reject(D.createError("CommandFactory#_getCommandFor","Command '"+A+"' doesn't exist, check typing","sap.ui.rta"));}return new Promise(function(R){var J=H.clazz;sap.ui.require([J.replace(/\./g,"/")],function(K){R(K);});}).then(function(J){var K=z instanceof M;if(!H.noSelector){S=Object.assign({},S,!K&&{selector:z});}S=Object.assign({},S,{element:K?z:undefined,name:A});var N;if(H.configure){N=H.configure(z,S,B);}var P;if(K){P=O.getOverlay(z);}if(N&&N.changeOnRelevantContainer){Object.assign(S,{element:P.getRelevantContainer()});z=S.element;P=O.getOverlay(z);}var T;if(P&&z.sParentAggregationName){T=e(P);}if(T){if(H.adjustForBinding){H.adjustForBinding(S);}I=m(T,I);}var Q=new J(S);var R=true;if(H.configure){R=c(z,Q,N);}if(R){return Promise.resolve().then(function(){return Q.prepare(I,V,A);}).then(function(U){if(U){return Q;}});}Q.destroy();return undefined;});}
var y=M.extend("sap.ui.rta.command.CommandFactory",{metadata:{library:"sap.ui.rta",properties:{flexSettings:{type:"object"}},associations:{},events:{}}});
y.prototype.init=function(){this.setProperty("flexSettings",{layer:L.CUSTOMER,developerMode:true});};
y.prototype.setFlexSettings=function(z){this.setProperty("flexSettings",jQuery.extend(this.getFlexSettings(),z));};
y.prototype.getCommandFor=function(z,A,S,B,V){return _(z,A,S,B,this.getFlexSettings(),V);};
y.getCommandFor=function(z,A,S,B,G){if(!G){G={layer:L.CUSTOMER,developerMode:true};}if(G.scenario||G.baseId){var H=F.buildLrepRootNamespace(G.baseId,G.scenario,G.projectId);G.rootNamespace=H;G.namespace=H+"changes/";}return _(z,A,S,B,G);};
return y;},true);
sap.ui.predefine('sap/ui/rta/command/CompositeCommand',["sap/ui/rta/command/BaseCommand","sap/ui/fl/Utils"],function(B,F){"use strict";
var C=B.extend("sap.ui.rta.command.CompositeCommand",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{}}});
C.prototype.execute=function(){var p=[];this._forEachCommand(function(c){p.push(c.execute.bind(c));});return F.execPromiseQueueSequentially(p,true).catch(function(e){var c=this.getCommands();c.forEach(function(o){if(o instanceof sap.ui.rta.command.FlexCommand){if(!o._aRecordedUndo){this.removeCommand(o);}}}.bind(this));return this.undo().then(function(){return Promise.reject(e);});}.bind(this));};
C.prototype.undo=function(){var p=[];this._forEachCommandInReverseOrder(function(c){p.push(c.undo.bind(c));});return F.execPromiseQueueSequentially(p);};
C.prototype._forEachCommand=function(d){var c=this.getCommands();c.forEach(d,this);};
C.prototype._forEachCommandInReverseOrder=function(d){var c=this.getCommands();for(var i=c.length-1;i>=0;i--){d.call(this,c[i]);}};
C.prototype._addCompositeIdToChange=function(c){if(c.getPreparedChange&&c.getPreparedChange()){var o=c.getPreparedChange().getDefinition();if(!o.support.compositeCommand){if(!this._sCompositeId){this._sCompositeId=F.createDefaultFileName("composite");}o.support.compositeCommand=this._sCompositeId;}}};
C.prototype.addCommand=function(c,s){this._addCompositeIdToChange(c);return this.addAggregation("commands",c,s);};
C.prototype.insertCommand=function(c,i,s){this._addCompositeIdToChange(c);return this.insertAggregation("commands",c,i,s);};
return C;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantConfigure',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantConfigure",{metadata:{library:"sap.ui.rta",properties:{control:{type:"any"},changes:{type:"array"}},associations:{},events:{}}});
C.prototype.prepare=function(F){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getControl();this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this._aPreparedChanges=[];this.getChanges().forEach(function(c){c.appComponent=this.oAppComponent;this._aPreparedChanges.push(this.oModel.setVariantProperties(this.sVariantManagementReference,c,true));}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var p;this.getChanges().forEach(function(c,i){p={};Object.keys(c).forEach(function(P){var o="original"+P.charAt(0).toUpperCase()+P.substr(1);if(P==="visible"){p[P]=true;}else if(c[o]){p[P]=c[o];p[o]=c[P];}else if(P.indexOf("original")===-1){p[P]=c[P];}});p.change=this._aPreparedChanges[i];this.oModel.setVariantProperties(this.sVariantManagementReference,p,false);}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);this._aPreparedChanges=null;}.bind(this));};
return C;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantDuplicate',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantDuplicate",{metadata:{library:"sap.ui.rta",properties:{sourceVariantReference:{type:"string"},newVariantReference:{type:"string"},newVariantTitle:{type:"string"}},associations:{},events:{}}});
C.prototype.prepare=function(F){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getElement();var s=this.getSourceVariantReference();var n=this.getNewVariantReference();this.oAppComponent=f.getAppComponentForControl(v);if(!n){n=f.createDefaultFileName();this.setNewVariantReference(n);}this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this.oModel=this.oAppComponent.getModel(f.VARIANT_MODEL_NAME);var p={variantManagementReference:this.sVariantManagementReference,appComponent:this.oAppComponent,layer:this.sLayer,newVariantReference:n,sourceVariantReference:s,title:this.getNewVariantTitle()};return this.oModel.copyVariant(p).then(function(c){this._oVariantChange=c[0];this._aPreparedChanges=c;}.bind(this));};
C.prototype.undo=function(){if(this._oVariantChange){var p={variant:this._oVariantChange,sourceVariantReference:this.getSourceVariantReference(),variantManagementReference:this.sVariantManagementReference,component:this.oAppComponent};return this.oModel.removeVariant(p).then(function(){this._oVariantChange=null;this._aPreparedChanges=null;}.bind(this));}return Promise.resolve();};
return C;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantSetTitle',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSetTitle",{metadata:{library:"sap.ui.rta",properties:{oldText:{type:"string"},newText:{type:"string"}},associations:{},events:{}}});
C.prototype.prepare=function(F){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){this._oPreparedChange=this.getVariantChange();if(!this._oPreparedChange){return undefined;}return this._oPreparedChange;};
C.prototype.execute=function(){var v=this.getElement();var V=v.getTitle().getBinding("text");this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this.sCurrentVariant=this.oModel.getCurrentVariantReference(this.sVariantManagementReference);var c=this.oModel.getVariantProperty(this.sCurrentVariant,"title");this.setOldText(c);var p={appComponent:this.oAppComponent,variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getNewText(),layer:this.sLayer};return Promise.resolve(this.oModel.setVariantProperties(this.sVariantManagementReference,p,true)).then(function(o){this._oVariantChange=o;V.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var v=this.getElement().getTitle().getBinding("text");var p={variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getOldText(),change:this._oVariantChange};return Promise.resolve(this.oModel.setVariantProperties(this.sVariantManagementReference,p,false)).then(function(c){this._oVariantChange=c;v.checkUpdate(true);}.bind(this));};
return C;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantSwitch',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{targetVariantReference:{type:"string"},sourceVariantReference:{type:"string"}},associations:{},events:{}}});
C.prototype._getAppComponent=function(){var e=this.getElement();return e?f.getAppComponentForControl(e):this.getSelector().appComponent;};
C.prototype.execute=function(){var e=this.getElement();var a=this._getAppComponent();var n=this.getTargetVariantReference();this.oModel=a.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(e,a).id;return this._updateModelVariant(n,a);};
C.prototype.undo=function(){var o=this.getSourceVariantReference();var a=this._getAppComponent();return this._updateModelVariant(o,a);};
C.prototype._updateModelVariant=function(v,a){if(this.getTargetVariantReference()!==this.getSourceVariantReference()){return Promise.resolve(this.oModel.updateCurrentVariant(this.sVariantManagementReference,v,a));}return Promise.resolve();};
return C;});
sap.ui.predefine('sap/ui/rta/command/CreateContainer',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},newControlId:{type:"string",group:"content"},label:{type:"string"},parentId:{type:"string",group:"content"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(){var s=F.prototype._getChangeSpecificData.apply(this);s.newLabel=this.getLabel();return s;};
return C;});
sap.ui.predefine('sap/ui/rta/command/CustomAdd',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.CustomAdd",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},addElementInfo:{type:"object",group:"content"},aggregationName:{type:"string",group:"content"},customItemId:{type:"string",group:"content"}}}});
return C;});
sap.ui.predefine('sap/ui/rta/command/FlexCommand',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils","sap/base/Log","sap/base/util/merge","sap/ui/fl/write/api/ChangesWriteAPI","sap/base/util/values"],function(B,J,f,L,m,C,o){"use strict";
var F=B.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean"},selector:{type:"object"}},associations:{},events:{}}});
F.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id;};
F.prototype.getAppComponent=function(){var e=this.getElement();return e?f.getAppComponentForControl(e):this.getSelector().appComponent;};
F.prototype.prepare=function(a,v,c){var s;if(!this.getSelector()&&a&&a.templateSelector){s={id:a.templateSelector,appComponent:this.getAppComponent(),controlType:f.getControlType(sap.ui.getCore().byId(a.templateSelector))};this.setSelector(s);}else if(!this.getSelector()&&this.getElement()){s={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:f.getControlType(this.getElement())};this.setSelector(s);}return this._createChange(a,v,c).then(function(b){this._oPreparedChange=b;return true;}.bind(this)).catch(function(e){L.error(e.message||e.name);return false;});};
F.prototype.getPreparedChange=function(){return this._oPreparedChange;};
F.prototype.execute=function(){var c=this.getPreparedChange();return this._applyChange(c);};
F.prototype._getChangeSpecificData=function(){var p=this.getMetadata().getProperties();var c={changeType:this.getChangeType()};o(p).filter(function(P){return P.group==="content";}).forEach(function(P){c[P.name]=P.get(this);},this);return c;};
F.prototype._createChange=function(a,v,c){return this._createChangeFromData(this._getChangeSpecificData(),a,v,c);};
F.prototype._createChangeFromData=function(c,a,v,s){if(a){c=m({},c,a);}c.jsOnly=this.getJsOnly();var M=this.getAppComponent().getModel(f.VARIANT_MODEL_NAME);var V;if(M&&v){V=M.getCurrentVariantReference(v);}var b={variantManagementReference:v,variantReference:V};if(V){c=Object.assign({},c,b);}c.command=s;return C.create({changeSpecificData:c,selector:this._validateControlForChange(a)}).then(function(d){if(a&&a.originalSelector){d.addDependentControl(a.originalSelector,"originalSelector",{modifier:J,appComponent:this.getAppComponent()});d.getDefinition().selector=Object.assign(d.getDefinition().selector,J.getSelector(this.getSelector().id,this.getSelector().appComponent));d.setContent(Object.assign({},d.getContent(),a.content));}return d;}.bind(this));};
F.prototype.undo=function(){var c=this.getElement()||J.bySelector(this.getSelector());var a=this.getPreparedChange();return C.revert({change:a,element:c});};
F.prototype._applyChange=function(c){var a=c.change||c;var A=this.getAppComponent();var s=J.bySelector(a.getSelector(),A);var p={modifier:J,appComponent:A,view:f.getViewForControl(s)};return C.apply(Object.assign({change:a,element:s},p)).then(function(r){if(!r.success){return Promise.reject(r.error);}});};
F.prototype._validateControlForChange=function(a){if(a&&a.originalSelector&&a.content&&a.content.boundAggregation){return{id:a.originalSelector,appComponent:this.getAppComponent(),controlType:f.getControlType(sap.ui.getCore().byId(a.originalSelector))};}return this.getElement()||this.getSelector();};
return F;});
sap.ui.predefine('sap/ui/rta/command/LREPSerializer',["sap/ui/base/ManagedObject","sap/ui/rta/command/FlexCommand","sap/ui/rta/command/AppDescriptorCommand","sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/dt/ElementUtil","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI"],function(M,F,A,a,C,E,L,P){"use strict";
var b=M.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.core.Control"}},properties:{commandStack:{type:"object"}},aggregations:{}}});
function g(r){return E.getElementInstance(r);}
b.prototype._lastPromise=Promise.resolve();
b.prototype.setCommandStack=function(c){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);}this.setProperty("commandStack",c);c.addCommandExecutionHandler(this._fnHandleCommandExecuted);};
b.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this);};
b.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);};
b.prototype._isPersistedChange=function(p){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(p.getId())!==-1;};
b.prototype.handleCommandExecuted=function(e){return(function(e){var p=e;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var c=this.getCommandStack().getSubCommands(p.command);if(p.undo){c.forEach(function(o){if(!(o instanceof F||o instanceof A)||o.getRuntimeOnly()){return;}var f=o.getPreparedChange();var h=o.getAppComponent();if(h){P.remove({change:f,selector:h});}});}else{var d=[];c.forEach(function(o){if(o.getRuntimeOnly()){return;}if(o instanceof F){var f=o.getAppComponent();if(f){var h=o.getPreparedChange();if(h.getState()===C.states.DELETED){h.setState(C.states.NEW);}if(!this._isPersistedChange(h)){P.add({change:o.getPreparedChange(),selector:f});}}}else if(o instanceof A){d.push(o.createAndStoreChange());}}.bind(this));return Promise.all(d);}}.bind(this));return this._lastPromise;}.bind(this))(e);};
b.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var c=this.getCommandStack().getAllExecutedCommands();return c.some(function(o){return!!o.needsReload;});}.bind(this));return this._lastPromise;};
b.prototype.saveCommands=function(s){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var r=g(this.getRootControl());if(!r){throw new Error("Can't save commands without root control instance!");}return P.save({selector:r,skipUpdateCache:false,draft:!!s});}.bind(this)).then(function(){L.info("UI adaptation successfully transfered changes to layered repository");this.getCommandStack().removeAllCommands();}.bind(this));return this._lastPromise;};
b.prototype._triggerUndoChanges=function(){var c=this.getCommandStack();var p=[];var d=c.getAllExecutedCommands();d.forEach(function(o){p.push(o.undo.bind(o));});p=p.reverse();return a.execPromiseQueueSequentially(p,false,true);};
b.prototype.clearCommandStack=function(){var c=this.getCommandStack();c.detachCommandExecuted(this.handleCommandExecuted.bind(this));return this._triggerUndoChanges().then(function(){c.removeAllCommands();c.attachCommandExecuted(this.handleCommandExecuted.bind(this));return true;}.bind(this));};
return b;});
sap.ui.predefine('sap/ui/rta/command/Move',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var M=F.extend("sap.ui.rta.command.Move",{metadata:{library:"sap.ui.rta",properties:{movedElements:{type:"any[]"},target:{type:"any"},source:{type:"any"}},associations:{},events:{}}});
M.prototype._getChangeSpecificData=function(){var s=this.getSource();var t=this.getTarget();if(s.parent){s.id=s.parent.getId();delete s.parent;}if(t.parent){t.id=t.parent.getId();delete t.parent;}var S={changeType:this.getChangeType(),source:s,target:t,movedElements:[]};this.getMovedElements().forEach(function(m){S.movedElements.push({id:m.id||(m.element&&m.element.getId()),sourceIndex:m.sourceIndex,targetIndex:m.targetIndex});});return S;};
return M;});
sap.ui.predefine('sap/ui/rta/command/Property',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var P=F.extend("sap.ui.rta.command.Property",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newValue:{type:"any"},semanticMeaning:{type:"string"},changeType:{type:"string",defaultValue:"propertyChange"}},associations:{},events:{}}});
P.prototype._getChangeSpecificData=function(){var e=this.getElement();return{changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newValue:this.getNewValue(),semantic:this.getSemanticMeaning()}};};
return P;});
sap.ui.predefine('sap/ui/rta/command/Remove',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Remove",{metadata:{library:"sap.ui.rta",properties:{removedElement:{type:"any"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var e=this.getRemovedElement()||this.getElement();var s={changeType:this.getChangeType(),removedElement:{id:e.getId()}};return s;};
return R;});
sap.ui.predefine('sap/ui/rta/command/Rename',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Rename",{metadata:{library:"sap.ui.rta",properties:{renamedElement:{type:"object"},newValue:{type:"string",defaultValue:"new text"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),renamedElement:{id:this.getRenamedElement().getId()},value:this.getNewValue()};return s;};
return R;});
sap.ui.predefine('sap/ui/rta/command/Reveal',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Reveal",{metadata:{library:"sap.ui.rta",properties:{revealedElementId:{type:"string"},directParent:"object"}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType()};if(this.getRevealedElementId()){s.revealedElementId=this.getRevealedElementId();}return s;};
return R;});
sap.ui.predefine('sap/ui/rta/command/Settings',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Settings",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any",group:"content"}},associations:{},events:{}}});
S.prototype.execute=function(){if(this.getElement()){return F.prototype.execute.apply(this,arguments);}return Promise.resolve();};
S.prototype.undo=function(){if(this.getElement()){return F.prototype.undo.apply(this,arguments);}return Promise.resolve();};
return S;});
sap.ui.predefine('sap/ui/rta/command/Split',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Split",{metadata:{library:"sap.ui.rta",properties:{newElementIds:{type:"string[]"},source:{type:"any"},parentElement:{type:"any"}},associations:{},events:{}}});
S.prototype._getChangeSpecificData=function(){var s={newElementIds:this.getNewElementIds(),sourceControlId:this.getSource().getId(),changeType:this.getChangeType(),parentId:this.getParentElement().getId()};return s;};
return S;});
sap.ui.predefine('sap/ui/rta/command/Stack',["sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/rta/command/Settings","sap/ui/rta/command/CompositeCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/write/api/PersistenceWriteAPI"],function(M,F,S,C,J,P){"use strict";
function _(c,d,f){var o=c[f];if(o){d.push(o);}return d;}
function a(c,m,s,o){var d=o.getSelector();var e=new S({selector:d,changeType:o.getDefinition().changeType,element:J.bySelector(d,c)});e._oPreparedChange=o;if(o.getUndoOperations()){e._aRecordedUndo=o.getUndoOperations();o.resetUndoOperations();}var f=o.getDefinition().support.compositeCommand;if(f){if(!m[f]){m[f]=new C();s.pushExecutedCommand(m[f]);}m[f].addCommand(e);}else{s.pushExecutedCommand(e);}}
var b=M.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});
b.initializeWithChanges=function(c,f){var s=new b();s._aPersistedChanges=f;if(f&&f.length>0){var o=F.getComponentForControl(c);var A=F.getAppDescriptor(o)["sap.app"].id;var p={oComponent:o,appName:A,selector:c,invalidateCache:false};return P._getUIChanges(p).then(function(d){var m={};var e={};d.forEach(function(g){e[g.getDefinition().fileName]=g;});f.reduce(_.bind(null,e),[]).forEach(a.bind(null,o,m,s));return s;});}return Promise.resolve(s);};
b.prototype.addCommandExecutionHandler=function(h){this._aCommandExecutionHandler.push(h);};
b.prototype.removeCommandExecutionHandler=function(h){var i=this._aCommandExecutionHandler.indexOf(h);if(i>-1){this._aCommandExecutionHandler.splice(i,1);}};
b.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1;this._oLastCommand=Promise.resolve();};
b.prototype._waitForCommandExecutionHandler=function(p){return Promise.all(this._aCommandExecutionHandler.map(function(h){return h(p);}));};
b.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted];};
b.prototype.pushExecutedCommand=function(c){this.push(c,true);};
b.prototype.push=function(c,e){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop();}}this.insertCommand(c,0);if(!e){this._toBeExecuted++;}this.fireModified();};
b.prototype.top=function(){return this.getCommands()[0];};
b.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--;}return this.removeCommand(0);};
b.prototype.removeCommand=function(o,s){var r=this.removeAggregation("commands",o,s);this.fireModified();return r;};
b.prototype.removeAllCommands=function(s){var c=this.removeAllAggregation("commands",s);this._toBeExecuted=-1;this.fireModified();return c;};
b.prototype.isEmpty=function(){return this.getCommands().length===0;};
b.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var c=this._getCommandToBeExecuted();if(c){return c.execute().then(function(){this._toBeExecuted--;var p={command:c,undo:false};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this)).catch(function(e){e=e||new Error("Executing of the change failed.");e.index=this._toBeExecuted;e.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;return Promise.reject(e);}.bind(this));}}.bind(this));return this._oLastCommand;};
b.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var c=this._getCommandToBeExecuted();if(c){return c.undo().then(function(){var p={command:c,undo:true};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this));}return Promise.resolve();}return Promise.resolve();};
b.prototype.canUndo=function(){return(this._toBeExecuted+1)<this.getCommands().length;};
b.prototype.undo=function(){return this._unExecute();};
b.prototype.canRedo=function(){return!!this._getCommandToBeExecuted();};
b.prototype.redo=function(){return this.execute();};
b.prototype.pushAndExecute=function(c){this.push(c);return this.execute();};
b.prototype.getAllExecutedCommands=function(){var A=[];var c=this.getCommands();for(var i=c.length-1;i>this._toBeExecuted;i--){var s=this.getSubCommands(c[i]);A=A.concat(s);}return A;};
b.prototype.getSubCommands=function(c){var d=[];if(c.getCommands){c.getCommands().forEach(function(s){var e=this.getSubCommands(s);d=d.concat(e);},this);}else{d.push(c);}return d;};
return b;});
sap.ui.predefine('sap/ui/rta/command/appDescriptor/AddLibrary',["sap/ui/rta/command/AppDescriptorCommand"],function(A){"use strict";
var a=A.extend("sap.ui.rta.command.appDescriptor.AddLibrary",{metadata:{library:"sap.ui.rta",events:{}}});
a.prototype.init=function(){this.setChangeType("appdescr_ui5_addLibraries");};
a.prototype.execute=function(){var p=[];if(this.getParameters().libraries){var l=Object.keys(this.getParameters().libraries);l.forEach(function(L){p.push(sap.ui.getCore().loadLibrary(L,true));});}return Promise.all(p);};
return a;},true);
sap.ui.predefine('sap/ui/rta/enablement/TestDelegate',["sap/base/util/isPlainObject","sap/base/util/merge"],function(i,m){"use strict";
function a(o,k){return o[k]&&typeof o[k]==="string";}
function c(p){if(!p.appComponent.isA("sap.ui.core.Component")){return false;}if(!i(p.modifier)){return false;}if(p.modifier.targets==="xmlTree"&&!a(p.view,"nodeName")){return false;}if(p.payload&&!i(p.payload)){return false;}return["aggregationName","bindingPath"].every(a.bind(null,p));}
var T={getPropertyInfo:function(p){return Promise.resolve().then(function(){var v=p.element.isA("sap.ui.core.Element")&&p.aggregationName&&typeof p.aggregationName==="string"&&(!p.payload||typeof p.payload==="object");if(v){return[];}});},createLabel:function(p){return Promise.resolve().then(function(){var P=c(p)&&a(p,"labelFor");if(P){return p.modifier.createControl("sap.m.Label",p.appComponent,p.view,p.labelFor+"-label",{labelFor:p.labelFor,text:p.bindingPath},true);}});},createControlForProperty:function(p){return Promise.resolve().then(function(){var P=c(p)&&(a(p.element,"nodeName")||p.element.isA("sap.ui.core.Element"))&&i(p.fieldSelector)&&a(p.fieldSelector,"id");if(P){var b=[p.modifier.createControl("sap.m.Text",p.appComponent,p.view,p.fieldSelector,{text:"{"+p.bindingPath+"}"},true)];if(p.payload.valueHelpId){var v=m({},p.fieldSelector,{id:p.fieldSelector.id+"-"+p.payload.valueHelpId});b.push(p.modifier.createControl("sap.ui.core.Element",p.appComponent,p.view,v,true));}return Promise.all(b).then(function(C){return{control:C[0],valueHelp:C[1]};});}});},createLayout:function(p){var P=c(p)&&p.fieldSelector&&typeof p.fieldSelector==="object"&&typeof p.fieldSelector.id==="string";if(P){return new Promise(function(r){if(!p.payload.useCreateLayout){return r();}var l;var v;var L=m({},p);L.fieldSelector.id+="-field";T.createControlForProperty(L).then(function(s){v=s.valueHelp;l=L.modifier.createControl(L.payload.layoutType,L.appComponent,L.view,p.fieldSelector);L.modifier.insertAggregation(l,L.payload.aggregation,s.control,0,L.view);if(L.payload.labelAggregation){var C=Object.assign({labelFor:L.modifier.getId(s.control)},L);return T.createLabel(C);}}).then(function(o){if(o){L.modifier.insertAggregation(l,L.payload.labelAggregation,o,0,L.view);}}).then(function(){r({control:l,valueHelp:v});});});}}};return T;});
sap.ui.predefine('sap/ui/rta/enablement/elementActionTest',["sap/ui/core/UIComponent","sap/ui/core/ComponentContainer","sap/ui/core/mvc/XMLView","sap/ui/rta/command/CommandFactory","sap/ui/dt/DesignTime","sap/ui/dt/DesignTimeStatus","sap/ui/dt/OverlayRegistry","sap/ui/fl/ChangePersistence","sap/ui/model/Model","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Cache","sap/ui/fl/Layer","sap/ui/thirdparty/sinon-4","sap/ui/fl/library"],function(U,C,X,a,D,b,O,c,M,S,P,d,L,s){"use strict";var e=function(m,o){if(e._only&&(m.indexOf(e._only)<0)){return;}if(typeof o.xmlView==="string"){o.xmlView={viewContent:o.xmlView};}var f=s.sandbox.create();o.before=o.before||function(){};o.after=o.after||function(){};QUnit.module(m,function(){QUnit.test("When using the 'controlEnablingCheck' function to test if your control is ready for UI adaptation at runtime",function(x){x.ok(o.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");x.ok(o.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");x.ok(o.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");x.ok(o.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");var y=new DOMParser().parseFromString(o.xmlView.viewContent,"application/xml").documentElement;x.ok(y.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");x.ok(o.action,"then you provide an action: See the action parameter.");x.ok(o.action.name,"then you provide an action name: See the action.name parameter.");x.ok(o.action.controlId||o.action.control,"then you provide the control or control's id to operate the action on: See the action.controlId.");});});var g="sap.ui.rta.control.enabling.comp";var h=false;var A=true;var i=U.extend(g,{metadata:{manifest:{"sap.app":{id:g,type:"application"},getEntry:function(){return{type:"application"};}}},createContent:function(){var V=Object.assign({},o.xmlView);V.id=this.createId("view");if(V.async===undefined){V.async=this.getComponentData().async;}var x=new X(V);return x;}});function j(x){this.oUiComponent=new i({id:"comp",componentData:{async:x}});this.oUiComponentContainer=new C({component:this.oUiComponent,height:'100%'});this.oUiComponentContainer.placeAt(o.placeAt||"qunit-fixture");this.oView=this.oUiComponent.getRootControl();if(o.model instanceof M){this.oView.setModel(o.model);}sap.ui.getCore().applyChanges();return Promise.all([this.oView.loaded(),o.model&&o.model.getMetaModel()&&o.model.getMetaModel().loaded()]);}function k(x){var y=[].concat(o.previousActions||[],o.action);var z=[];return y.reduce(function(B,E){return B.then(l.bind(this,x,E)).then(function(F){z.push(F);return F.execute();});}.bind(this),Promise.resolve()).then(function(){return z;});}function l(x,y){return Promise.resolve().then(function(){var z;var B;var E;if(typeof y.control==="function"){z=y.control(this.oView);}else{z=this.oView.byId(y.controlId);}var F=y.name;return z.getMetadata().loadDesignTime(z).then(function(){if(y.parameter){if(typeof y.parameter==="function"){B=y.parameter(this.oView);}else{B=y.parameter;}}else{B={};}sap.ui.getCore().applyChanges();this.oDesignTime=new D({rootElements:[this.oView]});return new Promise(function(G){this.oDesignTime.attachEventOnce("synced",function(){var H=O.getOverlay(z);E=H.getDesignTimeMetadata();var R=E.getAction("getResponsibleElement",z);var I;if(y.name==="move"){var J=O.getOverlay(B.movedElements[0].element||B.movedElements[0].id);var K=J.getRelevantContainer();z=K;E=J.getParentAggregationOverlay().getDesignTimeMetadata();}else if(y.name==="addODataProperty"){x.ok(false,"addODataProperty action is deprecated. Use addViaDelegate action instead.");}else if(Array.isArray(y.name)){var N=E.getActionDataFromAggregations(y.name[0],z,undefined,y.name[1]);x.equal(N.length,1,"there should be only one aggregation with the possibility to do an add "+y.name[1]+" action");I=H.getAggregationOverlay(N[0].aggregation);E=I.getDesignTimeMetadata();F="addDelegateProperty";}else if(R){if(y.name==="reveal"){z=y.revealedElement(this.oView);H=O.getOverlay(y.revealedElement(this.oView));E=H.getDesignTimeMetadata();}else{z=R;H=O.getOverlay(z);E=H.getDesignTimeMetadata();G(z.getMetadata().loadDesignTime(z));}}G();}.bind(this));}.bind(this));}.bind(this)).then(function(){var G=new a({flexSettings:{layer:o.layer||L.CUSTOMER}});return G.getCommandFor(z,F,B,E);}).then(function(G){x.ok(G,"then the registration for action to change type, the registration for change and control type to change handler is available and "+o.action.name+" is a valid action");return G;});}.bind(this)).catch(function(z){throw new Error(z);});}function n(x){return x.reduce(function(y,z){return y.then(z.execute.bind(z));},Promise.resolve());}function u(x){var y=x.slice().reverse();return y.reduce(function(z,B){return z.then(B.undo.bind(B));},Promise.resolve());}function p(x){x.forEach(function(y){y.destroy();});}function q(V,x,y){var R={remainingCommands:[],deletedCommands:[]};if(x.length===1){R.remainingCommands.push(x[0]);return Promise.resolve(R);}var z=x.map(function(B){return B.getPreparedChange();});return P._condense({selector:V,changes:z}).then(function(B){if(o.changesAfterCondensing!==undefined){y.equal(B.length,o.changesAfterCondensing,"after condensing the amount of changes is correct");}var E=B.map(function(F){return F.getId();});x.forEach(function(F){if(E.indexOf(F.getPreparedChange().getId())>-1){R.remainingCommands.push(F);}else{R.deletedCommands.push(F);}});return R;});}function r(x){x.forEach(function(y){var z=y.getPreparedChange();if(y.getAppComponent){P.remove({change:z,selector:y.getAppComponent()});}});}function t(x){var y=[];f.stub(c.prototype,"getChangesForComponent").resolves(y);f.stub(c.prototype,"getCacheKey").resolves("etag-123");return j.call(this,h).then(v.bind(this,x,y));}function v(x,y){var z=[].concat(o.previousActions||[],o.action);var B=[];return z.reduce(function(E,F){return E.then(l.bind(this,x,F)).then(function(G){B.push(G);y.push(G.getPreparedChange());this.oUiComponentContainer.destroy();return j.call(this,A);}.bind(this));}.bind(this),Promise.resolve()).then(function(V){this.aCommands=B;return V;}.bind(this));}if(!o.jsOnly){QUnit.module(m+" on async views",{before:function(x){this.hookContext={};return o.before.call(this.hookContext,x);},after:function(x){return o.after.call(this.hookContext,x);},beforeEach:function(){f.stub(S,"getInstance").resolves({_oSettings:{}});},afterEach:function(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();p(this.aCommands);f.restore();}},function(){QUnit.test("When applying the change directly on the XMLView",function(x){return t.call(this,x).then(function(y){var V=y[0];return o.afterAction(this.oUiComponent,V,x);}.bind(this));});QUnit.test("When executing on XML and reverting the change in JS (e.g. variant switch)",function(x){return t.call(this,x).then(function(){return u(this.aCommands);}.bind(this)).then(function(){r(this.aCommands);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterUndo(this.oUiComponent,this.oView,x);}.bind(this));});QUnit.test("When executing on XML, reverting the change in JS (e.g. variant switch) and applying again",function(x){return t.call(this,x).then(function(){return q(this.oView,this.aCommands,x);}.bind(this)).then(function(y){this.aRemainingCommands=y.remainingCommands;return u(this.aCommands);}.bind(this)).then(function(){r(this.aCommands);}.bind(this)).then(function(){return n(this.aRemainingCommands);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterRedo(this.oUiComponent,this.oView,x);}.bind(this));});});}function w(x){if(x.getStatus()!==b.SYNCED){return new Promise(function(R){x.attachEventOnce("synced",R);});}return Promise.resolve();}QUnit.module(m,{before:function(x){this.hookContext={};return o.before.call(this.hookContext,x);},after:function(x){return o.after.call(this.hookContext,x);},beforeEach:function(x){f.stub(c.prototype,"getChangesForComponent").returns(Promise.resolve([]));f.stub(c.prototype,"getCacheKey").returns(d.NOTAG);f.stub(S,"getInstance").returns(Promise.resolve({_oSettings:{}}));return j.call(this,h).then(k.bind(this,x)).then(function(y){this.aCommands=y;}.bind(this));},afterEach:function(){this.oDesignTime.destroy();this.oUiComponentContainer.destroy();p(this.aCommands);f.restore();}},function(){QUnit.test("When executing the underlying command on the control at runtime",function(x){return w(this.oDesignTime).then(function(){sap.ui.getCore().applyChanges();return o.afterAction(this.oUiComponent,this.oView,x);}.bind(this));});QUnit.test("When executing and undoing the command",function(x){return w(this.oDesignTime).then(u.bind(null,this.aCommands)).then(r.bind(null,this.aCommands)).then(function(){sap.ui.getCore().applyChanges();return o.afterUndo(this.oUiComponent,this.oView,x);}.bind(this));});QUnit.test("When executing, undoing and redoing the command",function(x){return w(this.oDesignTime).then(q.bind(this,this.oView,this.aCommands,x)).then(function(y){this.aRemainingCommands=y.remainingCommands;return u(this.aCommands);}.bind(this)).then(r.bind(null,this.aCommands)).then(function(){return n(this.aRemainingCommands);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();return o.afterRedo(this.oUiComponent,this.oView,x);}.bind(this));});});};
e.skip=function(){};
e.only=function(m){e._only=m;};
return e;});
sap.ui.predefine('sap/ui/rta/library',["sap/ui/core/Core","sap/ui/core/library","sap/m/library","sap/ui/fl/library","sap/ui/dt/library"],function(){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.rta",version:"1.84.0",dependencies:["sap.ui.core","sap.m","sap.ui.fl","sap.ui.dt"],types:[],interfaces:[],controls:[],elements:[]});return sap.ui.rta;});
sap.ui.predefine('sap/ui/rta/plugin/AddXMLAtExtensionPoint',["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/api/ExtensionPointRegistryAPI"],function(P,D,F,M,E){"use strict";
var A=P.extend("sap.ui.rta.plugin.AddXMLAtExtensionPoint",{metadata:{library:"sap.ui.rta",properties:{fragmentHandler:{type:"function"}},associations:{},events:{}}});
var a="addXMLAtExtensionPoint";var b="appdescr_ui5_setFlexExtensionPointEnabled";
function h(o){var f=o.getId();return E.getExtensionPointInfoByParentId({parentId:f}).length>0;}
function i(){return sap.ui.getCore().getConfiguration().getDesignMode();}
A.prototype.bAppDescriptorCommandAlreadyAvailable=false;
A.prototype._isEditable=function(o){if(i()){var f=o.getElement();return this.hasChangeHandler(a,f).then(function(H){return H&&h(f)&&this.hasStableId(o);}.bind(this));}return Promise.resolve(false);};
A.prototype.isEnabled=function(f){return f.length===1;};
function c(o,m,C){var s=m.extensionPointName;var v=F.getViewForControl(o);var f={name:s,view:v};var g={fragment:m.fragment,fragmentPath:m.fragmentPath};return this.getCommandFactory().getCommandFor(f,a,g).then(function(j){return C.addCommand(j);});}
function d(o,C){var f=M.isFlexExtensionPointHandlingEnabled(o);if(f||this.bAppDescriptorCommandAlreadyAvailable){return Promise.resolve();}var g=F.getAppComponentForControl(o);var r=g.getManifestEntry("sap.app").id;return this.getCommandFactory().getCommandFor(o,"appDescriptor",{reference:r,appComponent:g,changeType:b,parameters:{flexExtensionPointEnabled:true},texts:{}}).then(function(j){this.bAppDescriptorCommandAlreadyAvailable=true;return C.addCommand(j);}.bind(this));}
function e(f,m){var C;var o=f[0];var g=o.getElement();return this.getCommandFactory().getCommandFor(g,"composite").then(function(_){C=_;}).then(function(){return c.call(this,g,m,C);}.bind(this)).then(function(){return d.call(this,g,C);}.bind(this)).then(function(){return C;});}
A.prototype.handler=function(f,p){return Promise.resolve().then(function(){var g=p.fragmentHandler||this.getFragmentHandler();if(!g){return Promise.reject("Fragment handler function is not available in the handler");}var o=f[0];var j=o.getElement().getId();var k=E.getExtensionPointInfoByParentId({parentId:j});return g(o,k);}.bind(this)).then(function(m){if(!m.extensionPointName||!(typeof m.extensionPointName==="string")){return Promise.reject("Extension point name is not selected!");}if(!m.fragmentPath||!(typeof m.fragmentPath==="string")){return Promise.reject("Fragment path is not available");}return m;}).then(function(m){return e.call(this,f,m);}.bind(this)).then(function(C){this.fireElementModified({command:C});}.bind(this)).catch(function(v){throw D.propagateError(v,"AddXMLAtExtensionPoint#handler","Error occured in AddXMLAtExtensionPoint handler function","sap.ui.rta");});};
A.prototype.getMenuItems=function(f){return this._getMenuItems(f,{pluginId:"CTX_ADDXML_AT_EXTENSIONPOINT",rank:110,icon:"sap-icon://add-equipment"});};
A.prototype.getActionName=function(){return"AddXMLAtExtensionPoint";};
A.prototype.getAction=function(){return{changeType:a};};
return A;});
sap.ui.predefine('sap/ui/rta/plugin/BaseCreate',["sap/ui/rta/plugin/Plugin","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(P,F,R){"use strict";
var B=P.extend("sap.ui.rta.plugin.BaseCreate",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
B.prototype._isEditable=function(o){return Promise.all([this._isEditableCheck(o,true),this._isEditableCheck(o,false)]).then(function(p){return{asSibling:p[0],asChild:p[1]};});};
B.prototype._isEditableCheck=function(o,O){var p=this._getParentOverlay(O,o);var a;if(!p||!p.getParentElementOverlay()){return Promise.resolve(false);}if(O){a=o.getParentAggregationOverlay().getAggregationName();}return this.checkAggregationsOnSelf(p,this.getActionName(),a).then(function(e){if(e){var b=F.getViewForControl(p.getElement());return this.hasStableId(o)&&F.checkControlId(b);}return false;}.bind(this));};
B.prototype._getParentOverlay=function(s,o){var p;var r=this.getResponsibleElementOverlay(o);if(s){p=r.getParentElementOverlay();}else{p=r;}return p;};
B.prototype.getCreateActions=function(s,o){var r=this.getResponsibleElementOverlay(o);var p=this._getParentOverlay(s,r);var d=p.getDesignTimeMetadata();var a=d.getActionDataFromAggregations(this.getActionName(),r.getElement());if(s){var b=r.getParentAggregationOverlay().getAggregationName();return a.filter(function(A){return A.aggregation===b;});}return a;};
B.prototype.getCreateAction=function(s,o,a){var A=this.getCreateActions(s,o);if(a){var c;A.some(function(b){if(b.aggregation===a){c=b;return true;}});return c;}return A[0];};
B.prototype.isAvailable=function(s,e){return this._isEditableByPlugin(e[0],s);};
B.prototype.isActionEnabled=function(a,s,e){if(!a){return false;}if(a.isEnabled&&typeof a.isEnabled==="function"){var I=a.isEnabled;var p=this._getParentOverlay(s,e);return I(p.getElement());}return true;};
B.prototype.getCreatedContainerId=function(a,n){var I=n;if(a.getCreatedContainerId&&typeof a.getCreatedContainerId==="function"){var m=a.getCreatedContainerId;I=m(n);}return I;};
B.prototype._determineIndex=function(p,s,a,g){return R.getIndex(p,s,a,g);};
B.prototype._getText=function(a,e,d,t){if(!a){return t;}var A=d.getAggregationDescription(a.aggregation,e);if(!A){return t;}var c=A.singular;var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return T.getText(t,c);};
B.prototype.getActionName=function(){throw new Error("abstract");};
function i(){}
B.prototype.getMenuItems=function(e){i(e);throw new Error("abstract");};
B.prototype.handleCreate=function(s,o){i(s,o);throw new Error("abstract");};
return B;});
sap.ui.predefine('sap/ui/rta/plugin/Combine',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util"],function(P,U,D){"use strict";
var C=P.extend("sap.ui.rta.plugin.Combine",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype._isEditable=function(o){var c=this.getAction(o);if(!o.isRoot()&&c&&c.changeType&&c.changeOnRelevantContainer){var r=o.getRelevantContainer();return this.hasChangeHandler(c.changeType,r).then(function(h){return h&&this.hasStableId(o)&&this._checkRelevantContainerStableID(c,o);}.bind(this));}return false;};
C.prototype._checkForSameRelevantContainer=function(e){var r=[];for(var i=0,n=e.length;i<n;i++){r[i]=e[i].getRelevantContainer();var c=this.getAction(e[i]);if(!c||!c.changeType){return false;}if(i>0){if((r[0]!==r[i])||(this.getAction(e[0]).changeType!==c.changeType)){return false;}}}return true;};
C.prototype._checkBindingCompatibilityOfControls=function(c,m){return c.every(function(s){return c.every(function(t){return s!==t?U.checkSourceTargetBindingCompatibility(s,t,m):true;});});};
C.prototype.isAvailable=function(e){if(e.length<=1){return false;}return(e.every(function(E){return this._isEditableByPlugin(E);},this)&&this._checkForSameRelevantContainer(e));};
C.prototype.isEnabled=function(e){if(!this.isAvailable(e)||e.length<=1){return false;}var c=e.map(function(E){return E.getElement();});var a=e.every(function(E){var A=this.getAction(E);if(!A){return false;}if(typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){return A.isEnabled(c);}return A.isEnabled;}return true;},this);if(a){var d=c[0]&&c[0].getModel();return this._checkBindingCompatibilityOfControls(c,d);}return a;};
C.prototype.handleCombine=function(e,c){var o;var E=e.map(function(a){if(a.getElement().getId()===c.getId()){o=a;}return a.getElement();});var d=o.getDesignTimeMetadata();var v=this.getVariantManagementReference(o);return this.getCommandFactory().getCommandFor(c,"combine",{source:c,combineElements:E},d,v).then(function(a){this.fireElementModified({command:a});}.bind(this)).catch(function(m){throw D.createError("Combine#handleCombine",m,"sap.ui.rta");});};
C.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_GROUP_FIELDS",rank:90,icon:"sap-icon://combine"});};
C.prototype.getActionName=function(){return"combine";};
C.prototype.handler=function(e,p){this.handleCombine(e,p.contextElement);};
return C;});
sap.ui.predefine('sap/ui/rta/plugin/ControlVariant',["sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/ui/rta/Utils","sap/ui/dt/ElementOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/variants/VariantManagement","sap/ui/base/ManagedObject","sap/ui/rta/command/CompositeCommand","sap/base/Log"],function(P,R,U,E,O,a,D,f,L,V,M,C,b){"use strict";E.prototype._variantManagement=undefined;
E.prototype.getVariantManagement=function(){return this._variantManagement;};
E.prototype.setVariantManagement=function(k){this._variantManagement=k;};
E.prototype.hasVariantManagement=function(){return!!this._variantManagement;};
function d(o){var m=o.getElement().getManageDialog();if(m&&!m.bIsDestroyed){m.destroy();}}
var c=P.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string",variantManagementControlOverlay:{type:"any"}},associations:{},events:{}}});
c.prototype.registerElementOverlay=function(o){var e=o.getElement();var v;P.prototype.registerElementOverlay.apply(this,arguments);if(e instanceof V){var A=e.getFor();var g;var h=f.getAppComponentForControl(e);var s=e.getId();v=h.getLocalId(s)||s;o.setVariantManagement(v);if(!A||(Array.isArray(A)&&A.length===0)){return;}g=!Array.isArray(A)?[A]:A;g.forEach(function(i){var j=i instanceof M?i:sap.ui.getCore().byId(i);var k=O.getOverlay(j);this._propagateVariantManagement(k,v);}.bind(this));o.attachEvent("editableChange",R._manageClickEvent,this);d(o);}else if(!o.getVariantManagement()){v=this._getVariantManagementFromParent(o);if(v){o.setVariantManagement(v);o.attachEvent("editableChange",R._manageClickEvent,this);}}};
c.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer===L.USER;};
c.prototype._propagateVariantManagement=function(p,v){var e=[];p.setVariantManagement(v);e=a.getAllChildOverlays(p);e.forEach(function(o){e=e.concat(this._propagateVariantManagement(o,v));}.bind(this));return e;};
c.prototype._getVariantManagementFromParent=function(o){var v=o.getVariantManagement();if(!v&&o.getParentElementOverlay()){return this._getVariantManagementFromParent(o.getParentElementOverlay());}return v;};
c.prototype.deregisterElementOverlay=function(o){if(this._isVariantManagementControl(o)){d(o);}o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);this.removeFromPluginsList(o);P.prototype.deregisterElementOverlay.apply(this,arguments);};
c.prototype._getVariantModel=function(e){var A=f.getAppComponentForControl(e);return A?A.getModel(f.VARIANT_MODEL_NAME):undefined;};
c.prototype._isEditable=function(o){if(this._isPersonalizationMode()){return false;}return this._isVariantManagementControl(o)&&this.hasStableId(o);};
c.prototype._isVariantManagementControl=function(o){var e=o.getElement();var A=e.getAssociation("for");return!!(A&&e instanceof V);};
c.prototype.isVariantSwitchAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantSwitchEnabled=function(e){var o=e[0];var v=[];if(this._isVariantManagementControl(o)){var g=o.getElement();var s=o.getVariantManagement?o.getVariantManagement():undefined;if(!s){return false;}var m=this._getVariantModel(g);if(m){v=m.getData()[s].variants.reduce(function(r,i){if(i.visible){return r.concat(i);}return r;},[]);}var h=v.length>1;return h;}return false;};
c.prototype.setDesignTime=function(o){R._setDesignTime.call(this,o);};
c.prototype.isRenameAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isRenameEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.isVariantDuplicateAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantDuplicateEnabled=function(e){var o=e[0];var v=o.getVariantManagement?o.getVariantManagement():undefined;if(!v||!this._isVariantManagementControl(o)){return false;}return true;};
c.prototype.isVariantConfigureAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantConfigureEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.switchVariant=function(t,n,s){var o=t.getDesignTimeMetadata();var T=t.getElement();this.getCommandFactory().getCommandFor(T,"switch",{targetVariantReference:n,sourceVariantReference:s},o).then(function(S){this.fireElementModified({command:S});}.bind(this)).catch(function(m){throw D.createError("ControlVariant#switchVariant",m,"sap.ui.rta");});};
c.prototype.renameVariant=function(e){var o=e[0];this.setVariantManagementControlOverlay(o);this.startEdit(o);};
c.prototype.startEdit=function(v){var o=v.getElement();var e=v.getDesignTimeMetadata().getData().variantRenameDomRef;var g=o.getTitle();var p=g.getText();var h=R.startEdit.bind(this,{overlay:v,domRef:e,pluginMethodName:"plugin.ControlVariant.startEdit"});if(v._triggerDuplicate){var s=this._getVariantTitleForCopy(p,v.getVariantManagement(),this._getVariantModel(o).getData());o.getTitle().setText(s);if(v.hasStyleClass(R.errorStyleClass)){h();}else{v.attachEventOnce("geometryChanged",function(){h();},this);}}else{h();}};
c.prototype.stopEdit=function(r){if(this._oEditedOverlay._triggerDuplicate){if(!this._oEditedOverlay.hasStyleClass(R.errorStyleClass)){delete this._oEditedOverlay._triggerDuplicate;}}R._stopEdit.call(this,r,"plugin.ControlVariant.stopEdit");};
c.prototype._createDuplicateCommand=function(p){return this.getCommandFactory().getCommandFor(p.element,"duplicate",{sourceVariantReference:p.currentVariantReference,newVariantTitle:p.newVariantTitle},p.designTimeMetadata,p.variantManagementReference);};
c.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this);var o=this._oEditedOverlay;var e=o.getDesignTimeMetadata();var r=o.getElement();var m=this._getVariantModel(r);var s;var v=o.getVariantManagement();var T=this.getOldValue()!==t;var n=T||o._triggerDuplicate;var i=n?m._getVariantTitleCount(t,v):0;var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var h=m.getCurrentVariantReference(v);o.removeStyleClass(R.errorStyleClass);if(t==='\xa0'){s="BLANK_ERROR_TEXT";}else if(i>0){s="DUPLICATE_ERROR_TEXT";}else if(n){return this._createSetTitleCommand({text:t,element:r,designTimeMetadata:e,variantManagementReference:v}).then(function(S){if(o._triggerDuplicate){return this._createDuplicateCommand({currentVariantReference:h,designTimeMetadata:e,variantManagementReference:v,element:r,newVariantTitle:this.getOldValue()}).then(function(k){return new C({commands:[k]});}).then(function(k){return T?k.addCommand(S):k;});}return S;}.bind(this)).then(function(k){this.fireElementModified({command:k});}.bind(this)).catch(function(k){throw D.createError("ControlVariant#_emitLabelChangeEvent",k,"sap.ui.rta");});}else{b.info("Control Variant title unchanged");return Promise.resolve();}if(s){var j=g.getText(s);this._prepareOverlayForValueState(o,j);o.addStyleClass(R.errorStyleClass);return U.showMessageBox("error",s,{titleKey:"BLANK_DUPLICATE_TITLE_TEXT"}).then(function(){return function(){this.startEdit(o);}.bind(this);}.bind(this));}};
c.prototype._getVariantTitleForCopy=function(s,v,o){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var e=r.getText("VARIANT_COPY_SINGLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)");var g=r.getText("VARIANT_COPY_MULTIPLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)").replace("\\{1\\}","([0-9]+)");var h=new RegExp(e+"+");var i=new RegExp(g);var t;var I=g.lastIndexOf("(.*)")>g.lastIndexOf("([0-9]+)")?1:2;var j=(I===1)?2:1;var T=0;if(i.test(s)){t=i.exec(s)[j];}else{t=h.test(s)?h.exec(s)[1]:s;}var k=[];o[v].variants.forEach(function(l){if(l.visible){k=i.test(l.title)?i.exec(l.title):h.exec(l.title);if(!k){return;}if(k.length===3&&t===k[j]&&T<=parseInt(k[I])){T=k[I]?(parseInt(k[I])+1):T;}else if(k.length===2&&t===k[1]){T=T===0?1:T;}}});return T>0?r.getText("VARIANT_COPY_MULTIPLE_TEXT",[t,T]):r.getText("VARIANT_COPY_SINGLE_TEXT",[t]);};
c.prototype._createSetTitleCommand=function(p){this._$oEditableControlDomRef.text(p.text);return this.getCommandFactory().getCommandFor(p.element,"setTitle",{newText:p.text},p.designTimeMetadata,p.variantManagementReference).catch(function(m){b.error("Error during rename : ",m);});};
c.prototype._prepareOverlayForValueState=function(o,v){o.getValueState=function(){return"Error";};o.getValueStateText=function(){return v;};o.getDomRefForValueStateMessage=function(){return this.$();};};
c.prototype.configureVariants=function(e){var o=e[0];var v=o.getElement();var s=o.getVariantManagement();var m=this._getVariantModel(v);var g=o.getDesignTimeMetadata();m.manageVariants(v,s,this.getCommandFactory().getFlexSettings().layer,U.getRtaStyleClassName()).then(function(h){return this.getCommandFactory().getCommandFor(v,"configure",{control:v,changes:h},g,s);}.bind(this)).then(function(h){this.fireElementModified({command:h});}.bind(this)).catch(function(h){throw D.createError("ControlVariant#configureVariants",h,"sap.ui.rta");});};
c.prototype.getMenuItems=function(e){var o=e[0];var m=[];if(this.isRenameAvailable(o)){m.push({id:"CTX_VARIANT_SET_TITLE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_RENAME'),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:210,icon:"sap-icon://edit"});}if(this.isVariantDuplicateAvailable(o)){m.push({id:"CTX_VARIANT_DUPLICATE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_DUPLICATE'),handler:function(e){e[0]._triggerDuplicate=true;this.renameVariant(e);}.bind(this),enabled:this.isVariantDuplicateEnabled.bind(this),rank:220,icon:"sap-icon://duplicate"});}if(this.isVariantConfigureAvailable(o)){m.push({id:"CTX_VARIANT_MANAGE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_MANAGE'),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:230,icon:"sap-icon://action-settings"});}if(this.isVariantSwitchAvailable(o)){var g=this._getVariantModel(o.getElement());var s=o.getVariantManagement();var S=g.getData()[s].variants.reduce(function(r,v){if(v.visible){var h=g.getData()[s].currentVariant===v.key;var i={id:v.key,text:v.title,icon:h?"sap-icon://accept":"blank",enabled:!h};return r.concat(i);}return r;},[]);m.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SWITCH'),handler:function(e,p){var h=p.eventItem.data();var t=e[0];var n=h.key;var i=g.getData()[s].currentVariant;return this.switchVariant(t,n,i);}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:S,rank:240,icon:"sap-icon://switch-views"});}return m;};
return c;});
sap.ui.predefine('sap/ui/rta/plugin/CreateContainer',["sap/ui/rta/plugin/BaseCreate","sap/ui/fl/Utils","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/util/uid"],function(B,F,R,D,u){"use strict";
var C=B.extend("sap.ui.rta.plugin.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype.isEnabled=function(s,e){var E=e[0];var a=this.getCreateAction(s,E);return this.isActionEnabled(a,s,E);};
C.prototype.getCreateContainerText=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var d=p.getDesignTimeMetadata();var e=p.getElement();var t="CTX_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype._getContainerTitle=function(a,e,d){var t="TITLE_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype.handleCreate=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var P=p.getElement();var d=p.getDesignTimeMetadata();var v=F.getViewForControl(P);var S;if(s){S=o.getElement();}var n=v.createId(u());var g=d.getAggregation(a.aggregation).getIndex;var i=this._determineIndex(P,S,a.aggregation,g);var V=this.getVariantManagementReference(p);return this.getCommandFactory().getCommandFor(P,"createContainer",{newControlId:n,label:this._getContainerTitle(a,P,d),index:i,parentId:P.getId()},d,V).then(function(c){this.fireElementModified({command:c,action:a,newControlId:n});}.bind(this)).catch(function(m){throw D.createError("CreateContainer#handleCreate",m,"sap.ui.rta");});};
C.prototype.getMenuItems=function(e){var o=true;var p="CTX_CREATE_SIBLING_CONTAINER";var r=40;var m=[];for(var i=0;i<2;i++){if(this.isAvailable(o,e)){m.push({id:p,text:this.getCreateContainerText.bind(this,o),handler:this.handleCreate.bind(this,o,e[0]),enabled:this.isEnabled.bind(this,o),icon:"sap-icon://add-folder",rank:r});}o=false;p="CTX_CREATE_CHILD_CONTAINER";r=50;}return m;};
C.prototype.getActionName=function(){return"createContainer";};
return C;});
sap.ui.predefine('sap/ui/rta/plugin/CutPaste',["sap/ui/dt/plugin/CutPaste","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/Utils"],function(C,D,P,R,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.CutPaste",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration).then(function(e){if(e){return true;}return this._isPasteEditable(o);}.bind(this));};
a.prototype._isPasteEditable=function(o){var e=this.getElementMover();if(!this.hasStableId(o)){return Promise.resolve(false);}return e.isMoveAvailableOnRelevantContainer(o).then(function(m){if(!m){return false;}return U.doIfAllControlsAreAvailable([o],function(){return e.isMoveAvailableForChildren(o);});});};
a.prototype.isAvailable=function(e){return e.every(function(E){return E.getMovable();});};
a.prototype.registerElementOverlay=function(){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.paste=function(t){this._executePaste(t);D.waitForSynced(this.getDesignTime())().then(function(){return this.getElementMover().buildMoveCommand();}.bind(this)).then(function(m){this.fireElementModified({command:m});this.stopCutAndPaste();}.bind(this)).catch(function(m){throw D.createError("CutPaste#paste",m,"sap.ui.rta");});};
a.prototype.cut=function(o){return C.prototype.cut.apply(this,arguments).then(function(){o.setSelected(false);});};
a.prototype.getMenuItems=function(e){var m=[];var p=this.enhanceItemWithResponsibleElement({id:'CTX_PASTE',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_PASTE'),handler:function(e){return this.paste(e[0]);}.bind(this),enabled:function(e){return this.isElementPasteable(e[0]);}.bind(this),rank:80,icon:"sap-icon://paste"},e,["move"]);var r=p.responsible||e;if(this.isAvailable(r)){var c=this.enhanceItemWithResponsibleElement({id:'CTX_CUT',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_CUT'),handler:function(e){return this.cut(e[0]);}.bind(this),enabled:function(e){return e.length===1;},rank:70,icon:"sap-icon://scissors"},e,["move"]);m.push(c,p);return m;}return this._isPasteEditable(e[0]).then(function(b){if(b){m.push(p);}return m;});};
return a;});
sap.ui.predefine('sap/ui/rta/plugin/DragDrop',["sap/ui/dt/plugin/ControlDragDrop","sap/ui/dt/Util","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(C,D,R,P,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.DragDrop",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype.setCommandFactory=function(c){this.setProperty("commandFactory",c);this.getElementMover().setCommandFactory(c);};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration);};
a.prototype.registerElementOverlay=function(){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.onDragStart=function(o){this.fireDragStarted();C.prototype.onDragStart.apply(this,arguments);this.getSelectedOverlays().forEach(function(o){o.setSelected(false);});o.$().addClass("sapUiRtaOverlayPlaceholder");};
a.prototype.onDragEnd=function(o){this.getElementMover().buildMoveCommand().then(function(c){this.fireElementModified({command:c});o.$().removeClass("sapUiRtaOverlayPlaceholder");o.setSelected(true);o.focus();C.prototype.onDragEnd.apply(this,arguments);}.bind(this)).catch(function(e){throw D.propagateError(e,"DragDrop#onDragEnd","Error accured during onDragEnd execution","sap.ui.rta.plugin");});};
a.prototype.onMovableChange=function(){C.prototype.onMovableChange.apply(this,arguments);};
return a;});
sap.ui.predefine('sap/ui/rta/plugin/EasyAdd',["sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/dt/OverlayRegistry","sap/m/Button","sap/ui/thirdparty/jquery"],function(A,O,B,q){"use strict";
var E=A.extend("sap.ui.rta.plugin.EasyAdd",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAdd");c.addStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").addClass("sapUiRtaPaddingTop");}var a=function(d,o,i){var C;if(d){C=o.getDesignTimeMetadata().getName().plural;}else{C=o.getDesignTimeMetadata().getAggregation("sections").childNames.plural();}this.clearCachedElements();this.showAvailableElements(d,[o],i,C);}.bind(this);var f=function(o,d,S,C,i){var e=function(h){var o=O.getOverlay(h.currentTarget.id.replace("-AddButton",""));a(S,o,i);h.stopPropagation();};var g=typeof C==="function"?C():C;this._addButton(o,e,d,g,S);}.bind(this);if(o.hasStyleClass("sapUiRtaPersAdd")){var b=o.hasStyleClass("sapUiRtaPersAdd")&&o.$().children(".sapUiRtaPersAddIconOuter").length<=0;if(b){f(o,o.$(),true,o.getDesignTimeMetadata().getName().singular);}}else if(o.hasStyleClass("sapUiRtaPersAddTop")){if(o.getAggregationOverlay("sections").$().children(".sapUiRtaPersAddIconOuter").length<=0){var s=o.getAggregationOverlay("sections").$();f(o,s,false,o.getDesignTimeMetadata().getAggregation("sections").childNames.singular,0);}}A.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(o._oAddButton){o._oAddButton.destroy();}if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersAdd");c.removeStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"){o.removeStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").removeClass("sapUiRtaPaddingTop");}};
E.prototype._isEditable=function(o){return A.prototype._isEditable.apply(this,arguments).then(function(i){if(o._oAddButton){var I=o.hasStyleClass("sapUiRtaPersAddTop");var s=I?"asChild":"asSibling";o._oAddButton.setEnabled(i[s]);if(I){var l=o.getElement();l.attachEventOnce("onAfterRenderingDOMReady",function(){l.$("sectionsContainer").addClass("sapUiRtaPaddingTop");});}}return i;});};
E.prototype._addButton=function(o,c,a,C,b){var i=o.getEditableByPlugins().indexOf(this._retrievePluginName(b))>-1;var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var I=o.getId()+"-AddButton";var h=q("<div class='sapUiRtaPersAddIconOuter' draggable='true' tabindex='-1'> </div>");o._oAddButton=new B(I,{text:t.getText("CTX_ADD_ELEMENTS",C),icon:"sap-icon://add",enabled:i}).placeAt(h.get(0)).attachBrowserEvent('click',c).attachBrowserEvent('tap',c);a.append(h);h[0].addEventListener("mouseover",function(e){e.stopPropagation();var o=e.fromElement?O.getOverlay(e.fromElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();p.removeStyleClass("sapUiRtaOverlayHover");}});h[0].addEventListener("mouseleave",function(e){e.stopPropagation();var o=e.toElement?O.getOverlay(e.toElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();if(p.getMovable()){p.addStyleClass("sapUiRtaOverlayHover");}}});h[0].addEventListener("click",function(e){e.stopPropagation();});h[0].addEventListener("contextmenu",function(e){e.stopPropagation();e.preventDefault();});h[0].addEventListener("dragstart",function(e){e.stopPropagation();e.preventDefault();});};
return E;});
sap.ui.predefine('sap/ui/rta/plugin/EasyRemove',["sap/ui/rta/plugin/Remove","sap/m/Button","sap/ui/thirdparty/jquery"],function(R,B,q){"use strict";
var E=R.extend("sap.ui.rta.plugin.EasyRemove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersDelete");}if(o.hasStyleClass("sapUiRtaPersDelete")&&o.$().children(".sapUiRtaPersDeleteClick").length<=0){var a=function(o){this.handler([o]);}.bind(this);var d=this._addButton(o);d.attachBrowserEvent("contextmenu",function(e){e.stopPropagation();e.preventDefault();});var O=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id.replace("-DeleteIcon",""));a(o);e.stopPropagation();e.preventDefault();};d.attachBrowserEvent("click",O).attachBrowserEvent("tap",O);}R.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype._isEditable=function(o){if(o._oDeleteButton){o._oDeleteButton.setEnabled(this.isEnabled([o]));}return R.prototype._isEditable.apply(this,arguments);};
E.prototype._addButton=function(o){var e=this.isEnabled([o]);var i=o.getId()+"-DeleteIcon";var h=q("<div class='sapUiRtaPersDeleteClick' draggable='true'> </div>");var H=q("<div class='sapUiRtaPersDeleteIconOuter'> </div>");o._oDeleteButton=new B(i,{icon:"sap-icon://less",tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_REMOVE"),enabled:e}).placeAt(H.get(0));h.append(H);o.$().append(h);h[0].addEventListener("dragstart",function(a){a.stopPropagation();a.preventDefault();});return o._oDeleteButton;};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersDelete");if(o._oDeleteButton){o._oDeleteButton.destroy();}}};
return E;});
sap.ui.predefine('sap/ui/rta/plugin/Plugin',["sap/ui/dt/Plugin","sap/ui/fl/registry/ChangeRegistry","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/fl/changeHandler/JsControlTreeModifier","sap/ui/rta/util/hasStableId"],function(P,C,O,a,J,h){"use strict";
function _(p,c,s){var r=s;if(typeof this.getActionName()==="string"){if(this.isResponsibleElementActionAvailable(s)){r=this.getResponsibleElementOverlay(s);}}var e=r.getElement()&&r.getDesignTimeMetadata()&&!r.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(r,Object.assign({sourceElementOverlay:s},p));if(e&&typeof e.then==="function"){e.then(function(E){this._handleModifyPluginList(s,E);}.bind(this));c.push(e);}else{this._handleModifyPluginList(s,e);}return c;}
var B=P.extend("sap.ui.rta.plugin.Plugin",{metadata:{"abstract":true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
B.prototype._isEditable=function(){};
B.prototype.executeWhenVisible=function(e,c){var g=function(E){if(E.getSource().getGeometry()&&E.getSource().getGeometry().visible){e.detachEvent("geometryChanged",g,this);c();}};var o=e.getGeometry();if(e.getElementVisibility()&&(!o||!o.visible)){e.attachEvent("geometryChanged",g,this);}else{c();}};
var b=function(e){var p=e.getParameters();var r;var o=e.getSource();if(p.type==="propertyChanged"&&p.name==="visible"){r=this._getRelevantOverlays(o);if(p.value===true){this.executeWhenVisible(o,function(){this.evaluateEditable(r,{onRegistration:false});}.bind(this));}else{this.evaluateEditable(r,{onRegistration:false});}}else if(p.type==="afterRendering"){if(this.getDesignTime().getStatus()==="synced"){this.evaluateEditable([o],{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([o],{onRegistration:false});},this);}}else if(p.type==="insertAggregation"||p.type==="removeAggregation"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else if(p.type==="addOrSetAggregation"){if(this.getDesignTime().getStatus()==="synced"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});},this);}}};
B.prototype._getRelevantOverlays=function(o,A){var c=o.getRelevantOverlays();if(c.length===0){var r=a.findAllOverlaysInContainer(o);if(A){var d=o.getAggregationOverlay(A);var e=d?d.getChildren():[];e=e.filter(function(f){return r.indexOf(f)===-1;});r=r.concat(e);}o.setRelevantOverlays(r);return r;}return c;};
B.prototype.evaluateEditable=function(o,p){if(!p.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return;}this.setProcessingStatus(true);var c=o.reduce(_.bind(this,p),[]);if(c.length){Promise.all(c).then(function(){this.setProcessingStatus(false);}.bind(this)).catch(function(){this.setProcessingStatus(false);}.bind(this));}else{this.setProcessingStatus(false);}};
B.prototype._handleModifyPluginList=function(o,e){if(e!==undefined&&e!==null){if(typeof e==="boolean"){this._modifyPluginList(o,e);}else{this._modifyPluginList(o,e.asChild,false);this._modifyPluginList(o,e.asSibling,true);}}};
B.prototype._modifyPluginList=function(o,i,c){if(i){this.addToPluginsList(o,c);}else{this.removeFromPluginsList(o,c);}};
B.prototype._retrievePluginName=function(s){var n=this.getMetadata().getName();if(s!==undefined){n+=s?".asSibling":".asChild";}return n;};
B.prototype._isEditableByPlugin=function(o,s){var p=this._retrievePluginName(s);var c=o.getEditableByPlugins();return c.indexOf(p)>-1;};
B.prototype.registerElementOverlay=function(o){this.executeWhenVisible(o,function(){this.evaluateEditable([o],{onRegistration:true});o.attachElementModified(b,this);}.bind(this));};
B.prototype.deregisterElementOverlay=function(o){this.removeFromPluginsList(o);this.removeFromPluginsList(o,true);this.removeFromPluginsList(o,false);o.detachElementModified(b,this);};
B.prototype.hasStableId=function(o){return h(o);};
B.prototype.getVariantManagementReference=function(o){var v;if(o.getVariantManagement){v=o.getVariantManagement();}return v;};
B.prototype.checkAggregationsOnSelf=function(o,A,p,s){var d=o.getDesignTimeMetadata();var e=o.getElement();var c=d.getActionDataFromAggregations(A,e,undefined,s);var f=c.filter(function(j){if(j&&p){return j.aggregation===p;}return true;})[0];var g=f?f.changeType:null;var i=f&&f.changeOnRelevantContainer;if(i){e=o.getRelevantContainer();var r=O.getOverlay(e);if(!this.hasStableId(r)){return Promise.resolve(false);}}if(g){return this.hasChangeHandler(g,e);}return Promise.resolve(false);};
B.prototype.removeFromPluginsList=function(o,s){var n=this._retrievePluginName(s);o.removeEditableByPlugin(n);if(!o.getEditableByPlugins().length){o.setEditable(false);}};
B.prototype.addToPluginsList=function(o,s){var n=this._retrievePluginName(s);var p=o.getEditableByPlugins();if(p.indexOf(n)===-1){o.addEditableByPlugin(n);o.setEditable(true);}};
B.prototype.hasChangeHandler=function(c,e,s){s=s||e.getMetadata().getName();var l=this.getCommandFactory().getFlexSettings().layer;return C.getInstance().getChangeHandler(c,s,e,J,l).then(function(){return true;}).catch(function(){return false;});};
B.prototype.isAvailable=function(e){return e.every(function(E){return this._isEditableByPlugin(E);},this);};
B.prototype._checkRelevantContainerStableID=function(A,e){if(A.changeOnRelevantContainer){var r=e.getRelevantContainer();var R=O.getOverlay(r);if(!this.hasStableId(R)){return false;}}return true;};
return B;});
sap.ui.predefine('sap/ui/rta/plugin/RTAElementMover',["sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/rta/Utils","sap/ui/rta/command/CommandFactory","sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry","sap/ui/dt/MetadataPropagationUtil"],function(E,O,U,C,P,a,M){"use strict";
var R=E.extend("sap.ui.rta.plugin.RTAElementMover",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"any",defaultValue:C},movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{}}});
R.prototype.init=function(){this.oBasePlugin=new P({commandFactory:this.getCommandFactory()});};
R.prototype.exit=function(){this.oBasePlugin.destroy();};
R.prototype.setCommandFactory=function(o){this.setProperty("commandFactory",o);this.oBasePlugin.setCommandFactory(o);};
R.prototype.isEditable=function(o,b){var e=o.getElement();if(!this.isMovableType(e)){return Promise.resolve(false);}return this.checkMovable(o,b).then(function(m){o.setMovable(m);return m;});};
function i(o,b){var d=o.getDesignTimeMetadata();var p=o.getParentElementOverlay();var n=d.markedAsNotAdaptable();if(!d||!p||n){return Promise.resolve(false);}var r=o.getRelevantContainer();var e=a.getOverlay(r);if(!e){return Promise.resolve(false);}return this.isMoveAvailableOnRelevantContainer(o).then(function(v){if(v){v=this.oBasePlugin.hasStableId(o)&&this.oBasePlugin.hasStableId(p)&&this.oBasePlugin.hasStableId(e);}return v;}.bind(this)).then(function(v){if(v){return c.call(this,o,e,b);}return v;}.bind(this));}
function c(o,r,b){var d=O.findAllUniqueAggregationOverlaysInContainer(o,r);var v=d.map(function(A){return this.checkTargetZone(A,o,b).then(function(V){return V?A:undefined;});}.bind(this));return Promise.all(v).then(function(V){V=V.filter(function(f){return!!f;});if(V.length<1){return false;}else if(V.length===1){var e=V[0].getChildren().filter(function(f){var g=f.getElement();return(g&&g.getVisible()&&g.getParent());});return e.length>1;}return true;});}
function h(A,e,r){var o=A.getDesignTimeMetadata();var m=o.getAction("move",e);if(!m){return Promise.resolve(false);}return this.oBasePlugin.hasChangeHandler(m.changeType,r);}
E.prototype._getMoveAction=function(o){var p;var b=o.getParentAggregationOverlay();if(b){p=b.getDesignTimeMetadata();}return p?p.getAction("move",o.getElement()):undefined;};
E.prototype.isMovableType=function(){return true;};
R.prototype.checkMovable=function(o,b){return i.call(this,o,b);};
R.prototype.checkTargetZone=function(A,o,b){var m=o||this.getMovedOverlay();return E.prototype.checkTargetZone.call(this,A,m,b).then(function(t){if(!t){return false;}var d=m.getElement();var T=A.getParent();var e=m.getRelevantContainer();if(!d||!T){return false;}var f=T.getElement();var g=A.getDesignTimeMetadata();var v=M.getRelevantContainerForPropagation(g.getData(),d);v=v||f;if(!e||!v||!this.oBasePlugin.hasStableId(T)||e!==v){return false;}if(m.getParent().getElement()!==f){if(!U.checkSourceTargetBindingCompatibility(d,f)){return false;}}return h.call(this,A,d,v);}.bind(this));};
R.prototype.isMoveAvailableOnRelevantContainer=function(o){var b;var m=this._getMoveAction(o);if(m&&m.changeType){b=o.getRelevantContainer();var r=a.getOverlay(b);if(!this.oBasePlugin.hasStableId(r)){return Promise.resolve(false);}return this.oBasePlugin.hasChangeHandler(m.changeType,b);}return Promise.resolve(false);};
R.prototype.isMoveAvailableForChildren=function(o){var d=o.getDesignTimeMetadata();var A=d.getAggregationNamesWithAction("move");var b=[];A.forEach(function(e){var f=o.getAggregationOverlay(e);if(f){var g=f.getChildren();var j=g.map(this.checkMovable.bind(this));b=b.concat(j);}else{b.push(Promise.resolve(false));}}.bind(this));return Promise.all(b).then(function(m){return m.some(function(e){return e;});});};
R.prototype.buildMoveCommand=function(){var m=this.getMovedOverlay();var p=m.getParentAggregationOverlay();var o=m.getElement();var s=this._getSource();var r=m.getRelevantContainer();var t=O.getParentInformation(m);var S=s.index;var T=t.index;var b=this._compareSourceAndTarget(s,t);if(b){return Promise.resolve();}delete s.index;delete t.index;var v=this.oBasePlugin.getVariantManagementReference(m);return this.getCommandFactory().getCommandFor(r,"Move",{movedElements:[{element:o,sourceIndex:S,targetIndex:T}],source:s,target:t},p.getDesignTimeMetadata(),v);};
return R;});
sap.ui.predefine('sap/ui/rta/plugin/Remove',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/rta/command/CompositeCommand","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/base/Log"],function(P,U,C,O,K,L){"use strict";
var R=P.extend("sap.ui.rta.plugin.Remove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
R.prototype.registerElementOverlay=function(o){if(this.isEnabled([o])){o.attachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.registerElementOverlay.apply(this,arguments);};
R.prototype._isEditable=function(e){var E=e.getElement();var r=this.getAction(e);if(r&&r.changeType){if(r.changeOnRelevantContainer){E=e.getRelevantContainer();}return this.hasChangeHandler(r.changeType,E).then(function(h){return h&&this._checkRelevantContainerStableID(r,e)&&this.hasStableId(e);}.bind(this));}return false;};
R.prototype.isEnabled=function(e){var r=e.map(function(E){return this.getResponsibleElementOverlay(E);}.bind(this));var E=r[0];var a=this.getAction(E);var i=false;if(!a){return i;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){i=a.isEnabled(E.getElement());}else{i=a.isEnabled;}}else{i=true;}return i&&this._canBeRemovedFromAggregation(r);};
R.prototype._canBeRemovedFromAggregation=function(e){var o=e[0];var E=o.getElement();var p=E.getParent();if(!p){return false;}var a=p.getAggregation(E.sParentAggregationName);if(!Array.isArray(a)){return true;}if(a.length===1){return false;}var n=e.length;var i=a.filter(function(E){var b=O.getOverlay(E);return!(b&&b.getElementVisibility());});return!(i.length===(a.length-n));};
R.prototype._getConfirmationText=function(o){var a=this.getAction(o);if(a&&a.getConfirmationText){return a.getConfirmationText(o.getElement());}};
R.prototype.deregisterElementOverlay=function(o){if(this.isEnabled([o])){o.detachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.deregisterElementOverlay.apply(this,arguments);};
R.prototype._onKeyDown=function(e){if(e.keyCode===K.DELETE){e.stopPropagation();this.removeElement();}};
R.prototype.removeElement=function(e){var t=e||this.getSelectedOverlays();t=t.filter(function(E){return this.isEnabled([E]);},this);if(t.length>0){this.handler(t);}};
R.prototype._getRemoveCommand=function(r,d,v){return this.getCommandFactory().getCommandFor(r,"Remove",{removedElement:r},d,v);};
R.prototype._fireElementModified=function(c){if(c.getCommands().length){this.fireElementModified({command:c});}};
R.prototype.handler=function(e){var p=[];var c=new C();function s(o){o.setSelected(true);setTimeout(function(){o.focus();},0);}var n=R._getElementToFocus(e);e.forEach(function(o){var r=this.getResponsibleElementOverlay(o);var a=r.getElement();var d=r.getDesignTimeMetadata();var v=this.getVariantManagementReference(r);var b=this._getConfirmationText(r);p.push(Promise.resolve().then(function(){if(b){return U.openRemoveConfirmationDialog(a,b);}return true;}).then(function(f){if(!f){throw Error("Cancelled");}return this._getRemoveCommand(a,d,v);}.bind(this)).then(function(f){c.addCommand(f);}).catch(function(E){if(E&&E.message==="Cancelled"){if(e.length===1){n=o;}}else{throw E;}}));o.setSelected(false);},this);if(p.length){return Promise.all(p).then(function(){s(n);this._fireElementModified(c);}.bind(this)).catch(function(E){L.error("Error during remove: ",E);});}};
R._getElementToFocus=function(s){var n;if(s.length===1){var o=s[0];var S=o.getParent().getAggregation(o.sParentAggregationName);if(S.length>1){var i=S.indexOf(o);var c=S.slice(i+1);if(i!==0){c=c.concat(S.slice(0,i).reverse());}n=c.filter(function(a){return a.getElement().getVisible();}).shift();}}if(!n){n=O.getOverlay(s[0].getRelevantContainer());}return n;};
R.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_REMOVE",rank:60,icon:"sap-icon://less"});};
R.prototype.getActionName=function(){return"remove";};
return R;});
sap.ui.predefine('sap/ui/rta/plugin/Rename',["sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/base/Log"],function(P,R,L){"use strict";
var a=P.extend("sap.ui.rta.plugin.Rename",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{editable:{},nonEditable:{}}}});
a.prototype.exit=function(){P.prototype.exit.apply(this,arguments);this.setBusy(false);R._exit.call(this);};
a.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};
a.prototype.startEdit=function(o){var e=o.getElement();var d=o.getDesignTimeMetadata();var D=d.getAction("rename",e).domRef;R.startEdit.call(this,{overlay:o,domRef:D,pluginMethodName:"plugin.Rename.startEdit"});};
a.prototype.stopEdit=function(r){R._stopEdit.call(this,r,"plugin.Rename.stopEdit");};
a.prototype.handler=function(e){e=this.getSelectedOverlays()||e;this.startEdit(e[0]);};
a.prototype.isRenameAvailable=function(o){return this._isEditableByPlugin(o);};
a.prototype.isRenameEnabled=function(o){return this.isEnabled(o);};
a.prototype.isEnabled=function(e){if(e.length>1){return false;}var t=e[0];var r=this.getResponsibleElementOverlay(t);var i=true;if(!this.getAction(r)){i=false;}var T=this.getAction(t);if(i&&typeof T.isEnabled!=="undefined"){if(typeof T.isEnabled==="function"){i=T.isEnabled(t.getElement());}else{i=T.isEnabled;}}if(i){var d=t.getDesignTimeMetadata();if(!d.getAssociatedDomRef(t.getElement(),T.domRef)){i=false;}}return i;};
a.prototype.registerElementOverlay=function(o){o.attachEvent("editableChange",R._manageClickEvent,this);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype._isEditable=function(o){var e=o.getElement();var r=this.getAction(o);if(r&&r.changeType){if(r.changeOnRelevantContainer){e=o.getRelevantContainer();}return this.hasChangeHandler(r.changeType,e).then(function(h){return h&&this._checkRelevantContainerStableID(r,o)&&this.hasStableId(o);}.bind(this));}return false;};
a.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);this.removeFromPluginsList(o);};
a.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this);if(this.getOldValue()!==t){this._$oEditableControlDomRef.text(t);return Promise.resolve(this._oEditedOverlay).then(function(e){var r=this.getResponsibleElementOverlay(e);var o=r.getElement();var d=r.getDesignTimeMetadata();var v=this.getVariantManagementReference(r);return this.getCommandFactory().getCommandFor(o,"rename",{renamedElement:o,newValue:t},d,v);}.bind(this)).then(function(r){this.fireElementModified({command:r});}.bind(this)).catch(function(e){L.error("Error during rename : ",e);});}return Promise.resolve();};
a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_RENAME",rank:10,icon:"sap-icon://edit"});};
a.prototype.getActionName=function(){return"rename";};
return a;});
sap.ui.predefine('sap/ui/rta/plugin/RenameHandler',["sap/ui/base/BindingParser","sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/rta/plugin/Plugin","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/rta/Utils","sap/ui/dt/DOMUtil","sap/ui/events/KeyCodes"],function(B,q,D,P,O,E,a,U,b,K){"use strict";var e="\xa0";
function c(n){var o;var d;try{o=B.complexParser(n,undefined,true);}catch(f){d=true;}if(o&&typeof o==="object"||d){throw Error(sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("RENAME_BINDING_ERROR_TEXT"));}}
var R={errorStyleClass:"sapUiRtaErrorBg",validators:{noEmptyText:{validatorFunction:function(n){return n!==e;},errorMessage:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("RENAME_EMPTY_ERROR_TEXT")}},_manageClickEvent:function(v){var o=v.getSource?v.getSource():v;if(o.isSelected()&&this.isRenameAvailable(o)&&this.isRenameEnabled([o])){o.attachBrowserEvent("click",R._onClick,this);}else{o.detachBrowserEvent("click",R._onClick,this);}},startEdit:function(p){this.setBusy(true);this._oEditedOverlay=p.overlay;var o=p.overlay.getElement();var d=this._oEditedOverlay.getDesignTimeMetadata();var v=d.getAssociatedDomRef(o,p.domRef);if(!U.isElementInViewport(v)){v.get(0).scrollIntoView();}this._$oEditableControlDomRef=q(v);var w=0;var f=a.getOverlay(v instanceof q?v.get(0).id:v.id);if(!f){f=this._oEditedOverlay;var _=q(E.getDomRef(o));var g=this._$oEditableControlDomRef.parent();var C=parseInt(_.outerWidth());if(!isNaN(C)){var i=parseInt(this._$oEditableControlDomRef.outerWidth());var h=parseInt(g.outerWidth());w=C-i;if(w<0&&h){if(g.get(0).id!==_.get(0).id&&g.children(":visible").length===1&&g.children(":visible").get(0).id===this._$oEditableControlDomRef.get(0).id&&C>h){w=C-h;}else{w=0;}}}}var j=q("<div class='sapUiRtaEditableField'></div>").css({"white-space":"nowrap",overflow:"hidden",width:"calc(100% - ("+w+"px))"}).appendTo(f.$());this._$editableField=q("<div contentEditable='true'></div>").appendTo(j);if(this._$oEditableControlDomRef.text()===""){this._$oEditableControlDomRef.text("_?_");this._$editableField.text("");}else{this._$editableField.text(this._$oEditableControlDomRef.text());}this.setOldValue(R._getCurrentEditableFieldText.call(this));b.copyComputedStyle(this._$oEditableControlDomRef,this._$editableField);this._$editableField.children().remove();this._$editableField.css("visibility","hidden");this._$editableField.css({"-moz-user-modify":"read-write","-webkit-user-modify":"read-write","-ms-user-modify":"read-write","user-modify":"read-write","text-overflow":"clip","white-space":"nowrap"});if(D.browser.name==="ed"&&o.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){this._$editableField.css({"line-height":"normal"});}O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$editableField.one("focus",R._onEditableFieldFocus.bind(this));this._$editableField.on("blur",R._onEditableFieldBlur.bind(this));this._$editableField.on("keydown",R._onEditableFieldKeydown.bind(this));this._$editableField.on("dragstart",R._stopPropagation.bind(this));this._$editableField.on("drag",R._stopPropagation.bind(this));this._$editableField.on("dragend",R._stopPropagation.bind(this));this._$editableField.on("click",R._stopPropagation.bind(this));this._$editableField.on("mousedown",R._stopPropagation.bind(this));this._$oEditableControlDomRef.css("visibility","hidden");j.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({top:this._$oEditableControlDomRef.offset().top});this._$editableField.css("visibility","");this._$editableField.trigger("focus");p.overlay.setSelected(true);sap.ui.getCore().getEventBus().publish("sap.ui.rta",p.pluginMethodName,{overlay:p.overlay,editableField:this._$editableField});},_setDesignTime:function(d){this._aSelection=[];var o=this.getDesignTime();if(o){o.getSelectionManager().detachChange(R._onDesignTimeSelectionChange,this);}P.prototype.setDesignTime.apply(this,arguments);if(d){d.getSelectionManager().attachChange(R._onDesignTimeSelectionChange,this);this._aSelection=this.getSelectedOverlays();}},_onDesignTimeSelectionChange:function(o){var s=o.getParameter("selection");this._aSelection.forEach(R._manageClickEvent,this);s.forEach(R._manageClickEvent,this);this._aSelection=s;},_stopPropagation:function(o){o.stopPropagation();},_preventDefault:function(o){o.preventDefault();},_onEditableFieldFocus:function(o){var d=o.target;var r=document.createRange();r.selectNodeContents(d);var s=window.getSelection();s.removeAllRanges();s.addRange(r);},_stopEdit:function(r,p){var o;this.setBusy(false);if(this._$oEditableControlDomRef.text()==="_?_"){this._$oEditableControlDomRef.text("");}this._oEditedOverlay.$().find(".sapUiRtaEditableField").remove();O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$oEditableControlDomRef.css("visibility","visible");if(r){o=this._oEditedOverlay;o.setSelected(true);o.focus();}delete this._$editableField;delete this._$oEditableControlDomRef;delete this._oEditedOverlay;delete this._bBlurOrKeyDownStarted;sap.ui.getCore().getEventBus().publish("sap.ui.rta",p,{overlay:o});},_onEditableFieldBlur:function(){return R._handlePostRename.call(this,false);},_handlePostRename:function(r,o){if(!this._bBlurOrKeyDownStarted){this._oEditedOverlay.removeStyleClass(R.errorStyleClass);this._bBlurOrKeyDownStarted=true;if(o){R._preventDefault.call(this,o);R._stopPropagation.call(this,o);}return Promise.resolve().then(R._validateNewText.bind(this)).then(this._emitLabelChangeEvent.bind(this)).then(function(f){this.stopEdit(r);if(typeof f==="function"){f();}}.bind(this)).catch(function(d){return R._handleInvalidRename.call(this,d.message,r);}.bind(this));}return Promise.resolve();},_handleInvalidRename:function(s,r){return U.showMessageBox("error",s,{titleKey:"RENAME_ERROR_TITLE"}).then(function(){var o=this._oEditedOverlay;o.addStyleClass(R.errorStyleClass);this.stopEdit(r);this.startEdit(o);}.bind(this));},_validateNewText:function(){var s;var n=R._getCurrentEditableFieldText.call(this);c(n);var r=this.getResponsibleElementOverlay(this._oEditedOverlay);var o=this.getAction(r);var v=o&&o.validators||[];v.some(function(V){var d;if(typeof V==="string"&&R.validators[V]){d=R.validators[V];}else{d=V;}if(!d.validatorFunction(n)){s=d.errorMessage;return true;}});if(s){throw Error(s);}},_onEditableFieldKeydown:function(o){switch(o.keyCode){case K.ENTER:return R._handlePostRename.call(this,true,o);case K.ESCAPE:this._oEditedOverlay.removeStyleClass(R.errorStyleClass);this.stopEdit(true);R._preventDefault.call(this,o);break;case K.DELETE:R._stopPropagation.call(this,o);break;default:}return Promise.resolve();},_getCurrentEditableFieldText:function(){var t=this._$editableField.text().trim();return t===""?e:t;},_onClick:function(o){var d=sap.ui.getCore().byId(o.currentTarget.id);if(this.isRenameEnabled([d])&&!o.metaKey&&!o.ctrlKey){this.startEdit(d);R._preventDefault.call(this,o);}},_exit:function(){if(this._$oEditableControlDomRef){this.stopEdit(false);}}};return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Selection',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/ui/dt/Overlay","sap/base/util/restricted/_intersection","sap/ui/Device"],function(P,U,O,K,a,_,D){"use strict";
var S=P.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});
S.prototype.init=function(){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);P.prototype.init.apply(this,arguments);};
S.prototype._checkDeveloperMode=function(o,f){if(f){var g=this.getCommandFactory().getFlexSettings().developerMode;if(g&&this.hasStableId(o)){o.setEditable(true);o.setSelectable(true);this.fireElementEditableChange({editable:true});return true;}}return false;};
S.prototype.registerElementOverlay=function(o){var f=o.getDesignTimeMetadata();if(!f.markedAsNotAdaptable()&&!this._checkDeveloperMode(o,f)){o.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(o);}o.attachBrowserEvent("click",this._selectOverlay,this);o.attachBrowserEvent("contextmenu",this._selectOverlay,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("mousedown",this._onMouseDown,this);o.attachBrowserEvent("mouseover",this._onMouseover,this);o.attachBrowserEvent("mouseleave",this._onMouseleave,this);};
S.prototype._onEditableChange=function(E){var o=E.getSource();this._adaptSelectable(o);};
S.prototype._adaptSelectable=function(o){var s=o.getEditable();if(o.getSelectable()!==s){o.setSelectable(s);if(!s){this._removePreviousHover();}this.fireElementEditableChange({editable:s});}};
S.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._selectOverlay,this);o.detachBrowserEvent("contextmenu",this._selectOverlay,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("mousedown",this._onMouseDown,this);o.detachBrowserEvent("mouseover",this._onMouseover,this);o.detachBrowserEvent("mouseleave",this._onMouseleave,this);o.detachEditableChange(this._onEditableChange,this);};
S.prototype._setFocusOnOverlay=function(o,E){if(o&&o.getSelectable()){o.focus();E.stopPropagation();}};
S.prototype._onKeyDown=function(E){var o=U.getFocusedOverlay();if(E.keyCode===K.ENTER){this._selectOverlay(E);}else if(E.keyCode===K.ARROW_UP&&E.shiftKey===false&&E.altKey===false){if(o){var p=U.getFocusableParentOverlay(o);this._setFocusOnOverlay(p,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_DOWN&&E.shiftKey===false&&E.altKey===false){if(o){var f=U.getFirstFocusableDescendantOverlay(o);this._setFocusOnOverlay(f,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_LEFT&&E.shiftKey===false&&E.altKey===false){if(o){var g=U.getPreviousFocusableSiblingOverlay(o);this._setFocusOnOverlay(g,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_RIGHT&&E.shiftKey===false&&E.altKey===false){if(o){var n=U.getNextFocusableSiblingOverlay(o);this._setFocusOnOverlay(n,E);E.preventDefault();}}else if(E.keyCode===K.ESCAPE){if(o){this._deselectOverlays();}}};
S.prototype._deselectOverlays=function(){this.getDesignTime().getSelectionManager().reset();};
S.prototype._selectOverlay=function(E){var o=O.getOverlay(E.currentTarget.id);var m=E.metaKey||E.ctrlKey;var C=E.type==="contextmenu";if(o&&o.getSelectable()){if(o.isSelected()){if(!C){this.getDesignTime().getSelectionManager().remove(o);}}else if(m){this.getDesignTime().getSelectionManager().add(o);}else{this.getDesignTime().getSelectionManager().set(o);}E.preventDefault();E.stopPropagation();}};
S.prototype._onMouseDown=function(E){if(D.browser.name==="ie"){var t=O.getOverlay(E.target.id);var T=jQuery(E.target).hasClass("sapUiDtOverlayScrollContainer");var o=O.getOverlay(E.currentTarget.id);if(o&&(T||t instanceof a)){if(o.getSelectable()){o.focus();E.stopPropagation();}else{o.getDomRef().blur();}}}};
S.prototype._onMouseover=function(E){var o=O.getOverlay(E.currentTarget.id);if(o.isSelectable()){if(o!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=o;o.addStyleClass("sapUiRtaOverlayHover");}E.preventDefault();E.stopPropagation();}};
S.prototype._onMouseleave=function(E){var o=O.getOverlay(E.currentTarget.id);if(o.isSelectable()){this._removePreviousHover();E.preventDefault();E.stopPropagation();}};
S.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover");}delete this._oHoverTarget;};
S.prototype.setDesignTime=function(){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator);}P.prototype.setDesignTime.apply(this,arguments);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator);}};
S.prototype._multiSelectionValidator=function(E){return(E.length===1||(b(E,this.getMultiSelectionRequiredPlugins())&&c(E)&&(d(E)||e(E))));};
function b(E,m){var s=m.slice();E.forEach(function(o){s=_(s,o.getEditableByPlugins());});return s.length>0;}
function c(E){return E.every(function(o){return o.getRelevantContainer()===E[0].getRelevantContainer();});}
function d(E){return E.every(function(o){return o.getParentElementOverlay()===E[0].getParentElementOverlay();});}
function e(E){return E.every(function(o){return o.getElement().getMetadata().getName()===E[0].getElement().getMetadata().getName();});}
return S;});
sap.ui.predefine('sap/ui/rta/plugin/Settings',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/Log"],function(P,U,D,B){"use strict";
var S=P.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",properties:{commandStack:{type:"any"}},associations:{},events:{}}});
var p="CTX_SETTINGS";
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s){if(s.handler){return this.hasStableId(o);}var h=Object.keys(s).some(function(a){var b=s[a];return b.handler&&this._checkRelevantContainerStableID(b,o);}.bind(this));if(h){return this.hasStableId(o);}}return false;};
S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a){return false;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){return a.isEnabled(E.getElement());}return a.isEnabled;}return true;};
S.prototype._getUnsavedChanges=function(i,c){var e;var u=this.getCommandStack().getAllExecutedCommands().filter(function(C){e=C.getElementId&&C.getElementId()||C.getElement&&C.getElement().getId();if(e===i&&c.indexOf(C.getChangeType())>=0){return true;}}).map(function(C){return C.getPreparedChange();});return u;};
S.prototype._handleFlexChangeCommand=function(c,s,C){var m=c.changeSpecificData;var v;var a=c.selectorElement||c.selectorControl;var b;var o;if(a.controlType){b=a.controlType;}else{o=a;}return this.hasChangeHandler(m.changeType,o,b).then(function(h){if(s[0].getVariantManagement&&h){v=s[0].getVariantManagement();}return this.getCommandFactory().getCommandFor(a,"settings",m,undefined,v);}.bind(this)).then(function(d){return C.addCommand(d);});};
S.prototype._handleAppDescriptorChangeCommand=function(c,e,C){var m=c.changeSpecificData;var o=c.appComponent;var M=o.getManifest();var r=M["sap.app"].id;return this.getCommandFactory().getCommandFor(e,"appDescriptor",{reference:r,appComponent:o,changeType:m.appDescriptorChangeType,parameters:m.content.parameters,texts:m.content.texts}).then(function(a){return C.addCommand(a);});};
S.prototype._handleCompositeCommand=function(e,E,c){var C;return this.getCommandFactory().getCommandFor(E,"composite").then(function(_){C=_;}).then(function(){return c.map(function(m){var a=m.changeSpecificData;if(a.changeType){return this._handleFlexChangeCommand(m,e,C);}else if(a.appDescriptorChangeType){return this._handleAppDescriptorChangeCommand(m,E,C);}},this);}.bind(this)).then(function(a){return Promise.all(a);}).then(function(){if(C.getCommands().length>0){this.fireElementModified({command:C});}}.bind(this));};
S.prototype.handler=function(e,m){m=m||{};var E=e[0].getElement();var h=m.fnHandler;if(!h){h=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!h){throw new Error("Handler not found for settings action");}}m.getUnsavedChanges=this._getUnsavedChanges.bind(this);m.styleClass=U.getRtaStyleClassName();return h(E,m).then(function(c){if(c.length>0){return this._handleCompositeCommand(e,E,c);}}.bind(this)).catch(function(v){throw D.propagateError(v,"Settings#handler","Error occured during handler execution","sap.ui.rta.plugin");});};
S.prototype.getMenuItems=function(e){var E=e[0];var s=this.getAction(E);var m=[];if(s){var r=110;if(s.handler){s={settings:s};}var a=Object.keys(s);a.forEach(function(b,i,A){var o=s[b];if(o.handler&&this._checkRelevantContainerStableID(o,E)&&this.isAvailable([E])){var c=A.length===1;m.push({id:c?p:p+i,rank:c?r:r+i,text:this.getActionText(E,o,p),icon:g(o),enabled:(typeof o.isEnabled==="function"&&function(e){return o.isEnabled(e[0].getElement());}||o.isEnabled||this.isEnabled([E])),handler:function(h,e,d){d=d||{};d.fnHandler=h;return this.handler(e,d);}.bind(this,o.handler),submenu:f(o.submenu)});}else{B.warning("Handler not found for settings action '"+b+"' or relevant container has no stable id");}},this);}return m;};
function f(s){if(s){return s.map(function(o,i){return{id:o.key||p+"_SUB_"+i,icon:o.icon||"blank",text:o.name||"",enabled:o.hasOwnProperty("enabled")?o.enabled:true};});}}
function g(s){var d="sap-icon://key-user-settings";var a=s.icon;if(!a){return d;}if(typeof a!=="string"){B.error("Icon setting for settingsAction should be a string");return d;}return a;}
S.prototype.getActionName=function(){return"settings";};
return S;});
sap.ui.predefine('sap/ui/rta/plugin/Split',["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/base/util/uid"],function(P,D,F,u){"use strict";
var S=P.extend("sap.ui.rta.plugin.Split",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s&&s.changeType&&s.changeOnRelevantContainer){var r=o.getRelevantContainer();return this.hasChangeHandler(s.changeType,r).then(function(h){return h&&this.hasStableId(o)&&this._checkRelevantContainerStableID(s,o);}.bind(this));}return false;};
S.prototype.isAvailable=function(e){if(e.length!==1){return false;}var E=e[0];if(!this._isEditableByPlugin(E)){return false;}var s=this.getAction(E);var o=E.getElement();if(s&&s.getControlsCount(o)<=1){return false;}return true;};
S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a||!this.isAvailable(e)){return false;}var A=true;if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){A=a.isEnabled(E.getElement());}else{A=a.isEnabled;}}return A;};
S.prototype.handleSplit=function(e){var s=e.getElement();var p=s.getParent();var d=e.getDesignTimeMetadata();var E=this.getAction(e).getControlsCount(s);var v=F.getViewForControl(s);var n=[];for(var i=0;i<E;i++){n.push(v.createId(u()));}var o=this.getAction(e);var V=this.getVariantManagementReference(e,o);return this.getCommandFactory().getCommandFor(s,"split",{newElementIds:n,source:s,parentElement:p},d,V).then(function(a){this.fireElementModified({command:a});}.bind(this)).catch(function(a){throw D.propagateError(a,"Split#handleSplit","Error occured during handleSplit execution","sap.ui.rta.plugin");});};
S.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_UNGROUP_FIELDS",rank:100,icon:"sap-icon://split"});};
S.prototype.getActionName=function(){return"split";};
S.prototype.handler=function(e){this.handleSplit(e[0]);};
return S;});
sap.ui.predefine('sap/ui/rta/plugin/Stretch',["sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/base/util/includes","sap/base/util/restricted/_debounce"],function(P,O,a,b,_){"use strict";
var S=P.extend("sap.ui.rta.plugin.Stretch",{metadata:{library:"sap.ui.rta",properties:{},associations:{stretchCandidates:{type:"sap.ui.core.Control",multiple:true}},events:{}}});
S.STRETCHSTYLECLASS="sapUiRtaStretchPaddingTop";
S.prototype.setDesignTime=function(d){P.prototype.setDesignTime.apply(this,arguments);if(d){d.attachEventOnce("synced",this._onDTSynced,this);}};
S.prototype.exit=function(){if(this.getDesignTime()){this.getDesignTime().detachEvent("elementOverlayAdded",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementOverlayMoved",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementPropertyChanged",this._onElementPropertyChanged);this.getDesignTime().detachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged);this.getDesignTime().detachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed);}};
S.prototype.addStretchCandidate=function(o){var e=o.getElement();if(!b(this.getStretchCandidates(),e.getId())){this.addAssociation("stretchCandidates",e);}};
S.prototype.removeStretchCandidate=function(o){this.removeAssociation("stretchCandidates",o.getElement());this._toggleStyleClass(o,false);};
S.prototype.registerElementOverlay=function(o){this._checkParentAndAddToStretchCandidates(o);o.attachElementModified(this._onElementModified,this);P.prototype.registerElementOverlay.apply(this,arguments);};
S.prototype.deregisterElementOverlay=function(o){this._toggleStyleClass(o,false);};
S.prototype._isEditable=function(){return false;};
S.prototype._onDTSynced=function(){this._setStyleClassForAllStretchCandidates();this.getDesignTime().attachEvent("elementOverlayAdded",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementOverlayMoved",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementPropertyChanged",this._onElementPropertyChanged,this);this.getDesignTime().attachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged,this);this.getDesignTime().attachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed,this);};
S.prototype._onElementModified=function(e){if(this.getDesignTime().getBusyPlugins().length){return;}var p=e.getParameters();var o=e.getSource();if(p.type==="afterRendering"){if(!this.fnDebounced){this.fnDebounced=_(function(){this._setStyleClassForAllStretchCandidates(this._getNewStretchCandidates(this._aOverlaysCollected));this._aOverlaysCollected=[];this.fnDebounced=undefined;}.bind(this),16);}if(!this._aOverlaysCollected){this._aOverlaysCollected=[];}if(!b(this._aOverlaysCollected,o)){this._aOverlaysCollected.push(o);this.fnDebounced();}}};
S.prototype._onElementOverlayDestroyed=function(e){if(this.getDesignTime().getBusyPlugins().length){return;}var n=[];var p=e.getParameters().elementOverlay.getParentElementOverlay();if(p&&!p._bIsBeingDestroyed){var r=this._getRelevantOverlays(p).filter(function(o){return o.getElement();});n=this._getNewStretchCandidates(r);}this._setStyleClassForAllStretchCandidates(n);};
S.prototype._onElementOverlayEditableChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var c=this._getRelevantOverlaysOnEditableChange(o);this._setStyleClassForAllStretchCandidates(c);};
S.prototype._onElementPropertyChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var r=this._getRelevantOverlays(o);var d=_(function(){if(!this.bIsDestroyed&&!o.bIsDestroyed){var n=this._getNewStretchCandidates(r).concat(this._getRelevantOverlaysOnEditableChange(o));n=n.filter(function(i,p,A){return A.indexOf(i)===p;});this._setStyleClassForAllStretchCandidates(n);}}.bind(this));r.forEach(function(o){o.attachEventOnce("geometryChanged",d);});};
S.prototype._onElementOverlayChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var r=this._getRelevantOverlays(o);var n=this._getNewStretchCandidates(r);this._setStyleClassForAllStretchCandidates(n);};
S.prototype._getRelevantOverlaysOnEditableChange=function(o){var r=b(this.getStretchCandidates(),o.getElement().getId())?[o.getElement().getId()]:[];var p=o.getParentAggregationOverlay();if(!p){return r;}var c=p.getChildren();c.splice(c.indexOf(o),1);var A=c.some(function(o){return o.getEditable()&&o.getGeometry();});if(A){return r;}return r.concat(this._getRelevantParents(o));};
S.prototype._getRelevantParents=function(o){var r=[];for(var i=0;i<25;i++){o=o.getParentElementOverlay();if(!o){return r;}if(!b(this.getStretchCandidates(),o.getElement().getId())){return r;}r.push(o.getElement().getId());}};
S.prototype._getNewStretchCandidates=function(o){var n=[];o.forEach(function(c){if(this._reevaluateStretching(c)){n.push(c.getElement().getId());}},this);return n;};
S.prototype._reevaluateStretching=function(o){if(!o.bIsDestroyed){var e=o.getAssociatedDomRef();if(e){var i=e.hasClass(S.STRETCHSTYLECLASS);var s=this._childrenAreSameSize(o,undefined,i);if(i&&!s){this.removeStretchCandidate(o);}else if(!i&&s){this.addStretchCandidate(o);return true;}}}};
S.prototype._checkParentAndAddToStretchCandidates=function(o){var p=o.getParentElementOverlay();var $=p&&p.getAssociatedDomRef();if($){if(this._startAtSamePosition(p,o)){if(this._childrenAreSameSize(p)){this.addStretchCandidate(p);}}}};
S.prototype._startAtSamePosition=function(p,o){if(p&&p.getGeometry()&&o.getGeometry()){if(p.getGeometry().position.top===o.getGeometry().position.top&&p.getGeometry().position.left===o.getGeometry().position.left){return true;}}};
S.prototype._childrenAreSameSize=function(r,c,i){var p=r.getGeometry();if(!p){return false;}var h=p.size.height;if(i){h-=parseInt(r.getElement().$().css("padding-top"));}var d=Math.round(p.size.width)*Math.round(h);c=c||a.getAllChildOverlays(r);var C=c.map(function(f){return f.getGeometry();});var o=a.getGeometry(C);if(!o){return false;}var e=Math.round(o.size.width)*Math.round(o.size.height);return e===d;};
S.prototype._atLeastOneDescendantEditable=function(r,c){var A=c.some(function(o){return o.getEditable()&&o.getGeometry();});if(A){return true;}var C=[];c.forEach(function(o){C=C.concat(a.getAllChildOverlays(o));});if(!C.length>0){return false;}if(this._childrenAreSameSize(r,C)){return this._atLeastOneDescendantEditable(r,C);}};
S.prototype._setStyleClassForAllStretchCandidates=function(s){if(!Array.isArray(s)){s=this.getStretchCandidates();}s.forEach(function(e){var o=O.getOverlay(e);var c=a.getAllChildOverlays(o);var A=this._atLeastOneDescendantEditable(o,c);var d=o.getEditable()&&A;this._toggleStyleClass(o,d);},this);};
S.prototype._toggleStyleClass=function(o,A){var e=o.getAssociatedDomRef();if(e){if(A){e.addClass(S.STRETCHSTYLECLASS);}else{e.removeClass(S.STRETCHSTYLECLASS);}}};
return S;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AddElementsDialog',["sap/ui/base/ManagedObject","sap/m/Label","sap/m/Dialog","sap/ui/model/json/JSONModel","sap/m/SearchField","sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/List","sap/m/CustomListItem","sap/m/ScrollContainer","sap/ui/model/Sorter","sap/base/Log","sap/m/VBox","sap/ui/rta/Utils","sap/m/library","sap/ui/layout/VerticalLayout","sap/m/Text"],function(M,L,D,J,S,B,T,a,F,b,c,d,e,f,g,V,U,m,h,i){"use strict";var j=m.ButtonType;var k=m.ListType;var l=m.LabelDesign;
var A=M.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{customFieldEnabled:{type:"boolean",defaultValue:false},businessContextVisible:{type:"boolean",defaultValue:false},title:{type:"string"}},events:{opened:{},openCustomField:{}}}});
A.prototype.init=function(){this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this._bAscendingSortOrder=false;this._oDialog=new D().addStyleClass("sapUIRtaFieldRepositoryDialog");this._oDialog.addStyleClass(U.getRtaStyleClassName());this._oDialog.removeStyleClass("sapUiPopupWithPadding");this._oDialog.setModel(new J({elements:[]}));var C=this._createContent();var n=this._createButtons();C.forEach(function(o){this._oDialog.addContent(o);},this);n.forEach(function(o){this._oDialog.addButton(o);},this);this._oDialog.setInitialFocus(this._oInput);};
A.prototype.exit=function(){this._oDialog.destroy();};
A.prototype._createContent=function(){this._oInput=new S({width:"100%",liveChange:[this._updateModelFilter,this]});var r=new B({text:"",icon:"sap-icon://sort",press:[this._resortList,this]});this._oCustomFieldButton=new B({text:"",icon:"sap-icon://add",tooltip:this._oTextResources.getText("BTN_FREP_CCF"),enabled:this.getCustomFieldEnabled(),press:[this._redirectToCustomFieldCreation,this]});this._oToolbarSpacer1=new a();this.oInputFields=new T({content:[this._oInput,r,this._oToolbarSpacer1,this._oCustomFieldButton]});this._oBCContainer=new h({visible:this.getBusinessContextVisible(),content:[new i({text:this._oTextResources.getText("BUSINESS_CONTEXT_TITLE")})]}).addStyleClass("sapUIRtaBusinessContextContainer");var o=new L({design:l.Standard,text:{parts:[{path:"label"},{path:"parentPropertyName"},{path:"duplicateName"}],formatter:function(t,P,u){if(u&&P){t+=" ("+P+")";}return t;}}});var n=new L({text:{parts:[{path:"originalLabel"}],formatter:function(O){if(O){return this._oTextResources.getText("LBL_FREP",O);}return"";}.bind(this)},visible:{parts:[{path:"originalLabel"}],formatter:function(O){if(O){return true;}return false;}}});var v=new V();v.addItem(o);v.addItem(n);var s=new f("label",this._bAscendingSortOrder);this._oList=new c({mode:"MultiSelect",includeItemInSelection:true,growing:true,growingScrollToLoad:true}).setNoDataText(this._oTextResources.getText("MSG_NO_FIELDS",this._oTextResources.getText("MULTIPLE_CONTROL_NAME").toLowerCase()));var p=new d({type:k.Active,selected:"{selected}",tooltip:"{tooltip}",content:[v]}).addStyleClass("sapUIRtaListItem");this._oList.bindItems({path:"/elements",template:p,sorter:s,templateShareable:false,key:function(C){switch(C.getProperty("type")){case"invisible":return C.getProperty("elementId");case"odata":return C.getProperty("name");case"delegate":return C.getProperty("name");case"custom":return C.getProperty("key");default:g.error("sap.ui.rta.plugin.additionalElements.AddElementsDialog#_createContent: unsupported data type");}}});var q=new e({content:this._oList,vertical:true,horizontal:false}).addStyleClass("sapUIRtaCCDialogScrollContainer");return[this.oInputFields,this._oBCContainer,q];};
A.prototype._createButtons=function(){this._oOKButton=new B({text:this._oTextResources.getText("BTN_FREP_OK"),press:[this._submitDialog,this],type:j.Emphasized});var C=new B({text:this._oTextResources.getText("BTN_FREP_CANCEL"),press:[this._cancelDialog,this]});return[this._oOKButton,C];};
A.prototype._submitDialog=function(){this._oDialog.close();this._fnResolve();};
A.prototype._cancelDialog=function(){this._oList.removeSelections();this._oDialog.close();this._fnReject();};
A.prototype.setElements=function(E){this._oDialog.getModel().setProperty("/elements",E);};
A.prototype.getElements=function(){return this._oDialog.getModel().getProperty("/elements");};
A.prototype.getSelectedElements=function(){return this._oDialog.getModel().getObject("/elements").filter(function(E){return E.selected;});};
A.prototype.open=function(){return new Promise(function(r,n){this._fnResolve=r;this._fnReject=n;this._oDialog.attachAfterOpen(function(){this.fireOpened();}.bind(this));this._oDialog.open();}.bind(this));};
A.prototype._resortList=function(){this._bAscendingSortOrder=!this._bAscendingSortOrder;var o=this._oList.getBinding("items");var s=[];s.push(new f("label",this._bAscendingSortOrder));o.sort(s);};
A.prototype._updateModelFilter=function(E){var v=E.getParameter("newValue");var o=this._oList.getBinding("items");if((typeof v)==="string"){var n=new F("label",b.Contains,v);var O=new F("originalLabel",b.Contains,v);var p=new F("parentPropertyName",b.Contains,v);var q=new F("duplicateName",b.EQ,true);var P=new F({filters:[p,q],and:true});var r=new F({filters:[n,O,P],and:false});o.filter([r]);}else{o.filter([]);}};
A.prototype._redirectToCustomFieldCreation=function(){this.fireOpenCustomField();this._oDialog.close();};
A.prototype.setTitle=function(t){M.prototype.setProperty.call(this,"title",t,true);this._oDialog.setTitle(t);};
A.prototype.setCustomFieldEnabled=function(C){this.setProperty("customFieldEnabled",C,true);this._oCustomFieldButton.setEnabled(this.getProperty("customFieldEnabled"));};
A.prototype._setBusinessContextVisible=function(n){this.setProperty("businessContextVisible",n,true);this._oBCContainer.setVisible(this.getProperty("businessContextVisible"));};
A.prototype.getList=function(){return this._oList;};
A.prototype.addBusinessContext=function(n){this._removeBusinessContexts();var o=new i({text:this._oTextResources.getText("MSG_NO_BUSINESS_CONTEXTS")});if(n&&n.length>0){n.forEach(function(C){o=new i({text:C.BusinessContextDescription});this._oBCContainer.addContent(o);},this);}else{this._oBCContainer.addContent(o);}this._setBusinessContextVisible(true);};
A.prototype._removeBusinessContexts=function(){var n;var o=this._oBCContainer.getContent().length;for(n=0;n<o;n++){this._oBCContainer.removeContent(1);}};
return A;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer',["sap/ui/thirdparty/jquery","sap/ui/dt/ElementUtil","sap/base/Log","sap/base/util/ObjectPath","sap/ui/rta/util/BindingsExtractor"],function(q,E,L,O,B){"use strict";
function _(j,F,M){if(!j){return false;}var G=j.getBindingInfo(F,M);var P=G&&G.path;if(!P){return false;}if(P.indexOf(">")>-1){P=P.split(">").pop();}return P.indexOf("/")===0;}
function a(j,F,G,M){var H;if(F){H=j.getBindingInfo(G,M);if(typeof H.model==="string"&&H.model!==M){H=undefined;}}else{H=j.getBindingContext(M);}return H;}
function b(j,F,M){var G=_(j,F,M);var H=a(j,G,F,M);if(H){return G?H.path:H.getPath();}}
function c(P){var F=P.reduce(function(j,G){if(Array.isArray(G.properties)){j=j.concat(G.properties.map(function(I){I.parentPropertyName=G.label||G.name;return I;}));}else{j.push(G);}return j;},[]);return F;}
function d(j,F,G){var P={element:j,aggregationName:F,payload:G.delegateInfo.payload||{}};return G.delegateInfo.delegate.getPropertyInfo(P).then(c);}
function e(j,F,G){var H=G.addViaDelegate;var I;if(H){I=d.bind(null,j,F,H);}else{I=Promise.resolve.bind(Promise,[]);}return I().then(function(P){return l(P);});}
function f(P){return P.filter(function(j){return!j.unsupported;});}
function g(P,j){j.type="custom";if(j.id){j.itemId=P+"-"+j.id;j.key=j.itemId;}return j;}
function h(P){return{selected:false,label:P.label||P.name,parentPropertyName:P.parentPropertyName?P.parentPropertyName:"",duplicateName:P.duplicateName?P.duplicateName:false,tooltip:P.tooltip||P.label,originalLabel:"",type:"delegate",entityType:P.entityType,name:P.name,bindingPath:P.bindingPath};}
function i(j){var F=j.element;var G=j.action;return{selected:false,label:F.__label||E.getLabelForElement(F,G.getLabel),tooltip:F.__tooltip||E.getLabelForElement(F,G.getLabel)||F.__bindingPath,parentPropertyName:F.__parentPropertyName?F.__parentPropertyName:"",duplicateName:F.__duplicateName?F.__duplicateName:false,originalLabel:F.__renamedLabel&&F.__label!==F.__originalLabel?F.__originalLabel:"",bindingPath:F.__bindingPath,type:"invisible",elementId:F.getId()};}
function k(j,R,F,M){if(R&&R!==j){var G=b(j,F,M);return E.findAllSiblingsInContainer(j,R).filter(function(S){return G===b(S,F,M);});}return[j];}
function l(P){P.forEach(function(M,F,P){if(M["duplicateName"]!==true){for(var j=F+1;j<P.length-1;j++){if(M.label===P[j].label){M["duplicateName"]=true;P[j]["duplicateName"]=true;}}}});return P;}
function m(I,P){return P.some(function(M){return M.label===I.__label;});}
function n(j){return Array.isArray(j)&&j.length>0;}
function o(j,P){return P.filter(function(M){return j.some(function(F){return F.startsWith(M.bindingPath);});}).pop();}
function p(j){return(q.isPlainObject(j)?j.parts[0].path:!!j.getPath&&j.getPath());}
function r(j,F,M,G){var H=j.getModel(M);var R=k(j,F.relevantContainer,G,M);var I=[];R.forEach(function(j){I=I.concat(B.getBindings(j,H).map(p));});return I;}
function s(j,F){var P={element:j.relevantContainer,aggregationName:F,payload:j.delegateInfo.payload||{}};return j.delegateInfo.delegate.getRepresentedProperties(P);}
function t(j,F,M,G){return s(F,G).then(function(R){if(R===undefined){return r(j,F,M,G);}var H=[];R.forEach(function(I){H=H.concat(I.bindingPaths);});return H;});}
function u(j,F,M,G){return Promise.resolve().then(function(){var H=!!O.get("delegateInfo.delegate.getRepresentedProperties",F);if(H){return t(j,F,M,G);}return r(j,F,M,G);});}
function v(I,S){I.__originalLabel=S.label;I.__tooltip=S.tooltip;I.__bindingPath=S.name;if(I.__label!==I.__originalLabel){I.__renamedLabel=true;}if(S.parentPropertyName){I.__parentPropertyName=S.parentPropertyName;}}
function w(j,F){var H=!!O.get("delegateInfo.delegate.getRepresentedProperties",j);if(H){return s(j,F);}}
function x(I,R){var j;R.some(function(P){if(P.id===I.getId()){j=P;return true;}});return j.bindingPaths||[];}
function y(I,P,j){if(!n(j)){return true;}var M=o(j,P);if(M){v(I,M);return true;}return false;}
function z(j,F,I,G,R,P){var H=G.addViaDelegate;var M=C(H);var J=j.getModel(M);var K=true;var N=[];if(H){if(H&&R){N=x(I,R);}else if(b(j,F,M)===b(I,F,M)){N=B.collectBindingPaths(I,J).bindingPaths;}else if(B.getBindings(I,J).length>0){K=false;}if(K){I.__duplicateName=m(I,P);K=y(I,P,N);}}return K;}
function A(I,j,F,G){var H=j.addViaCustom;if(H&&F){H.items.forEach(function(J){g(G.getParent().getId(),J);if(J.itemId===I.getId()){v(I,J);}});}}
function C(j){return O.get("delegateInfo.payload.modelName",j);}
var D={enhanceInvisibleElements:function(j,F){var R=F.reveal;var G=F.addViaDelegate;var H=j.getMetadata().getAggregation();var I=H?H.name:F.aggregation;return Promise.all([e(j,I,F),w(G,I)]).then(function(J){var P=J[0];var K=J[1];var M=[];var N=R.elements||[];N.forEach(function(Q){var S=Q.element;var T=Q.action;S.__label=E.getLabelForElement(S,T.getLabel);var U=z(j,I,S,F,K,P);A(S,F,U,j);if(U){M.push({element:S,action:T});}});return M;}).then(function(J){return J.map(i);});},getUnrepresentedDelegateProperties:function(j,F){var M=C(F);var G=j.getMetadata().getAggregation();var H=G?G.name:F.action.aggregation;return Promise.all([d(j,H,F),u(j,F,M,H)]).then(function(I){var J=I[0];var R=I[1];var K=F.action.filter?F.action.filter:function(){return true;};var U=f(J);U=U.filter(function(N){var P=false;if(R){P=R.some(function(Q){return Q===N.bindingPath;});}return!P&&K(F.relevantContainer,N);});U=l(U);return U;}).then(function(U){return U.map(h);});},getCustomAddItems:function(j,F){return new Promise(function(R){if(Array.isArray(F.items)){R(F.items.map(g.bind(null,j.getParent().getId())).filter(function(G){if(!G.id){L.error("CustomAdd item with label "+G.label+" does not contain an 'id' property","sap.ui.rta.plugin.AdditionalElementsAnalyzer#showAvailableElements");return false;}return!E.getElementInstance(G.itemId);}));}else{R();}});},getFilteredItemsList:function(j){var I=j[0];var F=2;var G=j[F];if(G){var H=I.map(function(J){return J.elementId;});j[F]=G.filter(function(J){return!J.itemId||H.indexOf(J.itemId)===-1;});}return j.reduce(function(J,K){return J.concat(K);},[]);}};return D;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin',["sap/ui/rta/plugin/Plugin","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/rta/Utils","sap/ui/fl/Utils","sap/ui/dt/Util","sap/ui/dt/ElementDesignTimeMetadata","sap/base/Log","sap/base/util/merge","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/core/util/reflection/JsControlTreeModifier"],function(P,E,O,U,F,D,a,L,m,b,J){"use strict";
function _(s,i,q){var r;var R=i;if(q){var t=["add.delegate","reveal","add.custom"].some(function(w){return q.isResponsibleElementActionAvailable(i,w);});if(t){R=q.getResponsibleElementOverlay(i);}}var u=R.getRelevantContainer(!s);var v=O.getOverlay(u);if(s){r=R.getParentElementOverlay();}else{r=R;}return{responsibleElementOverlay:R,relevantContainerOverlay:v,parentOverlay:r,relevantContainer:u,parent:r&&r.getElement()};}
function c(i,C){return C.sParentAggregationName;}
function d(i,s){var q=i.getElement();if(!q){return[];}var I=E.getAggregation(q,s).filter(function(C){var r=O.getOverlay(C);if(!this.hasStableId(r)){return false;}var R=i.getRelevantContainer(true);var t=O.getOverlay(R);var u=i;var v=false;do{v=!u.getElementVisibility();if(v){break;}if(u===t){break;}else{u=u.getParentElementOverlay();}}while(u);if(v){return true;}return r.getElementVisibility()===false;},this);return I;}
function e(i){return(i["addViaDelegate"]&&i["addViaDelegate"].designTimeMetadata)||(i["addViaCustom"]&&i["addViaCustom"].designTimeMetadata);}
var S=true;var f=false;
function g(r,i,q,s,C){var N=[];var t;var u;if(i.addViaCustom||i.addViaDelegate){var v=i.aggregation;var w=e(i);t=w.getAggregationDescription(v,q);if(t){u=s?t.singular:t.plural;N.push(u);}}if(i.reveal){i.reveal.controlTypeNames.forEach(function(t){u=s?t.singular:t.plural;N.push(u);});}var x=N.reduce(function(y,z){if(y.indexOf(z)===-1){y.push(z);}return y;},[]);var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(x.length===1){u=x[0];}else if(C){u=C;}else{u=T.getText("MULTIPLE_CONTROL_NAME");}return T.getText(r,[u]);}
function h(i,r){var R;i.reveal.elements.some(function(q){if(q.element.getId()===r.getId()){R=q;return false;}});return R;}
function j(i,q){var r=q.responsibleElementOverlay.getParentAggregationOverlay().getAggregationName();return i.aggregation===r;}
function k(C,i,q,r){var v=q.changeType&&r.hasStableId(C);if(v&&C!==i.relevantContainerOverlay){v=r.hasStableId(i.relevantContainerOverlay);}return v;}
function l(i,q,r){return i.reduce(function(s,t){return s.then(function(u){var C=t.changeOnRelevantContainer?q.relevantContainer:q.parent;var v=O.getOverlay(C);var V=k(v,q,t,r);if(V){t.element=C;return b.getDelegateForControl({control:q.relevantContainer,modifier:J,supportsDefault:t.supportsDefaultDelegate}).then(function(w){if(w&&w.name){t.delegateInfo=w;u.push(t);}return u;});}return u;});},Promise.resolve([]));}
function n(i,q){return this.hasChangeHandler(i.changeType,i.element).then(function(H){if(H){return{aggregationName:i.aggregation,addPropertyActionData:{designTimeMetadata:q,action:i,delegateInfo:{payload:i.delegateInfo.payload||{},delegate:i.delegateInfo.instance,modelType:i.delegateInfo.modelType,requiredLibraries:i.delegateInfo.requiredLibraries}}};}});}
function o(C,r){var i=C.getManifestEntry("/sap.ui5/dependencies/libs");return Object.keys(r).some(function(R){return!i[R];});}
function p(){var i=[];var r=b.getKnownDefaultDelegateLibraries();r.forEach(function(s){var q=sap.ui.getCore().loadLibrary(s,{async:true}).catch(function(v){L.warning("Required library not available: ",v);return Promise.reject();});i.push(q);});return Promise.all(i);}
var A=P.extend("sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin",{
metadata:{library:"sap.ui.rta",properties:{analyzer:"object",dialog:"object",commandFactory:"object"},associations:{},events:{}},
getContextMenuTitle:function(i,q){var r=_(i,q,this);var s=this._getActionsOrUndef(i,q);return g("CTX_ADD_ELEMENTS",s,r.parent,S);},
isAvailable:function(i,q){return q.every(function(r){return this._isEditableByPlugin(r,i);},this);},
isEnabled:function(i,q){if(q.length>1){return false;}var r=this.getResponsibleElementOverlay(q[0]);var s;var I;if(i){s=r.getParentElementOverlay();if(s){I=true;}else{I=false;}}else{var t=this._getActionsOrUndef(i,r);if((!t.reveal||t.reveal.elements.length===0)&&!t.addViaCustom&&!t.addViaDelegate){I=false;}else{I=true;}}var C=this.getCachedElements(i);var u=C&&C.length>0;I=I&&(u||this.getDialog().getCustomFieldEnabled());return I;},
registerElementOverlay:function(i){var M=i.getElement().getModel();if(M){var q=M.getMetaModel();if(q&&q.loaded){q.loaded().then(function(){this.evaluateEditable([i],{onRegistration:true});}.bind(this));}}P.prototype.registerElementOverlay.apply(this,arguments);},
_getRevealActions:function(s,i){var q=_(s,i,this);var r=[q.parentOverlay];if(q.relevantContainer!==q.parent){r=E.findAllSiblingsInContainer(q.parent,q.relevantContainer).map(function(v){return O.getOverlay(v);}).filter(function(v){return v;});}var t;if(s){var u=q.responsibleElementOverlay.getParentAggregationOverlay();t=u?[q.responsibleElementOverlay.getParentAggregationOverlay().getAggregationName()]:[];}else{t=q.parentOverlay.getAggregationOverlays().filter(function(v){return!v.getDesignTimeMetadata().isIgnored(q.parent);}).map(function(v){return v.getAggregationName();});}return t.reduce(function(v,w){return v.then(function(R){return this._getRevealActionFromAggregations(r,R,w);}.bind(this));}.bind(this),Promise.resolve({}));},
_getRevealActionFromAggregations:function(i,q,s){var I=i.reduce(function(t,u){return u?t.concat(d.call(this,u,s)):t;}.bind(this),[]);var r={elements:[],controlTypeNames:[]};var R=I.reduce(function(t,u){return t.then(function(v){return this._invisibleToReveal(v,u);}.bind(this));}.bind(this),Promise.resolve(r));return R.then(function(t){if(t.elements.length>0){q[s]={reveal:t};}return q;});},
_invisibleToReveal:function(r,i){return Promise.resolve().then(function(){var q;var R;var s=false;var H=Promise.resolve();var t=O.getOverlay(i);if(t){q=t.getDesignTimeMetadata();R=q&&q.getAction("reveal",i);if(R&&R.changeType){var u=i;if(R.changeOnRelevantContainer){u=t.getRelevantContainer();}H=this.hasChangeHandler(R.changeType,u).then(function(v){if(v){if(R.changeOnRelevantContainer){var w=_(true,t);s=this.hasStableId(w.relevantContainerOverlay)&&this.hasStableId(w.parentOverlay);}else{s=true;}if(!R.getAggregationName){R.getAggregationName=c;}}}.bind(this));}}return H.then(function(){if(s){r.elements.push({element:i,designTimeMetadata:q,action:R});var N=q.getName(i);if(N){r.controlTypeNames.push(N);}}return r;});}.bind(this));},
_getAddViaDelegateActions:function(s,i){var q=_(s,i,this);var r=q.parentOverlay&&q.parentOverlay.getDesignTimeMetadata();return Promise.resolve().then(function(){var t=r?r.getActionDataFromAggregations("add",q.parent,undefined,"delegate"):[];if(t.length){return p().then(l.bind(this,t,q,this));}return[];}.bind(this)).then(function(t){return t.reduce(function(u,v){return u.then(function(R){return n.call(this,v,r).then(function(w){if(w){w.addPropertyActionData.relevantContainer=q.relevantContainer;if(!R[w.aggregationName]){R[w.aggregationName]={};}R[w.aggregationName].addViaDelegate=w.addPropertyActionData;}return R;});}.bind(this));}.bind(this),Promise.resolve({}));}.bind(this));},
_checkInvalidAddActions:function(s,i){var q=_(s,i,this);var r=q.parentOverlay&&q.parentOverlay.getDesignTimeMetadata();var t=r?r.getActionDataFromAggregations("addODataProperty",q.parent):[];if(t.length>0){L.error("Outdated addODataProperty action in designtime metadata in "+r.getData().designtimeModule+" or propagated or via instance specific designtime metadata.");}},
_getCustomAddActions:function(s,i){var q=_(s,i,this);var r=q.parentOverlay&&q.parentOverlay.getDesignTimeMetadata();var t=r&&r.getActionDataFromAggregations("add",q.parent,undefined,"custom")||[];function u(v,C){var I=[];return Promise.resolve().then(function(){if(v&&typeof v.getItems==="function"){var w=O.getOverlay(C);if(this.hasStableId(w)){return v.getItems(C);}}}.bind(this)).then(function(w){I=w;if(Array.isArray(I)){var x=I.reduce(function(y,z){if(z.changeSpecificData.changeOnRelevantContainer){C=q.relevantContainer;}if(z.changeSpecificData.changeType){y.push(this.hasChangeHandler(z.changeSpecificData.changeType,C));}return y;}.bind(this),[]);return Promise.all(x);}}.bind(this)).then(function(H){if(Array.isArray(H)&&I.length===H.length&&H.indexOf(false)===-1){return{aggregationName:v.aggregation,addViaCustom:{designTimeMetadata:r,action:v,items:I}};}});}var C=q.parent;return t.reduce(function(v,w){return v.then(function(R){return u.call(this,w,C).then(function(x){if(x){R[x.aggregationName]={addViaCustom:x.addViaCustom};}return R;});}.bind(this));}.bind(this),Promise.resolve({}));},
_getActions:function(s,i,I){return new Promise(function(r,q){var t=s?"asSibling":"asChild";if(!I&&i._mAddActions){return r(i._mAddActions[t]);}var R=this._getRevealActions(s,i);var u=this._getAddViaDelegateActions(s,i);var C=this._getCustomAddActions(s,i);return Promise.all([R,u,C,this._checkInvalidAddActions(s,i)]).then(function(v){var w=m(v[0],v[1],v[2]);var x=Object.keys(w);if(x.length===0){w={};}else if(x.length>1){L.error("reveal or addViaDelegate or custom add action defined for more than 1 aggregation, that is not yet possible");}if(x.length>0){var y=x[0];w[y].aggregation=y;w=w[y];}i._mAddActions=i._mAddActions||{asSibling:{},asChild:{}};i._mAddActions[t]=w;r(w);}).catch(function(v){q(v);});}.bind(this));},
_getActionsOrUndef:function(s,i){var q=s?"asSibling":"asChild";return i._mAddActions&&i._mAddActions[q];},
_checkIfCreateFunctionIsAvailable:function(C){return!C||(C&&C.content&&C.content.createFunction);},
showAvailableElements:function(i,r,I,C){var R=r[0];var q=_(i,R);var s=i&&R.getElement();var t;return this._getActions(i,R).then(function(u){t=u;}).then(function(){return this.getAllElements(i,[q.responsibleElementOverlay],I,C);}.bind(this)).then(function(u){this.getDialog().setElements(u);return this.getDialog().open().then(function(){return this._createCommands(q,s,t,I);}.bind(this)).then(function(){var v=O.getOverlay(s)||R;v.focus();}).catch(function(v){if(v instanceof Error){throw v;}});}.bind(this)).catch(function(u){if(u instanceof Error){throw u;}else{L.info("Service not up to date, skipping add dialog","sap.ui.rta");}});},
_setDialogTitle:function(i,q,C){var s=g("HEADER_ADDITIONAL_ELEMENTS",i,q,f,C);this.getDialog().setTitle(s);if(C){this.getDialog()._oList.setNoDataText(this.getDialog()._oTextResources.getText("MSG_NO_FIELDS",C.toLowerCase()));}},
_onOpenCustomField:function(){F.ifUShellContainerThen(function(s){var C=s[0];var H=(C&&C.hrefForExternal({target:{semanticObject:"CustomField",action:"develop"},params:{businessContexts:this._oCurrentFieldExtInfo.BusinessContexts.map(function(B){return B.BusinessContext;}),serviceName:this._oCurrentFieldExtInfo.ServiceName,serviceVersion:this._oCurrentFieldExtInfo.ServiceVersion,entityType:this._oCurrentFieldExtInfo.EntityType}}));U.openNewWindow(H);}.bind(this),["CrossApplicationNavigation"]);},
_createCommands:function(i,s,q,I){var r=this.getDialog().getSelectedElements();r.sort(function(t,u){if(t.label>u.label){return-1;}if(t.label<u.label){return 1;}return 0;});if(r.length>0){return this.getCommandFactory().getCommandFor(i.parent,"composite").then(function(C){var t=Promise.resolve();r.forEach(function(u){switch(u.type){case"invisible":t=t.then(this._createCommandsForInvisibleElement.bind(this,C,u,i,s,q,I));break;case"delegate":t=t.then(this._createCommandsForAddViaDelegate.bind(this,C,u,i,s,q,I));break;case"custom":t=t.then(this._createCommandsForCustomElement.bind(this,C,u,i,s,q,I));break;default:L.error("Can't create command for untreated element.type "+u.type);}},this);return t.then(function(){return C;});}.bind(this)).then(function(C){this.fireElementModified({command:C});}.bind(this)).catch(function(M){throw D.propagateError(M,"AdditionalElementsPlugin#_createCommands","Error occured during _createCommands execution","sap.ui.rta.plugin");});}return Promise.resolve();},
_createCommandsForInvisibleElement:function(C,s,i,q,r,I){return this._createRevealCommandForInvisible(s,r,i).then(function(R){C.addCommand(R);return this._createMoveCommandForInvisible(s,i,q,I);}.bind(this)).then(function(M){if(M){C.addCommand(M);}else{L.warning("No move action configured for "+i.parent.getMetadata().getName()+", aggregation: "+r.aggregation,"sap.ui.rta");}return C;});},
_createCommandForAddLibrary:function(i,r,q){if(r){var C=F.getAppComponentForControl(i.relevantContainer);var s=o(C,r);if(s){var M=C.getManifest();var R=M["sap.app"].id;return this.getCommandFactory().getCommandFor(i.publicParent,"addLibrary",{reference:R,parameters:{libraries:r},appComponent:C},q);}}return Promise.resolve();},
_createRevealCommandForInvisible:function(s,i,q){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var t=h(i,r);var u=t.designTimeMetadata;var v=t.action;var V;if(R){V=this.getVariantManagementReference(R);}if(v.changeOnRelevantContainer){return this.getCommandFactory().getCommandFor(r,"reveal",{revealedElementId:r.getId(),directParent:q.parent},u,V);}return this.getCommandFactory().getCommandFor(r,"reveal",{},u,V);},
_createMoveCommandForInvisible:function(s,i,q,I){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var t=R.getParentAggregationOverlay().getAggregationName();var u=R.getParentElementOverlay().getElement()||i.parent;var T=i.parent;var v=U.getIndex(i.parent,q,t);var w=U.getIndex(u,r,t)-1;v=I!==undefined?I:E.adjustIndexForMove(u,T,w,v);if(v!==w||i.parent!==r.getParent()){var x=O.getOverlay(r)?O.getOverlay(r).getParentAggregationOverlay():i.relevantContainerOverlay;var y=x.getDesignTimeMetadata();var V=this.getVariantManagementReference(R);return this.getCommandFactory().getCommandFor(i.relevantContainer,"move",{movedElements:[{element:r,sourceIndex:w,targetIndex:v}],source:{parent:u,aggregation:t},target:{parent:T,aggregation:t}},y,V);}return Promise.resolve();},
_createCommandsForCustomElement:function(C,s,i,q,r,I){var t=i.parent;var u=i.parentOverlay.getAggregationOverlay(r.aggregation).getDesignTimeMetadata();var v=Object.assign({changeOnRelevantContainer:s.changeSpecificData.changeOnRelevantContainer,aggregationName:r.aggregation,changeType:s.changeSpecificData.changeType,addElementInfo:s.changeSpecificData.content,index:I||U.getIndex(i.parent,q,r.aggregation)},s.itemId&&{customItemId:s.itemId});var V;if(i.relevantContainerOverlay){V=this.getVariantManagementReference(i.relevantContainerOverlay);}return this.getCommandFactory().getCommandFor(t,"customAdd",v,u,V).then(function(w){if(w){C.addCommand(w);}return C;});},
_createCommandsForAddViaDelegate:function(C,s,i,q,r,I){var t=r.addViaDelegate.action;var R=t.delegateInfo.requiredLibraries;var u=i.parentOverlay.getAggregationOverlay(r.aggregation);var v=u.getDesignTimeMetadata();return this._createCommandForAddLibrary(i,R,v).then(function(w){if(w){C.addCommand(w);}return this._createAddViaDelegateCommand(s,i,v,q,r,I);}.bind(this)).then(function(w){if(w){C.addCommand(w);}return C;});},
_createAddViaDelegateCommand:function(s,i,q,r,t,I){var u=t.addViaDelegate.action;var v=u.changeOnRelevantContainer?i.relevantContainer:i.parent;var w=u.changeOnRelevantContainer?i.relevantContainerOverlay:i.parentOverlay;var V=this.getVariantManagementReference(w);var x=U.getIndex(i.parent,r,t.aggregation,q.getData().getIndex);var C="addDelegateProperty";var M=F.getAppComponentForControl(i.parent).getManifest();var y=F.getODataServiceUriFromManifest(M);return this.getCommandFactory().getCommandFor(i.parent,C,{newControlId:U.createFieldLabelId(v,s.entityType,s.bindingPath),index:I!==undefined?I:x,bindingString:s.bindingPath,entityType:s.entityType,parentId:i.parent.getId(),propertyName:s.name,oDataServiceVersion:s.oDataServiceVersion,oDataServiceUri:y,modelType:u.delegateInfo.modelType,relevantContainerId:i.relevantContainer.getId()},q,V);},
_isEditable:function(i,q){return Promise.all([this._isEditableCheck(q.sourceElementOverlay,true),this._isEditableCheck(q.sourceElementOverlay,false)]).then(function(r){return{asSibling:r[0],asChild:r[1]};}).catch(function(v){L.error(v);});},
_isEditableCheck:function(i,q){return Promise.resolve().then(function(){var r=_(q,i,this);if(!r.relevantContainerOverlay){return false;}return this._getActions(q,i,true).then(function(s){return U.doIfAllControlsAreAvailable([i,r.parentOverlay],function(){var t=false;if(q){t=j(s,r);}if(!t&&s.reveal){t=true;}if(!t&&!q){if(s.addViaDelegate){return this.checkAggregationsOnSelf(r.parentOverlay,"add",undefined,"delegate");}}if(!t&&!q&&s.addViaCustom){t=true;}return t;}.bind(this));}.bind(this)).then(function(s){if(s){s=this.hasStableId(i)&&this.hasStableId(r.parentOverlay);}return s;}.bind(this));}.bind(this));},
getAllElements:function(i,q,I,C){var r=q[0];var s=_(i,r,this);var t;var u=[];var v=this.getCachedElements(i);if(v){return v;}return this._getActions(i,r).then(function(w){t=w;u.push(t.reveal?this.getAnalyzer().enhanceInvisibleElements(s.parent,t):Promise.resolve([]),t.addViaDelegate?this.getAnalyzer().getUnrepresentedDelegateProperties(s.parent,t.addViaDelegate):Promise.resolve([]),t.addViaCustom?this.getAnalyzer().getCustomAddItems(s.parent,t.addViaCustom,t.aggregation):Promise.resolve([]));if(t.aggregation||C){this._setDialogTitle(t,s.parent,C);}}.bind(this)).then(function(){if(t.addViaDelegate){return U.isServiceUpToDate(s.parent);}}).then(function(){if(t.addViaDelegate){return U.isExtensibilityEnabledInSystem(s.parent);}this.getDialog()._oCustomFieldButton.setVisible(false);}.bind(this)).then(function(w){if(t.addViaDelegate){this.getDialog()._oCustomFieldButton.setVisible(w);this.getDialog().setCustomFieldEnabled(false);return U.isCustomFieldAvailable(s.parent);}}.bind(this)).then(function(w){if(w){this._oCurrentFieldExtInfo=w;this.getDialog().setCustomFieldEnabled(true);this.getDialog().addBusinessContext(this._oCurrentFieldExtInfo.BusinessContexts);this.getDialog().detachEvent('openCustomField',this._onOpenCustomField,this);this.getDialog().attachEvent('openCustomField',null,this._onOpenCustomField,this);}}.bind(this)).then(this._combineAnalyzerResults.bind(this,u)).then(function(w){this.setCachedElements(w,i);return w;}.bind(this)).catch(function(w){throw w;});},
getMenuItems:function(q){var r=true;var s="CTX_ADD_ELEMENTS_AS_SIBLING";var R=20;var I="sap-icon://add";var M=[];this.clearCachedElements();return Promise.all([this.getAllElements(true,q),this.getAllElements(false,q)]).then(function(){for(var i=0;i<2;i++){if(this.isAvailable(r,q)){var G=this.getContextMenuTitle.bind(this,r);var t={id:s,text:G,handler:function(r,q){return this.showAvailableElements(r,q);}.bind(this,r),enabled:this.isEnabled.bind(this,r),rank:R,icon:I};M.push(this.enhanceItemWithResponsibleElement(t,q,["addViaDelegate","reveal","custom"]));}r=false;s="CTX_ADD_ELEMENTS_AS_CHILD";R=30;}return M;}.bind(this));},
_combineAnalyzerResults:function(i){return Promise.all(i).then(function(q){return this.getAnalyzer().getFilteredItemsList(q);}.bind(this));},
clearCachedElements:function(){this._aCachedElements=undefined;},
setCachedElements:function(i,q){this._aCachedElements=this._aCachedElements||{};this._aCachedElements[q?"asSibling":"asChild"]=i;},
getCachedElements:function(i){if(!this._aCachedElements){return undefined;}return this._aCachedElements[i?"asSibling":"asChild"];}
});
return A;});
sap.ui.predefine('sap/ui/rta/plugin/iframe/AddIFrame',["sap/ui/rta/plugin/BaseCreate","sap/ui/fl/Utils","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/util/uid","sap/ui/core/IconPool","sap/ui/rta/plugin/iframe/AddIFrameDialog"],function(B,F,R,D,u,I,A){"use strict";
function g(s,t,o){var S=!s;var v=this.getCreateAction(S,o,s);var p=this._getParentOverlay(S,o);var d=p.getDesignTimeMetadata();var e=p.getElement();return this._getText(v,e,d,t);}
function a(m,s,d,v){var V=F.getViewForControl(m);var c=V.createId(u());var w;var H;if(s.frameWidth){w=s.frameWidth+s.frameWidthUnit;}else{w="100%";}if(s.frameHeight){H=s.frameHeight+s.frameHeightUnit;}else{H="100%";}return this.getCommandFactory().getCommandFor(m,"addIFrame",{targetAggregation:s.aggregation,baseId:c,index:s.index,url:s.frameUrl,width:w,height:H},d,v);}
function h(s,e){var r=e[0];var i=!s;var o=this.getCreateAction(i,r,s);var p=this._getParentOverlay(i,r);var P=p.getElement();var d=p.getDesignTimeMetadata();var c=0;if(i){var S=r.getElement();var G=d.getAggregation(o.aggregation).getIndex;c=this._determineIndex(P,S,o.aggregation,G);}var v=this.getVariantManagementReference(p);var f=new A();var m={parameters:A.buildUrlBuilderParametersFor(P)};f.open(m).then(function(j){if(!j){return Promise.reject();}j.index=c;j.aggregation=o.aggregation;return a.call(this,P,j,d,v);}.bind(this)).then(function(C){this.fireElementModified({command:C,newControlId:C.getBaseId(),action:o.getCreatedContainerId?o:undefined});}.bind(this)).catch(function(E){if(E){throw D.createError("AddIFrame#handler",E,"sap.ui.rta");}});}
var b=B.extend("sap.ui.rta.plugin.AddIFrame",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
b.prototype.isEnabled=function(s,e){var E=e[0];var S=!s;var o=this.getCreateAction(S,E,s);return this.isActionEnabled(o,S,E);};
b.prototype.getMenuItems=function(e){function c(f){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var j=t.getText("CTX_ADDIFRAME_GROUP");return{text:g.bind(this,f,"CTX_ADDIFRAME"),handler:h.bind(this,f),enabled:this.isEnabled.bind(this,f),isSibling:!f,icon:"sap-icon://tnt/content-enricher",group:j};}I.registerFont({collectionName:"tnt",fontFamily:"SAP-icons-TNT",fontURI:sap.ui.require.toUrl("sap/tnt/themes/base/fonts"),lazy:true});var i=140;var m=[];var d=true;if(this.isAvailable(d,e)){var o=this.getCreateAction(d,e[0]);if(o){var s=Object.assign({id:"CTX_CREATE_SIBLING_IFRAME",rank:i,action:o},c.call(this));m.push(this.enhanceItemWithResponsibleElement(s,e));i+=10;}}d=false;if(this.isAvailable(d,e)){m=m.concat(this.getCreateActions(d,e[0]).map(function(o,f){var p=Object.assign({action:o,id:"CTX_CREATE_CHILD_IFRAME_"+o.aggregation.toUpperCase(),rank:i+10*f},c.call(this,o.aggregation));return this.enhanceItemWithResponsibleElement(p,e);},this));}return m;};
b.prototype.getActionName=function(){return"addIFrame";};
return b;});
sap.ui.predefine('sap/ui/rta/plugin/iframe/AddIFrameDialog',["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/rta/plugin/iframe/AddIFrameDialogController","sap/ui/fl/util/getContainerUserInfo"],function(L,M,F,c,J,R,A,g){"use strict";var V=c.ValueState;var _=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var a="https://help.sap.com/viewer/4fc8d03390c342da8a60f8ee387bca1a/latest/en-US/8db25610e91342919fcf63d4e5868ae9.html";var b=_.getText("IFRAME_ADDIFRAME_DIALOG_URL_WARNING_TEXT")+" ("+"<a href="+a+">"+_.getText("IFRAME_ADDIFRAME_DIALOG_URL_WARNING_LINKTEXT")+"</a>"+")";var d={dialogTitle:_.getText("IFRAME_ADDIFRAME_DIALOG_TITLE"),dialogCreateTitle:_.getText("IFRAME_ADDIFRAME_DIALOG_TITLE"),dialogUpdateTitle:_.getText("IFRAME_ADDIFRAME_DIALOG_UPDATE_TITLE"),sizeTitle:_.getText("IFRAME_ADDIFRAME_DIALOG_SIZE_TITLE"),widthLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_WIDTH_LABEL"),widthUnitLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_WIDTH_UNITLABEL"),heightLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_HEIGHT_LABEL"),heightUnitLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_HEIGHT_UNITLABEL"),percentUseLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PERCENT_USED"),saveText:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SAVE"),cancelText:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_CANCEL"),previewUrlLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PREVIEW_URL_LABEL"),previewUrlMessage:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_PREVIEW_MESSAGE"),previewButtonText:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SHOW_PREVIEW"),showPreviewButton:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SHOW_PREVIEW"),updatePreviewButton:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_UPDATE_PREVIEW"),previewFrameLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PREVIEW_FRAME_LABEL"),parameterSearchLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PARAMETER_SEARCH_LABEL"),editUrlLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_EDIT_URL_LABEL"),parametersLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PARAMETERS_LABEL"),columnParameterLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_TABLE_PARAMETER_LABEL"),columnUiValueLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_TABLE_UI_VALUE_LABEL")};
function e(s){if(s){d.dialogTitle=d.dialogUpdateTitle;}else{d.dialogTitle=d.dialogCreateTitle;}return new J({text:d,section:{visible:false},asNewSection:{value:false},sectionName:{value:"",valueState:V.None},frameWidth:{value:100,valueState:V.None,id:"sapUiRtaAddIFrameDialog_WidthInput"},frameWidthUnit:{value:"%"},frameHeight:{value:100,valueState:V.None,id:"sapUiRtaAddIFrameDialog_HeightInput"},frameHeightUnit:{value:"%"},frameUrl:{value:"",valueState:V.None},previewUrl:{value:""},documentationLink:{HTML:b},parameters:{value:[]},unitsOfMeasure:[{name:"%"},{name:"px"},{name:"rem"}]});}
var f=M.extend("sap.ui.rta.plugin.iframe.AddIFrameDialog",{metadata:{library:"sap.ui.rta",events:{opened:{}}}});
f.prototype.open=function(s){return new Promise(function(r){this._fnResolve=r;this._createDialog(s);}.bind(this));};
f.prototype._createDialog=function(s){var S=false;if(s){S=s.updateMode?s.updateMode:false;}this._oJSONModel=e(S);this._oController=new A(this._oJSONModel,s);F.load({name:"sap.ui.rta.plugin.iframe.AddIFrameDialog",controller:this._oController}).then(function(o){this._oDialog=o;this._oDialog.addStyleClass(R.getRtaStyleClassName());this._oDialog.setModel(this._oJSONModel);this._openDialog();}.bind(this)).catch(function(E){L.error("Error loading fragment sap.ui.rta.plugin.iframe.AddIFrameDialog: ",E);});};
f.prototype._openDialog=function(){this._oDialog.attachAfterOpen(function(){this._disablePanelExpand();this.fireOpened();}.bind(this));this._oDialog.attachAfterClose(function(){this._oDialog.destroy();this._oDialog=null;this._fnResolve(this._oController.getSettings());this._oController=null;}.bind(this));this._oDialog.open();};
f.prototype._disablePanelExpand=function(){var p=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewLinkPanel").getDependents()[0];if(p){p.setEnabled(false);}};
f.buildUrlBuilderParametersFor=function(o){var u=g();var U=Object.keys(u).map(function(s){return{label:s,key:"{$user>/"+s+"}",value:u[s]};});var B=o.getBindingContext();var D;if(B){var h=B.getObject();D=Object.keys(h).filter(function(p){return typeof h[p]!=="object";}).map(function(p){return{label:p,key:"{"+p+"}",value:h[p]};});}else{D=[];}return U.concat(D);};
return f;});
sap.ui.predefine('sap/ui/rta/plugin/iframe/AddIFrameDialogController',["sap/base/Log","sap/ui/core/mvc/Controller","sap/ui/core/library","sap/ui/rta/Utils","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/rta/plugin/iframe/urlCleaner"],function(L,C,c,U,F,a,u){"use strict";var V=c.ValueState;var _=["frameUrl"];var b=["frameWidth","frameHeight"];var d=["asNewSection","frameWidthUnit","frameHeightUnit"];return C.extend("sap.ui.rta.plugin.iframe.AddIFrameDialogController",{constructor:function(j,s){this._oJSONModel=j;this._importSettings(s);this._mParameterHashMap=this._buildParameterHashMap(s);},onValidationSuccess:function(e){e.getSource().setValueState(V.None);this._oJSONModel.setProperty("/areAllFieldsValid",this._areAllTextFieldsValid()&&this._areAllValueStateNones());},onValidationError:function(e){e.getSource().setValueState(V.Error);this._oJSONModel.setProperty("/areAllFieldsValid",false);this._setFocusOnInvalidInput();},onSizeUnitChange:function(){var w=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_WidthUnit").getSelectedKey();var h=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_HeightUnit").getSelectedKey();var i=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PercentText");if(w!=="%"&&h!=="%"){i.addStyleClass("sapUiRtaAddIFrameDialogPercentText-invisible");}else{i.removeStyleClass("sapUiRtaAddIFrameDialogPercentText-invisible");}},onURLChange:function(){var p=this._oJSONModel.getProperty("/previewUrl/value");var f=this._oJSONModel.getProperty("/frameUrl/value");var P=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewButton");if(f===""&&p!==""){var i=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewFrame");i.setUrl("about:blank");this._oJSONModel.setProperty("/previewUrl/value",f);var o=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewLinkPanel");var e=o.getDependents()[0];o.setExpanded(false);e.setEnabled(false);P.setText(this._oJSONModel.getProperty("/text/showPreviewButton"));P.setType("Emphasized");}else if(f!==""&&p!==""){if(f===p){P.setText(this._oJSONModel.getProperty("/text/showPreviewButton"));P.setType("Default");}else{P.setText(this._oJSONModel.getProperty("/text/updatePreviewButton"));P.setType("Emphasized");}}},onSavePress:function(){if(this._areAllTextFieldsValid()&&this._areAllValueStateNones()){this._close(this._buildReturnedSettings());}else{this._setFocusOnInvalidInput();}},onShowPreview:function(e){var s=encodeURI(this._buildPreviewURL(this._buildReturnedURL()));var i=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewFrame");i.setUrl("about:blank");var p=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewLinkPanel");var P=p.getDependents()[0];if(s){P.setEnabled(true);}else{p.setExpanded(false);P.setEnabled(false);}try{this._oJSONModel.setProperty("/previewUrl/value",s);i.setUrl(s);e.getSource().setType("Default");}catch(E){L.error("Error previewing the URL: ",E);}},onParameterPress:function(e){var k=e.getSource().getBindingContext().getObject().key;this._oJSONModel.setProperty("/frameUrl/value",this._addURLParameter(k));},onSearch:function(e){var f=new F("label",a.Contains,e.getParameter("query"));var B=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_ParameterTable").getBinding("items");B.filter([f]);},_buildPreviewURL:function(e){return e.replace(/{(.*?)}/g,function(m){return this._mParameterHashMap[m];}.bind(this));},_addURLParameter:function(p){return this._buildReturnedURL()+p;},_buildReturnedURL:function(){return u(this._oJSONModel.getProperty("/frameUrl/value"));},_buildParameterHashMap:function(p){if(p&&p.parameters){return U.buildHashMapFromArray(p.parameters,"key","value");}return{};},onCancelPress:function(){this._close();},_close:function(s){var A=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog");this._mSettings=s;A.close();},getSettings:function(){return this._mSettings;},_areAllValueStateNones:function(){var D=this._oJSONModel.getData();return _.concat(b).every(function(f){return D[f]["valueState"]===V.None;},this);},_areAllTextFieldsValid:function(){var j=this._oJSONModel;return _.reduce(function(A,f){var v="/"+f+"/value";var s;if(j.getProperty(v).trim()===""){s=V.Error;}else{s=V.None;}j.setProperty(v+"State",s);return A&&s===V.None;},true);},_buildReturnedSettings:function(){var s={};var D=this._oJSONModel.getData();_.concat(b,d).forEach(function(f){var v=D[f].value;if(f==="frameUrl"){v=u(v);}s[f]=v;});return s;},_importSettings:function(s){if(s){Object.keys(s).forEach(function(f){if(f==="frameWidth"||f==="frameHeight"){this._importIFrameSize(f,s[f]);}else{this._oJSONModel.setProperty("/"+f+"/value",s[f]);}},this);}},_importIFrameSize:function(f,s){var r=s.split(/(px|rem|%)/);if(r.length>=2){this._oJSONModel.setProperty("/"+f+"/value",parseFloat(r[0]));this._oJSONModel.setProperty("/"+f+"Unit/value",r[1]);}},_setFocusOnInvalidInput:function(){var D=this._oJSONModel.getData();return b.some(function(f){if(D[f]["valueState"]===V.Error){var e=sap.ui.getCore().byId(D[f]["id"]);e.focus();return true;}},this);}});});
sap.ui.predefine('sap/ui/rta/plugin/iframe/urlCleaner',[],function(){"use strict";return function(u){return u.replace(/\t|\r|\n/g,"");};});
sap.ui.predefine('sap/ui/rta/service/Action',["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/restricted/_castArray","sap/base/util/restricted/_pick"],function(O,D,_,a){"use strict";return function(r){function i(v,o){return typeof v==='function'?v(o):v;}function g(E){var m=r._oDesignTime.getPlugins().map(function(p){return p.getMenuItems(E);});return Promise.all(m).then(function(M){return M.reduce(function(R,M){return M?R.concat(M):R;},[]).map(function(c){return Object.assign({},c,{enabled:i(c.enabled,E),text:i(c.text,E[0])});});});}function b(c){var C=_(c);var E=C.map(function(s){var o=O.getOverlay(s);if(!o){throw new Error(D.printf('Control with id="{0}" is not under the one of root elements or ignored.',s));}return o;});return g(E).then(function(m){return m.map(function(M){return a(M,['id','icon','rank','group','enabled','text']);});});}function e(c,A){var C=_(c);var E=C.map(function(s){var o=O.getOverlay(s);if(!o){throw new Error(D.printf('Control with id="{0}" is not under the one of root elements or ignored.',s));}return o;});return g(E).then(function(d){var m=d.filter(function(m){return m.id===A;}).pop();if(!m){throw new Error('No action found by specified ID');}else{return m.handler(E,{});}});}return{exports:{get:b,execute:e}};};});
sap.ui.predefine('sap/ui/rta/service/ControllerExtension',["sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/thirdparty/jquery"],function(D,O,F,C,P,q){"use strict";return function(r){function m(p){return new Promise(function(a,b){var u;q.ajax({url:u=sap.ui.require.toUrl(p)+".js",async:true,success:function(d){a(d);},error:function(x,t,e){var E=new Error("resource "+p+" could not be loaded from "+u+". Check for 'file not found' or parse errors. Reason: "+e);E.status=t;E.error=e;E.statusCode=x.status;b(e);},dataType:"text"});});}return{exports:{add:function(c,v){var f=r.getFlexSettings();if(!f.developerMode){throw D.createError("service.ControllerExtension#add","code extensions can only be created in developer mode","sap.ui.rta");}if(!c){throw D.createError("service.ControllerExtension#add","can't create controller extension without codeRef","sap.ui.rta");}if(!c.endsWith(".js")){throw D.createError("service.ControllerExtension#add","codeRef has to end with 'js'");}var V=sap.ui.getCore().byId(v);var a=F.getAppComponentForControl(V);var s=V.getControllerName&&V.getControllerName()||V.getController()&&V.getController().getMetadata().getName();var R=F.getComponentClassName(a);var M=R.replace(/\.Component/g,"").replace(/\./g,"/");M+="/changes/";M+=c.replace(/\.js/g,"");var o={content:{codeRef:c},selector:{controllerName:s},changeType:"codeExt",namespace:f.namespace,developerMode:f.developerMode,scenario:f.scenario,moduleName:M};var p=C.create({changeSpecificData:o,selector:a});P.add({change:p,selector:a});return p.getDefinition();},getTemplate:function(v){var V=O.getOverlay(v);if(!V){throw D.createError("service.ControllerExtension#getTemplate","no overlay found for the given view ID","sap.ui.rta");}var c=V.getDesignTimeMetadata().getControllerExtensionTemplate();return m(c+"-dbg").catch(function(){return m(c);});}}};};});
sap.ui.predefine('sap/ui/rta/service/Outline',["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/Util","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit"],function(O,E,A,D,a,d,i,m,_){"use strict";return function(r,p){var o={};o.mExtensionPointMetadata={palette:{icons:{svg:"sap/ui/core/designtime/Icon.icon.svg"}}};o._getOutline=function(I,b){var R;if(!b&&D.isInteger(I)){b=I;I=undefined;}var c=[];if(!I){c=r._oDesignTime.getRootElements().map(function(s){return O.getOverlay(s);});}else{var P=O.getOverlay(I);if(!P){throw D.createError("services.Outline#get","Cannot find element with id= "+I+". A valid or empty value for the initial element id should be provided.","sap.ui.rta");}c.push(P);}R=c.map(function(e){return this._getChildrenNodes(e,b);},this);return R;};o._getExtensionPoints=function(b){var P=b.id;var s=b.technicalName;return a.getExtensionPointInfoByParentId({parentId:P}).filter(function(e){return e.aggregationName===s;});};o._getExtensionPointData=function(e){return{id:e.targetControl.getId(),name:e.name,technicalName:"sap.ui.extensionpoint",type:"extensionPoint",icon:this.mExtensionPointMetadata.palette.icons.svg,extensionPointInfo:{defaultContent:e.defaultContent.map(function(c){return c.getId();})}};};o._enrichExtensionPointData=function(b){var I=sap.ui.getCore().getConfiguration().getDesignMode();if(b.type==="aggregation"&&I){var e=this._getExtensionPoints(b).sort(function(c,f){return f.index-c.index;});e.forEach(function(c){var f=this._getExtensionPointData(c);b.elements.splice(c.index,0,f);}.bind(this));}};o._getChildrenNodes=function(b,c,P){var v=D.isInteger(c);if(b.getShouldBeDestroyed()){return{};}var e=this._getNodeProperties(b,P)||{};var C=b.getChildren();if((!v||(v&&c>0))&&C.length>0&&!i(e)){c=v?c-1:c;e.elements=C.map(function(f){return this._getChildrenNodes(f,c,f.getParent());},this).filter(function(f){return!i(f);});this._enrichExtensionPointData(e);}return e;};o._getNodeProperties=function(b,P){var c;var s;var t;var v;var I=false;var e=b.getElement();var f=e.getId();var g=e.getMetadata().getName();var h=b.getDesignTimeMetadata();var j=h.getData();var k=h.getLabel(e);var l=(j.palette&&j.palette.icons&&j.palette.icons.svg||undefined);if(b instanceof E){t="element";I=b.getEditable();c=h.getName(e);v=b.isVisible();}else{t="aggregation";s=b.getAggregationName();c=P.getAggregation(s)?P.getDesignTimeMetadata().getAggregationDescription(s,e):undefined;}var n=Object.assign({id:f,technicalName:s||g,editable:I,type:t},k!==f&&k!==undefined&&{instanceName:k},c&&c.singular&&{name:c.singular},l!==undefined&&{icon:l},typeof v==="boolean"&&{visible:v});return n;};o._removeDuplicate=function(R,b){return R.filter(function(u){return!d(b,u,Infinity);});};o._updatesHandler=function(e){var P=e.getParameters();if(this.sStatus==="initial"){this.aUpdates=[];}var R=m({},P);var s=R.id?O.getOverlay(R.id).getElement().getId():undefined;var t=R.targetId?O.getOverlay(R.targetId).getElement().getId():undefined;switch(e.getId()){case"elementOverlayCreated":if(P.elementOverlay.isRoot()){var b=P.elementOverlay.getElement().getId();R.element=o._getOutline(b)[0];R.type="new";break;}return;case"elementOverlayAdded":R.element=o._getOutline(s)[0];R.targetId=t;R.type="new";break;case"elementOverlayMoved":R.element=o._getOutline(s,0)[0];R.targetId=t;R.type="move";break;case"elementOverlayDestroyed":var c=R.elementOverlay.getParentAggregationOverlay();if((c instanceof A&&!c._bIsBeingDestroyed)||R.elementOverlay.isRoot()){R.element={};R.element.id=R.elementOverlay.getElement()?R.elementOverlay.getElement().getId():R.elementOverlay.getAssociation("element");R.type="destroy";break;}return;case"elementOverlayEditableChanged":R.element={id:s,editable:R.editable};R.type="editableChange";break;case"elementPropertyChanged":R.element=o._getOutline(s,0)[0];R.type="elementPropertyChange";break;}R=_(R,["elementOverlay","editable","target","id","elementId"]);this.aUpdates=o._removeDuplicate(this.aUpdates,R);this.aUpdates.push(R);if(this.sStatus==="initial"){setTimeout(function(){if(Array.isArray(this.aUpdates)&&this.aUpdates.length>0){this.sStatus="initial";p("update",this.aUpdates);}}.bind(o),200);}this.sStatus="processing";};o.destroy=function(){r._oDesignTime.detachEvent("elementOverlayCreated",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayAdded",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayMoved",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayDestroyed",this._updatesHandler,this);r._oDesignTime.detachEvent("elementPropertyChanged",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayEditableChanged",this._updatesHandler,this);delete this.aUpdates;delete this.sStatus;};o.aUpdates=[];o.sStatus="initial";r._oDesignTime.attachEvent("elementOverlayCreated",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayAdded",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayMoved",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayDestroyed",o._updatesHandler,o);r._oDesignTime.attachEvent("elementPropertyChanged",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayEditableChanged",o._updatesHandler,o);return{events:["update"],exports:{get:o._getOutline.bind(o)},destroy:o.destroy.bind(o)};};});
sap.ui.predefine('sap/ui/rta/service/Property',["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit"],function(O,D,i,m,_){"use strict";var a="[NOT SERIALIZABLE]";
function b(p,I,P){if(Object(p)!==p){return true;}if(typeof p==="function"){return false;}if(typeof p==="object"){if(Array.isArray(p)){return p.every(b);}else if(p instanceof Map){var M={};p.forEach(function(V,k){M[k]=V;});if(P){P[I]=M;}p=M;}return Object.keys(p).every(function(k){return b(p[k],k,p);});}return false;}
function v(p){return b(p)?p:a;}
return function(){var p={};p._getDesignTimeProperties=function(c){var o=O.getOverlay(c);if(!o){return D.createError("service.Property#get","A valid control id was not passed","sap.ui.rta");}var e=o.getElement();var M=e.getMetadata().getAllProperties();var d=o.getDesignTimeMetadata();var f=m({},d.getData());var g=f.properties||{};var h=f.annotations||{};var l=f.getLabel;return Promise.all([p._getConsolidatedAnnotations(h,e),p._getConsolidatedProperties(g||{},M,e),p._getResolvedFunction(l,e),p._getResolvedLinks(f.links,e)]).then(function(P){return Object.assign({},P[0]&&!i(P[0])&&{annotations:P[0]},P[1]&&{properties:P[1]},P[2]&&{label:v(P[2])},f.name&&{name:d.getName(e)},!i(P[3])&&{links:P[3]});});};p._getConsolidatedProperties=function(d,M,e){var f=Object.keys(M).reduce(function(F,k){F[k]={value:v(e.getProperty(k)),virtual:false,type:M[k].type,name:M[k].name,ignore:false,group:M[k].group,deprecated:M[k].deprecated,defaultValue:M[k].defaultValue,visibility:M[k].visibility};var B=p._getBindingInfo(k,e);Object.assign(F[k],B&&{binding:B});return F;},{});return p._getResolvedFunction(d,e).then(function(c){return Promise.all(Object.keys(c).map(function(k){return p._getResolvedFunction(c[k].ignore,e).then(function(I){if(typeof I!=="boolean"){throw D.createError("services.Property#get","Invalid ignore property value found in designtime for element with id "+e.getId()+" .","sap.ui.rta");}var r={};if(!f[k]){if(c[k].virtual===true){r=p._getEvaluatedVirtualProperty(c,k,e,I);}else{r[k]={value:v(_(c[k],"ignore")),virtual:false,ignore:I};}}else{r[k]={ignore:I};}return r;});}));}).then(function(F){return F.reduce(function(c,o){return m(c,o);},f);});};p._getEvaluatedVirtualProperty=function(d,P,e,I){var E={};E[P]={value:v(d[P].get(e)),virtual:true,type:d[P].type,name:d[P].name,group:d[P].group,ignore:I};var B=p._getBindingInfo(P,e);return p._getResolvedFunction(d[P].possibleValues,e).then(function(c){Object.assign(E[P],B&&{binding:B},c&&{possibleValues:v(c)},typeof d[P].nullable==="boolean"&&{nullable:d[P].nullable});return E;});};p._getConsolidatedAnnotations=function(d,e){return Promise.all(Object.keys(d).map(function(k){return p._getResolvedFunction(d[k].ignore,e).then(function(I){var f={};if(typeof I!=="boolean"&&typeof I!=="undefined"){throw D.createError("services.Property#get","Invalid ignore property value found in designtime for element with id "+e.getId()+" .","sap.ui.rta");}d[k].ignore=I;if(!I){f[k]=Object.assign({},d[k]);return p._getResolvedLinks(f[k].links,e).then(function(l){if(!i(l)){f[k].links=l;}return f;});}});})).then(function(f){return f.reduce(function(c,F){return Object.assign(c,F);},{});});};p._getResolvedLinks=function(l,e){var t=[];var r=Object.assign({},l);Object.keys(r).forEach(function(L){if(Array.isArray(r[L])){r[L].forEach(function(o){t.push(D.wrapIntoPromise(function(){if(typeof o.text==="function"){return o.text(e);}})(o).then(function(s){o.text=v(s||o.text);}));});}});return Promise.all(t).then(function(){return r;});};p._getBindingInfo=function(k,e){var P=e.getBindingInfo(k);if(!P){return;}return m({},P.parts&&{parts:P.parts},P.binding&&{bindingValues:{values:P.binding.getValue()}},P.binding&&P.binding.getOriginalValue&&{bindingValues:{originalValues:P.binding.getOriginalValue()}},P.bindingString&&{bindingString:P.bindingString});};p._getResolvedFunction=function(P,e){return D.wrapIntoPromise(function(){return typeof P==="function"?(P(e)||false):(P||false);})(P,e);};return{exports:{get:p._getDesignTimeProperties.bind(p)}};};});
sap.ui.predefine('sap/ui/rta/service/Receiver',["sap/ui/core/postmessage/Bus","sap/ui/dt/Util","sap/base/util/uid"],function(P,D,u){"use strict";var C='sap.ui.rta.service.receiver';var p;return function(r){var e={};var R=function(E){var d=E.data;var m=d.body;switch(E.eventId){case"getService":var s=m.arguments[0];r.getService(s).then(function(S){var a={};var M=[];Object.keys(S).forEach(function(k){if(typeof S[k]==='function'){if(!/^(at|de)tach/.test(k)){M.push(k);}}else{a[k]=S[k];}});p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"getService",data:{id:d.id,type:"response",body:{methods:M,properties:a,events:r._mServices[s].service.events}}});});break;case'callMethod':r.getService(m.service).then(function(S){S[m.method].apply(null,m.arguments).then(function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'callMethod',data:{type:'response',status:'success',id:d.id,body:v}});});}).catch(function(v){var o=D.propagateError(v,"service.Receiver",D.printf("Can't execute method {0} of service {1} due unexpected error.",m.method,m.service),"sap.ui.rta");p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"callMethod",data:{type:"response",status:"error",id:d.id,body:o.toString()}});});break;case'subscribe':r.getService(m.service).then(function(S){var h=function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'event',data:{body:{service:m.service,event:m.event,data:v}}});};var H=u();e[H]=h;S.attachEvent(m.event,h);p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'subscribe',data:{type:'response',status:'success',id:d.id,body:{id:H}}});});break;case'unsubscribe':r.getService(m.service).then(function(S){S.detachEvent(m.event,e[m.id]);delete e[m.id];p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'unsubscribe',data:{type:'response',status:'success',id:d.id}});});break;}};p=P.getInstance();p.publish({channelId:C,eventId:P.event.READY});p.subscribe(C,"getService",R);p.subscribe(C,"callMethod",R);p.subscribe(C,"subscribe",R);p.subscribe(C,"unsubscribe",R);return{destroy:function(){if(p){p.unsubscribe(C,"getService",R);p.unsubscribe(C,"callMethod",R);p.unsubscribe(C,"subscribe",R);p.unsubscribe(C,"unsubscribe",R);}}};};});
sap.ui.predefine('sap/ui/rta/service/Selection',function(){"use strict";return function(r,p){var s=r._oDesignTime.getSelectionManager();function g(e){return e.map(function(E){return E.getElement().getId();});}s.attachEvent("change",function(e){p("change",g(e.getParameter("selection")));});return{events:["change"],exports:{get:function(){return g(s.get());},set:s.set.bind(s),add:s.add.bind(s),remove:s.remove.bind(s),reset:s.reset.bind(s)}};};});
sap.ui.predefine('sap/ui/rta/service/index',function(){"use strict";return Object.freeze({selection:'sap.ui.rta.service.Selection',receiver:'sap.ui.rta.service.Receiver',controllerExtension:'sap.ui.rta.service.ControllerExtension',outline:'sap.ui.rta.service.Outline',action:'sap.ui.rta.service.Action',property:'sap.ui.rta.service.Property'});});
sap.ui.predefine('sap/ui/rta/toolbar/Adaptation',["sap/ui/core/Fragment","sap/ui/core/format/DateFormat","sap/ui/Device","./Base","sap/ui/core/library","sap/ui/fl/library","sap/ui/rta/toolbar/ChangeVisualization","sap/ui/rta/Utils"],function(F,D,a,B,c,f,C,U){"use strict";var M=c.MessageType;var V=f.Versions;
var A=B.extend("sap.ui.rta.toolbar.Adaptation",{
renderer:"sap.ui.rta.toolbar.AdaptationRenderer",
animation:true,
metadata:{library:"sap.ui.rta",events:{undo:{},redo:{},exit:{},restore:{},transport:{},modeChange:{},manageApps:{},appVariantOverview:{},saveAs:{},activate:{},discardDraft:{},switchVersion:{}}}
});
A.modes={MOBILE:"sapUiRtaToolbarMobile",TABLET:"sapUiRtaToolbarTablet",DESKTOP:"sapUiRtaToolbarDesktop"};var b="sapUiRtaToolbar";var d="sapUiRtaDraftVersionAccent";var e="sapUiRtaActiveVersionAccent";
A.prototype.init=function(){a.media.attachHandler(this._onSizeChanged,this,b);this._pFragmentLoaded=B.prototype.init.apply(this,arguments);C.changesPopover=undefined;};
A.prototype.onBeforeRendering=function(){if(!a.media.hasRangeSet(b)){a.media.initRangeSet(b,[900,1200],"px",[A.modes.MOBILE,A.modes.TABLET,A.modes.DESKTOP]);}this._onSizeChanged(a.media.getCurrentRange(b));B.prototype.onBeforeRendering.apply(this,arguments);};
A.prototype.onFragmentLoaded=function(){return this._pFragmentLoaded;};
A.prototype.exit=function(){C.removeChangeIndicators();a.media.detachHandler(this._onSizeChanged,this,b);B.prototype.exit.apply(this,arguments);};
function _(s,I,t,T){var o=this.getControl(s);var j=t?this.getTextResources().getText(t):"";var k=T?this.getTextResources().getText(T):"";o.setText(j||"");o.setTooltip(k||"");o.setIcon(I||"");}
A.prototype.formatDiscardDraftEnabled=function(n){return n===sap.ui.fl.Versions.Draft;};
A.prototype.formatVersionButtonText=function(v,n){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var T="";var s="Active";v=v||[];if(n===undefined||n===V.Original){T=t.getText("TIT_ORIGINAL_APP");s="inactive";if(v.length===0||(v.length===1&&v[0].type==="draft")){s="active";}}else{var o=v.find(function(j){return j.version===n;});if(o){s=o.type;if(n===V.Draft){T=t.getText("TIT_DRAFT");}else{T=o.title||t.getText("TIT_VERSION_1");}}}this.setVersionButtonAccentColor(s);return T;};
A.prototype.formatVersionTableVisibility=function(n){return n>0;};
A.prototype.formatVersionTitle=function(t,T){var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(T==="draft"){return o.getText("TIT_DRAFT");}return t||o.getText("TIT_VERSION_1");};
A.prototype.formatVersionTimeStamp=function(t){if(!t){return"";}return D.getInstance({format:"yMMMdjm"}).format(new Date(t));};
A.prototype.formatHighlight=function(t){switch(t){case"draft":return M.Warning;case"active":return M.Success;default:return M.None;}};
A.prototype.formatHighlightText=function(t){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");switch(t){case"draft":return T.getText("TIT_DRAFT");case"active":return T.getText("LBL_ACTIVE");default:return T.getText("LBL_INACTIVE");}};
function g(v){return v.some(function(o){return o.type==="active";});}
A.prototype.formatOriginalAppHighlight=function(v){return g(v)?M.None:M.Success;};
A.prototype.formatOriginalAppHighlightText=function(v){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return g(v)?t.getText("LBL_INACTIVE"):t.getText("LBL_ACTIVE");};
A.prototype.versionSelected=function(E){var v=E.getSource().getBindingContext("versions");var n=V.Original;if(v){n=v.getProperty("version");}this.fireEvent("switchVersion",{version:n});};
A.prototype.showChangesPopover=function(E){if(C.changeIndicatorsExist()){C.removeChangeIndicators();C.switchChangeVisualizationActive();return Promise.resolve();}if(this.getModel("controls").getProperty("/modeSwitcher")==="adaptation"){var o=E.getSource();var r=this.getModel("controls").getProperty("/rtaRootControlId");return C.openChangePopover(o,r).then(function(p){if(p){o.addDependent(p);}});}return Promise.resolve();};
A.prototype.showVersionHistory=function(E){var v=E.getSource();if(!this.oVersionDialogPromise){this.oVersionDialogPromise=F.load({name:"sap.ui.rta.toolbar.VersionHistory",id:this.getId()+"_versionHistoryDialog",controller:{formatVersionTitle:this.formatVersionTitle.bind(this),formatVersionTimeStamp:this.formatVersionTimeStamp.bind(this),formatVersionTableVisibility:this.formatVersionTableVisibility.bind(this),formatHighlight:this.formatHighlight.bind(this),formatHighlightText:this.formatHighlightText.bind(this),formatOriginalAppHighlight:this.formatOriginalAppHighlight.bind(this),formatOriginalAppHighlightText:this.formatOriginalAppHighlightText.bind(this),versionSelected:this.versionSelected.bind(this)}}).then(function(o){v.addDependent(o);return o;});}return this.oVersionDialogPromise.then(function(o){if(!o.isOpen()){o.openBy(v);}else{o.close();}});};
A.prototype.showRestore=function(v){return!v;};
A.prototype._showButtonIcon=function(s,I,t){_.call(this,s,I,"",t);};
A.prototype._showButtonText=function(s,t){_.call(this,s,"",t,"");};
A.prototype._switchToIcons=function(){var I=this.getControl("iconBox");var o=this.getControl("iconSpacer");I.setVisible(false);o.setVisible(false);this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("exit","sap-icon://decline","BTN_EXIT");};
A.prototype._switchToTexts=function(){var I=this.getControl("iconBox");var o=this.getControl("iconSpacer");I.setVisible(true);o.setVisible(true);this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("exit","BTN_EXIT");};
A.prototype._onSizeChanged=function(p){if(!p){return Promise.resolve();}return this.onFragmentLoaded().then(function(){var m=p.name;this.sMode=m;switch(m){case A.modes.MOBILE:this._switchToIcons();break;case A.modes.TABLET:case A.modes.DESKTOP:this._switchToTexts();break;default:}}.bind(this));};
A.prototype.buildControls=function(){return F.load({name:"sap.ui.rta.toolbar.Adaptation",id:this.getId()+"_fragment",controller:{activate:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),formatDiscardDraftEnabled:this.formatDiscardDraftEnabled.bind(this),modeChange:this.eventHandler.bind(this,"ModeChange"),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),showChangesPopover:this.showChangesPopover.bind(this),manageApps:this.eventHandler.bind(this,"ManageApps"),appVariantOverview:this.eventHandler.bind(this,"AppVariantOverview"),restore:this.eventHandler.bind(this,"Restore"),publish:this.eventHandler.bind(this,"Transport"),saveAs:this.eventHandler.bind(this,"SaveAs"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this),showRestore:this.showRestore.bind(this)}});};
function h(){this.getControl("versionTitleInput").setValue("");this.getControl("confirmVersionTitleButton").setEnabled(false);return Promise.resolve(this._oDialog);}
function i(){return F.load({name:"sap.ui.rta.toolbar.VersionTitleDialog",id:this.getId()+"_fragment",controller:{onConfirmVersioningDialog:function(){var v=this.getControl("versionTitleInput").getValue();this.fireEvent("activate",{versionTitle:v});this._oDialog.close();}.bind(this),onCancelVersioningDialog:function(){this._oDialog.close();}.bind(this),onVersionTitleLiveChange:function(E){var v=E.getParameter("value");this.getControl("confirmVersionTitleButton").setEnabled(!!v);}.bind(this)}}).then(function(o){this._oDialog=o;o.addStyleClass(U.getRtaStyleClassName());this.addDependent(this._oDialog);}.bind(this));}
A.prototype.getControl=function(n){return sap.ui.getCore().byId(this.getId()+"_fragment--sapUiRta_"+n);};
A.prototype._openVersionTitleDialog=function(n){var o;if(this._oDialog){o=h.call(this);}else{o=i.call(this);}return o.then(function(){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var T=t.getText("TIT_VERSION_TITLE_DIALOG");if(n!==V.Draft){T=t.getText("TIT_REACTIVATE_VERSION_TITLE_DIALOG");}this._oDialog.setTitle(T);return this._oDialog.open();}.bind(this));};
A.prototype.setVersionButtonAccentColor=function(t){var v=this.getControl("versionButton");switch(t){case"draft":v.addStyleClass(d);v.removeStyleClass(e);break;case"active":v.addStyleClass(e);v.removeStyleClass(d);break;default:v.removeStyleClass(e);v.removeStyleClass(d);}};
A.prototype.show=function(){return B.prototype.show.apply(this,arguments);};
A.prototype.hide=function(){return B.prototype.hide.apply(this,arguments);};
return A;},true);
sap.ui.predefine('sap/ui/rta/toolbar/AdaptationRenderer',['./BaseRenderer'],function(B){"use strict";
var A=B.extend('sap.ui.rta.toolbar.AdaptationRenderer');
A.render=function(r,c){r.addClass('sapUiRtaToolbarAdaptation');B.render(r,c);};
return A;});
sap.ui.predefine('sap/ui/rta/toolbar/Base',["sap/ui/model/resource/ResourceModel","sap/m/HBox","sap/ui/rta/util/Animation","sap/ui/dt/util/ZIndexManager"],function(R,H,A,Z){"use strict";
var B=H.extend("sap.ui.rta.toolbar.Base",{
metadata:{library:"sap.ui.rta",properties:{color:{type:"string",defaultValue:"default"},zIndex:{type:"int"},textResources:"object"}},
constructor:function(){H.apply(this,arguments);this.setAlignItems("Center");this.setVisible(false);this.placeToContainer();},
type:null,
animation:false
});
B.prototype.init=function(){this._oResourceModel=new R({bundle:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta")});H.prototype.init.apply(this,arguments);this.setModel(this._oResourceModel,"i18n");return this.buildContent();};
B.prototype.setTextResources=function(t){this.setProperty("textResources",t);this._oResourceModel=new R({bundle:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta")});};
B.prototype.onFragmentLoaded=function(){return Promise.resolve();};
B.prototype.eventHandler=function(e,E){this['fire'+e](E.getParameters());};
B.prototype.buildControls=function(){return Promise.resolve([]);};
B.prototype.placeToContainer=function(){this.placeAt(sap.ui.getCore().getStaticAreaRef());};
B.prototype.buildContent=function(){return this.buildControls().then(function(c){c.forEach(this.addItem,this);}.bind(this));};
B.prototype.show=function(){return new Promise(function(r){var d={onAfterRendering:function(){this.removeEventDelegate(d);r();}};this.addEventDelegate(d,this);this.bringToFront();this.setVisible(true);}.bind(this)).then(function(){return this.animation?A.waitTransition(this.$(),this.addStyleClass.bind(this,'is_visible')):Promise.resolve();}.bind(this)).then(function(){this.focus();}.bind(this));};
B.prototype.hide=function(){return(this.animation?A.waitTransition(this.$(),this.removeStyleClass.bind(this,'is_visible')):Promise.resolve()).then(function(){this.setVisible(false);}.bind(this));};
B.prototype.getControl=function(n){return sap.ui.getCore().byId("sapUiRta_"+n);};
B.prototype.bringToFront=function(){this.setZIndex(Z.getNextZIndex());};
return B;},true);
sap.ui.predefine('sap/ui/rta/toolbar/BaseRenderer',["sap/ui/core/Renderer","sap/m/HBoxRenderer"],function(R,H){"use strict";var B=R.extend.call(H,'sap.ui.rta.toolbar.BaseRenderer');
B.render=function(r,c){r.addClass('sapUiRtaToolbar');r.addClass("color_"+c.getColor());c.type&&r.addClass("type_"+c.type);var z=c.getZIndex();z&&r.addStyle("z-index",z);H.render(r,c);};
return B;});
sap.ui.predefine('sap/ui/rta/toolbar/ChangeIndicator',["sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/core/Control","sap/m/Text","sap/ui/core/format/DateFormat","sap/ui/core/Icon","sap/ui/dt/OverlayRegistry"],function(F,J,C,T,D,I,O){"use strict";return C.extend("sap.ui.rta.toolbar.ChangeIndicator",{metadata:{properties:{mode:{type:"string",defaultValue:"change"},parentId:{type:"string",defaultValue:""},changes:{type:"any",defaultValue:""}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},defaultAggregation:"content"},init:function(){this.setAggregation("_text",new T({text:this.getChanges().length}).addStyleClass("sapUiRtaChangeIndicatorText"));this.setAggregation("_icon",new I({src:"sap-icon://display",visible:false}).addStyleClass("sapUiRtaChangeIndicatorIcon"));},addChange:function(c){this.getChanges().push(c);this.getAggregation("_text").setText(this.getChanges().length);},renderer:{apiVersion:2,render:function(r,c){r.openStart("div",c);r.class("sapUiRtaChangeIndicator");r.class("sapUiRtaChangeIndicator-"+c.getMode());r.openEnd();r.openStart("div");r.openEnd();r.renderControl(c.getAggregation("_icon"));if(c.getChanges().length>1){r.renderControl(c.getAggregation("_text"));}r.close("div");r.close("div");}},onAfterRendering:function(){var e=document.getElementById(this.sId);var p=document.getElementById(this.getParentId());p.appendChild(e);var h=p.offsetHeight;if(h>50){h=50;}h-=2;e.style.width=h+"px";e.style.height=h+"px";if(this.getAggregation("_text").getDomRef()){this.getAggregation("_text").getDomRef().style.fontSize=(h/3)+"px";if(h<25){this.getAggregation("_text").getDomRef().style.height=h+"px";this.getAggregation("_text").getDomRef().style.width=h+"px";this.getAggregation("_text").getDomRef().style.fontSize=(h-2)+"px";}}if(this.getAggregation("_icon").getDomRef()){this.getAggregation("_icon").getDomRef().style.fontSize=(h*0.5)+"px";}this.attachBrowserEvent("click",function(E){E.stopPropagation();this.openDetailPopover();});},remove:function(){this.removeDependentElements();var p="";if(!document.getElementById(this.sId)){p="sap-ui-invisible-";}var n=document.getElementById(p+this.sId);n.parentNode.removeChild(n);},hide:function(){this.setVisible(false);},reveal:function(){this.setVisible(true);},showDependentElements:function(e){this.detachBrowserEvent("click",this.openDetailPopover);this.getAggregation("_icon").setVisible(true);this.getAggregation("_text").setVisible(false);this.hideChangeIndicators();this.reveal();this.getAggregation("_popover").close();this.addStyleClass("sapUiRtaChangeIndicator-change-solid");this.aDependentElementsChangeIndicators=[];var c;if(this.getChanges().length>1){var b=e.getSource().getBindingContext("changesModel");c=b.getModel().getProperty(b.getPath()).change;}else{c=this.getChanges()[0];}this.getChangedElements(c,true).then(function(a){a.forEach(function(o){var d=this.createChangeIndicator(c,o,"dependent");if(d&&d.getParentId()!==this.getParentId()){this.aDependentElementsChangeIndicators.push(d);this.getParent().addContent(d);}}.bind(this));this.attachBrowserEvent("click",this.hideDependentElements);}.bind(this));},removeDependentElements:function(){if(this.aDependentElementsChangeIndicators){this.aDependentElementsChangeIndicators.forEach(function(c){c.remove();c.destroy();});}this.aDependentElementsChangeIndicators=[];},hideDependentElements:function(){this.detachBrowserEvent("click",this.hideDependentElements);this.removeDependentElements();this.revealChangeIndicators();this.getAggregation("_popover").openBy(this);this.getAggregation("_icon").setVisible(false);this.getAggregation("_text").setVisible(true);this.removeStyleClass("sapUiRtaChangeIndicator-change-solid");this.attachBrowserEvent("click",this.click);},getChangesModelItem:function(c){return this.getChangedElements(c,false).then(function(a){var o=a[0];var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var s=c.getDefinition().support.command;var m=this.getMode();var d;var e=(s).charAt(0).toUpperCase()+(s).slice(1);var f;var E=false;var g=" ";var h=O.getOverlay(o);if(h){g="'"+h.getDesignTimeMetadata().getLabel(o)+"'";}d=b.getText("TXT_CHANGEVISUALIZATION_"+m.toUpperCase()+"_"+s.toUpperCase(),g);f=D.getDateTimeInstance().format(new Date(c.getCreation()));E=(m==="change"&&(s==="move"||s==="split"));var i={change:c,changeTitle:e,description:d,date:f,enableDetailButton:E};return i;}.bind(this));},openDetailPopover:function(){var c={changes:[]};var p=[];this.getChanges().forEach(function(o){p.push(this.getChangesModelItem(o));}.bind(this));Promise.all(p).then(function(r){r.forEach(function(i){c.changes.push(i);});if(!this.getAggregation("_popover")){var f="sap.ui.rta.toolbar.ChangeIndicatorPopover";if(c.changes.length===1){f="sap.ui.rta.toolbar.SingleChangeIndicatorPopover";}F.load({name:f,id:this.getId()+"_fragment",controller:this}).then(function(a){var m=new J(c);a.setModel(m,"changesModel");this.setAggregation("_popover",a);this.getAggregation("_popover").openBy(this);}.bind(this));}else{this.getAggregation("_popover").openBy(this);}}.bind(this));}});});
sap.ui.predefine('sap/ui/rta/toolbar/ChangeVisualization',["sap/ui/core/Fragment","sap/ui/thirdparty/jquery","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/rta/toolbar/ChangeIndicator","sap/ui/dt/OverlayRegistry","sap/ui/core/Component","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/Utils","sap/m/library","sap/ui/fl/Layer","sap/base/util/each","sap/base/util/includes"],function(F,q,P,a,J,C,O,b,c,d,m,L,e,f){"use strict";var B=m.ButtonType;var g={changes:[],changeIndicators:[],rootControlId:""};
g.updateCommandModel=function(){g.aValidCommands={all:["createContainer","addDelegateProperty","reveal","addIFrame","move","rename","combine","split","remove"],add:["createContainer","addDelegateProperty","reveal","addIFrame"],move:["move"],rename:["rename"],combinesplit:["combine","split"],remove:["remove"]};var o={commands:[]};var h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");e(g.aValidCommands,function(k,v){o.commands.push({commands:v,text:h.getText("TXT_CHANGEVISUALIZATION_OVERVIEW_"+k.toUpperCase()),count:0,type:"Inactive"});});g.changes.forEach(function(j){var s=j.getDefinition().support.command;if(s!==""){e(g.aValidCommands,function(k,v){var I=v.indexOf(s);if(I>-1){var i=Object.keys(g.aValidCommands).indexOf(k);o.commands[i].count++;o.commands[i].type="Active";}});}});var M=new J(o);g.changesPopover.setModel(M,"commandModel");};
g.removeChangeIndicators=function(){if(g.button&&g.changeIndicators){g.changeIndicators.forEach(function(o){o.changeIndicator.remove();o.changeIndicator.destroy();});g.switchChangeVisualizationActive();}g.changeIndicators=[];};
g.hideChangeIndicators=function(){if(g.changeIndicators){g.changeIndicators.forEach(function(o){o.changeIndicator.hide();});}};
g.revealChangeIndicators=function(){if(g.changeIndicators){g.changeIndicators.forEach(function(o){o.changeIndicator.reveal();});}};
g.changeIndicatorsExist=function(){return g.changeIndicators.length>0;};
g.switchChangeVisualizationActive=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(g.changeIndicators.length>0){g.button.setType(B.Emphasized);g.button.setTooltip(o.getText("BUT_CHANGEVISUALIZATION_HIDECHANGES"));q("body").on("keydown",function(E){if(E.key==="Escape"){g.removeChangeIndicators();}});}else{g.button.setType(B.Transparent);g.button.setTooltip(o.getText("BUT_CHANGEVISUALIZATION_SHOWCHANGES"));q("body").off("keydown");}};
g.showSpecificChanges=function(E){g.changesPopover.close();var o=E.getSource().getBindingContext("commandModel");var h=o.getModel().getProperty(o.getPath()).commands;g.changes.forEach(function(i){var s=i.getDefinition().support.command;if(f(h,s)){g.getChangedElements(i,false).then(function(j){j.forEach(function(k){var l=g.createChangeIndicator(i,k,"change");if(l!==null){g.changeIndicators.push({elementId:l.getParentId(),changeIndicator:l});l.placeAt(sap.ui.getCore().getStaticAreaRef());}});g.switchChangeVisualizationActive();});}});};
g.createChangeIndicator=function(o,h,s){var j=O.getOverlay(h);var k=o.getDefinition().support.command;while(!j||!j.isVisible()){if(k==="remove"){h=h.getParent();j=O.getOverlay(h.sId);}else{return null;}}var l=j.toString();var n="__"+l.split("__")[1];for(var i=0;i<g.changeIndicators.length;i++){if(g.changeIndicators[i].elementId===n&&s==="change"){g.changeIndicators[i].changeIndicator.addChange(o);return null;}}var p=new C({mode:s,parentId:n,changes:[]});p.addChange(o);p.setModel(g.button.getModel("i18n"),"i18n");p.hideChangeIndicators=g.hideChangeIndicators.bind(g);p.revealChangeIndicators=g.revealChangeIndicators.bind(g);p.createChangeIndicator=g.createChangeIndicator.bind(g);p.getChangedElements=g.getChangedElements.bind(g);return p;};
g.getChangedElements=function(o,D){var h=b.get(g.rootControlId);return g.getInfoFromChangeHandler(h,o).then(function(i){var s=[o.getSelector()];if(i){if(D){s=i.dependentControls;}else{s=i.affectedControls;}}var p=[];s.forEach(function(S){p.push(c.bySelector(S,h));});return Promise.all(p);});};
g.getChanges=function(){var o=b.get(g.rootControlId);var p={oComponent:o,selector:o,invalidateCache:false,includeVariants:true,currentLayer:L.CUSTOMER};return P._getUIChanges(p);};
g.openChangePopover=function(o,r){g.button=o;g.rootControlId=r;return g.getChanges().then(function(h){g.changes=h;if(!g.changesPopover){return F.load({name:"sap.ui.rta.toolbar.Changes",id:"fragment_changeVisualization",controller:g}).then(function(p){g.changesPopover=p;g.updateCommandModel();g.changesPopover.openBy(o);return p;});}if(g.changesPopover.isOpen()){g.changesPopover.close();}else{g.updateCommandModel();g.changesPopover.openBy(o);}});};
g.getInfoFromChangeHandler=function(A,o){var h=c.bySelector(o.getSelector(),A);if(h){var p={modifier:c,appComponent:A,view:a.getViewForControl(h)};var i=d.getControlIfTemplateAffected(o,h,p);return d.getChangeHandler(o,i,p).then(function(j){if(j&&typeof j.getChangeVisualizationInfo==="function"){return j.getChangeVisualizationInfo(o,A);}});}return Promise.resolve();};
return g;});
sap.ui.predefine('sap/ui/rta/toolbar/Fiori',["sap/m/Image","./Adaptation","../Utils","sap/base/Log"],function(I,A,U,L){"use strict";var F='sapUiRtaFioriHeaderInvisible';
var a=A.extend("sap.ui.rta.toolbar.Fiori",{
metadata:{library:"sap.ui.rta"},
renderer:'sap.ui.rta.toolbar.AdaptationRenderer',
type:'fiori'
});
a.prototype.init=function(){this._oRenderer=U.getFiori2Renderer();this._oFioriHeader=this._oRenderer.getRootControl().getOUnifiedShell().getHeader();A.prototype.init.apply(this,arguments);};
a.prototype.show=function(){this._oFioriHeader.addStyleClass(F);return A.prototype.show.apply(this,arguments);};
a.prototype.buildControls=function(){return A.prototype.buildControls.apply(this,arguments).then(function(c){var l=this._oFioriHeader.getLogo();if(this._oFioriHeader.getShowLogo()&&l){var $=this._oFioriHeader.$().find('#shell-header-icon');var w;var h;if($.length){w=$.width();h=$.height();this._checkLogoSize($,w,h);}this.getControl("iconSpacer").setWidth("10%");this.getControl("iconBox").addItem(new I(this.getId()+"_fragment--sapUiRta_icon",{src:l,width:w?w+'px':w,height:h?h+'px':h}));}return c;}.bind(this));};
a.prototype.hide=function(){return A.prototype.hide.apply(this,arguments).then(function(){this._oFioriHeader.removeStyleClass(F);}.bind(this));};
a.prototype._checkLogoSize=function($,w,h){var n=$.get(0).naturalWidth;var N=$.get(0).naturalHeight;if(w!==n||h!==N){L.error(["sap.ui.rta: please check Fiori Launchpad logo, expected size is",w+"x"+h+",","but actual is "+n+"x"+N].join(' '));}};
a.prototype.destroy=function(){this._oFioriHeader.removeStyleClass(F);delete this._oRenderer;delete this._oFioriHeader;A.prototype.destroy.apply(this,arguments);};
return a;},true);
sap.ui.predefine('sap/ui/rta/toolbar/FioriLike',["./Adaptation"],function(A){"use strict";
var F=A.extend("sap.ui.rta.toolbar.FioriLike",{
metadata:{library:"sap.ui.rta"},
renderer:'sap.ui.rta.toolbar.AdaptationRenderer',
type:'fiori'
});
return F;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Personalization',["./Base","sap/m/Button"],function(B,a){"use strict";
var P=B.extend("sap.ui.rta.toolbar.Personalization",{
renderer:'sap.ui.rta.toolbar.BaseRenderer',
type:'personalization',
metadata:{library:"sap.ui.rta",events:{exit:{},restore:{}}},
constructor:function(){B.apply(this,arguments);this.setJustifyContent("End");}
});
P.prototype.buildContent=function(){[new a("sapUiRta_restore",{type:"Transparent",text:"{i18n>BTN_RESTORE}",visible:true,press:this.eventHandler.bind(this,'Restore')}).data('name','restore'),new a("sapUiRta_exit",{type:"Emphasized",text:"{i18n>BTN_DONE}",press:this.eventHandler.bind(this,'Exit')}).data('name','exit')].forEach(function(c){this.addItem(c);}.bind(this));return Promise.resolve();};
return P;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Standalone',["./Adaptation"],function(A){"use strict";
var S=A.extend("sap.ui.rta.toolbar.Standalone",{
metadata:{library:"sap.ui.rta"},
renderer:'sap.ui.rta.toolbar.AdaptationRenderer',
type:'standalone'
});
return S;},true);
sap.ui.predefine('sap/ui/rta/util/Animation',["sap/ui/thirdparty/jquery"],function(q){"use strict";var m={};
m.waitTransition=function($,c){if(!($ instanceof q)){throw new Error('$element should be wrapped into jQuery object');}if(typeof c!=="function"){throw new Error('fnCallback should be a function');}return new Promise(function(r){$.one('transitionend',r);var t;var a=function(T){if(!t){t=T;}if(T!==t){c();}else{window.requestAnimationFrame(a);}};window.requestAnimationFrame(a);});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/BindingsExtractor',["sap/ui/dt/ElementUtil","sap/base/util/isPlainObject"],function(E,a){"use strict";
function c(o,m){var B={bindingPaths:[],bindingContextPaths:[]};var A=o.sParentAggregationName;var p=o.getParent();var k=g(o,m);if(p){var D=p.getMetadata().getAggregation();if(D){var P=E.getAggregation(p,A).indexOf(o);var s=D.name;var n=p.getBindingInfo(s);var t=n&&n.template;if(t){var T=t.getMetadata().getAggregation();if(T){var q=T.name;var r=E.getAggregation(t,q)[P];k=k.concat(g(r,null,true));}}}}for(var i=0,l=k.length;i<l;i++){if(k[i].getPath){var u=k[i].getPath();if(u&&B.bindingPaths.indexOf(u)===-1){B.bindingPaths.push(u);}}if(k[i].getContext&&k[i].getContext()&&k[i].getContext().getPath){var v=k[i].getContext().getPath();if(v&&B.bindingContextPaths.indexOf(v)===-1){B.bindingContextPaths.push(v);}}if(a(k[i])){if(B.bindingPaths.indexOf(k[i].parts[0].path)===-1){B.bindingPaths.push(k[i].parts[0].path);}}}return B;}
function g(o,p,t,A){var B=(t?h(o):e(o,p));var i=A?[A]:Object.keys(o.getMetadata().getAllAggregations());i.forEach(function(s){B=B.concat(b(o,p,t,s));});return B;}
function b(o,p,t,A){var B=[];var i=o.getBindingInfo(A);var T=i&&i.template;var k=T?[T]:E.getAggregation(o,A);k.forEach(function(C){if(C.getMetadata){B=B.concat(T||t?h(C):e(C,p),g(C,p,T||t));}});return B;}
function f(B,p){var i=[];var m=B.getMetadata().getName();if(m==="sap.ui.model.CompositeBinding"){B.getBindings().forEach(function(B){i=i.concat(f(B,p));});}else if((m==="sap.ui.model.odata.ODataPropertyBinding"||m==="sap.ui.model.odata.v2.ODataPropertyBinding"||m==="sap.ui.model.odata.v4.ODataPropertyBinding"||m==="sap.ui.model.json.JSONPropertyBinding"||m==="sap.ui.model.json.XMLPropertyBinding"||m==="sap.ui.model.resource.ResourcePropertyBinding")&&B.getModel()===p&&B.isRelative()&&typeof B.getPath==="function"&&B.getPath()){i.push(B);}return i;}
function d(B){var i=[];var p=B.parts;p.forEach(function(P){i.push({parts:[P]});});return i;}
function e(o,p){var P=Object.keys(o.getMetadata().getAllProperties());return P.filter(o.getBinding.bind(o)).reduce(function(B,s){return B.concat(f(o.getBinding(s),p));},[]);}
function h(o){var p=Object.keys(o.getMetadata().getAllProperties());return p.filter(function(P){return P in o.mBindingInfos;}).reduce(function(B,P){return B.concat(d(o.mBindingInfos[P]));},[]);}
function j(o){if(o.getBindingContext()&&o.getBindingContext().getPath){return o.getBindingContext().getPath();}return undefined;}
return{getBindings:g,collectBindingPaths:c,flattenBindings:f,getBindingsFromProperties:e,getBindingContextPath:j};},true);
sap.ui.predefine('sap/ui/rta/util/PopupManager',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/m/InstanceManager","sap/ui/dt/Overlay","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/core/Element","sap/ui/dt/util/ZIndexManager","sap/m/Dialog","sap/m/Popover","sap/base/util/restricted/_curry"],function(q,M,I,O,f,C,a,E,Z,D,P,_){"use strict";var F={add:"_activateFocusHandle",remove:"_deactivateFocusHandle"};
var b=M.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});
b.prototype.init=function(){this._oModalState=new Map();this._aPopupFilters=[this._isSupportedPopup.bind(this),this._isPopupAdaptable.bind(this)];this._aPopupFilters.forEach(function(d){Z.addPopupFilter(d);});};
b.prototype._overrideInstanceFunctions=function(){this._applyPopupAttributes({method:this._createPopupOverlays,setModal:true,bringToTop:true});this._overrideAddPopupInstance();this._overrideRemovePopupInstance();};
b.prototype.getCategorizedOpenPopups=function(){var o;var d;o=I.getOpenDialogs();var e=this._getValidatedPopups(o);d=I.getOpenPopovers();var g=this._getValidatedPopups(d);var h={aDialogs:e.relevant,aPopovers:g.relevant,aAllSupportedPopups:e.allSupported.concat(g.allSupported)};return h;};
b.prototype._getValidatedPopups=function(o){var A=[];o=o.filter(function(p){if(this._isPopupAdaptable(p)){A.push(p);return true;}else if(p instanceof D){A.push(p);}}.bind(this));return{relevant:o,allSupported:A};};
b.prototype._isComponentInsidePopup=function(p){return Array.isArray(p.getContent())?p.getContent().some(function(o){if(o instanceof a){return this.oRtaRootAppComponent===this._getAppComponentForControl(C.get(o.getComponent()));}}.bind(this)):false;};
b.prototype._isSupportedPopup=function(p){return(p instanceof D||p instanceof P);};
b.prototype.setRta=function(r){if(r&&r._oDesignTime){this.setProperty("rta",r);var R=r.getRootControlInstance();this.oRtaRootAppComponent=this._getAppComponentForControl(R);var m=this._onModeChange.bind(this);r.attachModeChanged(m);this._overrideInstanceFunctions();}};
b.prototype._onModeChange=function(e){var n=e.getParameters().mode;var A=function(m,p){if(m==='navigation'){p.oPopup[this._getFocusEventName("add")]();}else{p.oPopup[this._getFocusEventName("remove")]();if(this.getRta().getShowToolbars()){this.getRta().getToolbar().bringToFront();}}};n==='navigation'?this._applyPatchesToOpenPopups(_(A)(n)):this._removePatchesToOpenPopups(_(A)(n));};
b.prototype._applyPatchesToOpenPopups=function(e){this._applyPopupAttributes({method:e,focus:true,setModal:false});};
b.prototype._removePatchesToOpenPopups=function(e){this._applyPopupAttributes({method:e,setModal:true});};
b.prototype._getFocusEventName=function(o){return F[o];};
b.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=I.addDialogInstance;I.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=I.addPopoverInstance;I.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);};
b.prototype._overrideAddFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isSupportedPopup(p)){if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){p.attachEventOnce("afterOpen",this._createPopupOverlays,this);p.attachEventOnce("afterOpen",this.fireOpen,this);this._setModal(true,p);}else if(!(p instanceof P)){this._setModal(true,p);}}return v;}.bind(this);};
b.prototype._setModal=function(s,p){var o=this._oModalState.get(p.oPopup);if(typeof o!=="boolean"&&s&&this.getRta().getMode()==='adaptation'){this._oModalState.set(p.oPopup,p.oPopup.getModal());p.oPopup.setModal(true);}else if(typeof o==="boolean"&&s===false){p.oPopup.setModal(o);this._oModalState.delete(p.oPopup);}};
b.prototype._applyPopupAttributes=function(p){var r=this.getCategorizedOpenPopups();["aDialogs","aPopovers"].forEach(function(k){if(r[k].length>0){if(p.focus){if(r[k][0].oPopup.oContent){r[k][0].oPopup.oContent.focus();}}r[k].forEach(function(o){p.method.call(this,o);}.bind(this));}}.bind(this));r.aAllSupportedPopups.forEach(this._setModal.bind(this,p.setModal));};
b.prototype._applyPopupPatch=function(p){var o=O.getOverlayContainer();var d=p.oPopup;var A=[d.oContent.getDomRef(),o.get(0)].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){var r=this.getRta().getToolbar();var v=!!r.getVisible();if(!v){this.getRta().attachEventOnce("start",function(){A.push(r.getDomRef());});}else{A.push(r.getDomRef());}}d.setExtraContent(A);if(!this.fnOriginalPopupOnAfterRendering){this.fnOriginalPopupOnAfterRendering=d.onAfterRendering;}d.onAfterRendering=function(){var e=this.fnOriginalPopupOnAfterRendering.apply(d,arguments);d[this._getFocusEventName("remove")]();return e;}.bind(this);if(this.getRta().getMode()==='adaptation'){d[this._getFocusEventName("remove")]();}};
b.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=I.removeDialogInstance;I.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=I.removePopoverInstance;I.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);};
b.prototype._overrideRemoveFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isSupportedPopup(p)){if(this._isPopupAdaptable(p,false)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(p);}this._oModalState.delete(p.oPopup);this.fireClose(p);}return v;}.bind(this);};
b.prototype._getAppComponentForControl=function(o){var d;var A;if(o instanceof C){d=o;}else{d=this._getComponentForControl(o);}if(d){A=f.getAppComponentForControl(d);}return A;};
b.prototype._getComponentForControl=function(o){var d;var r;var p;if(o){d=C.getOwnerComponentFor(o);if(!d&&typeof o.getParent==="function"&&o.getParent()instanceof E){p=o.getParent();}else if(d){p=d;}if(p){r=this._getComponentForControl(p);}}return r||d;};
b.prototype._createPopupOverlays=function(e){if(!e){return;}var p=(e instanceof E)?e:e.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(p.getId())===-1&&!this._isComponentInsidePopup(p)){this.getRta()._oDesignTime.addRootElement(p);}p.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(p);};
b.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){I.addDialogInstance=this._fnOriginalAddDialogInstance;}if(this._fnOriginalRemoveDialogInstance){I.removeDialogInstance=this._fnOriginalRemoveDialogInstance;}if(this._fnOriginalAddPopoverInstance){I.addPopoverInstance=this._fnOriginalAddPopoverInstance;}if(this._fnOriginalRemovePopoverInstance){I.removePopoverInstance=this._fnOriginalRemovePopoverInstance;}this._applyPatchesToOpenPopups(this._removePopupPatch);};
b.prototype._removePopupPatch=function(p){var o=p.oPopup;o[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){o.onAfterRendering=this.fnOriginalPopupOnAfterRendering;}};
function c(p){if(!p||p instanceof C){return true;}if(!p.isPopupAdaptationAllowed||p.isPopupAdaptationAllowed()){return c(p.getParent());}return false;}
b.prototype._isPopupAdaptable=function(p){if(p.isPopupAdaptationAllowed&&!p.isPopupAdaptationAllowed()){return false;}var o=this._getAppComponentForControl(p);if(this.oRtaRootAppComponent===o||this._isComponentInsidePopup(p)){return c(p.getParent());}return false;};
b.prototype.exit=function(){this._restoreInstanceFunctions();delete this._oModalState;this._aPopupFilters.forEach(function(d){Z.removePopupFilter(d);});};
return b;});
sap.ui.predefine('sap/ui/rta/util/ServiceEventBus',["sap/ui/core/EventBus"],function(E){"use strict";
var S=E.extend("sap.ui.rta.util.ServiceEventBus");
S.prototype._callListener=function(c,l,C,e,d){c.call(l,d);};
S.prototype.getChannel=function(c){return this._mChannels[c];};
return S;});
sap.ui.predefine('sap/ui/rta/util/StylesLoader',["sap/ui/thirdparty/jquery"],function(q){"use strict";var m={};
m.loadStyles=function(f){return q.get(sap.ui.require.toUrl(('sap.ui.rta.assets.'+f).replace(/\./g,"/"))+'.css').then(function(d){if(sap.ui.getCore().getConfiguration().getRTL()){return d.replace(/right/g,'left');}return d;});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/UrlParser',[],function(){"use strict";var m={};
m.getParam=function(p){return m.getParams()[p];};
m.getParams=function(){return document.location.search.replace(/^\?/,'').split('&').reduce(function(p,P){var a=P.split('=');var v=a[1];switch(v){case'true':v=true;break;case'false':v=false;break;}p[a[0]]=v;return p;},{});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/hasStableId',["sap/ui/fl/Utils","sap/ui/dt/ElementUtil","sap/base/util/isPlainObject"],function(F,E,i){"use strict";
function a(c){var p=c.sParentAggregationName;var P=c.getParent();if(P&&p){var b=P.getBindingInfo(p);if(b){if(b.template&&c instanceof b.template.getMetadata().getClass()){return b.template;}return false;}return a(P);}return false;}
return function h(e){if(!e||e._bIsBeingDestroyed){return false;}if(typeof e.data("hasStableId")!=="boolean"){var s=e.getDesignTimeMetadata().getStableElements(e);var u=false;if(s.length>0){if(a(e.getElement())){u=s.some(function(S){var c;var A;var u=false;if(i(S)){c=S.id;A=S.appComponent;}else{c=S;}u=!F.checkControlId(c,A);if(u){var C=E.getElementInstance(c);if(E.getElementInstance(c)){var l=E.getAggregationInformation(C);u=!F.checkControlId(E.extractTemplateId(l),A);}}return u;});}else{u=s.some(function(S){var c=S.id||S;return!F.checkControlId(c,S.appComponent);});}}e.data("hasStableId",!u);}return e.data("hasStableId");};});
sap.ui.predefine('sap/ui/rta/util/showMessageBox',["sap/m/MessageBox","sap/ui/layout/HorizontalLayout","sap/m/Link","sap/m/Text"],function(M,H,L,T){"use strict";var l="\\[(.*?)\\]\\((.*?)\\)";
function h(m){var r=g(m);return Array.isArray(r)&&r.length>0;}
function a(t){var r=new RegExp("^"+l+"$");return Array.isArray(r.exec(t));}
function e(s){var m=new RegExp(l).exec(s);return{text:m[1],href:m[2]};}
function g(m){var r=new RegExp(l,"g");return m.match(r);}
function c(s){var o=new H({allowWrapping:true,content:s.map(function(S){if(a(S)){var m=e(S);return new L({text:m.text,href:m.href,target:"_blank",emphasized:true,wrapping:true});}return new T({text:S,renderWhitespace:true});})});o.addStyleClass("sapUiRtaMessageBox");return o;}
function b(m){var s=[m];var d=g(m);d.forEach(function(f){var i=0;while(i<s.length){var S=s[i];if(a(S)){i++;}else{var p=S.split(f);var I=[];p.forEach(function(P,j,o){I.push(P);if(j!==o.length-1){I.push(f);}});s.splice.apply(s,[i,1].concat(I));i+=I.length;}}});return s;}
return function d(m,o){var v;if(h(m)){var s=b(m);v=c(s);}else{v=m;}M.show(v,o);};});
sap.ui.predefine('sap/ui/rta/util/validateFlexEnabled',["sap/ui/fl/Utils","sap/m/MessageBox","sap/base/util/ObjectPath","sap/ui/rta/util/validateStableIds","sap/ui/rta/util/showMessageBox","sap/base/Log","sap/ui/rta/Utils","sap/ui/dt/Util"],function(F,M,O,v,s,L,U,D){"use strict";return function(r){function _(r,C,t,i,T){var j=C.getId();if(!m[j]){s(r._getTextResources().getText(t),{icon:M.Icon[i],title:r._getTextResources().getText(T),styleClass:U.getRtaStyleClassName()});a(j,true);}}function a(i,V){m[i]=V;}function b(C){var o=C.getManifest();return(O.get(["sap.app","id"],o)!=="sap.ui.documentation.sdk"&&!(O.get(["sap.app","id"],o)||"").startsWith("sap.ui.rta")&&!O.get(["sap.ovp"],o));}function c(){return("QUnit"in window||(window.frameElement&&(window.frameElement.getAttribute("id")||"").toLowerCase()==="opaframe"));}function d(i){return i&&!i._bIsBeingDestroyed;}function e(E){var n=E.getParameters().mode;if(n==="adaptation"){var r=E.getSource();var C=F.getAppComponentForControl(r.getRootControlInstance());p=p.filter(d);g(r,C,p);p=[];}}function f(E,r){var i=E.getParameters().elementOverlay;if(r.getMode()==="adaptation"){var C=F.getAppComponentForControl(r.getRootControlInstance());D.waitForSynced(r._oDesignTime,function(j){if(d(j)){g(r,C,[j]);}})(i);}else{p.push(i);}}function g(r,C,E){var u=v(E,C);if(u.length){u.forEach(function(i){L.error("Control ID was generated dynamically by SAPUI5. To support SAPUI5 flexibility, a stable control ID is needed to assign the changes to.",i.getElement().getId());});_(r,C,"MSG_UNSTABLE_ID_FOUND","ERROR","HEADER_ERROR");}}var m={};var p=[];var C=F.getAppComponentForControl(r.getRootControlInstance());r.attachEventOnce("stop",function(){a(C.getId(),false);});if(C&&b(C)){var o=C.getManifest();var h=O.get(["sap.ui5","flexEnabled"],o);if(typeof h!=="boolean"){if(!c()){_(r,C,"MSG_NO_FLEX_ENABLED_FLAG","WARNING","HEADER_WARNING");}}else{r.attachEvent("modeChanged",e);r._oDesignTime.attachEvent("elementOverlayCreated",r,f);g(r,C,r._oDesignTime.getElementOverlays());}}};});
sap.ui.predefine('sap/ui/rta/util/validateStableIds',["sap/base/util/ObjectPath","sap/ui/rta/util/hasStableId","sap/ui/core/mvc/View","sap/ui/core/Fragment","sap/ui/dt/OverlayUtil","sap/base/util/isPlainObject"],function(O,h,V,F,a,b){"use strict";
function c(C){var m=C.getManifest();return O.get(["sap.ui.generic.app"],m);}
function g(C){var m=C.getManifest();var v=O.get(["sap.ui5","extends","extensions","sap.ui.viewExtensions"],m);var e=[];if(b(v)){Object.keys(v).forEach(function(s){if(s.startsWith("sap.suite.ui.generic.template")){var f=v[s];Object.keys(f).forEach(function(i){e.push(f[i]);});}});}return e;}
function d(e,E){var f=[];for(var i=0,l=E.length;i<l;i++){var o=E[i];var j=o.getElement();var I=e.some(function(v){var C=O.get(v.className);var s;var k;if(j instanceof V){k=j.getViewName();s=v.viewName;}else if(j instanceof F){k=j.getFragmentName();}else{return false;}return(j instanceof C&&k===s);});if(I){f.push(o);if(f.length===e.length){break;}}}var r=[];f.forEach(function(o){a.iterateOverlayElementTree(o,function(o){r.push(o);});});return r;}
return function(e,C){var r=[];var R=e.slice(0);if(c(C)){var E=g(C);R=(E.length?d(E,R):[]);}r=R.filter(function(o){return(!o.getDesignTimeMetadata().markedAsNotAdaptable()&&!h(o));});return r;};});
sap.ui.require.preload({
	"sap/ui/rta/appVariant/manageApps/webapp/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.rta.appVariant.manageApps","type":"application","i18n":{"bundleUrl":"i18n/i18n.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en_US_sappsd","en_US_saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh_CN","zh_TW"],"fallbackLocale":"en"},"applicationVersion":{"version":"1.0.0"},"title":"{{appTitle}}","description":"{{appDescription}}","resources":"resources.json","ach":"ach","sourceTemplate":{"id":"ui5template.basicSAPUI5ApplicationProject","version":"1.40.12"}},"sap.ui":{"technology":"UI5","icons":{"icon":"","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.rta.appVariant.manageApps.webapp.view.ManageApps","type":"XML","async":true},"dependencies":{"minUI5Version":"1.30.0","libs":{"sap.ui.core":{},"sap.m":{},"sap.ui.layout":{},"sap.ui.rta":{}}},"contentDensities":{"compact":true,"cozy":true},"models":{"i18n":{"type":"sap.ui.model.resource.ResourceModel","settings":{"bundleName":"sap.ui.rta.appVariant.manageApps.webapp.i18n.i18n","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en_US_sappsd","en_US_saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh_CN","zh_TW"],"fallbackLocale":"en"}}},"resources":{"css":[{"uri":"css/style.css"}]}}}',
	"sap/ui/rta/appVariant/manageApps/webapp/view/ManageApps.view.xml":'<mvc:View controllerName="sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns="sap.m"><Table id="Table1" showNoData="false" inset="false" growing="true" growingThreshold="500" sticky="ColumnHeaders" items="{/appVariants}"><columns><Column width="8rem" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_APP_TYPE}"/></Column><Column width="4rem" minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ICON}"/></Column><Column minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_TITLE}"/></Column><Column minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_DESCRIPTION}"/></Column><Column width="8rem" minScreenWidth="Desktop" demandPopin="true" popinDisplay="Inline" hAlign="End"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ACTIONS}"/></Column></columns><items><ColumnListItem highlight="{path:\'currentStatus\',formatter:\'.formatRowHighlight\'}"><cells><ObjectIdentifier title="{typeOfApp}" text="{currentStatus}"/><core:Icon src="{icon}" tooltip="{iconText}" class="sapUiListTableIconSize"/><ObjectIdentifier title="{title}" text="{subTitle}"/><Text text="{description}"/><MenuButton text="{i18n&gt;MAA_DIALOG_ACTIONS}"><menu><Menu itemSelected="onMenuAction"><items><MenuItem text="{i18n&gt;MAA_DIALOG_ADAPT_UI}" visible="{parts:[{path:\'adaptUIButtonVisibility\'},{path:\'isKeyUser\'}],formatter:\'.formatAdaptUIButtonVisibility\'}" enabled="{adaptUIButtonEnabled}" tooltip="{parts:[{path:\'adaptUIButtonEnabled\'},{path:\'appVarStatus\'}],formatter:\'.formatAdaptUIButtonTooltip\'}" icon="sap-icon://wrench"/><MenuItem text="{i18n&gt;MAA_DIALOG_COPY_ID}" tooltip="{i18n&gt;TOOLTIP_MAA_DIALOG_COPY_ID}" icon="sap-icon://copy"/><MenuItem text="{i18n&gt;MAA_DIALOG_DELETE_APPVAR}" enabled="{delAppVarButtonEnabled}" visible="{delAppVarButtonVisibility}" tooltip="{parts:[{path:\'delAppVarButtonEnabled\'},{path:\'isS4HanaCloud\'}],formatter:\'.formatDelButtonTooltip\'}" icon="sap-icon://delete"/><MenuItem text="{i18n&gt;MAA_DIALOG_SAVE_AS_APP}" enabled="{saveAsButtonEnabled}" tooltip="{i18n&gt;TOOLTIP_MAA_DIALOG_SAVE_AS_APP}" icon="sap-icon://save" visible="{isKeyUser}"/></items></Menu></menu></MenuButton></cells></ColumnListItem></items></Table></mvc:View>',
	"sap/ui/rta/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.rta","type":"library","embeds":["appVariant/manageApps/webapp"],"applicationVersion":{"version":"1.84.0"},"title":"SAPUI5 library with RTA controls.","description":"SAPUI5 library with RTA controls.","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.84","libs":{"sap.ui.core":{"minVersion":"1.84.0"},"sap.ui.layout":{"minVersion":"1.84.0"},"sap.m":{"minVersion":"1.84.0"},"sap.ui.fl":{"minVersion":"1.84.0"},"sap.ui.dt":{"minVersion":"1.84.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en-GB","en-US-sappsd","en-US-saptrc","es","es-MX","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":[],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/rta/plugin/iframe/AddIFrameDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns="sap.m" xmlns:form="sap.ui.layout.form" xmlns:util="sap.ui.fl.util" xmlns:layout="sap.ui.layout"><Dialog id="sapUiRtaAddIFrameDialog" title="{/text/dialogTitle}" verticalScrolling="true" resizable="false" class="sapUiRtaAddIFrameDialog" draggable="true" validationSuccess="onValidationSuccess" validationError="onValidationError" parseError="onValidationError" contentWidth="50rem" contentHeight="44rem"><content><layout:VerticalLayout id="sapUiRtaAddIFrameDialog_VL" width="100%" class="sapUiRtaAddIFrameDialogVlWrapper"><Label id="sapUiRtaAddIFrameDialog_SizeTitle" text="{/text/sizeTitle}" class="sapUiRtaAddIFrameDialogSizeTitle" design="Bold"/><layout:Grid id="sapUiRtaAddIFrameDialog_SizeGrid" containerQuery="true" position="Center" class="sapUiRtaAddIFrameDialogSizeGrid" defaultSpan="XL6 L6 M6 S12"><form:SimpleForm id="sapUiRtaAddIFrameDialog_WidthForm" editable="true" layout="ResponsiveGridLayout" class="sapUiRtaAddIFrameDialogWidthForm" adjustLabelSpan="false" singleContainerFullSize="false" ariaLabelledBy="sapUiRtaAddIFrameDialog_WidthLabel" labelSpanXL="2" labelSpanL="2" labelSpanM="2" labelSpanS="4" emptySpanXL="2" emptySpanL="2" emptySpanM="2" emptySpanS="0"><form:content><Label id="sapUiRtaAddIFrameDialog_WidthLabel" class="sapUiRtaAddIFrameDialogWidthLabel" labelFor="sapUiRtaAddIFrameDialog_WidthInput" text="{/text/widthLabel}"/><Input id="sapUiRtaAddIFrameDialog_WidthInput" class="sapUiRtaAddIFrameDialogWidthInput" value="{path:\'/frameWidth/value\',type:\'sap.ui.model.type.Float\',constraints:{minimum:0}}" valueState="{/frameWidth/valueState}"/><Select id="sapUiRtaAddIFrameDialog_WidthUnit" class="sapUiRtaAddIFrameDialogWidthUnit" ariaLabelledBy="sapUiRtaAddIFrameDialog_WidthUnitLabel" change="onSizeUnitChange" selectedKey="{/frameWidthUnit/value}" items="{/unitsOfMeasure}"><core:Item key="{name}" text="{name}"/></Select></form:content></form:SimpleForm><form:SimpleForm id="sapUiRtaAddIFrameDialog_HeightForm" editable="true" layout="ResponsiveGridLayout" class="sapUiRtaAddIFrameDialogHeightForm" adjustLabelSpan="false" singleContainerFullSize="false" ariaLabelledBy="sapUiRtaAddIFrameDialog_HeightLabel" labelSpanXL="2" labelSpanL="2" labelSpanM="2" labelSpanS="4" emptySpanXL="2" emptySpanL="2" emptySpanM="2" emptySpanS="0"><form:content><Label id="sapUiRtaAddIFrameDialog_HeightLabel" class="sapUiRtaAddIFrameDialogHeightLabel" labelFor="sapUiRtaAddIFrameDialog_HeightInput" text="{/text/heightLabel}"/><Input id="sapUiRtaAddIFrameDialog_HeightInput" class="sapUiRtaAddIFrameDialogHeightInput" value="{path:\'/frameHeight/value\',type:\'sap.ui.model.type.Float\',constraints:{minimum:0}}" valueState="{/frameHeight/valueState}"/><Select id="sapUiRtaAddIFrameDialog_HeightUnit" class="sapUiRtaAddIFrameDialogHeightUnit" ariaLabelledBy="sapUiRtaAddIFrameDialog_HeightUnitLabel" change="onSizeUnitChange" selectedKey="{/frameHeightUnit/value}" items="{/unitsOfMeasure}"><core:Item key="{name}" text="{name}"/></Select></form:content></form:SimpleForm></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_PercentGrid" class="sapUiRtaAddIFrameDialogPercentGrid" containerQuery="true" position="Right" defaultSpan="XL12 L12 M12 S12"><Text id="sapUiRtaAddIFrameDialog_PercentText" text="{/text/percentUseLabel}" class="sapUiRtaAddIFrameDialogPercentText"/></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_EditGrid" class="sapUiRtaAddIFrameDialogEditGrid" containerQuery="true" defaultSpan="XL6 L6 M6 S12"><VBox id="sapUiRtaAddIFrameDialog_Parameters" class="sapUiRtaAddIFrameDialogParameters" renderType="Bare"><items><Label id="sapUiRtaAddIFrameDialog_ParametersLabel" text="{/text/parametersLabel}" labelFor="sapUiRtaAddIFrameDialog_ParameterTable" class="sapUiRtaAddIFrameDialogParametersLabel" design="Bold"/><SearchField id="sapUiRtaAddIFrameDialog_ParametersSearch" ariaLabelledBy="sapUiRtaAddIFrameDialog_ParameterSearchLabel" class="sapUiRtaAddIFrameDialogParametersSearch" search="onSearch"/><ScrollContainer height="12rem" vertical="true"><Table id="sapUiRtaAddIFrameDialog_ParameterTable" items="{/parameters/value}" ariaLabelledBy="sapUiRtaAddIFrameDialog_ParametersLabel" class="sapUiSizeCompact sapUiRtaAddIFrameDialogParameterTable" sticky="ColumnHeaders"><columns><Column><header><Label id="sapUiRtaAddIFrameDialog_ParameterLabel" class="sapUiRtaAddIFrameDialogParameterLabel" text="{/text/columnParameterLabel}"/></header></Column><Column><header><Label id="sapUiRtaAddIFrameDialog_ValueLabel" class="sapUiRtaAddIFrameDialog_ValueLabel" text="{/text/columnUiValueLabel}"/></header></Column></columns><items><ColumnListItem type="Active" press="onParameterPress"><cells><Text text="{label}"/><Text text="{value}" wrapping="false"/></cells></ColumnListItem></items></Table></ScrollContainer></items></VBox><VBox id="sapUiRtaAddIFrameDialog_EditUrl" class="sapUiRtaAddIFrameDialogEditUrl" renderType="Bare"><items><Label id="sapUiRtaAddIFrameDialog_EditUrlLabel" labelFor="sapUiRtaAddIFrameDialog_EditUrlTA" class="sapUiRtaAddIFrameDialogEditUrlLabel" text="{/text/editUrlLabel}" design="Bold"/><TextArea id="sapUiRtaAddIFrameDialog_EditUrlTA" ariaLabelledBy="sapUiRtaAddIFrameDialog_EditUrlLabel" class="sapUiRtaAddIFrameDialog_EditUrlTA" liveChange="onURLChange" valueLiveUpdate="true" value="{/frameUrl/value}" rows="11" width="100%"/></items></VBox></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_UrlWarningGrid" class="sapUiRtaAddIFrameDialogUrlWarningGrid" containerQuery="true" defaultSpan="XL12 L12 M12 S12"><FormattedText id="sapUiRtaAddIFrameDialog_DocumentationLink" htmlText="{/documentationLink/HTML}" class="sapUiRtaAddIFrameDialogDocumentationLink"/></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_PreviewLinkGrid" class="sapUiRtaAddIFrameDialogPreviewLinkGrid" containerQuery="true" defaultSpan="XL12 L12 M12 S12"><Panel id="sapUiRtaAddIFrameDialog_PreviewLinkPanel" expandable="true" width="auto" expanded="false" class="sapUiResponsiveMargin sapUiRtaAddIFrameDialogPreviewLinkPanel"><headerToolbar><OverflowToolbar id="sapUiRtaAddIFrameDialog_PreviewLinkToolbar" class="sapUiRtaAddIFrameDialogPreviewLinkToolbar" height="3rem" style="Clear"><Title id="sapUiRtaAddIFrameDialog_PreviewLinkTitle" class="sapUiRtaAddIFrameDialogPreviewLinkTitle" text="{/text/previewUrlLabel}"/><ToolbarSpacer/><Button id="sapUiRtaAddIFrameDialog_PreviewButton" enabled="{= !!${/frameUrl/value} }" text="{/text/previewButtonText}" type="Emphasized" press="onShowPreview" class="sapUiTinyMarginTop sapUiRtaAddIFrameDialogPreviewButton"/></OverflowToolbar></headerToolbar><content><Link id="sapUiRtaAddIFrameDialog_PreviewLink" class="sapUiRtaAddIFrameDialogPreviewLink" href="{/previewUrl/value}" text="{/previewUrl/value}" wrapping="true" visible="{= !!${/previewUrl/value} }"/></content></Panel></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_PreviewGrid" class="sapUiRtaAddIFrameDialogPreviewGrid" containerQuery="true" defaultSpan="XL12 L12 M12 S12"><VBox id="sapUiRtaAddIFrameDialog_PreviewGridVB" class="sapUiRtaAddIFrameDialogPreviewGridVB" renderType="Bare"><layoutData><FlexItemData growFactor="1"/></layoutData><items><Label id="sapUiRtaAddIFrameDialog_NoPreviewLabel" class="sapUiRtaAddIFrameDialogNoPreviewLabel" wrapping="true" text="{/text/previewUrlMessage}" textAlign="Center" visible="{= !${/previewUrl/value} }"/><util:IFrame id="sapUiRtaAddIFrameDialog_PreviewFrame" title="{/text/previewFrameLabel}" class="sapUiRtaAddIFrameDialogPreviewFrame" visible="{= !!${/previewUrl/value} }"/></items></VBox></layout:Grid></layout:VerticalLayout><core:InvisibleText id="sapUiRtaAddIFrameDialog_WidthUnitLabel" text="{/text/widthUnitLabel}"/><core:InvisibleText id="sapUiRtaAddIFrameDialog_HeightUnitLabel" text="{/text/heightUnitLabel}"/><core:InvisibleText id="sapUiRtaAddIFrameDialog_ParameterSearchLabel" text="{/text/parameterSearchLabel}"/></content><beginButton><Button id="sapUiRtaAddIFrameDialogSaveButton" class="sapUiRtaAddIFrameDialogSaveButton" type="Emphasized" text="{/text/saveText}" press="onSavePress" enabled="{= !!${/frameUrl/value} }"/></beginButton><endButton><Button id="sapUiRtaAddIFrameDialogCancelButton" class="sapUiRtaAddIFrameDialogCancelButton" type="Transparent" text="{/text/cancelText}" press="onCancelPress"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/Adaptation.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><HBox id="sapUiRta_toolbarIconAndDraftSection" class="sapUiRtaToolbarIconAndDraftSection"><OverflowToolbar class="sapUiRta_iconAndDraftBar"><content><HBox id="sapUiRta_iconBox"/><ToolbarSpacer id="sapUiRta_iconSpacer" width="0%" visible="true"/><Button id="sapUiRta_versionButton" type="Transparent" class="sapUiRtaVersionButton" icon="sap-icon://megamenu" iconFirst="false" visible="{versions&gt;/versioningEnabled}" text="{parts:[{path:\'versions&gt;/versions\'},{path:\'versions&gt;/displayedVersion\'}],formatter:\'.formatVersionButtonText\'}" tooltip="{parts:[{path:\'versions&gt;/versions\'},{path:\'versions&gt;/displayedVersion\'}],formatter:\'.formatVersionButtonText\'}" press=".showVersionHistory"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button id="sapUiRta_activate" icon="sap-icon://activate" press=".activate(${versions&gt;/displayedVersion})" visible="{versions&gt;/versioningEnabled}" enabled="{versions&gt;/activateEnabled}" type="Transparent" tooltip="{i18n&gt;TOL_ACTIVATE}"/><Button id="sapUiRta_discardDraft" icon="sap-icon://delete" press=".discardDraft" visible="{versions&gt;/versioningEnabled}" enabled="{path:\'versions&gt;/displayedVersion\',formatter:\'.formatDiscardDraftEnabled\'}" type="Transparent" tooltip="{i18n&gt;TOL_DISCARD_DRAFT}"/></content></OverflowToolbar></HBox><HBox id="sapUiRta_switcherSection" class="sapUiRtaToolbarSwitcherSection"><OverflowToolbar><content><ToolbarSpacer/><SegmentedButton id="sapUiRta_modeSwitcher" selectionChange=".modeChange" selectedKey="{controls&gt;/modeSwitcher}" width="auto"><items><SegmentedButtonItem id="sapUiRta_adaptationSwitcherButton" text="{i18n&gt;BTN_ADAPTATION}" width="auto" key="adaptation"/><SegmentedButtonItem id="sapUiRta_navigationSwitcherButton" text="{i18n&gt;BTN_NAVIGATION}" width="auto" key="navigation"/></items></SegmentedButton><ToolbarSpacer/></content></OverflowToolbar></HBox><HBox id="sapUiRta_toolbarActionsSection" class="sapUiRtaToolbarActionsSection" justifyContent="End"><OverflowToolbar id="sapUiRta_actionsToolbar"><content><ToolbarSpacer/><Button id="sapUiRta_undo" icon="sap-icon://undo" press=".undo" enabled="{controls&gt;/undoEnabled}" type="Transparent" tooltip="{i18n&gt;BTN_UNDO}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button id="sapUiRta_redo" icon="sap-icon://redo" press=".redo" enabled="{controls&gt;/redoEnabled}" type="Transparent" tooltip="{i18n&gt;BTN_REDO}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button id="sapUiRta_showChanges" icon="sap-icon://key-user-settings" press=".showChangesPopover" enabled="{= ${controls&gt;/modeSwitcher} === \'adaptation\'}" type="Transparent" tooltip="{i18n&gt;BUT_CHANGEVISUALIZATION_SHOWCHANGES}" visible="{controls&gt;/showChangesVisible}"><layoutData><OverflowToolbarLayoutData priority="Low"/></layoutData></Button><Button id="sapUiRta_publish" enabled="{controls&gt;/publishEnabled}" visible="{controls&gt;/publishVisible}" press=".publish" type="Transparent" text="{i18n&gt;BTN_PUBLISH}"><layoutData><OverflowToolbarLayoutData priority="High"/></layoutData></Button><Button id="sapUiRta_restore" enabled="{controls&gt;/restoreEnabled}" visible="{path:\'versions&gt;/versioningEnabled\',formatter:\'.showRestore\'}" press=".restore" type="Transparent" text="{i18n&gt;BTN_RESTORE}"><layoutData><OverflowToolbarLayoutData priority="High"/></layoutData></Button><Button id="sapUiRta_manageApps" press=".manageApps" enabled="{controls&gt;/manageAppsEnabled}" visible="{controls&gt;/manageAppsVisible}" type="Transparent" text="{i18n&gt;BTN_MANAGE_APPS_TXT}"><layoutData><OverflowToolbarLayoutData priority="Low"/></layoutData></Button><MenuButton id="sapUiRta_appVariantOverview" enabled="{controls&gt;/appVariantsOverviewEnabled}" visible="{controls&gt;/appVariantsOverviewVisible}" type="Transparent" text="{i18n&gt;BTN_MANAGE_APPS_TXT}"><menu><Menu itemSelected=".appVariantOverview" id="sapUiRta_appVariantMenu"><MenuItem id="sapUiRta_keyUser" text="{i18n&gt;MENU_ITEM_KEY_USER}"/><MenuItem id="sapUiRta_developer" text="{i18n&gt;MENU_ITEM_SAP_DEVELOPER}"/></Menu></menu><layoutData><OverflowToolbarLayoutData priority="Low"/></layoutData></MenuButton><Button id="sapUiRta_saveAs" visible="{controls&gt;/saveAsVisible}" enabled="{controls&gt;/saveAsEnabled}" press=".saveAs" type="Transparent" text="{i18n&gt;BTN_SAVE_AS}"><layoutData><OverflowToolbarLayoutData priority="Low"/></layoutData></Button></content></OverflowToolbar><Button id="sapUiRta_exit" type="Transparent" press=".exit" text="{i18n&gt;BTN_EXIT}"/><layoutData><FlexItemData growFactor="0"/></layoutData></HBox></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/ChangeIndicatorPopover.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns="sap.m"><Popover title="{i18n&gt;TIT_CHANGEVISUALIZATION_CHANGES}" placement="PreferredTopOrFlip" class="sapUiRtaPopover"><Table items="{changesModel&gt;/changes}" inset="false" fixedLayout="false" width="auto"><columns><Column width="auto"><Text text="{i18n&gt;TIT_CHANGEVISUALIZATION_CHANGE}"/></Column><Column width="auto"><Text text="{i18n&gt;TIT_CHANGEVISUALIZATION_DESCRIPTION}"/></Column><Column width="auto"><Text text="{i18n&gt;TIT_CHANGEVISUALIZATION_DATE}"/></Column><Column width="auto"><Text text="{i18n&gt;TIT_CHANGEVISUALIZATION_DETAILS}"/></Column></columns><items><ColumnListItem><cells><Text text="{changesModel&gt;changeTitle}"/><Text text="{changesModel&gt;description}"/><Text text="{changesModel&gt;date}"/><Button visible="{changesModel&gt;enableDetailButton}" icon="sap-icon://display" press=".showDependentElements"/></cells></ColumnListItem></items></Table></Popover></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/Changes.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Popover title="{i18n&gt;TIT_CHANGEVISUALIZATION_CHANGES}" placement="Bottom" class="sapUiRtaPopover"><List id="sapUiRta_changesList" items="{commandModel&gt;/commands}"><StandardListItem title="{commandModel&gt;text}" type="{commandModel&gt;type}" counter="{commandModel&gt;count}" press=".showSpecificChanges"/></List></Popover></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/SingleChangeIndicatorPopover.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout" xmlns="sap.m"><Popover title="{changesModel&gt;/changes/0/changeTitle}" placement="PreferredTopOrFlip" class="sapUiRtaPopover"><l:VerticalLayout><Text text="{changesModel&gt;/changes/0/description}" class="sapUiTinyMargin"/><Text text="{changesModel&gt;/changes/0/date}" class="sapUiTinyMargin"/></l:VerticalLayout><footer><FlexBox direction="RowReverse"><items><Button visible="{changesModel&gt;/changes/0/enableDetailButton}" text="{i18n&gt;TIT_CHANGEVISUALIZATION_DETAILS}" icon="sap-icon://display" press=".showDependentElements" class="sapUiTinyMargin"/></items></FlexBox></footer></Popover></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/VersionHistory.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Popover class="sapUiRtaVersionHistory" showHeader="false" placement="Bottom"><List visible="{path:\'versions&gt;/versions/length\',formatter:\'.formatVersionTableVisibility\'}" items="{versions&gt;/versions}"><FeedListItem text="{parts:[{path:\'versions&gt;title\'},{path:\'versions&gt;type\'}],formatter:\'.formatVersionTitle\'}" info="{versions&gt;activatedBy}" timestamp="{path:\'versions&gt;activatedAt\',formatter:\'.formatVersionTimeStamp\'}" type="Active" press=".versionSelected" highlight="{path:\'versions&gt;type\',formatter:\'.formatHighlight\'}" highlightText="{path:\'versions&gt;type\',formatter:\'.formatHighlightText\'}" showIcon="false"/></List><List><FeedListItem text="{i18n&gt;TIT_ORIGINAL_APP}" type="Active" press=".versionSelected" highlight="{path:\'versions&gt;/versions\',formatter:\'.formatOriginalAppHighlight\'}" highlightText="{path:\'versions&gt;/versions\',formatter:\'.formatOriginalAppHighlightText\'}" showIcon="false"/></List></Popover></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/VersionTitleDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Dialog title="{i18n&gt;TIT_VERSION_TITLE_DIALOG}" type="Message"><content><Input id="sapUiRta_versionTitleInput" type="Text" maxLength="200" liveChange=".onVersionTitleLiveChange" submit=".onConfirmVersioningDialog" placeholder="{i18n&gt;TXT_VERSION_TITLE_INPUT_PLACEHOLDER}"/></content><beginButton><Button id="sapUiRta_confirmVersionTitleButton" text="{i18n&gt;BUT_VERSION_TITLE_DIALOG_CONFIRM}" type="Emphasized" enabled="false" press=".onConfirmVersioningDialog"/></beginButton><endButton><Button text="{i18n&gt;BUT_VERSION_TITLE_DIALOG_CANCEL}" press=".onCancelVersioningDialog"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/view/RemoveElementDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns:commons="sap.ui.commons" xmlns:layout="sap.ui.layout" xmlns:sap.m="sap.m"><sap.m:Dialog class="sapUiRtaConfirmationDialog" verticalScrolling="false" title="{/titleText}" icon="{/icon}"><layout:VerticalLayout width="100%"><commons:TextView class="sapUiRtaConfirmationDialogText" text="{/messageText}"/></layout:VerticalLayout><sap.m:beginButton><sap.m:Button class="sapUiRtaConfirmationDialogRemoveButton" text="{/removeText}" press="removeField"/></sap.m:beginButton><sap.m:endButton><sap.m:Button class="sapUiRtaConfirmationDialogCancelButton" text="{/cancelText}" press="closeDialog"/></sap.m:endButton></sap.m:Dialog></core:FragmentDefinition>',
	"sap/ui/rta/appVariant/manageApps/webapp/index.js":function(){sap.ui.require(["sap/m/Shell","sap/ui/core/ComponentContainer"],function(S,C){"use strict";sap.ui.getCore().attachInit(function(){new S({app:new C({height:"100%",name:"sap.ui.rta.appVariant.manageApps",settings:{id:"sap.ui.rta.appVariant.manageApps"}})}).placeAt("content");});});
}
},"sap/ui/rta/library-preload"
);
//# sourceMappingURL=library-preload.js.map