/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Fragment","sap/ui/core/format/DateFormat","sap/ui/Device","./Base","sap/ui/core/library","sap/ui/fl/library","sap/ui/rta/toolbar/ChangeVisualization","sap/ui/rta/Utils"],function(F,D,a,B,c,f,C,U){"use strict";var M=c.MessageType;var V=f.Versions;var A=B.extend("sap.ui.rta.toolbar.Adaptation",{renderer:"sap.ui.rta.toolbar.AdaptationRenderer",animation:true,metadata:{library:"sap.ui.rta",events:{undo:{},redo:{},exit:{},restore:{},transport:{},modeChange:{},manageApps:{},appVariantOverview:{},saveAs:{},activate:{},discardDraft:{},switchVersion:{}}}});A.modes={MOBILE:"sapUiRtaToolbarMobile",TABLET:"sapUiRtaToolbarTablet",DESKTOP:"sapUiRtaToolbarDesktop"};var b="sapUiRtaToolbar";var d="sapUiRtaDraftVersionAccent";var e="sapUiRtaActiveVersionAccent";A.prototype.init=function(){a.media.attachHandler(this._onSizeChanged,this,b);this._pFragmentLoaded=B.prototype.init.apply(this,arguments);C.changesPopover=undefined;};A.prototype.onBeforeRendering=function(){if(!a.media.hasRangeSet(b)){a.media.initRangeSet(b,[900,1200],"px",[A.modes.MOBILE,A.modes.TABLET,A.modes.DESKTOP]);}this._onSizeChanged(a.media.getCurrentRange(b));B.prototype.onBeforeRendering.apply(this,arguments);};A.prototype.onFragmentLoaded=function(){return this._pFragmentLoaded;};A.prototype.exit=function(){C.removeChangeIndicators();a.media.detachHandler(this._onSizeChanged,this,b);B.prototype.exit.apply(this,arguments);};function _(s,I,t,T){var o=this.getControl(s);var j=t?this.getTextResources().getText(t):"";var k=T?this.getTextResources().getText(T):"";o.setText(j||"");o.setTooltip(k||"");o.setIcon(I||"");}A.prototype.formatDiscardDraftEnabled=function(n){return n===sap.ui.fl.Versions.Draft;};A.prototype.formatVersionButtonText=function(v,n){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var T="";var s="Active";v=v||[];if(n===undefined||n===V.Original){T=t.getText("TIT_ORIGINAL_APP");s="inactive";if(v.length===0||(v.length===1&&v[0].type==="draft")){s="active";}}else{var o=v.find(function(j){return j.version===n;});if(o){s=o.type;if(n===V.Draft){T=t.getText("TIT_DRAFT");}else{T=o.title||t.getText("TIT_VERSION_1");}}}this.setVersionButtonAccentColor(s);return T;};A.prototype.formatVersionTableVisibility=function(n){return n>0;};A.prototype.formatVersionTitle=function(t,T){var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(T==="draft"){return o.getText("TIT_DRAFT");}return t||o.getText("TIT_VERSION_1");};A.prototype.formatVersionTimeStamp=function(t){if(!t){return"";}return D.getInstance({format:"yMMMdjm"}).format(new Date(t));};A.prototype.formatHighlight=function(t){switch(t){case"draft":return M.Warning;case"active":return M.Success;default:return M.None;}};A.prototype.formatHighlightText=function(t){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");switch(t){case"draft":return T.getText("TIT_DRAFT");case"active":return T.getText("LBL_ACTIVE");default:return T.getText("LBL_INACTIVE");}};function g(v){return v.some(function(o){return o.type==="active";});}A.prototype.formatOriginalAppHighlight=function(v){return g(v)?M.None:M.Success;};A.prototype.formatOriginalAppHighlightText=function(v){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return g(v)?t.getText("LBL_INACTIVE"):t.getText("LBL_ACTIVE");};A.prototype.versionSelected=function(E){var v=E.getSource().getBindingContext("versions");var n=V.Original;if(v){n=v.getProperty("version");}this.fireEvent("switchVersion",{version:n});};A.prototype.showChangesPopover=function(E){if(C.changeIndicatorsExist()){C.removeChangeIndicators();C.switchChangeVisualizationActive();return Promise.resolve();}if(this.getModel("controls").getProperty("/modeSwitcher")==="adaptation"){var o=E.getSource();var r=this.getModel("controls").getProperty("/rtaRootControlId");return C.openChangePopover(o,r).then(function(p){if(p){o.addDependent(p);}});}return Promise.resolve();};A.prototype.showVersionHistory=function(E){var v=E.getSource();if(!this.oVersionDialogPromise){this.oVersionDialogPromise=F.load({name:"sap.ui.rta.toolbar.VersionHistory",id:this.getId()+"_versionHistoryDialog",controller:{formatVersionTitle:this.formatVersionTitle.bind(this),formatVersionTimeStamp:this.formatVersionTimeStamp.bind(this),formatVersionTableVisibility:this.formatVersionTableVisibility.bind(this),formatHighlight:this.formatHighlight.bind(this),formatHighlightText:this.formatHighlightText.bind(this),formatOriginalAppHighlight:this.formatOriginalAppHighlight.bind(this),formatOriginalAppHighlightText:this.formatOriginalAppHighlightText.bind(this),versionSelected:this.versionSelected.bind(this)}}).then(function(o){v.addDependent(o);return o;});}return this.oVersionDialogPromise.then(function(o){if(!o.isOpen()){o.openBy(v);}else{o.close();}});};A.prototype.showRestore=function(v){return!v;};A.prototype._showButtonIcon=function(s,I,t){_.call(this,s,I,"",t);};A.prototype._showButtonText=function(s,t){_.call(this,s,"",t,"");};A.prototype._switchToIcons=function(){var I=this.getControl("iconBox");var o=this.getControl("iconSpacer");I.setVisible(false);o.setVisible(false);this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("exit","sap-icon://decline","BTN_EXIT");};A.prototype._switchToTexts=function(){var I=this.getControl("iconBox");var o=this.getControl("iconSpacer");I.setVisible(true);o.setVisible(true);this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("exit","BTN_EXIT");};A.prototype._onSizeChanged=function(p){if(!p){return Promise.resolve();}return this.onFragmentLoaded().then(function(){var m=p.name;this.sMode=m;switch(m){case A.modes.MOBILE:this._switchToIcons();break;case A.modes.TABLET:case A.modes.DESKTOP:this._switchToTexts();break;default:}}.bind(this));};A.prototype.buildControls=function(){return F.load({name:"sap.ui.rta.toolbar.Adaptation",id:this.getId()+"_fragment",controller:{activate:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),formatDiscardDraftEnabled:this.formatDiscardDraftEnabled.bind(this),modeChange:this.eventHandler.bind(this,"ModeChange"),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),showChangesPopover:this.showChangesPopover.bind(this),manageApps:this.eventHandler.bind(this,"ManageApps"),appVariantOverview:this.eventHandler.bind(this,"AppVariantOverview"),restore:this.eventHandler.bind(this,"Restore"),publish:this.eventHandler.bind(this,"Transport"),saveAs:this.eventHandler.bind(this,"SaveAs"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this),showRestore:this.showRestore.bind(this)}});};function h(){this.getControl("versionTitleInput").setValue("");this.getControl("confirmVersionTitleButton").setEnabled(false);return Promise.resolve(this._oDialog);}function i(){return F.load({name:"sap.ui.rta.toolbar.VersionTitleDialog",id:this.getId()+"_fragment",controller:{onConfirmVersioningDialog:function(){var v=this.getControl("versionTitleInput").getValue();this.fireEvent("activate",{versionTitle:v});this._oDialog.close();}.bind(this),onCancelVersioningDialog:function(){this._oDialog.close();}.bind(this),onVersionTitleLiveChange:function(E){var v=E.getParameter("value");this.getControl("confirmVersionTitleButton").setEnabled(!!v);}.bind(this)}}).then(function(o){this._oDialog=o;o.addStyleClass(U.getRtaStyleClassName());this.addDependent(this._oDialog);}.bind(this));}A.prototype.getControl=function(n){return sap.ui.getCore().byId(this.getId()+"_fragment--sapUiRta_"+n);};A.prototype._openVersionTitleDialog=function(n){var o;if(this._oDialog){o=h.call(this);}else{o=i.call(this);}return o.then(function(){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var T=t.getText("TIT_VERSION_TITLE_DIALOG");if(n!==V.Draft){T=t.getText("TIT_REACTIVATE_VERSION_TITLE_DIALOG");}this._oDialog.setTitle(T);return this._oDialog.open();}.bind(this));};A.prototype.setVersionButtonAccentColor=function(t){var v=this.getControl("versionButton");switch(t){case"draft":v.addStyleClass(d);v.removeStyleClass(e);break;case"active":v.addStyleClass(e);v.removeStyleClass(d);break;default:v.removeStyleClass(e);v.removeStyleClass(d);}};A.prototype.show=function(){return B.prototype.show.apply(this,arguments);};A.prototype.hide=function(){return B.prototype.hide.apply(this,arguments);};return A;},true);
