/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","./utils/TableUtils","./RowActionRenderer","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/unified/Menu","sap/ui/core/Popup"],function(l,T,R,C,I,M,P){"use strict";var a=C.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}}});a.prototype.init=function(){this._bFixedLayout=true;this._aActions=["",""];this._iLastCloseTime=0;this.addAggregation("_icons",new I(this.getId()+"-icon0",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var i=this.getAggregation("_icons")[0].getDomRef();if(this._aActions[0]==="menu"){i.setAttribute("aria-haspopup","menu");}else{i.removeAttribute("aria-haspopup");}}},this);this.addAggregation("_icons",new I(this.getId()+"-icon1",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){var i=this.getAggregation("_icons")[1].getDomRef();if(this._aActions[1]==="menu"){i.setAttribute("aria-haspopup","menu");}else{i.removeAttribute("aria-haspopup");}}},this);};a.prototype.onBeforeRendering=function(){var r=this.getRow();var t=r?r.getTable():null;var i=this.getAggregation("_icons");var b=this.getItems();var v=this._getVisibleItems();var V=v.length;var s=this._getSize();var h=t?t.getId()+"-rowacthdr":"";if(this._bFixedLayout&&V===1&&s===2&&b.length>1&&v[0]===b[1]){v[0]._syncIcon(i[1]);this._aActions=["","action_fixed"];}else if(V===0||s===0){this._aActions=["",""];}else if(V===1&&s>0){v[0]._syncIcon(i[0]);this._aActions=["action",""];}else if(V===2&&s===2){v[0]._syncIcon(i[0]);v[1]._syncIcon(i[1]);this._aActions=["action","action"];}else if(V>2&&s===2){v[0]._syncIcon(i[0]);i[1].setSrc("sap-icon://overflow");i[1].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["action","menu"];}else{i[0].setSrc("sap-icon://overflow");i[0].setTooltip(T.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["menu",""];}i.forEach(function(o,c){o.removeAllAriaLabelledBy();o.removeStyleClass("sapUiTableActionHidden");if(h){o.addAriaLabelledBy(h);}if(this._aActions[c]===""){o.addStyleClass("sapUiTableActionHidden");}}.bind(this));};a.prototype.getAccessibilityInfo=function(){var r=this.getRow();var v=this._getVisibleItems().length;var s=this._getSize();var A=this.getVisible()&&v>0&&s>0&&(!r||(!r.isContentHidden()&&!r.isGroupHeader()&&!r.isSummary()));var t;if(A){t=T.getResourceText(v==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[v]);}else{t=T.getResourceText("TBL_ROW_ACTION_NO_ACTION");}return{focusable:A,enabled:A,description:t};};a.prototype._getVisibleItems=function(){return this.getItems().filter(function(i){return i.getVisible();});};a.prototype.getRow=function(){var p=this.getParent();return T.isA(p,"sap.ui.table.Row")?p:null;};a.prototype._getSize=function(){var r=this.getRow();var t=r?r.getTable():null;return t?t.getRowActionCount():2;};a.prototype._onIconPress=function(e){var o=e.getSource();var b=this.indexOfAggregation("_icons",o);var A=this._aActions[b];if(A==="action"){this._getVisibleItems()[b]._firePress();}else if(A==="action_fixed"){this._getVisibleItems()[0]._firePress();}else if(A==="menu"){var m=this.getAggregation("_menu");if(!m){m=new M();this.setAggregation("_menu",m,true);m.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now();},this);}m.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return;}var c=this.getItems();for(var i=b;i<c.length;i++){m.addItem(c[i]._getMenuItem());}m.open(null,o,P.Dock.EndTop,P.Dock.EndBottom,o);}};return a;});
