/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarAppointment"],function(C,D,L,a,U,l,I,b,R,c,d,e,q,f){"use strict";var g=l.CalendarDayType;var h=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var m=l.CalendarIntervalType;var n=l.CalendarAppointmentHeight;var o=l.CalendarAppointmentRoundWidth;var r=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:m.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:h.Standard},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:n.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:o.None}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});r.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+t.call(this).getTimePattern("medium")});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};r.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};r.prototype.onBeforeRendering=function(){this._aVisibleAppointments=[];u.call(this);x.call(this);B.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(!this.getAppointments().length){this.aSelectedAppointments=[];}else{this.getAppointments().forEach(function(i){this._updateSelectedAppointmentsArray(i);}.bind(this));}};r.prototype.onAfterRendering=function(){E.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};r.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};r.prototype.invalidate=function(j){if(j&&j instanceof f){var k=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==j){k=true;break;}}if(k){this._aVisibleAppointments=[];}this._updateSelectedAppointmentsArray(j);}C.prototype.invalidate.apply(this,arguments);};r.prototype.setStartDate=function(S){if(!S){S=new Date();}a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};r.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};r.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};r.prototype._getAppointmentReducedHeight=function(i){var j=!D.system.phone&&this.getAppointmentsReducedHeight()&&i.size===n.Regular;return j;};r.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){M.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var p;for(var i=0;i<V.length;i++){p=V[i].appointment;if(e(p.getDomRef(),j.target)){k=true;p.focus();break;}}if(!k){p=this.getFocusedAppointment();if(p){p.focus();}}}};r.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};r.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){N.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};r.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){N.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};r.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};r.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};r.prototype.onsaphome=function(i){O.call(this,i);i.preventDefault();i.stopPropagation();};r.prototype.onsapend=function(i){O.call(this,i);i.preventDefault();i.stopPropagation();};r.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(e(k.getDomRef(),j.target)){F.call(this,k,!(j.ctrlKey||j.metaKey));break;}}j.stopPropagation();j.preventDefault();};r.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var p=false;for(k=0;k<j.length;k++){var S=j[k];if(!this._isOneMonthsRowOnSmallSizes()&&e(S,i.target)){p=true;break;}}if(p){P.call(this,k,i.target);}else{this.onsapselect(i);}};r.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};r.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");E.call(this);return this;};r.prototype.updateCurrentTimeVisualization=function(){var $=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var S=this._getStartDate();var p=S.getTime();var T=this._oUTCEndDate;var V=T.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=V&&i.getTime()>=p){var W=z.call(this,k,j,S,T,p,i);var X=0;if(this._bRTL){$.css("right",W+"%");}else{$.css("left",W+"%");}$.css("display","");if(this.getUpdateCurrentTime()){switch(k){case m.Hour:X=60000;break;case m.Day:case m.Week:case m.OneMonth:X=1800000;break;default:X=-1;break;}if(X>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),X);}}}else{$.css("display","none");}return this;};r.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var p;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){p=k[i];break;}}if(!p){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){p=j[i];break;}}}return p;};r.prototype.focusAppointment=function(i){if(!i||!(i instanceof f)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){M.call(this,j);}else{i.focus();}return this;};r.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var p;var S;var T;for(var i=0;i<k.length;i++){p=k[i];if(p.getStartDate()>j){if(i>0){S=k[i-1];}else{S=p;}break;}}if(p){if(S&&Math.abs(p.getStartDate()-j)>=Math.abs(S.getStartDate()-j)){T=S;}else{T=p;}this.focusAppointment(T);}return this;};r.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};r.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};r.prototype._getNonWorkingDays=function(){var j=this.getNonWorkingDays();if(!j){var k=t.call(this);var W=k.getWeekendStart();var p=k.getWeekendEnd();j=[];for(var i=0;i<=6;i++){if((W<=p&&i>=W&&i<=p)||(W>p&&(i>=W||i<=p))){j.push(i);}}}else if(!Array.isArray(j)){j=[];}return j;};r.prototype._isOneMonthsRowOnSmallSizes=function(){return this.getIntervalType()===m.OneMonth&&this.getIntervals()===1;};r.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=Q;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};r.prototype._setCustomAppointmentsSorterCallback=function(S){this._fnCustomSortedAppointments=S;this.invalidate();};r.prototype._calculateAppoitnmentVisualCue=function(i){if(_(this,i)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0};}var j=i.getStartDate(),k=i.getEndDate(),p=new U(j.getFullYear(),j.getMonth(),j.getDate(),j.getHours(),j.getMinutes()),S=new U(k.getFullYear(),k.getMonth(),k.getDate(),k.getHours(),k.getMinutes()),T=this.getIntervalType(),V=this.getStartDate(),W=T==="Hour"?new U(V.getFullYear(),V.getMonth(),V.getDate(),V.getHours()):new U(V.getFullYear(),V.getMonth(),V.getDate()),X=this.getIntervals(),Y;switch(T){case"Hour":Y=new U(V.getFullYear(),V.getMonth(),V.getDate(),V.getHours()+X);break;case"Day":case"Week":case"One Month":Y=new U(V.getFullYear(),V.getMonth(),V.getDate()+X);break;case"Month":Y=new U(V.getFullYear(),V.getMonth()+X,V.getDate());break;default:break;}return{appTimeUnitsDifRowStart:W.getTime()-p.getTime(),appTimeUnitsDifRowEnd:S.getTime()-Y.getTime()};};r.prototype._updateSelectedAppointmentsArray=function(i){if(i.getSelected()){if(this.aSelectedAppointments.indexOf(i.getId())===-1){this.aSelectedAppointments.push(i.getId());}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(j){return j!==i.getId();});}};function _(j,k){var p=j.getAggregation("groupAppointments",[]);var i;for(i=0;i<p.length;++i){if(k===p[i]){return true;}}return false;}function s(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function t(){if(!this._oLocaleData){var i=s.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function u(){var S=this.getStartDate();var i;var j=this.getIntervals();var k=this.getIntervalType();this._oUTCStartDate=v.call(this,S);switch(k){case m.Hour:i=new U(this._oUTCStartDate.getTime());i.setUTCHours(i.getUTCHours()+j);this._iMinDelta=this._iHoursMinDelta;break;case m.Day:case m.Week:case m.OneMonth:i=new U(this._oUTCStartDate.getTime());i.setUTCDate(i.getUTCDate()+j);this._iMinDelta=this._iDaysMinDelta;break;case m.Month:i=new U(this._oUTCStartDate.getTime());i.setUTCMonth(i.getUTCMonth()+j);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}i.setUTCMilliseconds(-1);this._iRowSize=i.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/j);this._oUTCEndDate=i;}function v(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case m.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case m.Day:case m.Week:case m.OneMonth:k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case m.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}function w(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}function x(){var p=this._getAppointmentsSorted();var S;var T;var V;var W=this.getIntervals();var X=this.getIntervalType();var Y=this._getStartDate();var Z=Y.getTime();var $=this._oUTCEndDate;var a1=$.getTime();var b1=[];var c1=false;var i=0;var j=0;var d1=w.call(this);var e1=this._needAppointmentHorizontalFit();this.destroyAggregation("groupAppointments",true);for(i=0;i<p.length;i++){S=p[i];var f1=a._createUniversalUTCDate(S.getStartDate(),undefined,true);var g1=f1.getTime();f1.setUTCSeconds(0);f1.setUTCMilliseconds(0);var h1=S.getEndDate()?a._createUniversalUTCDate(S.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);var i1=h1.getTime();h1.setUTCSeconds(0);h1.setUTCMilliseconds(0);var j1=false;if(f1.getTime()<Z&&h1.getTime()>=Z){f1=new U(Z);j1=true;}if(h1.getTime()>a1&&f1.getTime()<=a1){h1=new U(a1);j1=true;}var k1=f1.getUTCHours()*60+f1.getUTCMinutes();f1.setUTCMinutes(f1.getUTCMinutes()-(k1%this._iMinDelta));var l1=(h1.getTime()-f1.getTime())/60000;if(j1&&l1==0){continue;}var m1=0;var n1=0;var o1=-1;T=undefined;V=undefined;if(f1&&f1.getTime()<=a1&&h1&&h1.getTime()>=Z&&g1<i1){if(d1&&(X==m.Month)&&((h1.getTime()-f1.getTime())<604800000)){T=y.call(this,f1,S,X,W,Y,$,Z,b1);var p1=a._createUniversalUTCDate(T.getEndDate(),undefined,true);if(h1.getTime()>p1.getTime()){V=y.call(this,h1,S,X,W,Y,$,Z,b1);}}if(e1){this._setHorizontalRoundingWidth(S,f1,h1);}m1=z.call(this,X,W,Y,$,Z,f1);n1=A.call(this,X,W,Y,$,Z,h1);if(T){T._iBegin=m1;T._iEnd=n1;T._iLevel=o1;if(V){V._iBegin=m1;V._iEnd=n1;V._iLevel=o1;}continue;}b1.push({appointment:S,begin:m1,end:n1,calculatedEnd:n1,level:o1,size:this.getProperty("appointmentHeight")});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==S.getId()){c1=true;}}}var q1=this.getAggregation("groupAppointments",[]);if(q1.length>0){for(i=0;i<b1.length;i++){S=b1[i];if(S.appointment._aAppointments&&S.appointment._aAppointments.length<=1){T=S.appointment;var r1=false;if(T._aAppointments.length==0){r1=true;}else{for(j=0;j<b1.length;j++){if(b1[j].appointment==T._aAppointments[0]){r1=true;break;}}}if(!r1){for(j=0;j<q1.length;j++){V=q1[j];if(T!=V){for(var k=0;k<V._aAppointments.length;k++){if(T._aAppointments[0]==V._aAppointments[k]){V._aAppointments.splice(k,1);if(V._aAppointments.length==1){this.removeAggregation("groupAppointments",V);V.destroy();q1=this.getAggregation("groupAppointments",[]);}else{V.setProperty("title",V._aAppointments.length,true);}break;}}}}S.begin=T._iBegin;S.end=T._iEnd;S.calculatedEnd=T._iEnd;S.level=T._iLevel;S.appointment=T._aAppointments[0];}else{b1.splice(i,1);i--;}this.removeAggregation("groupAppointments",T);T.destroy();q1=this.getAggregation("groupAppointments",[]);}}}if(!c1){if(b1.length>0){this._sFocusedAppointmentId=b1[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=b1;return this._aVisibleAppointments;}function y(i,k,p,S,T,V,W,X){var Y=this.getAggregation("groupAppointments",[]);var Z;var $=t.call(this);var a1=$.getFirstDayOfWeek();var b1=i.getUTCDay();var c1=new U(i.getTime());c1.setUTCHours(0);c1.setUTCMinutes(0);c1.setUTCSeconds(0);c1.setUTCMilliseconds(0);if(a1<=b1){c1.setDate(c1.getDate()-(b1-a1));}else{c1.setDate(c1.getDate()-(7-b1-a1));}for(var j=0;j<Y.length;j++){Z=Y[j];var d1=a._createUniversalUTCDate(Z.getStartDate(),undefined,true);if(d1.getTime()==c1.getTime()){break;}Z=undefined;}if(!Z){var e1=new U(c1.getTime());e1.setDate(e1.getDate()+7);e1.setMilliseconds(-1);Z=new f(this.getId()+"-Group"+Y.length,{type:k.getType(),startDate:a._createLocalDate(new Date(c1.getTime()),true),endDate:a._createLocalDate(new Date(e1.getTime()),true)});Z._aAppointments=[];this.addAggregation("groupAppointments",Z,true);var f1=z.call(this,p,S,T,V,W,c1);var g1=A.call(this,p,S,T,V,W,e1);X.push({appointment:Z,begin:f1,end:g1,calculatedEnd:g1,level:-1,size:this.getProperty("appointmentHeight")});}Z._aAppointments.push(k);if(Z.getType()!=g.None&&Z.getType()!=k.getType()){Z.setType(g.None);}Z.setProperty("title",Z._aAppointments.length,true);return Z;}function z(i,j,S,k,p,T){var V=0;if(i!=m.Month){V=100*(T.getTime()-p)/this._iRowSize;}else{var W=new U(T.getTime());W.setUTCDate(1);W.setUTCHours(0);W.setUTCMinutes(0);W.setUTCSeconds(0);W.setUTCMilliseconds(0);var X=new U(W.getTime());X.setUTCMonth(X.getUTCMonth()+1);X.setMilliseconds(-1);var Y=X.getTime()-W.getTime();var Z=(W.getUTCFullYear()-S.getUTCFullYear())*12+W.getUTCMonth()-S.getUTCMonth();V=(100*Z/j)+(100*(T.getTime()-W.getTime())/Y)/j;}if(V<0){V=0;}V=Math.round(V*100000)/100000;return V;}function A(i,j,S,k,p,T){var V=0;if(i!=m.Month){V=100-(100*(T.getTime()-p)/this._iRowSize);}else{var W=new U(T.getTime());W.setUTCDate(1);W.setUTCHours(0);W.setUTCMinutes(0);W.setUTCSeconds(0);W.setUTCMilliseconds(0);var X=new U(W.getTime());X.setUTCMonth(X.getUTCMonth()+1);X.setMilliseconds(-1);var Y=X.getTime()-W.getTime();var Z=(W.getUTCFullYear()-S.getUTCFullYear())*12+W.getUTCMonth()-S.getUTCMonth();V=100-((100*Z/j)+(100*(T.getTime()-W.getTime())/Y)/j);}if(V<0){V=0;}V=Math.round(V*100000)/100000;return V;}function B(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var p;var S=this.getIntervals();var T=this.getIntervalType();var W=this._getStartDate();var X=W.getTime();var Y=this._oUTCEndDate;var Z=Y.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){p=k[i];var $=a._createUniversalUTCDate(p.getStartDate(),undefined,true);$.setUTCSeconds(0);$.setUTCMilliseconds(0);var a1=p.getEndDate()?a._createUniversalUTCDate(p.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);a1.setUTCSeconds(0);a1.setUTCMilliseconds(0);if($&&$.getTime()<=Z&&a1&&a1.getTime()>=X){var b1=new U(W.getTime());var c1=new U(W.getTime());c1.setUTCMinutes(c1.getUTCMinutes()-1);var d1=-1;var e1=-1;for(j=0;j<S;j++){switch(T){case m.Hour:c1.setUTCHours(c1.getUTCHours()+1);if(j>0){b1.setUTCHours(b1.getUTCHours()+1);}break;case m.Day:case m.Week:case m.OneMonth:c1.setUTCDate(c1.getUTCDate()+1);if(j>0){b1.setUTCDate(b1.getUTCDate()+1);}break;case m.Month:c1.setUTCDate(1);c1.setUTCMonth(c1.getUTCMonth()+2);c1.setUTCDate(0);if(j>0){b1.setUTCMonth(b1.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+T+"; "+this);}if($&&$.getTime()<=b1.getTime()&&a1&&a1.getTime()>=c1.getTime()){if(d1<0){d1=j;}e1=j;}}if(d1>=0){V.push({interval:d1,appointment:p,last:e1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function E(){if(this._isOneMonthsRowOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var p=this.$("DummyApp");var S=p.outerHeight(true);if(S<=0){return;}var T=4;var V=p.outerWidth();var W=V/k*100;var X=Math.ceil(1000*W)/1000;var Y;var Z;var a1=0;var b1=0;var i=0;var c1=false;var d1;var e1=this._needAppointmentHorizontalFit();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){a1=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);c1=true;}for(i=0;i<this._aVisibleAppointments.length;i++){Y=this._aVisibleAppointments[i];Z=Y.appointment.$();var f1=Math.floor(1000*(100-Y.calculatedEnd-Y.begin))/1000;var g1=false;if(f1<X){Y.end=100-Y.begin-W;if(Y.end<0){Y.end=0;}Y.level=-1;g1=true;Z.addClass("sapUiCalendarAppSmall");}else if(Z.hasClass("sapUiCalendarAppSmall")){Y.end=Y.calculatedEnd;g1=true;Z.removeClass("sapUiCalendarAppSmall");}if(g1&&!e1){if(this._bRTL){Z.css("left",Y.end+"%");}else{Z.css("right",Y.end+"%");}}if(e1){Y.end=Y.calculatedEnd;}}for(i=0;i<this._aVisibleAppointments.length;i++){Y=this._aVisibleAppointments[i];Z=Y.appointment.$();var h1={};if(Y.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var i1=this._aVisibleAppointments[j];if(Y!=i1&&Y.begin<(Math.floor(1000*(100-i1.end))/1000)&&(Math.floor(1000*(100-Y.end))/1000)>i1.begin&&i1.level>=0){this._setBlockedLevelsForAppointment(i1,h1);}}Y.level=this._getAppointmetLevel(h1,Y);Z.attr("data-sap-level",Y.level);}d1=S*Y.level+a1;if(!c1){d1+=T;}Z.css("top",d1+"px");var j1=Y.level;j1+=this._getAppointmentRowCount(Y)-1;if(b1<j1){b1=j1;}}b1++;S=S*b1+a1;if(!c1){S+=T;}if(!this.getHeight()){$.outerHeight(S);}else{var k1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<k1.length;i++){var l1=q(k1[i]);l1.outerHeight(S);}}p.css("display","none");}function F(j,k){var i=0;var p;var S;var T;var V;var W=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");if(k){var X=this.getAppointments();var Y=this.getAggregation("groupAppointments",[]);q.merge(X,Y);for(i=0;i<X.length;i++){p=X[i];if(p.getId()!==j.getId()&&p.getSelected()){p.setProperty("selected",false,true);p.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==p.getId()){this.aSelectedAppointments.splice(i);}}S=p.$().attr("aria-labelledby");T=S?S.replace(W,""):"";p.$().attr("aria-labelledby",T);}}}V=j.$().attr("aria-labelledby")+" "+W;T=j.$().attr("aria-labelledby").replace(W,"").trim();if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",T);J(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",V);J(this,k);}this._updateSelectedAppointmentsArray(j);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){p=j._aAppointments[i];p.setProperty("selected",true,true);V=p.$().attr("aria-labelledby")+" "+W;p.$().attr("aria-labelledby",V);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}function H(i){var p=this._getPlanningCalendar();if(p){p["_onRow"+i]();}}r.prototype._needAppointmentHorizontalFit=function(){var p=this._getPlanningCalendar(),k,V,i;if(!p||this.getAppointmentRoundWidth()===o.None){return false;}k=p.getViewKey();V=p._getView(k);i=p._getIntervals(V);return i>=20;};r.prototype._setHorizontalRoundingWidth=function(i,j,k){var p;switch(this.getAppointmentRoundWidth()){case o.HalfColumn:p=12;break;}this._roundAppointment(i,j,k,p);};r.prototype._roundAppointment=function(i,j,k,p){var S,T;S=i.getStartDate().getHours()-i.getStartDate().getHours()%p;j.setUTCHours(S);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);T=i.getEndDate().getHours()-i.getEndDate().getHours()%p+p;k.setUTCHours(T);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);};r.prototype._setBlockedLevelsForAppointment=function(V,i){var j=this._getAppointmentRowCount(V);for(var k=0;k<j;k++){i[V.level+k]=true;}return i;};r.prototype._getAppointmentRowCount=function(V){var i,j=this._getAppointmentReducedHeight(V);switch(V.size){case n.HalfSize:i=1;break;case n.Regular:i=2;if(j&&!V.appointment.getText()&&!V.appointment.getDescription()){i=1;}break;case n.Large:i=3;break;case n.Automatic:i=1;if(V.appointment.getText()){i+=1;}if(V.appointment.getDescription()){i+=1;}break;}return i;};r.prototype._getAppointmetLevel=function(i,j){var k=0;var p=this._getAppointmentRowCount(j);var S=true;while(S){S=this._isPosibleToPositionAppointment(k,i,p);if(!S){S=true;k+=1;}else{S=false;}}return k;};r.prototype._isPosibleToPositionAppointment=function(i,j,k){for(var p=i;p<k+i;p++){if(j[p]){return false;}}return true;};r.prototype._getPlanningCalendar=function(){var p=this;while(p.getParent()!==null){if(p.isA("sap.m.PlanningCalendar")){return p;}p=p.getParent();}};function J(i,j){if(j){H.call(i,"DeselectAppointment");}}function K(k){var p=this.getAggregation("groupAppointments",[]);var S;var T=false;for(var i=0;i<p.length;i++){var V=p[i]._aAppointments;for(var j=0;j<V.length;j++){if(V[j].getId()==k){S=p[i];T=true;break;}}if(T){break;}}return S;}function M(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var p;var i=0;p=K.call(this,j);if(p){j=p.getId();p=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){p=V[i].appointment;break;}}if(p){var $=this.getFocusedAppointment().$();var S=p.$();this._sFocusedAppointmentId=p.getId();$.attr("tabindex","-1");S.attr("tabindex","0");S.trigger("focus");}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){p=k[i];break;}}if(p){this._sFocusedAppointmentId=p.getId();var T=v.call(this,p.getStartDate());this.setStartDate(a._createLocalDate(T,true));if(!e(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus();}.bind(this),0);}this.fireStartDateChange();}}}}function N(j,S){var k=this._sFocusedAppointmentId;var p=this._getAppointmentsSorted();var T=this.getAggregation("groupAppointments",[]);var V;var W=0;var i=0;for(i=0;i<T.length;i++){if(T[i].getId()==k){var X=T[i]._aAppointments;if(j){k=X[X.length-1].getId();}else{k=X[0].getId();}break;}}for(i=0;i<p.length;i++){if(p[i].getId()==k){W=i;break;}}if(j){W=W+S;}else{W=W-S;}if(W<0){W=0;}else if(W>=p.length){W=p.length-1;}V=p[W];M.call(this,V.getId());}function O(j){var k=this._getAppointmentsSorted();var p;var S=new U(this._getStartDate());var T=new U(this._oUTCEndDate);var V=this.getIntervalType();var W;var X;S.setUTCHours(0);T.setUTCHours(0);T.setUTCMinutes(0);T.setUTCSeconds(0);switch(V){case m.Hour:T.setUTCDate(T.getUTCDate()+1);T.setUTCMilliseconds(-1);break;case m.Day:case m.Week:case m.OneMonth:S.setUTCDate(1);T.setUTCMonth(T.getUTCMonth()+1);T.setUTCDate(1);T.setUTCMilliseconds(-1);break;case m.Month:S.setUTCMonth(0);S.setUTCDate(1);T.setUTCFullYear(T.getUTCFullYear()+1);T.setUTCMonth(1);T.setUTCDate(1);T.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+V+"; "+this);}var Y=a._createLocalDate(S,true);var Z=a._createLocalDate(T,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=Y&&k[i].getStartDate()<=Z){p=k[i];W=p.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>Z){break;}}X=K.call(this,W);if(X){p=X;W=p.getId();}if(W&&W!=this._sFocusedAppointmentId){M.call(this,W);}else if(j._bPlanningCalendar&&p){p.focus();}else{this.fireLeaveRow({type:j.type});}}function P(i,j){var k=this.getIntervalType();var S=this._getStartDate();var p=new U(S.getTime());var T;var V=false;var W=0;var X=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){V=true;var Y=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");X=Y.length;for(W=0;W<X;W++){var Z=Y[W];if(Z==j){break;}}}switch(k){case m.Hour:p.setUTCHours(p.getUTCHours()+i);if(V){p.setUTCMinutes(p.getUTCMinutes()+W*60/X);T=new U(p.getTime());T.setUTCMinutes(T.getUTCMinutes()+60/X);}else{T=new U(p.getTime());T.setUTCHours(T.getUTCHours()+1);}break;case m.Day:case m.Week:case m.OneMonth:p.setUTCDate(p.getUTCDate()+i);if(V){p.setUTCHours(p.getUTCHours()+W*24/X);T=new U(p.getTime());T.setUTCHours(T.getUTCHours()+24/X);}else{T=new U(p.getTime());T.setUTCDate(T.getUTCDate()+1);}break;case m.Month:p.setUTCMonth(p.getUTCMonth()+i);if(V){p.setUTCDate(p.getUTCDate()+W);T=new U(p.getTime());T.setUTCDate(T.getUTCDate()+1);}else{T=new U(p.getTime());T.setUTCMonth(T.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}T.setUTCMilliseconds(T.getUTCMilliseconds()-1);p=a._createLocalDate(p,true);T=a._createLocalDate(T,true);this.fireIntervalSelect({startDate:p,endDate:T,subInterval:V});}function Q(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}return r;});
