/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/format/NumberFormat',"./CurrencyRenderer"],function(C,N,a){"use strict";var b=C.extend("sap.ui.unified.Currency",{metadata:{library:"sap.ui.unified",properties:{value:{type:"float",group:"Appearance",defaultValue:0},stringValue:{type:"string",group:"Appearance",defaultValue:null},currency:{type:"string",group:"Appearance",defaultValue:null},maxPrecision:{type:"int",group:"Appearance",defaultValue:3},useSymbol:{type:"boolean",group:"Appearance",defaultValue:true}},designtime:"sap/ui/unified/designtime/Currency.designtime",dnd:{draggable:true,droppable:false}}});b.FIGURE_SPACE='\u2007';b.PUNCTUATION_SPACE='\u2008';b.prototype.init=function(){this._oFormat=N.getCurrencyInstance({showMeasure:false});};b.prototype.exit=function(){this._oFormat=null;this._$Value=null;this._$Currency=null;this._sLastCurrency=null;this._iLastCurrencyDigits=null;this._bRenderNoValClass=null;};b.prototype.onAfterRendering=function(){if(this.$()){this._$Value=this.$().find(".sapUiUfdCurrencyValue");this._$Currency=this.$().find(".sapUiUfdCurrencyCurrency");}};b.prototype.setValue=function(v){if(this.isBound("value")){this._bRenderNoValClass=v==null;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",this._bRenderNoValClass);}}this.setProperty("value",v,true);this._renderValue();return this;};b.prototype.unbindProperty=function(p){C.prototype.unbindProperty.apply(this,arguments);if(p==="value"){this._bRenderNoValClass=false;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}};b.prototype.setCurrency=function(v){var c,r;this.setProperty("currency",v,true);this._renderCurrency();c=this._oFormat.oLocaleData.getCurrencyDigits(v);if(this._iLastCurrencyDigits!=null&&this._iLastCurrencyDigits!==c){r=true;}else if(this._oFormat.oLocaleData.getCurrencyDigits()!==c){r=true;}this._iLastCurrencyDigits=c;if(this._sLastCurrency==="*"||v==="*"){r=true;}this._sLastCurrency=v;if(r){this._renderValue();if(v==="*"&&this.$()){this._bRenderNoValClass=false;this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}return this;};b.prototype.setUseSymbol=function(v){this.setProperty("useSymbol",v,true);this._renderCurrency();return this;};b.prototype.setMaxPrecision=function(v){this.setProperty("maxPrecision",v,true);this._renderValue();return this;};b.prototype._renderValue=function(){if(this._$Value){this._$Value.text(this.getFormattedValue());}};b.prototype._renderCurrency=function(){if(this._$Currency){this._$Currency.text(this._getCurrency());}};b.prototype._getCurrency=function(){return this.getUseSymbol()?this.getCurrencySymbol():this.getCurrency();};b.prototype.getFormattedValue=function(){var c=this.getCurrency(),m,p,i,f;if(c==="*"){return"";}i=this._oFormat.oLocaleData.getCurrencyDigits(c);m=this.getMaxPrecision();m=(m<=0&&i>0?m-1:m);p=m-i;f=this._oFormat.format(this.getStringValue()||this.getValue(),c);if(p==m&&m>0){f+=b.PUNCTUATION_SPACE;}if(p>0){f=f.padEnd(f.length+p,b.FIGURE_SPACE);}else if(p<0){f=f.substr(0,f.length+p);}return f;};b.prototype.getCurrencySymbol=function(){return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency());};b.prototype.getAccessibilityInfo=function(){if(this._bRenderNoValClass){return{};}return{description:(this.getFormattedValue()||"")+" "+(this.getCurrency()||"").trim()};};return b;});
