/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Object","./ObjectPageSubSection","./library","sap/base/Log","sap/base/util/isEmptyObject"],function(q,D,B,O,l,L,i){"use strict";var a=B.extend("sap.uxap._helpers.LazyLoading",{constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._bSuppressed=false;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters();},getInterface:function(){return this;}});a.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;this.LAZY_LOADING_EXTRA_SUBSECTION=this.LAZY_LOADING_DELAY*5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};a.prototype.suppress=function(){this._bSuppressed=true;};a.prototype.resume=function(){this._bSuppressed=false;};a.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading();};a.prototype.lazyLoadDuringScroll=function(I,s,t,p){var P,d,f=false;if(this._bSuppressed){return;}if(I){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}this._sLazyLoadingTimer=null;this.doLazyLoading();return;}this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){L.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),d);}};a.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),I=this._oObjectPageLayout.getUseIconTabBar(),s=sap.ui.getCore().byId(this._oObjectPageLayout.getSelectedSection()),S=this._oObjectPageLayout._oSectionInfo,b,c,p,d=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},f={},t,g,j;if(this._bSuppressed){return;}p=(h.iScreenHeight-(d?h.iAnchorBarHeight:0)-(d?h.iHeaderTitleHeightStickied:0));b=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;g=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(g){if(this._iScrollProgress>=0){j=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{j=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}b+=j;L.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+j);}c=b+p;b+=16;q.each(S,q.proxy(function(k,m){if(!m.isSection&&m.sectionReference.getParent()&&m.sectionReference.getParent().getVisible()){if(I&&s&&s.indexOfSubSection(m.sectionReference)<0){return;}if(m.positionTop<=c&&b<m.positionBottom-1){f[k]=k;if(!m.loaded){o[k]=k;}}else if(!m.loaded&&m.positionTop>c&&m.positionTop<c+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||m.positionTop<E)){E=m.positionTop;e=k;}}},this));if(E!=-1&&i(o)){L.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(k,m){L.debug("ObjectPageLayout :: lazyLoading","connecting "+m);sap.ui.getCore().byId(m).connectToModels();S[m].loaded=true;},this));q.each(f,q.proxy(function(k,m){if(!this._oPrevSubSectionsInView[k]){L.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+m);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(m)});}},this));this._oPrevSubSectionsInView=f;if(g){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY);}else{if(E){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_EXTRA_SUBSECTION);}else{this._sLazyLoadingTimer=null;}}};a.prototype.getSubsectionsToPreload=function(A,I){var s,t;if(I){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];A.some(function(o){if(!t&&I){t=o.getId()==I;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};a.prototype.destroy=function(){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}};a.prototype._isPhone=function(){return l.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};a.prototype._isTablet=function(){return D.system.tablet;};a.prototype._isTabletSize=function(){return l.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};return a;});
