/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/m/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/events/F6Navigation","sap/ui/dom/getFirstEditableInput","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem'],function(q,M,R,C,a,D,b,S,O,c,d,e,L,A,T,f,g,l,h,i,j,k,m,n,o,K,F,p,P,r){"use strict";var s=g.TitleLevel;var t=g.AccessibleLandmarkRole;var u=l.ObjectPageSubSectionLayout;var v=a.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:u.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:s.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});v.HEADER_CALC_DELAY=350;v.DOM_CALC_DELAY=200;v.MAX_SNAP_POSITION_OFFSET=20;v.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;v.TITLE_LEVEL_AS_ARRAY=Object.keys(s);v.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};v.BREAK_POINTS={TABLET:1024,PHONE:600};v.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop"};v.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};v.DIV="div";v.HEADER="header";v.FOOTER="section";v.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";v.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";v.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";v.prototype._getFirstEditableInput=function(x){var y=this.getDomRef(x);return p(y);};v.prototype._focusFirstEditableInput=function(x){this._getFirstEditableInput(x).focus();};v._getNextTitleLevelEntry=function(x){var y=v.TITLE_LEVEL_AS_ARRAY.indexOf(x),z=y!==-1,H=z&&(y!==v.TITLE_LEVEL_AS_ARRAY.length-1);if(!z){return s.Auto;}return v.TITLE_LEVEL_AS_ARRAY[H?y+1:y];};v._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};v.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(q("body").css("font-size"));this._iOffset=parseInt(0.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();};v.prototype.onBeforeRendering=function(){var H,x;this._deregisterScreenSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy();}this._oLazyLoading=new L(this);this._deregisterCustomEvents();if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();if(!n(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){x=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(x);if(x){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(D.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter());}this._$titleArea=[];};v.prototype.setBackgroundDesignAnchorBar=function(B){var x=this.getBackgroundDesignAnchorBar();if(x===B){return this;}this.setProperty("backgroundDesignAnchorBar",B);this._oABHelper._getAnchorBar().setBackgroundDesign(B);return this;};v.prototype.setToggleHeaderOnTitleClick=function(x){var y=this.getHeaderTitle(),z=this.setProperty("toggleHeaderOnTitleClick",x,true);if(!y||!y.supportsToggleHeaderOnTitleClick()){i.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return z;}x=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return z;};v.prototype._attachTitlePressHandler=function(){var x=this.getHeaderTitle();if(w(x)&&!this._bAlreadyAttachedTitlePressHandler){x.attachEvent(v.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};v.prototype._toggleHeaderVisibility=function(x){var H=this._getHeaderContent();if(w(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!x);}};v.prototype._snapHeader=function(x){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin();H.getAggregation("_pinButton").setPressed(false);x=true;}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(x);this._moveAnchorBarToTitleArea();if(x){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};v.prototype._expandHeader=function(x){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(x){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();};v.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return;}var E=!this._bHeaderExpanded,I,x,y;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));x=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(x);if(!x){this._scrollTo(0,0);}}else{y=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(y);}this.getHeaderTitle()._getFocusSpan().trigger("focus");};v.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(w(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(v.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};v.prototype._handleExpandButtonPressEventLifeCycle=function(x){var H=this.getHeaderTitle(),y=this._hasDynamicTitle(),E;if(H&&!y){E=H.getAggregation("_expandButton");if(E){E[x?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};v.prototype._adjustSelectedSectionByUXRules=function(){var x=this.oCore.byId(this.getSelectedSection()),V=x&&this._sectionCanBeRenderedByUXRules(x);if(!V){if(this._oFirstVisibleSection){x=this._oFirstVisibleSection;this.setAssociation("selectedSection",x.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}};v.prototype._sectionCanBeRenderedByUXRules=function(x){if(!(x instanceof O)){return false;}var y=x.getBindingInfo("subSections");if(!y&&(!x.getVisible()||!x._getInternalVisible())){return false;}var z=this._aSectionBases.map(function(B){return B.getId();});return(z.indexOf(x.getId())>-1);};v.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var x=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&x){return[x];}else{return this.getSections();}};v.prototype._preloadSectionsOnBeforeFirstRendering=function(){var x=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(x);if(this.getEnableLazyLoading()){x.forEach(function(y){this.fireEvent("subSectionPreload",{subSection:y});},this);}};v.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var x,y,I;if(!this.getEnableLazyLoading()){return this._getSectionsToRender();}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases());}this._adjustSelectedSectionByUXRules();y=this.oCore.byId(this.getSelectedSection());if(!y||(y===this._oFirstVisibleSection)){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases);}I=this.indexOfSection(y);var z=function(B){var E=B.isA("sap.uxap.ObjectPageSection")?B:B.getParent();return this.indexOfSection(E)>=I;}.bind(this);x=this._aSectionBases.filter(z);return this._oLazyLoading.getSubsectionsToPreload(x);};v.prototype._grepCurrentTabSectionBases=function(){var x=[],y,z,B,E;this._adjustSelectedSectionByUXRules();y=this.oCore.byId(this.getSelectedSection());if(y){z=y.getId();this._aSectionBases.forEach(function(G){B=G.getParent();E=B&&B.getId();if(G.getId()===z||E===z){x.push(G);}});}return x;};v.prototype.onAfterRendering=function(){var H=this._getHeaderContent(),x=this.getFooter(),y,W=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._ensureCorrectParentHeight();if(this._$sectionsContainer){this._$sectionsContainer.off("focusout");this._$sectionsContainer.off("focusin");}this._cacheDomElements();if(this._$sectionsContainer){this._$sectionsContainer.on("focusin",function(){this._skipToNextFastGroup=true;}.bind(this));this._$sectionsContainer.on("focusout",function(){this._skipToNextFastGroup=false;}.bind(this));}if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle");}if(W>0){this._updateMedia(W,v.MEDIA);}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",H.getPinnable());}if(x){y=v._getLibraryResourceBundle().getText("FOOTER_ARIA_LABEL");x.$().attr("aria-label",y);}this._handleExpandButtonPressEventLifeCycle(true);};v.prototype._onAfterRenderingDomReady=function(){var x,y,z,W=this._getWidth(this);if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();x=this.getSelectedSection();y=this.oCore.byId(x);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(x){if(this.getUseIconTabBar()){this._setSelectedSectionId(x);this._setCurrentTabSection(y);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(y);this._checkSubSectionVisibilityChange();}else{this.scrollToSection(x,0);}}this._toggleScrolling(!this._bAllContentFitsContainer);if(D.system.desktop){this._$opWrapper.on("scroll.OPL",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){z=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(z);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(W,v.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(W,v.DYNAMIC_HEADERS_MEDIA);}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady");};v.prototype._toggleScrolling=function(E){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=E?"auto":"hidden";}};v.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),x=this._calculateShiftOffset();$.css(x.sStyleAttribute,x.iMarginalsOffset+"px");};v.prototype._calculateShiftOffset=function(){var H=0,x=this.oCore.getConfiguration().getRTL()?"left":"right",y=this._hasVerticalScrollBar(),z=this._iOffset,B;if(D.system.desktop){B=k().width;H=B;if(!y){H=0;z+=B;}}return{"sStyleAttribute":x,"iActionsOffset":z,"iMarginalsOffset":H};};v.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?v.HEADER_CALC_DELAY:0;};v.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null;}this._deregisterScreenSizeListener();if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};v.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var V=new f(this.getId()+"-vertSB",{scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",V,true);}return this.getAggregation("_customScrollBar");};v.prototype.onWrapperScroll=function(E){var x=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(x);}};v.prototype.onCustomScrollerScroll=function(E){var x=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(x);};v.prototype.setShowOnlyHighImportance=function(V){var x=this.getShowOnlyHighImportance();if(x!==V){this.setProperty("showOnlyHighImportance",V,true);this.getSections().forEach(function(y){y._updateImportance();});}return this;};v.prototype.setIsHeaderContentAlwaysExpanded=function(V){var x=this.getAlwaysShowContentHeader();var y=(D.system.phone||D.system.tablet);if(x!==V){this.setProperty("alwaysShowContentHeader",V,y);}return this;};v.prototype.setShowEditHeaderButton=function(V){var x=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(x!==V){this.setProperty("showEditHeaderButton",V,true);H&&H.invalidate();}return this;};v.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};v.prototype.setSelectedSection=function(I){var x,y;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){m(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this;}this.scrollToSection(I);x=c._getClosestSection(I);y=(x instanceof c)?x.getId():x;return this.setAssociation("selectedSection",y,true);};v.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange();}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0);}}};v.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};v.prototype._cacheDomElements=function(){this._$footerWrapper=q(document.getElementById(this.getId()+"-footerWrapper"));this._$titleArea=q(document.getElementById(this.getId()+"-headerTitle"));this._$anchorBar=q(document.getElementById(this.getId()+"-anchorBar"));this._$stickyAnchorBar=q(document.getElementById(this.getId()+"-stickyAnchorBar"));this._$opWrapper=q(document.getElementById(this.getId()+"-opwrapper"));this._$spacer=q(document.getElementById(this.getId()+"-spacer"));this._$headerContent=q(document.getElementById(this.getId()+"-headerContent"));this._$stickyHeaderContent=q(document.getElementById(this.getId()+"-stickyHeaderContent"));this._$contentContainer=q(document.getElementById(this.getId()+"-scroll"));this._$sectionsContainer=q(document.getElementById(this.getId()+"-sectionsContainer"));this._$skipFastGroupAnchor=q(document.getElementById(this.getId()+"-skipFastGroupAnchor"));this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};v.prototype._handleExpandButtonPress=function(E){this._expandHeader(true);};v.prototype._toggleHeaderTitle=function(E,U){var H=this.getHeaderTitle();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!E);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!E);}if(E){H&&H.unSnap(U);}else{H&&H.snap(U);}};v.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};v.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};v.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};v.prototype._applyUxRules=function(I){var x,y,V,z,B,E,U,G,H,J,N,Q,W={};x=this.getSections()||[];z=0;E=this.getShowAnchorBar();U=this.getUseIconTabBar();G=null;this._cleanMemory();x.forEach(function(X){if(!X.getVisible()){return true;}this._registerSectionBaseInfo(X);y=X.getSubSections()||[];V=0;H=null;y.forEach(function(Y){if(!Y.getVisible()){return true;}this._registerSectionBaseInfo(Y);B=Y.getVisibleBlocksCount();if(B===0){Y._setInternalVisible(false,I);i.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+Y.getTitle()+" forced to hidden");}else{Y._setInternalVisible(true,I);W[Y.getId()]=true;V++;if(!H){H=Y;}if(this._shouldApplySectionTitleLevel(Y)){Y._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(Y));}}},this);if(V==0){X._setInternalVisible(false,I);i.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+X.getTitle()+" forced to hidden");}else{X._setInternalVisible(true,I);W[X.getId()]=true;if(!G){G=X;Q=V;}if(this.getSubSectionLayout()===u.TitleOnTop&&V===1&&H.getTitle().trim()!==""){i.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+X.getTitle()+" is taking its single subsection title "+H.getTitle());X._setInternalTitle(H.getTitle(),I);W[H.getId()]=false;H._setBorrowedTitleDomId(X.getId()+"-title");}else{X._setInternalTitle("",I);}if(V===1&&!H.getTitle().trim()){H._setBorrowedTitleDomId(X.getId()+"-title");}if(this._shouldApplySectionTitleLevel(X)){X._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(X));}z++;}if(U){W[X.getId()]=false;}},this);if(z<=1){E=false;i.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(U&&G){W[G.getId()]=true;}}else if(G&&E){J=true;W[G.getId()]=false;i.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+G.getTitle()+" title forced to hidden");}this.toggleStyleClass(v.NO_NAVIGATION_CLASS_NAME,z<=1);Object.keys(W).forEach(function(X){this.oCore.byId(X)._setInternalTitleVisible(W[X],I);}.bind(this));if(E){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(E,I);this._oFirstVisibleSection=G;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(G);this._bAllContentFitsContainer=(z===1)&&(V===1)&&this._oFirstVisibleSubSection.hasStyleClass(d.FIT_CONTAINER_CLASS);if(J&&(Q===1)){N=this.getAggregation("_anchorBar").getContent();if(N.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(N[0].getId()+"-content");}}this._checkSubSectionVisibilityChange();};v.prototype._checkSubSectionVisibilityChange=function(){var U=this.getUseIconTabBar(),x=U&&sap.ui.getCore().byId(this.getSelectedSection()),y=x?[x]:this._getVisibleSections(),V={},I;y.forEach(function(z){z.getSubSections().forEach(function(B){I=B.getVisible()&&B._getInternalVisible();if(I){V[B.getId()]=B;}});});if(j(Object.keys((this._oVisibleSubSections)),Object.keys(V)).length){this._oVisibleSubSections=V;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:V});}};v.prototype.setUseIconTabBar=function(V){var x=this.getUseIconTabBar();if(V!=x){this._applyUxRules();}this.setProperty("useIconTabBar",V);return this;};v.prototype.onsapskipforward=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,true);}};v.prototype.onsapskipback=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,false);}};v.prototype._handleGroupNavigation=function(E,x){var y={target:x?this._$skipFastGroupAnchor[0]:this._$sectionsContainer[0]};E.type="keydown";F.handleF6GroupNavigation(E,y);};v.prototype._setCurrentTabSection=function(x,I){if(!x){return;}var y;if(x instanceof sap.uxap.ObjectPageSubSection){y=x;x=x.getParent();}else{y=this._getFirstVisibleSubSection(x);}if(this._oCurrentTabSection!==x){this._renderSection(x);this._oCurrentTabSection=x;}this._oCurrentTabSubSection=y;};v.prototype._renderSection=function(x){var $=this.$().find(".sapUxAPObjectPageContainer"),y;if(x&&$.length){y=this.oCore.createRenderManager();this.getSections().forEach(function(z){if((z.getId()===x.getId())){y.renderControl(x);}else{y.cleanupControlWithoutRendering(z);}});y.flush($[0]);y.destroy();}};v.prototype.setShowAnchorBarPopover=function(V,x){var y=this.getProperty("showAnchorBarPopover"),V=this.validateProperty("showAnchorBarPopover",V),z=this.getSelectedSection();if(V===y){return this;}this._oABHelper._getAnchorBar().setShowPopover(V);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(z);return this.setProperty("showAnchorBarPopover",V,true);};v.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};v.prototype._setInternalAnchorBarVisible=function(V,I){if(V!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=V;if(I===true){this.invalidate();}}};v.prototype.setUpperCaseAnchorBar=function(V){this._oABHelper._getAnchorBar().setProperty("upperCase",V);return this.setProperty("upperCaseAnchorBar",V,true);};v.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,v.DOM_CALC_DELAY,this);}if(!I){i.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+v.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(x){});};v.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,v.DOM_CALC_DELAY,this);}if(!I){i.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+v.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(x){});};v.prototype._adjustLayoutAndUxRules=function(){var x,y;i.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();x=this.getSelectedSection();y=this.oCore.byId(x);if(y){this._setSelectedSectionId(x);if(this.getUseIconTabBar()){this._setCurrentTabSection(y);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(y);}this._requestAdjustLayout(true).then(function(z){if(z){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();x=this.getSelectedSection();if(!this._isClosestScrolledSection(x)||this._oScroller._$Container.is(":animated")){this.scrollToSection(x,null,0,false,true);}}.bind(this));}};v.prototype._isClosestScrolledSection=function(x){var y=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,z=this.iScreenHeight,B=this._getClosestScrolledSectionId(y,z);return B&&(x===B);};v.prototype._setSelectedSectionId=function(x){var y=this.getAggregation("_anchorBar"),z=x&&this._oSectionInfo[x];if(!z){return;}if(y&&z.buttonId){y.setSelectedButton(z.buttonId);this.setAssociation("selectedSection",x,true);}};v.prototype.isFirstRendering=function(){return this._bFirstRendering;};v.prototype._cleanMemory=function(){var x=this.getAggregation("_anchorBar");if(x){x._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};v.prototype._registerSectionBaseInfo=function(x){this._oSectionInfo[x.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(x instanceof c),sectionReference:x};this._aSectionBases.push(x);};v.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};v.prototype.scrollToSection=function(I,x,y,z,B){var E=this.oCore.byId(I),G,H,J=(sap.ui.getCore().getConfiguration().getAnimationMode()!==C.AnimationMode.none),N;if(!this.getDomRef()){i.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!E){i.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]||!E._getInternalVisible()){i.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){i.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var Q=c._getClosestSection(E);var W=this._bAllContentFitsContainer,U;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(Q);this._toggleScrolling(!this._bAllContentFitsContainer);U=this._bAllContentFitsContainer!==W;if(U&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true;}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}Q._allowPropagationToLoadedViews(true);this._setCurrentTabSection(E);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[Q.getId()].buttonId);this.setAssociation("selectedSection",Q.getId(),true);this._checkSubSectionVisibilityChange();}H=E instanceof d?E:this._getFirstVisibleSubSection(E);if(z){this.fireNavigate({section:c._getClosestSection(E),subSection:H});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}y=y||0;E._expandSection();this._requestAdjustLayout(true);x=this._computeScrollDuration(x,E);var V=this._computeScrollPosition(E);if(this._sCurrentScrollId!=I||B){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),x);}this._preloadSectionsOnBeforeScroll(E);this.getHeaderTitle()&&this._shiftHeaderTitle();V+=y;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(V)){G=this._getSnapPosition();this._scrollTo(G,0);if(G===0){this._toggleHeader(true);}}N=J&&x&&this.getEnableLazyLoading();this._scrollTo(V,x,N);}};v.prototype._hasSingleVisibleFullscreenSubSection=function(x){var V=x.getSubSections().filter(function(y){return y.getVisible()&&y._getInternalVisible()&&(y.getBlocks().length>0);});return(V.length===1)&&V[0].hasStyleClass(d.FIT_CONTAINER_CLASS);};v.prototype._computeScrollDuration=function(x,y){var z=parseInt(x);z=z>=0?z:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((y instanceof c)||this._isFirstVisibleSectionBase(y))&&this._bStickyAnchorBar){z=0;}return z;};v.prototype._computeScrollPosition=function(x){var y=x&&(x instanceof c),I=x.getId(),z=this._bMobileScenario||y?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(x)){z=0;}return z;};v.prototype._preloadSectionsOnBeforeScroll=function(x){var I=x.getId(),y;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){y=(x instanceof c)?x:x.getParent();this._connectModelsForSections([y]);}if(this.getEnableLazyLoading()){var z=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;y=this._oLazyLoading.getSubsectionsToPreload(z,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(y);}.bind(this),50);}else{this._connectModelsForSections(y);}y.forEach(function(B){this.fireEvent("subSectionEnteredViewPort",{subSection:B});},this);}};v.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};v.prototype.setDirectScrollingToSection=function(x){this.sDirectSectionId=x;};v.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};v.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};v.prototype._scrollTo=function(y,x,z){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){i.debug("ObjectPageLayout :: scrolling to "+y);if((x===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}if(z&&this._oLazyLoading){this._oLazyLoading.suppress();this._oScroller.scrollTo(0,y,x,this._resumeLazyLoading.bind(this));}else{this._oScroller.scrollTo(0,y,x);}}return this;};v.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true);}};v.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,x,V,y;if(!w(H)||!w(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();x=$.getBoundingClientRect().height;V=this._$opWrapper[0].getBoundingClientRect().height;y=$.offsetTop+x-V;this._scrollTo(y);};v.prototype._updateMedia=function(W,x){if(!W){return;}var U=function(y){Object.keys(x).forEach(function(z){var E=x[z],G=y===E;this.toggleStyleClass(E,G);},this);}.bind(this),B=v.BREAK_POINTS;if(W<=B.PHONE){U(x.PHONE);}else if(W<=B.TABLET){U(x.TABLET);}else{U(x.DESKTOP);}};v.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var x,y,z,B,E,G,H=!this._bHeaderExpanded,I,J,N,Q=this.getDomRef(),U=this.getUseIconTabBar();if(!Q||!this._bDomReady){return false;}i.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(Q);if(this.iScreenHeight===0){return;}this.iFooterHeight=this._getFooterHeight();var V=-1;this._aSectionBases.forEach(function(W){var X=this._oSectionInfo[W.getId()],$=W.$(),Y,Z=false;if(!X||!$.length){return;}if(!X.isSection){V++;}X.$dom=$;var _=$.position().top;X.positionTop=Math.ceil(_);if(X.isSection){Y=W.$("header");}else{Y=W.$("headerTitle");}Z=Y.length===0;if(!Z){X.positionTopMobile=Math.ceil(l.Utilities.getChildPosition(Y,this._$contentContainer).top)+Y.outerHeight();}else{X.positionTopMobile=X.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){X.positionTopMobile-=this.iAnchorBarHeight;X.positionTop-=this.iAnchorBarHeight;}X.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",Z);if(this._bMobileScenario){var a1=this.oCore.byId(W.getId()).getParent();if(a1 instanceof c&&a1._getIsHidden()){return;}if(E){this._oSectionInfo[E].positionBottom=X.positionTop;}E=W.getId();y=W;}else{if(X.isSection){if(E){this._oSectionInfo[E].positionBottom=X.positionTop;if(B){this._oSectionInfo[B].positionBottom=X.positionTop;}}E=W.getId();B=null;}else{if(B){this._oSectionInfo[B].positionBottom=X.positionTop;}B=W.getId();y=W;}}if(!X.isSection){J=U||(W.getParent()===this._oFirstVisibleSection);I=J&&(V===0);N=W.hasStyleClass(d.FIT_CONTAINER_CLASS);W._setHeight(this._computeSubSectionHeight(I,N,X.positionTop));}},this);if(y){x=this._computeLastVisibleHeight(y);if(this._bMobileScenario&&E){this._oSectionInfo[E].positionBottom=this._oSectionInfo[E].positionTop+x;}else{if(B){this._oSectionInfo[B].positionBottom=this._oSectionInfo[B].positionTop+x;}if(E&&B){this._oSectionInfo[E].positionBottom=this._oSectionInfo[B].positionTop+x;}}G=this._bStickyAnchorBar||(V>0)||this._checkContentBottomRequiresSnap(y);if(this._bAllContentFitsContainer){G=false;}if(G&&!this._shouldPreserveHeaderInTitleArea()){H=true;}z=this._computeSpacerHeight(y,x,G,H);this._$spacer.height(z+"px");i.debug("ObjectPageLayout :: bottom spacer is now "+z+"px");o(this._oScrollContainerLastState,{iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iSpacerHeight:z});}this._updateCustomScrollerHeight(H);this._setSectionInfoIsDirty(false);return true;};v.prototype._computeSubSectionHeight=function(x,y,z){var B,E;if(!y){return"";}var I=(this._bAllContentFitsContainer)?this._bHeaderExpanded:x;B=this._getSectionsContainerHeight(!I);if(this._bAllContentFitsContainer){E=(z-this.iHeaderContentHeight)+this.iFooterHeight;B-=E;}return B+"px";};v.prototype._updateCustomScrollerHeight=function(x){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var y=this._computeScrollableContentSize(x);y+=this._getStickyAreaHeight(x);this._getCustomScrollBar().setContentSize(y+"px");var z=(y>Math.ceil(this.iScreenHeight)),V=(z!==this._getCustomScrollBar().getVisible());if(V){this._getCustomScrollBar().setVisible(z);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};v.prototype._computeScrollableContentSize=function(x){var y=0;if(this._$contentContainer&&this._$contentContainer.length){y=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&x){y-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!x){y+=this.iAnchorBarHeight;}return y;};v.prototype._computeLastVisibleHeight=function(x){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var y=this._getSectionPositionTop(x,I);return this._$spacer.position().top-y;};v.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};v.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};v.prototype._getSectionsContainerHeight=function(I){var x=this._getScrollableViewportHeight(I);if(!I){x-=(this.iHeaderContentHeight+this.iAnchorBarHeight);}return x;};v.prototype._getSectionPositionTop=function(x,y){var z=Math.ceil(l.Utilities.getChildPosition(x.$(),this._$contentContainer).top);if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&y){z-=this.iAnchorBarHeight;}return z;};v.prototype._getSectionPositionBottom=function(x,y){var z=this._oSectionInfo[x.getId()].positionBottom;if(!y){z+=this.iAnchorBarHeight;}return z;};v.prototype._determineSectionBaseInternalTitleLevel=function(x){var y=this.getSectionTitleLevel(),I=x instanceof c;if(y===s.Auto){return I?s.H3:s.H4;}return I?y:v._getNextTitleLevelEntry(y);};v.prototype._shouldApplySectionTitleLevel=function(x){return x.getTitleLevel()===s.Auto;};v.prototype._checkContentBottomRequiresSnap=function(x){var y=false;return this._getSectionPositionBottom(x,y)>(this._getScrollableViewportHeight(y)+this._getSnapPosition());};v.prototype._computeSpacerHeight=function(x,y,z,B){var E,G;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){E=0;}else{G=this._getScrollableViewportHeight(B);if(z){G=Math.ceil(G);y=Math.floor(y);}else{y=this._$spacer.position().top;}if(y<G){E=G-y;if(this._bMobileScenario){E+=(this._oSectionInfo[x.getId()].positionTopMobile-this._oSectionInfo[x.getId()].positionTop);}}else{E=0;}}if((this.iFooterHeight>E)){E+=this.iFooterHeight;}return E;};v.prototype._isFirstVisibleSectionBase=function(x){var y,z,B,E=this.getSelectedSection(),U=this.getUseIconTabBar();if(!x||!x.getParent()){return;}y=x.getId();if(U&&(y===E)){return true;}if(U&&(x.getParent().getId()===E)){z=sap.ui.getCore().byId(E);B=this._getFirstVisibleSubSection(z);return B&&(B.getId()===y);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return y===this._oFirstVisibleSection.getId()||y===this._oFirstVisibleSubSection.getId();}return false;};v.prototype._getFirstVisibleSubSection=function(x){if(!x){return;}var y;this._aSectionBases.every(function(z){if(z.getParent()&&(z.getParent().getId()===x.getId())){y=z;return false;}return true;});return y;};v.prototype._initAnchorBarScroll=function(){var x=this.oCore.byId(this.getSelectedSection()),y;this._requestAdjustLayout(true);y=x?this._computeScrollPosition(x):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:y}},true);};v.prototype._setAsCurrentSection=function(x){var y,z,B;if(this._sScrolledSectionId===x){return;}i.debug("ObjectPageLayout :: current section is "+x);this._sScrolledSectionId=x;y=this.getAggregation("_anchorBar");if(y&&this._getInternalAnchorBarVisible()){z=this.oCore.byId(x);B=z&&z instanceof d&&(z.getTitle().trim()===""||!z._getInternalTitleVisible()||z.getParent()._getIsHidden());if(B){x=z.getParent().getId();i.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+x);}if(z&&this._oSectionInfo[x]){y.setSelectedButton(this._oSectionInfo[x].buttonId);this.setAssociation("selectedSection",c._getClosestSection(x).getId(),true);this._setSectionsFocusValues(x);}}};v.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};v.prototype._onUpdateContentSize=function(E){var x;if(E.size.height===0||E.size.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}this._adjustHeaderHeights();this._requestAdjustLayout().then(function(){x=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(x);}.bind(this));};v.prototype._onUpdateScreenSize=function(E){var x=this.getHeaderTitle(),H=this._getHeaderContent(),y=E.size.width,z=E.size.height,B=E.oldSize.height,G=(z!==B),I,J=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){i.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(J&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._scrollTo(0,0);}if(x&&x.isDynamic()){x._onResize(y);this._updateMedia(y,v.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(y,v.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}I=this.getSelectedSection();if((B===0)&&G&&!this._isClosestScrolledSection(I)){I!==null?this.scrollToSection(I,0):this._selectFirstVisibleSection();}this._scrollTo(this._$opWrapper.scrollTop(),0);if((B===0)&&G&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};v.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){i.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};v.prototype._applyContextualSettings=function(x){var y=x.contextualWidth;if(this._hasDynamicTitle()){this._updateMedia(y,v.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(y,v.MEDIA);return b.prototype._applyContextualSettings.call(this,x);};v.prototype._shouldSnapHeaderOnScroll=function(x){return(x>0)&&(x>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};v.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};v.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=(this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight);};v.prototype._isContentLengthDecreased=function(x){if(x){return((x.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength)&&(x.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight));}};v.prototype._canReachScrollTop=function(x,E){var y;E=E||0;y=this._oScrollContainerLastState.iScrollableContentLength+E-this._oScrollContainerLastState.iScrollableViewportHeight;return y>=x;};v.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL");}};v.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};v.prototype._onScroll=function(E,I){var x=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],y=this._$spacer.length&&this._$spacer[0],z=y.offsetHeight,B,H=this.getHeaderTitle(),G=this._shouldSnapHeaderOnScroll(x),J=this._shouldPreserveHeaderInTitleArea(),N=false,Q=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:x,iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:z};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!y){return;}B=this.iScreenHeight;if(B===0){return;}if(this._getSectionInfoIsDirty()){return;}if(Q&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(Q)){var U=Q.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(Q.iScrollTop)&&this._canReachScrollTop(Q.iScrollTop,U)){var V=z+U;this._$spacer.height(V+"px");this._scrollTo(Q.iScrollTop);return;}}if(G&&!J){B-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!J){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!J&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(G,!!(E&&E.type==="scroll"));}if(!J){this._adjustHeaderTitleBackgroundPosition(x);}i.debug("ObjectPageLayout :: lazy loading : Scrolling at "+x,"----------------------------------------");this._updateSelectionOnScroll(x);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,x,E.timeStamp,B);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(x===0){q(document.getElementById(this.getId()+"-scroll")).css("z-index","1000");N=false;}else if(!N){N=true;q(document.getElementById(this.getId()+"-scroll")).css("z-index","0");}}};v.prototype._updateSelectionOnScroll=function(x){var y=this.iScreenHeight,z,B;if(y===0){return;}z=this._getClosestScrolledSectionId(x,y);B=this._getClosestScrolledSectionId(x,y,true);if(z){var E=this.getDirectScrollingToSection();if(z!==this._sScrolledSectionId){i.debug("ObjectPageLayout :: closest id "+z,"----------------------------------------");var E=this.getDirectScrollingToSection();if(E&&E!==z){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(z);}else if(z===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(B!==this._sScrolledSubSectionId){var G=c._getClosestSection(z),H=this.oCore.byId(B);this._sScrolledSubSectionId=B;this.fireEvent("_sectionChange",{section:G,subSection:H});this.fireEvent("sectionChange",{section:G,subSection:H});}}};v.prototype._getSnapPosition=function(){var x=this.iHeaderContentHeight,y=this._getTitleHeightDelta();x-=Math.max(y,this._iHeaderContentPaddingBottom);return x;};v.prototype._getTitleHeightDelta=function(){var x=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;x=Math.max(x,0);x=Math.min(x,v.MAX_SNAP_POSITION_OFFSET);return x;};v.prototype._getClosestScrolledSectionId=function(x,y,z){z=!!z;x=Math.ceil(x);var B=x+y,E,G=z||this._bMobileScenario;q.each(this._oSectionInfo,function(I,H){var J,N,Q,U,V,W=this.getSelectedSection();J=this.oCore.byId(I);if(!J){return;}N=J.getParent();Q=N instanceof c&&N._getIsHidden();if(this.getUseIconTabBar()&&W){V=this.oCore.byId(W);if(!V){return;}if(H.isSection&&H.sectionReference!=V){return true;}if(!H.isSection&&V.indexOfSubSection(H.sectionReference)<0){return true;}}if(H.isSection||(G&&!Q)){if(!E&&(H.sectionReference._getInternalVisible()===true)){U=this._getFirstVisibleSubSection(H.sectionReference);if(H.isSection&&z&&U){E=U.getId();}else{E=I;}}if(H.isSection&&z){return true;}if(H.positionTop<=B&&x<=H.positionBottom){if(H.positionTop<=x&&H.positionBottom>x){E=I;return false;}}}}.bind(this));return E;};v.prototype._toggleHeader=function(x,U){var H;if(x===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!x,U);}if(!this._bStickyAnchorBar&&x){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!x){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}};v.prototype._restoreFocusAfter=function(x){var y=this.oCore.byId(this.oCore.getCurrentFocusedControlId());x.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){y&&y.$().trigger("focus");}}return this;};v.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};v.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var x=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(x);this._toggleHeaderStyleRules(false);}return this;};v.prototype._toggleHeaderStyleRules=function(x){x=!!x;var V=x?"hidden":"inherit";this._bStickyAnchorBar=x;this._$headerContent.css("overflow",V);this._$headerContent.toggleClass("sapContrastPlus",!x);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",x);this._$anchorBar.css("visibility",V);if(w(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!x);}this.fireToggleAnchorBar({fixed:x});if(!x&&!this.iAnchorBarHeight){this._requestAdjustLayout();}};v.prototype.getScrollDelegate=function(){return this._oScroller;};v.prototype.setHeaderTitle=function(H,x){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)});}this.setAggregation("headerTitle",H,x);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=r.toPx(P.get("_sap_f_DynamicPageHeader_PaddingBottom"));}return this;};v.prototype._onAfterHeaderTitleRendering=function(){var H=this.getHeaderTitle(),$=H&&H.$(),x;if(!H||!$.length){return;}x=$.height();if(x!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=x;}};v.prototype._onModifyHeaderTitle=function(x){var H=this.getAggregation("_headerContent");H&&x.current&&H.setBackgroundDesign(x.current);};v.prototype.invalidate=function(x){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&x&&(x instanceof c)&&!x.isActive()&&this._oSectionInfo[x.getId()]){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}a.prototype.invalidate.apply(this,arguments);};v.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),x=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),y=this.getAggregation("_headerContent"),z,N;var B=H?H.getCompatibleHeaderContentClass():e;if(!(y instanceof B)){z=this.getAggregation("_headerContent");if(z){z.destroy();}N=B.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");x&&N.setBackgroundDesign(x);this.setAggregation("_headerContent",N,true);}};v.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};v.prototype._adjustHeaderTitleBackgroundPosition=function(x){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-x)+"px");}}}};v.prototype._adjustHeaderHeights=function(){var x=this.getHeaderTitle(),y=true;if(x&&!x.supportsAdaptLayoutForDomElement()){y=false;}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(y);}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(y);}this._adjustHeaderBackgroundSize();i.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{i.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};v.prototype._appendTitleCloneToDOM=function(E){var $=this.getHeaderTitle().$(),x=$.clone();x.css({left:"-10000px",top:"-10000px",width:$.width()+"px",position:"absolute"});x.toggleClass("sapUxAPObjectPageHeaderStickied",E);x.appendTo(this._$titleArea.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(x);}return x;};v.prototype._obtainSnappedTitleHeight=function(V){var x=this.getHeaderTitle(),$,H;if(!x){return 0;}if(V){$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();}else if(x.snap){H=this._obtainTitleHeightViaStateChange(true);}return H;};v.prototype._obtainExpandedTitleHeight=function(V){var x=this.getHeaderTitle(),$,H;if(!x){return 0;}if(V){$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();}else if(x.unSnap){H=this._obtainTitleHeightViaStateChange(false);}return H;};v.prototype._obtainTitleHeightViaStateChange=function(x){var y=this.getHeaderTitle(),H,z=this._$sectionsContainer.height(),B,E=(x)?y.snap:y.unSnap,G=(x)?y.unSnap:y.snap;E.call(y,false);H=y.$().outerHeight();G.call(y,false);B=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(z,B);return H;};v.prototype._adjustSpacerHeightUponUnsnapping=function(x,y){var z;if(x!=y){z=this._$spacer.height()-(y-x);this._$spacer.height(z);}};v.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),x=l.ObjectPageHeaderDesign.Light;if(H!=null){x=H.getHeaderDesign();}return x;};v.prototype._getVisibleSections=function(){return this.getSections().filter(function(x){return x.getVisible()&&x._getInternalVisible();});};v.prototype._setSectionsFocusValues=function(x){var y=this._getVisibleSections()||[],$,z='0',N='-1',B="tabindex",E,G=y[0];y.forEach(function(H){$=H.$();if(x===H.getId()){$.attr(B,z);E=H;H._setSubSectionsFocusValues();}else{$.attr(B,N);H._disableSubSectionsFocus();}});if(!E&&y.length>0){G.$().attr(B,z);G._setSubSectionsFocusValues();E=G;}return E;};v.prototype.setShowHeaderContent=function(x){var y=this.getShowHeaderContent(),H;if(y!==x){if(y&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",x,true);H=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!x||!H);if(H){H.setProperty("visible",x);}}return this;};v.prototype._headerTitleChangeHandler=function(I){var x;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}x=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(x,this);this._getHeaderContent().invalidate();x.destroy();};v.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};v.prototype.insertHeaderContent=function(x,I,y){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",x,I,y);}return this._getHeaderContent().insertAggregation("content",x,I,y);};v.prototype.addHeaderContent=function(x,y){if(!this._getHeaderContent()){return this.addAggregation("headerContent",x,y);}return this._getHeaderContent().addAggregation("content",x,y);};v.prototype.removeAllHeaderContent=function(x){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",x);}return this._getHeaderContent().removeAllAggregation("content",x);};v.prototype.removeHeaderContent=function(x,y){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",x,y);}return this._getHeaderContent().removeAggregation("content",x,y);};v.prototype.destroyHeaderContent=function(x){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",x);}return this._getHeaderContent().destroyAggregation("content",x);};v.prototype.indexOfHeaderContent=function(x){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",x);}return this._getHeaderContent().indexOfAggregation("content",x);};v.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};v.prototype._getHeaderContentDomRef=function(){var H=this._getHeaderContent();return H&&H.getDomRef();};v.prototype._connectModelsForSections=function(x){x=x||[];x.forEach(function(y){y.connectToModels();});};v.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};v.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};v.prototype._shiftHeaderTitle=function(){var x=this._calculateShiftOffset(),y=x.sStyleAttribute,z=x.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+y,z+"px");};v.prototype._isFirstSection=function(x){var y=this._getVisibleSections();if(x===y[0]){return true;}return false;};v.prototype._isValidStoredSubSectionInfo=function(){var x=this.getSelectedSection(),y=this.oCore.byId(x),z;if(!y||!this._oStoredScrolledSubSectionInfo){return false;}z=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return z&&this._sectionCanBeRenderedByUXRules(z)&&(y.indexOfSubSection(z)>=0);};v.prototype._restoreScrollPosition=function(){var V=this._isValidStoredSubSectionInfo(),x;if(V){x=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(x,0);}else{this.scrollToSection(this.getSelectedSection(),0);}};v.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return;}var x=this._oScroller.getScrollTop(),y=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true),z;if(y){z=x-this._computeScrollPosition(this.oCore.byId(y));}this._iStoredScrollTop=x;this._oStoredScrolledSubSectionInfo={sSubSectionId:y,iOffset:z};this._oCurrentTabSection=null;};v.prototype.onkeyup=function(E){var x,y;if(E.which===K.TAB){x=this.oCore.getCurrentFocusedControlId();y=x&&this.oCore.byId(x);if(y&&this._isFirstSection(y)){this._scrollTo(0,0);}}};v.prototype.setShowFooter=function(x){var y=this.setProperty("showFooter",x,true);this._toggleFooter(x);return y;};v.prototype._toggleFooter=function(x){var U,y=this.getFooter();if(!w(y)||!w(this._$footerWrapper)){return;}U=this.oCore.getConfiguration().getAnimationMode()!==C.AnimationMode.none;if(U){this._toggleFooterAnimation(x,y);}else{this._$footerWrapper.toggleClass("sapUiHidden",!x);}this._requestAdjustLayout();};v.prototype._toggleFooterAnimation=function(x,y){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,y));this._bIsFooterAanimationGoing=true;if(x){this._$footerWrapper.removeClass("sapUiHidden");}y.toggleStyleClass(v.SHOW_FOOTER_CLASS_NAME,x);y.toggleStyleClass(v.HIDE_FOOTER_CLASS_NAME,!x);};v.prototype._onToggleFooterAnimationEnd=function(x){this._$footerWrapper.off("webkitAnimationEnd animationend");if(x.hasStyleClass(v.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");x.removeStyleClass(v.HIDE_FOOTER_CLASS_NAME);}else{x.removeStyleClass(v.SHOW_FOOTER_CLASS_NAME);}this._bIsFooterAanimationGoing=false;};v.prototype.clone=function(){var x,H,y;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);x=a.prototype.clone.apply(this,arguments);H=this._getHeaderContent();y=x._getHeaderContent();if(y){y.destroy();}if(H){x.setAggregation("_headerContent",H.clone(),true);}return x;};v.prototype._cloneProxiedAggregations=function(x){var y=this.mAggregations[x];if(Array.isArray(y)&&y.length===0){y=this["get"+x.charAt(0).toUpperCase()+x.slice(1)]();}this.mAggregations[x]=y;};v.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};v.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};v.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};v.prototype._headerBiggerThanAllowedToBeFixed=function(){var x=this._getOwnHeight();return this._getEntireHeaderHeight()>v.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*x;};v.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};v.prototype._getOwnHeight=function(){return this._getHeight(this);};v.prototype._getHeight=function(x){return!(x instanceof a)?0:x.$().outerHeight()||0;};v.prototype._getEntireHeaderHeight=function(){var x=0,H=0,y=this.getHeaderTitle(),z=this._getHeaderContent();if(w(y)){x=y.$().outerHeight();}if(w(z)){H=z.$().outerHeight();}return x+H;};v.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};v.prototype._restorePinButtonFocus=function(){var H=this._getHeaderContent();if(w(H)&&H.supportsPinUnpin()){H._focusPinButton();}};v.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(w($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}};v.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(w($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};v.prototype._togglePinButtonARIAState=function(x){var H=this._getHeaderContent();if(w(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(x);}};v.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};v.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};v.prototype._hasDynamicTitle=function(){var x=this.getHeaderTitle();return x&&x.isDynamic();};v.prototype._attachVisualIndicatorsPressHandlers=function(x,y){var z=this.getHeaderTitle(),H=this._getHeaderContent();if(w(z)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){z.attachEvent(v.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){x.call(y);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(w(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(v.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){x.call(y);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};v.prototype._hasVisibleDynamicTitleAndHeader=function(){var x=this.getHeaderTitle(),H=this.getHeaderContent();return w(x)&&x.isDynamic()&&x.getVisible()&&w(H)&&H.length>0;};v.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var x=this.getHeaderTitle();return w(x)&&x.isDynamic()&&!!x.getSnappedTitleOnMobile()&&D.system.phone;};v.prototype._updateToggleHeaderVisualIndicators=function(){var H,x,E,y=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!y){x=false;E=false;}else{H=this._bHeaderExpanded;x=H;E=!H&&!this._hasDynamicTitleWithSnappedTitleOnMobile();}this._toggleCollapseVisualIndicator(x);this._toggleExpandVisualIndicator(E);};v.prototype._updateTitleVisualState=function(){var x=this.getHeaderTitle(),y=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",y);if(w(x)){x._toggleFocusableState(y);}};v.prototype._focusCollapseVisualIndicator=function(){var x=this._getHeaderContent();if(w(x)){x._focusCollapseButton();}};v.prototype._focusExpandVisualIndicator=function(){var x=this.getHeaderTitle();if(w(x)){x._focusExpandButton();}};v.prototype._toggleExpandVisualIndicator=function(x){var y=this.getHeaderTitle();if(w(y)){y._toggleExpandButton(x);}};v.prototype._toggleCollapseVisualIndicator=function(x){var y=this._getHeaderContent();if(w(y)){y._toggleCollapseButton(x);}};v.prototype._attachVisualIndicatorMouseOverHandlers=function(x,y,z){var H=this._getHeaderContent();if(w(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(v.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,x,z);H.attachEvent(v.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,y,z);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};v.prototype._attachTitleMouseOverHandlers=function(x,y,z){var B=this.getHeaderTitle();if(w(B)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){B.attachEvent(v.EVENTS.TITLE_MOUSE_OVER,x,z);B.attachEvent(v.EVENTS.TITLE_MOUSE_OUT,y,z);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};v.prototype._suppressScroll=function(){this._bSuppressScroll=true;};v.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};v.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};v.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};v.prototype._getHeight=function(x){return!(x instanceof a)?0:x.$().outerHeight()||0;};v.prototype._getWidth=function(x){var y=x.getDomRef();return!(x instanceof a)?0:(y&&y.offsetWidth)||0;};v.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};v.prototype._setSectionInfoIsDirty=function(x){this.bSectionInfoIsDirty=x;};v.prototype._getAriaLabelText=function(E,x){var H=this.getHeaderTitle(),y=H?H.getTitleText():null,z;if(H&&y){z=y;if(x){z+=" "+v._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITH_TITLE");}}else{z=v._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITHOUT_TITLE");}return z;};v.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){return this._getDOMRefHeight(this.$("footerWrapper").get(0));}return 0;};v.prototype._getDOMRefHeight=function(x){return x.parentElement?x.getBoundingClientRect().height:0;};v.prototype._updateAriaLabels=function(){var x=this.getLandmarkInfo(),y=this._getAriaLabelText("ROOT",true),H=this._getAriaLabelText("HEADER",true),N=this._getAriaLabelText("NAVIGATION",false),z=this._getAriaLabelText("NAVTOOLBAR",true),B=x&&x.getHeaderLabel(),E=x&&x.getRootLabel(),G=x&&x.getNavigationLabel();if(!E){this.$().attr("aria-label",y);}if(!B){this.$("headerTitle").attr("aria-label",H);}if(!G){this.$("anchorBar").attr("aria-label",N);this.$("stickyAnchorBar").attr("aria-label",N);}this.$("anchBar").attr("aria-label",z);};v.prototype._formatLandmarkInfo=function(x,y){if(x){var z=x["get"+y+"Role"]()||"",B=x["get"+y+"Label"]()||"";if(z===t.None){z='';}return{role:z.toLowerCase(),label:B};}return{};};v.prototype._getHeaderTag=function(x){if(x&&x.getHeaderRole()!==t.None){return v.DIV;}return v.HEADER;};v.prototype._getFooterTag=function(x){if(x&&x.getFooterRole()!==t.None){return v.DIV;}return v.FOOTER;};function w(x){if(arguments.length===1){return Array.isArray(x)?x.length>0:!!x;}return Array.prototype.slice.call(arguments).every(function(y){return w(y);});}return v;});
