/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/dom/units/Rem","sap/ui/Device","./AvatarGroupRenderer","sap/m/Button","sap/m/library","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","sap/ui/core/Core"],function(l,C,I,R,D,A,B,L,a,K,b){"use strict";var c=l.AvatarGroupType;var d=L.AvatarColor;var e=L.AvatarSize;var f={XS:2,S:3,M:4,L:5,XL:7};var g={XS:0.75,S:1.25,M:1.625,L:2,XL:2.75};var h={XS:0.75,S:1.25,M:1.62,L:2,XL:2.75};var i={XS:0.0625,S:0.125,M:0.125,L:0.125,XL:0.25};var j={XS:0.06,S:0.12,M:0.12,L:0.12,XL:0.25};var k=C.extend("sap.f.AvatarGroup",{metadata:{library:"sap.f",properties:{groupType:{type:"sap.f.AvatarGroupType",group:"Appearance",defaultValue:c.Group},avatarDisplaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:e.S}},defaultAggregation:"items",aggregations:{items:{type:'sap.f.AvatarGroupItem',multiple:true}},events:{press:{parameters:{groupType:{type:"string"},overflowButtonPressed:{type:"boolean"},avatarsDisplayed:{type:"int"}}}}}});k.prototype.init=function(){this._oShowMoreButton=new B({});this._oShowMoreButton.addStyleClass("sapFAvatarGroupMoreButton");this._bFirstRendering=true;this._onResizeRef=this._onResize.bind(this);this._iCurrentAvatarColorNumber=1;this._bShowMoreButton=false;this._bIEBrowser=D.browser.internet_explorer;};k.prototype.exit=function(){this._detachResizeHandlers();if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}this._oShowMoreButton.destroy();this._oShowMoreButton=null;};k.prototype.onBeforeRendering=function(){if(this._bFirstRendering){this._iAvatarsToShow=this.getItems().length;this._bFirstRendering=false;}};k.prototype.onAfterRendering=function(){var o,m=[];if(!this._oItemNavigation){this._oItemNavigation=new I(null,null);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addEventDelegate(this._oItemNavigation);}o=this.getDomRef();this._oItemNavigation.setRootDomRef(o);if(this.getGroupType()===c.Individual){this.getItems().forEach(function(n){m.push(n.getDomRef());});this._oItemNavigation.setItemDomRefs(m);}this._detachResizeHandlers();this._attachResizeHandlers();if(b.isThemeApplied()){this._onResize();}if(this._shouldShowMoreButton()){this._oShowMoreButton.$().attr("role","button");if(this.getGroupType()===c.Group){this._oShowMoreButton.$().attr("tabindex","-1");}else{this._oShowMoreButton.$().attr("aria-label",this._getResourceBundle().getText("AVATARGROUP_POPUP"));}}this._updateAccState();};k.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}this._onResize();};k.prototype._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};k.prototype._updateAccState=function(){var r=this._getResourceBundle(),s=r.getText("AVATARGROUP_NUMBER_OF_AVATARS",[this._iAvatarsToShow,(this.getItems().length-this._iAvatarsToShow)]),p=r.getText("AVATARGROUP_POPUP");if(this.getGroupType()===c.Group){this.$().attr("aria-label",p+" "+s);}};k.prototype._attachResizeHandlers=function(){this._iResizeHandlerId=a.register(this,this._onResizeRef);};k.prototype._detachResizeHandlers=function(){if(this._iResizeHandlerId){a.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};k.prototype.setGroupType=function(v){this.getItems().forEach(function(o){o._setGroupType(v);});return this.setProperty("groupType",v);};k.prototype.addItem=function(o){o._setDisplaySize(this.getAvatarDisplaySize());o._setAvatarColor(d["Accent"+this._iCurrentAvatarColorNumber]);o._setGroupType(this.getGroupType());this._iAvatarsToShow=this.getItems().length;this._iCurrentAvatarColorNumber++;if(this._iCurrentAvatarColorNumber>10){this._iCurrentAvatarColorNumber=1;}return this.addAggregation("items",o);};k.prototype.setAvatarDisplaySize=function(v){var o=this.getAvatarDisplaySize();this._oShowMoreButton.removeStyleClass("sapFAvatarGroupMoreButton"+o);this._oShowMoreButton.addStyleClass("sapFAvatarGroupMoreButton"+v);if(o===v){return this;}this.getItems().forEach(function(m){m._setDisplaySize(v);});return this.setProperty("avatarDisplaySize",v);};k.prototype.ontap=function(E){var o=E.srcControl;this.firePress({groupType:this.getGroupType(),eventSource:o,overflowButtonPressed:o===this._oShowMoreButton,avatarsDisplayed:this._iAvatarsToShow});};k.prototype.onsapspace=function(E){this.ontap(E);};k.prototype.onsapenter=function(E){this.ontap(E);};k.prototype.onkeyup=function(E){if(E.shiftKey&&E.keyCode==K.ENTER||E.shiftKey&&E.keyCode==K.SPACE){E.preventDefault();}};k.prototype._getAvatarMargin=function(s){var G=this.getGroupType(),m;if(G===c.Group){m=this._bIEBrowser?h[s]:g[s];}else{m=this._bIEBrowser?j[s]:i[s];}return m;};k.prototype._getAvatarNetWidth=function(m,n){var G=this.getGroupType();if(G===c.Group){return m-n;}else{return m+n;}};k.prototype._getAvatarsToShow=function(w,m,n){var r=R.toPx(1),o=w-(m*r),p=Math.floor(o/(n*r));return p+1;};k.prototype._adjustAvatarsToShow=function(m){if(m-this._iAvatarsToShow>99){this._iAvatarsToShow-=2;}else{this._iAvatarsToShow--;}};k.prototype._getWidth=function(){var o=this.getDomRef(),w;if(this._bIEBrowser&&o){w=parseFloat(o.getBoundingClientRect().width.toFixed(2));}else{w=Math.ceil(this.$().width());}return w;};k.prototype._onResize=function(){var w=this._getWidth(),m=this.getItems(),n=m.length,s=this.getAvatarDisplaySize(),o=f[s],p=this._getAvatarMargin(s),q=this._getAvatarNetWidth(o,p),r=this.$().children(".sapFAvatarGroupItem").length;this._iAvatarsToShow=this._getAvatarsToShow(w,o,q);if(n>this._iAvatarsToShow&&n>0){this._bShowMoreButton=true;this._bAutoWidth=false;this._adjustAvatarsToShow(n);if(r!=this._iAvatarsToShow){this._oShowMoreButton.setText("+"+(n-this._iAvatarsToShow));this.invalidate();}}else{this._bAutoWidth=true;this.getDomRef().style.width="auto";if(this._bShowMoreButton){this._bShowMoreButton=false;this.invalidate();}}};k.prototype._shouldShowMoreButton=function(){return this._bShowMoreButton;};return k;});
