/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./GridContainerRenderer","./GridContainerSettings","./GridContainerUtils","./delegate/GridContainerItemNavigation","./library","./dnd/GridKeyboardDragAndDrop","sap/base/strings/capitalize","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleRenderer","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/layout/cssgrid/VirtualGrid","sap/ui/thirdparty/jquery"],function(G,a,b,c,l,d,e,M,C,f,R,I,g,D,K,V,q){"use strict";var h=f.getConfiguration().getRTL();var E=16;var o=["sap.f.Card","sap.ui.integration.widgets.Card","sap.m.GenericTile"];function j(){return!D.browser.msie&&!(D.browser.edge&&D.browser.version<E);}function m(i){var k=i.getLayoutData();return k?k.getColumns():1;}function n(i){var k=i.getLayoutData();return k?k.getActualRows():1;}function p(i){var k=i.getLayoutData();return k?k.hasAutoHeight():true;}var r=C.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},minHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"2rem"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",multiple:false},layoutS:{type:"sap.f.GridContainerSettings",multiple:false},layoutM:{type:"sap.f.GridContainerSettings",multiple:false},layoutL:{type:"sap.f.GridContainerSettings",multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",multiple:false,visibility:"hidden"}},events:{layoutChange:{parameters:{layout:{type:"string"}}},borderReached:{parameters:{event:{type:"jQuery.Event"}}}},dnd:{draggable:false,droppable:true}}});r.prototype.bUseExtendedChangeDetection=true;r.prototype.getActiveLayoutSettings=function(){var s=this.getAggregation(this._sActiveLayout);if(!s&&this._sActiveLayout==="layoutXS"){s=this.getAggregation("layoutS");}if(!s){s=this.getAggregation("layout")||this.getAggregation("_defaultLayout");}return s;};r.prototype._onBeforeItemRendering=function(){var i=this.getParent();if(i._reflectItemVisibilityToWrapper(this)&&!j()){i._scheduleIEPolyfill();}};r.prototype._onAfterItemRendering=function(){var i=this.getParent(),F;if(i._hasOwnVisualFocus(this)){F=this.getFocusDomRef();F.setAttribute("tabindex",-1);F.tabIndex=-1;}if(!i._resizeListeners[this.getId()]){i._resizeListeners[this.getId()]=R.register(this,i._resizeItemHandler);}i._setItemNavigationItems();if(!j()){i._scheduleIEPolyfill();return;}i._applyItemAutoRows(this);};r.prototype._reflectItemVisibilityToWrapper=function(i){var k=this._getItemWrapper(i),$;if(!k){return false;}$=q(k);if(i.getVisible()&&$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.removeClass("sapFGridContainerInvisiblePlaceholder");}else if(!i.getVisible()&&!$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.addClass("sapFGridContainerInvisiblePlaceholder");return true;}return false;};r.prototype._onItemChange=function(i){if(i.name!=="items"||!i.child){return;}if(i.mutation==="insert"){i.child.addEventDelegate(this._itemDelegate,i.child);}else if(i.mutation==="remove"){i.child.removeEventDelegate(this._itemDelegate,i.child);}};r.prototype._deregisterResizeListeners=function(){var k,i;for(k in this._resizeListeners){i=this._resizeListeners[k];R.deregister(i);}delete this._resizeListeners;D.resize.detachHandler(this._resizeDeviceHandler);};r.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return;}var t=this,w=[];if(!t._oItemNavigation){t._oItemNavigation=new c().setCycling(false).attachEvent(I.Events.BorderReached,this._onItemNavigationBorderReached,this).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"]}).setFocusedIndex(0);t.addDelegate(this._oItemNavigation);}t.$().children().map(function(i,W){if(W.getAttribute("class").indexOf("sapFGridContainerItemWrapper")>-1){w.push(W);}});t._oItemNavigation.setRootDomRef(t.getDomRef());t._oItemNavigation.setItemDomRefs(w);};r.prototype._detectActiveLayout=function(){var w=(this.getContainerQuery()&&this.getDomRef())?this._getComputedWidth():D.resize.width,i=D.media.getCurrentRange("GridContainerRangeSet",w),L="layout"+i.name,O=this.getActiveLayoutSettings(),s=false;if(!w){return false;}if(this._sActiveLayout!==L){this.addStyleClass("sapFGridContainer"+e(L));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+e(this._sActiveLayout));}this._sActiveLayout=L;s=O!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout});}return s;};r.prototype._getActiveGridStyles=function(){var s=this.getActiveLayoutSettings(),i=s.getColumns()||"auto-fill",k=s.getColumnSize(),t=s.getMinColumnSize(),u=s.getMaxColumnSize(),S={"grid-gap":s.getGap()};if(t&&u){S["grid-template-columns"]="repeat("+i+", minmax("+t+", "+u+"))";}else{S["grid-template-columns"]="repeat("+i+", "+k+")";}if(this.getInlineBlockLayout()){S["grid-auto-rows"]="min-content";}else{S["grid-auto-rows"]=s.getRowSize();}return S;};r.prototype.init=function(){this._oRb=f.getLibraryResourceBundle("sap.f");this.setAggregation("_defaultLayout",new a());this._initRangeSet();this._resizeListeners={};this._oItemNavigation=null;this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new M(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);this._resizeDeviceHandler=this._resizeDevice.bind(this);D.resize.attachHandler(this._resizeDeviceHandler);this._resizeItemHandler=this._resizeItem.bind(this);if(!j()){this._attachDndPolyfill();}};r.prototype.insertItem=function(i,k){this.insertAggregation("items",i,k,true);if(!this.getDomRef()||!j()||!i.getVisible()){this.invalidate();return this;}var s=f.createRenderManager(),w=this._createItemWrapper(i),N=this._getItemAt(k+1),t=this.getDomRef();if(N){t.insertBefore(w,this._getItemWrapper(N));}else{t.insertBefore(w,t.lastChild);}i.addStyleClass("sapFGridContainerItemInnerWrapper");s.render(i,w);s.destroy();return this;};r.prototype.removeItem=function(i){var k=this.removeAggregation("items",i,true),s=this.getDomRef(),t=k.getDomRef();if(!s||!t||!j()){this.invalidate();return k;}s.removeChild(t.parentElement);return k;};r.prototype.onBeforeRendering=function(){this._detectActiveLayout();var i=this._resizeListeners[this.getId()];if(i){R.deregister(i);}this._isRenderingFinished=false;};r.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=R.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);if(this.getItems().length===1&&this._forceFocus){this.focusItem(0);this._forceFocus=false;}};r.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;this._oItemNavigation=null;}if(!j()){this._detachDndPolyfill();}this._forceFocus=null;};r.prototype._initRangeSet=function(){if(!D.media.hasRangeSet("GridContainerRangeSet")){D.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"]);}};r.prototype._resize=function(){if(!this._isWidthChanged()){return;}var s=this._detectActiveLayout();this._applyLayout(s);};r.prototype._resizeDevice=function(){if(!this.getContainerQuery()){this._resize();}};r.prototype._isWidthChanged=function(){var i=this._getComputedWidth(),v=D.resize.width;if(this._lastGridWidth===i&&this._lastViewportWidth===v){return false;}this._lastGridWidth=i;this._lastViewportWidth=v;return true;};r.prototype._getComputedWidth=function(){if(!this.getDomRef()){return null;}return this.getDomRef().getBoundingClientRect().width;};r.prototype._resizeItem=function(i){if(!j()){if(!this._bDraggingInAnotherContainer){this._scheduleIEPolyfill();}this._bDraggingInAnotherContainer=false;return;}this._applyItemAutoRows(i.control);};r.prototype._applyLayout=function(s){if(!this._isRenderingFinished){return;}if(!j()){this._scheduleIEPolyfill(s);return;}if(s){this.$().css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this));}this._enforceMaxColumns();};r.prototype._applyItemAutoRows=function(i){if(!this._isRenderingFinished){return;}if(this.getInlineBlockLayout()){return;}if(p(i)){var $=i.$(),s=this.getActiveLayoutSettings(),k=s.calculateRowsForItem($.outerHeight());if(!k){return;}$.parent().css({'grid-row':'span '+Math.max(k,n(i))});}};r.prototype._enforceMaxColumns=function(){var s=this.getActiveLayoutSettings(),i=s.getComputedColumnsCount(this.$().innerWidth());if(!i){return;}this.getItems().forEach(function(k){k.$().parent().css("grid-column","span "+Math.min(m(k),i));});};r.prototype._getItemAt=function(i){var k=this.getItems(),t;if(i<0){i=0;}if(k.length&&k[i]){t=k[i];}return t;};r.prototype._createItemWrapper=function(i){var s=G.getStylesForItemWrapper(i,this),S=s.styles,k=s.classes,w=document.createElement("div");w.setAttribute("tabindex","0");S.forEach(function(v,t){w.style.setProperty(t,v);});k.forEach(function(v){w.classList.add(v);});return w;};r.prototype._scheduleIEPolyfill=function(i){if(this._iPolyfillCallId){clearTimeout(this._iPolyfillCallId);}if(i){this._applyIEPolyfillLayout();return;}this._iPolyfillCallId=setTimeout(this._applyIEPolyfillLayout.bind(this),0);};r.prototype._applyIEPolyfillLayout=function(){if(!this._isRenderingFinished){return;}if(this.bIsDestroyed){return;}var $=this.$(),s=$.innerWidth(),S=this.getActiveLayoutSettings(),t=S.getMinColumnSizeInPx()||S.getColumnSizeInPx(),u=S.getRowSizeInPx(),v=S.getGapInPx(),w=S.getComputedColumnsCount(s),x=parseInt($.css("padding-top").replace("px","")),y=parseInt($.css("padding-left").replace("px","")),z=this.getItems();if(!t||!u){return;}if(!z.length){return;}var A=new V();A.init({numberOfCols:Math.max(1,w),cellWidth:t,cellHeight:u,unitOfMeasure:"px",gapSize:v,topOffset:x?x:0,leftOffset:y?y:0,allowDenseFill:this.getAllowDenseFill(),rtl:h,width:s});var i,k,B,F,H,J,L=[];var N=function(O){A.fitElement(O+'',this._polyfillDropIndicator.columns||S.calculateColumnsForItem(Math.round(this._polyfillDropIndicator.width)),this._polyfillDropIndicator.rows||S.calculateRowsForItem(Math.round(this._polyfillDropIndicator.height)));L.push({id:O+'',domRef:this._polyfillDropIndicator.domRef});}.bind(this);for(i=0,k=0;i<z.length;i++){if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt===i){N(k);k++;}B=z[i];F=B.$();if(!F.is(":visible")){continue;}H=m(B);if(p(B)){J=this._calcAutoRowsForPolyfill(B,S);}else{J=n(B);}A.fitElement(k+'',H,J);L.push({id:k+'',domRef:F.parent()});k++;}if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt>=z.length){N(z.length);}A.calculatePositions();L.forEach(function(O){var P=A.getItems()[O.id];O.domRef.css({position:'absolute',top:P.top,left:P.left,width:P.width,height:P.height});});$.css("height",A.getHeight()+"px");if(!this.getWidth()&&S.getColumns()){if(!this.getContainerQuery()){$.css("width",A.getWidth()+"px");}}};r.prototype._calcAutoRowsForPolyfill=function(i,k){var $=i.$(),s,t;if($.hasClass("sapFCardAnalytical")){s=$[0].scrollHeight;}else{s=$.outerHeight();}t=Math.max(k.calculateRowsForItem(s),n(i));return t;};r.prototype._polyfillAfterDragOver=function(i){var $=i.getParameter("indicator");this._polyfillDropIndicator={rows:i.getParameter("rows"),columns:i.getParameter("columns"),width:i.getParameter("width"),height:i.getParameter("height"),domRef:$,insertAt:i.getParameter("indicatorIndex")};this._scheduleIEPolyfill();};r.prototype._polyfillAfterDragEnd=function(i){this._polyfillDropIndicator=null;};r.prototype._polyfillDraggingInAnotherContainer=function(){this._bDraggingInAnotherContainer=true;};r.prototype._attachDndPolyfill=function(){this.attachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.attachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);this.attachEvent("_gridPolyfillDraggingInAnotherContainer",this._polyfillDraggingInAnotherContainer,this);};r.prototype._detachDndPolyfill=function(){this.detachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.detachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);this.detachEvent("_gridPolyfillDraggingInAnotherContainer",this._polyfillDraggingInAnotherContainer,this);};r.prototype._onItemNavigationBorderReached=function(i){this.fireEvent("borderReached",{event:i instanceof q.Event?i:i.getParameter("event")});};r.prototype.onsapnext=function(i){var k=this._oItemNavigation.getItemDomRefs();if(k.indexOf(i.target)===-1){i.stopImmediatePropagation(true);}var s=q(i.target.firstElementChild).control(0);if(i.keyCode===K.ARROW_DOWN){i.stopImmediatePropagation(true);var N=this._getClosestItemBelowInThisContainer(s);if(N){this._getItemWrapper(N).focus();}else{this._onItemNavigationBorderReached(i);}}};r.prototype.onsapprevious=function(i){var k=this._oItemNavigation.getItemDomRefs();if(k.indexOf(i.target)===-1){i.stopImmediatePropagation(true);}var s=q(i.target.firstElementChild).control(0);if(i.keyCode===K.ARROW_UP){i.stopImmediatePropagation(true);var N=this._getClosestItemAboveInThisContainer(s);if(N){this._getItemWrapper(N).focus();}else{this._onItemNavigationBorderReached(i);}}};["onkeypress","onkeyup","onkeydown","onsapenter","onsapselect","onsapspace"].forEach(function(N){r.prototype[N]=function(i){if(!this._isItemWrapper(i.target)){return;}if(N==="onsapspace"){i.preventDefault();}var k=q(i.target.firstChild).control()[0];if(k){var F=k.getFocusDomRef(),s=q(F).control()[0];if(s&&s[N]){s[N].call(s,i);}}};});r.prototype._hasOwnVisualFocus=function(i){return o.indexOf(i.getMetadata().getName())>-1;};r.prototype._moveItem=function(i){if(!this._isItemWrapper(i.target)){return;}var k=q(i.target.firstElementChild).control(0),L=this.getItems().length,s=this.indexOfItem(k),t=-1,u=null,v="After";switch(i.keyCode){case K.ARROW_RIGHT:t=f.getConfiguration().getRTL()?s-1:s+1;if(t>=0&&t<L){u=this.getItems()[t];}break;case K.ARROW_LEFT:t=f.getConfiguration().getRTL()?s+1:s-1;if(t>=0&&t<L){u=this.getItems()[t];}break;case K.ARROW_UP:u=this._getClosestItemAbove(k);if(!u||(u.isA("sap.f.GridContainer")&&!u.getItems().length)){break;}if(this!==u.getParent()){v="Before";}break;case K.ARROW_DOWN:u=this._getClosestItemBelow(k);if(!u||(u.isA("sap.f.GridContainer")&&!u.getItems().length)){break;}if(this!==u.getParent()){v="Before";}break;default:break;}t=this.indexOfItem(u);if(!u){return;}i.stopPropagation();if(!u.isA("sap.f.GridContainer")&&this===u.getParent()&&t<s){v="Before";}d.fireDnDByKeyboard(k,u,v,i);this._setItemNavigationItems();};r.prototype.onsapincreasemodifiers=r.prototype._moveItem;r.prototype.onsapdecreasemodifiers=r.prototype._moveItem;r.prototype._getClosestItemBelowInThisContainer=function(i){var k=this.getItems().map(this._getItemWrapper).filter(function(w){return b.isBelow(i,w);});var s=b.findClosest(i,k);if(s){return q(s.firstElementChild).control(0);}return null;};r.prototype._getClosestItemBelow=function(i){var k=this._getClosestItemBelowInThisContainer(i);if(k){return k;}var s=Array.from(document.querySelectorAll(".sapFGridContainer")).filter(function(v){return b.isBelow(i,v);});var t=b.findClosestGridContainer(i,s);if(!t){return null;}var u=[];q(t).control(0).getItems().forEach(function(i){u.push(i.getDomRef());});if(u.length){k=b.findClosest(i,u);return q(k).control(0);}return q(t).control(0);};r.prototype._getClosestItemAboveInThisContainer=function(i){var k=this.getItems().map(this._getItemWrapper).filter(function(w){return b.isAbove(i,w);});var s=b.findClosest(i,k);if(s){return q(s.firstElementChild).control(0);}return null;};r.prototype._getClosestItemAbove=function(i){var k=this._getClosestItemAboveInThisContainer(i);if(k){return k;}var s=Array.from(document.querySelectorAll(".sapFGridContainer")).filter(function(v){return b.isAbove(i,v);});var t=b.findClosestGridContainer(i,s);if(!t){return null;}var u=[];q(t).control(0).getItems().forEach(function(i){u.push(i.getDomRef());});if(u.length){k=b.findClosest(i,u);return q(k).control(0);}return q(t).control(0);};r.prototype.focusItem=function(i){var k,s=this._oItemNavigation;this._forceFocus=true;this._setItemNavigationItems();k=s.getItemDomRefs();if(k[i]){s.setFocusedIndex(i);k[i].focus();}};r.prototype._isItemWrapper=function(i){return i.classList.contains("sapFGridContainerItemWrapper");};r.prototype._getItemWrapper=function(i){var k=i.getDomRef(),s;if(k){return k.parentElement;}s=document.getElementById(g.createInvisiblePlaceholderId(i));if(s){return s.parentElement;}return null;};return r;});
