/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/m/NumericContent","sap/m/Text","sap/f/cards/NumericHeaderRenderer","sap/ui/core/Core"],function(C,N,T,a,b){"use strict";var c=C.extend("sap.f.cards.NumericHeader",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{"type":"string",group:"Appearance"},subtitle:{"type":"string",group:"Appearance"},statusText:{type:"string",defaultValue:""},unitOfMeasurement:{"type":"string",group:"Data"},number:{"type":"string",group:"Data"},scale:{"type":"string",group:"Data"},trend:{"type":"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{"type":"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},details:{"type":"string",group:"Appearance"}},aggregations:{toolbar:{type:"sap.ui.core.Control",multiple:false},sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unitOfMeasurement:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_details:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_mainIndicator:{type:"sap.m.NumericContent",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:a});c.prototype.init=function(){this._oRb=b.getLibraryResourceBundle("sap.f");this.data("sap-ui-fastnavgroup","true",true);};c.prototype.exit=function(){this._oRb=null;};c.prototype.onBeforeRendering=function(){this._setAccessibilityAttributes();};c.prototype.setTitle=function(v){this.setProperty("title",v,true);this._getTitle().setText(v);return this;};c.prototype.setSubtitle=function(v){this.setProperty("subtitle",v,true);this._getSubtitle().setText(v);return this;};c.prototype.setUnitOfMeasurement=function(v){this.setProperty("unitOfMeasurement",v,true);this._getUnitOfMeasurement().setText(v);return this;};c.prototype.setDetails=function(v){this.setProperty("details",v,true);this._getDetails().setText(v);return this;};c.prototype.setNumber=function(v){this.setProperty("number",v,true);this._getMainIndicator().setValue(v);return this;};c.prototype.setScale=function(v){this.setProperty("scale",v,true);this._getMainIndicator().setScale(v);return this;};c.prototype.setTrend=function(v){this.setProperty("trend",v,true);this._getMainIndicator().setIndicator(v);return this;};c.prototype.setState=function(v){this.setProperty("state",v,true);this._getMainIndicator().setValueColor(v);return this;};c.prototype._getTitle=function(){var o=this.getAggregation("_title");if(!o){o=new T({id:this.getId()+"-title",wrapping:true,maxLines:3});this.setAggregation("_title",o);}return o;};c.prototype._getSubtitle=function(){var o=this.getAggregation("_subtitle");if(!o){o=new T({id:this.getId()+"-subtitle",wrapping:true,maxLines:2});this.setAggregation("_subtitle",o);}return o;};c.prototype._getUnitOfMeasurement=function(){var o=this.getAggregation("_unitOfMeasurement");if(!o){o=new T({id:this.getId()+"-unitOfMeasurement",wrapping:false});this.setAggregation("_unitOfMeasurement",o);}return o;};c.prototype._getDetails=function(){var o=this.getAggregation("_details");if(!o){o=new T({id:this.getId()+"-details",wrapping:false});this.setAggregation("_details",o);}return o;};c.prototype._getMainIndicator=function(){var o=this.getAggregation("_mainIndicator");if(!o){o=new N({id:this.getId()+"-mainIndicator",withMargin:false,nullifyValue:false,animateTextChange:false,truncateValueTo:100});this.setAggregation("_mainIndicator",o);}return o;};c.prototype.ontap=function(e){var s=e.srcControl;if(s&&s.getId().indexOf("overflowButton")>-1){return;}this.firePress();};c.prototype.onsapselect=function(){this.firePress();};c.prototype._getHeaderAccessibility=function(){var s=this._getSubtitle()?this._getSubtitle().getId():"",S=this.getStatusText()?this.getId()+"-status":"",u=this._getUnitOfMeasurement()?this._getUnitOfMeasurement().getId():"",d=this.getSideIndicators()?this._getSideIndicatorIds():"",D=this._getDetails()?this._getDetails().getId():"",m=this._getMainIndicator()?this._getMainIndicator().getId():"",i=s+" "+S+" "+u+" "+m+d+" "+D;return i.trim();};c.prototype._setAccessibilityAttributes=function(){if(this.hasListeners("press")){this._sAriaRole="button";this._sAriaHeadingLevel=undefined;this._sAriaRoleDescritoion=this._oRb.getText("ARIA_ROLEDESCRIPTION_INTERACTIVE_CARD_HEADER");}else{this._sAriaRole="heading";this._sAriaHeadingLevel="3";this._sAriaRoleDescritoion=this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER");}};c.prototype._getSideIndicatorIds=function(){var s="";this.getSideIndicators().forEach(function(S){s+=" "+S.getId();});return s;};c.prototype.isLoading=function(){return false;};c.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.attachEvent.apply(this,m);this.invalidate();return this;};c.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.detachEvent.apply(this,m);this.invalidate();return this;};c.prototype._isInsideGridContainer=function(){var p=this.getParent();if(!p){return false;}p=p.getParent();if(!p){return false;}return p.isA("sap.f.GridContainer");};return c;});
