/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Bar","./InstanceManager","./AssociativeOverflowToolbar","./ToolbarSpacer","./Title","./library","sap/m/Image","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/RenderManager","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/Device","sap/ui/core/library","sap/ui/events/KeyCodes","./TitlePropagationSupport","./DialogRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(B,I,A,T,a,l,b,C,c,P,S,R,d,f,g,D,h,K,j,k,L,q,m,n){"use strict";var O=h.OpenState;var o=l.DialogType;var p=l.DialogRoleType;var V=h.ValueState;var r=l.TitleAlignment;var s=m.getConfiguration().getAnimationMode();var u=s!==n.AnimationMode.none&&s!==n.AnimationMode.minimal;var t=u?300:10;var v=17;var w=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:o.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"any",group:"Behavior",defaultValue:null},role:{type:"sap.m.DialogRoleType",group:"Data",defaultValue:p.Dialog,visibility:"hidden"},closeOnNavigation:{type:"boolean",group:"Behavior",defaultValue:true},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:r.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"}});g.call(w.prototype,{header:{suffix:"header"},subHeader:{selector:".sapMDialogSubHeader .sapMIBar"},content:{selector:".sapMDialogScrollCont"},footer:{suffix:"footer"}});j.call(w.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});w._bPaddingByDefault=(m.getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);w._mIcons={};w._mIcons[V.Success]=c.getIconURI("message-success");w._mIcons[V.Warning]=c.getIconURI("message-warning");w._mIcons[V.Error]=c.getIconURI("message-error");w._mIcons[V.Information]=c.getIconURI("hint");w.prototype.init=function(){var e=this;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=m.getConfiguration().getRTL();this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer","sap.m.SplitContainer","sap.m.MultiInput","sap.m.SimpleFixFlex"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");this.oPopup.setModal(true);this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(i,F){e._setDimensions();e._adjustScrollingPane();if(e._oManuallySetPosition){i.at={left:e._oManuallySetPosition.x,top:e._oManuallySetPosition.y};}else{i.at=e._calcCenter();}e._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,i);e._registerContentResizeHandler();};if(w._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement();};w.prototype.onBeforeRendering=function(){var H=this.getCustomHeader()||this._header;if(this._hasSingleScrollableContent()){this.setVerticalScrolling(false);this.setHorizontalScrolling(false);L.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}if(this._oScroller){this._oScroller.setVertical(this.getVerticalScrolling());this._oScroller.setHorizontal(this.getHorizontalScrolling());}this._createToolbarButtons();if(m.getConfiguration().getAccessibility()&&this.getState()!=V.None){var e=new d({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",e);this.addAriaLabelledBy(e.getId());}if(H&&H.setTitleAlignment){H.setProperty("titleAlignment",this.getTitleAlignment(),true);}};w.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}};w.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};w.prototype.open=function(){var e=this.oPopup;e.setInitialFocusId(this.getId());var i=e.getOpenState();switch(i){case O.OPEN:case O.OPENING:return this;case O.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();e.attachOpened(this._handleOpened,this);this._iLastWidthAndHeightWithScroll=null;e.setContent(this);e.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};w.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var e=this.oPopup;var i=this.oPopup.getOpenState();if(!(i===O.CLOSED||i===O.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});e.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;e.close();this._deregisterContentResizeHandler();}return this;};w.prototype.isOpen=function(){return!!this.oPopup&&this.oPopup.isOpen();};w.prototype.setIcon=function(i){this._bHasCustomIcon=true;return this.setProperty("icon",i);};w.prototype.setState=function(e){var i;this.setProperty("state",e);if(this._bHasCustomIcon){return this;}if(e===V.None){i="";}else{i=w._mIcons[e];}this.setProperty("icon",i);return this;};w.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};w.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};w.prototype.onfocusin=function(e){var i=e.target;if(i.id===this.getId()+"-firstfe"){var y=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(y){y.focus();}}else if(i.id===this.getId()+"-lastfe"){var F=(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(F){F.focus();}}};w.prototype._getPromiseWrapper=function(){var e=this;return{reject:function(){e.currentPromise.reject();},resolve:function(){e.currentPromise.resolve();}};};w.prototype.onsapescape=function(e){var E=this.getEscapeHandler(),i={},y=this;if(this._isSpaceOrEnterPressed){return;}if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this._oCloseTrigger=null;if(typeof E==='function'){new Promise(function(z,F){i.resolve=z;i.reject=F;y.currentPromise=i;E(y._getPromiseWrapper());}).then(function(z){y.close();}).catch(function(){L.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};w.prototype.onkeyup=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=false;}};w.prototype.onkeydown=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=true;}};w.prototype._isSpaceOrEnter=function(e){var i=e.which||e.keyCode;return i==K.SPACE||i==K.ENTER;};w.prototype._openAnimation=function($,i,e){$.addClass("sapMDialogOpen");$.css("display","block");setTimeout(e,t);};w.prototype._closeAnimation=function($,i,e){$.removeClass("sapMDialogOpen");setTimeout(e,t);};w.prototype._setDimensions=function(){var $=this.$(),e=this.getStretch(),i=this.getStretchOnPhone()&&D.system.phone,M=this.getType()===o.Message,y={};if(!e){if(!this._oManuallySetSize){y.width=this.getContentWidth()||undefined;y.height=this.getContentHeight()||undefined;}else{y.width=this._oManuallySetSize.width;y.height=this._oManuallySetSize.height;}}if(y.width=='auto'){y.width=undefined;}if(y.height=='auto'){y.height=undefined;}if((e&&!M)||(i)){this.$().addClass('sapMDialogStretched');}$.css(y);if(!e&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._centerDialog();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};w.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};w.prototype._reposition=function(){};w.prototype._repositionAfterOpen=function(){};w.prototype._reapplyPosition=function(){this._adjustScrollingPane();};w.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),i,y=this.getContentHeight(),z=this.getContentWidth(),E,F=Math.floor(window.innerWidth*0.9),G=2,H=D.browser,J=0;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(!y||y=='auto'){i=e.scrollTop();e.css({height:'auto'});$.children().each(function(){J+=q(this).outerHeight(true);});if(this.getStretch()||J>$.innerHeight()){E=parseFloat($.height())+G;e.height(Math.round(E));}e.scrollTop(i);}if(D.system.desktop&&!H.chrome){var M=e.width()+"x"+e.height(),N=$.css("min-width")!==$.css("width");if(M!==this._iLastWidthAndHeightWithScroll&&N){if(this._hasVerticalScrollbar()&&(!z||z=='auto')&&!this.getStretch()&&e.width()<F){$.addClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":v});this._iLastWidthAndHeightWithScroll=M;}else{$.removeClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null;}}}if(!this.getStretch()&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._centerDialog();}};w.prototype._hasVerticalScrollbar=function(){var $=this.$('cont');if(D.browser.msie){return $[0].clientWidth<$.outerWidth();}return $[0].clientHeight<$[0].scrollHeight;};w.prototype._centerDialog=function(){this.$().css(this._calcCenter());};w.prototype._calcCenter=function(){var e=window.innerWidth,i=window.innerHeight,$=this.$(),y=$.outerWidth(),z=$.outerHeight();return{left:Math.round((e-y)/2),top:Math.round((i-z)/2)};};w.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header",{titleAlignment:this.getTitleAlignment()});this._header._setRootAccessibilityRole("heading");this._header._setRootAriaLevel("2");this.setAggregation("_header",this._header);}};w.prototype._applyTitleToHeader=function(){var e=this.getProperty("title");if(this._headerTitle){this._headerTitle.setText(e);}else{this._headerTitle=new a(this.getId()+"-title",{text:e,level:"H2"}).addStyleClass("sapMDialogTitle");this._header.addContentMiddle(this._headerTitle);}};w.prototype._hasSingleScrollableContent=function(){var e=this.getContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA(this._scrollContentList)){return true;}return false;};w.prototype._getFocusDomRef=function(){var i=this.getInitialFocus();if(i){return document.getElementById(i);}return this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElement()||this._getFirstVisibleButtonDomRef()||this.getDomRef();};w.prototype._getFirstVisibleButtonDomRef=function(){var e=this.getBeginButton(),E=this.getEndButton(),y=this.getButtons(),z;if(e&&e.getVisible()){z=e.getDomRef();}else if(E&&E.getVisible()){z=E.getDomRef();}else if(y&&y.length>0){for(var i=0;i<y.length;i++){if(y[i].getVisible()){z=y[i].getDomRef();break;}}}return z;};w.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');return $.firstFocusableDomRef();};w.prototype._getFirstFocusableContentElement=function(){var $=this.$("cont");return $.firstFocusableDomRef();};w.prototype._setInitialFocus=function(){var F=this._getFocusDomRef(),e;if(F&&F.id){e=m.byId(F.id);}if(e){if(e.getVisible&&!e.getVisible()){this.focus();return;}F=e.getFocusDomRef();}if(!F){this.setInitialFocus("");F=this._getFocusDomRef();}if(!this.getInitialFocus()){this.setAssociation('initialFocus',F?F.id:this.getId(),true);}if(D.system.desktop||(F&&!/input|textarea|select/i.test(F.tagName))){if(F){F.focus();}}else{this.focus();}};w.prototype.getScrollDelegate=function(){return this._oScroller;};w.prototype._composeAggreNameInHeader=function(e){var H;if(e==="Begin"){H="contentLeft";}else if(e==="End"){H="contentRight";}else{H="content"+e;}return H;};w.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(i){return i.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};w.prototype._setButton=function(e,i,y){return this;};w.prototype._getButton=function(e){var i=e.toLowerCase()+"Button",y="_o"+this._firstLetterUpperCase(e)+"Button";if(D.system.phone){return this.getAggregation(i,null,true);}else{return this[y];}};w.prototype._getButtonFromHeader=function(e){if(this._header){var H=this._composeAggreNameInHeader(this._firstLetterUpperCase(e)),i=this._header.getAggregation(H);return i&&i[0];}else{return null;}};w.prototype._firstLetterUpperCase=function(e){return e.charAt(0).toUpperCase()+e.slice(1);};w.prototype._getAnyHeader=function(){var e=this.getCustomHeader();if(e){e._setRootAriaLevel("2");return e._setRootAccessibilityRole("heading");}else{var i=this.getShowHeader();if(!i){return null;}this._createHeader();this._applyTitleToHeader();this._applyIconToHeader();return this._header;}};w.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){f.deregister(this._resizeListenerId);this._resizeListenerId=null;}D.resize.detachHandler(this._onResize,this);};w.prototype._registerResizeHandler=function(){var _=this.$("scroll");this._resizeListenerId=f.register(_.get(0),q.proxy(this._onResize,this));D.resize.attachHandler(this._onResize,this);this._onResize();};w.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){f.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};w.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=f.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};w.prototype._attachHandler=function(e){var i=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){i._oCloseTrigger=this;},onkeyup:function(){i._oCloseTrigger=this;},onkeydown:function(){i._oCloseTrigger=this;}};}if(e){e.addDelegate(this._oButtonDelegate,true,e);}};w.prototype._createToolbarButtons=function(){var e=this._getToolbar();var i=this.getButtons();var y=this.getBeginButton();var z=this.getEndButton(),E=this,F=[y,z];F.forEach(function(G){if(G&&E._oButtonDelegate){G.removeDelegate(E._oButtonDelegate);}});e.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}e.addContent(this._toolbarSpacer);F.forEach(function(G){E._attachHandler(G);});if(i&&i.length){i.forEach(function(G){e.addContent(G);});}else{if(y){e.addContent(y);}if(z){e.addContent(z);}}};w.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders");this._oToolbar.addDelegate({onAfterRendering:function(){if(this.getType()===o.Message){this.$("footer").removeClass("sapContrast sapContrastPlus");}}},false,this);this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};w.prototype.getValueStateString=function(e){var i=m.getLibraryResourceBundle("sap.m");switch(e){case(V.Success):return i.getText("LIST_ITEM_STATE_SUCCESS");case(V.Warning):return i.getText("LIST_ITEM_STATE_WARNING");case(V.Error):return i.getText("LIST_ITEM_STATE_ERROR");case(V.Information):return i.getText("LIST_ITEM_STATE_INFORMATION");default:return"";}};w.prototype.setSubHeader=function(e){this.setAggregation("subHeader",e);if(e){e.setVisible=function(i){e.setProperty("visible",i);this.invalidate();}.bind(this);}return this;};w.prototype.setLeftButton=function(e){if(typeof e==="string"){e=m.byId(e);}this.setBeginButton(e);return this.setAssociation("leftButton",e);};w.prototype.setRightButton=function(e){if(typeof e==="string"){e=m.byId(e);}this.setEndButton(e);return this.setAssociation("rightButton",e);};w.prototype.getLeftButton=function(){var e=this.getBeginButton();return e?e.getId():null;};w.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};w.prototype.setBeginButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogBeginButton");}return this.setAggregation("beginButton",e);};w.prototype.setEndButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogEndButton");}return this.setAggregation("endButton",e);};w.prototype.getAggregation=function(e,i,y){var z=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(e==='buttons'&&z&&z.length===0){this.getBeginButton()&&z.push(this.getBeginButton());this.getEndButton()&&z.push(this.getEndButton());}return z;};w.prototype.getAriaLabelledBy=function(){var H=this._getAnyHeader(),e=this.getAssociation("ariaLabelledBy",[]).slice();var i=this.getSubHeader();if(i){e.unshift(i.getId());}if(H){var y=H.findAggregatedObjects(true,function(z){return z.isA("sap.m.Title");});if(y.length){e=y.map(function(z){return z.getId();}).concat(e);}else{e.unshift(H.getId());}}return e;};w.prototype._applyIconToHeader=function(){var i=this.getIcon();if(!i){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}return;}if(!this._iconImage){this._iconImage=c.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},b).addStyleClass("sapMDialogIcon");this._header.insertAggregation("contentMiddle",this._iconImage,0);}this._iconImage.setSrc(i);};w.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};w.prototype.forceInvalidate=C.prototype.invalidate;w.prototype.invalidate=function(e){if(this.isOpen()){this.forceInvalidate(e);}};function x(e){var $=q(e);var i=$.control(0);if($.parents('.sapMDialogSection').length){return false;}if(!i||i.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}if(D.system.desktop){w.prototype.ondblclick=function(e){if(x(e.target)){var $=this.$('cont');this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);$.css({height:'100%'});}};w.prototype.onmousedown=function(e){if(e.which===3){return;}if(this.getStretch()||(!this.getDraggable()&&!this.getResizable())){return;}var i;var y=this;var $=q(document);var z=q(e.target);var E=z.hasClass('sapMDialogResizeHandler')&&this.getResizable();var M=function(Z){i=i?clearTimeout(i):setTimeout(function(){Z();},0);};var F=window.innerWidth;var G=window.innerHeight;var H={x:e.pageX,y:e.pageY,width:y._$dialog.width(),height:y._$dialog.height(),outerHeight:y._$dialog.outerHeight(),offset:{x:e.offsetX?e.offsetX:e.originalEvent.layerX,y:e.offsetY?e.offsetY:e.originalEvent.layerY},position:{x:y._$dialog.offset().left,y:y._$dialog.offset().top}};var J;function N(){var Z=y.$(),_=y.$('cont'),a1,b1;$.off("mouseup",N);$.off("mousemove",J);if(E){y._$dialog.removeClass('sapMDialogResizing');a1=parseInt(Z.height());b1=parseInt(Z.css("border-top-width"))+parseInt(Z.css("border-bottom-width"));_.height(a1+b1);}}if((x(e.target)&&this.getDraggable())||E){y._bDisableRepositioning=true;y._$dialog.addClass('sapDialogDisableTransition');y._oManuallySetPosition={x:H.position.x,y:H.position.y};y._$dialog.css({left:Math.min(Math.max(0,y._oManuallySetPosition.x),F-H.width),top:Math.min(Math.max(0,y._oManuallySetPosition.y),G-H.height),width:H.width});}if(x(e.target)&&this.getDraggable()){J=function(Z){if(Z.buttons===0){N();return;}M(function(){y._bDisableRepositioning=true;y._oManuallySetPosition={x:Math.max(0,Math.min(Z.pageX-e.pageX+H.position.x,F-H.width)),y:Math.max(0,Math.min(Z.pageY-e.pageY+H.position.y,G-H.outerHeight))};y._$dialog.css({left:y._oManuallySetPosition.x,top:y._oManuallySetPosition.y});});};$.on("mousemove",J);}else if(E){y._$dialog.addClass('sapMDialogResizing');var Q={};var U=parseInt(y._$dialog.css('min-width'));var W=H.x+H.width-U;var X=z.width()-e.offsetX;var Y=z.height()-e.offsetY;J=function(Z){M(function(){y._bDisableRepositioning=true;y.$('cont').height('').width('');if(Z.pageY+Y>G){Z.pageY=G-Y;}if(Z.pageX+X>F){Z.pageX=F-X;}y._oManuallySetSize={width:H.width+Z.pageX-H.x,height:H.height+Z.pageY-H.y};if(y._bRTL){Q.left=Math.min(Math.max(Z.pageX,0),W);y._oManuallySetSize.width=H.width+H.x-Math.max(Z.pageX,0);}Q.width=y._oManuallySetSize.width;Q.height=y._oManuallySetSize.height;y._$dialog.css(Q);});};$.on("mousemove",J);}else{return;}$.on("mouseup",N);e.preventDefault();e.stopPropagation();};}w.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};return w;});
