/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/events/KeyCodes",'./library',"sap/ui/core/library","sap/ui/core/Icon","./GenericTagRenderer"],function(C,K,l,c,I){"use strict";var G=l.GenericTagDesign,a=l.GenericTagValueState,V=c.ValueState,b={Error:"sap-icon://message-error",Warning:"sap-icon://message-warning",Success:"sap-icon://message-success",Information:"sap-icon://hint"};var d=C.extend("sap.m.GenericTag",{metadata:{library:"sap.m",interfaces:["sap.m.IOverflowToolbarContent","sap.m.IOverflowToolbarFlexibleContent"],properties:{text:{type:"string",defaultValue:""},status:{type:"sap.ui.core.ValueState",defaultValue:V.None},design:{type:"sap.m.GenericTagDesign",defaultValue:G.Full},valueState:{type:"sap.m.GenericTagValueState",defaultValue:a.None}},defaultAggregation:"value",aggregations:{value:{type:"sap.m.ObjectNumber",multiple:false},_statusIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_errorIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{press:{}}}});d.CLASSNAME_OVERFLOW_TOOLBAR="sapMGenericTagOverflowToolbar";d.prototype.setStatus=function(s){this.setProperty("status",s,false);this._getStatusIcon().setSrc(s!==V.None?b[s]:null);return this;};d.prototype.setValue=function(v){var p=this.getValue();if(p){v.detachEvent("_change",this._fireValueChanged,this);}this.setAggregation("value",v);v.attachEvent("_change",this._fireValueChanged,this);this._fireValueChanged();return this;};d.prototype._fireValueChanged=function(){this.fireEvent("_valueChanged");};d.prototype._getStatusIcon=function(){var s=this.getAggregation("_statusIcon");if(!s){s=new I(this.getId()+"-statusIcon").addStyleClass("sapMGenericTagIcon");this.setAggregation("_statusIcon",s);}return s;};d.prototype._getErrorIcon=function(){var e=this.getAggregation("_errorIcon");if(!e){e=new I(this.getId()+"-errorIcon",{src:b[V.Error]}).addStyleClass("sapMGenericTagErrorIcon");this.setAggregation("_errorIcon",e);}return e;};d.prototype.ontouchstart=function(){this._toggleActiveGenericTag(true);};d.prototype.ontouchend=function(){this._toggleActiveGenericTag(false);};d.prototype.ontouchcancel=function(){this._toggleActiveGenericTag(false);};d.prototype.onkeydown=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._toggleActiveGenericTag(true);}if(e.which===K.SHIFT||e.which===K.ESCAPE){this._bShouldInterupt=this._bSpacePressed;}if(e.which===K.SPACE){this._bSpacePressed=true;e.preventDefault();}if(e.which===K.ENTER){this.firePress();}};d.prototype.onkeyup=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._toggleActiveGenericTag(false);}if(e.which===K.SPACE){if(!this._bShouldInterupt){this.firePress();}this._bShouldInterupt=false;this._bSpacePressed=false;}};d.prototype.onclick=function(){this.firePress();};d.prototype.onfocusout=function(){this._toggleActiveGenericTag(false);};d.prototype._toggleActiveGenericTag=function(t){this.toggleStyleClass("sapMGenericTagActive",t);};d.prototype._onBeforeEnterOverflow=function(o){o.addStyleClass(d.CLASSNAME_OVERFLOW_TOOLBAR);};d.prototype._onAfterExitOverflow=function(o){o.removeStyleClass(d.CLASSNAME_OVERFLOW_TOOLBAR);};d.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true,invalidationEvents:["_valueChanged"]};o.onBeforeEnterOverflow=this._onBeforeEnterOverflow;o.onAfterExitOverflow=this._onAfterExitOverflow;return o;};return d;});
