/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','./Button','./SplitButton','sap/ui/Device','sap/ui/core/EnabledPropagator','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/LabelEnablement',"./MenuButtonRenderer","sap/ui/events/KeyCodes"],function(l,C,B,S,D,E,c,P,L,M,K){"use strict";var a=l.MenuButtonMode;var T=c.TextDirection;var b=l.ButtonType;var d=P.Dock;var n=["buttonMode","useDefaultActionOnly","width","menuPosition"];var e=C.extend("sap.m.MenuButton",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:b.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:a.Regular},menuPosition:{type:"sap.ui.core.Popup.Dock",group:"Misc",defaultValue:d.BeginBottom},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{defaultAction:{}},defaultAggregation:"menu",designtime:"sap/m/designtime/MenuButton.designtime",dnd:{draggable:true,droppable:false}}});E.call(e.prototype);e.prototype.init=function(){this._initButtonControl();};e.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null;}if(this._sDefaultIcon){this._sDefaultIcon=null;}if(this._iInitialTextBtnContentWidth){this._iInitialTextBtnContentWidth=null;}if(this._lastActionItemId){this._lastActionItemId=null;}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this);}};e.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText();}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon();}this._updateButtonControl();this._attachMenuEvents();};e.prototype._needsWidth=function(){return this._isSplitButton()&&this.getWidth()==="";};e.prototype._getTextBtnContentDomRef=function(){return this._getButtonControl()._getTextButton().getDomRef("content");};e.prototype.onAfterRendering=function(){if(this._needsWidth()&&sap.ui.getCore().isThemeApplied()&&this._getTextBtnContentDomRef()&&this._getInitialTextBtnWidth()>0){this._getTextBtnContentDomRef().style.width=this._getInitialTextBtnWidth()+'px';}};e.prototype.onThemeChanged=function(o){if(this._needsWidth()&&this.getDomRef()&&!this._iInitialTextBtnContentWidth&&this._getTextBtnContentDomRef()&&this._getInitialTextBtnWidth()>0){this._getTextBtnContentDomRef().style.width=this._getInitialTextBtnWidth()+'px';}};e.prototype._getInitialTextBtnWidth=function(){if(!this._iInitialTextBtnContentWidth){this._iInitialTextBtnContentWidth=Math.ceil(this._getTextBtnContentDomRef().getBoundingClientRect().width);}return this._iInitialTextBtnContentWidth;};e.prototype.setButtonMode=function(m){var t=this.getTooltip();C.prototype.setProperty.call(this,"buttonMode",m,true);this._getButtonControl().destroy();this._initButtonControl();for(var k in this.mProperties){if(this.mProperties.hasOwnProperty(k)&&n.indexOf(k)<0){this._getButtonControl().setProperty(k,this.mProperties[k],true);}}if(t){this._getButtonControl().setTooltip(t);}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText());}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon());}this.invalidate();return this;};e.prototype._initButton=function(){var o=new B(this.getId()+"-internalBtn",{width:"100%",ariaHasPopup:c.aria.HasPopup.Menu});o.attachPress(this._handleButtonPress,this);return o;};e.prototype._initSplitButton=function(){var o=new S(this.getId()+"-internalSplitBtn",{width:"100%"});o.attachPress(this._handleActionPress,this);o.attachArrowPress(this._handleButtonPress,this);return o;};e.prototype._initButtonControl=function(){var o;if(this._isSplitButton()){o=this._initSplitButton();}else{o=this._initButton();}this.setAggregation("_button",o,true);};e.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText());};e.prototype._getButtonControl=function(){return this.getAggregation("_button");};e.prototype._handleButtonPress=function(w){var m=this.getMenu(),o={zero:"0 0",plus2_right:"0 +2",minus2_right:"0 -2",plus2_left:"+2 0",minus2_left:"-2 0"};if(!m){return;}if(this._bPopupOpen){this.getMenu().close();this._bPopupOpen=false;return;}if(!m.getTitle()){m.setTitle(this.getText());}var p=[this,w];switch(this.getMenuPosition()){case d.BeginTop:p.push(d.BeginBottom,d.BeginTop,o.plus2_right);break;case d.BeginCenter:p.push(d.BeginCenter,d.BeginCenter,o.zero);break;case d.LeftTop:p.push(d.RightBottom,d.LeftBottom,o.plus2_left);break;case d.LeftCenter:p.push(d.RightCenter,d.LeftCenter,o.plus2_left);break;case d.LeftBottom:p.push(d.RightTop,d.LeftTop,o.plus2_left);break;case d.CenterTop:p.push(d.CenterBottom,d.CenterTop,o.plus2_left);break;case d.CenterCenter:p.push(d.CenterCenter,d.CenterCenter,o.zero);break;case d.CenterBottom:p.push(d.CenterTop,d.CenterBottom,o.minus2_right);break;case d.RightTop:p.push(d.LeftBottom,d.RightBottom,o.minus2_left);break;case d.RightCenter:p.push(d.LeftCenter,d.RightCenter,o.minus2_left);break;case d.RightBottom:p.push(d.LeftTop,d.RightTop,o.minus2_left);break;case d.EndTop:p.push(d.EndBottom,d.EndTop,o.plus2_right);break;case d.EndCenter:p.push(d.EndCenter,d.EndCenter,o.zero);break;case d.EndBottom:p.push(d.EndTop,d.EndBottom,o.minus2_right);break;default:case d.BeginBottom:p.push(d.BeginTop,d.BeginBottom,o.minus2_right);break;}m.openBy.apply(m,p);if(this.getMenu()){this._bPopupOpen=true;}this._writeAriaAttributes();if(this._isSplitButton()&&!D.system.phone){this._getButtonControl().setArrowState(true);}};e.prototype._handleActionPress=function(){var s=this._getLastSelectedItem(),o;if(!this.getUseDefaultActionOnly()&&s){o=sap.ui.getCore().byId(s);this.getMenu().fireItemSelected({item:o});}else{this.fireDefaultAction();}};e.prototype._menuClosed=function(){var o=this._getButtonControl(),O=o;this._bPopupOpen=false;if(this._isSplitButton()){o.setArrowState(false);O=o._getArrowButton();}O.$().removeAttr("aria-controls");};e.prototype._menuItemSelected=function(o){var m=o.getParameter("item");this.fireEvent("_menuItemSelected",{item:m});this._bPopupOpen=false;if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!m){return;}this._lastActionItemId=m.getId();!!this._sDefaultText&&this.setText(m.getText());!!this._sDefaultIcon&&this.setIcon(m.getIcon());};e.prototype._getLastSelectedItem=function(){return this._lastActionItemId;};e.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this);}};e.prototype._isSplitButton=function(){return this.getButtonMode()===a.Split;};e.prototype.setProperty=function(p,v,s){function i(t){var f=[b.Up,b.Back,b.Unstyled];return f.indexOf(t)!==-1;}if(p==="type"&&i(v)){return this;}if(p==='text'){this._sDefaultText=v;}switch(p){case'activeIcon':case'iconDensityAware':case'textDirection':case'visible':case'enabled':this._getButtonControl().setProperty(p,v);break;}return C.prototype.setProperty.apply(this,arguments);};e.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return C.prototype.setTooltip.apply(this,arguments);};e.prototype.setText=function(v){B.prototype.setProperty.call(this,'text',v);this._getButtonControl().setText(v);return this;};e.prototype.setType=function(v){B.prototype.setProperty.call(this,'type',v);this._getButtonControl().setType(v);return this;};e.prototype.setIcon=function(v){B.prototype.setProperty.call(this,'icon',v);this._getButtonControl().setIcon(v);return this;};e.prototype.addAriaLabelledBy=function(A){this.getAggregation("_button").addAssociation("ariaLabelledBy",A);return C.prototype.addAssociation.call(this,"ariaLabelledBy",A);};e.prototype.addAriaDescribedBy=function(A){this.getAggregation("_button").addAssociation("ariaDescribedBy",A);return C.prototype.addAssociation.call(this,"ariaDescribedBy",A);};e.prototype.removeAriaLabelledBy=function(A){this.getAggregation("_button").removeAssociation("ariaLabelledBy",A);return C.prototype.removeAssociation.call(this,"ariaLabelledBy",A);};e.prototype.removeAriaDescribedBy=function(A){this.getAggregation("_button").removeAssociation("ariaDescribedBy",A);return C.prototype.removeAssociation.call(this,"ariaDescribedBy",A);};e.prototype.removeAllAriaLabelledBy=function(A){this.getAggregation("_button").removeAllAssociation("ariaLabelledBy");return C.prototype.removeAllAssociation.call(this,"ariaLabelledBy");};e.prototype.removeAllAriaDescribedBy=function(){this.getAggregation("_button").removeAllAssociation("ariaDescribedBy");return C.prototype.removeAllAssociation.call(this,"ariaDescribedBy");};e.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef();};e.prototype.onsapup=function(o){this.openMenuByKeyboard();o.stopPropagation();};e.prototype.onsapdown=function(o){this.openMenuByKeyboard();o.stopPropagation();};e.prototype.onsapupmodifiers=function(o){this.openMenuByKeyboard();o.stopPropagation();};e.prototype.onsapdownmodifiers=function(o){this.openMenuByKeyboard();o.stopPropagation();};e.prototype.onsapshow=function(o){this.openMenuByKeyboard();!!o&&o.preventDefault();};e.prototype.ontouchstart=function(){this._bPopupOpen=this.getMenu()&&this.getMenu()._getMenu()&&this.getMenu()._getMenu().getPopup().isOpen();};e.prototype.onkeydown=function(o){if((o.keyCode===K.ENTER||o.keyCode===K.TAB)&&this._bPopupOpen){this.getMenu().close();this._bPopupOpen=false;}};e.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(true);}};e.prototype._writeAriaAttributes=function(){var o=this._getButtonControl(),O=this._isSplitButton()?o._getArrowButton():o,m=this.getMenu();if(m){O.$().attr("aria-controls",m.getDomRefId());}};e.prototype.getIdForLabel=function(){return this.getId()+"-internalBtn";};e.prototype._ensureBackwardsReference=function(){var i=this._getButtonControl(),I=i.getAriaLabelledBy(),r=L.getReferencingLabels(this);r.forEach(function(s){if(I&&I.indexOf(s)===-1){i.addAriaLabelledBy(s);}});return this;};return e;});
