/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ResponsivePopover","./Button","./Toolbar","./Bar","sap/ui/core/Control","sap/ui/core/IconPool","./semantic/SemanticPage","./Popover","./MessageView","sap/ui/Device","./MessagePopoverRenderer","sap/base/Log","sap/ui/base/ManagedObjectObserver","sap/ui/thirdparty/jquery"],function(R,B,T,a,C,I,S,P,M,D,b,L,c,q){"use strict";var d=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true},groupItems:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",altTypes:["sap.m.MessagePopoverItem"],multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false,forwarding:{idSuffix:"-messageView",aggregation:"headerButton"}}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}}});function e(n){return n.charAt(0).toUpperCase()+n.slice(1);}var f="sapMMsgPopover",g="320px",h="440px",i={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},A=["asyncDescriptionHandler","asyncURLHandler"],j={asyncDescriptionHandler:function(k){var l=k.item.getLongtextUrl();if(l){q.ajax({type:"GET",url:l,success:function(m){k.item.setDescription(m);k.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+l;L.error(E);k.promise.reject(E);}});}}};d.setDefaultHandlers=function(m){A.forEach(function(F){if(m.hasOwnProperty(F)){j[F]=m[F];}});};d.prototype.init=function(){var t=this;var p;this._oOpenByControl=null;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._oMessageView.addEventDelegate({onBeforeRendering:function(){var s=t._oMessageView._oSegmentedButton.getVisible(),k=!t.getInitiallyExpanded()||s;t._oMessageView._oSegmentedButton.setVisible(k);t._oMessageView._listPage.setShowHeader(true);}});this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:h,contentHeight:g,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._oMessageView._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(f);this._oPopover._setAriaModal(false);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(D.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(j.hasOwnProperty(F)){this['set'+e(F)](j[F]);}},this);this._observeItems();};d.prototype._observeItems=function(){var o=new c(function(k){var m=k.mutation;var l=k.child;var n=function(){setTimeout(this.invalidate.bind(this));}.bind(this);switch(m){case"insert":l.attachEvent("_change",n);break;case"remove":l.detachEvent("_change",n);break;default:break;}}.bind(this));o.observe(this,{aggregations:["items"]});};d.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover);}this._oPopover.setPlacement(this.getPlacement());};d.prototype.onBeforeRenderingPopover=function(){if(this._oMessageView&&this._bItemsChanged){var k=this.getItems();var t=this;this._oMessageView.destroyItems();k.forEach(function(l){l._updateProperties(function(){t._bItemsChanged=true;t.navigateBack();});this._oMessageView.addItem(l.clone("","",{cloneChildren:true,cloneBinding:true}));},this);this._bItemsChanged=false;}this._setInitialFocus();if(this._oOpenByControl&&!this._oOpenByControl.getVisible()){this._oPopover.close();}this._syncMessageView();};d.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null;}};d.prototype.exit=function(){this._oResourceBundle=null;this._oOpenByControl=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};d.prototype.openBy=function(o){var r=this._oPopover.getAggregation("_popup"),p=o.getParent();this._oOpenByControl=o;if(r instanceof P){if((p instanceof T||p instanceof a||p instanceof S)){r._minDimensions={width:400,height:128};r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(o);}return this;};d.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};d.prototype.isOpen=function(){return this._oPopover.isOpen();};d.prototype.toggle=function(o){if(this.isOpen()){this.close();}else{this.openBy(o);}return this;};d.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};d.prototype._initMessageView=function(){var t=this,m;m=new M(this.getId()+"-messageView",{activeTitlePress:function(E){if(D.system.phone){t.close();}t.fireActiveTitlePress({item:E.getParameter("item")});},listSelect:function(E){t.fireListSelect({messageTypeFilter:E.getParameter('messageTypeFilter')});},itemSelect:function(E){t.fireItemSelect({messageTypeFilter:E.getParameter('messageTypeFilter'),item:E.getParameter('item')});},longtextLoaded:function(){t.fireLongtextLoaded();},urlValidated:function(){t.fireUrlValidated();}});m._makeAutomaticBinding=function(){var k=t.getItems();if(!t.getBindingInfo("items")&&!k.length){this._bindToMessageModel();}};return m;};d.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(f+"-init")){this._expandMsgPopover();}};d.prototype._restoreExpansionDefaults=function(){if(this._oMessageView&&!this.getInitiallyExpanded()&&this.getItems().length!=1){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none");}else{this._expandMsgPopover();}};d.prototype._expandMsgPopover=function(){var s,H=g,s=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&s!=="0px"){H=parseFloat(s)?s:H;}this._oPopover.setContentHeight(H).removeStyleClass(f+"-init");};d.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(f+"-init").setContentHeight("auto");};d.prototype._insertCloseBtn=function(o){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),k=new B({icon:i["close"],visible:!D.system.phone,tooltip:s,press:this.close.bind(this)}).addStyleClass(f+"CloseBtn");o.insertContent(k,3,true);};d.prototype._setInitialFocus=function(){if(this._oMessageView&&this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||'all']);}};d.prototype._syncMessageView=function(){if(this._oMessageView){this._oMessageView.setProperty('asyncDescriptionHandler',this.getAsyncDescriptionHandler(),true);this._oMessageView.setProperty('asyncURLHandler',this.getAsyncURLHandler(),true);this._oMessageView.setProperty("groupItems",this.getGroupItems(),false);}};d.prototype.setModel=function(m,n){if(this._oMessageView){this._oMessageView.setModel(m,n);}return C.prototype.setModel.apply(this,arguments);};d.prototype.navigateBack=function(){if(this._oMessageView){this._oMessageView.navigateBack();}};["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(n){d.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var p=this._oPopover;var r=p[n].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){d.prototype["_"+F+"Old"]=d.prototype[F];d.prototype[F]=function(){var r=d.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return d;});
