/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Core','./NotificationListBase','sap/ui/core/InvisibleText','./ListItemBase','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/m/Button','./NotificationListGroupRenderer',"sap/ui/events/KeyCodes"],function(l,C,N,I,L,a,c,D,B,b,K){'use strict';var P=c.Priority;var d=l.ButtonType;var R=C.getLibraryResourceBundle('sap.m'),E=R.getText('NOTIFICATION_LIST_GROUP_EXPAND'),e=R.getText('NOTIFICATION_LIST_GROUP_COLLAPSE'),f=R.getText('NOTIFICATION_LIST_GROUP_READ'),U=R.getText('NOTIFICATION_LIST_GROUP_UNREAD'),g='sap-icon://slim-arrow-right',h='sap-icon://slim-arrow-down';var m=D.system.desktop?400:100;var i=N.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true},showEmptyGroup:{type:'boolean',group:'Behavior',defaultValue:false},enableCollapseButtonWhenEmpty:{type:'boolean',group:'Behavior',defaultValue:false},showItemsCounter:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:'',deprecated:true},authorPicture:{type:'sap.ui.core.URI',multiple:false,deprecated:true},datetime:{type:'string',group:'Appearance',defaultValue:'',deprecated:true}},defaultAggregation:'items',aggregations:{items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'},_collapseButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"}},events:{onCollapse:{parameters:{collapsed:{type:'boolean'}}}}}});i.prototype._getCollapseButton=function(){var k=this.getAggregation('_collapseButton'),n=this.getCollapsed();if(!k){k=new B(this.getId()+'-collapseButton',{type:d.Transparent,press:function(){var o=!this.getCollapsed();this.setCollapsed(o);this.fireOnCollapse({collapsed:o});}.bind(this)});this.setAggregation("_collapseButton",k,true);}k.setIcon(n?g:h);k.setTooltip(n?E:e);return k;};i.prototype.init=function(){this._groupTitleInvisibleText=new I({id:this.getId()+"-invisibleGroupTitleText"});};i.prototype.exit=function(){N.prototype.exit.apply(this,arguments);if(this._groupTitleInvisibleText){this._groupTitleInvisibleText.destroy();this._groupTitleInvisibleText=null;}};i.prototype.getVisibleItems=function(){var v=this.getItems().filter(function(k){return k.getVisible();});return v;};i.prototype._getVisibleItemsCount=function(){return this.getVisibleItems().length;};i.prototype._getGroupTitleInvisibleText=function(){var r=this.getUnread()?U:f,p,k=this.getPriority(),n,o=[r];if(k!==P.None){p=R.getText('NOTIFICATION_LIST_GROUP_PRIORITY',k);o.push(p);}if(this.getShowItemsCounter()){n=R.getText("LIST_ITEM_COUNTER",[this._getVisibleItemsCount()]);o.push(n);}return this._groupTitleInvisibleText.setText(o.join(' '));};i.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=P.None;if(n){n.forEach(function(k){p=j(p,k.getPriority());});}else{p=this.getProperty('priority');}return p;};function j(k,s){if(k==s){return k;}if((k=='None')){return s;}if((k=='Low')&&(s!='None')){return s;}if((k=='Medium')&&(s!='None'&&s!='Low')){return s;}return k;}i.prototype.onBeforeRendering=function(){N.prototype.onBeforeRendering.apply(this,arguments);this._getCollapseButton().setVisible(this.getEnableCollapseButtonWhenEmpty()||this._getVisibleItemsCount()>0);};i.prototype._isMaxNumberReached=function(){return this.getItems().length>m;};i.prototype._getMaxNumberReachedMsg=function(){return{title:R.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_TITLE',this.getItems().length-m),description:R.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_BODY')};};return i;});
