/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control',"sap/ui/Device",'sap/ui/core/Icon','sap/ui/core/ResizeHandler','sap/ui/core/ValueStateSupport','sap/ui/core/library','./ProgressIndicatorRenderer',"sap/base/Log","sap/m/Popover","sap/m/Text"],function(l,C,D,I,R,V,c,P,L,a,T){"use strict";var b=c.TextDirection;var d=c.ValueState;var e=l.PlacementType;var f=C.extend("sap.m.ProgressIndicator",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:d.None},displayValue:{type:"string",group:"Appearance",defaultValue:null},percentValue:{type:"float",group:"Data",defaultValue:0},showValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false},displayAnimation:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/ProgressIndicator.designtime"}});f.RESIZE_HANDLER_ID={SELF:"_sResizeHandlerId"};var u=sap.ui.getCore().getConfiguration().getAnimation();f.prototype.init=function(){this._bIEBrowser=D.browser.internet_explorer;};f.prototype.onBeforeRendering=function(){this._deRegisterResizeHandler(f.RESIZE_HANDLER_ID.SELF);};f.prototype.onAfterRendering=function(){this._updateHoverableScenario();this._registerResizeHandler(f.RESIZE_HANDLER_ID.SELF,this,this._onResize.bind(this));};f.prototype.exit=function(){if(this._oPopoverText){this._oPopoverText.destroy();this._oPopoverText=null;}this._deRegisterResizeHandler(f.RESIZE_HANDLER_ID.SELF);};f.prototype._registerResizeHandler=function(h,o,H){if(!this[h]){this[h]=R.register(o,H);}};f.prototype._deRegisterResizeHandler=function(h){if(this[h]){R.deregister(this[h]);this[h]=null;}};f.prototype._onResize=function(E){this._updateHoverableScenario();};f.prototype.ontap=function(E){var p;if(this._isHoverable()){p=this._getPopover();if(p.isOpen()){p.close();}else{p.openBy(this);}}};f.prototype._updateHoverableScenario=function(){var o=this.$(this.getPercentValue()>50?"textLeft":"textRight")[0],O=o&&o.offsetWidth,s=o&&o.scrollWidth;if(this._bIEBrowser){O+=1;}this.toggleStyleClass("sapMPIHoverable",this.getDisplayValue()!==""&&O<s);};f.prototype._isHoverable=function(){return this.hasStyleClass("sapMPIHoverable");};f.prototype._getPopover=function(){var p;if(!this.getAggregation("_popover")){this._oPopoverText=new T({text:this.getDisplayValue()});p=new a(this.getId()+"-popover",{showHeader:false,placement:e.Bottom,content:[this._oPopoverText,new I({src:"sap-icon://decline",press:this._onPopoverCloseIconPress.bind(this)})]}).addStyleClass('sapMPIPopover');this.setAggregation("_popover",p,true);}return this.getAggregation("_popover");};f.prototype._onPopoverCloseIconPress=function(){this._getPopover().close();};f.prototype.setDisplayValue=function(s){this.setProperty("displayValue",s);if(this._oPopoverText){this._oPopoverText.setText(s);}return this;};f.prototype.setPercentValue=function(p){var t=this,$,g,h=this.$(),A,o=p;p=parseFloat(p);if(!i(p)){if(p>100){p=100;}else if(p<0){p=0;}else{L.warning(this+": percentValue ("+o+") is not a valid number! The provided value will not be set!");return this;}L.warning(this+": percentValue ("+o+") is not correct! Setting the percentValue to "+p);}if(this.getPercentValue()!==p){g=this.getPercentValue()-p;this.setProperty("percentValue",p,true);if(!h.length){return this;}["sapMPIValueMax","sapMPIValueMin","sapMPIValueNormal","sapMPIValueGreaterHalf"].forEach(function(s){h.removeClass(s);});h.addClass(this._getCSSClassByPercentValue(p).join(" "));h.addClass("sapMPIAnimate").attr("aria-valuenow",p).attr("aria-valuetext",this._getAriaValueText({fPercent:p}));A=u&&this.getDisplayAnimation()?Math.abs(g)*20:0;$=this.$("bar");$.stop();$.animate({"flex-basis":p+"%"},A,"linear",function(){t._setText.apply(t);t.$().removeClass("sapMPIAnimate");});}return this;};f.prototype._setText=function(){this.$().toggleClass("sapMPIValueGreaterHalf",this.getPercentValue()>50);return this;};f.prototype._getCSSClassByPercentValue=function(p){if(p===100){return["sapMPIValueMax","sapMPIValueGreaterHalf"];}if(p===0){return["sapMPIValueMin"];}if(p<=50){return["sapMPIValueNormal"];}return["sapMPIValueNormal","sapMPIValueGreaterHalf"];};f.prototype._getAriaValueText=function(p){p.sText=p.sText||this.getDisplayValue();p.fPercent=p.fPercent||this.getPercentValue();p.sStateText=p.sStateText||this._getStateText();var A=p.sText||p.fPercent+"%";if(p.sStateText){A+=" "+p.sStateText;}return A;};f.prototype._getStateText=function(){return V.getAdditionalText(this.getState());};f.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=this.getDisplayValue(),g=s?s:B.getText("ACC_CTR_STATE_PROGRESS",[this.getPercentValue()]);return{role:"progressbar",type:B.getText("ACC_CTR_TYPE_PROGRESS"),description:g,focusable:this.getEnabled(),enabled:this.getEnabled()};};function i(v){return!isNaN(v)&&v>=0&&v<=100;}return f;});
