/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/base/Log','sap/base/util/isEmptyObject','./library','sap/ui/core/Control','./TreeRenderer','./Button'],function(q,L,a,l,C,T,B){"use strict";var b=l.TreeSelectionMode;var c=C.extend("sap.ui.commons.Tree",{metadata:{library:"sap.ui.commons",properties:{title:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},showHeader:{type:"boolean",group:"Misc",defaultValue:true},showHeaderIcons:{type:"boolean",group:"Misc",defaultValue:true},showHorizontalScrollbar:{type:"boolean",group:"Misc",defaultValue:false},minWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},selectionMode:{type:"sap.ui.commons.TreeSelectionMode",group:"Behavior",defaultValue:b.Legacy}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node",bindable:"bindable"}},events:{select:{allowPreventDefault:true,parameters:{node:{type:"sap.ui.commons.TreeNode"},nodeContext:{type:"object"}}},selectionChange:{parameters:{nodes:{type:"sap.ui.commons.TreeNode[]"},nodeContexts:{type:"object[]"}}}}}});c.prototype.resizeListenerId;c.prototype.init=function(){this.bAllCollapsed=false;this.allowTextSelection(false);this.iOldScrollTop=null;this.mSelectedNodes={};this.mSelectedContexts={};this.aLeadSelection=null;var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.oCollapseAllButton=new B(this.getId()+"-CollapseAll",{icon:this.getIconPrefix()+"CollapseAll.png",tooltip:R.getText("TREE_COLLAPSE_ALL"),lite:true});this.oExpandAllButton=new B(this.getId()+"-ExpandAll",{icon:this.getIconPrefix()+"ExpandAll.png",tooltip:R.getText("TREE_EXPAND_ALL"),lite:true});this.oCollapseAllButton.attachPress(this.onCollapseAll,this);this.oExpandAllButton.attachPress(this.onExpandAll,this);this.oCollapseAllButton.addStyleClass("sapUiTreeCol");this.oExpandAllButton.addStyleClass("sapUiTreeExp");};c.prototype.exit=function(){if(this.oCollapseAllButton){this.oCollapseAllButton.destroy();this.oCollapseAllButton=null;}if(this.oExpandAllButton){this.oExpandAllButton.destroy();this.oExpandAllButton=null;}};c.SelectionType={Select:"Select",Toggle:"Toggle",Range:"Range"};c.prototype.onThemeChanged=function(){if(this.oCollapseAllButton&&this.oExpandAllButton){this.oCollapseAllButton.setIcon(this.getIconPrefix()+"CollapseAll.png");this.oExpandAllButton.setIcon(this.getIconPrefix()+"ExpandAll.png");}};c.prototype.onExpandAll=function(){this.expandAll();};c.prototype.onCollapseAll=function(){this.collapseAll();};c.prototype.expandAll=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].expand(true,true);this._adjustSelectionOnExpanding(n[i]);}};c.prototype.collapseAll=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].collapse(true,true);this._adjustSelectionOnCollapsing(n[i]);}this._adjustFocus();};c.prototype.onsapdown=function(e){this.moveFocus(false);e.preventDefault();};c.prototype.onsapup=function(e){this.moveFocus(true);e.preventDefault();};c.prototype.onsaphome=function(e){this.placeFocus(this.getFirstSibling(e.target));e.preventDefault();};c.prototype.onsaphomemodifiers=function(e){this.placeFocus(this.getFirst());e.preventDefault();};c.prototype.onsapend=function(e){this.placeFocus(this.getLastSibling(e.target));e.preventDefault();};c.prototype.onsapendmodifiers=function(e){this.placeFocus(this.getLast());e.preventDefault();};c.prototype.onsapcollapseall=function(e){if(this.bAllCollapsed){this.expandAll();}else{this.collapseAll();}this.bAllCollapsed=!this.bAllCollapsed;};c.prototype.getIconPrefix=function(){var i="themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/";if(!sap.ui.getCore().getConfiguration().getRTL()){i+="img/tree/";}else{i+="img-RTL/tree/";}return sap.ui.resource("sap.ui.commons",i);};c.prototype.getFirstSibling=function(D){var e=q(D).siblings(".sapUiTreeNode:visible").first();if(e.length){return e[0];}return null;};c.prototype.getLastSibling=function(D){var e=q(D).siblings(".sapUiTreeNode:visible").last();if(e.length){return e[0];}return null;};c.prototype.getFirst=function(){var D=this.$().find(".sapUiTreeNode:visible").first();if(D.length){return D[0];}return null;};c.prototype.getLast=function(){var D=this.$().find(".sapUiTreeNode:visible").last();if(D.length){return D[0];}return null;};c.prototype.moveFocus=function(m){var e=q(".sapUiTreeNode:focus");if(e.length){var o=sap.ui.getCore().byId(e[0].id);var D=this.$().find(".sapUiTreeNode:visible");var f=D.index(e[0]);var n=f;if(m){n--;}else{n++;}if(n>=0&&n<D.length){var g=D.eq(n);var N=sap.ui.getCore().byId(g[0].id);o.blur();N.focus();}}};c.prototype._adjustFocus=function(){var f=this.$().find('.sapUiTreeNode[tabIndex="0"]');if(!f.is(':visible')){var D=this.$().find(".sapUiTreeNode");var e=D.index(f[0]);var g=D.filter(":lt("+e+")");var h=g.filter(":visible");var n=h[h.length-1];if(n){n.setAttribute("tabindex","0");if(q(".sapUiTreeNode:focus").is(":not(:visible)")){n.focus();}}}};c.prototype.placeFocus=function(D){if(!D){return;}var o=this.$().find(".sapUiTreeNode[tabIndex='0']");if(o.length){o[0].setAttribute("tabindex","-1");}D.setAttribute("tabindex","0");var t=sap.ui.getCore().byId(D.id);t.focus();};c.prototype._adjustSelectionOnExpanding=function(e){if(!e){return;}var E=[];if(e.getSelectedForNodes().length){E.push(e);}r(e,E,null);var $=e.$();if($&&$.hasClass('sapUiTreeNodeSelectedParent')){$.removeClass('sapUiTreeNodeSelectedParent');}var s=e.$('children').find('.sapUiTreeNodeExpanded.sapUiTreeNodeSelectedParent');s.removeClass('sapUiTreeNodeSelectedParent');};function r(n,e,f){var I=n.getExpanded(),N=false,g=I&&!!n.getSelectedForNodes().length,F=(f||I)?f:n,i;for(i=0;i<e.length;i++){if(e[i].getSelectedForNodes().indexOf(n.getId())!==-1){N=true;e[i].removeAssociation("selectedForNodes",n,true);}}if(F&&N&&F!==n){if(F.getSelectedForNodes().indexOf(n.getId())===-1){F.addAssociation("selectedForNodes",n,true);}F.$().addClass('sapUiTreeNodeSelectedParent');}if(g){e.push(n);}var h=n._getNodes();for(i=0;i<h.length;i++){r(h[i],e,F);}if(g){e.pop(n);}}function d(n,R){var N=n._getNodes(),o;for(var i=0;i<N.length;i++){o=N[i];if(o.getIsSelected()){R.addAssociation("selectedForNodes",o,true);}d(o,R);}}c.prototype._adjustSelectionOnCollapsing=function(o){if(!o){return;}d(o,o);if(o.getSelectedForNodes().length){var $=o.$();if($&&!$.hasClass('sapUiTreeNodeSelectedParent')){$.addClass('sapUiTreeNodeSelectedParent');}}};c.prototype.isTreeBinding=function(n){return(n=="nodes");};c.prototype.updateNodes=function(R){var n,N,k,e,i;if(R==="filter"){n=this.getAggregation("nodes");e=n.length;for(i=0;i<e;i++){n[i].destroy();}this.mSelectedNodes={};}this.updateAggregation("nodes");for(k in this.mSelectedContexts){N=this.getNodeByContext(this.mSelectedContexts[k]);if(N){N.setIsSelected(true);}else{this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,k);}}};c.prototype._removeItemFromObject=function(o,k){var K,R={};for(K in o){if(K!==k){R[K]=o[K];}}return R;};c.prototype.getNodeContext=function(n){var o=this.getBindingInfo("nodes"),m=o&&o.model;return n.getBindingContext(m);};c.prototype.getNodeByContext=function(o){var e=this.getBindingInfo("nodes"),m=e&&e.model;return this.findNode(this,function(n){var f=n.getBindingContext(m);return(o&&f&&o.getPath()===f.getPath());});};c.prototype.findNode=function(n,m){var f,t=this;if(m(n)){return n;}q.each(n._getNodes(),function(i,n){f=t.findNode(n,m);if(f){return false;}});return f;};c.prototype.setSelectionMode=function(m){m=this.validateProperty("selectionMode",m);if(this.getSelectionMode()!=m){this.setProperty("selectionMode",m);this._delSelection();}return this;};c.prototype.getSelection=function(){for(var i in this.mSelectedNodes){return this.mSelectedNodes[i];}return null;};c.prototype.setSelection=function(n,s,t){var D=true;if(!s){D=this.fireSelect({node:n,nodeContext:this.getNodeContext(n)});}if(D){switch(this.getSelectionMode()){case b.Legacy:case b.Single:this._setSelectedNode(n,s);break;case b.Multi:if(t==c.SelectionType.Range){this._setSelectedNodeMapRange(n,s);}else if(t==c.SelectionType.Toggle){this._setSelectedNodeMapToggle(n,s);}else{this._setSelectedNode(n,s);}break;case b.None:break;}}};c.prototype.onAfterRendering=function(){if(this.iOldScrollTop){this.$("TreeCont").scrollTop(this.iOldScrollTop);}};c.prototype.invalidate=function(){var t=this;C.prototype.invalidate.apply(this,arguments);if(this.iSelectionUpdateTimer){return;}this.iSelectionUpdateTimer=setTimeout(function(){t.mSelectedNodes={};t.mSelectedContexts=[];t.updateSelection(t,true);t.iSelectionUpdateTimer=null;},0);};c.prototype._addSelectedNodeContext=function(o){var p;if(o&&o.sPath){p=o.sPath;if(this.getSelectionMode()===b.Multi){if(!(p in this.mSelectedContexts)){this.mSelectedContexts[p]=o;}}else{this.mSelectedContexts={};this.mSelectedContexts[p]=o;}}};c.prototype.updateSelection=function(n,e){var t=this;q.each(n._getNodes(),function(i,n){if(n.getIsSelected()){switch(t.getSelectionMode()){case b.None:L.warning("Added selected nodes in a tree with disabled selection");n.setIsSelected(false);break;case b.Legacy:if(a(t.mSelectedNodes)){t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;case b.Single:if(a(t.mSelectedNodes)==false){L.warning("Added multiple selected nodes in single select tree");n.setIsSelected(false);}else{t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;case b.Multi:if(!e){L.warning("Added selected node inside collapsed node in multi select tree");n.setIsSelected(false);}else{t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;}}t.updateSelection(n,e&&n.getExpanded());});};c.prototype.onBeforeRendering=function(){this.iOldScrollTop=this.$("TreeCont").scrollTop();};c.prototype._setSelectedNode=function(n,s){var t=this,o=this.getNodeContext(n);q.each(this.mSelectedNodes,function(i,n){t._delMultiSelection(n,s);});n._select(s,true);this.mSelectedNodes[n.getId()]=n;this._addSelectedNodeContext(o);this.oLeadSelection=n;if(!s){this.fireSelectionChange({nodes:[n],nodeContexts:[o]});}};c.prototype._setSelectedNodeMapToggle=function(n,s){this._setNodeSelection(n,!n.getIsSelected(),s);};c.prototype._setSelectedNodeMapRange=function(n,s){var S,e=[],f=[],g,E,F,t;if(this.mSelectedNodes[n.getId()]==n){return;}else{if(this._getNodes().length>0){S=this._getSelectableNodes();g=S.indexOf(this.oLeadSelection);E=S.indexOf(n);F=g<E?g:E;t=g<E?E:g;for(var i=F;i<=t;i++){this._setMultiSelection(S[i],s);}}}if(!s){q.map(this.mSelectedNodes,function(n){e.push(n);});q.map(this.mSelectedContexts,function(o){f.push(o);});this.fireSelectionChange({nodes:e,nodeContexts:f});}};c.prototype._getSelectableNodes=function(n){var s=[];function e(n){q.each(n,function(i,N){if(N.getSelectable()){s.push(N);}if(N.getExpanded()){e(N._getNodes());}});}e(this._getNodes());return s;};c.prototype._setNodeSelection=function(n,i,s){var S=[],e=[],v;if(this.getSelectionMode()==b.Single){if(i){var o=this.getSelection();this._setSelectedNode(n,s);if(!n.isVisible()){v=this._getVisibleNode(n);this._adjustSelectionOnCollapsing(v);}if(o&&!o.isVisible()){v=this._getVisibleNode(o);this._adjustSelectionOnExpanding(v);}return;}else{this._delMultiSelection(n,s);if(!n.isVisible()){v=this._getVisibleNode(n);this._adjustSelectionOnExpanding(v);}}}if(i){this._setMultiSelection(n,s);this.oLeadSelection=n;}else{this._delMultiSelection(n,s);this.oLeadSelection=n;}if(!s){q.map(this.mSelectedNodes,function(n){S.push(n);});q.map(this.mSelectedContexts,function(f){e.push(f);});this.fireSelectionChange({nodes:S,nodeContexts:e});}};c.prototype._setMultiSelection=function(s,S){if(!s){return;}s._select(S);this.mSelectedNodes[s.getId()]=s;this._addSelectedNodeContext(this.getNodeContext(s));};c.prototype._delMultiSelection=function(s){var o;if(!s){return;}s._deselect();this.mSelectedNodes=this._removeItemFromObject(this.mSelectedNodes,s.getId());o=s.getBindingContext();if(o&&o.sPath){if(o.sPath in this.mSelectedContexts){this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,o.sPath);}}};c.prototype._delSelection=function(){var t=this;if(this.oSelectedNode){this.oSelectedNode._deselect();}if(a(this.mSelectedNodes)==false){q.each(this.mSelectedNodes,function(i,n){t._delMultiSelection(n);});}};c.prototype._getNodes=function(){return this.mAggregations.nodes||[];};c.prototype._getVisibleNode=function(n){var p=n.getParent();if(p.isVisible()){var v=p;}else{v=this._getVisibleNode(p);}return v;};return c;});
