/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/ui/core/CustomData','./mvc/View','./mvc/XMLProcessingMode','./mvc/EventHandlerResolver','./ExtensionPoint','./StashedControlSupport','sap/ui/base/SyncPromise','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/values','sap/base/assert','sap/base/security/encodeXML','sap/base/util/LoaderExtensions','sap/base/util/JSTokenizer','sap/base/util/isEmptyObject'],function(q,D,M,C,V,X,E,a,S,b,L,O,v,c,d,f,J,g){"use strict";function h(e,i,N,j,R){var B=M.bindingParser(i,j,true,false,false,false,R);if(B&&typeof B==="object"){return B;}var p=i=B||i;var z=D.getType(e);if(z){if(z instanceof D){p=z.parseValue(i,{context:j,locals:R});if(!z.isValid(p)){L.error("Value '"+i+"' is not valid for type '"+z.getName()+"'.");}}}else{throw new Error("Property "+N+" has unknown type "+e);}return typeof p==="string"?M.bindingParser.escape(p):p;}function l(e){return e.localName||e.baseName||e.nodeName;}var k="http://www.w3.org/1999/xhtml";var m="http://www.w3.org/2000/svg";var n="sap.ui.core";var o="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var r="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1";var s="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1";var I="http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1";var P="http://schemas.sap.com/sapui5/preprocessorextension/";function t(A,e){function i(p,z,B,F,G){var H,K,N=[];for(H=p.firstChild;H;H=H.nextSibling){K=e(p,z,B,H,false,F,G);if(K){N.push(K.unwrap());}}return b.resolve(N);}function j(p,z,B,F,G){var H,K=Promise.resolve(),N=[F];for(H=p.firstChild;H;H=H.nextSibling){K=K.then(e.bind(null,p,z,B,H,false,F,G));N.push(K);}return Promise.all(N);}return A?j:i;}var u={};u.loadTemplate=function(e,i){var R=e.replace(/\./g,"/")+("."+(i||"view")+".xml");return f.loadResource(R).documentElement;};u.loadTemplatePromise=function(e,i){var R=e.replace(/\./g,"/")+("."+(i||"view")+".xml");return f.loadResource(R,{async:true}).then(function(j){return j.documentElement;});};u.parseViewAttributes=function(e,j,p){var A=j.getMetadata().getAllProperties();for(var i=0;i<e.attributes.length;i++){var z=e.attributes[i];if(z.name==='controllerName'){j._controllerName=z.value;}else if(z.name==='resourceBundleName'){j._resourceBundleName=z.value;}else if(z.name==='resourceBundleUrl'){j._resourceBundleUrl=z.value;}else if(z.name==='resourceBundleLocale'){j._resourceBundleLocale=z.value;}else if(z.name==='resourceBundleAlias'){j._resourceBundleAlias=z.value;}else if(z.name==='class'){j.addStyleClass(z.value);}else if(!p[z.name]&&A[z.name]){p[z.name]=h(A[z.name].type,z.value,z.name,j._oContainingView.oController);}}};u.enrichTemplateIds=function(e,i){u.enrichTemplateIdsPromise(e,i,false);return e;};u.enrichTemplateIdsPromise=function(e,i,A){return y(e,i,true,A).then(function(){return e;});};u.parseTemplate=function(e,i){return u.parseTemplatePromise(e,i,false).unwrap();};u.parseTemplatePromise=function(i,j,A,z){return y(i,j,false,A,z).then(function(){var p=b.resolve(arguments[0]);if(j.isA("sap.ui.core.Fragment")){return p;}var B=arguments;if(j.isA("sap.ui.core.mvc.View")&&j._epInfo&&j._epInfo.all.length>0){p=T(A,j,{"content":j._epInfo.all});}return p.then(function(){if(Array.isArray(B[0])){B[0]=B[0].filter(function(e){return!e._isExtensionPoint;});}return B[0];});});};function w(R){var e,i=/^[a-zA-Z_$][a-zA-Z0-9_$]*$/;if(!R||typeof R!=="object"){e="core:require in XMLView can't be parsed to a valid object";}else{Object.keys(R).some(function(K){if(!i.test(K)){e="core:require in XMLView contains invalid identifier: '"+K+"'";return true;}if(!R[K]||typeof R[K]!=="string"){e="core:require in XMLView contains invalide value '"+R[K]+"'under key '"+K+"'";return true;}});}return e;}function x(j,A){var p=j.getAttributeNS(n,"require"),R,z,B;if(p){try{R=J.parseJS(p);}catch(e){L.error("Require attribute can't be parsed on Node: ",j.nodeName);throw e;}B=w(R);if(B){throw new Error(B+" on Node: "+j.nodeName);}if(!g(R)){z={};if(A){return new Promise(function(F,G){var H=Object.keys(R).reduce(function(i,K){z[K]=sap.ui.require(R[K]);return i&&z[K]!==undefined;},true);if(H){F(z);return;}sap.ui.require(v(R),function(){var K=arguments;Object.keys(R).forEach(function(N,i){z[N]=K[i];});F(z);},G);});}else{Object.keys(R).forEach(function(K){z[K]=sap.ui.requireSync(R[K]);});return b.resolve(z);}}}}function T(A,e,i){var j=b.resolve();if(!g(i)){var z=[];var R;if(A){j=new Promise(function(p){R=p;});}Object.keys(i).forEach(function(B){var F=i[B];F.forEach(function(G){G.targetControl=e;var H=sap.ui.require(G.providerClass);if(H){z.push(H.applyExtensionPoint(G));}else{var p=new Promise(function(K,N){sap.ui.require([G.providerClass],function(Q){K(Q);},N);}).then(function(K){return K.applyExtensionPoint(G);});z.push(p);}});});if(A){Promise.all(z).then(R);}}return j;}function y(p,z,A,B,F){var R=[],G=x(p,B)||b.resolve();B=B&&!!z._sProcessingMode;L.debug("XML processing mode is "+(z._sProcessingMode||"default")+".","","XMLTemplateProcessor");L.debug("XML will be processed "+B?"asynchronously":"synchronously"+".","","XMLTemplateProcessor");var H=sap.ui.getCore().getConfiguration().getDesignMode();if(H){z._sapui_declarativeSourceInfo={xmlNode:p,xmlRootNode:z._oContainingView===z?p:z._oContainingView._sapui_declarativeSourceInfo.xmlRootNode};}var K=z.sViewName||z._sFragmentName;if(!K){var N=z;var Q=0;while(++Q<1000&&N&&N!==N._oContainingView){N=N._oContainingView;}K=N.sViewName;}if(z.isSubView()){$(p,true,false,G);}else{if(p.localName==="View"&&p.namespaceURI!=="sap.ui.core.mvc"){L.warning("XMLView root node must have the 'sap.ui.core.mvc' namespace, not '"+p.namespaceURI+"'"+(K?" (View name: "+K+")":""));}_(p,false,false,G);}var i=0;function U(){for(;i<R.length;i++){var e=R[i];if(e&&typeof e.then==='function'){return e.then(W).then(U);}}return R;}function W(e){var j=[i,1].concat(e);Array.prototype.splice.apply(R,j);}return G.then(U);function Y(e){return e;}function Z(e){return z._oContainingView.createId(e);}function $(p,e,j,g1){if(p.nodeType===1){var h1=l(p);if(p.namespaceURI===k||p.namespaceURI===m){R.push("<"+h1+" ");var i1=false;for(var i=0;i<p.attributes.length;i++){var j1=p.attributes[i];var k1=j1.value;if(j1.name==="id"){i1=true;k1=e1(z,p);}R.push(j1.name+"=\""+d(k1)+"\" ");}if(e===true){R.push("data-sap-ui-preserve"+"=\""+z.getId()+"\" ");if(!i1){R.push("id"+"=\""+z.getId()+"\" ");}}R.push(">");var l1=p;if(window.HTMLTemplateElement&&p instanceof HTMLTemplateElement&&p.content instanceof DocumentFragment){l1=p.content;}_(l1,false,false,g1);R.push("</"+h1+">");}else if(h1==="FragmentDefinition"&&p.namespaceURI===n){_(p,false,true,g1);}else{G=G.then(function(){return c1(p,g1).then(function(o1){for(var i=0;i<o1.length;i++){var p1=o1[i];if(z.getMetadata().hasAggregation("content")){z._epInfo=z._epInfo||{contentControlsCount:0,last:null,all:[]};if(p1._isExtensionPoint){p1.index=z._epInfo.contentControlsCount;p1.targetControl=z;p1.aggregationName="content";if(z._epInfo.last){z._epInfo.last._nextSibling=p1;}z._epInfo.last=p1;z._epInfo.all.push(p1);}else{z._epInfo.contentControlsCount++;z.addAggregation("content",p1);}}else if(z.getMetadata().hasAssociation(("content"))){z.addAssociation("content",p1);}}return o1;});});R.push(G);}}else if(p.nodeType===3&&!j){var m1=p.textContent||p.text,n1=l(p.parentNode);if(m1){if(n1!="style"){m1=d(m1);}R.push(m1);}}}function _(p,e,j,g1){var h1=p.childNodes;for(var i=0;i<h1.length;i++){$(h1[i],e,j,g1);}}function a1(e,j){var g1;var h1=sap.ui.getCore().getLoadedLibraries();q.each(h1,function(l1,m1){if(e===m1.namespace||e===m1.name){g1=m1.name+"."+((m1.tagNames&&m1.tagNames[j])||j);}});g1=g1||e+"."+j;function i1(k1){if(!k1){L.error("Control '"+g1+"' did not return a class definition from sap.ui.define.","","XMLTemplateProcessor");k1=O.get(g1);}if(!k1){L.error("Can't find object class '"+g1+"' for XML-view","","XMLTemplateProcessor");}return k1;}var j1=g1.replace(/\./g,"/");var k1=sap.ui.require(j1);if(!k1){if(B){return new Promise(function(l1,m1){sap.ui.require([j1],function(k1){k1=i1(k1);l1(k1);},m1);});}else{k1=sap.ui.requireSync(j1);k1=i1(k1);}}return k1;}function b1(e,j,g1){if(e.namespaceURI===k||e.namespaceURI===m){var id=e.attributes['id']?e.attributes['id'].textContent||e.attributes['id'].text:null;if(A){return u.enrichTemplateIdsPromise(e,z,B).then(function(){return[];});}else{var i1=function(h1){var k1={id:id?e1(z,e,id):undefined,xmlNode:e,containingView:z._oContainingView,processingMode:z._sProcessingMode};if(z.fnScopedRunWithOwner){return z.fnScopedRunWithOwner(function(){return new h1(k1);});}return new h1(k1);};if(B){return new Promise(function(h1,k1){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(j1){h1([i1(j1)]);},k1);});}else{var j1=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return b.resolve([i1(j1)]);}}}else{return c1(e,j,g1);}}function c1(e,j,g1){if(l(e)==="ExtensionPoint"&&e.namespaceURI===n){if(A){return b.resolve([]);}else{var h1=z instanceof V?z._oContainingView:z;var i1=a._factory.bind(null,h1,e.getAttribute("name"),function(){var k1=b.resolve();var l1=[];var m1=e.childNodes;for(var i=0;i<m1.length;i++){var n1=m1[i];if(n1.nodeType===1){k1=k1.then(b1.bind(null,n1,j,g1));l1.push(k1);}}return b.all(l1).then(function(o1){var p1=[];o1.forEach(function(q1){p1=p1.concat(q1);});return p1;});});return b.resolve(z.fnScopedRunWithOwner?z.fnScopedRunWithOwner(i1):i1());}}else{var j1=a1(e.namespaceURI,l(e));if(j1&&typeof j1.then==='function'){return j1.then(function(k1){return d1(e,k1,j,g1);});}else{return d1(e,j1,j,g1);}}}function d1(g1,h1,i1,j1){var ns=g1.namespaceURI,l1={},m1={},n1="",o1=[],p1=null,q1=null,r1=g1.getAttribute("stashed")==="true";if(!A){g1.removeAttribute("stashed");}if(!h1){return b.resolve([]);}var s1=h1.getMetadata();var t1=s1.getAllSettings();var u1=x(g1,B);if(u1){i1=b.all([i1,u1]).then(function(e){return Object.assign({},e[0],e[1]);});}i1=i1.then(function(j){if(g(j)){j=null;}if(!A){for(var i=0;i<g1.attributes.length;i++){var k1=g1.attributes[i],z1=k1.name,A1,B1=t1[z1],C1=k1.value;if(z1==="id"){l1[z1]=e1(z,g1,C1);}else if(z1==="class"){n1+=C1;}else if(z1==="viewName"){l1[z1]=C1;}else if(z1==="fragmentName"){l1[z1]=C1;l1['containingView']=z._oContainingView;}else if((z1==="binding"&&!B1)||z1==='objectBindings'){if(!r1){var D1=M.bindingParser(C1,z._oContainingView.oController);if(D1){l1.objectBindings=l1.objectBindings||{};l1.objectBindings[D1.model||undefined]=D1;}}}else if(z1==='metadataContexts'){if(!r1){var E1=null;try{E1=u._calculatedModelMapping(C1,z._oContainingView.oController,true);}catch(e){L.error(z+":"+e.message);}if(E1){l1.metadataContexts=E1;if(u._preprocessMetadataContexts){u._preprocessMetadataContexts(h1.getMetadata().getName(),l1,z._oContainingView.oController);}}}}else if(z1.indexOf(":")>-1){A1=k1.namespaceURI;if(A1===o){var F1=l(k1);o1.push(new C({key:F1,value:h("any",C1,F1,z._oContainingView.oController)}));}else if(A1===r){q1=C1;}else if(A1&&A1.startsWith(P)){L.debug(z+": XMLView parser ignored preprocessor attribute '"+z1+"' (value: '"+C1+"')");}else if(A1===n||A1===I||z1.startsWith("xmlns:")){}else{if(!p1){p1={};}if(!p1.hasOwnProperty(k1.namespaceURI)){p1[k1.namespaceURI]={};}p1[k1.namespaceURI][l(k1)]=k1.nodeValue;L.debug(z+": XMLView parser encountered unknown attribute '"+z1+"' (value: '"+C1+"') with unknown namespace, stored as sap-ui-custom-settings of customData");}}else if(B1&&B1._iKind===0){l1[z1]=h(B1.type,C1,z1,z._oContainingView.oController,j);}else if(B1&&B1._iKind===1&&B1.altTypes){if(!r1){l1[z1]=h(B1.altTypes[0],C1,z1,z._oContainingView.oController,j);}}else if(B1&&B1._iKind===2){if(!r1){var D1=M.bindingParser(C1,z._oContainingView.oController,false,false,false,false,j);if(D1){l1[z1]=D1;}else{L.error(z+": aggregations with cardinality 0..n only allow binding paths as attribute value (wrong value: "+z1+"='"+C1+"')");}}}else if(B1&&B1._iKind===3){if(!r1){l1[z1]=Z(C1);}}else if(B1&&B1._iKind===4){if(!r1){l1[z1]=C1.split(/[\s,]+/g).filter(Y).map(Z);}}else if(B1&&B1._iKind===5){if(!r1){var G1=[];E.parse(C1).forEach(function(H1){var I1=E.resolveEventHandler(H1,z._oContainingView.oController,j);if(I1){G1.push(I1);}else{L.warning(z+": event handler function \""+H1+"\" is not a function or does not exist in the controller.");}});if(G1.length){l1[z1]=G1;}}}else if(B1&&B1._iKind===-1){if(V.prototype.isPrototypeOf(h1.prototype)&&z1=="async"){l1[z1]=h(B1.type,C1,z1,z._oContainingView.oController,j);}else{L.warning(z+": setting '"+z1+"' for class "+s1.getName()+" (value:'"+C1+"') is not supported");}}else{c(z1==='xmlns',z+": encountered unknown setting '"+z1+"' for class "+s1.getName()+" (value:'"+C1+"')");if(u._supportInfo){u._supportInfo({context:g1,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+z1+"' for class "+s1.getName()}});}}}if(p1){o1.push(new C({key:"sap-ui-custom-settings",value:p1}));}if(o1.length>0){l1.customData=o1;}}return j;}).catch(function(e){if(!e.isEnriched){var j=z.getMetadata().isA("sap.ui.core.mvc.View")?"View":"Fragment";var k1=g1&&g1.cloneNode(false);var z1=k1&&new XMLSerializer().serializeToString(k1);e=new Error("Error found in "+j+" (id: '"+z.getId()+"').\nXML node: '"+z1+"':\n"+e);e.isEnriched=true;L.error(e);}if(B&&z._sProcessingMode!==X.SequentialLegacy){throw e;}});var v1=t(B,w1);function w1(g1,x1,y1,e,k1,i1,j1){var z1,A1;if(e.nodeType===1){if(e.namespaceURI===s){l1[l(e)]=e.querySelector("*");return;}z1=e.namespaceURI===ns&&y1&&y1[l(e)];if(z1){return v1(e,z1,false,i1,j1);}else if(x1){if(!k1&&e.getAttribute("stashed")==="true"&&!A){var B1=e;e=e.cloneNode();B1.removeAttribute("stashed");A1=function(){var j=e1(z,e);S.createStashedControl({wrapperId:j,fnCreate:function(){var D1=B;B=false;try{return w1(g1,x1,y1,B1,true,i1,j1).unwrap();}finally{B=D1;}}});};if(z.fnScopedRunWithOwner){z.fnScopedRunWithOwner(A1);}else{A1();}e.setAttribute("visible","false");}if(l1[x1.name]&&l1[x1.name].path&&typeof l1[x1.name].path==="string"){j1={aggregation:x1.name,id:l1.id};}return b1(e,i1,j1).then(function(D1){for(var j=0;j<D1.length;j++){var E1=D1[j];var F1=x1.name;if(E1._isExtensionPoint){if(!l1[F1]){l1[F1]=[];}var G1=m1[F1];if(!G1){G1=m1[F1]=[];}E1.index=l1[F1].length;E1.aggregationName=F1;E1.closestAggregationBindingCarrier=j1&&j1.id;E1.closestAggregationBinding=j1&&j1.aggregation;var H1=G1[G1.length-1];if(H1){H1._nextSibling=E1;}G1.push(E1);}else if(x1.multiple){if(!l1[F1]){l1[F1]=[];}if(typeof l1[F1].path==="string"){c(!l1[F1].template,"list bindings support only a single template object");l1[F1].template=E1;}else{l1[F1].push(E1);}}else{c(!l1[F1],"multiple aggregates defined for aggregation with cardinality 0..1");l1[F1]=E1;}}return D1;});}else if(l(g1)!=="FragmentDefinition"||g1.namespaceURI!==n){throw new Error("Cannot add direct child without default aggregation defined for control "+s1.getElementName());}}else if(e.nodeType===3){var C1=e.textContent||e.text;if(C1&&C1.trim()){throw new Error("Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed: "+C1.trim());}}}var x1=s1.getDefaultAggregation();var y1=s1.getAllAggregations();return v1(g1,x1,y1,i1,j1).then(function(){var e;var j=b.resolve();var k1=b.resolve();var z1=g1.getAttribute("type");if(A&&g1.hasAttribute("id")){f1(z,g1);}else if(!A){if(h1.getMetadata().isA("sap.ui.core.mvc.View")){var A1=function(){if(h1.getMetadata().isA("sap.ui.core.mvc.XMLView")&&z._sProcessingMode){l1.processingMode=z._sProcessingMode;}return V._legacyCreate(l1,undefined,h1._sType||z1);};if(z.fnScopedRunWithOwner){e=z.fnScopedRunWithOwner(A1);}else{e=A1();}}else if(h1.getMetadata().isA("sap.ui.core.Fragment")&&B&&["XML","JS","HTML"].indexOf(l1.type)>-1){if(z1!=="JS"){l1.processingMode=z._sProcessingMode;}var B1="sap/ui/core/Fragment";var C1=sap.ui.require(B1);l1.name=l1.name||l1.fragmentName;if(C1){k1=C1.load(l1);}else{k1=new Promise(function(E1,F1){sap.ui.require([B1],function(C1){C1.load(l1).then(function(G1){E1(G1);});},F1);});}}else{var D1=function(){var E1;if(z.fnScopedRunWithOwner){E1=z.fnScopedRunWithOwner(function(){var E1=new h1(l1);return E1;});}else{E1=new h1(l1);}j=T(B,E1,m1);return E1;};if(F&&F.fnRunWithPreprocessor){e=F.fnRunWithPreprocessor(D1);}else{e=D1();}}}return k1.then(function(E1){return E1||e;}).then(function(E1){if(n1&&E1.addStyleClass){E1.addStyleClass(n1);}if(!E1){E1=[];}else if(!Array.isArray(E1)){E1=[E1];}if(u._supportInfo&&E1){for(var i=0,F1=E1.length;i<F1;i++){var G1=E1[i];if(G1&&G1.getId()){var H1=u._supportInfo({context:g1,env:{caller:"createRegularControls",nodeid:g1.getAttribute("id"),controlid:G1.getId()}}),I1=q1?q1+",":"";I1+=H1;u._supportInfo.addSupportInfo(G1.getId(),I1);}}}if(H){E1.forEach(function(G1){if(s1.getCompositeAggregationName){var J1=g1.getElementsByTagName(G1.getMetadata().getCompositeAggregationName());for(var i=0;i<J1.length;i++){g1.removeChild(J1[0]);}}G1._sapui_declarativeSourceInfo={xmlNode:g1,xmlRootNode:z._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:s1.getName()==='sap.ui.core.Fragment'?l1['fragmentName']:null};});}return j.then(function(){return E1;});});});}function e1(z,p,e){if(p.getAttributeNS(I,"id")){return p.getAttribute("id");}else{return Z(e?e:p.getAttribute("id"));}}function f1(z,p){p.setAttribute("id",Z(p.getAttribute("id")));p.setAttributeNS(I,"id",true);}}u._preprocessMetadataContexts=null;u._calculatedModelMapping=function(B,e,A){var j,p={},z=M.bindingParser(B,e);function F(G){if(G.length%2===0){throw new Error("The last entry is no binding");}for(var i=1;i<=G.length;i=i+2){if(typeof G[i-1]=='string'){throw new Error("Binding expected not a string");}if(G[i]){if((typeof G[i]!='string')||(G[i]!=",")){throw new Error("Missing delimiter ','");}}}}if(z){if(!z.formatter){j=z;z={parts:[j]};}else{F(z.formatter.textFragments);}for(var i=0;i<z.parts.length;i++){j=z.parts[i];p[j.model]=p[j.model]||(A?[]:null);if(Array.isArray(p[j.model])){p[j.model].push(j);}else{p[j.model]=j;}}}return p;};return u;},true);
