/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/Context","sap/ui/model/PropertyBinding","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/layout/HorizontalLayout","sap/ui/layout/Grid","sap/m/SearchField","sap/m/RadioButton","sap/m/ColumnListItem","sap/m/Column","sap/m/Text","sap/m/Bar","sap/m/Table","sap/m/Page","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/ToggleButton","sap/m/CheckBox","sap/m/Dialog","sap/m/Input","sap/m/Label","sap/m/Title","sap/m/ResponsivePopover","sap/m/SelectList","sap/m/ObjectIdentifier","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/VBox","sap/ui/events/KeyCodes","sap/ui/core/library","sap/m/library","sap/ui/fl/Utils"],function(C,P,J,F,a,D,I,b,c,H,G,S,R,d,f,T,B,g,h,i,j,k,l,m,n,o,L,p,q,r,O,s,t,V,K,u,v,w){"use strict";var x=v.OverflowToolbarPriority;var y=v.ButtonType;var z=v.PlacementType;var A=v.PopinDisplay;var E=v.ScreenSize;var M=u.ValueState;var N=u.TextAlign;var Q=b.extend("sap.ui.fl.variants.VariantManagement",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},manualVariantKey:{type:"boolean",group:"Misc",defaultValue:false},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},editable:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:null},updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false},resetOnContextChange:{type:"boolean",group:"Misc",defaultValue:true},executeOnSelectionForStandardDefault:{type:"boolean",group:"Misc",defaultValue:false}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"}}},manage:{},initialized:{},select:{parameters:{key:{type:"string"}}}}},renderer:{apiVersion:2,render:function(e,U){e.openStart("div",U).class("sapUiFlVarMngmt").attr("title",U._oRb.getText("VARIANT_MANAGEMENT_TRIGGER_TT")).openEnd();e.renderControl(U.oVariantLayout);e.close("div");}}});Q.INNER_MODEL_NAME="$sapUiFlVariants";Q.MAX_NAME_LEN=100;Q.COLUMN_FAV_IDX=0;Q.COLUMN_NAME_IDX=1;Q.prototype.init=function(){this._sModelName=w.VARIANT_MODEL_NAME;this.attachModelContextChange(this._setModel,this);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._createInnerModel();this.oVariantInvisibleText=new I();this.oVariantText=new p(this.getId()+"-text",{text:{path:'currentVariant',model:this._sModelName,formatter:function(U){var W="";if(U){W=this.getSelectedVariantText(U);this._setInvisibleText(W,this.getModified());}return W;}.bind(this)}});this.oVariantText.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantText.addStyleClass("sapUiFlVarMngmtTitle");if(D.system.phone){this.oVariantText.addStyleClass("sapUiFlVarMngmtTextPhoneMaxWidth");}else{this.oVariantText.addStyleClass("sapUiFlVarMngmtTextMaxWidth");}var e=new L(this.getId()+"-modified",{text:"*",visible:{path:"modified",model:this._sModelName,formatter:function(U){var W=this.getCurrentVariantKey();if(W){this._setInvisibleText(this.getSelectedVariantText(W),U);}return((U===null)||(U===undefined))?false:U;}.bind(this)}});e.setVisible(false);e.addStyleClass("sapUiFlVarMngmtModified");e.addStyleClass("sapUiFlVarMngmtClickable");e.addStyleClass("sapMTitleStyleH4");this.oVariantPopoverTrigger=new l(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:y.Transparent,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_TRIGGER_TT"),press:function(){this._oCtrlRef=this.oVariantPopoverTrigger;}.bind(this)});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtn");this.oVariantPopoverTrigger.addStyleClass("sapMTitleStyleH4");this.oVariantLayout=new H({content:[this.oVariantText,e,this.oVariantPopoverTrigger]});this.oVariantLayout.addStyleClass("sapUiFlVarMngmtLayout");e.setVisible(false);this.oVariantInvisibleText.toStatic();this.addDependent(this.oVariantLayout);};Q.prototype.getOverflowToolbarConfig=function(){var e={canOverflow:false,invalidationEvents:["save","manage","select"]};return e;};Q.prototype.getTitle=function(){return this.oVariantText;};Q.prototype._setInvisibleText=function(e,U){var W;if(e){if(U){W="VARIANT_MANAGEMENT_SEL_VARIANT_MOD";}else{W="VARIANT_MANAGEMENT_SEL_VARIANT";}this.oVariantInvisibleText.setText(this._oRb.getText(W,[e]));}};Q.prototype._createInnerModel=function(){var e=new J({showExecuteOnSelection:false,showSetAsDefault:true,editable:true,popoverTitle:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS")});this.setModel(e,Q.INNER_MODEL_NAME);this._bindProperties();};Q.prototype._bindProperties=function(){this.bindProperty("showSetAsDefault",{path:"/showSetAsDefault",model:Q.INNER_MODEL_NAME});this.bindProperty("editable",{path:"/editable",model:Q.INNER_MODEL_NAME});};Q.prototype._getShowExecuteOnSelection=function(){var e=this.getModel(Q.INNER_MODEL_NAME);if(e){return e.getProperty("/showExecuteOnSelection");}return false;};Q.prototype._setShowExecuteOnSelection=function(e){var U=this.getModel(Q.INNER_MODEL_NAME);if(U){U.setProperty("/showExecuteOnSelection",e);}};Q.prototype.setExecuteOnSelection=function(e){var U=this.getModel(this._sModelName);if(U&&this.oContext){U.setProperty(this.oContext+"/executeOnSelection",e);}};Q.prototype.getOriginalDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/originalDefaultVariant");}return null;};Q.prototype.setDefaultVariantKey=function(e){var U=this.getModel(this._sModelName);if(U&&this.oContext){U.setProperty(this.oContext+"/defaultVariant",e);}};Q.prototype.getDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/defaultVariant");}return null;};Q.prototype.setCurrentVariantKey=function(e){var U=this.getModel(this._sModelName);if(U&&this.oContext){U.setProperty(this.oContext+"/currentVariant",e);}return this;};Q.prototype.getCurrentVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/currentVariant");}return null;};Q.prototype._assignPopoverTitle=function(){var e;var U;var W=this.getModel(this._sModelName);if(W&&this.oContext){e=W.getProperty(this.oContext+"/popoverTitle");}if(e!==undefined){U=this.getModel(Q.INNER_MODEL_NAME);if(U){U.setProperty("/popoverTitle",e);}}};Q.prototype.getVariants=function(){return this._getItems();};Q.prototype.setModified=function(e){var U=this.getModel(this._sModelName);if(U&&this.oContext){U.setProperty(this.oContext+"/modified",e);}};Q.prototype.getModified=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/modified");}return false;};Q.prototype.getSelectedVariantText=function(e){var U=this._getItemByKey(e);if(U){return U.title;}return"";};Q.prototype.getStandardVariantKey=function(){var e=this._getItems();if(e&&e[0]){return e[0].key;}return null;};Q.prototype.getShowFavorites=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/showFavorites");}return false;};Q.prototype._clearDeletedItems=function(){this._aDeletedItems=[];};Q.prototype._addDeletedItem=function(e){this._aDeletedItems.push(e);};Q.prototype._getDeletedItems=function(){return this._aDeletedItems;};Q.prototype._getItems=function(){var e=[];if(this.oContext&&this.oContext.getObject()){e=this.oContext.getObject().variants.filter(function(U){if(!U.hasOwnProperty("visible")){return true;}return U.visible;});}return e;};Q.prototype._getItemByKey=function(e){var U=null;var W=this._getItems();W.some(function(X){if(X.key===e){U=X;}return(U!==null);});return U;};Q.prototype._rebindControl=function(){this.oVariantText.unbindProperty("text");this.oVariantText.bindProperty("text",{path:'currentVariant',model:this._sModelName,formatter:function(e){var U=this.getSelectedVariantText(e);return U;}.bind(this)});this.oVariantText.unbindProperty("visible");this.oVariantText.bindProperty("visible",{path:"modified",model:this._sModelName,formatter:function(e){return(e===null||e===undefined)?false:e;}});};Q.prototype.setModelName=function(e){if(this.getModelName()){this.oContext=null;}this.setProperty("modelName",e);this._sModelName=e;this._rebindControl();return this;};Q.prototype._setBindingContext=function(){var e;var U;if(!this.oContext){e=this.getModel(this._sModelName);if(e){U=this._getLocalId(e);if(U){this.oContext=new C(e,"/"+U);this.setBindingContext(this.oContext,this._sModelName);if(!this.getModelName()&&e.registerToModel){e.registerToModel(this);}this._assignPopoverTitle();this._registerPropertyChanges(e);this.fireInitialized();}}}};Q.prototype._getLocalId=function(e){if(this.getModelName()&&(this._sModelName!==w.VARIANT_MODEL_NAME)){return this.getId();}return e.getVariantManagementReferenceForControl(this);};Q.prototype._setModel=function(){this._setBindingContext();};Q.prototype._registerPropertyChanges=function(e){var U=new P(e,this.oContext+"/showExecuteOnSelection");U.attachChange(function(W){if(W&&W.oSource&&W.oSource.oModel&&W.oSource.sPath){var X=W.oSource.oModel.getProperty(W.oSource.sPath);if(X!==undefined){this._setShowExecuteOnSelection(X);}}}.bind(this));U=new P(e,this.oContext+"/variantsEditable");U.attachChange(function(W){if(W&&W.oSource&&W.oSource.oModel&&W.oSource.sPath){var X;var Y=W.oSource.oModel.getProperty(W.oSource.sPath);X=this.getModel(Q.INNER_MODEL_NAME);if(X&&(Y!==undefined)){X.setProperty("/editable",Y);}}}.bind(this));};Q.prototype.handleOpenCloseVariantPopover=function(){if(!this.bPopoverOpen){this._openVariantList();}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();}};Q.prototype.getFocusDomRef=function(){if(this.oVariantPopoverTrigger){return this.oVariantPopoverTrigger.getFocusDomRef();}};Q.prototype.onclick=function(){if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus();}this.handleOpenCloseVariantPopover();};Q.prototype.onkeyup=function(e){if(e.which===K.F4||e.which===K.SPACE||e.altKey===true&&e.which===K.ARROW_UP||e.altKey===true&&e.which===K.ARROW_DOWN){this._openVariantList();}};Q.prototype.onAfterRendering=function(){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));};Q.prototype._openInErrorState=function(){var U;if(!this.oErrorVariantPopOver){U=new V({fitContainer:true,alignItems:sap.m.FlexAlignItems.Center,items:[new c({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new p({titleStyle:sap.ui.core.TitleLevel.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new T({textAlign:sap.ui.core.TextAlign.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});U.addStyleClass("sapUiFlVarMngmtErrorPopover");this.oErrorVariantPopOver=new q(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:Q.INNER_MODEL_NAME},contentWidth:"400px",placement:z.VerticalPreferredBottom,content:[new h(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[U]})],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close();}}.bind(this));}if(this.bPopoverOpen){return;}this.oErrorVariantPopOver.openBy(this.oVariantLayout);};Q.prototype._createVariantList=function(){if(this.oVariantPopOver){return;}this.oVariantManageBtn=new k(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog();}.bind(this),layoutData:new t({priority:x.Low})});this.oVariantSaveBtn=new k(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave();}.bind(this),visible:{path:"modified",model:this._sModelName,formatter:function(U){return U;}},type:y.Emphasized,layoutData:new t({priority:x.Low})});this.oVariantSaveAsBtn=new k(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog();}.bind(this),layoutData:new t({priority:x.Low})});this._oVariantList=new r(this.getId()+"-list",{selectedKey:{path:"currentVariant",model:this._sModelName},itemPress:function(U){var W=null;if(U&&U.getParameters()){var X=U.getParameters().item;if(X){W=X.getKey();}}if(W){this.setCurrentVariantKey(W);this.fireEvent("select",{key:W});this.oVariantPopOver.close();}}.bind(this)});this._oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var e=new sap.ui.core.Item({key:'{'+this._sModelName+">key}",text:'{'+this._sModelName+">title}"});this._oVariantList.bindAggregation("items",{path:"variants",model:this._sModelName,template:e});this._oSearchField=new S(this.getId()+"-search");this._oSearchField.attachLiveChange(function(U){this._triggerSearch(U,this._oVariantList);}.bind(this));this.oVariantSelectionPage=new h(this.getId()+"-selpage",{subHeader:new i({content:[this._oSearchField]}),content:[this._oVariantList],footer:new s({content:[new j(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false,showFooter:{path:"/editable",model:Q.INNER_MODEL_NAME}});this.oVariantPopOver=new q(this.getId()+"-popover",{title:{path:"/popoverTitle",model:Q.INNER_MODEL_NAME},titleAlignment:"Auto",contentWidth:"400px",placement:z.VerticalPreferredBottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true;this.oVariantPopoverTrigger.setPressed(true);}.bind(this),afterClose:function(){this.oVariantPopoverTrigger.setPressed(false);if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oVariantPopOver);};Q.prototype.showSaveButton=function(e){if(e===false){this.oVariantSaveAsBtn.setType(y.Emphasized);this.oVariantSaveBtn.setVisible(false);}else{this.oVariantSaveAsBtn.setType(y.Default);this.oVariantSaveBtn.setVisible(true);}};Q.prototype._openVariantList=function(){var e;if(this.getInErrorState()){this._openInErrorState();return;}if(this.bPopoverOpen){return;}if(!this.oContext){return;}this._createVariantList();this._oSearchField.setValue("");this._oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this._oVariantList.getItems().length>9);this.showSaveButton(false);if(this.getModified()){e=this._getItemByKey(this.getCurrentVariantKey());if(e&&e.change){this.showSaveButton(true);}}var U=this._oCtrlRef?this._oCtrlRef:this.oVariantLayout;this._oCtrlRef=null;this.oVariantPopOver.openBy(U);};Q.prototype._triggerSearch=function(e,U){if(!e){return;}var W=e.getParameters();if(!W){return;}var X=W.newValue?W.newValue:"";var Y=new F({path:"title",operator:a.Contains,value1:X});U.getBinding("items").filter(this._getFilters(Y));};Q.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new o(this.getId()+"-name",{liveChange:function(){this._checkVariantNameConstraints(this.oInputName);}.bind(this)});var e=new L(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")});e.setLabelFor(this.oInputName);e.addStyleClass("sapUiFlVarMngmtSaveDialogLabel");this.oDefault=new m(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/showSetAsDefault",model:Q.INNER_MODEL_NAME},width:"100%"});this.oExecuteOnSelect=new m(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/showExecuteOnSelection",model:Q.INNER_MODEL_NAME},width:"100%"});this.oInputManualKey=new o(this.getId()+"-key",{liveChange:function(){this._checkVariantNameConstraints(this.oInputManualKey);}.bind(this)});this.oLabelKey=new L(this.getId()+"-keylabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_KEY"),required:true});this.oLabelKey.setLabelFor(this.oInputManualKey);this.oSaveSave=new k(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),type:y.Emphasized,press:function(){if(!this._bSaveOngoing){this._checkVariantNameConstraints(this.oInputName);if(this.oInputName.getValueState()==="Error"){return;}this._bSaveOngoing=true;this._bSaveCanceled=false;this._handleVariantSaveAs(this.oInputName.getValue());}}.bind(this),enabled:true});var U=new G({defaultSpan:"L12 M12 S12"});if(this.getShowSetAsDefault()){U.addContent(this.oDefault);}if(this._getShowExecuteOnSelection()){U.addContent(this.oExecuteOnSelect);}this.oSaveAsDialog=new n(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),afterClose:function(){this._bSaveOngoing=false;}.bind(this),beginButton:this.oSaveSave,endButton:new k(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._bSaveCanceled=true;this.oSaveAsDialog.close();}.bind(this)}),content:[e,this.oInputName,this.oLabelKey,this.oInputManualKey,U],stretch:D.system.phone});this.oSaveAsDialog.addStyleClass("sapUiPopupWithPadding");this.oSaveAsDialog.addStyleClass("sapUiFlVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oSaveAsDialog);}};Q.prototype._openSaveAsDialog=function(){this._createSaveAsDialog();this.oInputName.setValue(this.getSelectedVariantText(this.getCurrentVariantKey()));this.oInputName.setEnabled(true);this.oInputName.setValueState(M.None);this.oInputName.setValueStateText(null);this.oDefault.setSelected(false);this.oExecuteOnSelect.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close();}if(this.getManualVariantKey()){this.oInputManualKey.setVisible(true);this.oInputManualKey.setEnabled(true);this.oInputManualKey.setValueState(M.None);this.oInputManualKey.setValueStateText(null);this.oLabelKey.setVisible(true);}else{this.oInputManualKey.setVisible(false);this.oLabelKey.setVisible(false);}this.oSaveAsDialog.open();};Q.prototype._handleVariantSaveAs=function(e){var U=null;var W=e.trim();var X=this.oInputManualKey.getValue().trim();if(W===""){this.oInputName.setValueState(M.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}if(this.getManualVariantKey()){if(X===""){this.oInputManualKey.setValueState(M.Error);this.oInputManualKey.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}U=X;}if(this.oSaveAsDialog){this.oSaveAsDialog.close();}if(this.oDefault.getSelected()){this.setDefaultVariantKey(U);}this.setModified(false);this.fireSave({key:U,name:W,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected()});};Q.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getCurrentVariantKey());var U=false;if(this.getDefaultVariantKey()===e.key){U=true;}if(this.oVariantPopOver){this.oVariantPopOver.close();}this.fireSave({name:e.title,overwrite:true,key:e.key,def:U});this.setModified(false);};Q.prototype.openManagementDialog=function(e,U){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined;}this._openManagementDialog(U);};Q.prototype._triggerSearchInManageDialog=function(e,U){if(!e){return;}var W=e.getParameters();if(!W){return;}var X=W.newValue?W.newValue:"";var Y=[this._getVisibleFilter(),new F({filters:[new F({path:"title",operator:a.Contains,value1:X}),new F({path:"author",operator:a.Contains,value1:X})],and:false})];U.getBinding("items").filter(Y);this._bDeleteOccured=true;};Q.prototype.getManageDialog=function(){return this.oManagementDialog;};Q.prototype._createManagementDialog=function(){if(!this.oManagementDialog||this.oManagementDialog.bIsDestroyed){this.oManagementTable=new g(this.getId()+"-managementTable",{growing:true,columns:[new f({width:"3rem",visible:{path:"showFavorites",model:this._sModelName}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"14rem"}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT"),wrappingType:"Hyphenated"}),width:"4rem",demandPopin:true,popinDisplay:A.Inline,minScreenWidth:E.Tablet,visible:{path:"/showSetAsDefault",model:Q.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),wrappingType:"Hyphenated"}),width:"6rem",hAlign:N.Center,demandPopin:true,popinDisplay:A.Inline,minScreenWidth:"800px",visible:{path:"/showExecuteOnSelection",model:Q.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR")}),width:"8rem",demandPopin:true,popinDisplay:A.Inline,minScreenWidth:"900px"}),new f({width:"2rem",hAlign:N.Center}),new f({visible:false})]});this.oManagementSave=new k(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),enabled:true,type:y.Emphasized,press:function(){this._handleManageSavePressed();}.bind(this)});this.oManagementCancel=new k(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._resumeManagementTableBinding();this.oManagementDialog.close();this._handleManageCancelPressed();}.bind(this)});this.oManagementDialog=new n(this.getId()+"-managementdialog",{contentWidth:"40%",resizable:true,draggable:true,title:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG"),beginButton:this.oManagementSave,endButton:this.oManagementCancel,content:[this.oManagementTable],stretch:D.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false;};this._oSearchFieldOnMgmtDialog=new S();this._oSearchFieldOnMgmtDialog.attachLiveChange(function(U){this._triggerSearchInManageDialog(U,this.oManagementTable);}.bind(this));var e=new B(this.getId()+"-mgmHeaderSearch",{contentMiddle:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bDeleteOccured=false;}};Q.prototype._setFavoriteIcon=function(e,U){if(e){e.setSrc(U?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(U?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));e.setAlt(this._oRb.getText(U?"VARIANT_MANAGEMENT_FAV_DEL_ACC":"VARIANT_MANAGEMENT_FAV_ADD_ACC"));}};Q.prototype._templateFactoryManagementDialog=function(e,U){var W=null;var X;var Y;var Z;var $=U.getObject();if(!$){return undefined;}var _=function(h1){this._checkVariantNameConstraints(h1.oSource,h1.oSource.getBindingContext(this._sModelName).getObject().key);}.bind(this);var a1=function(h1){this._handleManageTitleChanged(h1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var b1=function(h1){if(h1.getParameters().selected===true){this._handleManageDefaultVariantChange(h1.oSource,h1.oSource.getBindingContext(this._sModelName).getObject());}}.bind(this);var c1=function(h1){this._handleManageExecuteOnSelectionChanged(h1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var d1=function(h1){this._handleManageDeletePressed(h1.oSource.getBindingContext(this._sModelName).getObject());var i1=h1.oSource.getParent();if(i1){i1.setVisible(false);}this._reCheckVariantNameConstraints();}.bind(this);var e1=function(h1){this._handleManageFavoriteChanged(h1.oSource,h1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);if($.rename){Z=new o({liveChange:_,change:a1,value:'{'+this._sModelName+">title}"});}else{Z=new O({title:'{'+this._sModelName+">title}"});if(W){Z.setTooltip(W);}}X=new k({icon:"sap-icon://sys-cancel",enabled:true,type:y.Transparent,press:d1,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:$.remove});this._assignColumnInfoForDeleteButton(X);Y=this.oContext.getPath();var f1=new c({src:{path:"favorite",model:this._sModelName,formatter:function(h1){return h1?"sap-icon://favorite":"sap-icon://unfavorite";}},tooltip:{path:'favorite',model:this._sModelName,formatter:function(h1){return this._oRb.getText(h1?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP");}.bind(this)},press:e1});f1.addStyleClass("sapUiFlVarMngmtFavColor");var g1=new d({cells:[f1,Z,new R({groupName:this.getId(),select:b1,selected:{path:Y+"/defaultVariant",model:this._sModelName,formatter:function(h1){return $.key===h1;}}}),new m({select:c1,selected:'{'+this._sModelName+">executeOnSelect}"}),new T({text:'{'+this._sModelName+">author}",textAlign:"Begin"}),X,new T({text:'{'+this._sModelName+">key}"})]});return g1;};Q.prototype._openManagementDialog=function(e){this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close();}this._suspendManagementTableBinding();this._clearDeletedItems();this._oSearchFieldOnMgmtDialog.setValue("");if(this._bDeleteOccured){this._bDeleteOccured=false;this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});}if(e){this.oManagementDialog.addStyleClass(e);}this.oManagementDialog.open();};Q.prototype._assignColumnInfoForDeleteButton=function(e){if(!this._oInvisibleDeleteColumnName){this._oInvisibleDeleteColumnName=new I({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")});this.oManagementDialog.addContent(this._oInvisibleDeleteColumnName);}if(this._oInvisibleDeleteColumnName){e.addAriaLabelledBy(this._oInvisibleDeleteColumnName);}};Q.prototype._handleManageDefaultVariantChange=function(e,U){var W=U.key;if(this.getShowFavorites()&&!U.favorite&&e){U.favorite=true;this._setFavoriteIcon(e.getParent().getCells()[Q.COLUMN_FAV_IDX],true);}this.setDefaultVariantKey(W);};Q.prototype._handleManageCancelPressed=function(){var e;var U;this._getDeletedItems().forEach(function(W){W.visible=true;});this._getItems().forEach(function(W){W.title=W.originalTitle;W.favorite=W.originalFavorite;W.executeOnSelection=W.originalExecuteOnSelection;});e=this.getOriginalDefaultVariantKey();if(e!==this.getDefaultVariantKey()){this.setDefaultVariantKey(e);}U=this.getModel(this._sModelName);if(U){U.checkUpdate();}};Q.prototype._handleManageFavoriteChanged=function(e,U){if((this.getDefaultVariantKey()===U.key)&&U.favorite){return;}U.favorite=!U.favorite;this._setFavoriteIcon(e,U.favorite);};Q.prototype._getRowForKey=function(e){var U=null;if(this.oManagementTable){this.oManagementTable.getItems().some(function(W){if(e===W.getCells()[0].getBindingContext(this._sModelName).getObject().key){U=W;}return U!==null;}.bind(this));}return U;};Q.prototype._handleManageDeletePressed=function(e){var U;var W=e.key;if(this.oManagementTable.getItems().length===1){return;}e.visible=false;this._addDeletedItem(e);if((W===this.getDefaultVariantKey())){this.setDefaultVariantKey(this.getStandardVariantKey());if(this.getShowFavorites()){var X=this._getItemByKey(this.getStandardVariantKey());if(X&&!X.favorite){var Y=this._getRowForKey(this.getStandardVariantKey());if(Y){X.favorite=true;this._setFavoriteIcon(Y.getCells()[Q.COLUMN_FAV_IDX],true);}}}}U=this.getModel(this._sModelName);if(U){U.checkUpdate();}this.oManagementCancel.focus();};Q.prototype._handleManageExecuteOnSelectionChanged=function(){};Q.prototype._handleManageTitleChanged=function(){};Q.prototype._handleManageSavePressed=function(){if(this._anyInErrorState(this.oManagementTable)){return;}this._getDeletedItems().some(function(e){if(e.key===this.getCurrentVariantKey()){var U=this.getStandardVariantKey();this.setModified(false);this.setCurrentVariantKey(U);this.fireEvent("select",{key:U});return true;}return false;}.bind(this));this.fireManage();this._resumeManagementTableBinding();this.oManagementDialog.close();};Q.prototype._resumeManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.resume();}}};Q.prototype._suspendManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.suspend();}}};Q.prototype._anyInErrorState=function(e){var U;var W;var X=false;if(e){U=e.getItems();U.some(function(Y){W=Y.getCells()[Q.COLUMN_NAME_IDX];if(W&&W.getValueState&&(W.getValueState()===M.Error)){X=true;}return X;});}return X;};Q.prototype._getFilters=function(e){var U=[];if(e){U.push(e);}U.push(this._getVisibleFilter());if(this.getShowFavorites()){U.push(this._getFilterFavorites());}return U;};Q.prototype._getVisibleFilter=function(){return new F({path:"visible",operator:a.EQ,value1:true});};Q.prototype._getFilterFavorites=function(){return new F({path:"favorite",operator:a.EQ,value1:true});};Q.prototype._verifyVariantNameConstraints=function(e,U){if(!e){return;}var W=e.getValue();W=W.trim();if(!this._checkIsDuplicate(W,U)){if(W===""){e.setValueState(M.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));}else if(W.indexOf('{')>-1){e.setValueState(M.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]));}else if(W.length>Q.MAX_NAME_LEN){e.setValueState(M.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[Q.MAX_NAME_LEN]));}else{e.setValueState(M.None);e.setValueStateText(null);}}else{e.setValueState(M.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"));}};Q.prototype._checkVariantNameConstraints=function(e,U){this._verifyVariantNameConstraints(e,U);if(this.oManagementDialog&&this.oManagementDialog.isOpen()){this._reCheckVariantNameConstraints();}};Q.prototype._reCheckVariantNameConstraints=function(){var e;var U=false;if(this.oManagementTable){e=this.oManagementTable.getItems();e.some(function(W){var X=W.getBindingContext(this._sModelName).getObject();if(X&&X.visible){var Y=W.getCells()[Q.COLUMN_NAME_IDX];if(Y&&Y.getValueState&&(Y.getValueState()===M.Error)){this._verifyVariantNameConstraints(Y,X.key);if(Y.getValueState()===M.Error){U=true;}}}return U;}.bind(this));}return U;};Q.prototype._checkIsDuplicate=function(e,U){if(this.oManagementDialog&&this.oManagementDialog.isOpen()){return this._checkIsDuplicateInManageTable(e,U);}return this._checkIsDuplicateInModel(e,U);};Q.prototype._checkIsDuplicateInModel=function(e,U){var W=false;var X=this._getItems();var Y=e.toLowerCase();X.some(function(Z){if(Z.title.toLowerCase()===Y){if(U&&(U===Z.key)){return false;}W=true;}return W;});return W;};Q.prototype._checkIsDuplicateInManageTable=function(e,U){var W;var X=false;var Y=e.toLowerCase();if(this.oManagementTable){W=this.oManagementTable.getItems();W.some(function(Z){var $;var _=Z.getBindingContext(this._sModelName).getObject();if(_&&_.visible){var a1=Z.getCells()[Q.COLUMN_NAME_IDX];if(a1&&(_.key!==U)){if(a1.isA("sap.m.Input")){$=a1.getValue().toLowerCase();}else{$=a1.getTitle().toLowerCase();}if($===Y){X=true;}}return X;}}.bind(this));}return X;};Q.prototype.exit=function(){var e;if(this.oVariantInvisibleText){this.oVariantInvisibleText.destroy(true);this.oVariantInvisibleText=undefined;}if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy();}this.oDefault=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy();}this.oExecuteOnSelect=undefined;this._oRb=undefined;this.oContext=undefined;this._oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantPopoverTrigger=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;e=this.getModel(Q.INNER_MODEL_NAME);if(e){e.destroy();}};return Q;});
