/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseListContent","./TableContentRenderer","sap/ui/integration/library","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/m/ObjectStatus","sap/m/Avatar","sap/ui/core/library","sap/m/library","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper","sap/ui/util/openWindow"],function(B,T,l,R,C,a,b,L,P,O,c,A,d,m,e,f,o){"use strict";var g=m.AvatarSize;var h=m.AvatarColor;var V=d.VerticalAlign;var i=m.ListSeparators;var k=m.ListType;var n=l.AreaType;var p=B.extend("sap.ui.integration.cards.TableContent",{metadata:{library:"sap.ui.integration"},renderer:T});p.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};p.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null;}var t=this.getAggregation("_content");if(!t){t=new R({id:this.getId()+"-Table",showSeparators:i.None});this.setAggregation("_content",t);}return t;};p.prototype.setConfiguration=function(j){B.prototype.setConfiguration.apply(this,arguments);if(!j){return this;}if(j.rows&&j.columns){this._setStaticColumns(j.rows,j.columns);return this;}if(j.row&&j.row.columns){this._setColumns(j.row);}return this;};p.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().row);};p.prototype._setColumns=function(r){var j=[],t=this._getTable(),q=r.columns;q.forEach(function(u){t.addColumn(new C({header:new b({text:u.title}),width:u.width,hAlign:u.hAlign,visible:u.visible}));j.push(this._createCell(u));}.bind(this));this._oItemTemplate=new a({cells:j,vAlign:V.Middle});this._oActions.setAreaType(n.ContentItem);this._oActions.attach(r,this);var s={template:this._oItemTemplate};this._filterHiddenNavigationItems(r,s);this._bindAggregationToControl("items",t,s);};p.prototype._setStaticColumns=function(r,q){var t=this._getTable();q.forEach(function(j){t.addColumn(new C({header:new b({text:j.title}),width:j.width,hAlign:j.hAlign}));});r.forEach(function(s){var I=new a({vAlign:V.Middle});if(s.cells&&Array.isArray(s.cells)){for(var j=0;j<s.cells.length;j++){I.addCell(this._createCell(s.cells[j]));}}if(s.actions&&Array.isArray(s.actions)){var u=s.actions[0];if(u.type===k.Navigation){I.setType(k.Navigation);}if(u.url){I.attachPress(function(){o(u.url,u.target||"_blank");});}}t.addItem(I);}.bind(this));this.fireEvent("_actionContentReady");};p.prototype._createCell=function(j){if(j.url){return new L({text:j.value,href:j.url,target:j.target||"_blank"});}if(j.identifier){var t;if(j.identifier.url){t=f.formattedProperty(j.identifier.url,function(v){if(typeof v==="string"){return true;}return false;});}var I=new O({title:j.value,titleActive:t});if(j.identifier.url){I.attachTitlePress(function(E){var S=E.getSource(),q=S.getBindingContext(),r,u,v;if(q){r=q.getPath();}u=e.resolveValue(j.identifier.url,S,r);v=e.resolveValue(j.identifier.target,S,r);if(u){o(u,v||"_blank");}});}return I;}if(j.state){return new c({text:j.value,state:j.state});}if(j.value){return new b({text:j.value});}if(j.icon){var s=f.formattedProperty(j.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));return new A({src:s,displayShape:j.icon.shape,displaySize:j.icon.size||g.XS,tooltip:j.icon.alt,initials:j.icon.text,backgroundColor:j.icon.backgroundColor||(j.icon.text?undefined:h.Transparent)}).addStyleClass("sapFCardIcon");}if(j.progressIndicator){return new P({percentValue:j.progressIndicator.percent,displayValue:j.progressIndicator.text,state:j.progressIndicator.state});}};p.prototype.getInnerList=function(){return this._getTable();};return p;});
