/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/core/IconPool","sap/base/util/merge","sap/ui/core/Core","sap/base/util/deepClone"],function(C,S,L,J,I,m,c,d){"use strict";var r=c.getLibraryResourceBundle("sap.ui.integration"),D;var e=C.extend("sap.ui.integration.designtime.editor.fields.viz.IconSelect",{metadata:{properties:{value:{type:"string",defaultValue:"sap-icon://accept"},editable:{type:"boolean",defaultValue:true},allowFile:{type:"boolean",defaultValue:true},allowNone:{type:"boolean",defaultValue:true}},aggregations:{_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},renderer:function(R,o){var s=o.getAggregation("_select");R.openStart("div");R.addClass("sapUiIntegrationIconSelect");if(s&&o.getWidth){R.addStyle("width",s.getWidth());}R.writeClasses();R.writeStyles();R.writeElementData(o);R.openEnd();R.renderControl(s);R.close("div");}});e.prototype._initIconModel=function(){var i=I.getIconNames();i=i.sort(function(a,b){return a.toLowerCase().localeCompare(b.toLowerCase());});var f=[];if(!D){i.filter(function(s){var t=I.getIconInfo(s).text||("-"+s).replace(/-(.)/ig,function(M,a){return" "+a.toUpperCase();}).substring(1);f.push({icon:"sap-icon://"+s,key:"sap-icon://"+s,text:t,tooltip:t,enabled:true});});f=[{icon:"",text:r.getText("CARDEDITOR_ICON_NONE"),tooltip:"",key:"empty",enabled:true},{icon:"sap-icon://upload",text:r.getText("CARDEDITOR_ICON_CHOOSE"),tooltip:"",key:"file",enabled:true},{icon:"sap-icon://download",text:r.getText("CARDEDITOR_ICON_SELECTED"),tooltip:"",key:"selected",enabled:false}].concat(f);D=d(f);}else{f=d(D);}this._oIconModel=new J(f);this._oIconModel.setSizeLimit(f.length);};e.prototype.init=function(){if(!this._oIconModel){this._initIconModel();}var i=new L({icon:"{iconlist>icon}",text:"{iconlist>text}",tooltip:"{iconlist>tooltip}",key:"{iconlist>key}",enabled:"{iconlist>enabled}"});this._oFileUpload=document.createElement("INPUT");this._oFileUpload.type="file";this._oFileUpload.accept=".png,.jpg,.jpeg,.svg";this._boundFileUploadChange=this._fileUploadChange.bind(this);this._oFileUpload.addEventListener("change",this._boundFileUploadChange);this._oSelect=new S({width:"100%",items:{path:"iconlist>/",template:i},change:function(E){var s=E.getSource(),a=E.getSource().getSelectedKey();if(a==="file"){s._customImage=null;this._oFileUpload.click();this._boundFocusBack=this._focusBack.bind(this);s.getDomRef("hiddenSelect").addEventListener("focus",this._boundFocusBack);}else{this.setValue(a);}}.bind(this)});this._oSelect.setModel(this._oIconModel,"iconlist");var o=this._oSelect.open;this._oSelect.open=function(){o&&o.apply(this,arguments);this.getPicker().addStyleClass("sapUiIntegrationIconSelectList");this.getPicker().setContentHeight("400px");};this._oSelect.addDelegate({onAfterRendering:function(){var a=this._oSelect.getDomRef("labelIcon");if(a){var s=this._oSelect._customImage;if(s){a.style.backgroundImage="url('"+s+"')";a.classList.add("sapMSelectListItemIconCustom");}else{a.style.backgroundImage="unset";a.classList.remove("sapMSelectListItemIconCustom");}}}.bind(this)});this._oSelect.addDelegate({onsappageup:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();this._oSelect.setSelectedIndex(s-50);}}.bind(this),onsappagedown:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();if(s<3){this._oSelect.setSelectedIndex(29);}else{this._oSelect.setSelectedIndex(s+50);}}}.bind(this),onsapup:function(){if(this._oSelect.isOpen()){var a=this.getAllowFile();var A=this.getAllowNone();var f=this._oIconModel.getProperty("/2/enabled");var s=this._oSelect.getSelectedIndex();if(s>11+2){this._oSelect.setSelectedIndex(s-11);}else if(s>=3){if(A&&!a){this._oSelect.setSelectedIndex(0);}else if(f){this._oSelect.setSelectedIndex(2);}else{this._oSelect.setSelectedIndex(3);}}}}.bind(this),onsapdown:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();if(s>1){this._oSelect.setSelectedIndex(s+11);}}}.bind(this),onsapleft:function(){if(this._oSelect.isOpen()){this._oSelect.onsapup.apply(this._oSelect,arguments);}}.bind(this),onsapright:function(){if(this._oSelect.isOpen()){this._oSelect.onsapdown.apply(this._oSelect,arguments);}}.bind(this)},true);this.setAggregation("_select",this._oSelect);};e.prototype._fileUploadChange=function(){var f=new window.FileReader();f.onload=function(){this.setValue(f.result);this._oSelect.invalidate();}.bind(this);if(this._oFileUpload.files.length===1){f.readAsDataURL(this._oFileUpload.files[0]);}};e.prototype._focusBack=function(){this._oSelect.getDomRef("hiddenSelect").removeEventListener("focus",this._boundFocusBack);setTimeout(function(){this.setValue(this.getValue());}.bind(this),150);};e.prototype.bindProperty=function(p,b){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var s=m({},b);this._oSelect.bindProperty("editable",s);}return this;};e.prototype.setValue=function(v){this.setProperty("value",v,true);if(v.indexOf("data:image/")===0){this._oSelect._customImage=v;this._oIconModel.setProperty("/2/enabled",true);this._oSelect.setSelectedKey("selected");}else{this._oSelect._customImage=null;this._oIconModel.setProperty("/2/enabled",false);this._oSelect.setSelectedKey(v);}this._oSelect.invalidate();return this;};e.prototype.setAllowFile=function(v){this.setProperty("allowFile",v,true);v=this.getAllowFile();this._oIconModel.setProperty("/1/enabled",v);return this;};e.prototype.setAllowNone=function(v){this.setProperty("allowNone",v,true);v=this.getAllowNone();this._oIconModel.setProperty("/0/enabled",v);return this;};return e;});
