//@ui5-bundle sap/ui/integration/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/integration/Designtime',["sap/ui/base/ManagedObject"],function(M){"use strict";
var D=M.extend("sap.ui.integration.Designtime",{
metadata:{library:"sap.ui.integration"},
constructor:function(s){M.apply(this);this.settings=s||(this.create&&this.create())||{};}
});
D.prototype.init=function(){this._oCard=null;};
D.prototype.exit=function(){this._oCard=null;};
D.prototype.onCardReady=function(c,i){this._oCard=c;this._oInternalCardInstance=i;};
D.prototype._readyPromise=function(c,i){this.onCardReady(c,i);return Promise.resolve();};
D.prototype.getCard=function(){return this._oCard;};
D.prototype.getSettings=function(){return this.settings;};
return D;});
sap.ui.predefine('sap/ui/integration/Extension',["sap/base/Log","sap/ui/base/ManagedObject"],function(L,M){"use strict";
var E=M.extend("sap.ui.integration.Extension",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},formatters:{type:"object"}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:'object'},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}}}});
E.prototype.init=function(){this._oCardInterface=null;this._oCard=null;};
E.prototype.exit=function(){this._oCardInterface=null;this._oCard=null;};
E.prototype.setActions=function(a){this.setProperty("actions",a);if(this._oCard){this._oCard._refreshActionsMenu();}};
E.prototype.setFormatters=function(f){this.setProperty("formatters",f);if(!this._oCard){return;}if(!this._oCard._bApplyManifest||this._oCard.getAggregation("_extension")!==this){L.error("Extension formatters must be set before the initialization of the card. Do this inside Extension#init().");}};
E.prototype.onCardReady=function(){};
E.prototype.getCard=function(){return this._oCardInterface;};
E.prototype._setCard=function(c,C){this._oCard=c;this._oCardInterface=C;};
return E;});
sap.ui.predefine('sap/ui/integration/Host',['sap/ui/thirdparty/jquery','sap/ui/core/Element'],function(q,E){"use strict";
var H=E.extend("sap.ui.integration.Host",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},resolveDestination:{type:"function",invalidate:false,parameters:{destinationName:{type:"string"}}}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:'object'},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}}}});
H.prototype.getDestination=function(d){var r=this.getResolveDestination(),R;if(typeof r!=="function"){return Promise.reject("Could not resolve destination '"+d+"'. There is no 'resolveDestination' callback function configured in the host.");}R=r(d);if(!R){return Promise.reject("Destination '"+d+"' could not be resolved by the host.");}if(R instanceof Promise){return R;}return Promise.resolve(R);};
H.prototype.getContextValue=function(p){if(!p){return Promise.resolve(null);}return Promise.resolve(null);};
H.prototype.getDestinations=function(){return Promise.resolve([]);};
H.prototype.getContexts=function(){return Promise.resolve({});};
return H;});
sap.ui.predefine('sap/ui/integration/bindingFeatures/DateRange',["sap/ui/core/date/UniversalDateUtils","sap/base/Log"],function(U,L){"use strict";var D={start:function(t,v){var r=this._getRange(t,v);if(!r){return null;}return r[0];},end:function(t,v){var r=this._getRange(t,v);if(!r){return null;}return r[1];},_getRange:function(t,v){var g=U.ranges[t];if(!g){L.error("The requested date range type '"+t+"' is not found","sap.ui.integration.widgets.Card");return null;}return g(v);}};return D;});
sap.ui.predefine('sap/ui/integration/cards/AdaptiveContent',["sap/ui/integration/library","sap/ui/core/library","sap/ui/dom/includeScript","sap/ui/integration/cards/BaseContent","sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/thirdparty/adaptivecards-templating","sap/ui/integration/thirdparty/markdown-it","sap/ui/integration/cards/adaptivecards/elements/UI5InputText","sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber","sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet","sap/ui/integration/cards/adaptivecards/elements/UI5InputTime","sap/ui/integration/cards/adaptivecards/elements/UI5InputDate","sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle","sap/ui/integration/cards/adaptivecards/overwrites/ActionRender","sap/ui/integration/cards/adaptivecards/elements/hostConfig","sap/m/VBox","sap/m/MessageStrip","sap/ui/core/HTML","sap/ui/core/Core","sap/ui/model/json/JSONModel","sap/base/Log","sap/ui/integration/util/LoadingProvider","sap/ui/Device"],function(l,c,i,B,A,a,M,U,b,d,e,f,g,h,H,V,j,k,C,J,L,m,D){"use strict";var n=c.MessageType;
var o=B.extend("sap.ui.integration.cards.AdaptiveContent",{
metadata:{library:"sap.ui.integration"},
renderer:{apiVersion:2,render:function(r,p){var P=B.getMetadata().getRenderer();return P.render.apply(this,arguments);}}
});
o.prototype.init=function(){this.setComponentsReady(false);this._bAdaptiveCardElementsReady=false;this._setupCardContent();this._setupAdaptiveCardDependency();this._loadDependencies();this._oLoadingProvider=new m();};
o.prototype.onAfterRendering=function(){this._renderMSCardContent(this._oCardTemplate||this._oCardConfig);};
o.prototype._setupCardContent=function(){var p=new j(this.getId()+"-message",{showCloseButton:true,visible:false}),q=new k(this.getId()+"content",{preferDOM:false,content:"<div>&nbsp;</div>"});p.addStyleClass("sapUiTinyMargin");this.setAggregation("_content",new V({items:[p,q]}));};
o.prototype.setConfiguration=function(p){this._oCardConfig=p;if(p&&p.request&&p.request.url){this._loadManifestFromUrl(p.request.url);return;}this._handleMarkDown();this._setupMSCardContent();};
o.prototype.getConfiguration=function(){return this._oCardConfig;};
o.prototype._handleMarkDown=function(){var t=this;A.AdaptiveCard.onProcessMarkdown=function(T,r){var p=t.getParent(),E=p&&p.getManifestEntry("/sap.card/configuration/enableMarkdown");if(E){r.outputHtml=new M().render(T);r.didProcess=true;return r;}};};
o.prototype._loadManifestFromUrl=function(u){var p=new J(),t=this;p.loadData(u).then(function(){t._oCardConfig=Object.assign(t._oCardConfig,p.getData());}).then(function(){t._handleMarkDown();t._setupMSCardContent();}).then(function(){p.destroy();p=null;}).catch(function(){L.error("No JSON file found on this URL. Please provide a correct path to the JSON-serialized card object model file.");});};
o.prototype._setupAdaptiveCardDependency=function(){this.adaptiveCardInstance=new A.AdaptiveCard();this._doMSCardsOverwrites();this._adjustHostConfig();this._handleActions();this._replaceElements();this._isRtl();};
o.prototype._doMSCardsOverwrites=function(){A.Action.prototype.render=h;};
o.prototype._adjustHostConfig=function(){this.adaptiveCardInstance.hostConfig=new A.HostConfig(H);};
o.prototype._isRtl=function(){this.adaptiveCardInstance.isRtl=function(){return C.getConfiguration().getRTL();};};
o.prototype._handleActions=function(){this.adaptiveCardInstance.onExecuteAction=function(p){var t,P,q;if(p instanceof A.OpenUrlAction){P={url:p.url};t=l.CardActionType.Navigation;}else if(p instanceof A.SubmitAction){P={data:p.data};t=l.CardActionType.Submit;}else{return;}q=this.getActions();if(q){q.fireAction(this,t,P);}}.bind(this);};
o.prototype.onActionSubmitStart=function(F){this.getParent().setBusy(true);};
o.prototype.onActionSubmitEnd=function(r,E){var R=C.getLibraryResourceBundle("sap.ui.integration"),s=E?R.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_ERROR"):R.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_SUCCESS"),p=E?n.Error:n.Success;this.showMessage(s,p);this.getParent().setBusy(false);};
o.prototype.showMessage=function(s,t){var p=this.getAggregation("_content").getItems()[0];p.applySettings({"type":t,"text":s,"visible":true});};
o.prototype._replaceElements=function(){A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Text");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Text",function(){return new U();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Number");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Number",function(){return new b();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.ChoiceSet");A.AdaptiveCard.elementTypeRegistry.registerType("Input.ChoiceSet",function(){return new d();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Time");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Time",function(){return new e();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Date");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Date",function(){return new f();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Toggle");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Toggle",function(){return new g();});};
o.prototype.setCardDataProvider=function(p){this._oCardDataProvider=p;};
o.prototype._setupMSCardContent=function(){var p=this._oCardConfig,q,r=this._oCardDataProvider;if(!this.adaptiveCardInstance||!p){return;}q=p.$data||p.data;if(!q&&!r){this._oCardTemplate=null;this._renderMSCardContent(p);return;}if(p.$data){q={"json":q};}this._setDataConfiguration(q);};
o.prototype.onDataChanged=function(){var p=this.getBindingContext().getPath(),q=this.getModel().getProperty(p);this._oCardTemplate=this._setTemplating(this._oCardConfig,q);this._oLoadingProvider.setLoading(false);this.invalidate();};
o.prototype._renderMSCardContent=function(p){var q=this.getAggregation("_content").getItems()[1].$(),I=!!this.isLoading();this.setBusy(I);this.getAggregation("_content").toggleStyleClass("sapFCardContentHidden",I);if(this.adaptiveCardInstance&&p&&q.length){this.adaptiveCardInstance.parse(p);q.html(this.adaptiveCardInstance.render());this._bAdaptiveCardElementsReady=true;this._fireCardReadyEvent();if(this.adaptiveCardInstance.renderedElement){this.adaptiveCardInstance.renderedElement.tabIndex=-1;}}};
o.prototype._fireCardReadyEvent=function(){if(this._bAdaptiveCardElementsReady&&this.getComponentsReady()){this._bReady=true;this.fireEvent("_ready");}};
o.prototype._setTemplating=function(t,p){var q=new a.Template(t),r=new a.EvaluationContext();r.$root=p;return q.expand(r);};
o.prototype._loadDependencies=function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");this._fireCardReadyEvent();return;}if(window.customElements){window.customElements.whenDefined("ui5-button").then(function(){if(!this.getComponentsReady()){this.setComponentsReady(true);this._fireCardReadyEvent();}}.bind(this));}setTimeout(function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");return;}i({id:"webcomponents-loader",url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/webcomponentsjs/webcomponents-loader.js")});}.bind(this));document.addEventListener("WebComponentsReady",function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");return;}if(D.browser.edge||D.browser.msie){i({id:"webcomponents-bundle-es5",url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.es5.js")});}else{i({id:"webcomponents-bundle",attributes:{type:"module"},url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.esm.js")});}this.setComponentsReady(true);this._fireCardReadyEvent();}.bind(this));};
o.prototype.setComponentsReady=function(v){this._bComponentsReady=v;return this;};
o.prototype.getComponentsReady=function(){return!!this._bComponentsReady;};
return o;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticalContent',["./AnalyticalContentRenderer","./BaseContent","sap/ui/integration/library","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/ui/core/Core","sap/ui/thirdparty/jquery"],function(A,B,l,a,L,C,q){"use strict";var V,F,b;var c={"Top":"top","Bottom":"bottom","Left":"left","Right":"right"};var d={"TopLeft":"topLeft","Center":"center"};var T={"Left":"left","Center":"center","Right":"right"};var e={"Line":"line","StackedColumn":"stacked_column","StackedBar":"stacked_bar","Donut":"donut"};var f=l.AreaType;
var g=B.extend("sap.ui.integration.cards.AnalyticalContent",{
metadata:{library:"sap.ui.integration"},
renderer:A
});
g.prototype.loadDependencies=function(o){return new Promise(function(r,h){C.loadLibrary("sap.viz",{async:true}).then(function(){sap.ui.require(["sap/viz/ui5/controls/VizFrame","sap/viz/ui5/controls/common/feeds/FeedItem","sap/viz/ui5/data/FlattenedDataset"],function(_,i,j){V=_;F=i;b=j;r();},function(E){h(E);});}).catch(function(){h("Analytical content type is not available with this distribution.");});});};
g.prototype._getVizPropertiesObject=function(o){var t=o.title,h=o.legend,p=o.plotArea;if(!o){return this;}var v={"title":{"style":{"fontWeight":"normal"},"layout":{"respectPlotPosition":false}},"legend":{},"legendGroup":{"layout":{}},"plotArea":{"window":{"start":"firstDataPoint","end":"lastDataPoint"}},"categoryAxis":{"title":{}},"valueAxis":{"title":{}},"interaction":{"noninteractiveMode":true}};if(t){v.title.text=t.text;v.title.visible=t.visible;v.title.alignment=T[t.alignment];}if(h){v.legend.visible=h.visible;v.legendGroup.layout.position=c[h.position];v.legendGroup.layout.alignment=d[h.alignment];}if(p){if(p.dataLabel){v.plotArea.dataLabel=p.dataLabel;}if(p.categoryAxisText){v.categoryAxis.title.visible=p.categoryAxisText.visible;}if(p.valueAxisText){v.valueAxis.title.visible=p.valueAxisText.visible;}}return v;};
g.prototype.onDataChanged=function(){this._createChart();};
g.prototype._createChart=function(){var o=this.getConfiguration();if(!o.chartType){L.error("ChartType is a mandatory property");return;}var r=a.resolveValue(o,this,"/");var D=[];if(o.dimensions){var h=[];for(var i=0;i<o.dimensions.length;i++){var j=o.dimensions[i];var n=r.dimensions[i].label;D.push(n);var k={name:n,value:j.value};h.push(k);}}var m=[];if(o.measures){var M=[];for(var i=0;i<o.measures.length;i++){var p=o.measures[i];var n=r.measures[i].label;m.push(n);var s={name:n,value:p.value};M.push(s);}}var t=new b({measures:M,dimensions:h,data:{path:this.getBindingContext().getPath()}});var u=new V({uiConfig:{applicationSet:'fiori'},height:"100%",width:"100%",vizType:e[o.chartType],dataset:t,legendVisible:o.legend,feeds:[new F({uid:o.measureAxis,type:'Measure',values:m}),new F({uid:o.dimensionAxis,type:'Dimension',values:D})]});var v=this._getVizPropertiesObject(r);u.setVizProperties(v);this._oActions.setAreaType(f.Content);this._oActions.attach(o,this);this.setAggregation("_content",u);};
return g;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticalContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var A=B.extend("sap.ui.integration.cards.AnalyticalContentRenderer");
A.getMinHeight=function(c,C){var M="14rem";return M;};
return A;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticsCloudContent',["./AnalyticsCloudContentRenderer","./BaseContent","sap/ui/integration/library","sap/ui/core/HTML","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/ui/dom/includeScript"],function(A,B,l,H,a,L,i){"use strict";var b=l.AreaType;
var c=B.extend("sap.ui.integration.cards.AnalyticsCloudContent",{
metadata:{library:"sap.ui.integration"},
renderer:A
});
c.prototype.init=function(){B.prototype.init.apply(this,arguments);var I=this.getId()+"-highchartContainer";this._oHighchartContainer=new H(I,{content:"<div id="+I+" style='height:100%; width:100%'></div>"});this.setAggregation("_content",this._oHighchartContainer);this.fireEvent("_actionContentReady");};
c.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oHighchart){this._oHighchart.destroy();this._oHighchart=null;}if(this._oHighchartContainer){this._oHighchartContainer.destroy();this._oHighchartContainer=null;}};
c.prototype.loadDependencies=function(){return this._loadHighcharts();};
c.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);this._oActions.setAreaType(b.Content);this._oActions.attach(C,this);};
c.prototype.onAfterRendering=function(){this._createHighchart();};
c.prototype._loadHighcharts=function(){var C=this.getCardInstance(),d=c.SAC_DESTINATION_KEY,p=C.resolveDestination(d);return p.then(function(u){return c.loadHighcharts(u);},function(r){return Promise.reject("Destination with key '"+d+"' is required for AnalyticsCloud card. It could not be resolved. Reason: '"+r+"'");});};
c.prototype._createHighchart=function(){var C=this.getCardInstance(),o=this.getConfiguration(),d=this.getBindingContext(),p,e;if(!C.isReady()){C.attachEventOnce("_ready",this._createHighchart,this);return;}if(!window.Highcharts){this._handleError("There was a problem with loading Highcharts library. Could not initialize AnalyticsCloud card content.");return;}if(d){p=d.getPath();}e=a.resolveValue(o.options,this,p);this._oHighchart=new window.Highcharts.Chart(this._oHighchartContainer.getId(),e);};
c.SAC_DESTINATION_KEY="sac";c.SAC_FIREFLY_SERVICE_PATH="/firefly-service";c.HIGHCHART_MODULES={"highcharts/highstock":{amd:true,exports:'Highcharts'},"highcharts/highcharts-more":{deps:["highcharts/highstock"]},"highcharts/solid-gauge":{deps:["highcharts/highstock"]},"highcharts/histogram-bellcurve":{deps:["highcharts/highstock"]},"highcharts/no-data-to-display":{deps:["highcharts/highstock"]},"highcharts/wordcloud":{deps:["highcharts/highstock"]},"highcharts/variable-pie":{deps:["highcharts/highstock"]},"highcharts/heatmap":{deps:["highcharts/highstock"]},"highcharts/treemap":{deps:["highcharts/highstock"]},"highcharts/variwide":{deps:["highcharts/highstock"]},"highcharts/pattern-fill":{deps:["highcharts/highstock"]},"highcharts/highcharts-3d":{deps:["highcharts/highstock"]},"highcharts/grouped-categories":{deps:["highcharts/highstock"]}};
c.loadHighcharts=function(s){var S=s.trim().replace(/\/$/,""),f=S+this.SAC_FIREFLY_SERVICE_PATH,I=this._isHighchartsIncluded(f),d=this._isHighchartsIncludedByThirdParty();if(I){return this._pLoadModules;}if(d){return Promise.resolve();}this._sIncludedFrom=f;this._pLoadModules=this._loadModules(f);return this._pLoadModules;};
c._isHighchartsIncluded=function(s){var I=this._sIncludedFrom;if(I&&I===s){return true;}if(I&&I!==s){L.warning("Highcharts library is already included from '"+I+"'. The included version will be used and will not load from '"+s+"'","sap.ui.integration.widgets.Card#AnalyticsCloud");return true;}return false;};
c._isHighchartsIncludedByThirdParty=function(){if(window.Highcharts){L.warning("Highcharts library is already included on the page. The included version will be used and will not load another one.","sap.ui.integration.widgets.Card#AnalyticsCloud");return true;}return false;};
c._loadModules=function(s){var S=this.HIGHCHART_MODULES,m=Object.getOwnPropertyNames(S);sap.ui.loader.config({paths:{"highcharts":s+"/highcharts"},async:true,shim:S});return this._require(m).catch(function(){return Promise.reject("There was a problem with loading of the Highcharts library files.");});};
c._require=function(m){return new Promise(function(r,R){sap.ui.require(m,function(){r(arguments);},function(e){R(e);});});};
return c;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticsCloudContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var A=B.extend("sap.ui.integration.cards.AnalyticsCloudContentRenderer");
A.getMinHeight=function(c,C){var M="14rem";return M;};
return A;});
sap.ui.predefine('sap/ui/integration/cards/BaseContent',["./BaseContentRenderer","sap/ui/core/Core","sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/base/ManagedObjectObserver","sap/ui/integration/util/LoadingProvider"],function(B,C,a,J,M,L){"use strict";
var b=a.extend("sap.ui.integration.cards.BaseContent",{
metadata:{library:"sap.ui.integration",aggregations:{_content:{multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{press:{}}},
renderer:B
});
b.prototype.init=function(){this._iWaitingEventsCount=0;this._bReady=false;this._mObservers={};this._awaitEvent("_dataReady");this._awaitEvent("_actionContentReady");this._oLoadingProvider=new L();};
b.prototype.ontap=function(e){if(!e.isMarked()){this.firePress({});}};
b.prototype.exit=function(){this._iWaitingEventsCount=0;if(this._mObservers){Object.keys(this._mObservers).forEach(function(k){this._mObservers[k].disconnect();delete this._mObservers[k];},this);}this._oServiceManager=null;this._oDataProviderFactory=null;this._oIconFormatter=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}if(this._oLoadingPlaceholder){this._oLoadingPlaceholder.destroy();this._oLoadingPlaceholder=null;}};
b.prototype.loadDependencies=function(c){return Promise.resolve();};
b.prototype.getActions=function(){return this._oActions;};
b.prototype.setActions=function(A){this._oActions=A;};
b.prototype._awaitEvent=function(e){this._iWaitingEventsCount++;this.attachEventOnce(e,function(){this._iWaitingEventsCount--;if(this._iWaitingEventsCount===0){this._bReady=true;this.fireEvent("_ready");}});};
b.prototype.setConfiguration=function(c,t){this._oConfiguration=c;if(!c){return this;}this._oLoadingPlaceholder=this._oLoadingProvider.createContentPlaceholder(c,t);this._setDataConfiguration(c.data);return this;};
b.prototype.getConfiguration=function(){return this._oConfiguration;};
b.prototype._setDataConfiguration=function(d){if(!d){this.fireEvent("_dataReady");return;}this.bindObject(d.path||"/");if(this._oDataProvider){this._oDataProvider.destroy();}if(this._oDataProviderFactory){this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);}if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.onDataChanged();this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
b.prototype.destroyPlaceholder=function(){var c=this.getAggregation("_content");if(c){c.removeStyleClass("sapFCardContentHidden");}if(this._oLoadingPlaceholder){this._oLoadingPlaceholder.destroy();this._oLoadingPlaceholder=null;}};
b.prototype.onDataChanged=function(){};
function _(A,c,o){var d=this.getBindingContext(),e=c.getAggregation(A);if(d){o.path=o.path||d.getPath();c.bindAggregation(A,o);if(this.getModel("parameters")&&e){this.getModel("parameters").setProperty("/visibleItems",e.length);}if(!this._mObservers[A]){this._mObservers[A]=new M(function(f){if(f.name===A&&(f.mutation==="insert"||f.mutation==="remove")){var e=c.getAggregation(A);var l=e?e.length:0;if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",l);}}}.bind(this));this._mObservers[A].observe(c,{aggregations:[A]});}}}
b.prototype._bindAggregationToControl=function(A,c,o){var d=A&&typeof A==="string";var e=o&&typeof o==="object";if(!d||!c||!e){return;}if(this.getBindingContext()){_.apply(this,arguments);}else{c.attachModelContextChange(_.bind(this,A,c,o));}};
b.prototype.isReady=function(){return this._bReady;};
b.prototype._updateModel=function(d){this.getModel().setData(d);};
b.prototype._handleError=function(l){this.fireEvent("_error",{logMessage:l});};
b.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
b.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
b.prototype.setIconFormatter=function(i){this._oIconFormatter=i;return this;};
b.prototype.isLoading=function(){var l=this._oLoadingProvider,c=this.getCardInstance();return!l.getDataProviderJSON()&&(l.getLoadingState()||(c&&c.isLoading()));};
b.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");a.prototype.attachEvent.apply(this,m);this.invalidate();return this;};
b.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");a.prototype.detachEvent.apply(this,m);this.invalidate();return this;};
b.prototype.onActionSubmitStart=function(f){};
b.prototype.onActionSubmitEnd=function(r,e){};
b.prototype.onDataRequested=function(){if(this._oLoadingProvider){this._oLoadingProvider.createLoadingState(this._oDataProvider);}};
b.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.destroyPlaceholder();this._oLoadingProvider.setLoading(false);};
b.prototype.getCardInstance=function(){return C.byId(this.getCard());};
return b;});
sap.ui.predefine('sap/ui/integration/cards/BaseContentRenderer',["sap/ui/core/Renderer"],function(R){"use strict";
var B=R.extend("sap.ui.integration.cards.BaseContentRenderer",{apiVersion:2});
B.DEFAULT_MIN_HEIGHT="5rem";
B.render=function(r,c){var C="sapFCard",n=c.getMetadata().getName(),t=n.slice(n.lastIndexOf(".")+1),o=c.getParent(),i=o&&o.isA("sap.f.ICard");C+=t;r.openStart("div",c).class(C).class("sapFCardBaseContent");if(c.hasListeners("press")){r.class("sapFCardClickable");}if(i&&o.getHeight()==="auto"){var h=this.getMinHeight(c.getConfiguration(),c);r.style("min-height",h);}r.openEnd();if(t!=="AdaptiveContent"&&i&&c.isLoading()){r.renderControl(c._oLoadingPlaceholder);if(t!=="AnalyticalContent"&&t!=="TimelineContent"){this.hideContent(c);}}this.renderContent(r,c);r.close("div");};
B.renderContent=function(r,c){r.renderControl(c.getAggregation("_content"));};
B.hideContent=function(c){if(c.isLoading()){c.getAggregation("_content").addStyleClass("sapFCardContentHidden");}};
B.getMinHeight=function(c,C){return this.DEFAULT_MIN_HEIGHT;};
B.isCompact=function(c){var r=c,p=c.getParent();if(!c.getDomRef()&&p&&p.isA("sap.f.ICard")){r=p;}return r.$().closest(".sapUiSizeCompact").hasClass("sapUiSizeCompact");};
return B;});
sap.ui.predefine('sap/ui/integration/cards/BaseListContent',["sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingResolver","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/Log"],function(B,a,F,b,L){"use strict";
var c=B.extend("sap.ui.integration.cards.BaseListContent",{
metadata:{library:"sap.ui.integration"},
renderer:{}
});
c.prototype.setConfiguration=function(C,t){if(!C){return this;}var l=this.getInnerList(),m=C.maxItems;if(l&&m){l.setGrowing(true);l.setGrowingThreshold(parseInt(m));l.addStyleClass("sapFCardMaxItems");}return B.prototype.setConfiguration.apply(this,arguments);};
c.prototype.getInnerList=function(){return null;};
c.prototype._filterHiddenNavigationItems=function(i,o){if(!i.actions){return;}var A=i.actions[0];if(!(A&&A.service&&A.type==="Navigation")){return;}var f=new F("_card_item_hidden",b.EQ,false);this._awaitEvent("_filterNavItemsReady");o.filters=[f];};
c.prototype._checkHiddenNavigationItems=function(i){if(!i.actions){return;}var m=this.getModel(),p=this.getBindingContext().getPath(),I=m.getProperty(p),A=i.actions[0],s=p.trim().replace(/\/$/,""),P=[],d;if(!(A&&A.service&&A.type==="Navigation")){return;}if(A.service==="object"){d=A.service.name;}else{d=A.service;}I.forEach(function(o,e){var f=a.resolveValue(A.parameters,this,s+"/"+e);if(o._card_item_hidden!==undefined){return;}o._card_item_hidden=false;P.push(this._oServiceManager.getService(d).then(function(n){var m=this.getModel();if(!n.hidden){return Promise.resolve();}return n.hidden({parameters:f}).then(function(h){o._card_item_hidden=h;m.checkUpdate(true);});}.bind(this)).catch(function(M){L.error(M);}));}.bind(this));m.checkUpdate(true);Promise.all(P).then(function(){this.fireEvent("_filterNavItemsReady");}.bind(this));};
return c;});
sap.ui.predefine('sap/ui/integration/cards/CalendarContent',["./CalendarContentRenderer",'sap/ui/core/ResizeHandler',"sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/f/CalendarInCard","sap/f/PlanningCalendarInCardLegend","sap/m/library","sap/m/Button","sap/m/FlexBox",'sap/ui/core/format/DateFormat',"sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/unified/CalendarAppointment","sap/ui/unified/DateTypeRange","sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarLegendItem"],function(C,R,l,B,a,b,c,P,L,d,F,D,e,f,g,h,U,j){"use strict";var A=l.AreaType;
var k=B.extend("sap.ui.integration.cards.CalendarContent",{
renderer:C,
metadata:{library:"sap.ui.integration",properties:{visibleAppointmentsCount:{type:"int",group:"Data",defaultValue:2},noAppointmentsText:{type:"string",group:"Misc",defaultValue:null}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"}}}
});
k.prototype._createCardContent=function(){this._oCalendar=new c(this.getId()+"-navigation",{select:function(E){var s=E.getSource().getSelectedDates()[0].getStartDate();this._setParameters(E,E.getParameter("startDate"));this._refreshVisibleAppointments(s);this.invalidate();}.bind(this)});this._oLegend=new P(this.getId()+"-legend",{columnWidth:"7.5rem",standardItems:[]});this._oContent=new F(this.getId()+"-wrapper",{items:[this._oCalendar,this._oLegend]});this.setAggregation("_content",this._oContent);this._oFormatAria=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+_.call(this).getTimePattern("medium")});};
k.prototype.init=function(){this._aVisibleAppointments=[];B.prototype.init.apply(this,arguments);this._createCardContent();this.fireEvent("_actionContentReady");};
k.prototype.exit=function(){if(this._sTwoColumnsResizeListener){R.deregister(this._sTwoColumnsResizeListener);this._sTwoColumnsResizeListener=undefined;}B.prototype.exit.apply(this,arguments);if(this._oAppointmentTemplate){this._oAppointmentTemplate.destroy();this._oAppointmentTemplate=null;}if(this._oSpecialDateTemplate){this._oSpecialDateTemplate.destroy();this._oSpecialDateTemplate=null;}if(this._oCalendarLegendItemTemplate){this._oCalendarLegendItemTemplate.destroy();this._oCalendarLegendItemTemplate=null;}if(this._oAppointmentLegendItemTemplate){this._oAppointmentLegendItemTemplate.destroy();this._oAppointmentLegendItemTemplate=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
k.prototype.onDataChanged=function(){this._setParameters();};
k.prototype.onBeforeRendering=function(){var i=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();this._refreshVisibleAppointments(i);this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);};
k.prototype.onAfterRendering=function(){B.prototype.onAfterRendering.call(this,arguments);if(!this._sTwoColumnsResizeListener){this._sTwoColumnsResizeListener=R.register(this,this.resizeHandler);this.resizeHandler({control:this,target:this.getDomRef()});}};
k.prototype.resizeHandler=function(E){E.control.toggleStyleClass("sapMPCInCardTwoColumns",E.target.getBoundingClientRect().width>576);};
k.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.item){this._addItem(o.item);}if(o.specialDate){this._addSpecialDate(o.specialDate);}if(o.legendItem){this._addLegendItem(o.legendItem);}if(o.date){this._addDate(o.date);}if(o.maxItems){this._addMaxItems(o.maxItems);}if(o.maxLegendItems){this._addMaxLegendItems(o.maxLegendItems);}if(o.noItemsText){this._addNoItemsText(o.noItemsText);}if(o.moreItems&&o.moreItems.actions){this._oActions.setAreaType(A.Content);this._oActions.attach(o.moreItems,this._getMoreButton());}return this;};
k.prototype._setParameters=function(E,o){var i=this.getConfiguration&&this.getConfiguration(),I=i&&i.item&&i.item.path,n,s,p,M,q,r=D.getDateTimeInstance();if(o){n=o;}else if(this._oCalendar.getSelectedDates().length){n=this._oCalendar.getSelectedDates()[0].getStartDate();}else{n=this._oCalendar.getStartDate();}s=new Date(n.getFullYear(),n.getMonth(),n.getDate());p=new Date(n.getFullYear(),n.getMonth(),n.getDate());p.setDate(p.getDate()+1);q=I?this.getModel().getProperty(I).filter(function(t){var S=r.parse(t.start).getTime(),u=r.parse(t.end).getTime();if((S>=s.getTime()&&S<p.getTime())||(u>=s.getTime()&&u<p.getTime())||(S<=s.getTime()&&u>p.getTime())){return t;}}):[];this._iAllItems=q.length;if(i&&typeof i.maxItems==="object"){M=i&&this.getConfiguration().maxItems&&"/"+this.getConfiguration().maxItems.binding.getPath();this._iMaxItems=this.getModel().getProperty(M);}else{this._iMaxItems=i&&this.getConfiguration().maxItems;}this._iVisibleItems=Math.min(this._iMaxItems,this._iAllItems);if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);}};
k.prototype._refreshVisibleAppointments=function(s){this._aVisibleAppointments=this._calculateVisibleAppointments(this.getAppointments(),s);};
k.prototype._calculateVisibleAppointments=function(i,s){var I=this._isAppointmentInSelectedDate(s);var t=function(o,n){var E=o.getEndDate(),N=new Date();if(s.getDate()===N.getDate()&&s.getMonth()===N.getMonth()&&s.getFullYear()===N.getFullYear()){return this._iAllItems-n<this._iVisibleItems||E.getTime()>N.getTime();}return true;};var r=i.filter(I,this).sort(this._sortByStartHourCB).filter(t,this).slice(0,this._iVisibleItems);return r;};
k.prototype._sortByStartHourCB=function(o,i){return o.getStartDate().getTime()-i.getStartDate().getTime()||i.getEndDate().getTime()-o.getEndDate().getTime();};
k.prototype._isAppointmentInSelectedDate=function(s){return function(o){var i=o.getStartDate().getTime(),n=o.getEndDate().getTime(),S=s.getTime(),p=U.getInstance(new Date(s.getTime())),q,r,t,E;p.setDate(p.getDate()+1);q=p.getTime();r=i<S&&n>q;t=i>=S&&i<q;E=n>S&&n<=q;return r||t||E;};};
k.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};
k.prototype.formatDate=function(t){var o=D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).parse(t);if(!o){o=D.getInstance({pattern:"yyyy-MM-dd"}).parse(t);}return o;};
k.prototype._addItem=function(i){var n={title:i.template.title,text:i.template.text,type:i.template.type},o;if(i.template.startDate){n.startDate=a.formattedProperty(i.template.startDate,this.formatDate);}if(i.template.endDate){n.endDate=a.formattedProperty(i.template.endDate,this.formatDate);}if(i.template.icon&&i.template.icon.src){n.icon=a.formattedProperty(i.template.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));}this._oAppointmentTemplate=new g(n);o={path:i.path,template:this._oAppointmentTemplate};this._bindAggregationToControl("appointments",this,o);};
k.prototype._addSpecialDate=function(s){var S=s.template,o;if(S.startDate){S.startDate=a.formattedProperty(S.startDate,this.formatDate);}if(S.endDate){S.endDate=a.formattedProperty(S.endDate,this.formatDate);}this._oSpecialDateTemplate=new h(S);o={path:s.path,template:this._oSpecialDateTemplate};this._bindAggregationToControl("specialDates",this._oCalendar,o);};
k.prototype._addLegendItem=function(i){var n={text:i.template.text,type:i.template.type},o={text:i.template.text,type:i.template.type},p,q;this._oCalendarLegendItemTemplate=new j(n);p={path:i.path,template:this._oCalendarLegendItemTemplate,filters:new e({path:"category",operator:f.Contains,value1:"calendar"})};this._bindAggregationToControl("items",this._oLegend,p);this._oAppointmentLegendItemTemplate=new j(o);q={path:i.path,template:this._oAppointmentLegendItemTemplate,filters:new e({path:"category",operator:f.Contains,value1:"appointment"})};this._bindAggregationToControl("appointmentItems",this._oLegend,q);};
k.prototype._addDate=function(t){if(b.isBindingInfo(t)){if(!t){return;}var o=new h();o.bindProperty("startDate",a.formattedProperty(t,this.formatDate));this._oCalendar.addSelectedDate(o);}else{this._oCalendar.addSelectedDate(new h({startDate:this.formatDate(t)}));}};
k.prototype._addMaxItems=function(M){if(b.isBindingInfo(M)){M&&this.bindProperty("visibleAppointmentsCount",M);}else{this.setVisibleAppointmentsCount(M);}};
k.prototype._addMaxLegendItems=function(M){if(b.isBindingInfo(M)){M&&this._oLegend.bindProperty("visibleLegendItemsCount",M);}else{this._oLegend.setVisibleLegendItemsCount(M);}};
k.prototype._addNoItemsText=function(n){if(b.isBindingInfo(n)){n&&this.bindProperty("noAppointmentsText",n);}else{this.setNoAppointmentsText(n);}};
k.prototype._getMoreButton=function(){if(!this._oMoreAppsButton){this._oMoreAppsButton=new d({text:"More"});}return this._oMoreAppsButton;};
k.prototype._bNeedForMoreButton=function(){return this._iAllItems>this.getVisibleAppointmentsCount();};
k.prototype._getCurrentAppointment=function(){var n=this._getVisibleAppointments(),N=new Date(),o,s,E,i,S=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();if(S.getDate()===N.getDate()&&S.getMonth()===N.getMonth()&&S.getFullYear()===N.getFullYear()){for(i=n.length-1;i>=0;i--){o=n[i];s=o.getStartDate().getTime();E=o.getEndDate().getTime();if(N.getTime()>s&&N.getTime()<E){return o;}}}};
function _(){if(!this._oLocaleData){var s=m.call(this);var o=new sap.ui.core.Locale(s);this._oLocaleData=sap.ui.core.LocaleData.getInstance(o);}return this._oLocaleData;}
function m(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}
return k;});
sap.ui.predefine('sap/ui/integration/cards/CalendarContentRenderer',["./BaseContentRenderer","sap/ui/core/InvisibleText","sap/ui/unified/library","sap/ui/unified/CalendarLegendRenderer"],function(B,I,u,C){"use strict";var a=u.CalendarDayType;
var b=B.extend("sap.ui.integration.cards.CalendarContentRenderer",{apiVersion:2});
b.renderContent=function(r,c){var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.integration");r.openStart("div","card-group");r.attr("role","group");r.attr("aria-label",R.getText("CARDS_CALENDAR"));r.class("sapFCalCard");r.openEnd();r.openStart("div","card-layout");r.class("sapFCalCardLayout");r.openEnd();r.openStart("div","left-side");r.class("sapFCalCardLeftSide");r.openEnd();r.renderControl(c._oCalendar);r.openStart("div","card-legend");r.attr("aria-label",R.getText("CARDS_CALENDAR_LEGEND"));r.openEnd();r.renderControl(c._oLegend);r.close("div");r.close("div");r.openStart("div","right-side");r.class("sapFCalCardRightSide");r.openEnd();b.renderAppointments(r,c);if(c._bNeedForMoreButton()){r.renderControl(c._getMoreButton());}r.close("div");r.close("div");r.close("div");};
b.renderAppointments=function(r,c){var v=c._getVisibleAppointments(),o=c._getCurrentAppointment(),R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.integration");r.openStart("div","appointments-list");r.attr("role","list");r.attr("aria-label",R.getText("CARDS_CALENDAR_APPOINTMENTS"));r.class("sapFCalCardAppList");r.openEnd();if(!v.length){r.openStart("div");r.class("sapFCalCardNoItemsText");r.openEnd();r.text(c.getNoAppointmentsText());r.close("div");}v.forEach(function(A){b.renderAppointment(r,c,A,o==A);});r.close("div");};
b.renderAppointment=function(r,c,A,i){var s=c._oCalendar.getSelectedDates()[0].getStartDate();r.openStart("div");r.attr("role","listitem");r.class("sapUiCalendarAppContainer");if(i){r.class("sapUiCalendarAppCurrent");}r.accessibilityState(A,b.getAccProps(A));r.openEnd();r.openStart("div");r.class("sapUiCalendarAppContainerLeft");r.openEnd();r.openStart("div");r.class("sapUiCalendarAppStart");r.openEnd();r.text(A._getDateRangeIntersectionText(s).start);r.close("div");r.openStart("div");r.class("sapUiCalendarAppEnd");r.openEnd();r.text(A._getDateRangeIntersectionText(s).end);r.close("div");r.close("div");r.openStart("div");r.class("sapUiCalendarAppContainerRight");r.openEnd();this._renderAppointment(r,c,A,s);r.close("div");b.renderAdditionalAriaLabel(r,c,A);r.close("div");};
b._renderAppointment=function(r,c,A,s){var i=A.getId();var t=A.getTitle();var T=A.getText();var d=A.getType();var e=A.getIcon();var S=!t||!T;r.openStart("div",A);r.class("sapUiCalendarApp");if(d&&d!=a.None){r.class("sapUiCalendarApp"+d);}if(S){r.class("sapUiCalendarAppOneLine");}r.openEnd();r.openStart("div");r.class("sapUiCalendarAppCont");r.openEnd();if(e){var f=["sapUiCalendarAppIcon"];var m={};m["id"]=i+"-Icon";m["title"]=null;r.icon(e,f,m);}r.openStart("div");r.class("sapUiCalendarAppTitleWrapper");r.openEnd();if(t){r.openStart("span",i+"-Title");r.class("sapUiCalendarAppTitle");r.openEnd();r.text(t);r.close("span");}if(T){r.openStart("span",i+"-Text");r.class("sapUiCalendarAppText");r.openEnd();r.text(T);r.close("span");}r.close("div");r.close("div");r.close("div");};
b.renderAdditionalAriaLabel=function(r,c,A){var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),f=c._oFormatAria,t=A.getType(),l=c._oLegend?c._oLegend.getAppointmentItems():[];var s=R.getText("CALENDAR_START_TIME")+": "+f.format(A.getStartDate());s=s+"; "+R.getText("CALENDAR_END_TIME")+": "+f.format(A.getEndDate());if(t&&t!=a.None){s=s+"; "+this.getAriaTextForType(t,l);}r.openStart("span",A.getId()+"-Descr");r.class("sapUiInvisibleText");r.openEnd();r.text(s);r.close("span");};
b.getAriaTextForType=function(t,l){var T,s,o,i;if(l&&l.length){for(var i=0;i<l.length;i++){o=l[i];if(o.getType()===t){T=o.getText();break;}}}if(!T){s=C.getTypeAriaText(t);if(s){T=s.getText();}}return T;};
b.getAccProps=function(A){var i=A.getId();var m={labelledby:{value:I.getStaticId("sap.ui.unified","APPOINTMENT")+" "+i+"-Descr",append:true},selected:null};if(A.getTitle()){m["labelledby"].value=m["labelledby"].value+" "+i+"-Title";}if(A.getText()){m["labelledby"].value=m["labelledby"].value+" "+i+"-Text";}return m;};
return b;});
sap.ui.predefine('sap/ui/integration/cards/ComponentContent',["sap/ui/integration/cards/BaseContent","sap/ui/core/ComponentContainer"],function(B,C){"use strict";
var a=B.extend("sap.ui.integration.cards.ComponentContent",{
metadata:{library:"sap.ui.integration"},
renderer:{}
});
a.prototype.setConfiguration=function(c){B.prototype.setConfiguration.apply(this,arguments);if(!c){return;}var o=new C({manifest:c,async:true,componentCreated:function(e){var b=e.getParameter("component"),d=this.getParent();if(b.onCardReady){b.onCardReady(d);}this.fireEvent("_actionContentReady");this.fireEvent("_updated");}.bind(this),componentFailed:function(){this.fireEvent("_actionContentReady");this._handleError("Card content failed to create component");}.bind(this)});this.setAggregation("_content",o);};
return a;});
sap.ui.predefine('sap/ui/integration/cards/Filter',["sap/ui/core/Control","sap/ui/core/Core","sap/base/Log","sap/ui/core/Icon","sap/m/HBox","sap/m/Text","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/integration/util/LoadingProvider"],function(C,a,L,I,H,T,S,b,J,c){"use strict";
var F=C.extend("sap.ui.integration.cards.Filter",{
metadata:{properties:{key:{type:"string",defaultValue:""},config:{type:"object",defaultValue:"null"},value:{type:"string",defaultValue:""}},aggregations:{_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},
renderer:{apiVersion:2,render:function(r,f){var l=f.isLoading();r.openStart("div",f).class("sapFCardFilter");if(l){r.class("sapFCardFilterLoading");}r.openEnd();if(f._hasError()){r.renderControl(f._getErrorMessage());}else{r.renderControl(f._getSelect());}r.close("div");}}
});
F.prototype.init=function(){this._oLoadingProvider=new c();this.attachEventOnce("_dataReady",function(){this.fireEvent("_ready");});};
F.prototype.exit=function(){if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}};
F.prototype.isLoading=function(){return!this._oLoadingProvider.getDataProviderJSON()&&this._oLoadingProvider.getLoadingState();};
F.prototype._getSelect=function(){var o=this.getAggregation("_select");if(!o){o=this._createSelect();this.setAggregation("_select",o);}return o;};
F.prototype._hasError=function(){return!!this._bError;};
F.prototype._getErrorMessage=function(){var m="Unable to load the filter.";return new H({justifyContent:"Center",alignItems:"Center",items:[new I({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:m})]});};
F.prototype._handleError=function(l){L.error(l);this._bError=true;this.invalidate();};
F.prototype._onDataRequestComplete=function(){this.fireEvent("_dataReady");this._oLoadingProvider.setLoading(false);this.invalidate();};
F.prototype._onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};
F.prototype._updateModel=function(d){var s=this._getSelect(),m=this.getModel();m.setData(d);s.setSelectedKey(this.getValue());this._updateSelected(s.getSelectedItem());};
F.prototype._setDataConfiguration=function(d){if(!d){this.fireEvent("_dataReady");return;}if(this._oDataProvider){this._oDataProvider.destroy();}var o=a.byId(this.getCard());this._oDataProvider=o._oDataProviderFactory.create(d,null,true);this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this._onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this._onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this._onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();};
F.prototype._updateSelected=function(s){var f=this.getModel("filters"),d=this.getKey();f.setProperty("/"+d,{"value":s.getKey(),"selectedItem":{"title":s.getText(),"key":s.getKey()}});};
F.prototype._createSelect=function(){var s=new S(),i,d,e="/",o=this.getConfig();s.attachChange(function(E){var v=E.getParameter("selectedItem").getKey();this.setValue(v);this._updateSelected(E.getParameter("selectedItem"));}.bind(this));if(o&&o.item){e=o.item.path||e;}if(o&&o.item&&o.item.template){i=o.item.template.key;d=o.item.template.title;}if(o&&o.items){i="{key}";d="{title}";this.setModel(new J(o.items));}s.bindItems({path:e,template:new b({key:i,text:d})});s.setSelectedKey(this.getValue());return s;};
return F;});
sap.ui.predefine('sap/ui/integration/cards/Header',["sap/base/util/isEmptyObject","sap/f/cards/Header","sap/f/cards/HeaderRenderer","sap/m/library","sap/ui/integration/util/BindingHelper",'sap/ui/model/json/JSONModel',"sap/ui/integration/util/LoadingProvider"],function(i,F,a,l,B,J,L){"use strict";var A=l.AvatarColor;
var H=F.extend("sap.ui.integration.cards.Header",{
constructor:function(c,o,s,I){c=c||{};this._sAppId=s;this._bIsEmpty=i(c);var S={title:c.title,subtitle:c.subTitle};if(c.status&&typeof c.status.text==="string"){S.statusText=c.status.text;}if(c.icon){S.iconSrc=c.icon.src;S.iconDisplayShape=c.icon.shape;S.iconInitials=c.icon.text;S.iconAlt=c.icon.alt;S.iconBackgroundColor=c.icon.backgroundColor||(c.icon.text?A.Accent6:A.Transparent);}S=B.createBindingInfos(S);if(S.iconSrc){S.iconSrc=B.formattedProperty(S.iconSrc,function(v){return I.formatSrc(v,s);});}S.toolbar=o;F.call(this,S);if(o){o.attachVisibilityChange(this._handleToolbarVisibilityChange.bind(this));}},
metadata:{library:"sap.ui.integration",properties:{}},
renderer:a
});
H.prototype.init=function(){F.prototype.init.call(this);this._bReady=false;this._oLoadingProvider=new L();this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
H.prototype.exit=function(){F.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
H.prototype.isReady=function(){return this._bReady;};
H.prototype.isLoading=function(){var o=this._oLoadingProvider,c=this.getParent(),b=c.getMetadata()._sClassName==='sap.ui.integration.widgets.Card'?c.isLoading():false;return!o.getDataProviderJSON()&&(o.getLoadingState()||b);};
H.prototype._updateModel=function(d){this.getModel().setData(d);};
H.prototype._handleError=function(s){this.fireEvent("_error",{logMessage:s});};
H.prototype._handleToolbarVisibilityChange=function(e){var t=e.getParameter("visible");if(this._bIsEmpty){this.setVisible(t);}};
H.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};
H.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
H.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
H.prototype._setDataConfiguration=function(d){var p="/";if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
H.prototype.onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};
H.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this._oLoadingProvider.setLoading(false);this._oLoadingProvider.removeHeaderPlaceholder(this);};
return H;});
sap.ui.predefine('sap/ui/integration/cards/ListContent',["./BaseListContent","./ListContentRenderer","sap/ui/util/openWindow","sap/m/library","sap/m/List","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem"],function(B,L,o,l,a,b,c,M,d,e){"use strict";var A=b.AreaType;var f=l.AvatarSize;var g=l.AvatarColor;
var h=B.extend("sap.ui.integration.cards.ListContent",{
metadata:{aggregations:{_legend:{multiple:false,visibility:"hidden"}}},
renderer:L
});
h.prototype.init=function(){B.prototype.init.apply(this,arguments);var j=this._getList();var t=this;this.setAggregation("_content",j);j.attachUpdateFinished(function(){if(t._iVisibleItems){var I=j.getItems();for(var i=t._iVisibleItems+1;i<I.length;i++){I[i].setVisible(false);}}});this._oItemTemplate=new e({iconDensityAware:false});};
h.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};
h.prototype.loadDependencies=function(C){if(!C||!C.item||!C.item.chart){return Promise.resolve();}return M.loadDependencies();};
h.prototype.destroyPlaceholder=function(){var i=this.getAggregation("_legend");if(i){i.removeStyleClass("sapFCardContentHidden");}B.prototype.destroyPlaceholder.apply(this,arguments);};
h.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.items){this._setStaticItems(C.items);return this;}if(C.item){this._setItem(C.item);}return this;};
h.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().item);};
h.prototype._getList=function(){if(this._bIsBeingDestroyed){return null;}if(!this._oList){this._oList=new a({id:this.getId()+"-list",growing:false,showNoData:false,showSeparators:"None"});}return this._oList;};
h.prototype._setItem=function(i){var s={iconDensityAware:false,title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),highlight:i.highlight,info:i.info&&i.info.value,infoState:i.info&&i.info.state};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconInitials=i.icon.text;if(s.title&&s.description){s.iconSize=f.S;}else{s.iconSize=f.XS;}s.iconSize=i.icon.size||s.iconSize;s.iconBackgroundColor=i.icon.backgroundColor||(i.icon.text?undefined:g.Transparent);}if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart);}this._oItemTemplate=new e(s);this._oActions.setAreaType(A.ContentItem);this._oActions.attach(i,this);var j={template:this._oItemTemplate};this._filterHiddenNavigationItems(i,j);this._bindAggregationToControl("items",this._getList(),j);};
h.prototype._createChartAndAddLegend=function(C){var i=M.create(C);this.destroyAggregation("_legend");if(C.type==="StackedBar"){var j=new d({chart:i.getChart()});j.initItemsTitles(C.bars,this.getBindingContext().getPath());this.setAggregation("_legend",j);}return i;};
h.prototype._setStaticItems=function(i){var j=this._getList();i.forEach(function(I){var k=new e({iconDensityAware:false,title:I.title?I.title:"",description:I.description?I.description:"",icon:I.icon?I.icon:"",infoState:I.infoState?I.infoState:"None",info:I.info?I.info:"",highlight:I.highlight?I.highlight:"None"});if(I.action){k.setType("Navigation");if(I.action.url){k.attachPress(function(){o(I.action.url,I.target||"_blank");});}}j.addItem(k);});this.fireEvent("_actionContentReady");};
h.prototype.getInnerList=function(){return this._getList();};
return h;});
sap.ui.predefine('sap/ui/integration/cards/ListContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var L=B.extend("sap.ui.integration.cards.ListContentRenderer");
L.renderContent=function(r,l){r.renderControl(l.getAggregation("_content"));if(l.getAggregation("_legend")){r.renderControl(l.getAggregation("_legend"));}};
L.hideContent=function(l){B.hideContent(l);if(l.getAggregation("_legend")){l.getAggregation("_legend").addStyleClass("sapFCardContentHidden");}};
L.getMinHeight=function(c,C){if(!c){return this.DEFAULT_MIN_HEIGHT;}if(!c.maxItems||!c.item){return this.DEFAULT_MIN_HEIGHT;}var i=this.isCompact(C),a=parseInt(c.maxItems)||0,t=c.item,I=i?2:2.75;if(t.description||t.chart){I=5;}if(t.description&&t.chart){I=6;}return(a*I)+"rem";};
return L;});
sap.ui.predefine('sap/ui/integration/cards/NumericHeader',['sap/base/util/extend',"sap/base/util/isEmptyObject","sap/f/cards/NumericHeader","sap/f/cards/NumericHeaderRenderer","sap/ui/integration/util/BindingHelper","sap/f/cards/NumericSideIndicator",'sap/ui/model/json/JSONModel',"sap/ui/integration/util/LoadingProvider"],function(e,i,F,a,B,N,J,L){"use strict";
var b=F.extend("sap.ui.integration.cards.NumericHeader",{
constructor:function(c,A,s){c=c||{};this._sAppId=s;this._bIsEmpty=i(c);var S={title:c.title,subtitle:c.subTitle};if(c.status&&typeof c.status.text==="string"){S.statusText=c.status.text;}e(S,{unitOfMeasurement:c.unitOfMeasurement,details:c.details});if(c.mainIndicator){S.number=c.mainIndicator.number;S.scale=c.mainIndicator.unit;S.trend=c.mainIndicator.trend;S.state=c.mainIndicator.state;}S=B.createBindingInfos(S);if(c.sideIndicators){S.sideIndicators=c.sideIndicators.map(function(I){return new N(I);});}S.toolbar=A;F.call(this,S);if(A){A.attachVisibilityChange(this._handleToolbarVisibilityChange.bind(this));}},
metadata:{library:"sap.ui.integration",properties:{}},
renderer:a
});
b.prototype.init=function(){F.prototype.init.call(this);this._bReady=false;this._oLoadingProvider=new L();this._aReadyPromises=[];this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
b.prototype.exit=function(){F.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}};
b.prototype.isReady=function(){return this._bReady;};
b.prototype.isLoading=function(){var l=this._oLoadingProvider,c=this.getParent(),d=c.getMetadata()._sClassName==='sap.ui.integration.widgets.Card'?c.isLoading():false;return!l.getDataProviderJSON()&&(l.getLoadingState()||d);};
b.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(E,function(){r();});}.bind(this)));};
b.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
b.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
b.prototype._setDataConfiguration=function(d){var p="/";if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(E){this._updateModel(E.getParameter("data"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(E){this._handleError(E.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
b.prototype._updateModel=function(d){this.getModel().setData(d);};
b.prototype._handleError=function(l){this.fireEvent("_error",{logMessage:l});};
b.prototype._handleToolbarVisibilityChange=function(E){var t=E.getParameter("visible");if(this._bIsEmpty){this.setVisible(t);}};
b.prototype.onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};
b.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this._oLoadingProvider.setLoading(false);this._oLoadingProvider.removeHeaderPlaceholder(this);};
return b;});
sap.ui.predefine('sap/ui/integration/cards/ObjectContent',["sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/m/library","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Title","sap/m/Avatar","sap/m/Link","sap/m/Label","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/BindingHelper"],function(l,B,L,H,V,T,a,A,b,c,R,d,e,f){"use strict";var g=l.AreaType;var h=L.AvatarSize;var i=L.AvatarColor;
var O=B.extend("sap.ui.integration.cards.ObjectContent",{
metadata:{library:"sap.ui.integration"},
renderer:{}
});
O.prototype._getRootContainer=function(){if(this._bIsBeingDestroyed){return null;}var o=this.getAggregation("_content");if(!o){o=new d();this.setAggregation("_content",o);}this._sResizeListenerId=R.register(o,this.onAlignedFlowLayoutResize.bind(this));o.addEventDelegate({"onAfterRendering":function(){this.getContent().forEach(function(E){if(!E.getVisible()){document.getElementById("sap-ui-invisible-"+E.getId()).parentElement.classList.add("sapFCardInvisibleContent");}});}},o);return o;};
O.prototype.onAlignedFlowLayoutResize=function(E){if(E&&(E.size.width===E.oldSize.width)&&!E.control){return;}var C=E.control,m=C.getMinItemWidth(),n=C.getContent().length,M;if(m.lastIndexOf("rem")!==-1){M=e.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}var j=Math.floor(E.size.width/M);if(j>n){j=n;}if(this._iColsOld===j){return;}this._iColsOld=j;var k=j-1,r=Math.ceil(n/j);C.getContent().forEach(function(I,o){I.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(k===o&&k<n){I.removeStyleClass("sapFCardObjectSpaceBetweenGroup");k+=j;}if(o+1>(r-1)*j){I.addStyleClass("sapFCardObjectGroupLastInColumn");}else{I.removeStyleClass("sapFCardObjectGroupLastInColumn");}});};
O.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};
O.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.groups){this._addGroups(C);}return this;};
O.prototype._addGroups=function(C){var o=this._getRootContainer();var G=C.groups||[];G.forEach(function(j){var k=new V({visible:j.visible}).addStyleClass("sapFCardObjectGroup");var t=new a({text:j.title}).addStyleClass("sapFCardObjectItemTitle");k.addItem(t);j.items.forEach(function(I){var m,v=I.label,n=I.value,p,q,r=[];if(v){v=f.formattedProperty(v,function(y){return y&&y[y.length-1]===":"?y:y+=":";});p=new c({text:v,visible:I.visible}).addStyleClass("sapFCardObjectItemLabel");}if(n){switch(I.type){case'link':m=new b({href:I.url||n,text:n,target:I.target||'_blank',visible:f.reuse(I.visible)});break;case'email':if(I.value){r.push(I.value);}if(I.emailSubject){r.push(I.emailSubject);}q=f.formattedProperty(r,function(y,E){if(E){return"mailto:"+y+"?subject="+E;}else{return"mailto:"+y;}});m=new b({href:q,text:n,visible:f.reuse(I.visible)});break;case'phone':q=f.formattedProperty(n,function(y){return"tel:"+y;});m=new b({href:q,text:n,visible:f.reuse(I.visible)});break;default:m=new T({text:n,visible:f.reuse(I.visible)});break;}}if(m){m.addStyleClass("sapFCardObjectItemText");}if(I.icon){var s=f.formattedProperty(I.icon.src,function(y){return this._oIconFormatter.formatSrc(y,this._sAppId);}.bind(this));var u=new A({displaySize:I.icon.size||h.XS,src:s,initials:I.icon.text,displayShape:I.icon.shape,tooltip:I.icon.alt,backgroundColor:I.icon.backgroundColor||(I.icon.text?undefined:i.Transparent)}).addStyleClass("sapFCardObjectItemAvatar sapFCardObjectItemLabel sapFCardIcon");var w=new V({items:[p,m]});var x=new H({visible:I.visible,items:[u,w]});k.addItem(x);}else{k.addItem(p);k.addItem(m);}},this);o.addContent(k);},this);this._oActions.setAreaType(g.Content);this._oActions.attach(C,this);};
return O;});
sap.ui.predefine('sap/ui/integration/cards/TableContent',["./BaseListContent","./TableContentRenderer","sap/ui/integration/library","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/m/ObjectStatus","sap/m/Avatar","sap/ui/core/library","sap/m/library","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper","sap/ui/util/openWindow"],function(B,T,l,R,C,a,b,L,P,O,c,A,d,m,e,f,o){"use strict";var g=m.AvatarSize;var h=m.AvatarColor;var V=d.VerticalAlign;var i=m.ListSeparators;var k=m.ListType;var n=l.AreaType;
var p=B.extend("sap.ui.integration.cards.TableContent",{
metadata:{library:"sap.ui.integration"},
renderer:T
});
p.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};
p.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null;}var t=this.getAggregation("_content");if(!t){t=new R({id:this.getId()+"-Table",showSeparators:i.None});this.setAggregation("_content",t);}return t;};
p.prototype.setConfiguration=function(j){B.prototype.setConfiguration.apply(this,arguments);if(!j){return this;}if(j.rows&&j.columns){this._setStaticColumns(j.rows,j.columns);return this;}if(j.row&&j.row.columns){this._setColumns(j.row);}return this;};
p.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().row);};
p.prototype._setColumns=function(r){var j=[],t=this._getTable(),q=r.columns;q.forEach(function(u){t.addColumn(new C({header:new b({text:u.title}),width:u.width,hAlign:u.hAlign,visible:u.visible}));j.push(this._createCell(u));}.bind(this));this._oItemTemplate=new a({cells:j,vAlign:V.Middle});this._oActions.setAreaType(n.ContentItem);this._oActions.attach(r,this);var s={template:this._oItemTemplate};this._filterHiddenNavigationItems(r,s);this._bindAggregationToControl("items",t,s);};
p.prototype._setStaticColumns=function(r,q){var t=this._getTable();q.forEach(function(j){t.addColumn(new C({header:new b({text:j.title}),width:j.width,hAlign:j.hAlign}));});r.forEach(function(s){var I=new a({vAlign:V.Middle});if(s.cells&&Array.isArray(s.cells)){for(var j=0;j<s.cells.length;j++){I.addCell(this._createCell(s.cells[j]));}}if(s.actions&&Array.isArray(s.actions)){var u=s.actions[0];if(u.type===k.Navigation){I.setType(k.Navigation);}if(u.url){I.attachPress(function(){o(u.url,u.target||"_blank");});}}t.addItem(I);}.bind(this));this.fireEvent("_actionContentReady");};
p.prototype._createCell=function(j){if(j.url){return new L({text:j.value,href:j.url,target:j.target||"_blank"});}if(j.identifier){var t;if(j.identifier.url){t=f.formattedProperty(j.identifier.url,function(v){if(typeof v==="string"){return true;}return false;});}var I=new O({title:j.value,titleActive:t});if(j.identifier.url){I.attachTitlePress(function(E){var S=E.getSource(),q=S.getBindingContext(),r,u,v;if(q){r=q.getPath();}u=e.resolveValue(j.identifier.url,S,r);v=e.resolveValue(j.identifier.target,S,r);if(u){o(u,v||"_blank");}});}return I;}if(j.state){return new c({text:j.value,state:j.state});}if(j.value){return new b({text:j.value});}if(j.icon){var s=f.formattedProperty(j.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));return new A({src:s,displayShape:j.icon.shape,displaySize:j.icon.size||g.XS,tooltip:j.icon.alt,initials:j.icon.text,backgroundColor:j.icon.backgroundColor||(j.icon.text?undefined:h.Transparent)}).addStyleClass("sapFCardIcon");}if(j.progressIndicator){return new P({percentValue:j.progressIndicator.percent,displayValue:j.progressIndicator.text,state:j.progressIndicator.state});}};
p.prototype.getInnerList=function(){return this._getTable();};
return p;});
sap.ui.predefine('sap/ui/integration/cards/TableContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var T=B.extend("sap.ui.integration.cards.TableContentRenderer");
T.getMinHeight=function(c,C){if(!c){return this.DEFAULT_MIN_HEIGHT;}var i=this.isCompact(C),a=parseInt(c.maxItems)||0,r=i?2:2.75,t=i?2:2.75;return(a*r+t)+"rem";};
return T;});
sap.ui.predefine('sap/ui/integration/cards/TimelineContent',["./BaseListContent","./TimelineContentRenderer","sap/ui/core/Core","sap/ui/integration/util/BindingHelper"],function(B,T,C,a){"use strict";var b,c;
var d=B.extend("sap.ui.integration.cards.TimelineContent",{
metadata:{library:"sap.ui.integration"},
renderer:T
});
d.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oTimeLineItemTemplate){this._oTimeLineItemTemplate.destroy();this._oTimeLineItemTemplate=null;}};
d.prototype.loadDependencies=function(o){return new Promise(function(r,e){C.loadLibrary("sap.suite.ui.commons",{async:true}).then(function(){sap.ui.require(["sap/suite/ui/commons/Timeline","sap/suite/ui/commons/TimelineItem"],function(_,f){b=_;c=f;r();},function(E){e(E);});}).catch(function(){e("Timeline content type is not available with this distribution.");});});};
d.prototype._getTimeline=function(){var t=this.getAggregation("_content");if(this._bIsBeingDestroyed){return null;}if(!t){t=new b({id:this.getId()+"-Timeline",showHeaderBar:false,enableScroll:false});this.setAggregation("_content",t);}return t;};
d.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.items){this._setStaticItems(o.items);return this;}if(o.item){this._setItem(o.item);}return this;};
d.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().item);};
d.prototype._setItem=function(i){var s={userNameClickable:false,title:i.title&&i.title.value,text:i.description&&i.description.value,dateTime:i.dateTime&&i.dateTime.value,userName:i.owner&&i.owner.value,icon:i.icon&&i.icon.src};if(i.ownerImage&&i.ownerImage.value){s.userPicture=a.formattedProperty(i.ownerImage.value,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));}this._oTimeLineItemTemplate=new c(s);this._oActions.attach(i,this);var o={template:this._oTimeLineItemTemplate};this._filterHiddenNavigationItems(i,o);this._bindAggregationToControl("content",this._getTimeline(),o);return this;};
d.prototype._setStaticItems=function(i){var t=this._getTimeline(),o;i.forEach(function(I){o=new c({title:I.title,text:I.description,userPicture:I.ownerImage,dateTime:I.dateTime,userName:I.owner,icon:I.icon});t.addContent(o);});};
d.prototype.getInnerList=function(){return this._getTimeline();};
return d;});
sap.ui.predefine('sap/ui/integration/cards/TimelineContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var T=B.extend("sap.ui.integration.cards.TimelineContentRenderer");
T.getMinHeight=function(c,C){if(!c){return this.DEFAULT_MIN_HEIGHT;}if(!c.maxItems){return this.DEFAULT_MIN_HEIGHT;}var i=this.isCompact(C),a=parseInt(c.maxItems),I=i?4:5;return(a*I)+"rem";};
return T;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.ChoiceSetInput.apply(this,arguments);}
U.prototype=Object.create(A.ChoiceSetInput.prototype);
U.prototype.internalRender=function(){if(!this.isMultiSelect){if(this.isCompact){this._selectElement=document.createElement("ui5-select");this._selectElement.id=this.id;this._selectElement.addEventListener("change",function(){this.valueChanged();}.bind(this));for(var i=0;i<this.choices.length;i++){var o=document.createElement("ui5-option");o.value=this.choices[i].value;o.innerHTML=this.choices[i].title;if(this.choices[i].value===this.defaultValue){o.selected=true;}this._selectElement.appendChild(o);}return this._selectElement;}var r=document.createElement("div");r.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");r.id=this.id;r.addEventListener("select",function(){this.valueChanged();}.bind(this));this._toggleInputs=[];for(var j=0;j<this.choices.length;j++){var R=document.createElement("ui5-radiobutton");R.value=this.choices[j].value;R.text=this.choices[j].title;R.name=this.id;R.wrap=this.wrap;if(this.choices[j].value===this.defaultValue){R.selected=true;}this._toggleInputs.push(R);r.appendChild(R);}return r;}var d=this.defaultValue?this.defaultValue.split(","):null;var c=document.createElement("div");c.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");c.id=this.id;c.addEventListener("change",function(){this.valueChanged();}.bind(this));this._toggleInputs=[];for(var k=0;k<this.choices.length;k++){var C=document.createElement("ui5-checkbox");C.value=this.choices[k].value;C.text=this.choices[k].title;C.name=this.id;C.wrap=this.wrap;if(d&&d.indexOf(this.choices[k].value)>=0){C.checked=true;}this._toggleInputs.push(C);c.appendChild(C);}return c;};
Object.defineProperty(U.prototype,"value",{get:function v(){var i;if(!this.isMultiSelect){if(this.isCompact){return this._selectElement.selectedOption?this._selectElement.selectedOption.value:null;}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null;}for(i=0;i<this._toggleInputs.length;i++){if(this._toggleInputs[i].selected){return this._toggleInputs[i].value;}}return null;}}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null;}var r="";for(i=0;i<this._toggleInputs.length;i++){if(this._toggleInputs[i].checked){if(r!==""){r+=this.hostConfig.choiceSetInputValueSeparator;}r+=this._toggleInputs[i].value;}}return r===""?null:r;}}});return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputDate',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.DateInput.apply(this,arguments);}
U.prototype=Object.create(A.DateInput.prototype);
U.prototype.internalRender=function(){this._dateInputElement=document.createElement("ui5-datepicker");this._dateInputElement.id=this.id;this._dateInputElement.placeholder=this.placeholder;this._dateInputElement.formatPattern="yyyy-MM-dd";this._dateInputElement.value=this.defaultValue||"";this._dateInputElement.minDate=this.min||"";this._dateInputElement.maxDate=this.max||"";this._dateInputElement.addEventListener("change",function(){this.valueChanged();}.bind(this));return this._dateInputElement;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.NumberInput.apply(this,arguments);}
U.prototype=Object.create(A.NumberInput.prototype);
U.prototype.internalRender=function(){this._numberInputElement=document.createElement("ui5-input");this._numberInputElement.type="Number";this._numberInputElement.id=this.id;this._numberInputElement.placeholder=this.placeholder||"";this._numberInputElement.value=this.defaultValue||"";this._numberInputElement.addEventListener("change",function(e){if(e.target.value>this._max){e.target.value=this._max;}if(e.target.value<this._min){e.target.value=this._min;}this.valueChanged();}.bind(this));return this._numberInputElement;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputText',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.TextInput.apply(this,arguments);}
U.prototype=Object.create(A.TextInput.prototype);
U.prototype.internalRender=function(){if(this.isMultiline){var t=document.createElement("ui5-textarea");t.id=this.id;t.placeholder=this.placeholder||"";t.value=this.defaultValue||"";t.maxlength=this.maxLength||null;t.addEventListener("change",function(){this.valueChanged();}.bind(this));return t;}var i=document.createElement("ui5-input");switch(this.style){case 1:i.type="Tel";break;case 2:i.type="URL";break;case 3:i.type="Email";break;default:i.type="Text";}i.id=this.id;i.placeholder=this.placeholder||"";i.value=this.defaultValue||"";i.maxlength=this.maxLength||null;i.addEventListener("change",function(){this.valueChanged();}.bind(this));return i;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputTime',["sap/ui/integration/thirdparty/adaptivecards","sap/ui/core/format/DateFormat"],function(A,D){"use strict";
function U(){A.TimeInput.apply(this,arguments);}
var V={None:"None",Error:"Error"};var t="HH:mm";U.prototype=Object.create(A.TimeInput.prototype);
U.prototype.internalRender=function(){var w="ui5-timepicker";this._timeInputElement=document.createElement(w);this._timeInputElement.id=this.id;this._timeInputElement.value=this.defaultValue||"";this._timeInputElement.formatPattern=t;this._handleMinMaxProps();this._validateInput(this.value);this._timeInputElement.addEventListener("change",function(e){this._validateInput(e.target.value);this.valueChanged();}.bind(this));return this._timeInputElement;};
U.prototype._validateInputRange=function(v){var a,i,b;if(!this._isMinValid&&!this._isMaxValid){this._setValueState(V.None);return;}a=v.split(":");i=a[0];b=a[1];if(this._isMinValid&&i<this._iMinHour||(i===this._iMinHour&&b<this._iMinMinute)){this._setValueState(V.Error);return;}if(this._isMaxValid&&i>this._iMaxHour||(i===this._iMaxHour&&b>this._iMaxMinute)){this._setValueState(V.Error);return;}this._setValueState(V.None);};
U.prototype._validateInput=function(v){if(v===""){this._setValueState(V.None);return;}this._isValidTime(v)?this._validateInputRange(v):this._setValueState(V.Error);};
U.prototype._handleMinMaxProps=function(){this._isMinValid=this._min&&this._isValidTime(this._min);this._isMaxValid=this._max&&this._isValidTime(this._max);if(this._isMinValid){this._aMinValue=this._min.split(":");this._iMinHour=Number(this._aMinValue[0]);this._iMinMinute=Number(this._aMinValue[1]);}if(this._isMaxValid){this._aMaxValue=this._max.split(":");this._iMaxHour=Number(this._aMaxValue[0]);this._iMaxMinute=Number(this._aMaxValue[1]);}if(!this._isMinValid||!this._isMaxValid){return;}if(this._iMinHour>this._iMaxHour||(this._iMinHour===this._iMaxHour&&this._iMinMinute>this._iMaxMinute||this._iMinMinute===this._iMaxMinute)){this._setValueState(V.Error);}else{this._setValueState(V.None);}};
U.prototype._setValueState=function(T){this._timeInputElement.valueState=T;};
U.prototype._setValueStateMessage=function(m){this._timeInputElement.valueStateMessage=m;};
U.prototype._isValidTime=function(v){var T=D.getTimeInstance({pattern:t});return v&&T.parse(v);};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.ToggleInput.apply(this,arguments);}
U.prototype=Object.create(A.ToggleInput.prototype);
U.prototype.internalRender=function(){this._checkboxInputElement=document.createElement("ui5-checkbox");this._checkboxInputElement.id=this.id;this._checkboxInputElement.text=this.title||"";this._checkboxInputElement.wrap=this.wrap;this._checkboxInputElement.checked=false;if(this.defaultValue===this.valueOn){this._checkboxInputElement.checked=true;}this._checkboxInputElement.addEventListener("change",function(){this.valueChanged();}.bind(this));return this._checkboxInputElement;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/hostConfig',["sap/ui/core/theming/Parameters"],function(P){"use strict";return{"spacing":{"small":8,"default":16,"medium":32,"large":48,"extraLarge":48,"padding":16},"separator":{"lineThickness":1,"lineColor":P.get("sapUiToolbarSeparatorColor")},"supportsInteractivity":true,"fontTypes":{"default":{"fontFamily":P.get("sapUiFontFamily"),"fontSizes":{"small":12,"default":14,"medium":14,"large":16,"extraLarge":20}},"monospace":{}},"containerStyles":{"default":{"backgroundColor":"transparent","foregroundColors":{"default":{"default":P.get("sapUiBaseText"),"subtle":P.get("sapUiContentLabelColor")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"emphasis":{"backgroundColor":P.get("sapUiNeutralBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"accent":{"backgroundColor":P.get("sapUiInformationBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"good":{"backgroundColor":P.get("sapUiSuccessBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"attention":{"backgroundColor":P.get("sapUiErrorBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"warning":{"backgroundColor":P.get("sapUiWarningBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}}}};});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/overwrites/ActionRender',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";return function(b){if(b===0){b="ac-pushButton";}var h=this.parent.hostConfig;var a=document.createElement("ui5-button");this.addCssClasses(a);a.setAttribute("aria-label",this.title);a.type="button";a.style.display="flex";a.style.alignItems="center";a.style.justifyContent="center";var c=!A.isNullOrEmpty(this.title);var t=document.createElement("div");t.style.overflow="hidden";t.style.textOverflow="ellipsis";if(!(h.actions.iconPlacement===A.ActionIconPlacement.AboveTitle||h.actions.allowTitleToWrap)){t.style.whiteSpace="nowrap";}if(c){t.innerText=this.title;}if(A.isNullOrEmpty(this.iconUrl)){a.classList.add("noIcon");a.appendChild(t);}else{var i=document.createElement("img");i.src=this.iconUrl;i.style.width=h.actions.iconSize+"px";i.style.height=h.actions.iconSize+"px";i.style.flex="0 0 auto";if(h.actions.iconPlacement===A.ActionIconPlacement.AboveTitle){a.classList.add("iconAbove");a.style.flexDirection="column";if(c){i.style.marginBottom="4px";}}else{a.classList.add("iconLeft");if(c){i.style.marginRight="4px";}}a.appendChild(i);a.appendChild(t);}this._renderedElement=a;};});
sap.ui.predefine('sap/ui/integration/controls/ActionsToolbar',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/m/library","sap/m/Button","sap/m/ActionSheet","sap/ui/integration/util/CardActions","./ActionsToolbarRenderer"],function(q,C,l,B,A,a,b){"use strict";var c=l.ButtonType;
function s(o,p,v,e){return new Promise(function(r){var R;if(typeof v==="function"){R=v(e);if(R instanceof Promise){R.then(function(f){o.setProperty(p,f);r();});return;}}else{R=v;}o.setProperty(p,R);r();});}
var d=C.extend("sap.ui.integration.controls.ActionsToolbar",{
metadata:{library:"sap.ui.integration",properties:{},aggregations:{_toolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{visibilityChange:{parameters:{visible:{type:"boolean"}}}}},
renderer:b
});
d.prototype._open=function(){this._refreshButtons().then(function(){this._oActionSheet.openBy(this._getToolbar());}.bind(this));};
d.prototype._createActionButton=function(h,o,m){return new B({icon:m.icon,text:m.text,tooltip:m.tooltip,type:m.buttonType,press:function(e){a.fireAction({card:o,host:h,action:m,parameters:m.parameters,source:e.getSource(),url:m.url});}});};
d.prototype._getToolbar=function(){var t=this.getAggregation('_toolbar');if(!t){t=new B({id:this.getId()+"-overflowButton",icon:'sap-icon://overflow',type:c.Transparent,press:function(e){this._open();}.bind(this)});this.setAggregation('_toolbar',t);}return t;};
d.prototype.initializeContent=function(h,o,e){var t=this,f,g=[],i=[];this._oCard=o;if(h){i=i.concat(h.getActions()||[]);}if(e){i=i.concat(e.getActions()||[]);}if(!i.length){return false;}this._aActions=i;i.forEach(function(j){f=t._createActionButton(h,o,j);g.push(f);});if(this._oActionSheet){this._oActionSheet.destroy();}this._oActionSheet=new A({buttons:g});this._refreshButtons().then(function(){var g=this._oActionSheet.getButtons(),v=g.filter(function(j){return j.getVisible();}),V=!!v.length;this.fireVisibilityChange({visible:V});this._getToolbar().setVisible(V);}.bind(this));return true;};
d.prototype._refreshButtons=function(){var e=this._aActions,o=this._oCard,f=this._oActionSheet.getButtons(),m,g,i,p=[];for(i=0;i<e.length;i++){m=e[i];g=f[i];p.push(s(g,'enabled',m.enabled,o));p.push(s(g,'visible',m.visible,o));}return Promise.all(p);};
d.prototype.exit=function(){this._oCard=null;this._aActions=null;if(this._oActionSheet){this._oActionSheet.destroy();this._oActionSheet=null;}};
return d;});
sap.ui.predefine('sap/ui/integration/controls/ActionsToolbarRenderer',[],function(){"use strict";var A={apiVersion:2};
A.render=function(r,a){r.openStart("div",a).class("sapUIActionsToolbar").openEnd();r.renderControl(a._getToolbar());r.close("div");};
return A;},true);
sap.ui.predefine('sap/ui/integration/controls/ListContentItem',["./ListContentItemRenderer","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize","sap/m/StandardListItem"],function(L,A,a,b,S){"use strict";
var c=S.extend("sap.ui.integration.controls.ListContentItem",{
metadata:{library:"sap.ui.integration",properties:{iconAlt:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:a.Square},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:b.XS},iconBackgroundColor:{type:"sap.m.AvatarColor"}},aggregations:{microchart:{type:"sap.ui.integration.controls.Microchart",multiple:false},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}}},
renderer:L
});
c.prototype._getAvatar=function(){var o=this.getAggregation("_avatar");if(!o){o=new A().addStyleClass("sapFCardIcon");this.setAggregation("_avatar",o);}o.setSrc(this.getIcon()).setDisplayShape(this.getIconDisplayShape()).setTooltip(this.getIconAlt()).setInitials(this.getIconInitials()).setDisplaySize(this.getIconSize()).setBackgroundColor(this.getIconBackgroundColor());return o;};
return c;});
sap.ui.predefine('sap/ui/integration/controls/ListContentItemRenderer',["sap/ui/core/Renderer","sap/m/StandardListItemRenderer"],function(R,S){"use strict";var L=R.extend(S);L.apiVersion=2;
L.renderLIAttributes=function(r,l){S.renderLIAttributes.apply(this,arguments);r.class("sapUiIntegrationLCI");r.class("sapUiIntegrationLCIIconSize"+l.getIconSize());if(l.getMicrochart()){r.class("sapUiIntegrationLCIWithChart");}};
L.renderLIContent=function(r,l){var i=l.getInfo(),t=l.getTitle(),d=l.getDescription(),a=l.getAdaptTitleSize(),s=!t&&i;if(l.getIcon()||l.getIconInitials()){r.renderControl(l._getAvatar());}r.openStart("div").class("sapMSLIDiv");if((!d&&a&&i)||s){r.class("sapMSLIInfoMiddle");}r.openEnd();this.renderTitleWrapper(r,l);if(t&&d){this.renderDescription(r,l);}if(s&&!l.getWrapping()){this.renderInfo(r,l);}if(l.getMicrochart()){r.renderControl(l.getMicrochart());}r.close("div");};
return L;},true);
sap.ui.predefine('sap/ui/integration/controls/Microchart',["sap/m/library","sap/ui/core/Control","sap/ui/core/Core"],function(l,C,a){"use strict";var B,b,S,c;var V=l.ValueColor;
var M=C.extend("sap.ui.integration.controls.Microchart",{
metadata:{library:"sap.ui.integration",properties:{displayValue:{type:"string"},valueColor:{type:"sap.m.ValueColor",defaultValue:V.Neutral}},aggregations:{chart:{type:"sap.ui.core.Control",multiple:false}}},
renderer:{apiVersion:2,render:function(r,m){var v="sapUiIntegrationMicrochartValue"+m.getValueColor();r.openStart("div",m).class("sapUiIntegrationMicrochartChartWrapper").openEnd();r.openStart("div").class("sapUiIntegrationMicrochartChart").openEnd().renderControl(m.getChart()).close("div");r.openStart("div").class("sapMSLIInfo").class(v).openEnd().text(m.getDisplayValue()).close("div");r.close("div");}}
});
M.loadDependencies=function(){return new Promise(function(r,d){a.loadLibrary("sap.suite.ui.microchart",{async:true}).then(function(){sap.ui.require(["sap/suite/ui/microchart/BulletMicroChart","sap/suite/ui/microchart/BulletMicroChartData","sap/suite/ui/microchart/StackedBarMicroChart","sap/suite/ui/microchart/StackedBarMicroChartBar"],function(_,e,f,g){B=_;b=e;S=f;c=g;r();},function(e){d(e);});}).catch(function(){d("The usage of Microcharts is not available with this distribution.");});});};
M.create=function(o){var m,d;if(o.type==="Bullet"){var t=[];if(o.thresholds){t=o.thresholds.map(function(T){return new b({value:T.value,color:T.color});});}d=new B({size:"Responsive",minValue:o.minValue,maxValue:o.maxValue,targetValue:o.target,showTargetValue:!!o.target,scaleColor:"Light",scale:o.scale,actual:new b({value:o.value,color:o.color}),thresholds:t});m=new M({valueColor:o.color,displayValue:o.displayValue,chart:d});}if(o.type==="StackedBar"){var e=o.bars.map(function(f){return new c({value:f.value,displayValue:f.displayValue,valueColor:f.color});});d=new S({size:"Responsive",bars:e,maxValue:o.maxValue});m=new M({displayValue:o.displayValue,chart:d});}return m;};
return M;});
sap.ui.predefine('sap/ui/integration/controls/MicrochartLegend',["./MicrochartLegendRenderer","sap/m/Text","sap/ui/core/Control","sap/ui/integration/util/BindingHelper"],function(M,T,C,B){"use strict";
var a=C.extend("sap.ui.integration.controls.MicrochartLegend",{
metadata:{library:"sap.ui.integration",aggregations:{_titles:{type:"sap.m.Text",multiple:true,visibility:"hidden"}},associations:{chart:{type:"sap.ui.core.Control",multiple:false}}},
renderer:M
});
a.prototype.onAfterRendering=function(){this._equalizeWidths();};
a.prototype._equalizeWidths=function(){var $=this.$().children(".sapUiIntegrationMicrochartLegendItem"),m=0;$.css("width","");$.each(function(){var c=this.getBoundingClientRect().width;if(c>m){m=c;}});$.css("min-width",m+"px");};
a.prototype.initItemsTitles=function(b,p){this.destroyAggregation("_titles");b.forEach(function(c,i){var o=B.prependRelativePaths(c.legendTitle,p+"/"+i);var t=new T({text:o});t.addEventDelegate({onAfterRendering:this._equalizeWidths},this);this.addAggregation("_titles",t);}.bind(this));};
return a;});
sap.ui.predefine('sap/ui/integration/controls/MicrochartLegendRenderer',["sap/m/library","sap/ui/core/Core","sap/ui/core/theming/Parameters"],function(l,C,P){"use strict";var V=l.ValueColor;var M={apiVersion:2};
M.render=function(r,m){var c=C.byId(m.getChart()),L=[],t=m.getAggregation("_titles");if(c){L=c._calculateChartData().map(function(d){return d.color;});}r.openStart("div",m).class("sapUiIntegrationMicrochartLegend").openEnd();L.forEach(function(s,i){r.openStart("div").class("sapUiIntegrationMicrochartLegendItem").openEnd();r.openStart("div");M.addColor(r,s);r.openEnd().close("div");r.renderControl(t[i]);r.close("div");});r.close("div");};
M.addColor=function(r,c){if(V[c]){r.class("sapUiIntegrationMicrochartLegendItem"+c);}else{var s=P.get(c)||c;r.style("background",s);}};
return M;},true);
sap.ui.predefine('sap/ui/integration/customElements/CustomElementBase',["sap/base/Log","sap/ui/integration/util/Utils","sap/base/strings/hyphenate","sap/base/strings/camelize","sap/ui/integration/thirdparty/customElements","sap/ui/integration/thirdparty/customEvent"],function(L,U,h,c,a,b){"use strict";
function C(){if(this.constructor===C){throw new TypeError('Abstract class "CustomElementBase" cannot be instantiated directly.');}return Reflect.construct(HTMLElement,[],this.constructor);}
C.prototype=Object.create(HTMLElement.prototype);C.prototype.constructor=C;
C.prototype.connectedCallback=function(){this._init();this._upgradeAllProperties();this._oControlInstance.placeAt(this.firstElementChild);this._attachEventListeners();};
C.prototype.disconnectedCallback=function(){if(this._oControlInstance){this._oControlInstance.destroy();delete this._oControlInstance;}if(this.firstElementChild){this.removeChild(this.firstElementChild);}};
C.prototype.attributeChangedCallback=function(A,o,n){this._init();var s=c(A);if(U.isJson(n)){n=JSON.parse(n);}if(this._mAllProperties[s]){this._mAllProperties[s].set(this._oControlInstance,n);}else if(this._mAllAssociations[s]){var e=document.getElementById(n);if(e instanceof C){n=document.getElementById(n)._getControl();}this._mAllAssociations[s].set(this._oControlInstance,n);}};
C.prototype._init=function(){if(!this._oControlInstance){this._oControlInstance=new this._ControlClass();}if(!this.firstElementChild){var u=document.createElement("div");this.appendChild(u);}};
C.prototype._getControl=function(){this._init();return this._oControlInstance;};
C.prototype._attachEventListeners=function(){Object.keys(this._oMetadata.getEvents()).map(function(e){this._oControlInstance.attachEvent(e,function(E){this.dispatchEvent(new CustomEvent(e,{detail:E,bubbles:true}));},this);}.bind(this));};
C.prototype._upgradeAllProperties=function(){this._aAllProperties.forEach(this._upgradeProperty.bind(this));};
C.prototype._upgradeProperty=function(p){if(this[p]){var v=this[p];delete this[p];this[p]=v;}};
C.generateAccessors=function(p,P){P.forEach(function(s){Object.defineProperty(p,s,{get:function(){return this.getAttribute(h(s));},set:function(v){if(typeof v==="object"){v=JSON.stringify(v);}return this.setAttribute(h(s),v);}});});};
C.define=function(s,d,D){D=D||[];C.awaitDependencies(D).then(function(){window.customElements.define(s,d);});};
C.awaitDependencies=function(d){var p=d.map(function(s){return window.customElements.whenDefined(s);});return Promise.all(p);};
C.extend=function(d,s){function e(){return C.apply(this,arguments);}e.prototype=Object.create(C.prototype);e.prototype.constructor=e;var p=e.prototype,k="";p._ControlClass=d;p._oMetadata=d.getMetadata();p._mAllAssociations=p._oMetadata.getAllAssociations();p._mAllProperties=p._oMetadata.getAllProperties();p._aAllProperties=[];if(s&&s.customProperties){p._mAllProperties=Object.assign(p._mAllProperties,s.customProperties);}for(k in p._mAllProperties){if(s&&s.privateProperties&&s.privateProperties.indexOf(k)!==-1){continue;}p._aAllProperties.push(k);}for(k in p._mAllAssociations){p._aAllProperties.push(k);}Object.defineProperty(e,"observedAttributes",{get:function(){var A=p._aAllProperties.map(h);return A;}});C.generateAccessors(p,p._aAllProperties);return e;};
return C;});
sap.ui.predefine('sap/ui/integration/formatters/DateTimeFormatter',["sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/integration/util/Utils"],function(D,U,a){"use strict";var d={dateTime:function(v,f,l){var A=a.processFormatArguments(f,l),o=D.getDateTimeInstance(A.formatOptions,A.locale),p=a.parseJsonDateTime(v);var u=new U(p);var F=o.format(u);return F;},date:function(v,f,l){return d.dateTime.apply(this,arguments);}};return d;});
sap.ui.predefine('sap/ui/integration/formatters/IconFormatter',["sap/ui/base/Object","sap/ui/core/IconPool"],function(B,I){"use strict";
var a=B.extend("sap.ui.integration.util.Destinations",{constructor:function(d){B.call(this);this._oDestinations=d;}});
a.prototype.formatSrc=function(u,A){var i=0;if(!u||!A){return u;}if(u.startsWith("data:")){return u;}if(this._oDestinations.hasDestination(u)){return this._oDestinations.processString(u);}if(I.isIconURI(u)||u.startsWith("http://")||u.startsWith("https://")||u.startsWith("//")){return u;}if(u.startsWith("..")){i=2;}else if(u.startsWith(".")){i=1;}return sap.ui.require.toUrl(A.replace(/\./g,"/")+u.slice(i,u.length));};
return a;});
sap.ui.predefine('sap/ui/integration/formatters/NumberFormatter',["sap/ui/core/format/NumberFormat","sap/ui/integration/util/Utils"],function(N,U){"use strict";var n={currency:function(c,C,f,l){var s=U.processFormatArguments(f,l),o=N.getCurrencyInstance(s.formatOptions,s.locale);return o.format(c,C);},"float":function(f,F,l){var s=U.processFormatArguments(F,l),o=N.getFloatInstance(s.formatOptions,s.locale);return o.format(f);},integer:function(i,f,l){var s=U.processFormatArguments(f,l),I=N.getIntegerInstance(s.formatOptions,s.locale);return I.format(i);},percent:function(p,f,l){var s=U.processFormatArguments(f,l),P=N.getPercentInstance(s.formatOptions,s.locale);return P.format(p);},unit:function(u,s,f,l){var S=U.processFormatArguments(f,l),o=N.getUnitInstance(S.formatOptions,S.locale);return o.format(u,s);}};return n;});
sap.ui.predefine('sap/ui/integration/library',["sap/ui/base/DataType","sap/ui/Global","sap/ui/core/library","sap/m/library","sap/f/library"],function(D){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.integration",version:"1.84.17",dependencies:["sap.ui.core","sap.f","sap.m"],types:["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction"],controls:["sap.ui.integration.widgets.Card","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem"],elements:["sap.ui.integration.Host"],customElements:{"card":"sap/ui/integration/customElements/CustomElementCard"}});var t=sap.ui.integration;t.CardActionType={Navigation:"Navigation",Submit:"Submit",Custom:'Custom'};t.CardDataMode={Active:"Active",Inactive:"Inactive"};t.AreaType={None:'None',ContentItem:'ContentItem',Content:'Content',Header:'Header'};t.CardMenuAction=D.createType("sap.ui.integration.CardMenuAction",{isValid:function(v){var p=["type","text","icon","tooltip","buttonType","enabled","visible","action","parameters","target","url"];return Object.keys(v).every(function(k){return p.indexOf(k)!==-1;});}},"object");return t;});
sap.ui.predefine('sap/ui/integration/services/Data',['./Service'],function(S){"use strict";var D=S.extend();
D.prototype.attachDataChanged=function(d,p){};
D.prototype.detachDataChanged=function(d){};
D.prototype.getData=function(i){return Promise.resolve(false);};
return D;});
sap.ui.predefine('sap/ui/integration/services/Navigation',['./Service'],function(S){"use strict";var N=S.extend();
N.prototype.navigate=function(c){};
S.prototype.enabled=function(c){return Promise.resolve(false);};
return N;});
sap.ui.predefine('sap/ui/integration/services/Service',[],function(){"use strict";var S=function(){};
S.extend=function(C){if(!C){var t=this;C=function(){t.apply(this,arguments);};}C.prototype=Object.create(this.prototype);C.prototype.constructor=C;C.extend=this.extend.bind(C);return C;};
S.prototype.getInterface=function(){return this;};
return S;});
sap.ui.predefine('sap/ui/integration/util/BindingHelper',["sap/ui/base/BindingParser","sap/base/util/extend","sap/ui/integration/formatters/DateTimeFormatter","sap/ui/integration/formatters/NumberFormatter","sap/ui/integration/bindingFeatures/DateRange"],function(B,e,D,N,a){"use strict";var r=/\{\{([^}]+)\}\}/g,b=/\{\{(parameters\.[^}]+)\}\}/g,c=/\{\{(dataSources\.[^}]+)\}\}/g;var d={};var f={date:D.date,dateTime:D.dateTime,currency:N.currency,"float":N.float,integer:N.integer,percent:N.percent,unit:N.unit};d.DEFAULT_CARD_MODELS=["i18n","parameters","filters","context"];d.mLocals={"format":f,"dateRange":a};
d.extractBindingInfo=function(v){v=d.escapeCardPlaceholders(v);return B.complexParser(v,undefined,true,undefined,undefined,undefined,d.mLocals);};
d.createBindingInfos=function(i){if(!i){return i;}if(Array.isArray(i)){return i.map(d.createBindingInfos);}if(typeof i==="object"){var I={};for(var k in i){I[k]=d.createBindingInfos(i[k]);}return I;}return d.escapeParametersAndDataSources(d.extractBindingInfo(i)||i);};
d.formattedProperty=function(v,F){var g={};if(Array.isArray(v)){g.parts=v.map(function(I){return typeof I==="object"?e({},I):{value:I};});g.formatter=F;}else if(typeof v==="object"){g=e({},v);if(v.formatter){var i=g.formatter;g.formatter=function(){var I=i.apply(this,arguments);return F(I);};}else{g.formatter=F;}}else{g=F(v);}return g;};
d.escapeCardPlaceholders=function(v){if(typeof v!=="string"){return v;}return v.replace(r,"\\{\\{$1\\}\\}");};
d.escapeParametersAndDataSources=function(v){if(typeof v!=="string"){return v;}return v.replace(b,"\\{\\{$1\\}\\}").replace(c,"\\{\\{$1\\}\\}");};
d.addNamespace=function(n,v){d.mLocals[n]=v;};
d.isAbsolutePath=function(p){return p.startsWith("/");};
d.prependRelativePaths=function(v,p){if(typeof v!=="object"){return v;}var o=e({},v);if(o.path&&!this.isAbsolutePath(o.path)){o.path=p+"/"+o.path;}if(o.parts){o.parts=o.parts.map(function(g){return d.prependRelativePaths(g,p);});}return o;};
d.copyModels=function(s,t,m){var M=m||d.DEFAULT_CARD_MODELS,o=s.getModel();if(o){t.setModel(o);}M.forEach(function(g){var h=s.getModel(g);if(h){t.setModel(h,g);}});};
d.reuse=function(v){if(typeof v==="object"){return e({},v);}return v;};
return d;});
sap.ui.predefine('sap/ui/integration/util/BindingResolver',["sap/ui/base/ManagedObject","sap/base/Log","sap/ui/model/Model","sap/ui/integration/util/BindingHelper","sap/base/util/extend"],function(M,L,a,B,e){"use strict";
var S=M.extend("sap.ui.integration.util.SimpleControl",{metadata:{library:"sap.ui.integration",properties:{resolved:{type:"any"}}}});
var s=new S();var b={};
function p(v,m,P,c,i){if(c===i){L.warning("BindingResolver maximum level processing reached. Please check for circular dependencies.");return v;}if(Array.isArray(v)){return v.map(function(I){return p(I,m,P,c+1,i);});}if(v&&typeof v==="object"&&!b.isBindingInfo(v)){var n={};for(var d in v){n[d]=p(v[d],m,P,c+1,i);}return n;}if(typeof v==="string"||(typeof v==="object"&&b.isBindingInfo(v))){return r(v,m,P);}return v;}
function r(v,m,P){if(!v){return v;}var o=typeof v==="string"?M.bindingParser(v):e({},v);if(!o){return v;}if(!P){P="/";}if(m instanceof a){s.setModel(m);}else{B.copyModels(m,s);}s.bindObject(P);s.bindProperty("resolved",o);var V=s.getResolved();s.unbindProperty("resolved");s.unbindObject();s.setModel(null);return V;}
b.resolveValue=function(v,m,P){var c=0,i=30;if(m){return p(v,m,P,c,i);}else{return v;}};
b.isBindingInfo=function(o){if(!o){return false;}return o.hasOwnProperty("path")||(o.hasOwnProperty("parts")&&o.hasOwnProperty("formatter"));};
return b;});
sap.ui.predefine('sap/ui/integration/util/CardActions',["sap/m/library","sap/ui/integration/library","sap/ui/util/openWindow","sap/ui/base/ManagedObject","sap/base/Log","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/DataProviderFactory"],function(l,a,o,M,L,B,D){"use strict";
function _(s){if(s&&typeof s==="object"){return s.name;}return s;}
var A=a.AreaType,C=a.CardActionType,b=l.ListType;
var c=M.extend("sap.ui.integration.util.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},areaType:{type:"sap.ui.integration.AreaType",defaultValue:A.None}}}});
c.prototype.exit=function(){this._oAreaControl=null;};
c.prototype.attach=function(i,d){this._oAreaControl=d;if(!i.actions){this._fireActionReady();return;}var e=i.actions[0];if(e&&e.type){this._attachAction(i,e);}else{this._fireActionReady();}};
c.prototype._setItemTemplateTypeFormatter=function(d){var t=this,e=t._oAreaControl,i=e._oItemTemplate;var f=M.bindingParser("{path:''}");f.formatter=function(v){var g=this.getBindingContext(),p,P;if(g){p=g.getPath();}P=B.resolveValue(d.parameters,e,p);if(v.__resolved){if(!v.__enabled||v.__enabled==="false"){return b.Inactive;}return b.Navigation;}if(!v.__promise){v.__promise=true;e._oServiceManager.getService(_(d.service)).then(function(n){if(n){n.enabled({parameters:P}).then(function(E){v.__resolved=true;v.__enabled=E;e.getModel().checkUpdate(true);}).catch(function(){v.__resolved=true;v.__enabled=false;});}else{v.__resolved=true;v.__enabled=false;}});}return b.Inactive;};i.bindProperty("type",f);};
c.prototype._setSingleActionEnabledState=function(i,d){var e=this._oAreaControl,f=e.getBindingContext(),p,P;if(f){P=f.getPath();}p=B.resolveValue(d.parameters,e,P);return new Promise(function(r){e._oServiceManager.getService(_(d.service)).then(function(n){if(n){n.enabled({parameters:p}).then(function(E){r(E);}).catch(function(){r(false);});}else{r(false);}}).catch(function(){r(false);});});};
c.prototype._setItemTemplateEnabledState=function(d){var e,t,i=this._oAreaControl._oItemTemplate;if(typeof d.enabled==="object"){e=d.enabled;e.formatter=function(v){if(!v||v==="false"){return b.Inactive;}return b.Navigation;};}if(e){i.bindProperty("type",e);}else{t=(d.enabled===false||d.enabled==="false")?b.Inactive:b.Navigation;i.setProperty("type",t);}};
c.prototype._fireActionReady=function(){var h=this.getAreaType()===A.Header;var e=h?"_actionHeaderReady":"_actionContentReady";this._oAreaControl.fireEvent(e);};
c.prototype._handleServiceAction=function(s,d){var f=s.getBindingContext(),p;if(f){p=f.getPath();}this._oAreaControl._oServiceManager.getService(_(d.service)).then(function(S){if(S){S.navigate({parameters:B.resolveValue(d.parameters,s,p)});}}).catch(function(e){L.error("Navigation service unavailable",e);}).finally(function(){this._processAction(s,d,p);}.bind(this));};
c.prototype._handleAction=function(s,d){var e=s.getBindingContext(),p;if(e){p=e.getPath();}this._processAction(s,d,p);};
c.prototype._attachPressEvent=function(d,e,s){d.attachPress(function(E){var S=E.getSource();if(e.service){this._handleServiceAction(S,e);}else{this._handleAction(S,e);}}.bind(this));};
c.prototype._attachAction=function(i,d){var e=this.getAreaType()===A.ContentItem?this._oAreaControl._oItemTemplate:this._oAreaControl,f=true,s=this.getAreaType(),S=s===A.Header||s===A.Content,g=s===A.ContentItem,h=true;if(d.service){if(this.getAreaType()===A.ContentItem){this._setItemTemplateTypeFormatter(d);}f=false;}else if(g){this._setItemTemplateEnabledState(d);f=false;}if(S&&d.service){this._setSingleActionEnabledState(i,d).then(function(E){if(E){this._attachPressEvent(e,d,S);}this._fireActionReady();}.bind(this));}else{if(f){h=d.enabled!==false&&d.enabled!=="false";}if(h){this._attachPressEvent(e,d,S);}this._fireActionReady();}};
c.prototype._processAction=function(s,d,p){var h=this._getHostInstance(),e=this.getCard(),u=d.url;if(u){u=B.resolveValue(u,s,p);}c.fireAction({card:e,host:h,action:d,parameters:B.resolveValue(d.parameters,s,p),source:s,url:u});};
c.prototype._getHostInstance=function(){var d=this.getCard();if(d){return d.getHostInstance();}return null;};
c.prototype.fireAction=function(s,t,p){var h=this._getHostInstance(),d=this.getCard(),e=this._extractActionConfigurations(d,p),E={card:d,host:h,action:{type:t},parameters:e,source:s};c.fireAction(E);};
c.fireAction=function(m){var h=m.host,d=m.card,e=d.getAggregation("_extension"),f=m.action,p=m.parameters||{},g={type:f.type,card:d,actionSource:m.source,manifestParameters:p,parameters:p},i=d.fireAction(g);if(!i){return false;}if(h){i=h.fireAction(g);}if(!i){return false;}if(e){i=e.fireAction(g);}if(i){c._doPredefinedAction(m);}return i;};
c._doPredefinedAction=function(m){var d=m.action,p=m.parameters,f,u,t;if(p){var P=p.url,s=p.target;}switch(d.type){case C.Navigation:if(d.service){break;}u=m.url||P;t=d.target||s||"_blank";if(u){c.openUrl(u,t);}break;case C.Custom:f=d.action;if(typeof f==="function"){f(m.card,m.source);}break;case C.Submit:if(m.source&&m.source.isA("sap.ui.integration.cards.BaseContent")){c.handleSubmitAction(m);}break;}};
c.openUrl=function(u,t){o(u,t);};
c.handleSubmitAction=function(m){var d,e=m.card,f=e._oDataProviderFactory,g=m.source,h=m.parameters;if(!h.configuration){return;}g.onActionSubmitStart(h);d=f.create({request:h.configuration});d.getData().then(function(r){g.onActionSubmitEnd(r,null);},function(E){L.error(E);g.onActionSubmitEnd(null,{error:E});}).finally(function(){f.remove(d);});};
c.prototype._extractActionConfigurations=function(d,p){var r=d&&d.getManifestEntry("/sap.card/configuration/actionHandlers/submit"),e=p.data||{};if(!r){return p;}return{data:e,configuration:{"mode":r.mode||"cors","url":r.url,"method":r.method||"POST","parameters":Object.assign({},e,r.parameters),"headers":r.headers,"xhrFields":{"withCredentials":!!r.withCredentials}}};};
return c;});
sap.ui.predefine('sap/ui/integration/util/CardMerger',["sap/base/util/merge","sap/ui/model/json/JSONModel"],function(m,J){"use strict";var C={layers:{"admin":0,"content":5,"translation":10,"all":20},mergeManifestPathChanges:function(M,c){Object.keys(c).forEach(function(s){if(s.charAt(0)==="/"){M.setProperty(s,c[s]);}});},mergeCardDelta:function(M,c){var i=m({},M),s="sap.card";if(Array.isArray(c)&&c.length>0){var o;c.forEach(function(a){if(a.content){m(i[s],a.content);}else{o=o||new J(i);C.mergeManifestPathChanges(o,a);}});}return i;},mergeCardDesigntimeMetadata:function(d,c){var i=m({},d);c.forEach(function(o){var I=o.content.entityPropertyChange||[];I.forEach(function(a){var p=a.propertyPath;switch(a.operation){case"UPDATE":if(i.hasOwnProperty(p)){i[p]=a.propertyValue;}break;case"DELETE":delete i[p];break;case"INSERT":if(!i.hasOwnProperty(p)){i[p]=a.propertyValue;}break;default:break;}});});return i;}};return C;});
sap.ui.predefine('sap/ui/integration/util/ContentFactory',["./BindingHelper","./CardActions","sap/ui/base/Object","sap/base/util/merge","sap/ui/integration/cards/AdaptiveContent","sap/ui/integration/cards/AnalyticalContent","sap/ui/integration/cards/AnalyticsCloudContent","sap/ui/integration/cards/CalendarContent","sap/ui/integration/cards/ComponentContent","sap/ui/integration/cards/ListContent","sap/ui/integration/cards/ObjectContent","sap/ui/integration/cards/TableContent","sap/ui/integration/cards/TimelineContent"],function(B,C,a,m,A,b,c,d,e,L,O,T,f){"use strict";
var g=a.extend("sap.ui.integration.util.ContentFactory",{constructor:function(o){a.call(this);this._oCard=o;}});
g.prototype.create=function(h){var o=this._oCard,t=h.cardType;return new Promise(function(r,i){var j=this.getClass(t);if(!j){i(t.toUpperCase()+" content type is not supported.");return;}var k=new j();k.setCard(o);if(k instanceof A){k.setCardDataProvider(o._oDataProvider);}k.loadDependencies(h.contentManifest).then(function(){if((h.cardManifest&&h.cardManifest.isDestroyed())||(h.dataProviderFactory&&h.dataProviderFactory.isDestroyed())){i();return;}var l=new C({card:o});k._sAppId=h.appId;k.setServiceManager(h.serviceManager);k.setDataProviderFactory(h.dataProviderFactory);k.setIconFormatter(h.iconFormatter);k.setActions(l);if(t.toLowerCase()!=="adaptivecard"){k.setConfiguration(this._createBindingInfos(h.contentManifest),t);}else{k.setConfiguration(h.contentManifest);}r(k);}.bind(this)).catch(function(E){i(E);});}.bind(this));};
g.prototype.getClass=function(t){switch(t.toLowerCase()){case"adaptivecard":return A;case"analytical":return b;case"analyticscloud":return c;case"calendar":return d;case"component":return e;case"list":return L;case"object":return O;case"table":return T;case"timeline":return f;default:return null;}};
g.prototype._createBindingInfos=function(o){var r=m({},o),D=r.data;delete r.data;r=B.createBindingInfos(r);if(D){r.data=D;}return r;};
return g;});
sap.ui.predefine('sap/ui/integration/util/ContextModel',["sap/ui/model/json/JSONModel","sap/base/Log","sap/ui/integration/util/Utils"],function(J,L,U){"use strict";
var C=J.extend("sap.ui.integration.util.ContextModel",{constructor:function(d,o){J.apply(this,arguments);this._aPendingPromises=[];}});
C.prototype.setHost=function(h){this._oHost=h;this._mValues=null;};
C.prototype.getProperty=function(p,c){if(p&&!p.startsWith("/")&&!c){p="/"+p;}var h=this._oHost,a=this.resolve(p,c),b,H=h&&h.getContextValue;if(H){this._mValues=this._mValues||{};if(this._mValues[a]!==undefined){return this._mValues[a];}b=U.timeoutPromise(h.getContextValue(a.substring(1)));b=b.then(function(v){this._mValues[a]=v;this.checkUpdate();}.bind(this)).catch(function(r){this._mValues[a]=null;this.checkUpdate();L.error("Path "+a+" could not be resolved. Reason: "+r);}.bind(this));this._aPendingPromises.push(b);return null;}else{return J.prototype.getProperty.apply(this,arguments);}};
C.prototype.waitForPendingProperties=function(){var p=Promise.all(this._aPendingPromises);this._aPendingPromises=[];return p;};
return C;},true);
sap.ui.predefine('sap/ui/integration/util/DataProvider',["sap/ui/base/ManagedObject"],function(M){"use strict";
var D=M.extend("sap.ui.integration.util.DataProvider",{metadata:{library:"sap.ui.integration",properties:{settingsJson:{type:"string"}},events:{dataRequested:{parameters:{}},dataChanged:{parameters:{data:{type:"object"}}},error:{parameters:{message:{type:"string"}}}}}});
D.prototype.setDestinations=function(d){this._oDestinations=d;};
D.prototype.setDependencies=function(d){this._aDependencies=d;};
D.prototype.setSettingsJson=function(s){this.setProperty("settingsJson",s);this.setSettings(JSON.parse(s));if(this._bActive){this._scheduleDataUpdate();}};
D.prototype.setSettings=function(s){this._oSettings=s;};
D.prototype.getSettings=function(){return this._oSettings;};
D.prototype.triggerDataUpdate=function(){var p,a;this.fireDataRequested();p=this._waitDependencies();a=p.then(this._triggerDataUpdate.bind(this));if(!this._pInitialRequestPromise){this._pInitialRequestPromise=a;}return a;};
D.prototype._triggerDataUpdate=function(){this._bActive=true;return this.getData().then(function(d){this.fireDataChanged({data:d});this.onDataRequestComplete();}.bind(this)).catch(function(e){this.fireError({message:e});this.onDataRequestComplete();}.bind(this));};
D.prototype.getData=function(){var d=this.getSettings();return new Promise(function(r,a){if(d.json){r(d.json);}else{a("Could not get card data.");}});};
D.prototype.destroy=function(){if(this._iIntervalId){clearInterval(this._iIntervalId);this._iIntervalId=null;}this._oSettings=null;M.prototype.destroy.apply(this,arguments);};
D.prototype.getInitialRequestPromise=function(){return this._pInitialRequestPromise;};
D.prototype.onDataRequestComplete=function(){var i;if(!this._oSettings||!this._oSettings.updateInterval){return;}i=parseInt(this._oSettings.updateInterval);if(isNaN(i)){return;}setTimeout(function(){this.triggerDataUpdate();}.bind(this),i*1000);};
D.prototype._scheduleDataUpdate=function(){if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId);}this._iDataUpdateCallId=setTimeout(this.triggerDataUpdate.bind(this),0);};
D.prototype._waitDependencies=function(){var d=this._aDependencies||[],p=[];d.forEach(function(o){p.push(o.getInitialRequestPromise());});return Promise.all(p);};
return D;});
sap.ui.predefine('sap/ui/integration/util/DataProviderFactory',["sap/ui/base/Object","sap/ui/integration/util/ServiceDataProvider","sap/ui/integration/util/RequestDataProvider","sap/ui/integration/util/DataProvider","sap/ui/integration/util/ExtensionDataProvider","sap/ui/integration/util/JSONBindingHelper","sap/ui/integration/util/BindingHelper"],function(B,S,R,D,E,J,a){"use strict";
var b=B.extend("sap.ui.integration.util.DataProviderFactory",{constructor:function(d,e,c){B.call(this);this._oDestinations=d;this._oExtension=e;this._oCard=c;this._aDataProviders=[];this._aFiltersProviders=[];}});
b.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);if(this._aDataProviders){this._aDataProviders.forEach(function(d){if(!d.bIsDestroyed){d.destroy();}});this._aDataProviders=null;this._aFiltersProviders=null;}this._oCard=null;this._oExtension=null;this._bIsDestroyed=true;};
b.prototype.isDestroyed=function(){return this._bIsDestroyed;};
b.prototype.create=function(d,s,i){var c=this._oCard,C,o;if(!d){return null;}C={"settingsJson":J.createJsonWithBindingInfos(d)};if(d.request){o=new R(C);}else if(d.service){o=new S(C);}else if(d.json){o=new D(C);}else if(d.extension){o=new E(C,this._oExtension);}else{return null;}if(c){a.copyModels(this._oCard,o);o.bindObject("/");}o.setDestinations(this._oDestinations);if(o.isA("sap.ui.integration.util.IServiceDataProvider")){o.createServiceInstances(s);}this._aDataProviders.push(o);if(i){this._aFiltersProviders.push(o);}else{o.setDependencies(this._aFiltersProviders);}return o;};
b.prototype.remove=function(d){var p=this._aDataProviders.indexOf(d);if(p>-1){this._aDataProviders.splice(p,1);}if(d&&!d.bDestroyed&&d._bIsDestroyed){d.destroy();}};
return b;});
sap.ui.predefine('sap/ui/integration/util/Destinations',["sap/ui/base/Object","sap/base/Log","sap/ui/integration/util/Utils"],function(B,L,U){"use strict";var r=/\{\{destinations.([^\}]+)/;
var D=B.extend("sap.ui.integration.util.Destinations",{
metadata:{library:"sap.ui.integration"},
constructor:function(h,c){B.call(this);this._oHost=h;this._oConfiguration=c;this._mResolved=new Map();}
});
D.prototype.setHost=function(h){this._oHost=h;this._mResolved.clear();};
D.prototype.process=function(c){var u=c.url,C;if(!u||typeof u!=="string"){return Promise.resolve(c);}if(!this.hasDestination(u)){return Promise.resolve(c);}C=jQuery.extend(true,{},c);return this.processString(u).then(function(p){C.url=p;return C;});};
D.prototype.getUrl=function(k){var R;if(this._mResolved.has(k)){return this._mResolved.get(k);}R=this._resolveUrl(k);this._mResolved.set(k,R);return R;};
D.prototype._resolveUrl=function(k){var c=this._oConfiguration?this._oConfiguration[k]:null,n,d,p;if(!c){return Promise.reject("Configuration for destination '"+k+"' was not found in the manifest.");}n=c.name;d=c.defaultUrl;if(!n&&!d){return Promise.reject("Can not resolve destination '"+k+"'. Neither 'name' nor 'defaultUrl' is configured.");}if(!n&&d){return Promise.resolve(d);}if(!this._oHost&&!d){return Promise.reject("Can not resolve destination '"+k+"'. There is no 'host' and no defaultUrl specified.");}if(!this._oHost&&d){return Promise.resolve(d);}p=U.timeoutPromise(this._oHost.getDestination(n));if(d){return p.catch(function(m){L.error(m+" Fallback to default url.");return d;});}return p;};
D.prototype.hasDestination=function(s){return!!s.match(r);};
D.prototype.processString=function(s){var m=s.match(r),k;if(!m){return Promise.resolve(s);}k=m[1];return this.getUrl(k).then(function(u){return this._replaceUrl(s,k,u);}.bind(this));};
D.prototype._replaceUrl=function(s,k,u){var S=u.trim().replace(/\/$/,"");return s.replace("{{destinations."+k+"}}",S);};
return D;});
sap.ui.predefine('sap/ui/integration/util/ExtensionDataProvider',["sap/ui/integration/util/DataProvider"],function(D){"use strict";
var E=D.extend("sap.ui.integration.util.ExtensionDataProvider",{
metadata:{library:"sap.ui.integration"},
constructor:function(c,e){D.call(this,c);this._oExtension=e;}
});
E.prototype.destroy=function(){D.prototype.destroy.apply(this,arguments);this._oExtension=null;};
E.prototype.getData=function(){var e=this.getSettings().extension;if(!this._oExtension){return Promise.reject("The extension module is not loaded properly or doesn't export a correct value.");}if(!this._oExtension[e.method]){return Promise.reject("Extension doesn't implement "+e.method+" method.");}return this._oExtension[e.method].apply(this._oExtension,e.args);};
return E;});
sap.ui.predefine('sap/ui/integration/util/FilterBarFactory',["sap/ui/base/Object","sap/m/library","sap/m/HBox","sap/ui/integration/cards/Filter"],function(B,l,H,F){"use strict";var a=l.FlexWrap;var R=l.FlexRendertype;
var b=B.extend("sap.ui.integration.util.FilterBarFactory",{
metadata:{library:"sap.ui.integration"},
constructor:function(c){B.call(this);this._oCard=c;}
});
b.prototype.create=function(f,m){var c=[],r=[],C,k,o,d;for(k in f){C=f[k];o=new F({card:this._oCard,key:k,config:C,value:m[k]?m[k].value:C.value});this._awaitEvent(r,o,"_ready");o._setDataConfiguration(C.data);c.push(o);}if(!c.length){return null;}for(var i=0;i<c.length-1;i++){c[i].addStyleClass("sapUiTinyMarginEnd");}d=new H({wrap:a.Wrap,renderType:R.Bare,items:c});Promise.all(r).then(function(){d.fireEvent("_filterBarDataReady");});return d;};
b.prototype._awaitEvent=function(p,f,e){p.push(new Promise(function(r){f.attachEventOnce(e,function(){r();});}));};
return b;});
sap.ui.predefine('sap/ui/integration/util/HeaderFactory',["sap/ui/integration/library","sap/ui/base/Object","sap/ui/integration/cards/NumericHeader","sap/ui/integration/cards/Header","sap/base/strings/formatMessage","sap/ui/integration/controls/ActionsToolbar","sap/ui/integration/util/BindingHelper","./CardActions"],function(l,B,N,H,f,A,a,C){"use strict";var b=l.AreaType;
function c(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var o={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var e=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){e=P.length;}var i=parseFloat(s)||0;var g=parseFloat(e)||0;return f(t,[i,g]);}};h.bindProperty("statusText",o);}}
var d=B.extend("sap.ui.integration.util.HeaderFactory",{
metadata:{library:"sap.ui.integration"},
constructor:function(o){B.call(this);this._oCard=o;}
});
d.prototype.create=function(m){var h,o=this._oCard,e,g=this._createActionsToolbar();if(!m&&!g){return null;}if(!m){m={};}e=new C({card:o,areaType:b.Header});switch(m.type){case"Numeric":h=new N(m,g,o._sAppId);break;default:h=new H(m,g,o._sAppId,o._oIconFormatter);break;}if(m.status&&m.status.text&&m.status.text.format){if(m.status.text.format.translationKey){o._loadDefaultTranslations();}c(m.status.text.format,h);}h.setServiceManager(o._oServiceManager);h.setDataProviderFactory(o._oDataProviderFactory);h._setDataConfiguration(m.data);e.attach(m,h);h._oActions=e;return h;};
d.prototype._createActionsToolbar=function(){var o=this._oCard,h=o.getHostInstance(),e=o.getAggregation("_extension"),g,i;if(!h&&!e){return null;}g=new A();i=g.initializeContent(h,o,e);if(i){return g;}return null;};
return d;});
sap.ui.predefine('sap/ui/integration/util/JSONBindingHelper',["sap/ui/base/BindingParser","sap/ui/integration/util/BindingHelper"],function(B,a){"use strict";var b=[["ESCAPED_BINDING_START",/\\{/g,"\\{"],["ESCAPED_BINDING_END",/\\}/g,"\\}"],["BINDING_START",/{/g,"{"],["BINDING_END",/}/g,"}"]];var J={};
J.createJsonWithBindingInfos=function(v){if(!v){return v;}var j=this._createBindableJson(v),c=a.createBindingInfos(j);if(typeof c==="string"){c=this._escape(c);}return c;};
J._createBindableJson=function(v){var r;r=JSON.stringify(v,function(k,V){if(typeof V==="string"){return this._encodeBindingString(V);}return V;}.bind(this));r=this._escape(r);r=this._decodeBindingString(r);return r;};
J._escape=function(v){return B.complexParser.escape(v);};
J._encodeBindingString=function(v){b.forEach(function(c){var C=c[0],r=c[1];v=v.replace(r,C);});return v;};
J._decodeBindingString=function(v){b.forEach(function(c){var C=c[0],s=c[2];v=v.replace(new RegExp(C,"g"),s);});return v;};
return J;});
sap.ui.predefine('sap/ui/integration/util/LoadingProvider',["sap/ui/base/ManagedObject","sap/f/cards/loading/GenericPlaceholder","sap/f/cards/loading/ListPlaceholder"],function(M,G,L){"use strict";
var a=M.extend("sap.ui.integration.util.LoadingProvider",{metadata:{library:"sap.ui.integration"}});
a.prototype.createLoadingState=function(d){this._bLoading=true;this._bJSON=false;if(d){if(d.getSettings()['json']){this._bJSON=true;}}else{this._bLoading=false;}};
a.prototype.getDataProviderJSON=function(){return this._bJSON;};
a.prototype.setLoading=function(l){this._bLoading=l;return this._bLoading;};
a.prototype.getLoadingState=function(){return this._bLoading;};
a.prototype.removeHeaderPlaceholder=function(c){if(c&&c.getDomRef()){c.removeStyleClass("sapFCardHeaderLoading");c.getDomRef().classList.remove("sapFCardHeaderLoading");}};
a.prototype.destroy=function(){this._bLoading=null;this._bJSON=null;if(this._oContentPlaceholder){this._oContentPlaceholder.destroy();this._oContentPlaceholder=null;}M.prototype.destroy.apply(this,arguments);};
a.prototype.createContentPlaceholder=function(c,t){switch(t){case"List":this._oContentPlaceholder=new L({maxItems:c.maxItems?parseInt(c.maxItems):2,item:c.item});break;default:this._oContentPlaceholder=new G();}return this._oContentPlaceholder;};
return a;});
sap.ui.predefine('sap/ui/integration/util/Manifest',["sap/ui/base/Object","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/Log","./ParameterMap","sap/ui/integration/util/CardMerger"],function(B,C,d,a,b,L,P,c){"use strict";var M="/{SECTION}/configuration/parameters",e="/{SECTION}/configuration/filters",f="/{SECTION}",A="/sap.app/dataSources",R=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}|\{i18n>([^\}]+)\}/g;
var g=B.extend("sap.ui.integration.util.Manifest",{constructor:function(s,o,i,j){B.call(this);this._aChanges=j;this.PARAMETERS=M.replace("{SECTION}",s);this.FILTERS=e.replace("{SECTION}",s);this.CONFIGURATION=f.replace("{SECTION}",s);if(o){var O={},l;O.process=false;if(i){O.baseUrl=i;this._sBaseUrl=i;}else{L.warning("If no base URL is provided when the manifest is an object static resources cannot be loaded.");}if(this._aChanges){l=c.mergeCardDelta(o,this._aChanges);}else{l=o;}this._oManifest=new C(l,O);this.oJson=this._oManifest.getRawJson();}}});
g.prototype.getJson=function(){return this._unfreeze(this.oJson);};
g.prototype.get=function(s){return this._unfreeze(n(this.oJson,s));};
g.prototype.getUrl=function(){return this._oManifest.resolveUri("./","manifest");};
g.prototype.getResourceBundle=function(){return this.oResourceBundle;};
g.prototype._unfreeze=function(v){if(typeof v==="object"){return JSON.parse(JSON.stringify(v));}return v;};
g.prototype.destroy=function(){this.oJson=null;this.oResourceBundle=null;if(this._oManifest){this._oManifest.destroy();}this._bIsDestroyed=true;};
g.prototype.isDestroyed=function(){return this._bIsDestroyed;};
g.prototype.load=function(s){if(!s||!s.manifestUrl){if(this._sBaseUrl&&this._oManifest){return this.loadI18n().then(function(){this.processManifest();}.bind(this));}else{if(this._oManifest){this.processManifest();}return new Promise(function(i){i();});}}return C.load({manifestUrl:s.manifestUrl,async:true,processJson:function(o){if(this._aChanges){return c.mergeCardDelta(o,this._aChanges);}return o;}.bind(this)}).then(function(o){this._oManifest=o;this.oJson=this._oManifest.getRawJson();return this.loadI18n().then(function(){this.processManifest();}.bind(this));}.bind(this));};
g.prototype.loadI18n=function(){var H=false;C.processObject(this._oManifest.getJson(),function(o,K,v){if(!H&&v.match(R)){H=true;}});if(this.get("/sap.app/i18n")){H=true;}if(!H){return Promise.resolve();}return this._oManifest._loadI18n(true).then(function(o){this.oResourceBundle=o;}.bind(this));};
g.prototype.processManifest=function(){var i=0,j=15,u=jQuery.extend(true,{},this._oManifest.getRawJson()),D=this.get(A);p(u,this.oResourceBundle,i,j,this._oCombinedParams,D,this._oCombinedFilters);h(u);this.oJson=u;};
function h(o){if(o&&typeof o==='object'&&!Object.isFrozen(o)){Object.freeze(o);for(var K in o){if(o.hasOwnProperty(K)){h(o[K]);}}}}
function k(v){return(typeof v==="string")&&v.indexOf("{{")===0&&v.indexOf("}}")===v.length-2;}
function m(v){return(typeof v==="string")&&(v.indexOf("{{parameters.")>-1||v.indexOf("{{dataSources")>-1||v.indexOf("{{filters.")>-1);}
g._processPlaceholder=function(s,o,D,F){var i=P.processPredefinedParameter(s),v,j;if(!b(o)){for(var l in o){v=o[l].value;j="{{parameters."+l;i=r(i,v,j);}}if(D){i=r(i,D,"{{dataSources");}if(F){i=r(i,F,"{{filters");}return i;};
function r(s,v,i){if(a(v)||Array.isArray(v)){for(var j in v){s=r(s,v[j],i+"."+j);}}else if(s.includes(i+"}}")){s=s.replace(new RegExp(i+"}}",'g'),v);}return s;}
function p(o,i,j,l,q,D,F){if(j===l){return;}if(Array.isArray(o)){o.forEach(function(I,t,u){if(typeof I==="object"){p(I,i,j+1,l,q,D,F);}else if(m(I)){u[t]=g._processPlaceholder(I,q,D,F);}else if(k(I)&&i){u[t]=i.getText(I.substring(2,I.length-2));}},this);}else{for(var s in o){if(typeof o[s]==="object"){p(o[s],i,j+1,l,q,D,F);}else if(m(o[s])){o[s]=g._processPlaceholder(o[s],q,D,F);}else if(k(o[s])&&i){o[s]=i.getText(o[s].substring(2,o[s].length-2));}}}}
function n(o,s){if(s==="/"){return o;}if(o&&s&&typeof s==="string"&&s[0]==="/"){var j=s.substring(1).split("/"),q;for(var i=0,l=j.length;i<l;i++){q=j[i];o=o.hasOwnProperty(q)?o[q]:undefined;if(o===null||typeof o!=="object"){if(i+1<l&&o!==undefined){o=undefined;}break;}}return o;}return o&&o[s];}
g.prototype.processFilters=function(i){if(!this._oManifest){return;}var o=this.get(this.FILTERS),j={};if(i.size&&!o){L.error("If runtime filters are set, they have to be defined in the manifest configuration as well.");return;}jQuery.each(o,function(K,l){var v=i.get(K)||l.value;j[K]=v;});this._oCombinedFilters=j;this.processManifest();};
g.prototype.processParameters=function(o){if(!this._oManifest){return;}var i=this.get(this.PARAMETERS);if(!b(o)&&!i){L.error("If parameters property is set, parameters should be described in the manifest");return;}this._oCombinedParams=this._syncParameters(o,i);this.processManifest();};
g.prototype.getProcessedParameters=function(o){var i=this.get(this.PARAMETERS),j=this._syncParameters(o,i);p(j,this.oResourceBundle,0,15,o);return j;};
g.prototype._syncParameters=function(o,l){if(b(o)){return l;}var q=d(l,20,20),s=Object.getOwnPropertyNames(o),t=Object.getOwnPropertyNames(q);for(var i=0;i<t.length;i++){for(var j=0;j<s.length;j++){if(t[i]===s[j]){q[t[i]].value=o[s[j]];}}}return q;};
return g;},true);
sap.ui.predefine('sap/ui/integration/util/ParameterMap',['sap/ui/core/Core'],function(C){"use strict";var P={};var p={"{{parameters.NOW_ISO}}":g,"{{parameters.TODAY_ISO}}":a,"{{parameters.LOCALE}}":b};
function g(){return new Date().toISOString();}
function a(){return new Date().toISOString().slice(0,10);}
function b(){return C.getConfiguration().getLocale().toString();}
P.processPredefinedParameter=function(s){var r;Object.keys(p).forEach(function(e){r=new RegExp(e,'g');if(s.indexOf(e)>-1){s=s.replace(r,p[e]());}});return s;};
return P;});
sap.ui.predefine('sap/ui/integration/util/RequestDataProvider',["sap/ui/integration/util/DataProvider","jquery.sap.global","sap/base/Log"],function(D,q,L){"use strict";var m=["no-cors","same-origin","cors"];var M=["GET","POST"];
var R=D.extend("sap.ui.integration.util.RequestDataProvider",{metadata:{properties:{allowCustomDataType:{type:"boolean",defaultValue:false}}}});
R.prototype.getData=function(){var r=this.getSettings().request;if(this._oDestinations){return this._oDestinations.process(r).then(this._fetch.bind(this));}return this._fetch(r);};
R.prototype._isValidRequest=function(r){if(!r){return false;}if(m.indexOf(r.mode)===-1){return false;}if(M.indexOf(r.method)===-1){return false;}if(typeof r.url!=="string"){return false;}return true;};
R.prototype._fetch=function(r){var s="Invalid request";return new Promise(function(a,b){if(!r||!r.url){L.error(s);b(s);return;}if(!this.getAllowCustomDataType()&&r.dataType){L.error("To specify dataType property in the Request Configuration, first set allowCustomDataType to 'true'.");}var d=r.parameters;if(this._hasHeader(r,"Content-Type","application/json")){d=JSON.stringify(r.parameters);}var o={"mode":r.mode||"cors","url":r.url,"method":(r.method&&r.method.toUpperCase())||"GET","dataType":(this.getAllowCustomDataType()&&r.dataType)||"json","data":d,"headers":r.headers,"timeout":15000,"xhrFields":{"withCredentials":!!r.withCredentials}};if(this._isValidRequest(o)){q.ajax(o).done(function(c){a(c);}).fail(function(j,t,e){b(e);});}else{L.error(s);b(s);}}.bind(this));};
R.prototype._hasHeader=function(r,h,v){if(!r.headers){return false;}for(var k in r.headers){if(k.toLowerCase()===h.toLowerCase()&&r.headers[k]===v){return true;}}return false;};
return R;});
sap.ui.predefine('sap/ui/integration/util/ServiceDataProvider',["sap/ui/integration/util/DataProvider"],function(D){"use strict";
var S=D.extend("sap.ui.integration.util.ServiceDataProvider",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.integration.util.IServiceDataProvider"]}});
S.prototype.destroy=function(){this._oDataServicePromise=null;if(this._oServiceManager){this._oServiceManager=null;}D.prototype.destroy.apply(this,arguments);};
S.prototype.createServiceInstances=function(s){this._oServiceManager=s;if(!this._oSettings||!this._oSettings.service){return;}var v=this._oSettings.service;if(v&&typeof v==="object"){v=v.name;}this._createServiceInstance(v);};
S.prototype._createServiceInstance=function(s){var d=this._oSettings;this._oDataServicePromise=this._oServiceManager.getService(s).then(function(o){o.attachDataChanged(function(e){this.fireDataChanged({data:e.data});}.bind(this),d.service.parameters);return o;}.bind(this));};
S.prototype.getData=function(){var d=this.getSettings();var s=d.service;return new Promise(function(r,a){if(s&&this._oDataServicePromise){this._oDataServicePromise.then(function(o){o.getData().then(function(b){r(b);}).catch(function(){a("Card data service failed to get data.");});}).catch(function(){a("Card data service unavailable.");});}else{a("Could not get card data.");}}.bind(this));};
return S;});
sap.ui.predefine('sap/ui/integration/util/ServiceManager',["sap/ui/base/EventProvider","sap/base/Log"],function(E,L){"use strict";
var S=E.extend("sap.ui.integration.util.ServiceManager",{constructor:function(s,o){if(!s){throw new Error("Missing manifest services reference!");}if(!o){throw new Error("Missing context object");}this._mServiceFactoryReferences=s;this._mServices={};this._oServiceContext=o;this._initAllServices();}});
S.prototype._initAllServices=function(){for(var s in this._mServiceFactoryReferences){this._initService(s);}};
S.prototype._initService=function(n){var s=this._mServices[n]||{};s.promise=S._getService(this._oServiceContext,n,this._mServiceFactoryReferences).then(function(o){s.instance=o;}).catch(function(e){L.error(e.message);});this._mServices[n]=s;};
S.prototype.getService=function(s){var e="Invalid service";return new Promise(function(r,R){if(!s||!this._mServices[s]||!Object.keys(this._mServices[s])){R(e);return;}this._mServices[s].promise.then(function(){if(this._mServices[s].instance){r(this._mServices[s].instance);}else{R(e);}}.bind(this)).catch(R);}.bind(this));};
S.prototype.destroy=function(){this._mServices=null;};
S._getService=function(i,n,s){return new Promise(function(r,R){var o,f;if(i.bIsDestroyed){R(new Error("Service "+n+" could not be loaded as the requestor "+i.getMetadata().getName()+" was destroyed."));return;}if(!s){R(new Error("No Services declared"));return;}else{o=s[n];}if(!o||!o.factoryName){R(new Error("No Service '"+n+"' declared or factoryName missing"));return;}else{f=o.factoryName;}sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(a){var b=a.get(f);if(b){b.createInstance({scopeObject:i,scopeType:"component",settings:o.settings||{}}).then(function(c){if(c.getInterface){r(c.getInterface());}else{r(c);}}).catch(R);}else{var e=new Error("ServiceFactory '"+f+"' for Service '"+n+"' not found in ServiceFactoryRegistry");e._optional=o.optional;R(e);}});});};
return S;});
sap.ui.predefine('sap/ui/integration/util/Utils',["sap/ui/core/Locale",'sap/base/util/isPlainObject',"sap/base/Log"],function(L,i,a){"use strict";var U={};
U.isJson=function(t){if(typeof t!=="string"){return false;}try{JSON.parse(t);return true;}catch(e){return false;}};
U.processFormatArguments=function(f,l){var F=i(f)?f:{},o=typeof f==="string"?new L(f):(l&&new L(l));return{formatOptions:F,locale:o};};
var J=1,b=2,c=3;
U.parseJsonDateTime=function(d){var r=/^\/Date\((-?\d+)(\+|-)?(\d+)?\)\/$/,j;if(typeof d==="string"){j=r.exec(d);}if(j){var R=new Date(parseInt(j[J]));if(j[b]){var m=parseInt(j[c]);if(j[b]==="-"){m=-m;}var C=R.getUTCMinutes();R.setUTCMinutes(C-m);}if(isNaN(R.valueOf())){a.error("Invalid JSON Date format - "+d);}else{d=R;}}return d;};
U.DEFAULT_PROMISE_TIMEOUT=5000;
U.timeoutPromise=function(p,t){var d;if(t===undefined){t=U.DEFAULT_PROMISE_TIMEOUT;}d=new Promise(function(r,e){setTimeout(function(){e("The promise was not resolved after "+t+" ms so it timed out.");},t);});return Promise.race([p,d]);};
return U;});
sap.ui.predefine('sap/ui/integration/util/loadCardEditor',function(){"use strict";
function l(){return new Promise(function(r,R){sap.ui.require(["sap/ui/integration/designtime/cardEditor/BASEditor"],r,R);});}
return function(){return sap.ui.loader._.loadJSResourceAsync("sap-ui-integration-cardEditor.js").then(l).catch(l);};});
sap.ui.predefine('sap/ui/integration/widgets/Card',["sap/ui/base/Interface","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/integration/util/DataProviderFactory","sap/m/HBox","sap/ui/core/Icon","sap/m/Text","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/integration/util/ContextModel","sap/base/util/LoaderExtensions","sap/f/CardRenderer","sap/f/CardBase","sap/f/library","sap/ui/integration/library","sap/ui/integration/util/Destinations","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/util/FilterBarFactory","sap/ui/integration/util/CardActions"],function(I,q,C,a,S,L,m,d,D,H,b,T,J,R,c,e,F,f,l,g,h,i,j,k,B,n,o,p,r){"use strict";var M={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations",FILTERS:"/sap.card/configuration/filters"};var s=l.cards.HeaderPosition;var t=g.CardDataMode;
var u=f.extend("sap.ui.integration.widgets.Card",{
metadata:{library:"sap.ui.integration",properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:t.Active},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]"}},aggregations:{_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},manifestReady:{parameters:{}}},associations:{host:{}}},
renderer:F
});
u.prototype.init=function(){f.prototype.init.call(this);this.setModel(new J(),"parameters");this.setModel(new J(),"filters");this.setModel(new c(),"context");this._busyStates=new Map();this._oContentFactory=new k(this);this._oLimitedInterface=new I(this,["getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","showMessage","getBaseUrl","getTranslatedText","getModel","triggerAction"]);};
u.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_headerReady");this._awaitEvent("_filterBarReady");this._awaitEvent("_contentReady");this._awaitEvent("_cardReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
u.prototype._clearReadyState=function(){this._bReady=false;this._aReadyPromises=[];};
u.prototype.onBeforeRendering=function(){if(this.getDataMode()!==t.Active){return;}if(this._bApplyManifest||this._bApplyParameters){this._clearReadyState();this._initReadyState();}if(this._bApplyManifest){var v=this.getManifest();if(!v){this.destroyManifest();}else{this.createManifest(v,this.getBaseUrl());}}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this._getContextAndRuntimeParams());this._applyManifestSettings();}this._bApplyManifest=false;this._bApplyParameters=false;};
u.prototype.setManifest=function(v){this.setProperty("manifest",v);this._bApplyManifest=true;return this;};
u.prototype.setManifestChanges=function(v){this.setProperty("manifestChanges",v);this._bApplyManifest=true;return this;};
u.prototype.setParameters=function(v){this.setProperty("parameters",v);this._bApplyParameters=true;return this;};
u.prototype.setParameter=function(K,v){var P=this.getParameters()||{};P[K]=v;this.setParameters(P);return this;};
u.prototype.setHost=function(v){this.setAssociation("host",v);var w=this.getHostInstance();this.getModel("context").setHost(w);if(this._oDestinations){this._oDestinations.setHost(w);}return this;};
u.prototype.createManifest=function(v,w){var O={};this._isManifestReady=false;if(typeof v==="string"){O.manifestUrl=v;v=null;}if(this._oCardManifest){this._oCardManifest.destroy();}this._oCardManifest=new a("sap.card",v,w,this.getManifestChanges());this._oCardManifest.load(O).then(function(){this._registerManifestModulePath();this._isManifestReady=true;this.fireManifestReady();return this._loadExtension();}.bind(this)).then(this._applyManifest.bind(this)).catch(this._applyManifest.bind(this));};
u.prototype._loadExtension=function(){var E=this._oCardManifest.get("/sap.card/extension");if(!E){return null;}var v=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+E;return new Promise(function(w,x){sap.ui.require([v],function(y){var z=new y();z._setCard(this,this._oLimitedInterface);this.setAggregation("_extension",z);B.addNamespace("extension",{formatters:z.getFormatters()});w();}.bind(this),function(y){L.error("Failed to load "+E+". Check if the path is correct.");x(y);});}.bind(this));};
u.prototype._applyManifest=function(){var v=this._oCardManifest;if(v&&v.getResourceBundle()){this._enhanceI18nModel(v.getResourceBundle());}if(this._hasContextParams()){this._resolveContextParams().then(function(w){this._oContextParameters=w;this._applyManifestWithParams();}.bind(this));return;}this._applyManifestWithParams();};
u.prototype._applyManifestWithParams=function(){var v=this._oCardManifest,P=this._getContextAndRuntimeParams();v.processParameters(P);this._prepareToApplyManifestSettings();this._applyManifestSettings();};
u.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var v=C.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(v);this._defaultTranslationsLoaded=true;};
u.prototype._enhanceI18nModel=function(v){var w=this.getModel("i18n");if(w){w.enhance(v);return;}w=new R({bundle:v});this.setModel(w,"i18n");};
u.prototype._hasContextParams=function(){var v=this._oCardManifest.get(M.PARAMS),K,V;for(K in v){V=v[K].value;if(typeof V==="string"&&V.indexOf("{context>")!==-1){return true;}}return false;};
u.prototype._resolveContextParams=function(){var v=this.getModel("context"),w=this._oCardManifest.get(M.PARAMS),x={},K,V;for(K in w){V=w[K].value;if(typeof V==="string"&&V.indexOf("{context>")!==-1){x[K]=V;}}n.resolveValue(x,this,"/");return v.waitForPendingProperties().then(function(){return n.resolveValue(x,this,"/");}.bind(this));};
u.prototype._getContextAndRuntimeParams=function(){var v=this._oContextParameters||{},w=this.getParameters()||{};return m(v,w);};
u.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(v){this.attachEventOnce(E,function(){v();});}.bind(this)));};
u.prototype.isReady=function(){return this._bReady;};
u.prototype.refresh=function(){if(this.getDataMode()===t.Active){this._clearReadyState();this._initReadyState();this.destroyManifest();this._bApplyManifest=true;this.invalidate();}};
u.prototype._refreshActionsMenu=function(){var v=this.getCardHeader(),w=this.getHostInstance(),E=this.getAggregation("_extension"),A=[],x,y,z;if(!v){return;}x=v.getToolbar();if(x){if(w){A=A.concat(w.getActions()||[]);}if(E){A=A.concat(E.getActions()||[]);}if(d(A,x._aActions)){return;}}y=new j(this);z=y._createActionsToolbar();if(z){v.setToolbar(z);}};
u.prototype.exit=function(){f.prototype.exit.call(this);this.destroyManifest();this._busyStates=null;this._oContentFactory=null;};
u.prototype.destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null;}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null;}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}if(this._oTemporaryContent){this._oTemporaryContent.destroy();this._oTemporaryContent=null;}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null;}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null;}this.destroyAggregation("_header");this.destroyAggregation("_filterBar");this.destroyAggregation("_content");this._aReadyPromises=null;this._busyStates.clear();this.getModel("filters").setData({});this._oContextParameters=null;};
u.prototype._registerManifestModulePath=function(){if(!this._oCardManifest){return;}this._sAppId=this._oCardManifest.get("/sap.app/id");if(this._sAppId){e.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oCardManifest.getUrl());}else{L.error("Card sap.app/id entry in the manifest is mandatory");}};
u.prototype.getManifest=function(){var v=this.getProperty("manifest");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};
u.prototype.getParameters=function(){var v=this.getProperty("parameters");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};
u.prototype.getCombinedParameters=function(){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}var P=this._oCardManifest.getProcessedParameters(this._getContextAndRuntimeParams()),v={},K;for(K in P){v[K]=P[K].value;}return v;};
u.prototype.getManifestEntry=function(P){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}return this._oCardManifest.get(P);};
u.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{};}return q.extend(true,{},this._oCardManifest._oManifest.getRawJson());};
u.prototype.resolveDestination=function(K){return this._oDestinations.getUrl(K);};
u.prototype.showMessage=function(v,w){var x=this.getCardContent();if(!x||!x.showMessage){L.error("The experimental feature 'showMessage' is currently available only for an Adaptive Card.");return;}x.showMessage(v,w);};
u.prototype.getTranslatedText=function(K,A,v){var w=this.getModel("i18n"),x;if(!w){L.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null;}x=w.getResourceBundle();return x.getText(K,A,v);};
u.prototype._prepareToApplyManifestSettings=function(){var A=this._oCardManifest.get(M.APP_TYPE),E=this.getAggregation("_extension");if(A&&A!=="card"){L.error("sap.app/type entry in manifest is not 'card'");}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}this._oDestinations=new h(this.getHostInstance(),this._oCardManifest.get(M.DESTINATIONS));this._oIconFormatter=new o(this._oDestinations);this._oDataProviderFactory=new D(this._oDestinations,E,this);this._oLoadingProvider=new i();if(E){E.onCardReady();}this._fillFiltersModel();};
u.prototype._fillFiltersModel=function(){var v=this.getModel("filters"),w=this._oCardManifest.get(M.FILTERS);for(var K in w){v.setProperty("/"+K,{"value":w[K].value});}};
u.prototype._applyManifestSettings=function(){this._applyServiceManifestSettings();this._applyFilterBarManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyContentManifestSettings();};
u.prototype._applyDataManifestSettings=function(){var v=this._oCardManifest.get(M.DATA);if(!v){this.fireEvent("_cardReady");return;}this.bindObject(v.path||"/");if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(v,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(E){this.getModel().setData(E.getParameter("data"));if(this._createContentPromise){this._createContentPromise.then(function(w){w.onDataChanged();});}this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(E){this._handleError("Data service unavailable. "+E.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}};
u.prototype._handleCardLoading=function(){var v=this.getCardContent();if(v&&!v.hasStyleClass("sapFCardErrorContent")&&v._oLoadingPlaceholder){var w=v.getAggregation("_content");if(w){w.removeStyleClass("sapFCardContentHidden");}v._oLoadingPlaceholder.destroy();}if(this._oLoadingProvider){this._oLoadingProvider.removeHeaderPlaceholder(this.getCardHeader());}this._oLoadingProvider.setLoading(false);};
u.prototype._applyServiceManifestSettings=function(){var v=this._oCardManifest.get(M.SERVICES);if(!v){return;}if(!this._oServiceManager){this._oServiceManager=new S(v,this);}};
u.prototype.getCardHeader=function(){return this.getAggregation("_header");};
u.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top";}return this._oCardManifest.get(M.HEADER_POSITION)||s.Top;};
u.prototype.getCardContent=function(){return this.getAggregation("_content");};
u.prototype._applyHeaderManifestSettings=function(){var v=this.createHeader();if(!v){this.fireEvent("_headerReady");return;}this.destroyAggregation("_header");this.setAggregation("_header",v);if(v.isReady()){this.fireEvent("_headerReady");}else{v.attachEvent("_ready",function(){this.fireEvent("_headerReady");}.bind(this));}};
u.prototype._applyFilterBarManifestSettings=function(){var v=this.createFilterBar();if(!v){this.fireEvent("_filterBarReady");return;}v.attachEventOnce("_filterBarDataReady",function(){this.fireEvent("_filterBarReady");}.bind(this));this.destroyAggregation("_filterBar");this.setAggregation("_filterBar",v);};
u.prototype.getHostInstance=function(){var v=this.getHost();if(!v){return null;}return C.byId(v);};
u.prototype._applyContentManifestSettings=function(){var v=this._oCardManifest.get(M.TYPE),w=this.getContentManifest(),A=v+" "+this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD");this._ariaText.setText(A);if(!w){this.fireEvent("_contentReady");return;}this._setTemporaryContent(v,w);if(this._bIsPreviewMode){this.fireEvent("_contentReady");return;}this._createContentPromise=this.createContent({cardType:v,contentManifest:w,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,appId:this._sAppId}).then(function(x){this._setCardContent(x);return x;}.bind(this));this._createContentPromise.catch(function(E){if(E){this._handleError(E);}}.bind(this));};
u.prototype.createHeader=function(){var v=this._oCardManifest.get(M.HEADER),w=new j(this);return w.create(v);};
u.prototype.createFilterBar=function(){var v=this._oCardManifest.get(M.FILTERS),w=this.getModel("filters"),x=w.getProperty("/"),y=new p(this);return y.create(v,x);};
u.prototype.getContentManifest=function(){var v=this._oCardManifest.get(M.TYPE),w=v&&v.toLowerCase()==="component",x=this._oCardManifest.get(M.CONTENT),y=!!x;if(y&&!v){L.error("Card type property is mandatory!");return null;}if(!y&&!w){return null;}if(!x&&w){x=this._oCardManifest.getJson();}return x;};
u.prototype.createContent=function(v){v.cardManifest=this._oCardManifest;return this._oContentFactory.create(v);};
u.prototype.onAfterRendering=function(){var v;if(this._oCardManifest&&this._oCardManifest.get(M.TYPE)){v=this._oCardManifest.get(M.TYPE).toLowerCase();}this.toggleStyleClass("sapFCardAnalytical",v==="analytical");};
u.prototype._setCardContent=function(v){v.attachEvent("_error",function(E){this._handleError(E.getParameter("logMessage"),E.getParameter("displayMessage"));}.bind(this));var P=this.getAggregation("_content");if(P&&P!==this._oTemporaryContent){P.destroy();}this.setAggregation("_content",v);if(v.isReady()){this.fireEvent("_contentReady");}else{v.attachEvent("_ready",function(){this.fireEvent("_contentReady");}.bind(this));}};
u.prototype._setTemporaryContent=function(v,w){var x=this._getTemporaryContent(v,w),P=this.getAggregation("_content");if(P&&P!==x){P.destroy();}this.setAggregation("_content",x);};
u.prototype._handleError=function(v,w){L.error(v);this.fireEvent("_error",{message:v});var x="Unable to load the data.",E=w||x,P=this.getAggregation("_content");var y=new H({justifyContent:"Center",alignItems:"Center",items:[new b({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:E})]}).addStyleClass("sapFCardErrorContent");if(P&&!P.hasStyleClass("sapFCardErrorContent")){P.destroy();this.fireEvent("_contentReady");}y.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var z=this._oCardManifest.get(M.TYPE),A=this._oCardManifest.get(M.CONTENT),G=this._oContentFactory.getClass(z).getMetadata().getRenderer().getMinHeight(A,y);if(this.getHeight()==="auto"){y.$().css({"min-height":G});}}},this);this.setAggregation("_content",y);};
u.prototype._getTemporaryContent=function(v,w){if(!this._oTemporaryContent&&this._oLoadingProvider){this._oTemporaryContent=this._oLoadingProvider.createContentPlaceholder(w,v);this._oTemporaryContent.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var x=this._oContentFactory.getClass(v).getMetadata().getRenderer().getMinHeight(w,this._oTemporaryContent);if(this.getHeight()==="auto"){this._oTemporaryContent.$().css({"min-height":x});}}},this);}return this._oTemporaryContent;};
u.prototype.setDataMode=function(v){if(this._oDataProviderFactory&&v===t.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;}this.setProperty("dataMode",v,true);if(this.getProperty("dataMode")===t.Active){this.refresh();}return this;};
u.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oCardManifest){return new Promise(function(v,w){this.attachManifestReady(function(){this.loadDesigntime().then(v,w);}.bind(this));}.bind(this));}var A=this._oCardManifest.get("/sap.app/id");if(!A){return Promise.reject("App id not maintained");}return new Promise(function(v,w){var x=this._oCardManifest.get("/sap.card/designtime"),y=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+x;if(y){sap.ui.require([y],function(z){z=new z();z._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=z;v(z);}.bind(this));}.bind(this),function(){w({error:y+" not found"});});}else{w();}}.bind(this));};
u.prototype.isLoading=function(){return this._oLoadingProvider?this._oLoadingProvider.getLoadingState():false;};
u.prototype.getFocusDomRef=function(){var v=this.getCardHeader();if(v&&v.getDomRef()){return v.getDomRef();}return this.getDomRef();};
u.prototype.onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};
u.prototype.onDataRequestComplete=function(){this.fireEvent("_cardReady");this._handleCardLoading();this._oLoadingProvider.setLoading(false);};
u.prototype.request=function(v){return this._oDataProviderFactory.create({request:v}).setAllowCustomDataType(true).getData();};
u.prototype.triggerAction=function(A){r.fireAction({card:this,host:this.getHostInstance(),action:A,parameters:A.parameters,source:this});};
u.prototype._setPreviewMode=function(v){this._bIsPreviewMode=v;if(v){this.addStyleClass("sapFCardPreview");}else{this.removeStyleClass("sapFCardPreview");}this._bApplyManifest=true;this.invalidate();};
return u;});
sap.ui.require.preload({
	"sap/ui/integration/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.integration","type":"library","embeds":[],"applicationVersion":{"version":"1.84.17"},"title":"SAPUI5 library with integration-related controls.","description":"SAPUI5 library with integration-related controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"webcomponentsjs","packagedWithMySelf":true,"version":"0.0.0"},{"name":"custom-event-polyfill","packagedWithMySelf":true,"version":"0.0.0"},{"name":"adaptive-cards","packagedWithMySelf":true,"version":"0.0.0"},{"name":"markdown-it","packagedWithMySelf":true,"version":"0.0.0"},{"name":"ui5-web-components","packagedWithMySelf":true,"version":"0.0.0"},{"name":"ajv","packagedWithMySelf":true,"version":"0.0.0"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.84","libs":{"sap.ui.core":{"minVersion":"1.84.17"},"sap.f":{"minVersion":"1.84.17"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","pt-PT","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.integration.widgets.Card","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem"],"elements":["sap.ui.integration.Host"],"types":["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction"]}}}}',
	"sap/ui/integration/customElements/CustomElementCard.js":function(){sap.ui.require(["sap/ui/integration/widgets/Card","sap/ui/integration/customElements/CustomElementBase","sap/m/BadgeCustomData"],function(C,a,B){"use strict";var b=a.extend(C,{privateProperties:["width","height"],customProperties:{"badge":{set:function(c,v){c.addCustomData(new B({value:v}));}}}});b.prototype.refresh=function(){this._getControl().refresh();};b.prototype.loadDesigntime=function(){return this._getControl().loadDesigntime();};a.define("ui-integration-card",b);});
},
	"sap/ui/integration/customElements/CustomElementCardEditor.js":function(){sap.ui.require(["sap/ui/integration/designtime/editor/CardEditor","sap/ui/integration/customElements/CustomElementBase"],function(C,a){"use strict";var b=a.extend(C,{});b.prototype.getCurrentSettings=function(){return this._getControl().getCurrentSettings();};var d=["ui-integration-card"];a.define("ui-integration-card-editor",b,d);});
},
	"sap/ui/integration/library-bootstrap.js":function(){(function(w){"use strict";var c;var s=document.currentScript||document.querySelector("script[src*='/sap-ui-integration.js']");
function b(){if(w.sap&&w.sap.ui&&w.sap.ui.getCore){c=w.sap.ui.getCore();return a();}w.sap.ui.require(['sap/ui/core/Core'],function(C){C.boot();c=C;C.attachInit(function(){a();});});}
function r(l){var L=c.getLoadedLibraries()[l];var t=Object.keys(L.customElements),T=s.getAttribute("tags");if(T){t=T.split(",");}w.sap.ui.require(t.map(function(o,i){return L.customElements[t[i]];}));}
function a(){c.loadLibraries(["sap/ui/integration"],{async:true}).then(function(){r("sap.ui.integration");});}
b();})(window);
},
	"sap/ui/integration/sap-ui-integration-config.js":function(){window["sap-ui-config"]=window["sap-ui-config"]||{};window["sap-ui-config"].bindingSyntax="complex";window["sap-ui-config"].compatVersion="edge";window["sap-ui-config"].async=true;window["sap-ui-config"]["xx-waitForTheme"]=true;
},
	"sap/ui/integration/sap-ui-integration-define-nojQuery.js":function(){(function(){"use strict";sap["ui"].define("sap/ui/thirdparty/jquery",function(){return jQuery;});sap["ui"].define("sap/ui/thirdparty/jqueryui/jquery-ui-position",function(){return jQuery;});})();
}
},"sap/ui/integration/library-preload"
);
//# sourceMappingURL=library-preload.js.map