/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/core/Control","./library","sap/ui/core/ResizeHandler","./AlignedFlowLayoutRenderer","sap/ui/dom/units/Rem"],function(C,a,l,R,A,b){"use strict";var c=a.extend("sap.ui.layout.AlignedFlowLayout",{metadata:{library:"sap.ui.layout",properties:{minItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"12rem"},maxItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"24rem"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},endContent:{type:"sap.ui.core.Control",multiple:true}}}});c.prototype.init=function(){if(typeof ResizeObserver==="function"){this.oResizeObserver=new ResizeObserver(this.onResize.bind(this));this.fLayoutWidth=0;this.fEndItemWidth=0;}else{this._sResizeHandlerContainerListenerID=R.register(this,this.onResizeHandler.bind(this));}this.fnReflow=this.reflow.bind(this);this.bReflowSuspended=false;};c.prototype.exit=function(){this.fnReflow=null;this.disconnectResizeObserver();this.oResizeObserver=null;this.fLayoutWidth=undefined;this.fEndItemWidth=undefined;this.disconnectResizeHandler();this._sResizeHandlerContainerListenerID="";this._sResizeHandlerEndItemListenerID="";};c.prototype.onAfterRenderingOrThemeChanged=function(){window.requestAnimationFrame(function(){var d=this.getDomRef(),e=this.getDomRef("endItem"),E=!!(this.hasContent()&&d&&e);if(E){var L=window.getComputedStyle(d,null),i=L.getPropertyValue("padding-top"),m=e.style;if(C.getConfiguration().getRTL()){m.left=L.getPropertyValue("padding-left");}else{m.right=L.getPropertyValue("padding-right");}m.bottom=i;}var D={domRef:d,endItemDomRef:e};this.reflow(D);}.bind(this));};c.prototype.onBeforeRendering=function(){this.disconnectResizeObserver();this.disconnectResizeHandlerForEndItem();};c.prototype.onAfterRendering=function(){this.observeSizeChangesIfRequired();this.onAfterRenderingOrThemeChanged();};c.prototype.onThemeChanged=c.prototype.onAfterRenderingOrThemeChanged;c.prototype.onResizeHandler=function(e){if(e.size.width!==e.oldSize.width){this.reflow();}};c.prototype.onResize=function(o){var d=this.getDomRef();this.bReflowSuspended=this.bReflowSuspended||this.unobserveSizeChangesIfReflowSuspended(d);if(this.bReflowSuspended){return;}var e,O=o[0],w=h(this.fLayoutWidth,O,d),n=O.contentRect.width;if(w){this.fLayoutWidth=n;}else{e=this.getDomRef("endItem");w=h(this.fEndItemWidth,O,e);if(w){this.fEndItemWidth=n;}else{return;}}window.requestAnimationFrame(function(){var D={domRef:d,endItemDomRef:e};this.reflow(D);}.bind(this));};c.prototype.reflow=function(d){if(this.bReflowSuspended){this.bReflowSuspended=false;if(this.oResizeObserver){this.observeSizeChangesIfRequired();}}var e=this.getContent();if((e.length===0)||!e[0].isActive()){return;}d=d||{};var D=d.domRef||this.getDomRef();if(!D){return;}var E=d.endItemDomRef||this.getDomRef("endItem"),L=this.getLastItemDomRef();if(!E||!L){if(!D.offsetParent){return;}this.toggleDisplayOfSpacers(D);return;}var o=D.lastElementChild;r(D,o);if(!D.offsetParent){return;}var m=o.style,i=E.offsetHeight,f=E.offsetWidth,g=L.offsetTop,j=L.offsetLeft,k,n;if(C.getConfiguration().getRTL()){n=j;}else{var p=Number.parseFloat(window.getComputedStyle(L).marginRight);var q=j+L.offsetWidth+p;n=D.offsetWidth-q;}var s=n>=f;if(s){if(this.checkItemsWrapping(D)){if(E.offsetTop<g){m.height=Math.max(0,i-g)+"px";if(L.offsetTop>=E.offsetTop){k=E.offsetLeft;j=L.offsetLeft;if((k>=j)&&(k<=(j+L.offsetWidth))){m.height=i+"px";}}m.display="block";}else{m.height="0";m.display="";}}else{if(E.offsetTop<g){m.height=i+"px";}m.display="block";}}else{m.height=i+"px";m.display="block";}var t=f+"px";m.width=t;m.minWidth=t;this.toggleDisplayOfSpacers(D);};c.prototype.toggleDisplayOfSpacers=function(d){var e=this.getRenderer().CSS_CLASS+"OneLine",E=true;if(this.checkItemsWrapping(d,E)){d.classList.remove(e);}else{d.classList.add(e);}};function h(o,O,t){var W=0.25,n=O.contentRect.width;return(t===O.target)&&(Math.abs(n-o)>=W);}function r(d,L){var m=L&&L.style;if(m){m.width="";m.height="";m.display="";}d.classList.remove(d.classList.item(0)+"OneLine");}c.prototype.checkItemsWrapping=function(d,e){d=d||this.getDomRef();if(!d){return false;}var f=d.firstElementChild,L=this.getLastItemDomRef();if(!f||!L){return false;}var F=f.offsetTop,i=L.offsetTop,g=f.offsetHeight;if(i>=(F+g)){return true;}if(e){return false;}var E=this.getDomRef("endItem");return!!E&&(E.offsetTop>=(F+g));};c.prototype.getLastItemDomRef=function(){var d=this.getContent(),i=d.length;if(i){var o=d[i-1],e=o.getDomRef();if(e){return e.parentElement;}}return null;};c.prototype.getLastVisibleDomRef=function(){return this.getDomRef("endItem")||this.getLastItemDomRef();};c.prototype.computeNumberOfSpacers=function(){var i=this.getContent().length;if(i===0){return 0;}var s=i,m=this.getMinItemWidth(),M;if(m.lastIndexOf("rem")!==-1){M=b.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}if(M){var d=Math.max(document.documentElement.clientWidth,window.screen.width);s=Math.abs(d/M);}s=Math.min(s,i-1);s=Math.max(1,s);s=Math.floor(s);return s;};c.prototype.observeSizeChangesIfRequired=function(){if(this.hasContent()){this.observeSizeChanges();}};c.prototype.observeSizeChanges=function(){var d=this.getDomRef();if(!d){return;}var e=this.getDomRef("endItem");if(this.oResizeObserver){this.oResizeObserver.observe(d);if(e){this.oResizeObserver.observe(e);}return;}if(e){this._sResizeHandlerEndItemListenerID=R.register(e,this.onResizeHandler.bind(this));}};c.prototype.unobserveSizeChanges=function(d){if(this.oResizeObserver&&d){this.oResizeObserver.unobserve(d);}};c.prototype.unobserveSizeChangesIfReflowSuspended=function(d){var e=R.isSuspended(d,this.fnReflow);if(e){this.unobserveSizeChanges(d);this.unobserveSizeChanges(this.getDomRef("endItem"));return true;}return false;};c.prototype.disconnectResizeObserver=function(){if(this.oResizeObserver){this.oResizeObserver.disconnect();}};c.prototype.disconnectResizeHandler=function(){if(this._sResizeHandlerContainerListenerID){R.deregister(this._sResizeHandlerContainerListenerID);}this.disconnectResizeHandlerForEndItem();};c.prototype.disconnectResizeHandlerForEndItem=function(){if(this._sResizeHandlerEndItemListenerID){R.deregister(this._sResizeHandlerEndItemListenerID);}};c.prototype.hasContent=function(){return this.getContent().length>0;};return c;});
