/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/p13n/P13nBuilder','sap/ui/core/library','sap/ui/mdc/p13n/AdaptationController','sap/ui/mdc/p13n/FlexUtil','sap/ui/Device','sap/ui/mdc/Control','sap/base/util/merge','sap/base/util/deepEqual','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/base/Log','sap/ui/mdc/condition/ConditionModel','sap/ui/mdc/condition/Condition','sap/ui/mdc/util/IdentifierUtil','sap/ui/mdc/condition/ConditionConverter','sap/m/MessageBox',"sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/mdc/p13n/StateUtil","sap/ui/mdc/condition/FilterConverter","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/mdc/util/FilterUtil","sap/m/Button","sap/m/library"],function(P,c,A,F,D,C,m,d,M,a,L,b,e,I,f,g,h,j,S,k,l,n,B,o){"use strict";var V=c.ValueState;var p=C.extend("sap.ui.mdc.filterbar.FilterBarBase",{metadata:{library:"sap.ui.mdc",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},liveMode:{type:"boolean",defaultValue:false},showMessages:{type:"boolean",group:"Misc",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},filterConditions:{type:"object",defaultValue:{}},suspendSelection:{type:"boolean",defaultValue:false},_filterCount:{type:"string",visibility:"hidden"}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false},layout:{type:"sap.ui.mdc.filterbar.IFilterContainer",multiple:false,visibility:"hidden"}},associations:{variantBackreference:{type:"sap.ui.fl.variants.VariantManagement",multiple:false}},events:{search:{conditions:{type:"object"}},filtersChanged:{conditionsBased:{type:"boolean"},filtersText:{type:"string"},filtersTextExpanded:{type:"string"}}}}});var q=o.ButtonType;p.INNER_MODEL_NAME="$sap.ui.filterbar.mdc.FilterBarBase";p.CONDITION_MODEL_NAME="$filters";var E={NoError:-1,RequiredHasNoValue:0,FieldInErrorState:1,AsyncValidation:2};p.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._createInnerModel();this._oObserver=new a(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems"]});this._createInnerLayout();this._bPersistValues=false;this._aProperties=null;this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(function(r){this._fResolveInitialFiltersApplied=r;}.bind(this));this._bIgnoreChanges=false;this._oAdaptationController=null;this._bSearchTriggered=false;this.setProperty("adaptationConfig",{liveMode:false,retrievePropertyInfo:this._getNonHiddenPropertyInfoSet,itemConfig:{changeOperations:{add:"addFilter",remove:"removeFilter",move:"moveFilter"}},onReset:function(){this.getAdaptationController().resetP13n().then(function(){this.getInbuiltFilter()._setXConditions(this.getFilterConditions(),true);}.bind(this));},filterConfig:{changeOperations:{add:"addFilter",remove:"removeFilter",move:"moveFilter"},adaptationUI:this.retrieveInbuiltFilter,applyFilterChangeOn:this,containerSettings:{verticalScrolling:false,title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_TITLE")}}});};p.prototype._createInnerLayout=function(){this._cLayoutItem=null;this._oFilterBarLayout=null;this._bPersistValues=false;this._btnAdapt=null;this.setAggregation("layout",this._oFilterBarLayout,true);};p.prototype._isPhone=function(){return(D.system.phone)?true:false;};p.prototype._isLiveMode=function(){if(this._isPhone()){return false;}return this.getLiveMode();};p.prototype._getConditionModel=function(){return this._oConditionModel;};p.prototype._getSearchButton=function(){if(!this._btnSearch){this._btnSearch=new B(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:q.Emphasized});}return this._btnSearch;};p.prototype.getConditionModelName=function(){return this._getConditionModelName();};p.prototype._getConditionModelName=function(){return p.CONDITION_MODEL_NAME;};p.prototype._createConditionModel=function(){this._oConditionModel=new b();this.setModel(this._oConditionModel,this._getConditionModelName());};p.prototype.applySettings=function(s,i){C.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModel.attachPropertyChange(this._handleConditionModelPropertyChange,this);this._retrieveMetadata().then(function(){this._applyInitialFilterConditions();}.bind(this));};p.prototype.setSuspendSelection=function(v){this.setProperty("suspendSelection",v);if(!v){if(this._bSearchTriggered){this._bSearchTriggered=false;this.triggerSearch();}}return this;};p.prototype._createInnerModel=function(){this._oModel=new M(this);this.setModel(this._oModel,p.INNER_MODEL_NAME);return this;};p.prototype.getCurrentState=function(){var s={};if(this._bPersistValues){var i=[];var r=m({},this.getFilterConditions());for(var K in r){if(!this._getPropertyByName(K)){i.push(K);}}i.forEach(function(K){delete r[K];});s.filter=r;}var t=this.getFilterItems();var u=[];t.forEach(function(v,w){u.push({name:v.getFieldPath()});});s.items=u;return s;};p.prototype.getAssignedFilterNames=function(){var N,i=null,r=this._getConditionModel();if(r){i=[];var s=r.getConditions("$search");if(s&&s.length>0){i.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"));}this._getNonHiddenPropertyInfoSet().forEach(function(t){N=I.getPropertyKey(t);var s=r.getConditions(N);if(s&&s.length>0){i.push(t.label||N);}});}return i;};p.prototype._getAssignedFiltersText=function(){var t={};t.filtersText=this._getAssignedFiltersCollapsedText(this.getAssignedFilterNames());t.filtersTextExpanded=this._getAssignedFiltersExpandedText();return t;};p.prototype._getAssignedFiltersExpandedText=function(){var i=0,r=0,s=this._getConditionModel();if(s){var t=s.getAllConditions();for(var u in t){var v=this._getPropertyByName(u);if(v&&!v.hiddenFilter&&(t[u].length>0)){++i;if(!(((u==="$search")&&this.getAggregation("basicSearchField"))||this._getFilterField(u))){++r;}}}}if(!i&&!r){return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");}if(!r){if(i===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_NON_HIDDEN",[i]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_NON_HIDDEN",[i]);}if((i===1)){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_HIDDEN",[i,r]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_HIDDEN",[i,r]);};p.prototype._getAssignedFiltersCollapsedText=function(r){var s;r=r||[];if(r.length){s=Object.keys(r).map(function(i){return r[i];}).join(", ");if(r.length===1){return this._oRb.getText("filterbar.ADAPT_FILTER_COLLAPSED",[r.length,s]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_COLLAPSED",[r.length,s]);}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");};p.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText();};p.prototype._reportModelChange=function(t){this._handleAssignedFilterNames();if(this.getLiveMode()||t){this.triggerSearch();}};p.prototype._isFlexSupported=function(i){return j.isFlexSupported({element:this});};p.prototype._handleConditionModelPropertyChange=function(i){if(!this._bIgnoreChanges){var s=i.getParameter("path");if(s.indexOf("/conditions/")===0){var r=s.substring("/conditions/".length);if(this._bPersistValues&&this._isFlexSupported()){var O={};O[r]=this._stringifyConditions(r,i.getParameter("value"));this._cleanupConditions(O[r]);this.retrieveAdaptationController().then(function(t){t.createConditionChanges(O);});}else{this._reportModelChange(false);}}}};p.prototype._toExternal=function(i,r){var s=m({},r);s=f.toString(s,i.typeConfig,this.getTypeUtil());this._cleanupCondition(s);if(r.inParameters&&(Object.keys(r.inParameters).length>0)){Object.keys(r.inParameters).forEach(function(K){var t=this._getPropertyByName(K);if(t){var u=e.createCondition("EQ",[r.inParameters[K]]);var v=f.toString(u,t.typeConfig,this.getTypeUtil());if(!s.inParameters){s.inParameters={};}s.inParameters[K]=v.values[0];}else{L.error("mdc.FilterBar._toExternal: could not find property info for "+K);}}.bind(this));}if(r.outParameters&&(Object.keys(r.outParameters).length>0)){Object.keys(r.outParameters).forEach(function(K){var O=this._getPropertyByName(K);if(O){var t=e.createCondition("EQ",[r.outParameters[K]]);var u=f.toString(t,O.typeConfig,this.getTypeUtil());if(!s.outParameters){s.outParameters={};}s.outParameters[K]=u.values[0];}else{L.error("mdc.FilterBar._toExternal: could not find property info for "+K);}}.bind(this));}return s;};p.prototype._toInternal=function(i,r){var s=m({},r);s=f.toType(s,i.typeConfig,this.getTypeUtil());if(r.inParameters&&(Object.keys(r.inParameters).length>0)){Object.keys(r.inParameters).forEach(function(K){var t=this._getPropertyByName(K);if(t){var u=e.createCondition("EQ",[r.inParameters[K]]);var v=f.toType(u,t.typeConfig,this.getTypeUtil());if(!s.inParameters){s.inParameters={};}s.inParameters[K]=v.values[0];}else{L.error("mdc.FilterBar._toInternal: could not find property info for "+K);}}.bind(this));}if(r.outParameters&&(Object.keys(r.outParameters).length>0)){Object.keys(r.outParameters).forEach(function(K){var O=this._getPropertyByName(K);if(O){var t=e.createCondition("EQ",[r.outParameters[K]]);var v=f.toType(t,O.typeConfig,this.getTypeUtil());if(!s.outParameters){s.outParameters={};}s.outParameters[K]=v.values[0];}else{L.error("mdc.FilterBar._toInternal: could not find property info for "+K);}}.bind(this));}return s;};p.prototype._cleanupCondition=function(i){if(i){if(i.hasOwnProperty("isEmpty")){delete i.isEmpty;}}};p.prototype._cleanupConditions=function(i){if(i){i.forEach(function(r){this._cleanupCondition(r);},this);}};p.prototype._stringifyCondition=function(i,r){var R=r;if(r&&r.values){if(r.values.length>0){R=this._toExternal(i,r);}else{R=m({},r);this._cleanupCondition(R);}}return R;};p.prototype._stringifyConditions=function(s,i){var r=this._getPropertyByName(s);var R=i;if(r&&i){R=[];i.forEach(function(t){R.push(this._stringifyCondition(r,t));},this);}return R;};p.prototype._handleAssignedFilterNames=function(i){if(!this._oMetadataAppliedPromise){return;}this._oMetadataAppliedPromise.then(function(){if(this._bIsBeingDestroyed){return;}if(!i){if(this._btnAdapt){var r=this.getAssignedFilterNames();this.setProperty("_filterCount",this._oRb.getText(r.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",r.length),false);}}var t=this._getAssignedFiltersText();var O={conditionsBased:!i,filtersText:t.filtersText,filtersTextExpanded:t.filtersTextExpanded};this.fireFiltersChanged(O);}.bind(this));};p.prototype.onReset=function(i){this._getConditionModel().oConditionModel.removeAllConditions();};p.prototype.onSearch=function(i){this.triggerSearch();};p.prototype.triggerSearch=function(){return this.valid(true);};p.prototype.valid=function(i){i=typeof i=="boolean"?i:true;if(this.getSuspendSelection()&&i){this._bSearchTriggered=true;return Promise.resolve();}return this.initialized().then(function(){if(!this._oSearchPromise){this._oSearchPromise=new Promise(function(s,t){this._fResolvedSearchPromise=s;this._fRejectedSearchPromise=t;}.bind(this));var r=function(){this._validate(i);this._oSearchPromise=null;};setTimeout(r.bind(this),0);}return this._oSearchPromise;}.bind(this));};p.prototype._clearDelayedSearch=function(){if(this._iDelayedSearchId){clearTimeout(this._iDelayedSearchId);this._iDelayedSearchId=null;}};p.prototype._getRequiredFieldsWithoutValues=function(){var r=[];this._getRequiredPropertyNames().forEach(function(N){var i=this._getConditionModel().getConditions(N);if(!i||i.length===0){r.push(N);}}.bind(this));return r;};p.prototype._checkAsyncValidation=function(){var r=E.NoError;if(this._aFIChanges&&this._aFIChanges.length>0){r=E.AsyncValidation;}return r;};p.prototype._checkRequiredFields=function(){var r=E.NoError;var R=this._getRequiredFieldsWithoutValues();R.forEach(function(N){var i=this._getFilterField(N);if(i){if(i.getValueState()===V.None){i.setValueState(V.Error);i.setValueStateText(this._oRb.getText("filterbar.REQUIRED_FILTER_VALUE_MISSING"));}}else{L.error("Mandatory filter field '"+N+"' not visible on FilterBarBase has no value.");}r=E.RequiredHasNoValue;}.bind(this));return r;};p.prototype._checkFieldsInErrorState=function(){var r=E.NoError;this._getNonRequiredPropertyNames().some(function(N){var i=this._getFilterField(N);if(i&&(i.getValueState()!==V.None)){r=E.FieldInErrorState;}return r!==E.NoError;}.bind(this));return r;};p.prototype._handleFilterItemSubmit=function(i){var r=i.getParameter("promise");if(r){r.then(function(){this.triggerSearch();}.bind(this));}};p.prototype._handleFilterItemChanges=function(i){if(this._bIgnoreChanges){return;}var r=i.oSource;if(r.getRequired()&&(r.getValueState()===V.Error)&&i.getParameter("valid")){r.setValueState(V.None);return;}if(!this._aFIChanges){this._aFIChanges=[];}this._aFIChanges.push({name:r.getFieldPath(),promise:i.getParameter("promise")});};p.prototype._checkFilters=function(){var r=this._checkAsyncValidation();if(r!==E.NoError){return r;}r=this._checkRequiredFields();if(r!==E.NoError){return r;}r=this._checkFieldsInErrorState();if(r!==E.NoError){return r;}return r;};p.prototype._setFocusOnFirstErroneousField=function(){this.getFilterItems().some(function(i){if(i.getValueState()!==V.None){setTimeout(i["focus"].bind(i),0);return true;}return false;});};p.prototype._handleAsyncValidation=function(i){if(this._aFIChanges&&(this._aFIChanges.length>0)){var N=this._aFIChanges.slice();this._aFIChanges=null;var r=[];N.forEach(function(s){r.push(s.promise);});Promise.all(r).then(function(s){s.forEach(function(t,u){var v=this._getFilterField(N[u].name);if(v&&v.getRequired()&&(v.getValueState()===V.Error)){v.setValueState(V.None);}},this);this._validate(i);}.bind(this),function(s){this._validate(i);}.bind(this));}};p.prototype._validate=function(i){var s,r;r=this._checkFilters();if(r===E.AsyncValidation){this._handleAsyncValidation(i);return;}var t=function(){this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null;}.bind(this);if(r===E.NoError){if(i){this.fireSearch();}this._fResolvedSearchPromise();t();}else{if(r===E.RequiredHasNoValue){s=this._oRb.getText("filterbar.REQUIRED_CONDITION_MISSING");}else{s=this._oRb.getText("filterbar.VALIDATION_ERROR");}if(this.getShowMessages()&&!this._isLiveMode()){try{g.error(s,{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":"",onClose:this._setFocusOnFirstErroneousField.bind(this)});}catch(x){L.error(x.message);}}else{L.warning("search was not triggered. "+s);}this._fRejectedSearchPromise();t();}};p.prototype.setInternalConditions=function(i){var r=this._getConditionModel();if(r){r.setConditions(i);}};p.prototype.getInternalConditions=function(){return this._getModelConditions(this._getConditionModel(),true);};p.prototype.hasProperty=function(N){return this._getPropertyByName(N);};p.prototype.waitForInitialization=function(){return Promise.all([this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]);};p.prototype.initialized=function(){return this.waitForInitialization();};p.prototype._getModelConditions=function(i,r,K){var s={};if(i){var t=i.getAllConditions();for(var u in t){if(t[u]&&(K||t[u].length>0)){s[u]=m([],t[u]);if(!r){this._cleanupConditions(s[u]);var v=this._stringifyConditions(u,s[u]);s[u]=v;}}}}return s;};p.prototype.removeCondition=function(s,x){return this.initialized().then(function(){var i=this._getConditionModel();if(i){var r=this._getPropertyByName(s);if(r){var t=this._toInternal(r,x);if(i.indexOf(s,t)>=0){i.removeCondition(s,t);}}}}.bind(this));};p.prototype.addCondition=function(s,x){return this.initialized().then(function(){var i=this._getConditionModel();if(i){var r=this._getPropertyByName(s);if(r){var t=this._toInternal(r,x);if(i.indexOf(s,t)<0){var u=[{sFieldPath:r}];S.checkConditionOperatorSanity(u);if(u&&u.length>0){this._cleanUpFilterFieldInErrorStateByName(s);i.addCondition(s,t);}}}}}.bind(this));};p.prototype._setXConditions=function(i,r){var s,t,u=this._getConditionModel();if(r){u.removeAllConditions();}if(i){for(var v in i){t=i[v];s=this._getPropertyByName(v);if(s){if(t.length===0){u.removeAllConditions(v);}else{t.forEach(function(w){if(s.maxConditions!==-1){u.removeAllConditions(v);}var N=this._toInternal(s,w);u.addCondition(v,N);}.bind(this));}}}}};p.prototype._getXConditions=function(){return this._getModelConditions(this._getConditionModel(),false);};p.prototype._storeChanges=function(i){if(i&&i.length){var H=j.hasVariantManagement({element:this});try{h.add({changes:i,ignoreVariantManagement:!H});}catch(r){L.error("error while saving changes - "+r.message);}}};p.prototype._getRequiredPropertyNames=function(){var r=[];this._getNonHiddenPropertyInfoSet().forEach(function(i){if(i.required){r.push(I.getPropertyKey(i));}});return r;};p.prototype._getNonRequiredPropertyNames=function(){var N=[];this._getNonHiddenPropertyInfoSet().forEach(function(i){if(!i.required){N.push(I.getPropertyKey(i));}});return N;};p.prototype._insertFilterFieldtoContent=function(i,r){if(!this._cLayoutItem){return;}var s=this._cLayoutItem;var t=new s();t.setFilterField(i);this._oFilterBarLayout.insertFilterField(t,r);};p.prototype._filterItemInserted=function(i){if(!i.getVisible()){return;}if(i.setWidth){i.setWidth("");}this._applyFilterItemInserted(i);this._handleAssignedFilterNames(true);};p.prototype._applyFilterItemInserted=function(r){var s,t;t=this.indexOfAggregation("filterItems",r);if(this.getAggregation("basicSearchField")){t++;}s=t;var u=this.getFilterItems();for(var i=0;i<s;i++){if(!u[i].getVisible()){t--;}}this._insertFilterFieldtoContent(r,t);if(!this._oObserver.isObserved(r,{properties:["visible"]})){this._oObserver.observe(r,{properties:["visible"]});}};p.prototype._filterItemRemoved=function(i){this._applyFilterItemRemoved(i.getFieldPath());this._handleAssignedFilterNames(true);};p.prototype._applyFilterItemRemoved=function(s){this._removeFilterFieldFromContentByName(s);};p.prototype._removeFilterFieldFromContent=function(i){this._removeFilterFieldFromContentByName(i.getFieldPath());};p.prototype._removeFilterFieldFromContentByName=function(s){var i=this._getFilterItemLayoutByName(s);if(i){this._oFilterBarLayout.removeFilterField(i);i.destroy();}};p.prototype._observeChanges=function(i){if(i.type==="aggregation"&&i.name==="filterItems"){switch(i.mutation){case"insert":i.child.attachChange(this._handleFilterItemChanges,this);i.child.attachSubmit(this._handleFilterItemSubmit,this);this._filterItemInserted(i.child);break;case"remove":i.child.detachChange(this._handleFilterItemChanges,this);i.child.detachSubmit(this._handleFilterItemSubmit,this);this._filterItemRemoved(i.child);break;default:L.error("operation "+i.mutation+" not yet implemented");}}else if(i.type==="property"){var r;if(i.object.isA&&i.object.isA("sap.ui.mdc.FilterField")){r=i.object;if(r){if(i.current){this._filterItemInserted(r);}else{this._filterItemRemoved(r);}this._oFilterBarLayout.rerender();}}}};p.prototype._getFilterItemLayout=function(i){return this._getFilterItemLayoutByName(i.getFieldPath());};p.prototype._getFilterItemLayoutByName=function(s){var i=null;if(this._oFilterBarLayout){this._oFilterBarLayout.getFilterFields().some(function(r){if(r._getFieldPath()===s){i=r;}return i!==null;});}return i;};p.prototype._getFilterField=function(N){var i=null;this.getFilterItems().some(function(r){if(r&&r.getFieldPath&&(r.getFieldPath()===N)){i=r;}return i!==null;});return i;};p.prototype._retrieveMetadata=function(){if(this._oMetadataAppliedPromise){return this._oMetadataAppliedPromise;}this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise(function(r){this._fResolveMetadataApplied=r;}.bind(this));this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){this._aProperties=[];var r=function(){this._fResolveMetadataApplied();this._fResolveMetadataApplied=null;}.bind(this);if(this.bDelegateInitialized&&this.getControlDelegate().fetchProperties){try{this.getControlDelegate().fetchProperties(this).then(function(s){this._aProperties=s;r();}.bind(this),function(s){L.error(s);r();});}catch(i){L.error("Exception during fetchProperties occured: "+i.message);r();}}else{L.error("Provided delegate '"+this.getDelegate().path+"' not valid.");r();}}}.bind(this));return this._oMetadataAppliedPromise;};p.prototype.setBasicSearchField=function(i){var O=this.getAggregation("basicSearchField");if(O){this._removeFilterFieldFromContent(O);O.detachSubmit(this._handleFilterItemSubmit,this);}this.setAggregation("basicSearchField",i);if(i){i.attachSubmit(this._handleFilterItemSubmit,this);if(!this._oObserver.isObserved(i,{properties:["visible"]})){this._oObserver.observe(i,{properties:["visible"]});}this._insertFilterFieldtoContent(i,0);}return this;};p.prototype.getPropertyInfoSet=function(){return this._aProperties||[];};p.prototype._getNonHiddenPropertyInfoSet=function(){var v=[];this.getPropertyInfoSet().every(function(i){if(!i.hiddenFilter){if(I.getPropertyKey(i)!=="$search"){v.push(i);}}return true;});return v;};p.prototype._getNonHiddenPropertyByName=function(N){var i=null;this._getNonHiddenPropertyInfoSet().some(function(r){if(I.getPropertyKey(r)===N){i=r;}return i!=null;});return i;};p.prototype._getPropertyByName=function(N){return n.getPropertyByKey(this.getPropertyInfoSet(),N);};p.prototype._cleanUpFilterFieldInErrorStateByName=function(s){var i=null;var r=this.getFilterItems();r.some(function(t){if(t.getFieldPath()===s){i=t;}return i!=null;});if(i){this._cleanUpFilterFieldInErrorState(i);}};p.prototype._cleanUpAllFilterFieldsInErrorState=function(){var i=this.getFilterItems();i.forEach(function(r){this._cleanUpFilterFieldInErrorState(r);}.bind(this));};p.prototype._cleanUpFilterFieldInErrorState=function(i){if(i.getRequired()&&(i.getValueState()!==V.None)){i.setValueState(V.None);}};p.prototype.applyConditionsAfterChangesApplied=function(){if(this._isChangeApplying()){return;}this._bIgnoreChanges=true;this._oFlexPromise=this._getWaitForChangesPromise();Promise.all([this._oFlexPromise,this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]).then(function(v){this._oFlexPromise=null;this._changesApplied();}.bind(this));};p.prototype._getWaitForChangesPromise=function(){return j.waitForChanges({element:this});};p.prototype._suspendBinding=function(i){if(i){var r=i.getBinding("conditions");if(r){if(!this._aBindings){this._aBindings=[];}r.suspend();this._aBindings.push(i);}}};p.prototype._resumeBindings=function(){if(this._aBindings){this._aBindings.forEach(function(i){if(!i.bIsDestroyed){var r=i.getBinding("conditions");if(r){r.resume();}}});this._aBindings=null;}};p.prototype._isChangeApplying=function(){return!!this._oFlexPromise;};p.prototype._applyInitialFilterConditions=function(){this._bIgnoreChanges=true;this._applyFilterConditionsChanges();this._changesApplied();this._bInitialFiltersApplied=true;this._fResolveInitialFiltersApplied();this._fResolveInitialFiltersApplied=null;};p.prototype._applyFilterConditionsChanges=function(){var i;var s=this.getProperty("filterConditions");if(Object.keys(s).length>0){i=m([],s);this._setXConditions(i,true,true);}};p.prototype.setVariantBackreference=function(v){if(!this._hasAssignedVariantManagement()){this.setAssociation("variantBackreference",v);l.attachVariantApplied({selector:this,vmControlId:this.getVariantBackreference(),callback:this._handleVariantSwitch.bind(this),callAfterInitialVariant:true});}else{L.error("the association 'variant' may only be assigned once and may not change afterwards.");}};p.prototype._handleVariantSwitch=function(v){this._cleanUpAllFilterFieldsInErrorState();this._bExecuteOnSelect=false;if(v.hasOwnProperty("executeOnSelect")&&v.executeOnSelect){this._bExecuteOnSelect=true;}if(!this._oFlexPromise&&this._bInitialFiltersApplied){this._changesApplied();}};p.prototype._hasAssignedVariantManagement=function(){var v=this.getVariantBackreference();if(v&&sap.ui.getCore().byId(v)&&sap.ui.getCore().byId(v).isA("sap.ui.fl.variants.VariantManagement")){return true;}return false;};p.prototype._changesApplied=function(){this._bIgnoreChanges=false;this._bIgnoreChanges=false;this._reportModelChange(this._bExecuteOnSelect);this._bExecuteOnSelect=undefined;};p.prototype._getView=function(){return I.getView(this);};p.prototype.getConditions=function(){var i=this._bPersistValues?this.getCurrentState().filter:this._getXConditions();if(i&&i["$search"]){delete i["$search"];}return i;};p.prototype.getSearch=function(){var s=this._getConditionModel()?this._getConditionModel().getConditions("$search"):[];return s[0]?s[0].values[0]:"";};p.prototype.exit=function(){if(this._hasAssignedVariantManagement()){l.detachVariantApplied({selector:this,vmControlId:this.getVariantBackreference()});}if(this.bDelegateInitialized&&this.getControlDelegate().cleanup){this.getControlDelegate().cleanup(this);}C.prototype.exit.apply(this,arguments);this._clearDelayedSearch();this._oFilterBarLayout=null;this._cLayoutItem=null;this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null;}if(this._oConditionModel){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);this._oConditionModel.destroy();this._oConditionModel=null;}this._oObserver.disconnect();this._oObserver=undefined;this._bPersistValues=null;this._oDelegate=null;this._aProperties=null;this._oFlexPromise=null;this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._oInitialFiltersAppliedPromise=null;this._oSearchPromise=null;this._aBindings=null;};return p;});
