/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/UriParameters","sap/ui/base/ManagedObject","sap/ui/mdc/p13n/FlexUtil","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/base/Log","./P13nBuilder"],function(S,M,F,J,m,L,P){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var u=new S(window.location.search);var A=M.extend("sap.ui.mdc.AdaptationController",{library:"sap.ui.mdc",metadata:{properties:{adaptationControl:{type:"object"},liveMode:{type:"boolean",defaultValue:false},itemConfig:{type:"object"},sortConfig:{type:"object",defaultValue:{changeOperations:{add:"addSort",remove:"removeSort",move:"moveSort"},adaptationUI:"sap/ui/mdc/p13n/panels/SortPanel",containerSettings:{title:r.getText("sort.PERSONALIZATION_DIALOG_TITLE")}}},filterConfig:{type:"object",defaultValue:{adaptationUI:null,initializeControl:null,containerSettings:{title:r.getText("filter.PERSONALIZATION_DIALOG_TITLE")}}},stateRetriever:{type:"function"},retrievePropertyInfo:{type:"function"},afterChangesCreated:{type:"function"},onReset:{type:"function"}},events:{beforeP13nContainerOpens:{container:{type:"object"}},afterP13nContainerCloses:{container:{type:"object"},reason:{type:"string"}}}}});A.prototype.init=function(){this.oAdaptationModel=new J();this.oAdaptationModel.setSizeLimit(10000);this.oState={};this.bIsDialogOpen=false;};A.prototype.showP13n=function(s,p){if(u.getAll("sap-ui-xx-p13nLiveMode")[0]==="true"){this.setLiveMode(true);L.warning("Please note that the p13n liveMode is experimental");}if(!this.bIsDialogOpen){this.bIsDialogOpen=true;return this._retrievePropertyInfo().then(function(a){return this.createP13n(p,a).then(function(o){var v=u.getAll("sap-ui-xx-filterView")[0];if(v==="list"&&o&&o.getContent()[0]&&o.getContent()[0]._oFilterBarLayout&&o.getContent()[0]._oFilterBarLayout.getInner().isA("sap.ui.mdc.p13n.panels.GroupPanelBase")){o.getContent()[0]._oFilterBarLayout.getInner().switchViewMode("list");}this._openP13nControl(o,s);return o;}.bind(this),function(){this.bIsDialogOpen=false;L.warning("P13n container creation failed");}.bind(this));}.bind(this));}};A.prototype.createP13n=function(p,a){return new Promise(function(b,c){this.aPropertyInfo=a;this._retrieveControl(this.getAdaptationControl().getDelegate().name).then(function(d){if(!(a instanceof Array)){c("Please provide a property info array to create a p13n control");}this.oAdaptationControlDelegate=d;this.sP13nType=p;this._retrieveP13nContainer().then(function(C){var o=C.getContent()[0];var e=this._prepareAdaptationData(a);this._setP13nModelData(e);o.setP13nModel(this.oAdaptationModel);if(o.setLiveMode){o.setLiveMode(this.getLiveMode());}var f=this.getTypeConfig(p).initializeControl;f.call(o).then(function(){this.getAdaptationControl().addDependent(C);b(C);}.bind(this));}.bind(this));}.bind(this),c);}.bind(this));};A.prototype.createSortChanges=function(n,a){return this._executeAfterAsyncActions(function(){var c=m({},this.getStateRetriever().call(this.getAdaptationControl(),this.oAdaptationControlDelegate));var p=c.sorters||[];var s=this.getSortConfig();var f=function(o){return o.name+o.descending;};var b=function(i){return i.hasOwnProperty("sorted")&&i.sorted===false?false:true;};var N=a?n:this._getFilledArray(p,n,"sorted").filter(b);var d=F.getArrayDeltaChanges(p,N,f,this.getAdaptationControl(),s.changeOperations);if(this.getAfterChangesCreated()){this.getAfterChangesCreated()(this,d,"Sort");}return d;}.bind(this));};A.prototype.createItemChanges=function(n){return this._executeAfterAsyncActions(function(){var a=this.getAdaptationControl();var c=m({},this.getStateRetriever().call(a,this.oAdaptationControlDelegate));var p=c.items;var i=this.getItemConfig();var s=function(o){var d=o.name;if(i&&i.additionalDeltaAttributes&&i.additionalDeltaAttributes instanceof Array){i.additionalDeltaAttributes.forEach(function(b){d+=o[b];});}return d;};var f=function(o){return o.hasOwnProperty("visible")&&o.visible===false?false:true;};var N=this._getFilledArray(p,n,"visible").filter(f);var I=F.getArrayDeltaChanges(p,N,s,this.getAdaptationControl(),i.changeOperations);if(this.getAfterChangesCreated()){this.getAfterChangesCreated()(this,I,"Item");}return I;}.bind(this));};A.prototype.createConditionChanges=function(n){return this._executeAfterAsyncActions(function(){var c=[];var C=m({},this.getStateRetriever().call(this.getAdaptationControl(),this.oAdaptationControlDelegate));var p=C.filter;var a=this.getAdaptationControl();for(var f in n){var v=this._hasProperty(f).valid;if(!v){L.warning("property '"+f+"' not supported");continue;}c=c.concat(F.getConditionDeltaChanges(f,n[f],p[f],a));}if(this.getAfterChangesCreated()){this.getAfterChangesCreated()(this,c,"Value");}return c;}.bind(this));};A.prototype._retrievePropertyInfo=function(){return new Promise(function(a,b){if(this.aPropertyInfo){a(this.aPropertyInfo);}else if(this.getRetrievePropertyInfo()){this.aPropertyInfo=this.getRetrievePropertyInfo().call(this.getAdaptationControl());a(this.aPropertyInfo);}else{this._retrieveControl(this.getAdaptationControl().getDelegate().name).then(function(d){this.oAdaptationControlDelegate=d;d.fetchProperties(this.getAdaptationControl()).then(function(p){this.aPropertyInfo=p;a(this.aPropertyInfo);}.bind(this));}.bind(this));}}.bind(this));};A.prototype._executeAfterAsyncActions=function(c){return new Promise(function(a,b){this._retrievePropertyInfo().then(function(p){a(c());});}.bind(this));};A.prototype.getTypeConfig=function(p){var o=this["get"+p+"Config"]?this["get"+p+"Config"]():undefined;return{changeOperations:o?o.changeOperations:{},ignoreIndex:o?o.ignoreIndex:false,adaptationUI:o?o.adaptationUI:undefined,initializeControl:o&&o.initializeControl?o.initializeControl:function(){return Promise.resolve();},containerSettings:o&&o.containerSettings?o.containerSettings:{},sortData:o&&o.hasOwnProperty("sortData")?o.sortData:true};};A.prototype._openP13nControl=function(p,s){this.fireBeforeP13nContainerOpens({container:p});if(this.getLiveMode()){p.openBy(s);}else{p.open();}};A.prototype._getFilledArray=function(p,n,R){var N=m([],p);var a=m([],n);var e=P.arrayToMap(p);a.forEach(function(i){var E=e[i.name];if(!i.hasOwnProperty(R)||i[R]){var b=i.position;if(E){b=b>-1?b:E.position;var o=E.position;N.splice(b,0,N.splice(o,1)[0]);}else{b=b>-1?b:N.length;N.splice(b,0,i);}N[b]=i;}else if(E){N[E.position][R]=false;}});return N;};A.prototype._prepareAdaptationData=function(p){var a=this.getAdaptationControl();var c=m({},this.getStateRetriever().call(a,this.oAdaptationControlDelegate));var i=this._getTypeIgnoreValues(this.sP13nType);var s=this.getTypeConfig(this.sP13nType).sortData;return P.prepareP13nData(c,p,i,s?this.sP13nType:"generic");};A.prototype._getTypeIgnoreValues=function(p){var i;if(this.sP13nType=="Sort"){i=[{ignoreKey:"sortable",ignoreValue:false}];}if(this.sP13nType=="Filter"){i=[{ignoreKey:"filterable",ignoreValue:false}];}return i;};A.prototype._setP13nModelData=function(p){this.oAdaptationModel.setProperty("/items",p.items);this.oAdaptationModel.setProperty("/itemsGrouped",p.itemsGrouped);this.oState=m({},p);};A.prototype.resetP13n=function(){return F.discardChanges({selector:this.getAdaptationControl()}).then(function(){var p=this._prepareAdaptationData(this.aPropertyInfo);this.oState=m({},p);this.oAdaptationModel.setProperty("/items",p.items);this.oAdaptationModel.setProperty("/itemsGrouped",p.itemsGrouped);}.bind(this));};A.prototype._retrieveP13nContainer=function(){return new Promise(function(a,b){var l=this.getLiveMode();var v=this.getTypeConfig(this.sP13nType).adaptationUI;var p=function(o){if(l&&!this.bInitialized&&o.attachChange){o.attachChange(function(){this._handleChange();}.bind(this));}this._createP13nContainer(o).then(function(d){a(d);});}.bind(this);if(typeof v==="string"){var s=v;this._retrieveControl(s).then(function(d){var e=new d();p(e);});}else if(v instanceof Function){var c=v.call(this.getAdaptationControl());if(c instanceof Promise){c.then(function(o){p(o);});}else{p(c);}}else if(v.isA("sap.ui.core.Control")){var o=v;p(o);}else{b(new Error("Please provide either a BasePanel derivation or a custom Control as personalization UI for AdaptationController"));}}.bind(this));};A.prototype._retrieveControl=function(p){return new Promise(function(a,b){sap.ui.require([p],function(C){a(C);},b);});};A.prototype._createP13nContainer=function(p){var c;if(this.getLiveMode()){c=this._createPopover(p);}else{c=this._createModalDialog(p);}return c.then(function(C){C.addStyleClass("sapUiMdcPersonalizationDialog");if(!this.getLiveMode()){C.setEscapeHandler(function(d){this._closeDialog(C,"Cancel");d.resolve();}.bind(this));}C.toggleStyleClass("sapUiSizeCompact",!!jQuery(this.getAdaptationControl()).closest(".sapUiSizeCompact").length);return C;}.bind(this));};A.prototype._addResetInfo=function(s){if(this.getOnReset()){s.reset={title:s.title,onExecute:this.getOnReset().bind(this.getAdaptationControl())};}};A.prototype._createPopover=function(p){var a=function(e){var o=e.getSource();this.fireAfterP13nContainerCloses({reason:"autoclose",container:o});o.destroy();this.bIsDialogOpen=false;}.bind(this);var s=Object.assign({verticalScrolling:true,afterClose:a},this.getTypeConfig(this.sP13nType).containerSettings);this._addResetInfo(s);return P.createP13nPopover(p,s);};A.prototype._createModalDialog=function(p){var d=function(e){var o=e.getSource().getParent();this._handleChange();this._closeDialog(o,"Ok");}.bind(this);var D=function(e){var c=e.getSource().getParent();this._closeDialog(c,"Cancel");}.bind(this);var s=Object.assign({verticalScrolling:true,confirm:{handler:d},cancel:D},this.getTypeConfig(this.sP13nType).containerSettings);this._addResetInfo(s);return P.createP13nDialog(p,s);};A.prototype._closeDialog=function(c,R){c.close();this.bIsDialogOpen=false;this.fireAfterP13nContainerCloses({reason:R,container:c});c.destroy();};A.prototype._handleChange=function(){var c=[],i=[],C=[];var f=function(o){return this.sP13nType=="Sort"?o.isSorted:o.selected;}.bind(this);i=this.oState.items.filter(f);C=this.oAdaptationModel.getData().items.filter(f);var s=function(o){var d=o.name;if(o.hasOwnProperty("descending")){d=d+o.descending;}if(o.role){d=d+o.role;}return d;};var a=this.getTypeConfig(this.sP13nType).changeOperations;var I=this.getTypeConfig(this.sP13nType).ignoreIndex;if(a){c=F.getArrayDeltaChanges(i,C,s,this.getAdaptationControl(),a,I);}else{c=[];}this.oState=m({},this.oAdaptationModel.getData());this.getAfterChangesCreated()(this,c,"Item");};A.prototype._hasProperty=function(n){var i={valid:false,property:undefined};this.aPropertyInfo.some(function(p){var v=p.name===n||n=="$search";v=v?v:p.path===n;if(v){i.valid=true;i.property=p;}return v;});return i;};A.prototype.destroy=function(s){M.prototype.destroy.apply(this,arguments);if(this.oAdaptationModel){this.oAdaptationModel.destroy();}this.oAdaptationModel=null;this.aPropertyInfo=null;this.oAdaptationModel=null;this.oState=null;this.bIsDialogOpen=null;this.sP13nType=null;this.oAdaptationControlDelegate=null;this.mChangeOperations=null;};return A;});
