/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterProcessor','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','sap/ui/model/TreeAutoExpandMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo','sap/base/util/isEmptyObject','sap/base/util/uid','sap/ui/thirdparty/jquery','sap/base/Log'],function(T,C,F,a,b,c,S,d,f,t,B,A,u,v,Q,L){"use strict";var w="sap.ui.model.analytics.AnalyticalBinding",I=0,x=L.getLogger(w);function y(o){var e=new t.QueryResultRequest(o.oAnalyticalQueryResult),g,s,h,i,j,m,n,p,k=o.mParameters.select.split(","),l=E(k,o.sPath);e.setAggregationLevel(o.aMaxAggregationLevel);e.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(q){h=o.oDimensionDetailsSet[q];e.includeDimensionKeyTextAttributes(q,true,h.textPropertyName!==undefined,h.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(M){m=o.oMeasureDetailsSet[M];e.includeMeasureRawFormattedValueUnit(M,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=e.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=k.indexOf(p);if(j<0){x.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath);l=true;}else{k.splice(j,1);}}}for(i=0,n=k.length;i<n;i++){p=k[i];h=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(h&&o.oDimensionDetailsSet[h.getName()]===undefined){D(o.sPath,p,h);l=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){D(o.sPath,p,m);l=true;}}return l?[]:k;}function D(p,s,o){var e=o instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(o.getName()===s){x.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p);}else{x.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+o.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p);}}function E(s,p){var e,g=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){x.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p);s.splice(i,1);g=true;}}return g;}var G=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;I+=1;this._iId=I;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==d.None){x.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==d.Request||P.countMode==d.Both)){x.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==d.Request){x.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){x.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});function H(o,e){return function(){if(!o.__supportUID){o.__supportUID=v();}return{type:w,analyticalError:e,analyticalBindingId:o.__supportUID};};}G.prototype.setContext=function(o){var r;if(this.oContext!==o){this.oContext=o;if(!this.isRelative()){return;}this.oDataState=null;this.bApplySortersToGroups=true;this.iTotalSize=-1;this._abortAllPendingRequests();r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}else{this.bInitial=true;}}};G.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};G.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};G.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(G._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(G._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){x.fatal("assertion failed: grand total represented by a single entry");}return r;};G.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,e,n,g;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;e=p.level;n=p.numberOfExpandedLevels;g=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];e=arguments[4];n=arguments[5];g=arguments[6];}var h=this._getContextsForParentContext(o,s,l,i,e,n,g);return h;};G.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};G.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return G.prototype.ContextsAvailabilityStatus.ALL;}else{return G.prototype.ContextsAvailabilityStatus.SOME;}}else{return G.prototype.ContextsAvailabilityStatus.NONE;}};G.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};G.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){x.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};G.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1;};G.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};G.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};G.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};G.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};G.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};G.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};G.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};G.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};G.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};G.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};G.prototype.isMeasure=function(p){return this.aMeasureName&&this.aMeasureName.indexOf(p)!==-1;};G.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==c.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:C.Filter});return this;};G.prototype.getFilterInfo=function(i){var o=b.combineFilters(this.aControlFilter,this.aApplicationFilter);if(o){return o.getAST(i);}return null;};G.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};G.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],e=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),s,h,i,j,k,m,n,q;if(e&&this.oDimensionDetailsSet[g].textPropertyName){k=e.getTextProperty();}if(k){m=k.name;q=this.mAnalyticalInfoByProperty[m]&&this.mAnalyticalInfoByProperty[m].formatter;n=o.getProperty(m);s=V?V(p,n):p;h=q?q(n,p):n;}else{s=V?V(p):p;}j=e.getLabelText&&e.getLabelText();i=(j?j+': ':'')+s;if(h){i+=' - '+h;}return i;};G.prototype.updateAnalyticalInfo=function(e,g){var h,o,k,l,m=this;function n(O){var R=O.level,V=O.name;l=l||k.getAllHierarchyPropertyNames();l.forEach(function(W){var X=m.oAnalyticalQueryResult.findDimensionByPropertyName(W).getHierarchy(),Y=null,Z=X.getNodeIDProperty().name,$;if(Z===V){Y=p(X);}else{$=X.getNodeExternalKeyProperty();if($&&$.name===V){Y=p(X);Y.nodeExternalKeyName=V;}else{$=k.getTextPropertyOfProperty(Z);if($&&$.name===V){Y=p(X);Y.nodeTextName=V;}}}if(Y&&"level"in O){if(typeof R==="number"){if("level"in Y&&Y.level!==R){throw new Error("Multiple different level filter for hierarchy '"+Z+"' defined");}Y.level=R;Y.grouped=!!O.grouped;}else{throw new Error("The level of '"+Z+"' has to be an integer value");}}});}function p(O){var R=O.getNodeIDProperty().name,V,W=m.mHierarchyDetailsByName[R];if(!W){V=O.getNodeLevelProperty();W={dimensionName:O.getNodeValueProperty().name,nodeIDName:R,nodeLevelName:V&&V.name};m.mHierarchyDetailsByName[R]=W;}return W;}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}h=t.helper.deepEqual(this._aLastChangedAnalyticalInfo,e,function(O){m.mAnalyticalInfoByProperty[O.name].formatter=O.formatter;});if(h){this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}}if(h<2){if(g||h){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}var P=this.oDimensionDetailsSet||{},q=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};k=this.oAnalyticalQueryResult.getEntityType();for(var i=0;i<e.length;i++){var r=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(r&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=r.getName();o=this.oDimensionDetailsSet[r.getName()];if(!o){o={};o.name=r.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[r.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(!this.getSortablePropertyNames()||this.getSortablePropertyNames().indexOf(r.getName())==-1){x.fatal("property "+r.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(r.getName()==e[i].name){o.keyPropertyName=e[i].name;}var s=r.getTextProperty();if(s&&s.name==e[i].name){o.textPropertyName=e[i].name;}if(r.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var M=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(M&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=M.getName();var z=this.oMeasureDetailsSet[M.getName()];if(!z){z={};z.name=M.getName();this.oMeasureDetailsSet[M.getName()]=z;this.aMeasureName.push(z.name);}if(M.getRawValueProperty().name==e[i].name){z.rawValuePropertyName=e[i].name;}var J=M.getFormattedValueProperty();if(J&&J.name==e[i].name){z.formattedValuePropertyName=e[i].name;}z.analyticalInfo=e[i];}if(!r&&!M){n(e[i]);}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}Object.keys(this.mHierarchyDetailsByName).forEach(function(O){var R=m.mHierarchyDetailsByName[O];if(!("level"in R)){delete m.mHierarchyDetailsByName[O];if(x.isLoggable(L.Level.INFO)){x.info("No level specified for hierarchy node '"+O+"'; ignoring hierarchy","");}}else if(!m.oDimensionDetailsSet[O]){m.oDimensionDetailsSet[O]={aAttributeName:[],grouped:R.grouped,isHierarchyDimension:true,name:O};m.aMaxAggregationLevel.push(O);if(R.grouped){m.aAggregationLevel.push(O);}}});for(var K in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(K).getUnitProperty();if(U){this.oMeasureDetailsSet[K].unitPropertyName=U.name;}}var N=Object.keys(P).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(N){this.iTotalSize=-1;}if(N||Object.keys(q).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=y(this);}if(g){this._fireChange({reason:C.Change});}};G.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};G.prototype.loadGroups=function(g){var e=[];for(var s in g){e.push(s);this._resetData(s);var h=g[s];for(var i=0;i<h.length;i++){var o=h[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,k;(k=e[++j])!==undefined;){r.push(this._getRequestId(G._requestType.groupMembersQuery,{groupId:k}));}this._considerRequestGrouping(r);}};G.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};G._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};G._artificialRootContextGroupId="artificialRootContext";G._addHierarchyLevelFilters=function(e,o){e.forEach(function(g){o.removeConditions(g.propertyName);o.addCondition(g.propertyName,a.EQ,g.level);});};G.prototype._getContextsForParentContext=function(p,s,l,i,e,n,g){if(p===undefined){return[];}if(p&&p.getPath()=="/"+G._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,e);return this._getContextsForParentGroupId(P,s,l,i,n,g);};G.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){x.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){x.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){x.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],k,o,m,q;var r=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[r]){this.aMultiUnitLoadFactor[r]=1;}var z=n>0&&p!=null;if(z){var M=this._getGroupIdLevel(p);var J=M+n;var K=true;if(!g){m=this._calculateRequiredGroupExpansion(p,J,s,l+e);K=m.groupId_Missing==null;K=K||m.groupId_Missing.length<p.length||m.groupId_Missing.substring(0,p.length)!=p;}if(K){h=this._getLoadedContextsForGroup(p,s,l);}else{q=l+e;}k=!K;q=Math.ceil(q*this.aMultiUnitLoadFactor[r]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);k=false;if(!g){if(this._oWatermark&&p===this._oWatermark.groupID){e=10000;}o=this._calculateRequiredGroupSection(p,s,l,e);var P=o.length>0&&l<o.length;k=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;o.length=Math.ceil(o.length*this.aMultiUnitLoadFactor[r]);}}if(!k){this._cleanupGroupingForCompletedRequest(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));}var N=false;if(this.oModel.getServiceMetadata()){if(k){var O=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(G._requestType.totalSizeQuery));N=true;var R;if(this.bUseBatchRequests){if(z){R=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,U;(U=R[++i])!==undefined;){if(this._isRequestPending(U)){N=false;break;}}if(N){this.aBatchRequestQueue.push([G._requestType.groupMembersAutoExpansionQuery,p,m,q,n]);}}else{N=o.length&&!this._isRequestPending(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));if(N){this.aBatchRequestQueue.push([G._requestType.groupMembersQuery,p,o.startIndex,o.length]);R=[this._getRequestId(G._requestType.groupMembersQuery,{groupId:p})];}}if(N&&O){R.push(this._getRequestId(G._requestType.totalSizeQuery));this._considerRequestGrouping(R);this.aBatchRequestQueue.push([G._requestType.totalSizeQuery]);}if(N){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(G.prototype._processRequestQueue.bind(this));}}else{var V;if(z){R=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,W;(W=R[++j])!==undefined;){if(this._isRequestPending(W)){N=false;break;}}if(N){V=this._prepareGroupMembersAutoExpansionQueryRequest(G._requestType.groupMembersAutoExpansionQuery,p,m,q,n);}}else{N=o.length&&!this._isRequestPending(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));if(N){V=this._prepareGroupMembersQueryRequest(G._requestType.groupMembersQuery,p,o.startIndex,o.length);R=[V.sRequestId];}}if(N){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(V);if(O&&!V.bIsFlatListRequest){R.push(this._getRequestId(G._requestType.totalSizeQuery));this._considerRequestGrouping(R);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(G._requestType.totalSizeQuery));}}}}}return h;};G.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(o,g){var h,e=[],i=this;if(g===null){return e;}h=Object.keys(this.mHierarchyDetailsByName);if(h.length>0&&g!=="/"){x.error("Hierarchy cannot be requested for members of a group",g);return e;}h.forEach(function(s){var j=i.mHierarchyDetailsByName[s];o.addRecursiveHierarchy(j.dimensionName,!!j.nodeExternalKeyName,!!j.nodeTextName);e.push({propertyName:j.nodeLevelName,level:j.level});});return e;};G.prototype._getNonHierarchyDimensions=function(e){var g=this;return e.filter(function(s){return!g.oDimensionDetailsSet[s].isHierarchyDimension;});};G.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==G._requestType.groupMembersQuery){o=G.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case G._requestType.groupMembersQuery:continue;case G._requestType.totalSizeQuery:if(!e){o=G.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case G._requestType.groupMembersAutoExpansionQuery:o=G.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case G._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:x.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};G.prototype._prepareGroupMembersQueryRequest=function(r,g,s,e){var h=[],m=[],o;var p=new t.QueryResultRequest(this.oAnalyticalQueryResult);p.setResourcePath(this._getResourcePath());p.getSortExpression().clear();var q=0,z=-1;if(g){h=this._getGroupIdComponents(g);q=z=h.length;var U=0;for(var j=0,J=0;j<q;J++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[J]].grouped==false){++U;}else{++j;}}q=z=q+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[z]].grouped==false){if(++z==this.aMaxAggregationLevel.length){break;}}}}var K=z>=this.aMaxAggregationLevel.length-1;o=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(p,g);var M=this.aMaxAggregationLevel.slice(0,z+1);var N=this._getNonHierarchyDimensions(M);p.setAggregationLevel(N);for(var i=0;i<N.length;i++){var O=this.oDimensionDetailsSet[N[i]];var P=(O.textPropertyName!=undefined);p.includeDimensionKeyTextAttributes(O.name,true,P,O.aAttributeName);if(O.grouped){m.push({sPath:N[i],bDescending:false});}}var R=p.getFilterExpression();R.clear();if(this.aApplicationFilter){R.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){R.addUI5FilterConditions(this.aControlFilter);}if(q>=1){for(var k=0,l=h.length;k<l;k++){R.removeConditions(this.aAggregationLevel[k]);R.addCondition(this.aAggregationLevel[k],a.EQ,h[k]);}}G._addHierarchyLevelFilters(o,R);var V;var W;var X;var Y;var Z=[];if(g!=null||this.bProvideGrandTotals||(this._canApplySortersToGroups()&&this.aSorter.length>0)){p.setMeasures(this.aMeasureName);for(var $ in this.oMeasureDetailsSet){Y=this.oMeasureDetailsSet[$];if(!K&&this._isSkippingTotalForMeasure($)){V=false;W=false;X=false;}else{V=(Y.rawValuePropertyName!=undefined);W=(Y.formattedValuePropertyName!=undefined);X=(Y.unitPropertyName!=undefined);if(X){if(Z.indexOf(Y.unitPropertyName)==-1){Z.push(Y.unitPropertyName);}}}p.includeMeasureRawFormattedValueUnit(Y.name,V,W,X);}for(var n in N){var _;if((_=Z.indexOf(N[n]))!=-1){Z.splice(_,1);}}}if(g){this._addSorters(p.getSortExpression(),m);}if(e==0){x.fatal("unhandled case: load 0 entities of sub group");}var a1=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){p.setResultPageBoundaries(a1.iServiceKeyIndex+1,a1.iServiceKeyIndex+e);}p.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:p,sGroupId:g,aSelectedUnitPropertyName:Z,aAggregationLevel:M,bIsFlatListRequest:K&&q==0,bIsLeafGroupsRequest:K,iStartIndex:s,iLength:e,oKeyIndexMapping:a1};};G.prototype._prepareTotalSizeQueryRequest=function(r){var h;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,"/");o.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}G._addHierarchyLevelFilters(h,e);o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};G.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,o,e,n){var h=this;var p=function(o,s){var K=[];if(o.groupId_Missing==null){x.fatal("missing group Id not present");return K;}var z=h._getGroupIdComponents(o.groupId_Missing);var J=z.length;if(J>s){x.fatal("the given group ID is too deep for requested level for auto expansion");return K;}var k=[];for(var i=0;i<J;i++){var l=h.aAggregationLevel[i];var $=z[i];var _=h._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,_,$);}var a1=null;if(o.startIndex_Missing>0){var b1=h._getKey(o.groupId_Missing,o.startIndex_Missing-1);var c1=h.oModel.getObject("/"+b1);var d1=h.aAggregationLevel[J];var e1=c1[d1];a1=new F(d1,h._getFilterOperatorMatchingPropertySortOrder(d1,false),e1);}for(var N=0;N<s;N++){var f1=[];var g1=Math.min(J,N+1);for(var h1=0;h1<g1;h1++){var i1=[];var j1=Math.min(J,h1+1);var k1=o.startIndex_Missing>0;for(var l1=0;l1<j1;l1++){var m1=new F("x",a.EQ,"x");m1=Q.extend(true,m1,k[l1]);if(j1>1&&l1<j1-1){m1.sOperator=a.EQ;}if(l1==J-1&&N>J-1&&!k1){if(m1.sOperator==a.GT){m1.sOperator=a.GE;}else{m1.sOperator=a.LE;}}i1.push(m1);}if(i1.length>0){f1.push(new F(i1,true));if(N>J-1&&h1==J-1&&k1){var n1=[];for(var j=0;j<i1.length;j++){var o1=new F("x",a.EQ,"x");o1=Q.extend(true,o1,i1[j]);n1.push(o1);}n1[J-1].sOperator=a.EQ;n1.push(a1);f1.push(new F(n1,true));break;}}}if(f1.length>0){K[N]=new F(f1,false);}else{K[N]=null;}}return K;};var m=function(r,g,N,$,O,e,_,a1){var b1;var c1=new t.QueryResultRequest(h.oAnalyticalQueryResult);c1.setResourcePath(h._getResourcePath());c1.getSortExpression().clear();var d1=0,e1=-1;d1=e1=N-1;var f1=0;for(var i=0,g1=0;i<d1;g1++){if(h.oDimensionDetailsSet[h.aMaxAggregationLevel[g1]].grouped==false){++f1;}else{++i;}}d1=e1=d1+f1;if(h.aMaxAggregationLevel.length>0){while(h.aMaxAggregationLevel[e1]&&h.oDimensionDetailsSet[h.aMaxAggregationLevel[e1]].grouped==false){if(++e1==h.aMaxAggregationLevel.length){break;}}}var h1=e1>=h.aMaxAggregationLevel.length-1;b1=h._getHierarchyLevelFiltersAndAddRecursiveHierarchy(c1,g);var i1=h.aMaxAggregationLevel.slice(0,e1+1);c1.setAggregationLevel(i1);for(var l=0;l<i1.length;l++){var j1=h.oDimensionDetailsSet[i1[l]];var k1=(j1.textPropertyName!=undefined);c1.includeDimensionKeyTextAttributes(j1.name,true,k1,j1.aAttributeName);if(j1.grouped){c1.getSortExpression().addSorter(i1[l],t.SortOrder.Ascending);}}var l1=c1.getFilterExpression();l1.clear();if(h.aApplicationFilter){l1.addUI5FilterConditions(h.aApplicationFilter);}if(h.aControlFilter){l1.addUI5FilterConditions(h.aControlFilter);}if($){l1.addUI5FilterConditions([$]);}G._addHierarchyLevelFilters(b1,l1);var m1;var n1;var o1;var p1;var q1=[];c1.setMeasures(h.aMeasureName);for(var r1 in h.oMeasureDetailsSet){p1=h.oMeasureDetailsSet[r1];if(!h1&&h._isSkippingTotalForMeasure(r1)){m1=false;n1=false;o1=false;}else{m1=(p1.rawValuePropertyName!=undefined);n1=(p1.formattedValuePropertyName!=undefined);o1=(p1.unitPropertyName!=undefined);if(o1){if(q1.indexOf(p1.unitPropertyName)==-1){q1.push(p1.unitPropertyName);}}}c1.includeMeasureRawFormattedValueUnit(p1.name,m1,n1,o1);}for(var j in i1){var s1;if((s1=q1.indexOf(i1[j]))!=-1){q1.splice(s1,1);}}var t1=c1.getSortExpression();for(var k=0;k<h.aSorter.length;k++){if(h.aSorter[k]){t1.addSorter(h.aSorter[k].sPath,h.aSorter[k].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);}}if(e==0){x.fatal("unhandled case: load 0 entities of sub group");}var u1=O;if(!a1){u1=0;}else{var v1=0;for(var w1 in h.mServiceKey){if(w1.split("/").length===N+1){v1+=h.mServiceKey[w1].length;}}u1=Math.max(u1,v1);}if(!h.bNoPaging){c1.setResultPageBoundaries(u1+1,u1+e);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:c1,iLevel:N,aSelectedUnitPropertyName:q1,aAggregationLevel:i1,bIsFlatListRequest:h1,bIsLeafGroupsRequest:h1,iStartIndex:O,iLength:e,bAvoidLengthUpdate:_};};var q=[];var R=[];if(!o){x.fatal("no first missing group member specified");}var s=this._getGroupIdLevel(g)+n+1;var z=h._getGroupIdComponents(o.groupId_Missing);var J=z.length;var K=p(o,s);var M;for(var N=1;N<=s;N++){var O;if(N>=J+2){O=0;M=undefined;}else if(N==J+1){O=o.startIndex_Missing;M=o.groupId_Missing;}else if(J>0){if(N==J){M=o.groupId_Missing;}else{M=this._getGroupIdAncestors(o.groupId_Missing,-(J-N))[0];}var P=this._getGroupIdAncestors(o.groupId_Missing,-(J-N+1))[0];if(!P){x.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+N);}O=this._findKeyIndex(P,this.mEntityKey[M]);if(O==-1){x.fatal("failed to determine position of value "+M+" in group "+P);}M=P;O++;}var U=e>N?Math.ceil((e-N)/(s-N+1)):e;var V=K[N-1];if(this.bUseAcceleratedAutoExpand){var W=m(G._requestType.levelMembersQuery,g,N,V,O,U,false,V==null?true:false);W.sGroupId_Missing_AtLevel=M;W.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:N});q.push(W);R.push(W.sRequestId);}else if(V&&V.aFilters.length>0){if(!V._bMultiFilter||V.bAnd){x.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<V.aFilters.length;i++){var X=V.aFilters[i];var Y=m(G._requestType.levelMembersQuery,g,N,X,O,U,false,V==null?true:false);Y.sGroupId_Missing_AtLevel=M;Y.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:N,tupleIndex:i});q.push(Y);R.push(Y.sRequestId);}}else{var Z=m(G._requestType.levelMembersQuery,g,N,null,O,U,false,V==null?true:false);Z.sGroupId_Missing_AtLevel=M;Z.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:N});q.push(Z);R.push(Z.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:q,sGroupId:g,iLength:e};};G.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var h=g.bIsLeafGroupsRequest;var k=o.getFilterExpression();k.clear();if(this.aApplicationFilter){k.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){k.addUI5FilterConditions(this.aControlFilter);}var l=[];for(var i=0;i<e.length;i++){var n=new F(e[i],a.EQ,m.oEntry[e[i]]);l.push(n);}k.addUI5FilterConditions(l);var p;var q;var s;var M;var z=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var J in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[J];if(!m.aReloadMeasurePropertyName||m.aReloadMeasurePropertyName.indexOf(M.name)==-1){continue;}if(!h&&this._isSkippingTotalForMeasure(J)){p=false;q=false;s=false;}else{p=(M.rawValuePropertyName!=undefined);q=(M.formattedValuePropertyName!=undefined);s=(M.unitPropertyName!=undefined);if(s){if(z.indexOf(M.unitPropertyName)==-1){z.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,p,q,s);}for(var j in e){var K;if((K=z.indexOf(e[j]))!=-1){z.splice(K,1);}}return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:z,aAggregationLevel:e,oMultiUnitRepresentative:m};};G.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};G.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){x.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var j=o.getURIQueryOptionValue("$skip");var k=o.getURIQueryOptionValue("$top");var l=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){if(h===null){h=this.mParameters["filter"];}else{h+="and ("+this.mParameters["filter"]+")";}}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(O!==null){P.push("$orderby="+O);}if(j!==null){P.push("$skip="+j);}if(k!==null){P.push("$top="+k);}if(l!==null){P.push("$inlinecount="+l);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};G.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],l=[];function m(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function n(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var p=0;p<r.length;p++){var q=r[p];if(q.aAggregationLevel&&q.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,z;(z=r[++i])!==undefined;){var J=z.oAnalyticalQueryRequest,K=z.sGroupId;if(J.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});K=null;this.mServiceLength[K]=this.mLength[K]=1;this.mServiceFinalLength[K]=true;this._setServiceKey(this._getKeyIndexMapping(K,0),G._artificialRootContextGroupId);setTimeout(m);this.bArtificalRootContext=true;continue;}var P=J.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(z.sRequestId)){this._registerNewRequest(z.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(J,z.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var M=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:n,context:this.oContext,urlParameters:U});h.push(M);}l.push(z);}}if(h.length>0){x.debug("AnalyticalBinding: executing batch request with "+l.length+" operations");var N;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);N=this.oModel.submitBatch(O,V,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{N={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:l,binding:this,success:O,error:V});}this._registerNewRequestHandle(R,N);}function O(W,X){g._deregisterHandleOfCompletedRequest(R);if(l.length!=W.__batchResponses.length){x.fatal("assertion failed: received "+W.__batchResponses.length+" responses for "+l.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<l.length;j++){var Y=l[j].sRequestId;if(Y!==undefined){g._deregisterCompletedRequest(Y);g._cleanupGroupingForCompletedRequest(Y);}}g.fireDataReceived({data:[]});return;}var Z=0;for(var k=0;k<W.__batchResponses.length;k++){if(W.__batchResponses[k].data!=undefined){if(W.__batchResponses[k].data.results.length==0){Z++;}switch(l[k].iRequestType){case G._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(l[k],W.__batchResponses[k].data);break;case G._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(l[k],W.__batchResponses[k].data);break;case G._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(l[k],W.__batchResponses[k].data);break;case G._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(l[k],W.__batchResponses[k].data);break;default:x.fatal("invalid request type "+l[k].iRequestType);continue;}}g._deregisterCompletedRequest(l[k].sRequestId);g._cleanupGroupingForCompletedRequest(l[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(Z==W.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var $=true;var _;g.fireDataReceived({data:W});var a1={};if(g.iModelVersion===A.V1){_=g.oModel._getBatchErrors(W);if(_.length>0){$=false;a1=g.oModel._handleError(_[0]);}g.oModel.fireRequestCompleted({url:X.requestUri,type:"POST",async:true,info:"",infoObject:{},success:$,errorobject:$?{}:a1});if($){g.oModel.checkUpdate();}}}function V(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,W;(W=l[++j])!==undefined;){g._deregisterCompletedRequest(W.sRequestId);g._cleanupGroupingForCompletedRequest(W.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var X=k;if(g.iModelVersion===A.V1){X=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:X});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(X);}g.fireDataReceived();}};G.prototype._executeQueryRequest=function(r){if(r.iRequestType==G._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,s=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});s=null;this.mServiceLength[s]=this.mLength[s]=1;this.mServiceFinalLength[s]=true;this._setServiceKey(this._getKeyIndexMapping(s,0),G._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}x.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,l,n,false,U,m);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p.replace(/ /g,"%20"),{success:l,error:n,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function l(q){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case G._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,q);break;case G._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,q);break;case G._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,q);break;case G._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,q);break;default:x.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){m(q);}}function m(q){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:q});}}function n(q){if(q&&q.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};G.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};G.prototype._processGroupMembersQueryResponse=function(R,e){var s,n=R.sGroupId,z=this.aSorter.length>0,J=R.aSelectedUnitPropertyName,K=R.aAggregationLevel,M=R.oKeyIndexMapping.iIndex,N=R.oKeyIndexMapping.iServiceKeyIndex,O=R.iLength,P=R.oKeyIndexMapping,U=n==null?0:this._getGroupIdLevel(n)+1,V=(J.length>0),W,X,Y,Z=0,$,_,a1=[];var b1=e.results.length;if(n===null&&b1>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(z?"binding is refreshed":undefined);if(z){setTimeout(this.refresh.bind(this),0);return;}}var c1=this._getServiceKeys(n,P.iIndex-1);W=undefined;if(c1&&c1.length>0){for(var i=0,d1=c1.length;i<d1;i++){e.results[i-d1]=this.oModel.getObject("/"+c1[i]);}var e1=e.results[-c1.length];W="";for(var j=0;j<K.length;j++){W+=e1[K[j]]+"|";}}$=c1&&c1.length==1;for(var h=0;h<b1;h++){var f1=e.results[h];if(V){X="";for(var g=0;g<K.length;g++){X+=f1[K[g]]+"|";}if(W==X){this._warnNoSortingOfGroups();if(Y===undefined){if(h==0){Y=-c1.length;P.iServiceKeyIndex-=c1.length-1;}else{Y=h-1;}}var g1=-1,h1=e.results[h-1];for(var k=0;k<J.length;k++){if(h1[J[k]]!=f1[J[k]]){g1=k;break;}}if(g1==-1){x.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,H(this,"NO_DEVIATING_UNITS"));}}if((W!=X||h==b1-1)&&Y!==undefined){var i1=[];for(var l=Y;l<h;l++){i1.push(e.results[l]);}if(W==X){i1.push(e.results[h]);}var j1=[];for(var m=0;m<J.length;m++){var k1=J[m];for(var o=1;o<i1.length;o++){if(i1[o-1][k1]!=i1[o][k1]){j1.push(k1);break;}}}var l1=this._createMultiUnitRepresentativeEntry(n,e.results[Y],J,j1,R.bIsFlatListRequest);if(l1.aReloadMeasurePropertyName.length>0){_=this._prepareReloadMeasurePropertiesQueryRequest(G._requestType.reloadMeasuresQuery,R,l1);if(_.oAnalyticalQueryRequest&&_.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){a1.push(_);}}var m1=this._setAdjacentMultiUnitKeys(P,l1,i1);var n1;if(l1.bIsNewEntry){n1=i1.length-1;}else{n1=m1;}if($){$=false;}if(n1<0){x.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}Z+=n1;var o1=this.oModel._getKey(l1.oEntry);var p1=this.oModel.getContext('/'+o1);this._getGroupIdFromContext(p1,U);this.mEntityKey[s]=o1;Y=undefined;if(W!=X){$=this._setServiceKey(P,this.oModel._getKey(f1));}}else if(W!=X){$=this._setServiceKey(P,this.oModel._getKey(f1));}W=X;}else{this._setServiceKey(P,this.oModel._getKey(f1));}if(!R.bIsLeafGroupsRequest){var q1=this._getKey(n,P.iIndex-1);s=this._getGroupIdFromContext(this.oModel.getContext('/'+q1),U);this.mEntityKey[s]=q1;}}var r1=[];if(this.bReloadSingleUnitMeasures&&a1.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([G._requestType.reloadMeasuresQuery,a1]);Promise.resolve().then(G.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<a1.length;q++){var s1=a1[q];this._executeQueryRequest(s1);}}for(var p=0;p<a1.length;p++){var t1=a1[p];r1.push(t1.sRequestId);}this._considerRequestGrouping(r1);}if(c1&&c1.length>0){for(var r=0,u1=c1.length;r<u1;r++){delete e.results[r-u1];}}if(V){Z+=this._mergeLoadedKeyIndexWithSubsequentIndexes(P,K,J,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var v1=false;if(e.__count){this.mServiceLength[n]=parseInt(e.__count);this.mLength[n]=this.mServiceLength[n]-Z;this.mFinalLength[n]=true;if(R.bIsFlatListRequest){this.iTotalSize=e.__count;}v1=true;}if(!(n in this.mServiceLength)||this.mServiceLength[n]<N+b1){this.mServiceLength[n]=N+b1;this.mLength[n]=M+b1-Z;this.mFinalLength[n]=false;}if(b1<O||O===undefined){this.mServiceLength[n]=N+b1;this.mLength[n]=M+P.iIndex-M;this.mFinalLength[n]=true;v1=true;}if(b1==0){this.mLength[n]=this.mServiceLength[n]=0;this.mFinalLength[n]=true;v1=true;}if(!v1&&this.mLength[n]!==undefined&&Z>0){this.mLength[n]-=Z;}}this.bNeedsUpdate=true;if(Z>0){if(e.results.length-Z>0){this.aMultiUnitLoadFactor[K.length]=e.results.length/(e.results.length-Z);}if(this.aMultiUnitLoadFactor[K.length]<1.5){this.aMultiUnitLoadFactor[K.length]=2;}}x.info("MultiUnit Situation in Group ("+n+"), discarded: "+Z+", load-factor is now: "+this.aMultiUnitLoadFactor[K.length]);};G.prototype._processTotalSizeQueryResponse=function(r,o){if(o.__count==undefined){x.fatal("missing entity count in query result");return;}this.iTotalSize=o.__count;};G.prototype._processLevelMembersQueryResponse=function(r,o){var e=this;var p,P;var g=function(h,l){var m={iRequestType:G._requestType.groupMembersQuery,sRequestId:e._getRequestId(G._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=m.sGroupId||e._getKeys(m.sGroupId)===undefined)){var s=e._getParentGroupId(m.sGroupId);var n=e._findKeyIndex(s,e.mEntityKey[m.sGroupId]);if(n<0){x.fatal("assertion failed: failed to determine position of "+m.sGroupId+" in group "+s);}else if(!n){e.mFinalLength[r.sGroupId_Missing_AtLevel]=true;}else if(e._getKey(s,n-1)!==undefined){var q=e._getKey(s,n-1);var z=e._getGroupIdFromContext(e.oModel.getContext('/'+q),e._getGroupIdLevel(m.sGroupId));e.mFinalLength[z]=true;m.iStartIndex=0;}}if(l){m.iLength=P.length;}m.oKeyIndexMapping=e._getKeyIndexMapping(m.sGroupId,m.iStartIndex);var J=Q.extend(true,{},o);J.results=P;e._processGroupMembersQueryResponse(m,J);};if(o.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(o.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<o.results.length;i++){var j=o.results[i];var k=this.oModel.getContext("/"+this.oModel._getKey(o.results[i]));var s=this._getGroupIdFromContext(k,r.iLevel-1);if(p==s){P.push(j);if(i<o.results.length-1){continue;}}g(h,o.results.length==r.iLength&&i==o.results.length-1);h=false;if(p!=s){P=[j];}p=s;}if(o.results.length>1&&P.length==1){g(h,o.results.length==r.iLength);}};G.prototype._processReloadMeasurePropertiesQueryResponse=function(r,o){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(o.results.length!=1){x.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=o.results[0];var e=this.oModel.getObject("/"+M);if(!e){x.fatal("assertion failed: no entity found with key "+M);return;}var g=m.aReloadMeasurePropertyName;for(var i=0;i<g.length;i++){e[g[i]]=R[g[i]];}};G.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};G.prototype._calculateRequiredGroupSection=function(g,s,l,i){var e=this._getKeys(g);if(s>=i){s-=i;l+=i;}else{l+=s;s=0;}l+=i;if(this.mFinalLength[g]&&s+l>this.mLength[g]){l=this.mLength[g]-s;}if(e){while(l&&e(s)){s+=1;l-=1;}while(l&&e(s+l-1)){l-=1;}}return{startIndex:s,length:l};};G.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var k=h._getGroupIdLevel(g);if(k==e){var J=h._getLoadedContextsForGroup(g,s,l);var K=s+J.length-1;if(J.length>=l){return n;}else if(h.mFinalLength[g]){if(J.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-J.length};}else{return{groupId_Missing:g,startIndex_Missing:K+1,length_Missing:l-J.length};}}else{return{groupId_Missing:g,startIndex_Missing:K+1,length_Missing:l-J.length};}}var M=h._getLoadedContextsForGroup(g,s,l);var m=l,N=s+M.length-1;for(var i=-1,O;(O=M[++i])!==undefined;){m--;var p=j(h._getGroupIdFromContext(O,k+1),e,0,m);if(p.groupId_Missing==null){if(p.length_Missing==0){return p;}else{m=p.length_Missing;}}else{return p;}if(m==0){break;}}if(h.mFinalLength[g]||m==0){return{groupId_Missing:null,length_Missing:m};}else{return{groupId_Missing:g,startIndex_Missing:N+1,length_Missing:m};}};var k=this._getGroupIdLevel(g);if(k==e+1){g=this._getParentGroupId(g);--k;}if(g==null||k>e){return n;}var m=l,o=s;while(g!=null){var p=j(g,e,o,m);if(p.groupId_Missing!=null){return p;}else if(p.length_Missing==0){return p;}else{var q=false;while(!q){var P=this._getParentGroupId(g);if(P==null){g=P;--k;break;}var r=this.mEntityKey[g];if(!r){return n;}var z=this._findKeyIndex(P,r);if(z==-1){return n;}if(z==this._getKeyCount(P)-1){if(this.mFinalLength[P]){g=P;--k;continue;}else{return{groupId_Missing:P,startIndex_Missing:z+1,length_Missing:m};}}else{r=this._getKey(P,z+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+r),k);q=true;}}o=0;m=p.length_Missing;}}return{groupId_Missing:null,length_Missing:m};};G.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};G.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};G.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending;}}return null;};G.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case t.SortOrder.Ascending:if(W){s=a.GE;}else{s=a.GT;}break;case t.SortOrder.Descending:if(W){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};G.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};G.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var s=null;if(l>this.aAggregationLevel.length){x.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){s=o.getProperty(this.aAggregationLevel[i]);if(s!=null){if(s.__edmType==="Edm.Time"){s=s.ms;}g+=encodeURIComponent(s)+"/";}else{g+="@/";}}return g;};G.prototype._getGroupIdLevel=function(g){if(g==null){x.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};G.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var e=g.split("/");var h=[];for(var i=1;i<e.length-1;i++){if(e[i]=="@"){h[i-1]=null;}else{h[i-1]=decodeURIComponent(e[i]);}}return h;};G.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){x.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{x.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var e=g.split("/");var h=[],s="";var k=0,l=e.length-3;if(n>0){if(n-1>l){x.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{l=n-1;}}else if(-(n+1)>l){x.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=l+1+n;for(var i=0;i<k;i++){s+=e[i]+"/";}}for(var j=k;j<=l;j++){s+=e[j]+"/";h.push(s);}return h;};G.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};G.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};G.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};G.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){x.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};G.prototype._deregisterHandleOfCompletedRequest=function(r){if(u(this.oPendingRequestHandle)){x.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){x.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};G.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};G.prototype._getRequestId=function(r,p){switch(r){case G._requestType.groupMembersQuery:if(p.groupId===undefined){x.fatal("missing group ID");}return G._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case G._requestType.levelMembersQuery:if(p.level===undefined){x.fatal("missing level");}if(p.groupId===undefined){x.fatal("missing groupId");}return""+G._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case G._requestType.totalSizeQuery:return G._requestType.totalSizeQuery;case G._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){x.fatal("missing multi unit entry key");}return G._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:x.fatal("invalid request type "+r);return-1;}};G.prototype._registerNewRequest=function(r){if(r==undefined||r==""){x.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};G.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};G.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};G.prototype._deregisterCompletedRequest=function(r){if(u(this.oPendingRequests)){x.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){x.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};G.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};G.prototype._getKeyIndexMapping=function(g,s){var i,l,e,k=this.mKeyIndex[g],K={sGroupId:g,iIndex:s,iServiceKeyIndex:s},h=this.mServiceKey[g];if(k!==undefined){if(k[s]!==undefined){K.iServiceKeyIndex=k[s]==="ZERO"?0:Math.abs(k[s]);return K;}l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}if(l==0){e=0;}else{if(k[l]>=0){e=k[l];}else if(k[l+1]===undefined){e=-k[l];while(h[e+1]!==undefined){++e;}}else{e=Math.abs(k[l+1])-1;}if(h[e]===undefined){x.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+e);}}i=s-l;K.iServiceKeyIndex=e+i;}return K;};G.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};G.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){x.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){x.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};G.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};G.prototype._getServiceKeys=function(g,e){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],h=k[e];if(h===undefined){return undefined;}if(h>=0){return[s[h]];}var j=[];if(k[e+1]===undefined){h=k[e]=="ZERO"?0:-k[e];while(s[h]!==undefined){j.push(s[h++]);}}else{h=k[e]=="ZERO"?0:-k[e];for(var i=h,n=Math.abs(k[e+1]);i<n;i++){j.push(s[i]);}}return j;};G.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};G.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0||K[i]==="ZERO"){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};G.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};G.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};G.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,g){var K=this.mKeyIndex[k.sGroupId],h=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],j=0,n=k.iServiceKeyIndex,l=k.iIndex;var M,o;if(K===undefined){return j;}var N=false;var p=h[n-1],q=h[n];if(q===undefined){return j;}if(p===undefined){x.fatal("assertion failed: missing expected entry before given key index");return j;}var P=this.oModel.getObject("/"+p);var r=this.oModel.getObject("/"+q);var z="",J="";for(var i=0;i<e.length;i++){z+=P[e[i]]+"|";J+=r[e[i]]+"|";}N=z==J;var O=l;if(O>=this.mLength[k.sGroupId]){x.fatal("assertion failed: service key exists,but no corresponding key index found");return j;}while(K[O]===undefined||Math.abs(K[O])<n){++O;}if(N){if(Math.abs(K[O])==n&&K[O]<0){if(O>l){if(K[l-1]<0){m[O]=undefined;K.splice(l,O-l+1);m.splice(l,O-l+1);}else{K[l-1]=-K[l-1];m[l-1]=m[O];m[O]=undefined;K.splice(l,O-l+1);m.splice(l,O-l+1);j=1;}}}else if(Math.abs(K[O])>n){var R=O-1;if(K[R]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,g);o=this.oModel._getKey(M.oEntry);K[R]=-K[R];m[R]=o;if(R>l){K.splice(l,R-l);m.splice(l,R-l);}if(M.bIsNewEntry){j=1;}else{j=0;}}else if(K[l-1]<0){if(O>l){m[R]=undefined;K.splice(l,R-l+1);m.splice(l,R-l+1);}}else{K[l-1]=-K[l-1];m[l-1]=m[R];m[R]=undefined;K.splice(l,R-l+1);m.splice(l,R-l+1);}}else if(K[O]==n){if(O>l){if(K[l-1]<0){K.splice(l,O-l+1);m.splice(l,O-l+1);j=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,g);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){x.fatal("assertion failed: multi-unit entry already existed before");}K[l-1]=-K[l-1];m[l-1]=o;K.splice(l,O-l+1);m.splice(l,O-l+1);j=1;}}}else{x.fatal("assertion failed: uncovered case detected");return j;}}else if(K[O]>n){x.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(O-l>0){K.splice(l,O-l);m.splice(l,O-l);}return j;};G.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,e,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&this._isSkippingTotalForMeasure(M)){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(e){if(!o.unitPropertyName||e.indexOf(o.unitPropertyName)==-1){R.push(o.rawValuePropertyName||o.name);}}}for(var k=0;k<s.length;k++){if(e.indexOf(s[k])!=-1){m[s[k]]="*";}}var h="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var j=m[this.aAllDimensionSortedByName[l]];var n=j===""?'""':j;n=n===undefined?"":n;h+=(encodeURIComponent(n)+",");}h+="-multiple-units-not-dereferencable|"+this._iId;var p;if(this.mMultiUnitKey[g]&&(p=this.mMultiUnitKey[g].indexOf(h))!=-1){return{oEntry:this.oModel.getObject("/"+h),bIsNewEntry:false,iIndex:p,aReloadMeasurePropertyName:R};}m.__metadata.uri=h;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var q=this.oModel._getKey(m);this.oModel.getContext('/'+q)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};G.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};G.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};G.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};G.prototype.refresh=function(e){G.prototype._refresh.apply(this,arguments);};G.prototype._refresh=function(e,m,g){var h=false;if(!e){if(g){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in g)){h=true;}}if(m&&!h){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){h=true;return false;}});if(h){return false;}});}if(!m&&!g){h=true;}}if(e||h){this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};G.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};G.prototype.getDownloadUrl=function(s){var e,p,z;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var n in this.oDimensionDetailsSet){g.push(n);}o.setAggregationLevel(g);for(var q in this.oDimensionDetailsSet){var r=this.oDimensionDetailsSet[q];var J=(r.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(r.name,true,J,r.aAttributeName);}for(var M in this.oMeasureDetailsSet){h.push(M);}o.setMeasures(h);for(var K in this.oMeasureDetailsSet){var N=this.oMeasureDetailsSet[K];var O=(N.rawValuePropertyName!=undefined);var P=(N.formattedValuePropertyName!=undefined);var R=(N.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(N.name,O,P,R);}var U=o.getSortExpression();U.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){U.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);}}var V=o.getFilterExpression();V.clear();if(this.aApplicationFilter){V.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){V.addUI5FilterConditions(this.aControlFilter);}var W=o.getURIToQueryResultEntitySet();var X=this._getQueryODataRequestOptions(o,true);if(!X){return undefined;}var Y=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var Z=this.aAnalyticalInfo[k];if((Z.visible||Z.inResult)&&Z.name!==""&&Z.name!==Y[Y.length-1]){Y.push(Z.name);if(this.oMeasureDetailsSet[Z.name]!=undefined&&this.oMeasureDetailsSet[Z.name].unitPropertyName!=undefined){Y.push(this.oMeasureDetailsSet[Z.name].unitPropertyName);}}}for(var j=0,l=X.length;j<l;j++){if(/^\$select/i.test(X[j])){if(this.mParameters.select){e=X[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(Y.indexOf(p)===-1){Y.push(p);}}}X[j]="$select="+Y.join(",");break;}}if(s){X.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){X.push(this.sCustomParams);}if(W){return this.oModel._createRequestUrl(W,null,X).replace(/ /g,"%20");}};G.prototype._addSorters=function(s,g){var e=this._canApplySortersToGroups()?[].concat(this.aSorter).concat(g):[].concat(g).concat(this.aSorter);e.forEach(function(o){s.addSorter(o.sPath,o.bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);});};G.prototype._canApplySortersToGroups=function(){var s=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(s!==this.sLastAutoExpandMode&&s!==f.Sequential){x.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+s,this.sPath);}this.sLastAutoExpandMode=s;}return s===f.Sequential;}return false;};G.prototype._warnNoSortingOfGroups=function(s){var m;if(this.bApplySortersToGroups){m="Detected a multi-unit case, so sorting is only possible on leaves";if(s){m+="; "+s;}x.warning(m,this.sPath);}this.bApplySortersToGroups=false;};G.prototype._isSkippingTotalForMeasure=function(m){var o=this.mAnalyticalInfoByProperty[m];return!!o&&o.total==false;};G.Logger=x;return G;});
