/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_GroupLock","./_Helper","./_Requestor","sap/base/Log","sap/base/util/isEmptyObject","sap/ui/base/SyncPromise"],function(_,a,b,L,c,S){"use strict";var C="sap.ui.model.odata.v4.lib._Cache",r=/\(\$uid=[-\w]+\)$/,m="@com.sap.vocabularies.Common.v1.Messages",d=/^-?\d+$/,e=/^([^(]*)(\(.*\))$/;function f(i,p,l,D){if(l.$count!==undefined){s(i,p,l,l.$count+D);}}function g(R,p){return p===""||R===p||R.startsWith(p+"/");}function s(i,p,l,v){if(typeof v==="string"){v=parseInt(v);}a.updateExisting(i,p,l,{$count:v});}function h(R,i,q,l,G,n){this.iActiveUsages=1;this.mChangeListeners={};this.fnGetOriginalResourcePath=G;this.iInactiveSince=Infinity;this.mPatchRequests={};this.oPendingRequestsPromise=null;this.mPostRequests={};this.oRequestor=R;this.bSentRequest=false;this.bSortExpandSelect=l;this.setResourcePath(i);this.setQueryOptions(q);this.bSharedRequest=n;}h.prototype._delete=function(G,E,p,o,i){var l=p.split("/"),D=l.pop(),I=d.test(D)?Number(D):undefined,n=l.join("/"),t=this;this.checkSharedRequest();this.addPendingRequest();return this.fetchValue(_.$cached,n).then(function(v){var q=h.from$skip(D,v),u=D?v[q]||v.$byPredicate[q]:v,H,K=a.getPrivateAnnotation(u,"predicate"),w=a.buildPath(n,Array.isArray(v)?K:D),T=a.getPrivateAnnotation(u,"transient");if(T===true){throw new Error("No 'delete' allowed while waiting for server response");}if(T){G.unlock();t.oRequestor.removePost(T,u);return undefined;}if(u["$ui5.deleting"]){throw new Error("Must not delete twice: "+E);}u["$ui5.deleting"]=true;H={"If-Match":o||u};E+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return S.all([t.oRequestor.request("DELETE",E,G.getUnlockedCopy(),H,undefined,undefined,undefined,undefined,a.buildPath(t.getOriginalResourcePath(u),w)).catch(function(x){if(x.status!==404){delete u["$ui5.deleting"];throw x;}}).then(function(){if(Array.isArray(v)){i(t.removeElement(v,I,K,n),v);}else{if(D){a.updateExisting(t.mChangeListeners,n,v,h.makeUpdateData([D],null));}else{u["$ui5.deleted"]=true;}i();}t.oRequestor.getModelInterface().reportBoundMessages(t.sResourcePath,[],[w]);}),I===undefined&&t.requestCount(G.getUnlockedCopy()),G.unlock()]);}).finally(function(){t.removePendingRequest();});};h.prototype.addPendingRequest=function(){var R;if(!this.oPendingRequestsPromise){this.oPendingRequestsPromise=new S(function(i){R=i;});this.oPendingRequestsPromise.$count=0;this.oPendingRequestsPromise.$resolve=R;}this.oPendingRequestsPromise.$count+=1;};h.prototype.calculateKeyPredicate=function(i,t,M){var p,T=t[M];if(T&&T.$Key){p=a.getKeyPredicate(i,M,t);if(p){a.setPrivateAnnotation(i,"predicate",p);}}return p;};h.prototype.checkSharedRequest=function(){if(this.bSharedRequest){throw new Error(this+" is read-only");}};h.prototype.create=function(G,p,i,t,E,l,n){var o,K=E&&E["@$ui5.keepTransientPath"],q,u=this;function v(){a.removeByPath(u.mPostRequests,i,E);o.splice(o.indexOf(E),1);o.$created-=1;f(u.mChangeListeners,i,o,-1);delete o.$byPredicate[t];if(!i){u.adjustReadRequests(0,-1);}G.cancel();}function w(){u.addPendingRequest();a.setPrivateAnnotation(E,"transient",true);n();}function x(y,z){var A=z.getGroupId();a.setPrivateAnnotation(E,"transient",A);a.addByPath(u.mPostRequests,i,E);return S.all([u.oRequestor.request("POST",y,z,null,q,w,v,undefined,a.buildPath(u.sResourcePath,i,t)),u.fetchTypes()]).then(function(R){var B=R[0],D;a.deletePrivateAnnotation(E,"postBody");a.deletePrivateAnnotation(E,"transient");E["@$ui5.context.isTransient"]=false;a.removeByPath(u.mPostRequests,i,E);u.visitResponse(B,R[1],a.getMetaPath(a.buildPath(u.sMetaPath,i)),i+t,K);if(!K){D=a.getPrivateAnnotation(B,"predicate");if(D){o.$byPredicate[D]=E;a.updateTransientPaths(u.mChangeListeners,t,D);}}a.updateSelected(u.mChangeListeners,a.buildPath(i,D||t),E,B,a.getQueryOptionsForPath(u.mQueryOptions,i).$select);u.removePendingRequest();return E;},function(B){if(B.canceled){throw B;}u.removePendingRequest();l(B);if(u.fetchTypes().isRejected()){throw B;}return x(y,u.oRequestor.lockGroup(u.oRequestor.getGroupSubmitMode(A)==="API"?A:"$parked."+A,u,true,true));});}this.checkSharedRequest();E=a.merge({},E);E=b.cleanPayload(E);q=a.merge({},E);a.setPrivateAnnotation(E,"postBody",q);a.setPrivateAnnotation(E,"transientPredicate",t);E["@$ui5.context.isTransient"]=true;o=this.getValue(i);if(!Array.isArray(o)){throw new Error("Create is only supported for collections; '"+i+"' does not reference a collection");}o.unshift(E);o.$created+=1;f(this.mChangeListeners,i,o,1);o.$byPredicate=o.$byPredicate||{};o.$byPredicate[t]=E;if(!i){u.adjustReadRequests(0,1);}return p.then(function(y){y+=u.oRequestor.buildQueryString(u.sMetaPath,u.mQueryOptions,true);return x(y,G);});};h.prototype.deregisterChange=function(p,l){if(!this.bSharedRequest){a.removeByPath(this.mChangeListeners,p,l);}};h.prototype.drillDown=function(D,p,G,l){var o=S.resolve(D),E,n,q,t=false,u=this;function v(i){L.error("Failed to drill-down into "+p+", invalid segment: "+i,u.toString(),C);return undefined;}function w(V,i,x){var y=q.slice(0,x).join("/"),R,z;if(Array.isArray(V)){return v(i);}return u.oRequestor.getModelInterface().fetchMetadata(u.sMetaPath+"/"+a.getMetaPath(y)).then(function(A){if(!A){return v(i);}if(A.$Type==="Edm.Stream"){R=V[i+"@odata.mediaReadLink"]||V[i+"@mediaReadLink"];z=u.oRequestor.getServiceUrl();return R||a.buildPath(z+u.sResourcePath,y);}if(!t){if(!E&&!Array.isArray(D)){E=D;n=0;}return E&&u.fetchLateProperty(G,E,q.slice(0,n).join("/"),q.slice(n).join("/"),q.slice(n,x).join("/"))||v(i);}if(A.$kind==="NavigationProperty"){return null;}if(!A.$Type.startsWith("Edm.")){return{};}if("$DefaultValue"in A){return A.$Type==="Edm.String"?A.$DefaultValue:a.parseLiteral(A.$DefaultValue,A.$Type,y);}return null;});}if(!p){return o;}q=p.split("/");return q.reduce(function(x,y,i){return x.then(function(V){var I,M,z;if(y==="$count"){return Array.isArray(V)?V.$count:v(y);}if(V===undefined||V===null){return undefined;}if(typeof V!=="object"||y==="@$ui5._"||Array.isArray(V)&&(y[0]==="$"||y==="length")){return v(y);}if(a.hasPrivateAnnotation(V,"predicate")){E=V;n=i;}z=V;t=t||a.getPrivateAnnotation(V,"transient");M=e.exec(y);if(M){if(M[1]){V=V[M[1]];}if(V){V=V.$byPredicate&&V.$byPredicate[M[2]];}}else{I=h.from$skip(y,V);if(l&&I===y&&(V[y]===undefined||V[y]===null)){V[y]={};}V=V[I];}return V===undefined&&y[0]!=="#"&&y[0]!=="@"?w(z,y,i+1):V;});},o);};h.prototype.fetchLateProperty=function(G,R,i,l,M){var F,n,o,p,q,t,u=a.getMetaPath(i),T=this.fetchTypes().getResult(),U=[l],v=this;function w(Q,B){var x=a.buildPath(F,B),E=T[x],y;if(!E){E=v.fetchType(T,x).getResult();}if(B){(E.$Key||[]).forEach(function(K){if(typeof K==="object"){K=K[Object.keys(K)[0]];}U.push(a.buildPath(B,K));});U.push(B+"/@odata.etag");U.push(B+"/@$ui5._/predicate");}if(Q.$expand){y=Object.keys(Q.$expand)[0];w(Q.$expand[y],a.buildPath(B,y));}}if(!this.mLateQueryOptions){return undefined;}F=a.buildPath(this.sMetaPath,u);q=a.intersectQueryOptions(a.getQueryOptionsForPath(this.mLateQueryOptions,i),[l],this.oRequestor.getModelInterface().fetchMetadata,F,{});if(!q){return undefined;}w(q);n=a.buildPath(this.sResourcePath,i);t=n+this.oRequestor.buildQueryString(F,q,false,true);p=this.mPropertyRequestByPath[t];if(!p){o=n+this.oRequestor.buildQueryString(F,this.mQueryOptions,true);p=this.oRequestor.request("GET",o,G.getUnlockedCopy(),undefined,undefined,undefined,undefined,F,undefined,false,q).then(function(D){v.visitResponse(D,T,F,i);return D;}).finally(function(){delete v.mPropertyRequestByPath[t];});this.mPropertyRequestByPath[t]=p;}return p.then(function(D){var x=a.getPrivateAnnotation(D,"predicate");if(x&&a.getPrivateAnnotation(R,"predicate")!==x){throw new Error("GET "+t+": Key predicate changed from "+a.getPrivateAnnotation(R,"predicate")+" to "+x);}if(D["@odata.etag"]!==R["@odata.etag"]){throw new Error("GET "+t+": ETag changed");}a.updateSelected(v.mChangeListeners,i,R,D,U);return a.drillDown(R,M.split("/"));});};h.prototype.fetchType=function(t,M){var i=this;return this.oRequestor.fetchTypeForPath(M).then(function(T){var o,p=[];if(T){o=i.oRequestor.getModelInterface().fetchMetadata(M+"/"+m).getResult();if(o){T=Object.create(T);T[m]=o;}t[M]=T;(T.$Key||[]).forEach(function(K){if(typeof K==="object"){K=K[Object.keys(K)[0]];p.push(i.fetchType(t,M+"/"+K.slice(0,K.lastIndexOf("/"))));}});return S.all(p).then(function(){return T;});}});};h.prototype.fetchTypes=function(){var p,t,i=this;function l(B,q){if(q&&q.$expand){Object.keys(q.$expand).forEach(function(n){var M=B;n.split("/").forEach(function(o){M+="/"+o;p.push(i.fetchType(t,M));});l(M,q.$expand[n]);});}}if(!this.oTypePromise){p=[];t={};p.push(this.fetchType(t,this.sMetaPath));l(this.sMetaPath,this.mQueryOptions);this.oTypePromise=S.all(p).then(function(){return t;});}return this.oTypePromise;};h.prototype.getDownloadUrl=function(p,i){var q=this.mQueryOptions;if(p){q=a.getQueryOptionsForPath(q,p);q=a.merge({},i,q);}return this.oRequestor.getServiceUrl()+a.buildPath(this.sResourcePath,p)+this.oRequestor.buildQueryString(a.buildPath(this.sMetaPath,a.getMetaPath(p)),q);};h.prototype.getLateQueryOptions=function(){return this.mLateQueryOptions;};h.prototype.getMeasureRangePromise=function(){return undefined;};h.prototype.getValue=function(p){throw new Error("Unsupported operation");};h.prototype.getOriginalResourcePath=function(E){return this.fnGetOriginalResourcePath&&this.fnGetOriginalResourcePath(E)||this.sResourcePath;};h.prototype.getResourcePath=function(){return this.sResourcePath;};h.prototype.hasChangeListeners=function(){return!c(this.mChangeListeners);};h.prototype.hasPendingChangesForPath=function(p){return Object.keys(this.mPatchRequests).some(function(R){return g(R,p);})||Object.keys(this.mPostRequests).some(function(R){return g(R,p);});};h.prototype.hasSentRequest=function(){return this.bSentRequest;};h.prototype.patch=function(p,D){var t=this;this.checkSharedRequest();return this.fetchValue(_.$cached,p).then(function(o){a.updateExisting(t.mChangeListeners,p,o,D);return o;});};h.prototype.refreshSingle=function(G,p,i,l,K,D){var t=this;this.checkSharedRequest();return this.fetchValue(_.$cached,p).then(function(E){var q=Object.assign({},a.getQueryOptionsForPath(t.mQueryOptions,p)),R;if(i!==undefined){l=a.getPrivateAnnotation(E[i],"predicate");}R=a.buildPath(t.sResourcePath,p,l);if(K&&t.mLateQueryOptions){a.aggregateQueryOptions(q,t.mLateQueryOptions);}delete q.$apply;delete q.$count;delete q.$filter;delete q.$orderby;delete q.$search;R+=t.oRequestor.buildQueryString(t.sMetaPath,q,false,t.bSortExpandSelect);t.bSentRequest=true;return S.all([t.oRequestor.request("GET",R,G,undefined,undefined,D),t.fetchTypes()]).then(function(n){var o=n[0];t.replaceElement(E,i,l,o,n[1],p);return o;});});};h.prototype.refreshSingleWithRemove=function(G,p,i,l,K,D,o){var t=this;this.checkSharedRequest();return S.all([this.fetchValue(_.$cached,p),this.fetchTypes()]).then(function(R){var E=R[0],n,I,q={},u,v,Q=Object.assign({},a.getQueryOptionsForPath(t.mQueryOptions,p)),w,x=a.buildPath(t.sResourcePath,p),y=[],T=R[1];if(i!==undefined){n=E[i];l=a.getPrivateAnnotation(n,"predicate");}else{n=E.$byPredicate[l];}v=a.getKeyFilter(n,t.sMetaPath,T);I=(Q.$filter?"("+Q.$filter+") and ":"")+v;delete Q.$count;delete Q.$orderby;t.bSentRequest=true;if(K){if(t.mLateQueryOptions){a.aggregateQueryOptions(Q,t.mLateQueryOptions);}q=Object.assign({},Q);q.$filter=I;Q.$filter=v;delete Q.$search;w=x+t.oRequestor.buildQueryString(t.sMetaPath,Q,false,t.bSortExpandSelect);y.push(t.oRequestor.request("GET",w,G,undefined,undefined,D));if(i!==undefined&&(v!==I||q.$search)){delete q.$select;delete q.$expand;q.$count=true;q.$top=0;u=x+t.oRequestor.buildQueryString(t.sMetaPath,q);y.push(t.oRequestor.request("GET",u,G.getUnlockedCopy()));}}else{Q.$filter=I;w=x+t.oRequestor.buildQueryString(t.sMetaPath,Q,false,t.bSortExpandSelect);y.push(t.oRequestor.request("GET",w,G,undefined,undefined,D));}return S.all(y).then(function(R){var z=R[0].value,A=R[1]&&R[1]["@odata.count"]==="0";if(z.length>1){throw new Error("Unexpected server response, more than one entity returned.");}else if(z.length===0){t.removeElement(E,i,l,p);t.oRequestor.getModelInterface().reportBoundMessages(t.sResourcePath,[],[p+l]);o(false);}else if(A){t.removeElement(E,i,l,p);t.replaceElement(E,undefined,l,z[0],T,p);o(true);}else{t.replaceElement(E,i,l,z[0],T,p);}});});};h.prototype.registerChange=function(p,l){if(!this.bSharedRequest){a.addByPath(this.mChangeListeners,p,l);}};h.prototype.removeElement=function(E,i,p,l){var o,t;o=E.$byPredicate[p];if(i!==undefined){i=h.getElementIndex(E,p,i);E.splice(i,1);f(this.mChangeListeners,l,E,-1);}delete E.$byPredicate[p];t=a.getPrivateAnnotation(o,"transientPredicate");if(t){E.$created-=1;delete E.$byPredicate[t];}else if(!l){if(i!==undefined){this.iLimit-=1;this.adjustReadRequests(i,-1);}}return i;};h.prototype.removePendingRequest=function(){if(this.oPendingRequestsPromise){this.oPendingRequestsPromise.$count-=1;if(!this.oPendingRequestsPromise.$count){this.oPendingRequestsPromise.$resolve();this.oPendingRequestsPromise=null;}}};h.prototype.replaceElement=function(E,i,p,o,t,l){var O,T;if(i===undefined){E.$byPredicate[p]=o;}else{i=h.getElementIndex(E,p,i);O=E[i];E[i]=E.$byPredicate[p]=o;T=a.getPrivateAnnotation(O,"transientPredicate");if(T){o["@$ui5.context.isTransient"]=false;E.$byPredicate[T]=o;a.setPrivateAnnotation(o,"transientPredicate",T);}}this.visitResponse(o,t,a.getMetaPath(a.buildPath(this.sMetaPath,l)),l+p);};h.prototype.requestCount=function(G){var E,q,R,t=this;if(this.mQueryOptions&&this.mQueryOptions.$count){q=Object.assign({},this.mQueryOptions);delete q.$expand;delete q.$orderby;delete q.$select;E=this.getFilterExcludingCreated();if(E){q.$filter=q.$filter?"("+q.$filter+") and "+E:E;}q.$top=0;R=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,q);return this.oRequestor.request("GET",R,G).then(function(o){var i=parseInt(o["@odata.count"])+t.aElements.$created;s(t.mChangeListeners,"",t.aElements,i);t.iLimit=i;});}};h.prototype.resetChangesForPath=function(p){var t=this;Object.keys(this.mPatchRequests).forEach(function(R){var i,l;if(g(R,p)){l=t.mPatchRequests[R];for(i=l.length-1;i>=0;i-=1){t.oRequestor.removePatch(l[i]);}delete t.mPatchRequests[R];}});Object.keys(this.mPostRequests).forEach(function(R){var E,i,T;if(g(R,p)){E=t.mPostRequests[R];for(i=E.length-1;i>=0;i-=1){T=a.getPrivateAnnotation(E[i],"transient");t.oRequestor.removePost(T,E[i]);}delete t.mPostRequests[R];}});};h.prototype.setActive=function(A){if(A){this.iActiveUsages+=1;this.iInactiveSince=Infinity;}else{this.iActiveUsages-=1;if(!this.iActiveUsages){this.iInactiveSince=Date.now();}this.mChangeListeners={};}};h.prototype.setLateQueryOptions=function(q){if(q){this.mLateQueryOptions={$select:q.$select,$expand:q.$expand};}else{this.mLateQueryOptions=null;}};h.prototype.setProperty=function(p,v,E){var t=this;this.checkSharedRequest();return this.fetchValue(_.$cached,E,null,null,true).then(function(o){a.updateSelected(t.mChangeListeners,E,o,h.makeUpdateData(p.split("/"),v));});};h.prototype.setQueryOptions=function(q){this.checkSharedRequest();if(this.bSentRequest){throw new Error("Cannot set query options: Cache has already sent a request");}this.mQueryOptions=q;this.sQueryString=this.oRequestor.buildQueryString(this.sMetaPath,q,false,this.bSortExpandSelect);};h.prototype.setResourcePath=function(R){this.checkSharedRequest();this.sResourcePath=R;this.sMetaPath=a.getMetaPath("/"+R);this.oTypePromise=undefined;this.mLateQueryOptions=null;this.mPropertyRequestByPath={};};h.prototype.toString=function(){return this.oRequestor.getServiceUrl()+this.sResourcePath+this.sQueryString;};h.prototype.update=function(G,p,v,E,i,l,u,n,o){var q,t=p.split("/"),U,w=this;this.checkSharedRequest();try{q=this.fetchValue(_.$cached,l);}catch(x){if(!x.$cached){throw x;}q=S.resolve({"@odata.etag":"*"});}return q.then(function(y){var F=a.buildPath(l,p),z=G.getGroupId(),O,A,B,D,T,H,I=h.makeUpdateData(t,v);function J(){a.removeByPath(w.mPatchRequests,F,A);a.updateExisting(w.mChangeListeners,l,y,h.makeUpdateData(t,O));}function K(M,N){var R;function Q(){R=w.oRequestor.lockGroup(z,w,true);if(o){o();}}A=w.oRequestor.request("PATCH",i,M,{"If-Match":y},I,Q,J,undefined,a.buildPath(w.getOriginalResourcePath(y),l),N);a.addByPath(w.mPatchRequests,F,A);return S.all([A,w.fetchTypes()]).then(function(V){var W=V[0];a.removeByPath(w.mPatchRequests,F,A);if(!n){w.visitResponse(W,V[1],a.getMetaPath(a.buildPath(w.sMetaPath,l)),l);}a.updateExisting(w.mChangeListeners,l,y,n?{"@odata.etag":W["@odata.etag"]}:W);},function(x){var V=z;a.removeByPath(w.mPatchRequests,F,A);if(!E||x.canceled){throw x;}E(x);switch(w.oRequestor.getGroupSubmitMode(z)){case"API":break;case"Auto":if(!w.oRequestor.hasChanges(z,y)){V="$parked."+z;}break;default:throw x;}R.unlock();R=undefined;return K(w.oRequestor.lockGroup(V,w,true,true),true);}).finally(function(){if(R){R.unlock();}});}if(!y){throw new Error("Cannot update '"+p+"': '"+l+"' does not exist");}T=a.getPrivateAnnotation(y,"transient");if(T){if(T===true){throw new Error("No 'update' allowed while waiting for server response");}if(T.startsWith("$parked.")){D=T;T=T.slice(8);}if(T!==z){throw new Error("The entity will be created via group '"+T+"'. Cannot patch via group '"+z+"'");}}O=a.drillDown(y,t);a.updateAll(w.mChangeListeners,l,y,I);B=a.getPrivateAnnotation(y,"postBody");if(B){a.updateAll({},l,B,I);}if(u){U=u.split("/");u=a.buildPath(l,u);H=w.getValue(u);if(H===undefined){L.debug("Missing value for unit of measure "+u+" when updating "+F,w.toString(),C);}else{a.merge(T?B:I,h.makeUpdateData(U,H));}}if(T){if(D){a.setPrivateAnnotation(y,"transient",T);w.oRequestor.relocate(D,B,T);}G.unlock();return Promise.resolve();}w.oRequestor.relocateAll("$parked."+z,z,y);i+=w.oRequestor.buildQueryString(w.sMetaPath,w.mQueryOptions,true);return K(G);});};h.prototype.visitResponse=function(R,t,l,n,K,o){var p,H=false,q={},u=this.oRequestor.getServiceUrl()+this.sResourcePath,v=this;function w(M,i,A){H=true;if(M&&M.length){q[i]=M;M.forEach(function(B){if(B.longtextUrl){B.longtextUrl=a.makeAbsolute(B.longtextUrl,A);}});}}function x(B,i){return i?a.makeAbsolute(i,B):B;}function y(I,M,A,B){var D={},i,E,F,G;for(i=0;i<I.length;i+=1){F=I[i];E=A===""?o+i:i;if(F&&typeof F==="object"){z(F,M,A,B,E);G=a.getPrivateAnnotation(F,"predicate");if(!A){p.push(G||E.toString());}if(G){D[G]=F;I.$byPredicate=D;}}}}function z(i,M,I,A,B){var D,E,T=t[M],F=T&&T[m]&&T[m].$Path,G;A=x(A,i["@odata.context"]);E=v.calculateKeyPredicate(i,t,M);if(B!==undefined){I=a.buildPath(I,E||B);}else if(!K&&E){D=r.exec(I);if(D){I=I.slice(0,-D[0].length)+E;}}if(n&&!p){p=[I];}if(F){G=a.drillDown(i,F.split("/"));if(G!==undefined){w(G,I,A);}}Object.keys(i).forEach(function(J){var N,O=M+"/"+J,Q=i[J],U=a.buildPath(I,J);if(J.endsWith("@odata.mediaReadLink")||J.endsWith("@mediaReadLink")){i[J]=a.makeAbsolute(Q,A);}if(J.includes("@")){return;}if(Array.isArray(Q)){Q.$created=0;Q.$count=undefined;N=i[J+"@odata.count"];if(N){s({},"",Q,N);}else if(!i[J+"@odata.nextLink"]){s({},"",Q,Q.length);}y(Q,O,U,x(A,i[J+"@odata.context"]));}else if(Q&&typeof Q==="object"){z(Q,O,U,A);}});}if(o!==undefined){p=[];y(R.value,l||this.sMetaPath,"",x(u,R["@odata.context"]));}else if(R&&typeof R==="object"){z(R,l||this.sMetaPath,n||"",u);}if(H){this.oRequestor.getModelInterface().reportBoundMessages(this.getOriginalResourcePath(R),q,p);}};function j(R,i,q,l,D,n){h.call(this,R,i,q,l,function(){return D;},n);this.sContext=undefined;this.aElements=[];this.aElements.$byPredicate={};this.aElements.$count=undefined;this.aElements.$created=0;this.aElements.$tail=undefined;this.iLimit=Infinity;this.aReadRequests=[];this.bServerDrivenPaging=false;this.oSyncPromiseAll=undefined;}j.prototype=Object.create(h.prototype);j.prototype.addKeptElement=function(E){this.aElements.$byPredicate[a.getPrivateAnnotation(E,"predicate")]=E;};j.prototype.adjustReadRequests=function(i,o){this.aReadRequests.forEach(function(R){if(R.iStart>=i){R.iStart+=o;R.iEnd+=o;}});};j.prototype.fetchValue=function(G,p,D,l,i){var E,F=p.split("/")[0],o,t=this;G.unlock();if(this.aElements.$byPredicate[F]){o=S.resolve();}else if((G===_.$cached||F!=="$count")&&this.aElements[F]!==undefined){o=S.resolve(this.aElements[F]);}else{if(!this.oSyncPromiseAll){E=this.aElements.$tail?this.aElements.concat(this.aElements.$tail):this.aElements;this.oSyncPromiseAll=S.all(E);}o=this.oSyncPromiseAll;}return o.then(function(){t.registerChange(p,l);return t.drillDown(t.aElements,p,G,i);});};j.prototype.fill=function(p,l,E){var i,n=Math.max(this.aElements.length,1024);if(E>n){if(this.aElements.$tail&&p){throw new Error("Cannot fill from "+l+" to "+E+", $tail already in use, # of elements is "+this.aElements.length);}this.aElements.$tail=p;E=this.aElements.length;}for(i=l;i<E;i+=1){this.aElements[i]=p;}this.oSyncPromiseAll=undefined;};j.prototype.getFilterExcludingCreated=function(){var E,i,K,l=[],t;for(i=0;i<this.aElements.$created;i+=1){E=this.aElements[i];if(!E["@$ui5.context.isTransient"]){t=t||this.fetchTypes().getResult();K=a.getKeyFilter(E,this.sMetaPath,t);if(K){l.push(K);}}}return l.length?"not ("+l.join(" or ")+")":undefined;};j.prototype.getQueryString=function(){var E=this.getFilterExcludingCreated(),q=Object.assign({},this.mQueryOptions),F=q.$filter,Q=this.sQueryString;if(E){if(F){q.$filter="("+F+") and "+E;Q=this.oRequestor.buildQueryString(this.sMetaPath,q,false,this.bSortExpandSelect);}else{Q+=(Q?"&":"?")+"$filter="+a.encode(E,false);}}return Q;};j.prototype.getReadRange=function(l,n,p){var E=this.aElements;function o(l,q){var i;for(i=l;i<q;i+=1){if(E[i]===undefined){return true;}}return false;}if(o(l+n,l+n+p/2)){n+=p;}if(o(Math.max(l-p/2,0),l)){n+=p;l-=p;if(l<0){n+=l;if(isNaN(n)){n=Infinity;}l=0;}}return{length:n,start:l};};j.prototype.getResourcePathWithQuery=function(i,E){var l=this.aElements.$created,q=this.getQueryString(),D=q?"&":"?",n=E-i,R=this.sResourcePath+q;if(i<l){throw new Error("Must not request created element");}i-=l;if(i>0||n<Infinity){R+=D+"$skip="+i;}if(n<Infinity){R+="&$top="+n;}return R;};j.prototype.getValue=function(p){var o=this.drillDown(this.aElements,p,_.$cached);if(o.isFulfilled()){return o.getResult();}};j.prototype.handleResponse=function(l,E,R,t){var n=-1,o,p=this.aElements.$created,q,i,K,O=this.aElements.$count,u,v=R.value.length;this.sContext=R["@odata.context"];this.visitResponse(R,t,undefined,undefined,undefined,l);for(i=0;i<v;i+=1){q=R.value[i];u=a.getPrivateAnnotation(q,"predicate");if(u){K=this.aElements.$byPredicate[u];if(K){if(q["@odata.etag"]===K["@odata.etag"]){q=K;}else if(this.hasPendingChangesForPath(u)){throw new Error("Modified on client and on server: "+this.sResourcePath+u);}}this.aElements.$byPredicate[u]=q;}this.aElements[l+i]=q;}o=R["@odata.count"];if(o){this.iLimit=n=parseInt(o);}if(R["@odata.nextLink"]){this.bServerDrivenPaging=true;if(E<this.aElements.length){for(i=l+v;i<E;i+=1){delete this.aElements[i];}}else{this.aElements.length=l+v;}}else if(v<E-l){if(n===-1){n=O&&O-p;}n=Math.min(n!==undefined?n:Infinity,l-p+v);this.aElements.length=p+n;this.iLimit=n;if(!o&&n>0&&!this.aElements[n-1]){n=undefined;}}if(n!==-1){s(this.mChangeListeners,"",this.aElements,n!==undefined?n+p:undefined);}};j.prototype.read=function(I,l,p,G,D){var i,n,E,o,q=-1,t=this.oPendingRequestsPromise||this.aElements.$tail,R,u=this;if(I<0){throw new Error("Illegal index "+I+", must be >= 0");}if(l<0){throw new Error("Illegal length "+l+", must be >= 0");}if(t){return t.then(function(){return u.read(I,l,p,G,D);});}R=this.getReadRange(I,l,this.bServerDrivenPaging?0:p);o=Math.min(R.start+R.length,this.aElements.$created+this.iLimit);n=Math.min(o,Math.max(R.start,this.aElements.length)+1);for(i=R.start;i<n;i+=1){if(this.aElements[i]!==undefined){if(q>=0){this.requestElements(q,i,G.getUnlockedCopy(),D);D=undefined;q=-1;}}else if(q<0){q=i;}}if(q>=0){this.requestElements(q,o,G.getUnlockedCopy(),D);}G.unlock();E=this.aElements.slice(I,o);if(this.aElements.$tail){E.push(this.aElements.$tail);}return S.all(E).then(function(){var v=u.aElements.slice(I,o);v.$count=u.aElements.$count;return{"@odata.context":u.sContext,value:v};});};j.prototype.requestElements=function(i,E,G,D){var p,R={iEnd:E,iStart:i},t=this;this.aReadRequests.push(R);this.bSentRequest=true;p=S.all([this.oRequestor.request("GET",this.getResourcePathWithQuery(i,E),G,undefined,undefined,D),this.fetchTypes()]).then(function(l){if(t.aElements.$tail===p){t.aElements.$tail=undefined;}t.handleResponse(R.iStart,R.iEnd,l[0],l[1]);}).catch(function(o){t.fill(undefined,R.iStart,R.iEnd);throw o;}).finally(function(){t.aReadRequests.splice(t.aReadRequests.indexOf(R),1);});this.fill(p,i,E);};j.prototype.requestSideEffects=function(G,p,N,l,o){var E,F=[],M,q,R,t=this.fetchTypes().getResult(),u=this,i;function v(n){var w=a.getKeyFilter(n,u.sMetaPath,t);F.push(w);return w;}this.checkSharedRequest();if(this.oPendingRequestsPromise){return this.oPendingRequestsPromise.then(function(){return u.requestSideEffects(G,p,N,l,o);});}q=a.intersectQueryOptions(this.mLateQueryOptions||this.mQueryOptions,p,this.oRequestor.getModelInterface().fetchMetadata,this.sMetaPath,N,"",true);if(!q){return S.resolve();}if(o===undefined){if(!v(this.aElements[l])){return null;}}else{for(i=0;i<this.aElements.length;i+=1){E=this.aElements[i];if(!E||a.hasPrivateAnnotation(E,"transient")){continue;}if((i<l||i>=l+o)&&!a.hasPrivateAnnotation(E,"transientPredicate")){delete this.aElements.$byPredicate[a.getPrivateAnnotation(E,"predicate")];delete this.aElements[i];continue;}if(!v(E)){return null;}}this.aElements.length=o?Math.min(l+o,this.aElements.length):this.aElements.$created;if(!F.length){return S.resolve();}}q.$filter=F.join(" or ");if(F.length>1){q.$top=F.length;}a.selectKeyProperties(q,t[this.sMetaPath]);delete q.$count;delete q.$orderby;delete q.$search;M=a.extractMergeableQueryOptions(q);R=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,q,false,true);return this.oRequestor.request("GET",R,G,undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,M).then(function(w){var E,x,i,n;function y(z){z=z.slice(x.length+1);return!p.some(function(A){return a.getRelativePath(z,A)!==undefined;});}if(w.value.length!==F.length){throw new Error("Expected "+F.length+" row(s), but instead saw "+w.value.length);}u.visitResponse(w,t,undefined,"",false,NaN);for(i=0,n=w.value.length;i<n;i+=1){E=w.value[i];x=a.getPrivateAnnotation(E,"predicate");a.updateAll(u.mChangeListeners,x,u.aElements.$byPredicate[x],E,y);}});};function P(R,i,q){h.call(this,R,i,q);this.oPromise=null;}P.prototype=Object.create(h.prototype);P.prototype._delete=function(){throw new Error("Unsupported");};P.prototype.create=function(){throw new Error("Unsupported");};P.prototype.fetchValue=function(G,p,D,l,i){var t=this;if(i){throw new Error("Unsupported argument: bCreateOnDemand");}if(this.oPromise){G.unlock();}else{this.bSentRequest=true;this.oPromise=S.resolve(this.oRequestor.request("GET",this.sResourcePath+this.sQueryString,G,undefined,undefined,D,undefined,this.sMetaPath));}return this.oPromise.then(function(R){R=R||{value:null};t.registerChange("",l);return R.value;});};P.prototype.update=function(){throw new Error("Unsupported");};function k(R,i,q,l,n,G,p,M){h.call(this,R,i,q,l,G,n);this.sMetaPath=M||this.sMetaPath;this.bPost=p;this.bPosting=false;this.oPromise=null;}k.prototype=Object.create(h.prototype);k.prototype.fetchValue=function(G,p,D,l,i){var R=this.sResourcePath+this.sQueryString,t=this;if(this.oPromise){G.unlock();}else{if(this.bPost){throw new Error("Cannot fetch a value before the POST request");}this.bSentRequest=true;this.oPromise=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D,undefined,this.sMetaPath),this.fetchTypes()]).then(function(n){t.visitResponse(n[0],n[1]);return n[0];});}return this.oPromise.then(function(o){if(o&&o["$ui5.deleted"]){throw new Error("Cannot read a deleted entity");}t.registerChange(p,l);return t.drillDown(o,p,G,i);});};k.prototype.getValue=function(p){var o;if(this.oPromise&&this.oPromise.isFulfilled()){o=this.drillDown(this.oPromise.getResult(),p,_.$cached);if(o.isFulfilled()){return o.getResult();}}};k.prototype.post=function(G,D,E){var i,H="POST",t=this;this.checkSharedRequest();if(!this.bPost){throw new Error("POST request not allowed");}if(this.bPosting){throw new Error("Parallel POST requests not allowed");}if(E){i=G.getGroupId();this.oRequestor.relocateAll("$parked."+i,i,E);}if(D){H=D["X-HTTP-Method"]||H;delete D["X-HTTP-Method"];if(this.oRequestor.isActionBodyOptional()&&!Object.keys(D).length){D=undefined;}}this.bPosting=true;this.bSentRequest=true;this.oPromise=S.all([this.oRequestor.request(H,this.sResourcePath+this.sQueryString,G,E&&{"If-Match":E},D),this.fetchTypes()]).then(function(R){t.visitResponse(R[0],R[1]);t.bPosting=false;return R[0];},function(o){t.bPosting=false;throw o;});return this.oPromise;};k.prototype.requestSideEffects=function(G,p,n,R){var M,o=this.oPromise,q,i,t=this;this.checkSharedRequest();q=o&&a.intersectQueryOptions(this.mLateQueryOptions||this.mQueryOptions,p,this.oRequestor.getModelInterface().fetchMetadata,this.sMetaPath,n);if(!q){return S.resolve();}M=a.extractMergeableQueryOptions(q);R=(R||this.sResourcePath)+this.oRequestor.buildQueryString(this.sMetaPath,q,false,true);i=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,M),this.fetchTypes(),this.fetchValue(_.$cached,"")]).then(function(l){return l;}).then(function(l){var N=l[0],O=l[2];t.visitResponse(N,l[1]);a.updateAll(t.mChangeListeners,"",O,N,function(u){return!p.some(function(v){return a.getRelativePath(u,v)!==undefined;});});});return i;};h.create=function(R,i,q,l,D,n){var o,K,p,t,u;if(n){p=i+R.buildQueryString(a.getMetaPath("/"+i),q,false,l);u=R.$mSharedCollectionCacheByPath;if(!u){u=R.$mSharedCollectionCacheByPath={};}t=u[p];if(t){t.setActive(true);}else{K=Object.keys(u);o=K.length;if(o>100){K.filter(function(v){return!u[v].iActiveUsages;}).sort(function(v,w){return u[v].iInactiveSince-u[w].iInactiveSince;}).every(function(v){delete u[v];o-=1;return o>100;});}t=u[p]=new j(R,i,q,l,D,n);}return t;}return new j(R,i,q,l,D);};h.createProperty=function(R,i,q){return new P(R,i,q);};h.createSingle=function(R,i,q,l,n,G,p,M){return new k(R,i,q,l,n,G,p,M);};h.from$skip=function(i,l){return d.test(i)?l.$created+Number(i):i;};h.getElementIndex=function(E,K,i){var o=E[i];if(!o||a.getPrivateAnnotation(o,"predicate")!==K){i=E.indexOf(E.$byPredicate[K]);}return i;};h.makeUpdateData=function(p,v){return p.reduceRight(function(V,i){var R={};R[i]=V;return R;},v);};return h;},false);
