/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/support/supportRules/ui/models/SelectionUtils","sap/ui/support/supportRules/ui/models/PresetsUtils","sap/ui/core/Fragment","sap/m/MessageToast","sap/m/MessageBox","sap/ui/support/supportRules/ui/models/Documentation","sap/ui/support/supportRules/util/Utils","sap/m/GroupHeaderListItem","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/support/library"],function(B,S,P,F,M,a,D,U,G,q,c,l){"use strict";var V=c.ValueState;var C={SELECT_FRAGMENT_ID:"presetsSelect",EXPORT_FRAGMENT_ID:"presetExport",IMPORT_FRAGMENT_ID:"presetImport",PRESET_GROUP_NONE:"None",PRESET_GROUP_SYSTEM:"System Presets",PRESET_GROUP_CUSTOM:"Custom Presets"};var b=B.extend("sap.ui.support.supportRules.ui.controllers.PresetsController",{constructor:function(m,v){B.call(this);this.oModel=m;this.oView=v;}});b.prototype.openPresetVariant=function(){var o=this.oView.byId("presetVariantBtn");o.focus();if(!this._oPresetsPopover){this._oPresetsPopover=sap.ui.xmlfragment(C.SELECT_FRAGMENT_ID,"sap.ui.support.supportRules.ui.views.Presets",this);this.oView.addDependent(this._oPresetsPopover);}if(!this._oPresetsPopover.isOpen()){this._oPresetsPopover.setInitialFocus(F.byId(C.SELECT_FRAGMENT_ID,"select").getSelectedItem().getId());this._oPresetsPopover.openBy(o);}else{this._oPresetsPopover.close();}};b.prototype.onPresetChange=function(e){var p=e.getParameter("listItem").getBindingContext().getPath();this._applyPreset(this.oModel.getProperty(p));};b.prototype.onPresetItemPress=function(){this._oPresetsPopover.close();};b.prototype.onPresetItemDelete=function(e){var p=e.getSource().getBindingContext().getPath(),d=this.oModel.getProperty(p),f=this.oModel.getProperty("/customPresets"),s=e.getSource().$().closest(".sapMLIB").attr("id");var g=this.oModel.getProperty("/selectionPresets");var i=g.indexOf(d);if(i!==-1){g.splice(i,1);}if(d.selected){g[0].selected=true;this._applyPreset(g[0]);}this.oModel.setProperty("/selectionPresets",g);if(d.isCustomPreset){f=f.filter(function(h){return h.id!==d.id;});this.oModel.setProperty("/customPresets",f);}if(P.isPersistingAllowed()){P.persistSelectionPresets();P.persistCustomPresets();}if(i!==g.length){var n=sap.ui.getCore().byId(s),o=n.ontap;n.ontap=function(){n.ontap=o;};}};b.prototype.onPresetItemReset=function(e){var p=e.getSource().getBindingContext().getPath(),o=this.oModel.getProperty(p),d=o.isSystemPreset?P.getSystemPresets():this.oModel.getProperty("/customPresets"),f=e.getSource().getParent().getParent().getParent();f.focus();d.forEach(function(i){if(i.id===o.id){this.oModel.setProperty(p+"/title",i.title);this.oModel.setProperty(p+"/selections",i.selections);this.oModel.setProperty(p+"/isModified",false);return true;}}.bind(this));if(o.selected){this._applyPreset(o);}};b.prototype.onImportPress=function(){if(!this._oImportDialog){this._oImportDialog=sap.ui.xmlfragment(C.IMPORT_FRAGMENT_ID,"sap.ui.support.supportRules.ui.views.PresetImport",this);this.oView.addDependent(this._oImportDialog);}this._oImportDialog.open();};b.prototype.onImportFileChange=function(e){var f=e.getSource(),r=new FileReader();if(!f.getValue()){return;}this._clearImportErrors();r.onloadend=this.onImportFileLoaded.bind(this);r.onerror=this.onImportFileError.bind(this);r.readAsText(e.getParameter("files")[0],"UTF-8");};b.prototype.onImportFileMismatch=function(e){this._clearImportErrors();this._reportImportFileError("Invalid file type \""+e.getParameter("mimeType")+"\". Please, import a valid \"application/json\" file.",e.getParameter("fileName"));};b.prototype.onImportFileError=function(e){this._reportImportFileError("Error while reading file: \""+e.target.error+"\".");};b.prototype.onImportFileLoaded=function(e){var f=this._tryParseImportFile(e.target.result);if(f){this._clearImportErrors();if(!f.id){f.id=U.generateUuidV4();}if(f.dateExported){f.dateExported=new Date(f.dateExported);}this.oModel.setProperty("/currentImportData",f);if(!this._isAlreadyImported(f.id)){F.byId(C.IMPORT_FRAGMENT_ID,"importBtn").setEnabled(true);}}};b.prototype.onImportCancelPress=function(){this._oImportDialog.close();};b.prototype.onImportFinalizePress=function(){var i=this.oModel.getProperty("/currentImportData"),m="";this._importPreset(i);m="The Rule Preset \""+i.title+"\" was successfully imported.";if(!P.isPersistingAllowed()){m+=" This import can be stored for your next visit if you check "+"\"I agree to use local storage persistency\" from Support Assistant settings.";}this._oImportDialog.close();M.show(m,{width:"50%"});};b.prototype.onImportDialogClose=function(){this._clearImportErrors();F.byId(C.IMPORT_FRAGMENT_ID,"fileUpload").setValue(null);this.oModel.setProperty("/currentImportData",null);F.byId(C.IMPORT_FRAGMENT_ID,"importBtn").setEnabled(false);};b.prototype.onExportPress=function(){var o=this.oModel.getProperty("/selectionPresetsCurrent");if(!o.selections.length){a.error("Cannot export Rule Preset without selections.");return;}this.oModel.setProperty("/currentExportData",{"id":(o.isMySelection||o.isSystemPreset)?"":o.id,"title":o.title,"descriptionValue":o.description,"dateExportedForDisplay":new Date(),"isMySelection":o.isMySelection});if(!this._oExportDialog){this._oExportDialog=sap.ui.xmlfragment(C.EXPORT_FRAGMENT_ID,"sap.ui.support.supportRules.ui.views.PresetExport",this);this._oExportDialog.attachAfterClose(function(){this._clearValidationState();}.bind(this));this.oView.addDependent(this._oExportDialog);this.initializeExportValidations();}this._oExportDialog.open();};b.prototype.initializeExportValidations=function(){var i=this._getInputsToValidate();i.forEach(function(I){F.byId(C.EXPORT_FRAGMENT_ID,I.id).attachChange(function(e){this._changeHandler(e,I.validateMessage);}.bind(this));},this);};b.prototype._changeHandler=function(e,v){this._validateInput(e.getSource(),v);};b.prototype._validateForm=function(){var r=true,i=this._getInputsToValidate();i.forEach(function(I){var o=F.byId(C.EXPORT_FRAGMENT_ID,I.id);if(!this._validateInput(o,I.validateMessage)){r=false;}},this);return r;};b.prototype._validateInput=function(i,v){var o=i.getBinding("value"),s=V.None,d=true;try{if(i.getRequired()&&!i.getValue().trim()){throw{name:"RequiredException",message:i.getLabels()[0].getText()+" is required."};}if(o&&o.getType()){o.getType().validateValue(i.getValue());}}catch(e){var m=e.message;if(e.name==="ValidateException"&&v){m=v;}i.setValueStateText(m);s=V.Error;d=false;}i.setValueState(s);return d;};b.prototype._getInputsToValidate=function(){return[{id:"title"},{id:"presetId",validateMessage:"Invalid value. Possible characters are: a-z A-Z 0-9 - . _"}];};b.prototype._clearValidationState=function(){var i=this._getInputsToValidate();i.forEach(function(I){F.byId(C.EXPORT_FRAGMENT_ID,I.id).setValueState(V.None);});};b.prototype.onExportCancelPress=function(){this._oExportDialog.close();};b.prototype.onExportFinalizePress=function(){var i=F.byId(C.EXPORT_FRAGMENT_ID,"presetId").getValue(),t=F.byId(C.EXPORT_FRAGMENT_ID,"title").getValue(),d=F.byId(C.EXPORT_FRAGMENT_ID,"description").getValue();if(!this._validateForm()){return;}if(!i){i=U.generateUuidV4();}P.exportSelectionsToFile(i,t,d,S.getSelectedRules());M.show("The Rule Preset \""+t+"\" was successfully exported.",{width:"50%"});this._oExportDialog.close();};b.prototype.openHelp=function(){D.openTopic("3fc864acf926406194744375aa464fe7");};b.prototype._reportImportFileError=function(m,e){var E=F.byId(C.IMPORT_FRAGMENT_ID,"fileError"),f=F.byId(C.IMPORT_FRAGMENT_ID,"fileUpload"),o=F.byId(C.IMPORT_FRAGMENT_ID,"fileName"),i=F.byId(C.IMPORT_FRAGMENT_ID,"importBtn");E.setText(m).setVisible(true);o.addStyleClass("sapUiSupportToolError");this.oModel.setProperty("/currentImportData",{fileName:e||f.getValue()});i.setEnabled(false);};b.prototype._isAlreadyImported=function(p){var d=this.oModel.getProperty("/selectionPresets"),e=d.some(function(o){return o.id===p;});if(e){F.byId(C.IMPORT_FRAGMENT_ID,"duplicateIdError").setText("A preset with ID '"+p+"' is already imported.").setVisible(true);F.byId(C.IMPORT_FRAGMENT_ID,"presetId").addStyleClass("sapUiSupportToolError");return true;}else{return false;}};b.prototype._clearImportErrors=function(){F.byId(C.IMPORT_FRAGMENT_ID,"fileError").setText("").setVisible(false);F.byId(C.IMPORT_FRAGMENT_ID,"fileName").removeStyleClass("sapUiSupportToolError");F.byId(C.IMPORT_FRAGMENT_ID,"duplicateIdError").setText("").setVisible(false);F.byId(C.IMPORT_FRAGMENT_ID,"presetId").removeStyleClass("sapUiSupportToolError");};b.prototype._tryParseImportFile=function(f){var o={};var i="The file cannot be uploaded. Please, choose an \"application/json\" file exported from the Support Assistant.";try{o=JSON.parse(f);}catch(e){this._reportImportFileError(i);return false;}var E=[];if(!P.isValidSelectionImport(o,E)){this._reportImportFileError(i);return false;}o.fileName=F.byId(C.IMPORT_FRAGMENT_ID,"fileUpload").getValue();return o;};b.prototype._importPreset=function(i){var s=this.oModel.getProperty("/selectionPresets"),d=this.oModel.getProperty("/customPresets");var p={"id":i.id,"title":i.title,"description":i.description,"dateExported":i.dateExported,"version":i.version,"selections":i.selections};s.forEach(function(o){o.selected=false;});p.selected=true;p.isCustomPreset=true;s.push(p);d.push(q.extend(true,{},p));if(P.isPersistingAllowed()){P.persistCustomPresets();}this._applyPreset(p);};b.prototype._applyPreset=function(p){this.oModel.setProperty("/selectionPresetsCurrent",p);S.setSelectedRules(p.selections);if(P.isPersistingAllowed()){P.persistSelectionPresets();}};b.prototype.grouper=function(o){if(o.getProperty("isSystemPreset")){return C.PRESET_GROUP_SYSTEM;}if(o.getProperty("isCustomPreset")){return C.PRESET_GROUP_CUSTOM;}return C.PRESET_GROUP_NONE;};b.prototype.getGroupHeader=function(g){var v=!(g.key===C.PRESET_GROUP_NONE);return new G({title:g.key,visible:v}).addStyleClass("sapUiSupportToolGHLI");};return b;});
