/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/util/PasteHelper','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./utils/TableUtils','./extensions/ExtensionBase','./extensions/Accessibility','./extensions/Keyboard','./extensions/Pointer','./extensions/Scrolling','./extensions/DragAndDrop',"./TableRenderer","./rowmodes/FixedRowMode","./rowmodes/InteractiveRowMode","./rowmodes/AutoRowMode","./plugins/SelectionModelSelection","sap/ui/thirdparty/jquery","sap/base/Log"],function(D,C,E,I,P,a,F,S,B,b,R,c,T,d,A,K,e,f,g,h,j,k,m,n,q,L){"use strict";var G=c.GroupEventType;var N=c.NavigationMode;var o=c.SelectionMode;var p=c.SelectionBehavior;var r=c.SortOrder;var V=c.VisibleRowCountMode;var H=T.Hook.Keys.Table;var _=T.createWeakMapFacade();var s=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:o.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:p.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar,deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false,deprecated:true},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin"},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}}},designtime:"sap/ui/table/designtime/Table.designtime"}});I.insertFontFaceStyle();s.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};_(this).iCachedBindingLength=0;_(this).iFirstRenderedRowIndex=0;_(this).iComputedFixedColumnCount=null;this._attachExtensions();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._aRowHeights=[];this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){T.readThemeParameters();}this._bInvalid=true;};s.prototype.applySettings=function(l,M){if(l){var O=["rowMode","plugins"];var Q={};for(var i=0;i<O.length;i++){var U=O[i];if(U in l){Q[U]=l[U];delete l[U];}}if(Object.keys(Q).length>0){C.prototype.applySettings.call(this,Q,M);}}this._initLegacyRowMode();this._initLegacySelectionPlugin();C.prototype.applySettings.call(this,l,M);};s.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}d.enrich(this,e);d.enrich(this,f);d.enrich(this,K);d.enrich(this,A);d.enrich(this,g);this._bExtensionsInitialized=true;};s.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();T.Menu.cleanupDefaultContentCellContextMenu(this);delete this._aTableHeaders;};s.prototype._detachExtensions=function(){d.cleanup(this);};s.prototype.onpaste=function(i){if(i.isMarked()||/^(input|textarea)$/i.test(i.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(i.target)){return;}var l=P.getPastedDataAs2DArray(i.originalEvent);if(l.length===0||l[0].length===0){return;}this.firePaste({data:l});};s.prototype.onThemeChanged=function(){T.readThemeParameters();if(this.getDomRef()){this.invalidate();}};s.prototype.onlocalizationChanged=function(i){var l=i.changes||{};var M=l.hasOwnProperty("rtl");var O=l.hasOwnProperty("language");this._adaptLocalization(M,O).then(function(){this.invalidate();}.bind(this));};s.prototype._adaptLocalization=function(i,l){if(!i&&!l){return Promise.reject();}var M=Promise.resolve();if(i){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){M=T.getResourceBundle({async:true,reload:true});}return M.then(function(){if(l){T.Menu.cleanupDefaultContentCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};s.prototype._collectRowHeights=function(l){var M=this.getDomRef();if(!M){return[];}var O=this._getBaseRowHeight();var Q=l?".sapUiTableColHdrTr":".sapUiTableTr";var U=M.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Q);var W=M.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Q);var X=l?T.getHeaderRowCount(this):this.getRows().length;var Y=[];var Z=D.browser.chrome&&window.devicePixelRatio!=1;if(l){if(this.getColumnHeaderHeight()>0){O=this.getColumnHeaderHeight();}else if(this.getRowMode()){O=this._getDefaultRowHeight();}}for(var i=0;i<X;i++){var $=U[i]?U[i].getBoundingClientRect().height:0;var a1=W[i]?W[i].getBoundingClientRect().height:0;var b1=Math.max($,a1);if(Z){var c1=O-b1;if(c1>0&&c1<1){Y.push(Math.max(b1,O-1));continue;}}Y.push(Math.max(b1,O));}if(Y.length>0&&!l){T.dynamicCall(this._getSyncExtension,function(d1){var e1=d1.syncRowHeights(Y.slice());if(e1&&e1.length===Y.length){Y=e1.slice();}});}return Y;};s.prototype._resetRowHeights=function(){var l=this._getBaseRowHeight();var M="";if(l){M=l+"px";}var O=this.getDomRef("tableCCnt");if(O){var Q=O.querySelectorAll(".sapUiTableTr");for(var i=0;i<Q.length;i++){Q[i].style.height=M;}}};s.prototype._resetColumnHeaderHeights=function(){var l=this.getDomRef();if(l){var M=l.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<M.length;i++){M[i].style.height=null;}}};s.prototype._collectTableSizes=function(){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var M=this.getDomRef();if(!M){return l;}var O=M.querySelector(".sapUiTableCnt");if(O){l.tableCntHeight=O.clientHeight;l.tableCntWidth=O.clientWidth;}var Q=M.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(Q){l.tableCtrlScrollWidth=Q.clientWidth;}var U=M.querySelector(".sapUiTableRowHdrScr");if(U){l.tableRowHdrScrWidth=U.clientWidth;}var W=M.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(W){l.tableCtrlScrWidth=W.clientWidth;}var X=M.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(X){l.tableCtrlFixedWidth=X.clientWidth;}var Y=this._getSpanBasedComputedFixedColumnCount();var Z=0;if(Y){var $=this.getColumns();var a1=M.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<a1.length;i++){var b1=parseInt(a1[i].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(b1)&&(b1<Y)){var c1=$[b1];var d1;if(c1._iFixWidth!=null){d1=c1._iFixWidth;}else{d1=a1[i].getBoundingClientRect().width;}Z+=d1;}}}if(Z>0){var e1=this._getScrollExtension();var f1=l.tableRowHdrScrWidth;var g1=e1.getVerticalScrollbar();if(g1&&!e1.isVerticalScrollbarExternal()){f1+=g1.offsetWidth;}if(T.hasRowActions(this)){var h1=this.getDomRef("sapUiTableRowActionScr");if(h1){f1+=h1.offsetWidth;}}f1+=T.Column.getMinColumnWidth();var i1=l.tableCntWidth-f1;var j1=i1>Z;var k1=!j1;if(this._bIgnoreFixedColumnCount!==k1){this._bIgnoreFixedColumnCount=k1;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return l;};s.prototype._updateRowHeights=function(i,l){var M=this.getDomRef();if(!M){return;}function O(Z,$){var a1=i[$];if(a1){Z.style.height=a1+"px";}}var Q=l?".sapUiTableColHdrTr":".sapUiTableTr";var U=l?[]:M.querySelectorAll(".sapUiTableRowSelectionCell");var W=l?[]:M.querySelectorAll(".sapUiTableRowActionCell");var X=M.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Q);var Y=M.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Q);Array.prototype.forEach.call(U,O);Array.prototype.forEach.call(W,O);Array.prototype.forEach.call(X,O);Array.prototype.forEach.call(Y,O);};s.prototype.onBeforeRendering=function(i){this._bInvalid=true;this._detachEvents();if(i&&i.isMarked("renderRows")){return;}this._cleanUpTimers();this.getBinding("rows");this._aTableHeaders=[];};s.prototype.onAfterRendering=function(i){var l=i&&i.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!l){this._disableTextSelection(this.$().find(".sapUiTableCHA"));}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!l){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");}this._updateTableSizes(T.RowsUpdateReason.Render,true);T.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false;};s.prototype.invalidate=function(){this._bInvalid=true;T.Column.invalidateColumnUtils(this);return C.prototype.invalidate.call(this);};s.prototype._initRowDomRefs=function(){var l=this.getRows();for(var i=0;i<l.length;i++){l[i].initDomRefs();}};s.prototype._updateTableSizes=function(l,M){M=M===true;var O=this.getDomRef();if(this._bInvalid||!O||!sap.ui.getCore().isThemeApplied()||O.offsetWidth===0){return;}if(!M){this._resetRowHeights();this._resetColumnHeaderHeights();}this._aRowHeights=this._collectRowHeights(false);var Q=this._collectRowHeights(true);function U(g1){var h1=g1.getDomRef();var i1=T.Column.getMinColumnWidth();var j1=[];var k1=g1.getColumnHeaderVisible();function l1(o1,p1){if(o1<=p1){return Math.max(o1,p1-5,i1)+"px";}return-1;}function m1(p1){var q1=Math.max(p1._minWidth||0,i1,p1.getMinWidth());var r1=p1.getWidth();var s1;var t1;var u1;if(T.isVariableWidth(r1)&&!T.isFixedColumn(g1,p1.getIndex())){s1=h1.querySelectorAll('th[data-sap-ui-colid="'+p1.getId()+'"]');t1=s1[k1?0:1];u1=t1?t1.offsetWidth:null;if(u1!==null){if(u1<=q1){return{headers:s1,newWidth:l1(u1,q1)};}else if(t1&&t1.style.width!=r1){j1.push({col:p1,header:t1,minWidth:q1,headers:s1});return{headers:s1,newWidth:r1};}j1.push({col:p1,header:t1,minWidth:q1,headers:s1});}}return null;}function n1(p1){if(p1){Array.prototype.forEach.call(p1.headers,function(q1){q1.style.width=p1.newWidth;});}}g1._getVisibleColumns().map(m1).forEach(n1);if(j1.length){var o1;for(var i=0;i<j1.length;i++){o1=j1[i].header&&j1[i].header.offsetWidth;j1[i].newWidth=l1(o1,j1[i].minWidth);if(parseInt(j1[i].newWidth)>=0){n1(j1[i]);}}}}U(this);var W=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(Q,true);T.dynamicCall(this._getSyncExtension,function(i){i.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height});},this);var X=this._getScrollExtension();X.updateHorizontalScrollbar(W);X.updateVerticalScrollbarPosition();X.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)||T.hasRowNavigationIndicators(this)){var Y=$.hasClass("sapUiTableRActFlexible");var Z=this.getDomRef("dummycolhdr");if(Z){var a1=this.getDomRef("header");var b1=a1.clientWidth;var c1=this.getColumns().reduce(function(c1,i){if(i.getDomRef()&&i.getIndex()>=this.getComputedFixedColumnCount()){return c1+T.convertCSSSizeToPixel(i.getWidth());}return c1;}.bind(this),0);var d1=b1>c1;if(!Y&&d1){var e1=c1+W.tableRowHdrScrWidth+W.tableCtrlFixedWidth;var f1={};if(!T.hasRowActions(this)){e1=e1-T.ThemeParameters.navIndicatorWidth+T.BaseBorderWidth;}f1[this._bRtlMode?"right":"left"]=e1;this.$("sapUiTableRowActionScr").css(f1);this.$("rowacthdr").css(f1);$.toggleClass("sapUiTableRActFlexible",true);}else if(Y&&!d1){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");T.Hook.call(this,H.UpdateSizes,l);};s.prototype.setShowOverlay=function(i){i=!!i;this.setProperty("showOverlay",i,true);if(this.getDomRef()){var l=document.activeElement;this.$().toggleClass("sapUiTableOverlay",i);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(l);}return this;};s.prototype._updateFixedBottomRows=function(){var i=this.getDomRef();if(!i||this._getRowCounts().fixedBottom===0){return;}var l=T.getFirstFixedBottomRowIndex(this);var M=this.getRows();var $;q(i).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");q(i).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(l>=0&&l<M.length){$=M[l].getDomRefs(true);$.row.addClass("sapUiTableRowFirstFixedBottom",true);}if(l>=1&&l<M.length){$=M[l-1].getDomRefs(true);$.row.addClass("sapUiTableRowLastScrollable",true);}};s.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};s.prototype.applyFocusInfo=function(i){if(i&&i.customId){q(document.getElementById(i.customId)).trigger("focus");}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};s.prototype.setTitle=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});l.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",l);return this;};s.prototype.setFooter=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});}this.setAggregation("footer",l);return this;};s.prototype.setSelectionMode=function(i){if(i===o.Multi){i=o.MultiToggle;L.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this);}if(this._hasSelectionPlugin()){L.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this);}else{this.setProperty("selectionMode",i);this._oLegacySelectionPlugin.setSelectionMode(i);}return this;};s.prototype.setFirstVisibleRow=function(i){this._setFirstVisibleRowIndex(i);return this;};s.prototype._setFirstVisibleRowIndex=function(i,O){O=Object.assign({onScroll:false,suppressScrolling:false,suppressEvent:false,forceEvent:false,suppressRendering:false,onlySetProperty:false},O);if(i==null){i=0;}else if(i<0){L.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);i=0;}else if(this._bContextsAvailable){var M=this._getMaxFirstVisibleRowIndex();if(M<i){if(!O.onScroll){L.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);}i=M;}}var l=this.getFirstVisibleRow()!=i;var Q=this._getFirstRenderedRowIndex();var U=this.getBinding("rows")?Math.min(i,this._getMaxFirstRenderedRowIndex()):i;var W=this._getScrollExtension();this.setProperty("firstVisibleRow",i,true);if(!O.suppressRendering){_(this).iFirstRenderedRowIndex=U;}if(O.onlySetProperty){return false;}if((l||O.forceEvent)&&!O.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}if(!this.getBinding("rows")){W.updateVerticalScrollPosition();return false;}var X=false;var Y=this.getBinding("rows")!=null&&U!==Q;if(Y){if(!O.suppressRendering){y(this,O.onScroll?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange);X=true;}if(!O.onScroll&&!O.suppressScrolling){W.updateVerticalScrollPosition(X);}}else if(!O.onScroll&&!O.suppressScrolling){W.updateVerticalScrollPosition(!this._bContextsAvailable);}return X;};s.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;s.prototype.bindAggregation=function(i,l){if(i==="rows"){this._bindRows(u(Array.prototype.slice.call(arguments,1)));return this;}return C.prototype.bindAggregation.apply(this,arguments);};s.prototype.bindRows=function(i){this._bindRows(u(arguments));return this;};s.prototype._bindRows=function(i){t(this);this._bRowsBeingBound=true;x(this);s._addBindingListener(i,"change",function(){this._onBindingChange.apply(this,arguments);}.bind(this));s._addBindingListener(i,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments);}.bind(this));s._addBindingListener(i,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments);}.bind(this));if(this.getEnableBusyIndicator()){this.setBusy(false);}T.Hook.call(this,H.BindRows,i);C.prototype.bindAggregation.call(this,"rows",i);this._bRowsBeingBound=false;};s.prototype._bindAggregation=function(i,l){if(i==="rows"){t(this);this._bRowsBeingBound=true;}C.prototype._bindAggregation.call(this,i,l);if(i==="rows"){var M=this.getBinding("rows");var O=M?M.getModel():null;this._bRowsBeingBound=false;T.Hook.call(this,H.RowsBound,M);if(O&&O.getDefaultBindingMode()===B.OneTime){L.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}};s.prototype.unbindAggregation=function(i,l){if(i==="rows"){this._unbindRows();return this;}return C.prototype.unbindAggregation.apply(this,arguments);};s.prototype.unbindRows=function(){this._unbindRows();return this;};s.prototype._unbindRows=function(){var i=this.getBindingInfo("rows");if(i){T.Hook.call(this,H.UnbindRows,i);}C.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return;}this._adjustToTotalRowCount();if(i){T.Hook.call(this,H.RowsUnbound);}t(this);};function t(i){i._bRowsBeingBound=false;i._bContextsAvailable=false;i._iPendingRequests=0;i._bPendingRequest=false;i._iBindingLength=null;}function u(i){var l;if(i==null||i[0]==null){l={};}else if(typeof i[0]==="string"){var M=i[0];var O=i[1];var Q=i[2];var U=i[3];if(O instanceof S||Array.isArray(Q)&&Q[0]instanceof F){U=Q;Q=O;O=undefined;}l={path:M,sorter:Q,filters:U,template:O};}else{l=i[0];}return l;}s._addBindingListener=function(i,l,M,O){if(!i.events){i.events={};}var Q=i.events[l];i.events[l]=function(){M.apply(O,arguments);if(Q){Q.apply(this,arguments);}};};s.prototype._onBindingChange=function(i){var l=i.getParameter("reason");if(l===a.Sort||l===a.Filter){this.setFirstVisibleRow(0);}};s.prototype.setRowMode=function(i){this._destroyLegacyRowMode();this.setAggregation("rowMode",i);this._initLegacyRowMode();};s.prototype.getRowMode=function(){return this.getAggregation("rowMode");};s.prototype._getRowMode=function(){var i=this.getRowMode()||this._oLegacyRowMode;if(!i){this._initLegacyRowMode();i=this._oLegacyRowMode;}return i;};s.prototype._initLegacyRowMode=function(){if(this._oLegacyRowMode||this.getRowMode()){return;}this._oLegacyRowMode=v(this);this.addAggregation("_hiddenDependents",this._oLegacyRowMode);};s.prototype._destroyLegacyRowMode=function(){if(this._oLegacyRowMode){this._oLegacyRowMode.destroy();delete this._oLegacyRowMode;}};function v(i){var l;switch(i.getVisibleRowCountMode()){case V.Fixed:l=new j(true);break;case V.Interactive:l=new k(true);break;case V.Auto:l=new m(true);break;default:}return l;}s.prototype._getRowCounts=function(){var i=this._getRowMode().getComputedRowCounts();var l=this._bVariableRowHeightEnabled&&!i.fixedTop&&!i.fixedBottom;i._fullsize=i.count;i._scrollSize=i.scrollable;if(i.count>0&&l){i.count++;i.scrollable++;}return i;};s.prototype.setVisibleRowCountMode=function(i){if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCountMode\" has no effect");return this.setProperty("visibleRowCountMode",i,true);}var O=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",i);var l=this.getVisibleRowCountMode();if(l!==O){this._destroyLegacyRowMode();this._initLegacyRowMode();}return this;};s.prototype.setVisibleRowCount=function(i){var l=this.getVisibleRowCountMode();if(l==V.Auto){L.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}if(i!=null&&!isFinite(i)){return this;}var M=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=M&&M>0){L.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCount\" has no effect");return this.setProperty("visibleRowCount",i,true);}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this._getTotalRowCount()<=i){this.setFirstVisibleRow(0);}this.setProperty("visibleRowCount",i);T.dynamicCall(this._getSyncExtension,function(O){O.syncRowCount(i);});return this;};s.prototype.setMinAutoRowCount=function(M){if(parseInt(M)<1){L.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);M=1;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"minAutoRowCount\" has no effect");return this.setProperty("minAutoRowCount",M,true);}return this.setProperty("minAutoRowCount",M);};s.prototype.setTooltip=function(i){L.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",i,true);};s.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);L.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this;};s.prototype._getFixedBottomRowContexts=function(){var i=this._getRowCounts();var l=this._getTotalRowCount();if(i.fixedBottom>0&&i.count-i.fixedBottom<l){return this._getContexts(l-i.fixedBottom,i.fixedBottom);}else{return[];}};s.prototype._getFixedRowContexts=function(){var i=this._getRowCounts();if(i.fixedTop>0){return this._getContexts(0,i.fixedTop);}else{return[];}};s.prototype._getContexts=function(i,l,M){var O=this.getBinding("rows");if(O){return O.getContexts(i,l,M);}else{return[];}};s.prototype._getRowContexts=function(l,M,O){var Q=this.getBinding("rows");var U=this.getRows().length;l=l==null?U:l;l=Math.max(l,this._getRowMode().getMinRequestLength());if(!Q||l<=0){return[];}M=M===true;O=O===true;var W=this._getFirstRenderedRowIndex();var X=this._getRowCounts();var Y=[];var Z;var $=l-X.fixedBottom;var a1=0;var b1=$;var c1=this.getThreshold();c1=c1?Math.max(U,c1):0;var d1=W;var e1=function(h1,i1,d1){for(var i=0;i<i1.length;i++){h1[d1+i]=i1[i];}};if(X.fixedTop>0&&W>0){d1=W+X.fixedTop;$-=X.fixedTop;a1=X.fixedTop;Z=this._getFixedRowContexts();Y=Y.concat(Z);}Z=this._getContexts(d1,$,c1);if(!M){this._adjustToTotalRowCount();}var f1=this._getTotalRowCount();e1(Y,Z,a1);b1=Math.min(b1,Math.max(f1-X.fixedBottom,0));if(X.fixedBottom>0){Z=this._getFixedBottomRowContexts();e1(Y,Z,b1);}var g1=this._getMaxFirstRenderedRowIndex();if(g1<W&&this._bContextsAvailable&&!O){this._setFirstVisibleRowIndex(this.getFirstVisibleRow(),{onlySetProperty:true});Y=this._getRowContexts(l,M,true);}return Y;};s.prototype._adjustToTotalRowCount=function(){var i=this.getBinding("rows");var l=this._getTotalRowCount();var M=this._getScrollExtension();if(this._iBindingLength!==l){this._iBindingLength=l;this._updateFixedBottomRows();this._getAccExtension()._updateAriaRowCount();M.adjustToTotalRowCount();if(!i||!T.hasPendingRequests(this)){this._updateNoData();}}};s.prototype.refreshRows=function(i){this._bContextsAvailable=false;if(i===a.Sort||i===a.Filter){this.setFirstVisibleRow(0);}T.Hook.call(this,H.RefreshRows,i||T.RowsUpdateReason.Unknown);};s.prototype.updateRows=function(i,l){if(this.bIsDestroyed||this._bIsBeingDestroyed){return;}if(l.detailedReason==="AddVirtualContext"){w(this);return;}else if(l.detailedReason==="RemoveVirtualContext"){x(this);return;}this._bContextsAvailable=true;y(this,i);};function w(i){var l=i._getRowContexts(null,true)[0];x(i);i._oVirtualRow=i._getRowClone("virtual");i._oVirtualRow.setBindingContext(l,i.getBindingInfo("rows").model);i.addAggregation("_hiddenDependents",i._oVirtualRow);}function x(i){if(i._oVirtualRow){i._oVirtualRow.destroy();delete i._oVirtualRow;}}function y(i,l){if(i._bContextsAvailable){T.Hook.call(i,H.UpdateRows,l||T.RowsUpdateReason.Unknown);}}s.prototype.insertRow=function(){L.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);return this;};s.prototype.addRow=function(){L.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);return this;};s.prototype.removeRow=function(){L.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);return null;};s.prototype.removeAllRows=function(){L.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);return[];};s.prototype.destroyRows=function(){L.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);return this;};s.prototype.setCreationRow=function(i){if(!T.isA(i,"sap.ui.table.CreationRow")){i=null;}return this.setAggregation("creationRow",i);};s.prototype.getCreationRow=function(){return this.getAggregation("creationRow");};s.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};s.prototype._attachEvents=function(){var $=this.$();var i=this.getId();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd."+i+" transitionend."+i,function(l){if(q(l.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);d.attachEvents(this);};s.prototype._detachEvents=function(){var i=this.getId();q(document.body).off('webkitTransitionEnd.'+i+' transitionend.'+i);T.deregisterResizeHandler(this,"Table");D.resize.detachHandler(this._onWindowResize,this);d.detachEvents(this);};s.prototype._cleanUpTimers=function(){var i;for(i in this._mTimeouts){if(this._mTimeouts[i]){window.clearTimeout(this._mTimeouts[i]);delete this._mTimeouts[i];}}for(i in this._mAnimationFrames){if(this._mAnimationFrames[i]){window.cancelAnimationFrame(this._mAnimationFrames[i]);delete this._mAnimationFrames[i];}}};s.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};s.prototype.removeColumn=function(i,l){i=this.removeAggregation('columns',i,l);if(i===null){return i;}if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var M=this._aSortedColumns.indexOf(i);if(!this._bReorderInProcess&&M>=0){this._aSortedColumns.splice(M,1);}this.invalidateRowsAggregation();this._invalidateComputedFixedColumnCount();var O=this.getCreationRow();if(O){O._update();}return i;};s.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();this._invalidateComputedFixedColumnCount();var l=this.getCreationRow();if(l){l._update();}return i;};s.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();this._invalidateComputedFixedColumnCount();var l=this.getCreationRow();if(l){l._update();}return i;};s.prototype.addColumn=function(i,l){this.addAggregation('columns',i,l);this.invalidateRowsAggregation();this._invalidateComputedFixedColumnCount();var M=this.getCreationRow();if(M){M._update();}return this;};s.prototype.insertColumn=function(i,l,M){this.insertAggregation('columns',i,l,M);this.invalidateRowsAggregation();this._invalidateComputedFixedColumnCount();var O=this.getCreationRow();if(O){O._update();}return this;};s.prototype._getTotalRowCount=function(){var i=this.getBinding("rows");var l=this.getBindingInfo("rows");if(!i){return 0;}if(l.length!=null){return l.length;}if(!this._bContextsAvailable){return _(this).iCachedBindingLength;}_(this).iCachedBindingLength=i.getLength();return _(this).iCachedBindingLength;};s.prototype._getMaxFirstVisibleRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount()-1;}else{M=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,M);};s.prototype._getMaxFirstRenderedRowIndex=function(){var M=this._getTotalRowCount()-this._getRowCounts().count;return Math.max(0,M);};s.prototype._getFirstRenderedRowIndex=function(){return _(this).iFirstRenderedRowIndex;};s.prototype._getVisibleColumns=function(){var M=[];var O=this.getColumns();for(var i=0,l=O.length;i<l;i++){if(O[i].shouldRender()){M.push(O[i]);}}return M;};s.prototype._getColumnsWidth=function(M,O){var Q=this.getColumns();var U=0;if(M!==0&&!M){M=0;}if(O!==0&&!O){O=Q.length;}for(var i=M,l=O;i<l;i++){if(Q[i]&&Q[i].shouldRender()){var W=T.convertCSSSizeToPixel(Q[i].getWidth());if(W==null){W=T.Column.getMinColumnWidth();}U+=W;}}return U;};s.prototype._onTableResize=function(i){var O=i.oldSize.width;var l=i.size.width;if(this._bInvalid||!this.getDomRef()||O===l){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};s.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);this._adjustOutlineOffset();}};s.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout");}else{this.removeStyleClass("sapUiTableZoomout");}};s.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(l){l.preventDefault();return false;});};s.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart");};s.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};s.prototype._findAndfireCellEvent=function(i,l,M){var $=q(l.target);var O=$.closest(".sapUiTableDataCell");var Q=O.attr("id");var U=/.*-row(\d*)-col(\d*)/i.exec(Q);var W=false;if(U){var X=U[1];var Y=U[2];var Z=this.getRows()[X];var a1=Z&&Z.getCells()[Y];var b1=Z&&Z.getIndex();var c1=b.ofCell(a1).getId();var d1=Z.getRowBindingContext();var e1={rowIndex:b1,columnIndex:Y,columnId:c1,cellControl:a1,rowBindingContext:d1,cellDomRef:O.get(0)};W=!i.call(this,e1);if(!W&&typeof M==="function"){e1.cellDomRef=O[0];W=M.call(this,e1);}}return W;};s.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();if(this.getShowOverlay()){return this.getDomRef("overlay");}if(T.isNoDataVisible(this)){return this.getDomRef("noDataCnt");}var i=T.getFocusedItemInfo(this);if(i&&i.domRef){return i.domRef;}return C.prototype.getFocusDomRef.apply(this,arguments);};s.prototype.pushSortedColumn=function(i,l){if(!l){this._aSortedColumns=[];}if(this._aSortedColumns.indexOf(i)===-1){this._aSortedColumns.push(i);}};s.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};s.prototype.sort=function(l,M,O){if(!l){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var Q=this.getBinding("rows");if(Q){Q.sort();}this._aSortedColumns=[];}if(this.getColumns().indexOf(l)>=0){l.sort(M===r.Descending,O);}};s.prototype.filter=function(i,l){if(this.getColumns().indexOf(i)>=0){if(l==null){l="";}else if(typeof l!=="string"){throw new Error("The filter value is not a string");}i.filter(l);}};s.prototype._updateSelection=function(){var l=this.getSelectionMode();if(l===o.None){return;}var M=this._getSelectionPlugin().getRenderConfig();var O;var Q;var $=this.$("selall");var U=this.getRows();for(var i=0;i<U.length;i++){var W=U[i];W._updateSelection();}if(!M.headerSelector.visible){return;}if(M.headerSelector.type==="toggle"){var X=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!X);this._getAccExtension().setSelectAllState(X);O=X?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(M.headerSelector.type==="clear"){$.toggleClass("sapUiTableSelAllDisabled",!M.headerSelector.enabled);O="TBL_DESELECT_ALL";if(M.headerSelector.enabled){$.removeAttr("aria-disabled");}else{$.attr("aria-disabled","true");}}if(O){Q=T.getResourceText(O);if(this._getShowStandardTooltips()){$.attr('title',Q);}else if(M.headerSelector.type==="toggle"){this.getDomRef("ariaselectall").innerText=Q;}}};s.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};s.prototype._onSelectionChanged=function(i){var l=this._getSelectionPlugin();var M=i.getParameter("rowIndices");var O=i.getParameter("selectAll");var Q=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:l.getSelectedIndex();this._updateSelection();if(!this._hasSelectionPlugin()){this.setProperty("selectedIndex",l.getSelectedIndex(),true);this.fireRowSelectionChange({rowIndex:Q,rowContext:this.getContextByIndex(Q),rowIndices:M,selectAll:O,userInteraction:this._iSourceRowIndex!==undefined});}};s.prototype.getContextByIndex=function(i){var l=this.getBinding("rows");return i>=0&&l?l.getContexts(i,1)[0]:null;};s.prototype.getSelectedIndex=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndex();};s.prototype.setSelectedIndex=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectedIndex(i);return this;};s.prototype.clearSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.");}this._getSelectionPlugin().clearSelection();return this;};s.prototype.selectAll=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.");}if(T.hasSelectAll(this)){this._getSelectionPlugin().selectAll();}return this;};s.prototype.getSelectedIndices=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndices();};s.prototype.addSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().addSelectionInterval(i,l);return this;};s.prototype.setSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectionInterval(i,l);return this;};s.prototype.removeSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().removeSelectionInterval(i,l);return this;};s.prototype.isIndexSelected=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().isIndexSelected(i);};s.prototype.setGroupBy=function(i){var l=i;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof l==="string"){l=sap.ui.getCore().byId(l);}var M=false;if(l instanceof b&&l!==O){if(this.getColumns().indexOf(l)===-1){throw new Error("Column has to be part of the columns aggregation!");}var Q=this.fireGroup({column:l,groupedColumns:[l.getId()],type:G.group});if(O){O.setGrouped(false);M=true;}if(Q&&this.getEnableGrouping()){l.setGrouped(true);}}if(!l||M){if(O){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",l);};s.prototype.getBinding=function(i){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[i||"rows"]);};s.prototype.setEnableGrouping=function(i){var l=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",i);if(l){l.setGrouped(i);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};s.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};s.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};s.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};s.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this._getSpanBasedComputedFixedColumnCount();};s.prototype._getSpanBasedComputedFixedColumnCount=function(){if(_(this).iComputedFixedColumnCount===null){var l=this.getColumns();var M;var O=this.getFixedColumnCount();for(var i=O-1;i>=0;i--){M=l[i];if(M){O=Math.max(O,M.getIndex()+T.Column.getHeaderSpan(M));break;}}_(this).iComputedFixedColumnCount=Math.min(O,l.length);}return _(this).iComputedFixedColumnCount;};s.prototype.setFixedColumnCount=function(l,M){this.setProperty("fixedColumnCount",l,M);this._invalidateComputedFixedColumnCount();var O=this.getColumns();var Q;var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=this._getSpanBasedComputedFixedColumnCount()-1;i>=0;i--){Q=O[i];if(Q&&T.isVariableWidth(Q.getWidth())){Q._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+Q.getIndex()+"']").width();}}this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};s.prototype.setFixedRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"fixedRowCount\" has no effect");return this.setProperty("fixedRowCount",i,true);}return this.setProperty("fixedRowCount",i);};s.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"iFixedBottomRowCount\" has no effect");return this.setProperty("fixedBottomRowCount",i,true);}return this.setProperty("fixedBottomRowCount",i);};s.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);return this;};s.prototype._invalidateColumnMenus=function(){var M=this.getColumns();for(var i=0,l=M.length;i<l;i++){M[i].invalidateMenu();}};s.prototype._isTouchEvent=function(i){return!!(i&&i.originalEvent&&i.originalEvent.touches);};s.prototype._getRowClone=function(M){var O=typeof M==="number";var Q=O;var U=Q?this._aRowClones[M]:null;if(U&&!U.bIsDestroyed){return U;}U=new R(this.getId()+"-rows"+"-row"+(O?M:"-"+M));if(Q){this._aRowClones[M]=U;}var W=this.getColumns();for(var i=0,l=W.length;i<l;i++){if(W[i].getVisible()){var X=W[i].getTemplateClone(i);if(X){U.addCell(X);}}}if(T.hasRowActions(this)){var Y=this.getRowActionTemplate().clone();U.setAggregation("_rowAction",Y,true);}var Z=this.getRowSettingsTemplate();if(Z){var $=Z.clone();U.setAggregation("_settings",$,true);}return U;};s.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};s.prototype._invalidateComputedFixedColumnCount=function(){_(this).iComputedFixedColumnCount=null;};s.prototype._getBaseRowHeight=function(){var i=this._getRowMode().getBaseRowContentHeight();if(i>0){return i+T.RowHorizontalFrameSize;}else{return this._getDefaultRowHeight();}};s.prototype._getDefaultRowHeight=function(){var i=T.getContentDensity(this);return T.DefaultRowHeight[i];};s.prototype._getDefaultRowContentHeight=function(){var i=T.getContentDensity(this);return T.BaseSize[i];};s.prototype.setShowNoData=function(i){var l=true;if(this.getShowNoData()&&i===false&&this.getRows().length===0){l=false;}this.setProperty("showNoData",i,l);this._updateNoData();return this;};s.prototype.setNoData=function(i){var O=T.getNoDataText(this);this.setAggregation("noData",i,true);var l=T.getNoDataText(this);if(O!=null&&l!=null){if(O!==l){this.$("noDataMsg").text(l);}}else{this.invalidate();}return this;};s.prototype.exportData=function(M){var O=sap.ui.requireSync("sap/ui/core/util/Export");M=M||{};if(!M.rows){var Q=this.getBinding("rows"),U=this.getBindingInfo("rows");var W=Q.aFilters.concat(Q.aApplicationFilters);M.rows={path:U.path,model:U.model,sorter:Q.aSorters,filters:W,parameters:U.parameters};}if(!M.exportType){var X=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");M.exportType=new X();}var Y=M.rows.model;if(!Y){var Z=M.rows.path;var $=Z.indexOf(">");if($>0){Y=Z.substr(0,$);}}if(!M.columns){M.columns=[];var a1=this.getColumns();for(var i=0,l=a1.length;i<l;i++){var b1=a1[i];if(b1.getSortProperty()){M.columns.push({name:b1.getLabel().getText(),template:{content:{path:b1.getSortProperty(),model:Y}}});}}}var c1=new O(M);this.addDependent(c1);return c1;};s.prototype._onPersoApplied=function(){var M=this.getColumns();var O=[];for(var i=0,l=M.length;i<l;i++){var Q=M[i];if(Q.getSorted()){O.push(new S(Q.getSortProperty(),Q.getSortOrder()===r.Descending));}}var U=this.getBinding("rows");if(U){if(O.length>0){U.sort(O);}}};s.prototype._toggleSelectAll=function(){if(!T.hasData(this)||this.getSelectionMode()!==o.MultiToggle){return;}var i=this._getSelectionPlugin();if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;i.clearSelection();}else{this._iSourceRowIndex=0;i.selectAll();}this._iSourceRowIndex=undefined;};s.prototype.setBusy=function(i,l){var M=this.getBusy()!=i;l="sapUiTableGridCnt";var O=C.prototype.setBusy.call(this,i,l);if(M){this.fireBusyStateChanged({busy:i});}return O;};s.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);if(!i){this.setBusy(false);}return this;};s.prototype._onBindingDataRequested=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var l=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(l&&this._iPendingRequests===1||!l)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};s.prototype._onBindingDataReceived=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._adjustToTotalRowCount();if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=setTimeout(function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;}.bind(this),0);}};s.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};s.prototype.setRowActionTemplate=function(i){this.setAggregation("rowActionTemplate",i);this.invalidateRowsAggregation();return this;};s.prototype.setRowActionCount=function(i){if(typeof i==="number"){i=Math.max(0,Math.min(i,2));}return this.setProperty("rowActionCount",i);};s.prototype.setRowSettingsTemplate=function(i){this.setAggregation("rowSettingsTemplate",i);this.invalidateRowsAggregation();return this;};s.prototype.addPlugin=function(i){this.addAggregation("plugins",i);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};s.prototype.insertPlugin=function(i,l){this.insertAggregation("plugins",i,l);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};s.prototype.removePlugin=function(i){var l=this.removeAggregation("plugins",i);if(T.isA(l,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return l;};s.prototype.removeAllPlugins=function(){var i=this.removeAllAggregation("plugins");this._initSelectionPlugin();return i;};s.prototype.destroyPlugins=function(){this.destroyAggregation('plugins');this._initSelectionPlugin();return this;};s.prototype.getPlugin=function(l){if(typeof l!=="string"){return null;}var M=this.getPlugins();for(var i=0;i<M.length;i++){if(M[i].isA(l)){return M[i];}}return null;};s.prototype._getSelectionPlugin=function(){var i=this._oSelectionPlugin||this._oLegacySelectionPlugin;if(!i){this._initLegacySelectionPlugin();i=this._oLegacySelectionPlugin;}if(typeof this._getSelectedIndicesCount==="function"&&i.getSelectedCount!==this._getSelectedIndicesCount){i.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(function(M){i[M]=this[M];}.bind(this));}return i;};s.prototype._hasSelectionPlugin=function(){return this._oSelectionPlugin!=null;};s.prototype._initSelectionPlugin=function(){var i=this.getPlugin("sap.ui.table.plugins.SelectionPlugin");if(i){this._destroyLegacySelectionPlugin();if(i!==this._oSelectionPlugin){J(this,this._oSelectionPlugin);z(this,i);this._oSelectionPlugin=i;}}else{this._initLegacySelectionPlugin();J(this,this._oSelectionPlugin);delete this._oSelectionPlugin;}};s.prototype._initLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin||this.getPlugin("sap.ui.table.plugins.SelectionPlugin")){return;}this._oLegacySelectionPlugin=this._createLegacySelectionPlugin();this.addAggregation("_hiddenDependents",this._oLegacySelectionPlugin);z(this,this._oLegacySelectionPlugin);};s.prototype._destroyLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin){this._oLegacySelectionPlugin.destroy();delete this._oLegacySelectionPlugin;}};s.prototype._createLegacySelectionPlugin=function(){return new n();};function z(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.attachSelectionChange(i._onSelectionChanged,i);}}function J(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.detachSelectionChange(i._onSelectionChanged,i);}}s.prototype.insertAggregation=function(i,O,l,M){if(i==="_hiddenDependents"){return C.prototype.insertAggregation.call(this,i,O,l,true);}return C.prototype.insertAggregation.apply(this,arguments);};s.prototype.addAggregation=function(i,O,l){if(i==="_hiddenDependents"){return C.prototype.addAggregation.call(this,i,O,true);}return C.prototype.addAggregation.apply(this,arguments);};s.prototype.removeAggregation=function(i,O,l){if(i==="_hiddenDependents"){return C.prototype.removeAggregation.call(this,i,O,true);}return C.prototype.removeAggregation.apply(this,arguments);};s.prototype.removeAllAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.removeAllAggregation.call(this,i,true);}return C.prototype.removeAllAggregation.apply(this,arguments);};s.prototype.destroyAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.destroyAggregation.call(this,i,true);}C.prototype.destroyAggregation.apply(this,arguments);if(i==="rows"){this._aRowClones.forEach(function(M){M.destroy();});this._aRowClones=[];}return this;};s.prototype.getCellControl=function(i,l,M){var O=T.getRowColCell(this,i,l,!M);return O.cell;};s.prototype._fireRowsUpdated=function(i){var l={reason:i||T.RowsUpdateReason.Unknown};this.onRowsUpdated(l);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(l);this.fireEvent("_rowsUpdated",l);}.bind(this),0);};s.prototype.onRowsUpdated=function(i){T.Grouping.updateGroups(this);this._getAccExtension()._updateAriaRowIndices();this._updateSelection();};s.prototype.onRowsContentUpdated=function(i){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(i.reason);}};s.prototype._enableSynchronization=function(){var i=this;return new Promise(function(l,M){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(O){l(d.enrich(i,O).getInterface());},function(O){M(O);});});};s.prototype._enableLegacyMultiSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.");}this._legacyMultiSelection=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied");}var M=!!(l.metaKey||l.ctrlKey);if(!this.isIndexSelected(i)){if(M){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else if(M||this._getSelectionPlugin().getSelectedCount()===1){this.removeSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}.bind(this);};return s;});
