/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/library","sap/f/library","sap/ui/core/Control","sap/m/Text","sap/f/Avatar","sap/ui/Device","sap/f/cards/HeaderRenderer","sap/ui/core/Core"],function(l,a,C,T,A,D,H,b){"use strict";var c=l.AvatarShape;var d=l.AvatarColor;var e=C.extend("sap.f.cards.Header",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{type:"string",defaultValue:""},subtitle:{type:"string",defaultValue:""},statusText:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:c.Circle},iconSrc:{type:"sap.ui.core.URI",defaultValue:""},iconInitials:{type:"string",defaultValue:""},iconAlt:{type:"string",defaultValue:""},iconBackgroundColor:{type:"sap.m.AvatarColor",defaultValue:d.Transparent}},aggregations:{toolbar:{type:"sap.ui.core.Control",multiple:false},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_avatar:{type:"sap.f.Avatar",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:H});e.prototype.init=function(){this._oRb=b.getLibraryResourceBundle("sap.f");this.data("sap-ui-fastnavgroup","true",true);};e.prototype.exit=function(){this._oRb=null;};e.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new T({maxLines:3}).addStyleClass("sapFCardTitle");this.setAggregation("_title",t);}return t;};e.prototype._getSubtitle=function(){var s=this.getAggregation("_subtitle");if(!s){s=new T({maxLines:2}).addStyleClass("sapFCardSubtitle");this.setAggregation("_subtitle",s);}return s;};e.prototype._getAvatar=function(){var o=this.getAggregation("_avatar");if(!o){o=new A().addStyleClass("sapFCardIcon");this.setAggregation("_avatar",o);}return o;};e.prototype.onBeforeRendering=function(){var o=this._getAvatar();this._getTitle().setText(this.getTitle());this._getSubtitle().setText(this.getSubtitle());o.setDisplayShape(this.getIconDisplayShape());o.setSrc(this.getIconSrc());o.setInitials(this.getIconInitials());o.setTooltip(this.getIconAlt());o.setBackgroundColor(this.getIconBackgroundColor());this._setAccessibilityAttributes();};e.prototype._getHeaderAccessibility=function(){var s=this._getSubtitle()?this._getSubtitle().getId():"",S=this.getStatusText()?this.getId()+"-status":"",f=this._getAvatar()?this._getAvatar().getId():"",i=s+" "+S+" "+f;return i.trim();};e.prototype.onAfterRendering=function(){if(D.browser.msie){if(this.getTitle()){this._getTitle().clampText();}if(this.getSubtitle()){this._getSubtitle().clampText();}}};e.prototype.ontap=function(E){var s=E.srcControl;if(s&&s.getId().indexOf("overflowButton")>-1){return;}this.firePress();};e.prototype.onsapselect=function(){this.firePress();};e.prototype._setAccessibilityAttributes=function(){if(this.hasListeners("press")){this._sAriaRole="button";this._sAriaHeadingLevel=undefined;this._sAriaRoleDescritoion=this._oRb.getText("ARIA_ROLEDESCRIPTION_INTERACTIVE_CARD_HEADER");}else{this._sAriaRole="heading";this._sAriaHeadingLevel="3";this._sAriaRoleDescritoion=this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER");}};e.prototype.isLoading=function(){return false;};e.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.attachEvent.apply(this,m);this.invalidate();return this;};e.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.detachEvent.apply(this,m);this.invalidate();return this;};e.prototype._isInsideGridContainer=function(){var p=this.getParent();if(!p){return false;}p=p.getParent();if(!p){return false;}return p.isA("sap.f.GridContainer");};return e;});
