/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","sap/ui/core/dnd/DropInfo","sap/f/dnd/GridDragOver","sap/base/Log"],function(c,D,G,L){"use strict";var a=D.extend("sap.f.dnd.GridDropInfo",{metadata:{library:"sap.f",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{dropIndicatorSize:{type:"function",invalidate:false,parameters:{draggedControl:{type:"sap.ui.core.Control"}}}},events:{}}});a.prototype.isDroppable=function(C,e){if(!this._shouldEnhance()){return D.prototype.isDroppable.apply(this,arguments);}if(!this.getEnabled()){return false;}if(!C||!e){return false;}var d=this.getDropTarget();if(!d){return false;}var A=d.getDomRefForSetting(this.getTargetAggregation());if(A&&A.contains(e.target)){e.setMark("DragWithin",this.getTargetAggregation());return true;}if(!A&&d===C){return true;}return false;};a.prototype.fireDragEnter=function(e){if(!this._shouldEnhance()||this._isKeyboardEvent(e)){return D.prototype.fireDragEnter.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}this._hideDefaultIndicator(e);var g=G.getInstance(),d=e.dragSession.getDragControl();if(this.getDropIndicatorSize()){g.setDropIndicatorSize(this.getDropIndicatorSize()(d));}g.setCurrentContext(e.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation());var m=g.getSuggestedDropPosition();var b=this.fireEvent("dragEnter",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:m?m.targetControl:null},true);if(b){g.handleDragOver(e);}return b;};a.prototype.fireDragOver=function(e){if(!this._shouldEnhance()||this._isKeyboardEvent(e)){return D.prototype.fireDragOver.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}this._hideDefaultIndicator(e);var d=this._suggestDropPosition(e);if(d&&e.dragSession&&d.targetControl){e.dragSession.setDropControl(d.targetControl);}return this.fireEvent("dragOver",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d?d.targetControl:null,dropPosition:d?d.position:null});};a.prototype.fireDrop=function(e){if(!this._shouldEnhance()||this._isKeyboardEvent(e)){return D.prototype.fireDrop.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}var d=e.dragSession,g=G.getInstance(),m;g.setCurrentContext(d.getDragControl(),this.getDropTarget(),this.getTargetAggregation());m=g.getSuggestedDropPosition();this.fireEvent("drop",{dragSession:e.dragSession,browserEvent:e.originalEvent,dropPosition:m?m.position:null,draggedControl:d.getDragControl(),droppedControl:m?m.targetControl:null});g.scheduleEndDrag();};a.prototype._shouldEnhance=function(){if(this._bShouldEnhance===undefined){if(!this.getParent().isA("sap.f.dnd.IGridDroppable")){L.error("The control which uses 'sap.f.dnd.GridDropInfo' has to implement 'sap.f.dnd.IGridDroppable'.","sap.f.dnd.GridDropInfo");this._bShouldEnhance=false;return this._bShouldEnhance;}this._bShouldEnhance=this.getDropPosition()===c.dnd.DropPosition.Between&&this.getDropLayout()===c.dnd.DropLayout.Horizontal;}return this._bShouldEnhance;};a.prototype._isKeyboardEvent=function(e){return e.originalEvent.type==="keydown";};a.prototype._suggestDropPosition=function(d){if(!d.dragSession||!d.dragSession.getDragControl()){return null;}var g=G.getInstance();g.setCurrentContext(d.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation());g.handleDragOver(d);return g.getSuggestedDropPosition();};a.prototype._hideDefaultIndicator=function(d){d.dragSession.setIndicatorConfig({visibility:"hidden",position:"relative"});};return a;});
