/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation',"sap/ui/core/InvisibleText",'sap/ui/core/ResizeHandler','sap/ui/Device','sap/m/Button','sap/m/IconTabFilter','sap/m/IconTabSeparator','sap/m/IconTabBarDragAndDropUtil','sap/ui/core/library','sap/m/IconTabHeaderRenderer',"sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/events/KeyCodes"],function(l,C,a,E,I,b,R,D,B,c,d,e,f,g,q,L,K){"use strict";var h=f.dnd.DropPosition;var k=l.BackgroundDesign;var m=l.IconTabHeaderMode;var n=l.IconTabDensityMode;var o=a.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:m.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:k.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:n.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_overflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});var r=C.getLibraryResourceBundle("sap.m");E.apply(o.prototype,[true]);o.prototype.init=function(){this._aTabKeys=[];this._oAriaHeadText=null;this._bIsRendered=false;};o.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oOverflow){this._oOverflow.removeEventDelegate(this._oOverflowEventDelegate);this._oOverflowEventDelegate=null;this._oOverflow=null;}if(this._oAriaHeadText){this._oAriaHeadText.destroy();this._oAriaHeadText=null;}this._bRtl=null;};o.prototype.onBeforeRendering=function(){this._bIsRendered=false;this._bRtl=C.getConfiguration().getRTL();if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._updateSelection();this.destroyDragDropConfig();this._setsDragAndDropConfigurations();};o.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this.oSelectedItem){this._applySelectionToFilters();this.oSelectedItem._hideBadge();}if(C.isThemeApplied()){this._setItemsForStrip();}else{C.attachThemeChanged(this._handleThemeLoad,this);}this._initItemNavigation();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._fnResize,this));this.getItems().forEach(function(i){if(i._onAfterParentRendering){i._onAfterParentRendering();}});this._bIsRendered=true;};o.prototype._isRendered=function(){return this._bIsRendered;};o.prototype._getSelectList=function(){return this._getOverflow()._getSelectList();};o.prototype._getOverflow=function(){var O=this.getAggregation("_overflow");if(!O){O=new c({id:this.getId()+'-overflow',text:r.getText("ICONTABHEADER_OVERFLOW_MORE")});O._bIsOverflow=true;this._oOverflowEventDelegate={onsapnext:O.onsapdown};O.addEventDelegate(this._oOverflowEventDelegate,O);this.setAggregation("_overflow",O);this._oOverflow=O;}return O;};o.prototype._getInvisibleHeadText=function(){var A=this.getAriaTexts()||{};if(!this._oAriaHeadText){this._oAriaHeadText=new b({id:this.getId()+"-ariaHeadText"});}this._oAriaHeadText.setText(A.headerDescription);return this._oAriaHeadText;};o.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var j=this.getItems();var p=-1;var s;for(var i=0;i<j.length;i++){s=j[i];if(s instanceof c==false){continue;}p++;if((this.oSelectedItem._getRootTab()||this.oSelectedItem)===s){break;}}this._oItemNavigation.setFocusedIndex(p);};o.prototype.getTabFilters=function(){var t=[];this.getItems().forEach(function(i){if(i instanceof c){t.push(i);}});return t;};o.prototype._setsDragAndDropConfigurations=function(){if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){e.setDragDropAggregations(this,"Horizontal",this._getDropPosition());}};o.prototype._getDropPosition=function(){return this.getMaxNestingLevel()===0?h.Between:h.OnOrBetween;};o.prototype.setSelectedKey=function(s){var j=this.getTabFilters(),p=this._isInsideIconTabBar(),S;if(j.length>0){s=s||j[0]._getNonEmptyKey();}if(this.$().length){for(var i=0;i<j.length;i++){if(j[i]._getNonEmptyKey()===s){this.setSelectedItem(j[i],true);S=true;break;}}if(!S&&!p&&s){this.setSelectedItem(null);}}this.setProperty("selectedKey",s,true);return this;};o.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this._removeSelectionFromFilters();this.oSelectedItem=null;}return this;}if(this._isUnselectable(i)){return this;}var p=this.getParent();var j=this._isInsideIconTabBar();var s=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){s=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&j&&p.getExpandable()||this.oSelectedItem!==i)){this._removeSelectionFromFilters();}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&j&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(j){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this._applySelectionToFilters();this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(j&&(p.getExpandable()||p.getExpanded())){var S=this.oSelectedItem.getContent();if(S.length>0){p._rerenderContent(S);}else{if(!s){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}}this.oSelectedItem=i;var t=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",t,true);if(j){p.setProperty("selectedKey",t,true);}if(!A){if(j){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:t,item:this.oSelectedItem,key:t});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:t,item:this.oSelectedItem,key:t});}}this.oSelectedItem._startBadgeHiding();this._setItemsForStrip();return this;};o.prototype.getVisibleTabFilters=function(){return this.getTabFilters().filter(function(F){return F.getVisible();});};o.prototype._initItemNavigation=function(){var t=[],s=-1,S=this.oSelectedItem&&this.oSelectedItem._getRootTab();this.getTabFilters().forEach(function(i){var j=this.getFocusDomRef(i);if(!j){return;}j.setAttribute("tabindex","-1");t.push(j);if(i===S||i===this.oSelectedItem){s=t.indexOf(j);}}.bind(this));if(this.$().hasClass("sapMITHOverflowList")){var O=this._getOverflow().getFocusDomRef();O.setAttribute("tabindex","-1");t.push(O);}if(!this._oItemNavigation){this._oItemNavigation=new I().setCycling(false).attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(t).setPageSize(t.length).setSelectedIndex(s);};o.prototype.onThemeChanged=function(){this._applyTabDensityMode();};o.prototype._applyTabDensityMode=function(){var t=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(t){case n.Compact:this.$().addClass("sapUiSizeCompact");break;case n.Inherit:if(this.$().closest(".sapUiSizeCompact").length){this.$().addClass("sapUiSizeCompact");}break;}};o.prototype._handleThemeLoad=function(){setTimeout(this._setItemsForStrip.bind(this),350);C.detachThemeChanged(this._handleThemeLoad,this);};o.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");return this;};o.prototype.addItem=function(i){if(!(i instanceof d)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.addAggregation("items",i);this._invalidateParentIconTabBar();};o.prototype.insertItem=function(i,j){if(!(i instanceof d)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.insertAggregation("items",i,j);this._invalidateParentIconTabBar();};o.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this._aTabKeys=[];this.oSelectedItem=null;this._invalidateParentIconTabBar();return i;};o.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof d)){var s=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(s),1);}if(this.oSelectedItem===i){this.oSelectedItem=null;}this._invalidateParentIconTabBar();return i;};o.prototype.updateAggregation=function(){this.oSelectedItem=null;a.prototype.updateAggregation.apply(this,arguments);this.invalidate();};o.prototype.removeAggregation=function(A,O,s){var i=this.getTabFilters();var j=a.prototype.removeAggregation.apply(this,arguments);if(s){return j;}if(!this._getPreserveSelection()&&j&&j==this.oSelectedItem&&A=='items'){var p=(i?Array.prototype.indexOf.call(i,j):-1);i=this.getTabFilters();p=Math.max(0,Math.min(p,i.length-1));var S=i[p];if(S){this.setSelectedItem(S,true);}else{var t=this.getParent();if(this._isInsideIconTabBar()&&t.getExpanded()){t.$("content").children().remove();}}}return j;};o.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(this._isInsideIconTabBar()&&i.getExpanded()){i.$("content").children().remove();}}return a.prototype.removeAllAggregation.apply(this,arguments);};o.prototype._getPreserveSelection=function(){return this._bPreserveSelection;};o.prototype._setPreserveSelection=function(p){this._bPreserveSelection=p;};o.prototype._getDisplayText=function(i){var t=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){t='('+s+') '+t;}else{t+=' ('+s+')';}}}return t;};o.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==m.Inline;};o.prototype._checkTextOnly=function(){this._bTextOnly=this.getItems().every(function(i){return i instanceof d||!i.getIcon();});return this._bTextOnly;};o.prototype._checkNoText=function(j){if(j.length>0){for(var i=0;i<j.length;i++){if(!(j[i]instanceof d)){if(j[i].getText().length>0){return false;}}}}return true;};o.prototype._checkInLine=function(j){var p;if(j.length>0){for(var i=0;i<j.length;i++){p=j[i];if(!(p instanceof d)){if(p.getIcon()||p.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};o.prototype._getItemsInStrip=function(){return this.getItems().filter(function(i){var j=i.getDomRef();return j&&!j.classList.contains("sapMITBFilterHidden");});};o.prototype._setItemsForStrip=function(){var t=this.getVisibleTabFilters();if(!C.isThemeApplied()||!t.length){return;}var T=this.getDomRef("head"),s=(this.oSelectedItem&&this.oSelectedItem.getVisible())?this.oSelectedItem:t[0];if(!T){return;}var j=T.offsetWidth,i,S=(s._getRootTab()||s).getDomRef(),p=this.getItems().filter(function(A){return A.getDomRef();}).map(function(A){return A.getDomRef();});if(!p.length||!S){return;}p.forEach(function(A){A.style.width="";A.classList.remove("sapMITBFilterHidden");A.classList.remove("sapMITBFilterTruncated");});var u=p.indexOf(S),v=this._getItemSize(S),w,x=0,y;if(p[u-1]&&p[u-1].classList.contains("sapMITBSep")){w=p[u-1];x=this._getItemSize(w);}y=v+x;if(j<y){S.style.width=(j-20-x)+"px";S.classList.add("sapMITBFilterTruncated");}p.splice(u,1);if(w){p.splice(u-1,1);}var z=this._findLastVisibleItem(p,j,y);for(i=z+1;i<p.length;i++){p[i].classList.add("sapMITBFilterHidden");}this._getOverflow()._updateExpandButtonBadge();this._getOverflow().$().toggleClass("sapMITHOverflowVisible",z+1!==p.length);this.$().toggleClass("sapMITHOverflowList",z+1!==p.length);};o.prototype._findLastVisibleItem=function(i,t,s){var j=-1,p,u,v,P;for(p=0;p<i.length;p++){u=i[p];v=this._getItemSize(u);if(t>(s+v)){s+=v;j=p;}else{P=i[p-1];if(P&&P.classList.contains("sapMITBSep")){j-=1;}break;}}return j;};o.prototype._getItemSize=function(i){var s=window.getComputedStyle(i),w=i.offsetWidth,M=Number.parseInt(s.marginLeft)+Number.parseInt(s.marginRight);return w+M;};o.prototype._handleActivation=function(i){var t=i.target.id,j=i.srcControl,s,$=q(i.target);if(j instanceof B){return;}var p=q(document.getElementById(t));if(p.parents()&&Array.prototype.indexOf.call(p.parents(),this.$("content")[0])>-1){}else{if(t){i.preventDefault();if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){s=i.srcControl.getId().replace(/-icon$/,"");j=C.byId(s);if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._bIsOverflow){j._expandButtonPress();}return;}if(j===this._getOverflow()){j._expandButtonPress();return;}this.setSelectedItem(j);}}else if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._bIsOverflow){j._expandButtonPress();}return;}if(j===this._getOverflow()){j._expandButtonPress();return;}this.setSelectedItem(j);}}else{if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._bIsOverflow){j._expandButtonPress();}return;}if(j===this._getOverflow()){j._expandButtonPress();return;}this.setSelectedItem(j);}}}};o.prototype._fnResize=function(){if(this._getOverflow()._oPopover){this._getOverflow()._oPopover.close();}this._setItemsForStrip();this._initItemNavigation();};o.prototype._isUnselectable=function(i){var F=i._getRealTab();return!F.getEnabled()||(this._isInsideIconTabBar()&&!this.getParent().getContent().length&&F._getNestedLevel()===1&&F.getItems().length&&!F.getContent().length)||F._bIsOverflow;};o.prototype._isInsideIconTabBar=function(){var p=this.getParent();return p instanceof a&&p.isA('sap.m.IconTabBar');};o.prototype._invalidateParentIconTabBar=function(){if(this._isInsideIconTabBar()){this.getParent().invalidate();}};o.prototype.getFocusDomRef=function(F){var t=F||this.oSelectedItem;if(!t){return null;}return t.getDomRef();};o.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).trigger("focus");}};o.prototype._updateSelection=function(){var j=this.getItems(),s=this.getSelectedKey(),i=0,p=this.getParent(),t=this._isInsideIconTabBar(),u=p&&p.isA("sap.tnt.ToolHeader");if(!j.length){return;}if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){this.oSelectedItem=this._findItemByKey(s);}if(!this.oSelectedItem&&(t||!s)){for(i=0;i<j.length;i++){if(!(j[i]instanceof d)&&j[i].getVisible()){this.oSelectedItem=j[i];break;}}}}if(!u&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<j.length;i++){if(!(j[i]instanceof d)&&j[i].getVisible()){this.oSelectedItem=j[i];break;}}}if(!this.oSelectedItem){return;}if(this._isUnselectable(this.oSelectedItem)){this.setSelectedItem(this.oSelectedItem._getFirstAvailableSubFilter(),true);return;}this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);};o.prototype._findItemByKey=function(s){var t=this.getTabFilters(),S;for(var i=0;i<t.length;i++){if(t[i]._getNonEmptyKey()===s){return t[i];}S=t[i]._getAllSubFilters();for(var j=0;j<S.length;j++){if(S[j]._getNonEmptyKey()===s){return S[j];}}}};o.prototype._applySelectionToFilters=function(){if(this._isInsideIconTabBar()&&!this.getParent().getExpanded()){return;}this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});if(this.oSelectedItem._getNestedLevel()!==1){var s=this.oSelectedItem._getRootTab();s.$().addClass("sapMITBSelected").attr({"aria-selected":true});}};o.prototype._removeSelectionFromFilters=function(){this.oSelectedItem.$().removeClass("sapMITBSelected").attr({'aria-selected':false});if(this.oSelectedItem._getNestedLevel()!==1){var s=this.oSelectedItem._getRootTab();s.$().removeClass("sapMITBSelected").attr({"aria-selected":false});}};o.prototype._getItemsForOverflow=function(){var i=this._getItemsInStrip(),j=[];this.getItems().forEach(function(p){if(!D.system.phone&&i.indexOf(p)>-1){return;}j.push(p);if(p.isA("sap.m.IconTabFilter")){p._getAllSubItems().forEach(function(s){j.push(s);});}});return j;};o.prototype.ontouchstart=function(i){var t=i.targetTouches[0];this._iActiveTouch=t.identifier;};o.prototype.ontouchend=function(i){if(this._iActiveTouch===undefined){return;}var M=0;var j=1;var p;if(i.which===p||i.which===M||i.which===j){this._handleActivation(i);}this._iActiveTouch=undefined;};o.prototype.ontouchcancel=o.prototype.ontouchend;o.prototype.onkeydown=function(i){switch(i.which){case K.ENTER:this._handleActivation(i);i.preventDefault();break;case K.SPACE:this._handleActivation(i);i.preventDefault();break;}};o.prototype._handleDragAndDrop=function(i){var j=i.getParameter("dropPosition"),p=i.getParameter("draggedControl"),s=i.getParameter("droppedControl"),t=this,u=this.getMaxNestingLevel();if(j===h.On){t=s._getRealTab();}e.handleDrop(t,j,p._getRealTab(),s,false,u);if(p._getNestedLevel()>1){p._getRootTab()._closePopover();}this._setItemsForStrip();this._initItemNavigation();this._getOverflow()._setSelectListItems();this._getSelectList()._initItemNavigation();p._getRealTab().$().trigger("focus");if(j===h.On){s._getRealTab().$().trigger("focus");}};o.prototype._moveTab=function(t,i,M){e.moveItem.call(this,t,i,M);this._setItemsForStrip();this._initItemNavigation();};o.prototype.ondragrearranging=function(i){if(!this.getEnableTabReordering()){return;}var t=i.srcControl,T=this.indexOfItem(this._getItemsInStrip().pop());this._moveTab(t,i.keyCode,T);t.$().trigger("focus");};o.prototype.onsaphomemodifiers=o.prototype.ondragrearranging;o.prototype.onsapendmodifiers=o.prototype.ondragrearranging;o.prototype.onsapincreasemodifiers=o.prototype.ondragrearranging;o.prototype.onsapdecreasemodifiers=o.prototype.ondragrearranging;return o;});
