/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/library','sap/m/library','sap/ui/Device',"sap/base/Log",'sap/m/Link','sap/m/Text',"sap/ui/thirdparty/jquery","sap/ui/util/defaultLinkTypes"],function(C,c,l,D,L,a,T,q,d){"use strict";var b=c.TextDirection;var B=l.BackgroundDesign;var e=c.TitleLevel;var O={apiVersion:2};O._isEmptyObject=function(o){if(!o){return true;}if((!o._isEmpty||!o._isEmpty())&&(!o.getVisible||o.getVisible())){return false;}return true;};O._isEmptyArray=function(A){if(A){for(var i=0;i<A.length;i++){if(!O._isEmptyObject(A[i])){return false;}}}return true;};O._isEmptyRow=function(o,r){return O._isEmptyObject(o)&&O._isEmptyArray(r);};O._renderObjects=function(r,o,f){for(var i=0;i<o.length;i++){if(o[i]instanceof C){this._renderChildControl(r,f,o[i]);}}};O._computeChildControlsToBeRendered=function(o){o.__controlsToBeRendered={};var f=o.getAttributes();for(var i=0;i<f.length;i++){o.__controlsToBeRendered[f[i].getId()]=f[i];}f=o.getStatuses();for(var i=0;i<f.length;i++){o.__controlsToBeRendered[f[i].getId()]=f[i];}var g=o.getFirstStatus();if(g){o.__controlsToBeRendered[g.getId()]=g;}g=o.getSecondStatus();if(g){o.__controlsToBeRendered[g.getId()]=g;}g=o.getAggregation("_objectNumber");if(g){o.__controlsToBeRendered[g.getId()]=g;}};O._cleanupNotRenderedChildControls=function(r,o){for(var i in o.__controlsToBeRendered){r.cleanupControlWithoutRendering(o.__controlsToBeRendered[i]);}delete o.__controlsToBeRendered;};O._getMarkers=function(o){return o._getVisibleMarkers();};O._renderIntro=function(r,o,i,I){if(o.getIntroActive()){o._introText=new a(o.getId()+"-intro");o._introText.setText(o.getIntro());o._introText.setHref(o.getIntroHref());o._introText.setTarget(o.getIntroTarget());o._introText.press=o.introPress;}else{o._introText=new T(o.getId()+"-intro");o._introText.setText(o.getIntro());o._introText.setMaxLines(3);}o._introText.setTextDirection(o.getIntroTextDirection());r.openStart("div");r.class(i);if(o.getIntroActive()){r.class(I);}r.openEnd();this._renderChildControl(r,o,o._introText);r.close("div");};O._renderAttribute=function(r,o,A,f){r.openStart("div");r.class("sapMOHAttr");if(f){r.style("width","100%");}r.openEnd();this._renderChildControl(r,o,A);r.close("div");};O._getVisibleStatuses=function(o){var v=[];if(o.getFirstStatus()&&o.getFirstStatus().getVisible()){v.push([o.getFirstStatus()]);}if(o.getSecondStatus()&&o.getSecondStatus().getVisible()){v.push([o.getSecondStatus()]);}if(o.getStatuses()){var s=o.getStatuses();for(var i=0;i<s.length;i++){if(!s[i].getVisible||s[i].getVisible()){if((s[i]instanceof sap.m.ObjectStatus&&!s[i]._isEmpty())||s[i]instanceof sap.m.ProgressIndicator){v.push([s[i]]);}else{L.warning("Only sap.m.ObjectStatus or sap.m.ProgressIndicator are allowed in \"sap.m.ObjectHeader.statuses\" aggregation."+" Current object is "+s[i].constructor.getMetadata().getName()+" with id \""+s[i].getId()+"\"");}}}}return v;};O._getVisibleAttribsAndStatuses=function(o){var r=[],A=o.getAttributes(),v=[];for(var j=0;j<A.length;j++){if(A[j].getVisible()&&!A[j]._isEmpty()){v.push(A[j]);}}var V=this._getVisibleStatuses(o);r[0]=v;r[1]=V;return r;};O._renderRow=function(r,o,f,R){if(O._isEmptyRow(f,R)){return;}r.openStart("div");r.class("sapMOHAttrRow");r.openEnd();if(!O._isEmptyObject(f)){this._renderAttribute(r,o,f,O._isEmptyArray(R));}else if(O._isEmptyObject(f)&&!O._isEmptyArray(R)){if(R[0]instanceof sap.m.ProgressIndicator){r.openStart("div");r.class("sapMOHAttr");r.openEnd();r.close("div");}}if(!O._isEmptyArray(R)){r.openStart("div");if(R[0]instanceof sap.m.ProgressIndicator){r.class("sapMOHStatusFixedWidth");}else if(R[0]instanceof sap.m.ObjectMarker){r.class("sapMOHStatusFixedWidth");r.class("sapMObjStatusMarker");}else{r.class("sapMOHStatus");}r.openEnd();O._renderObjects(r,R,o);r.close("div");}r.close("div");};O._renderAttributesAndStatuses=function(r,o){var A=o.getAttributes();var v=[];for(var j=0;j<A.length;j++){if(A[j].getVisible()){v.push(A[j]);}}var i=v.length;var m=[];var M=O._getMarkers(o);if(!o.getResponsive()&&!O._isEmptyArray(M)){m.push(M);}var V=this._getVisibleStatuses(o);m=m.concat(V);var f=m.length;var n=i>f?i:f;if(!o.getResponsive()){for(var g=0;g<n;g++){this._renderRow(r,o,v[g],m[g]);}}};O._renderNumber=function(r,o){var n=o.getAdditionalNumbers();if(!o.getNumber()&&(n&&!n.length)){return;}r.openStart("div",o.getId()+"-numberdiv");r.class("sapMOHNumberDiv");r.openEnd();var f=o.getAggregation("_objectNumber");if(f&&f.getNumber()){f.setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,f);}r.close("div");if(!o.getCondensed()){this._renderAdditionalNumbers(r,o);}};O._renderAdditionalNumbers=function(r,o){var n=o.getAdditionalNumbers();if(n&&!n.length){return;}if(n.length===1){r.openStart("div");r.class("additionalOHNumberSeparatorDiv");r.openEnd();r.close("div");}for(var i=0;i<n.length;i++){r.openStart("div",o.getId()+"-additionalNumber"+i);r.class("sapMOHNumberDiv");r.class("additionalOHNumberDiv");if(n.length===1){r.class("sapMOHOnlyANumber");}r.openEnd();n[i].setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,n[i]);r.close("div");}};O._renderTitle=function(r,o){o._oTitleArrowIcon.setVisible(o.getShowTitleSelector());if(o.getShowTitleSelector()&&o._oTitleArrowIcon.getVisible()){r.openStart("div");r.class("sapMOHTitleAndArrow");r.openEnd();}if(o.getTitle()){var t=(o.getTitleLevel()===e.Auto)?e.H1:o.getTitleLevel();t=t.toLowerCase();o._titleText.setText(o.getTitle());o._titleText.setTextDirection(o.getTitleTextDirection());if(o.getTitleActive()){r.openStart("a",o.getId()+"-title");if(o.getTitleHref()){r.attr("href",o.getTitleHref());if(o.getTitleTarget()){r.attr("target",o.getTitleTarget());r.attr("rel",d('',o.getTitleTarget()));}}r.accessibilityState({role:"link"});}else{r.openStart("div",o.getId()+"-title");}r.class("sapMOHTitle");if(o.getTitleActive()){r.attr("tabindex","0");r.class("sapMOHTitleActive");}if(o.getShowTitleSelector()){r.class("sapMOHTitleFollowArrow");}r.openEnd();r.openStart(t);r.openEnd();this._renderChildControl(r,o,o._titleText);r.close(t);if(o.getTitleActive()){r.close("a");}else{r.close("div");}}if(o.getShowTitleSelector()){r.openStart("span");r.class("sapMOHTitleArrow");r.openEnd();this._renderChildControl(r,o,o._oTitleArrowIcon);r.close("span");}if(o.getShowTitleSelector()&&o._oTitleArrowIcon.getVisible()){r.close("div");}};O._renderFullTitle=function(r,o){var n=o.getAdditionalNumbers();if(!o.getNumber()&&(n&&!n.length)){r.class("sapMOHTitleDivFull");}};O._renderFullOH=function(r,o){if(o.getIntro()){this._renderIntro(r,o,"sapMOHIntro","sapMOHIntroActive");}r.openStart("div");r.class("sapMOHTopRow");r.openEnd();r.openStart("div",o.getId()+"-titlediv");r.class("sapMOHTitleDiv");if(o._hasIcon()){r.class("sapMOHTitleIcon");}this._renderFullTitle(r,o);r.openEnd();if(o._hasIcon()){r.openStart("div");r.class("sapMOHIcon");r.class('sapMOHIcon'+o.getImageShape());if(o.getIconActive()){r.class("sapMPointer");}r.openEnd();this._renderChildControl(r,o,o._getImageControl());r.close("div");}this._renderTitle(r,o);r.close("div");this._renderNumber(r,o);r.openStart("div");r.class("sapMOHDivider");r.openEnd();r.close("div");r.close("div");if(o._hasBottomContent()){r.openStart("div");r.class("sapMOHBottomRow");r.openEnd();this._renderAttributesAndStatuses(r,o);r.openStart("div");r.class("sapMOHDivider");r.openEnd();r.close("div");r.close("div");}};O._renderCondensedOH=function(r,o){r.openStart("div",o.getId()+"-titlediv");r.class("sapMOHTitleDiv");this._renderFullTitle(r,o);r.openEnd();this._renderTitle(r,o);r.close("div");this._renderNumber(r,o);var f=o.getAttributes()[0];if(f&&!f._isEmpty()){this._renderAttribute(r,o,f);}};O.render=function(r,o){if(o.getResponsive()){this._renderResponsive(r,o);return;}this._computeChildControlsToBeRendered(o);var f=o.getCondensed();r.openStart("div",o);r.openEnd();r.openStart("div");r.class("sapMOH");if(o._getBackground()!==B.Transparent){r.class("sapContrastPlus");}if(f){r.class("sapMOHC");}r.class("sapMOHBg"+o._getBackground());var t=o.getTooltip_AsString();if(t){r.attr("title",t);}r.accessibilityState({role:"region",labelledby:{value:o.getId()+"-titleText-inner",append:true}});r.openEnd();if(f){this._renderCondensedOH(r,o);}else{this._renderFullOH(r,o);}r.openStart("div");r.class("sapMOHLastDivider");r.openEnd();r.close("div");r.close("div");r.close("div");this._cleanupNotRenderedChildControls(r,o);};O._renderChildControl=function(r,o,f){r.renderControl(f);if(!o.getResponsive()&&o.__controlsToBeRendered){o.__controlsToBeRendered[f.getId()]=undefined;}};O._renderResponsive=function(r,o){var s=this._hasResponsiveStates(o),t=this._hasResponsiveTabs(o),h=o.getHeaderContainer();r.openStart("div",o);r.class("sapMOHROuter");var f=o.getTooltip_AsString();if(f){r.attr("title",f);}r.accessibilityState({role:"region",labelledby:{value:o.getId()+"-txt",append:true}});r.openEnd();r.openStart("div");r.class("sapMOHR");if(o._getBackground()!==B.Transparent){r.class("sapContrastPlus");}if(t){r.class("sapMOHRNoBorder");}r.class("sapMOHRBg"+o._getBackground());r.openEnd();r.openStart("div");if(D.system.desktop&&o._isMediaSize("Desktop")&&o.getFullScreenOptimized()&&o._iCountVisAttrStat>=1&&o._iCountVisAttrStat<=3){r.class("sapMOHRStatesOneOrThree");}r.openEnd();this._renderResponsiveTitleBlock(r,o);if(s){this._renderResponsiveStates(r,o);}r.close("div");if(t){this._renderResponsiveTabs(r,o);}r.close("div");if(h&&h instanceof sap.m.IconTabBar){this._renderChildControl(r,o,h);}r.close("div");if(!o.getTitle()){if(!o.getBinding("title")){L.warning("The title shouldn't be empty!");}}};O._renderResponsiveTitleBlock=function(r,o){r.openStart("div",o.getId()+"-titlenumdiv");r.class("sapMOHRTitleNumberDiv");r.openEnd();r.openStart("div",o.getId()+"-titlediv");r.class("sapMOHRTitleDiv");if(o._hasIcon()){if(D.system.phone||o._isMediaSize("Phone")){if(D.orientation.landscape||(o._isMediaSize("Phone")&&!D.system.phone)){r.class("sapMOHRTitleIcon");}}else{r.class("sapMOHRTitleIcon");}}if(!o.getNumber()){r.class("sapMOHRTitleDivFull");}r.openEnd();this._renderResponsiveTitle(r,o);if(o._hasIcon()){r.openStart("div",o.getId()+"-titleIcon");r.class("sapMOHRIcon");r.class('sapMOHRIcon'+o.getImageShape());if((D.system.phone&&D.orientation.portrait)){r.class("sapMOHRHideIcon");}if(o.getIconActive()){r.class("sapMPointer");}r.openEnd();this._renderChildControl(r,o,o._getImageControl());r.close("div");}r.close("div");this._renderResponsiveNumber(r,o);r.close("div");};O._renderResponsiveStates=function(r,o){r.openStart("div",o.getId()+"-states");r.class("sapMOHRStates");r.openEnd();this._renderResponsiveRow(r,o);r.close("div");};O._renderResponsiveRow=function(r,o){var v=[];v=this._getVisibleAttribsAndStatuses(o);var V=v[0].concat(v[1]),i=v[0].length,f=V.length,R=1,s='';if(f===0){return;}if(D.system.desktop){if(!o.getFullScreenOptimized()){if(f>=1&&f<=4){R=2;s='sapMOHRTwoCols';}if(f>=5){R=3;s='sapMOHRThreeCols';}}else{if(f>=1&&f<=3){R=1;s='sapMOHROneCols';}if(f>=4){R=4;s='sapMOHRFourCols';}}}if((D.system.tablet&&!D.system.desktop)||(D.system.desktop&&o._isMediaSize("Tablet"))){if(!o.getFullScreenOptimized()||(D.orientation.portrait&&o.getFullScreenOptimized())){R=2;s='sapMOHRTwoCols';}else{if(o.getFullScreenOptimized()&&(D.orientation.landscape||(D.system.desktop&&o._isMediaSize("Tablet")))){if(f>=1&&f<=2){R=2;s='sapMOHRTwoCols';}if(f>=3){R=3;s='sapMOHRThreeCols';}}}}if(D.system.phone||(D.system.desktop&&o._isMediaSize("Phone"))){R=1;s='sapMOHROneCols';}this._renderResponsiveStatesColumn(r,o,R,V,i,s);};O._renderResponsiveStatesColumn=function(r,o,R,v,f,s){var g=Math.floor(v.length/R);var h=v.length%R;var j=0;var k=1;for(var i=0;i<v.length;i++){if(j==0){r.openStart("div");r.class("sapMOHRStatesCont"+k);r.class(s);r.openEnd();}if(i<f){this._renderResponsiveAttribute(r,o,v[i]);}else{this._renderResponsiveStatus(r,o,v[i]);}j++;if((j==g&&k>h)||(j==(g+1)&&k<=h)||i==v.length-1){r.close("div");j=0;k++;}}};O._renderResponsiveAttribute=function(r,o,A){r.openStart("div");r.class("sapMOHRAttr");r.openEnd();this._renderChildControl(r,o,A);r.close("div");};O._renderResponsiveStatus=function(r,o,s){r.openStart("div");r.class("sapMOHRStatus");r.openEnd();this._renderChildControl(r,o,s[0]);r.close("div");};O._renderResponsiveMarkers=function(r,o){var m=[],t=o.getTitleTextDirection(),p=sap.ui.getCore().getConfiguration().getRTL();m=o._getVisibleMarkers();r.openStart("span",o.getId()+"-markers");r.class("sapMObjStatusMarker");if((t===b.LTR&&p)||(t===b.RTL&&!p)){r.class("sapMObjStatusMarkerOpposite");}r.openEnd();for(var i=0;i<m.length;i++){this._renderChildControl(r,o,m[i]);}r.close("span");};O._renderResponsiveNumber=function(r,o){var f=o.getAggregation("_objectNumber");if(f&&f.getNumber()){f.setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,f);}};O._hasResponsiveStates=function(o){var A=o.getAttributes(),v=[];if(!(o._hasAttributes()||o._hasStatus())){o._iCountVisAttrStat=0;return false;}for(var j=0;j<A.length;j++){if(A[j].getVisible()){v.push(A[j]);}}var V=this._getVisibleStatuses(o);o._iCountVisAttrStat=v.length+V.length;return!!(v.length+V.length);};O._hasResponsiveTabs=function(o){var h=o.getHeaderContainer(),i;if(h){if(h instanceof sap.m.IconTabBar){i=h._getIconTabHeader();if(i.getVisible()){o._iCountVisTabs=i.getItems().length;return!!i.getItems().length;}}else if(h.getMetadata().getName()==="sap.m.HeaderContainer"){return!!h.getContent().length;}else if(h.getMetadata().getName()==="sap.suite.ui.commons.HeaderContainer"){return!!h.getItems().length;}}return false;};O._renderResponsiveTabs=function(r,o){var h=o.getHeaderContainer(),i;r.openStart("div");r.class("sapMOHRTabs");if(h instanceof sap.m.IconTabBar){r.class("sapMOHRTabsITB");}r.openEnd();if(h){if(h instanceof sap.m.IconTabBar){i=h._getIconTabHeader();this._renderChildControl(r,o,i);h._bHideHeader=true;}else if(h.getMetadata().getName()==="sap.m.HeaderContainer"||h.getMetadata().getName()==="sap.suite.ui.commons.HeaderContainer"){this._renderChildControl(r,o,h);}else{L.warning("The control "+h+" is not supported for aggregation \"headerContainer\"");}}r.close("div");};O._renderResponsiveTitle=function(r,o){var n;o._oTitleArrowIcon.setVisible(o.getShowTitleSelector());r.openStart("div",o.getId()+"-title");r.class("sapMOHRTitle");if(o.getTitle().length&&o.getTitleActive()){r.class("sapMOHRTitleActive");}if(o.getShowTitleSelector()){r.class("sapMOHRTitleFollowArrow");}r.openEnd();if((D.system.phone&&D.orientation.portrait)){n=50;}else{n=80;}r.openStart("div",o.getId()+"-title-arrow");r.style("display","inline-block");r.openEnd();this._renderResponsiveTitleAndArrow(r,o,n);r.close("div");if(o.getIntro()){this._renderIntro(r,o,"sapMOHRIntro","sapMOHRIntroActive");}r.close("div");};O._rerenderTitle=function(r,o,n){var i=o.getId();this._renderResponsiveTitleAndArrow(r,o,n);r.flush(q(document.getElementById(i+"-title-arrow")));};O._renderResponsiveTitleAndArrow=function(r,o,n){var s,E='',t=o.getTitleTextDirection();var m=!!o._getVisibleMarkers().length;var f=(o.getTitleLevel()===e.Auto)?e.H1:o.getTitleLevel();f=f.toLowerCase();r.openStart(f);r.openEnd();r.openStart("span");r.class("sapMOHRTitleTextContainer");if(t!=b.Inherit){r.attr("dir",t.toLowerCase());}r.openEnd();if(o.getTitle().length&&o.getTitleActive()){r.openStart("a",o.getId()+"-txt");if(o.getTitleHref()){r.attr("href",o.getTitleHref());if(o.getTitleTarget()){r.attr("target",o.getTitleTarget());r.attr("rel",d('',o.getTitleTarget()));}}r.attr("tabindex","0");r.accessibilityState({role:"link"});}else{r.openStart("span",o.getId()+"-txt");}r.class("sapMOHRTitleText");r.openEnd();r.openStart("span",o.getId()+"-titletxtwrap");r.class("sapMOHRTitleTextWrappable");r.openEnd();if(o.getTitle().length>n){s=o.getTitle().substr(0,n).trim();E='...';}else{s=o.getTitle();}if(m){var g=s.substr(s.lastIndexOf(" ")+1);var h=s.substr(0,s.lastIndexOf(" ")+1);if(g.length===1){g=s;h='';}r.text(h);r.close("span");r.text(g);r.text(E);if(o.getTitleActive()){r.close("a");}else{r.close("span");}this._renderResponsiveMarkers(r,o);r.close("span");}else{if(!E){r.text(s);}else{r.text(s+E);}if(o.getTitleActive()){r.close("span");r.close("a");r.close("span");}else{r.close("span");r.close("span");r.close("span");}}if(o.getShowTitleSelector()){r.openStart("span");r.class("sapMOHRTitleArrow");r.openEnd();this._renderChildControl(r,o,o._oTitleArrowIcon);r.close("span");}r.close(f);};O._rerenderResponsiveStates=function(r,o){var i=o.getId(),v=this._getVisibleAttribsAndStatuses(o),V=v[0].concat(v[1]),f=v[0].length,g=V.length,R=1,s='';if(g===0){return;}if(D.orientation.portrait){R=2;s='sapMOHRTwoCols';}else{if(g>=1&&g<=2){R=2;s='sapMOHRTwoCols';}if(g>=3){R=3;s='sapMOHRThreeCols';}}this._renderResponsiveStatesColumn(r,o,R,V,f,s);r.flush(q(document.getElementById(i+"-states"))[0]);};return O;},true);
