/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/m/ToggleButton","sap/ui/core/InvisibleText","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","sap/m/OverflowToolbarAssociativePopover","sap/m/OverflowToolbarAssociativePopoverControls",'sap/ui/core/ResizeHandler',"sap/ui/core/IconPool",'sap/ui/core/theming/Parameters','sap/ui/dom/units/Rem',"sap/ui/Device","./OverflowToolbarRenderer","sap/base/Log","sap/ui/dom/jquery/Focusable"],function(l,C,T,I,a,b,O,c,d,R,e,P,D,f,g,L){"use strict";var h=l.PlacementType;var B=l.ButtonType;var j=l.OverflowToolbarPriority;var k=a.extend("sap.m.OverflowToolbar",{metadata:{properties:{asyncMode:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_overflowButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/OverflowToolbar.designtime"}});k.ARIA_ROLE_DESCRIPTION="OVERFLOW_TOOLBAR_ROLE_DESCRIPTION";k.CONTENT_SIZE_TOLERANCE=1;k.prototype._callToolbarMethod=function(F,A){return a.prototype[F].apply(this,A);};k.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bNestedInAPopover=null;this._bListenForControlPropertyChanges=false;this._bListenForInvalidationEvents=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;this._aControlSizes={};this._iFrameRequest=null;this._iOverflowToolbarButtonSize=0;this._oOverflowToolbarButtonClone=null;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aPopoverOnlyControls=[];this._aAllCollections=[this._aMovableControls,this._aToolbarOnlyControls,this._aPopoverOnlyControls];this.addStyleClass("sapMOTB");this._sAriaRoleDescription=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(k.ARIA_ROLE_DESCRIPTION);};k.prototype.exit=function(){var p=this.getAggregation("_popover");if(p){p.destroy();}if(this._oOverflowToolbarButtonClone){this._oOverflowToolbarButtonClone.destroy();}if(this._iFrameRequest){window.cancelAnimationFrame(this._iFrameRequest);this._iFrameRequest=null;}};k.prototype.setAsyncMode=function(v){return this.setProperty("asyncMode",v,true);};k.prototype.onAfterRendering=function(){this._bInvalidatedAndNotRendered=false;this._getOverflowButton().$().attr("aria-haspopup","menu");if(this._bContentVisibilityChanged){this._bControlsInfoCached=false;this._bContentVisibilityChanged=false;}if(this.getAsyncMode()){this._doLayoutAsync().then(this._applyFocus.bind(this));}else{this._doLayout();this._applyFocus();}};k.prototype.onsapfocusleave=function(){this._resetChildControlFocusInfo();};k.prototype.setWidth=function(w){this.setProperty("width",w);this._bResized=true;return this;};k.prototype._doLayout=function(){var o=sap.ui.getCore(),w;if(!o.isThemeApplied()){L.debug("OverflowToolbar: theme not applied yet, skipping calculations",this);return;}this._recalculateOverflowButtonSize();w=this.$().is(":visible")?this.$().width():0;this._bListenForControlPropertyChanges=false;this._bListenForInvalidationEvents=false;this._deregisterToolbarResize();if(w>0){if(!this._isControlsInfoCached()||(this._bNeedUpdateOnControlsCachedSizes&&this._bResized)){this._cacheControlsInfo();}if(this._iPreviousToolbarWidth!==w){this._iPreviousToolbarWidth=w;this._setControlsOverflowAndShrinking(w);this.fireEvent("_controlWidthChanged");}}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;this._bListenForInvalidationEvents=true;this._bResized=false;};k.prototype._doLayoutAsync=function(){return new Promise(function(r,i){this._iFrameRequest=window.requestAnimationFrame(function(){this._doLayout();r();}.bind(this));}.bind(this));};k.prototype._applyFocus=function(){var F,$,i=this.$().lastFocusableDomRef();if(this.sFocusedChildControlId){F=sap.ui.getCore().byId(this.sFocusedChildControlId);$=F&&F.$();}if($&&$.length){$.trigger("focus");}else if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;this._bOverflowButtonWasFocused=true;}else if(this._bOverflowButtonWasFocused&&!this._getOverflowButtonNeeded()){i&&i.focus();this._bOverflowButtonWasFocused=false;}};k.prototype._preserveChildControlFocusInfo=function(){var A=sap.ui.getCore().getCurrentFocusedControlId();if(this._getControlsIds().indexOf(A)!==-1){this._bControlWasFocused=true;this.sFocusedChildControlId=A;}else if(A===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;this.sFocusedChildControlId="";}};k.prototype._resetChildControlFocusInfo=function(){this._bControlWasFocused=false;this._bOverflowButtonWasFocused=false;this.sFocusedChildControlId="";};k.prototype._registerToolbarResize=function(){if(a.isRelativeWidth(this.getWidth())){var r=this._handleResize.bind(this);this._sResizeListenerId=R.register(this,r);}};k.prototype._deregisterToolbarResize=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};k.prototype._handleResize=function(){this._bResized=true;if(this._bInvalidatedAndNotRendered){return;}if(this.getAsyncMode()){this._doLayoutAsync();}else{this._doLayout();}};k.prototype._cacheControlsInfo=function(){var v,H,i=parseInt(this.$().css("padding-right"))||0,r=parseInt(this.$().css("padding-left"))||0;this._iOldContentSize=this._iContentSize;this._iContentSize=0;this._bNeedUpdateOnControlsCachedSizes=false;this.getContent().forEach(this._updateControlsCachedSizes,this);if(f.system.phone){this._iContentSize-=1;}if(this._aPopoverOnlyControls.length){v=this._aPopoverOnlyControls.filter(function(o){return o.getVisible();});H=(v.length>0);if(H){this._iContentSize+=this._getOverflowButtonSize();}}this._bControlsInfoCached=true;if(this._iOldContentSize!==this._iContentSize){this.fireEvent("_contentSizeChange",{contentSize:this._iContentSize+i+r+1});}};k.prototype._updateControlsCachedSizes=function(o){var p,i,w;p=this._getControlPriority(o);i=this._calculateControlSize(o);this._aControlSizes[o.getId()]=i;w=a.getOrigWidth(o.getId());if(w&&a.isRelativeWidth(w)){this._bNeedUpdateOnControlsCachedSizes=true;}if(p!==j.AlwaysOverflow){this._iContentSize+=i;}};k.prototype._calculateControlSize=function(o){return this._getOptimalControlWidth(o,this._aControlSizes[o.getId()]);};k.prototype._isControlsInfoCached=function(){return this._bControlsInfoCached;};k.prototype._flushButtonsToPopover=function(){this._aButtonsToMoveToPopover.forEach(this._moveButtonToPopover,this);};k.prototype._invalidateIfHashChanged=function(H){if(typeof H==="undefined"||this._getPopover()._getContentIdsHash()!==H){this._preserveChildControlFocusInfo();this.invalidate();}};k.prototype._addOverflowButton=function(){if(!this._getOverflowButtonNeeded()){this._iCurrentContentSize+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true);}};k.prototype._aggregateMovableControls=function(){var G={},A=[],i,p,s,m,n;this._aMovableControls.forEach(function(o){i=k._getControlGroup(o);p=k._oPriorityOrder;if(i){s=this._getControlPriority(o);m=this._getControlIndex(o);G[i]=G[i]||[];n=G[i];n.unshift(o);if(!n._priority||p[n._priority]<p[s]){n._priority=s;}if(!n._index||n._index<m){n._index=m;}}else{A.push(o);}},this);Object.keys(G).forEach(function(o){A.push(G[o]);});return A;};k.prototype._extractControlsToMoveToOverflow=function(A,t){var i,m;for(i=0;i<A.length;i++){m=A[i];if(m.length){m.forEach(this._addToPopoverArrAndUpdateContentSize,this);}else{this._addToPopoverArrAndUpdateContentSize(m);}if(this._getControlPriority(m)!==j.Disappear){this._addOverflowButton();}if(this._iCurrentContentSize<=t){break;}}};k.prototype._addToPopoverArrAndUpdateContentSize=function(o){this._aButtonsToMoveToPopover.unshift(o);this._iCurrentContentSize-=this._aControlSizes[o.getId()];};k.prototype._sortByPriorityAndIndex=function(v,i){var p=k._oPriorityOrder,s=this._getControlPriority(v),m=this._getControlPriority(i),n=p[s]-p[m];if(n!==0){return n;}else{return this._getControlIndex(i)-this._getControlIndex(v);}};k.prototype._setControlsOverflowAndShrinking=function(t){var i;this._iCurrentContentSize=this._iContentSize;this._aButtonsToMoveToPopover=[];if(this._bSkipOptimization){this._bSkipOptimization=false;}else{i=this._getPopover()._getContentIdsHash();}this._resetToolbar();this._collectPopoverOnlyControls();this._markControlsWithShrinkableLayoutData();if(this._iCurrentContentSize<=(t+k.CONTENT_SIZE_TOLERANCE)){this._flushButtonsToPopover();this._invalidateIfHashChanged(i);return;}this._moveControlsToPopover(t);this._flushButtonsToPopover();if(this._iCurrentContentSize>t){this._checkContents();}this._invalidateIfHashChanged(i);};k.prototype._markControlsWithShrinkableLayoutData=function(){this.getContent().forEach(this._markControlWithShrinkableLayoutData,this);};k.prototype._collectPopoverOnlyControls=function(){var p=this._aPopoverOnlyControls.length,i,o;if(p){for(i=p-1;i>=0;i--){o=this._aPopoverOnlyControls[i];if(o.getVisible()){this._aButtonsToMoveToPopover.unshift(o);}}if(this._aButtonsToMoveToPopover.length>0){this._setOverflowButtonNeeded(true);}}};k.prototype._moveControlsToPopover=function(t){var A=[];if(this._aMovableControls.length){A=this._aggregateMovableControls();A.sort(this._sortByPriorityAndIndex.bind(this));this._extractControlsToMoveToOverflow(A,t);}};k.prototype._markControlWithShrinkableLayoutData=function(o){var w,i;o.removeStyleClass(a.shrinkClass);w=a.getOrigWidth(o.getId());if(!a.isRelativeWidth(w)){return;}i=o.getLayoutData();if(i&&i.isA("sap.m.ToolbarLayoutData")&&i.getShrinkable()){o.addStyleClass(a.shrinkClass);}};k.prototype._resetToolbar=function(){this._getPopover().close();this._getPopover()._getAllContent().forEach(this._restoreButtonInToolbar,this);this._setOverflowButtonNeeded(false);this.getContent().forEach(this._removeShrinkingClass);};k.prototype._removeShrinkingClass=function(o){o.removeStyleClass(a.shrinkClass);};k.prototype._moveButtonToPopover=function(o){this._getPopover().addAssociatedContent(o);};k.prototype._restoreButtonInToolbar=function(v){if(typeof v==="object"){v=v.getId();}this._getPopover().removeAssociatedContent(v);};k.prototype._resetAndInvalidateToolbar=function(H){if(this._bIsBeingDestroyed){return;}this._resetToolbar();this._bControlsInfoCached=false;this._bNestedInAPopover=null;this._iPreviousToolbarWidth=null;if(H){this._bSkipOptimization=true;}if(this.$().length){this._preserveChildControlFocusInfo();this.invalidate();}};k.prototype.invalidate=function(){this._bInvalidatedAndNotRendered=true;C.prototype.invalidate.apply(this,arguments);};k.prototype._getVisibleContent=function(){var t=this.getContent(),p=this._getPopover()._getAllContent();return t.filter(function(o){return p.indexOf(o)===-1;});};k.prototype._getVisibleAndNonOverflowContent=function(){return this._getVisibleContent().filter(function(o){return o.getVisible();});};k.prototype._getToggleButton=function(i){return new T({id:this.getId()+i,icon:e.getIconURI("overflow"),press:this._overflowButtonPressed.bind(this),ariaLabelledBy:I.getStaticId("sap.ui.core","Icon.overflow"),type:B.Transparent});};k.prototype._getOverflowButton=function(){var o;if(!this.getAggregation("_overflowButton")){o=this._getToggleButton("-overflowButton");this.setAggregation("_overflowButton",o,true);}return this.getAggregation("_overflowButton");};k.prototype._getOverflowButtonClone=function(){if(!this._oOverflowToolbarButtonClone){this._oOverflowToolbarButtonClone=this._getToggleButton("-overflowButtonClone").addStyleClass("sapMTBHiddenElement");}return this._oOverflowToolbarButtonClone;};k.prototype._overflowButtonPressed=function(E){var p=this._getPopover(),s=this._getBestPopoverPlacement();if(p.getPlacement()!==s){p.setPlacement(s);}if(p.isOpen()){p.close();}else{p.openBy(E.getSource());}};k.prototype._getPopover=function(){var p;if(!this.getAggregation("_popover")){p=new c(this.getId()+"-popover",{showHeader:false,showArrow:false,modal:false,horizontalScrolling:f.system.phone?false:true,contentWidth:f.system.phone?"100%":"auto",offsetY:this._detireminePopoverVerticalOffset(),ariaLabelledBy:I.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")});p._adaptPositionParams=function(){c.prototype._adaptPositionParams.call(this);this._myPositions=["end top","begin center","end bottom","end center"];this._atPositions=["end bottom","end center","end top","begin center"];};if(f.system.phone){p.attachBeforeOpen(this._shiftPopupShadow,this);}p.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",p,true);}return this.getAggregation("_popover");};k.prototype._shiftPopupShadow=function(){var p=this._getPopover(),s=p.getCurrentPosition();if(s===h.Bottom){p.addStyleClass("sapMOTAPopoverNoShadowTop");p.removeStyleClass("sapMOTAPopoverNoShadowBottom");}else if(s===h.Top){p.addStyleClass("sapMOTAPopoverNoShadowBottom");p.removeStyleClass("sapMOTAPopoverNoShadowTop");}};k.prototype._popOverClosedHandler=function(){var w=f.os.windows_phone||f.browser.edge&&f.browser.mobile;this._getOverflowButton().setPressed(false);this._getOverflowButton().$().trigger("focus");if(this._isNestedInsideAPopup()||w){return;}this._getOverflowButton().setEnabled(false);setTimeout(function(){this._getOverflowButton().setEnabled(true);setTimeout(function(){this._getOverflowButton().$().trigger("focus");}.bind(this),0);}.bind(this),0);};k.prototype._isNestedInsideAPopup=function(){var s;if(this._bNestedInAPopover!==null){return this._bNestedInAPopover;}s=function(o){if(!o){return false;}if(o.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return s(o.getParent());};this._bNestedInAPopover=s(this);return this._bNestedInAPopover;};k.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded;};k.prototype._setOverflowButtonNeeded=function(v){if(this._bOverflowButtonNeeded!==v){this._bOverflowButtonNeeded=v;}return this;};k.prototype._updateContentInfoInControlsCollections=function(){this.getContent().forEach(function(o){if(o){this._removeContentFromControlsCollections(o);this._moveControlInSuitableCollection(o,this._getControlPriority(o));}},this);};k.prototype._moveControlInSuitableCollection=function(o,p){var i=p!==j.NeverOverflow,A=p===j.AlwaysOverflow;if(d.supportsControl(o)&&A){this._aPopoverOnlyControls.push(o);}else{if(d.supportsControl(o)&&i&&o.getVisible()){this._aMovableControls.push(o);}else{this._aToolbarOnlyControls.push(o);}}};k.prototype._removeContentFromControlsCollections=function(o){var i,m,n;for(i=0;i<this._aAllCollections.length;i++){m=this._aAllCollections[i];n=m.indexOf(o);if(n!==-1){m.splice(n,1);}}};k.prototype._clearAllControlsCollections=function(){this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aPopoverOnlyControls=[];this._aAllCollections=[this._aMovableControls,this._aToolbarOnlyControls,this._aPopoverOnlyControls];};k.prototype.onLayoutDataChange=function(E){this._resetAndInvalidateToolbar(true);E&&this._updateContentInfoInControlsCollections();};k.prototype.addContent=function(o){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o));}this._informNewFlexibleContentAdded(o);return this._callToolbarMethod("addContent",arguments);};k.prototype.insertContent=function(o,i){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o));}this._informNewFlexibleContentAdded(o);return this._callToolbarMethod("insertContent",arguments);};k.prototype.removeContent=function(){var v=this._callToolbarMethod("removeContent",arguments);if(v){this._getPopover().removeAssociatedContent(v.getId());}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(v);this._removeContentFromControlsCollections(v);return v;};k.prototype.removeAllContent=function(){var i=this._callToolbarMethod("removeAllContent",arguments);i.forEach(this._deregisterControlListener,this);i.forEach(this._removeContentFromControlsCollections,this);this._resetAndInvalidateToolbar(false);this._clearAllControlsCollections();return i;};k.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);setTimeout(function(){this._resetAndInvalidateToolbar(false);}.bind(this),0);this._clearAllControlsCollections();return this._callToolbarMethod("destroyContent",arguments);};k.prototype._informNewFlexibleContentAdded=function(o){if(o&&o.isA("sap.m.IOverflowToolbarFlexibleContent")){this.fireEvent("_contentSizeChange",{contentSize:null});}};k.prototype._registerControlListener=function(o){var i;if(o){o.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);if(o.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1){i=o.getOverflowToolbarConfig().invalidationEvents;if(i&&Array.isArray(i)){i.forEach(function(E){o.attachEvent(E,this._onInvalidationEventFired,this);},this);}}}};k.prototype._deregisterControlListener=function(o){var i;if(o){o.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);if(o.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1){i=o.getOverflowToolbarConfig().invalidationEvents;if(i&&Array.isArray(i)){i.forEach(function(E){o.detachEvent(E,this._onInvalidationEventFired,this);},this);}}}};k.prototype._onContentPropertyChangedOverflowToolbar=function(E){var s=E.getSource(),o,p;this._updateContentInfoInControlsCollections();if(!this._bListenForControlPropertyChanges){return;}o=d.getControlConfig(s);p=E.getParameter("name");if(p!=='visible'&&!s.getVisible()){return;}if(typeof o!=="undefined"&&o.noInvalidationProps.indexOf(p)!==-1){return;}if(p==="visible"){this._bContentVisibilityChanged=true;}if(s.isA("sap.m.IOverflowToolbarFlexibleContent")&&s.getVisible()){this.fireEvent("_contentSizeChange",{contentSize:null});}this._resetAndInvalidateToolbar(true);};k.prototype._onInvalidationEventFired=function(E){var s=E.getSource();if(!this._bListenForInvalidationEvents){return;}if(s.isA("sap.m.IOverflowToolbarFlexibleContent")){this.fireEvent("_contentSizeChange",{contentSize:null});}this._resetAndInvalidateToolbar(true);};k.prototype._getOverflowButtonSize=function(){return this._iOverflowToolbarButtonSize;};k.prototype._getBestPopoverPlacement=function(){var H=this.getHTMLTag();if(H==="Footer"){return h.Top;}else if(H==="Header"){return h.Bottom;}return h.Vertical;};k.prototype._getControlsIds=function(){return this.getContent().map(function(i){return i.getId();});};k.prototype._getControlIndex=function(v){return v.length?v._index:this.indexOfContent(v);};k.prototype._getOptimalControlWidth=function(o,i){var m,n=o.getLayoutData(),s=n&&n.isA("sap.m.ToolbarLayoutData")?n.getShrinkable():false,M=s?this._getMinWidthOfShrinkableControl(o):0,v=o.getVisible(),S;if(o.isA("sap.m.ToolbarSpacer")){S=parseInt(o.$().css('width'));M=(o.getWidth()&&S)?S:0;m=k._getOptimalWidthOfShrinkableControl(o,M);}else if(s&&M>0&&v){m=k._getOptimalWidthOfShrinkableControl(o,M);}else{m=v?k._getControlWidth(o):0;}if(m===null){m=typeof i!=="undefined"?i:0;}return m;};k.prototype._getMinWidthOfShrinkableControl=function(o){var m=o.$().css("min-width"),M=parseInt(m),r=a.isRelativeWidth(m);if(r){return(M*this.$().width())/100;}else{return M;}};k.prototype._getControlPriority=function(v){var i,o,p,G;if(v.length){return v._priority;}i=v.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1;G=i&&v.getOverflowToolbarConfig().getCustomImportance;if(i&&typeof G==="function"){return G();}o=v.getLayoutData&&v.getLayoutData();if(o&&o instanceof O){if(o.getMoveToOverflow()===false){return j.NeverOverflow;}if(o.getStayInOverflow()===true){return j.AlwaysOverflow;}p=o.getPriority();if(p===j.Never){return j.NeverOverflow;}if(p===j.Always){return j.AlwaysOverflow;}return p;}return j.High;};k._getControlMargins=function(o){return o.$().outerWidth(true)-o.$().outerWidth();};k._getOptimalWidthOfShrinkableControl=function(o,m){return m+k._getControlMargins(o);};k._getControlWidth=function(o){var i=o&&o.getDomRef();if(i){return Math.round(i.getBoundingClientRect().width+k._getControlMargins(o));}return null;};k._getControlGroup=function(o){var i=o.getLayoutData();if(i instanceof O){return i.getGroup();}};k._oPriorityOrder=(function(){var p={};p[j.Disappear]=1;p[j.Low]=2;p["Medium"]=3;p[j.High]=4;return p;})();k.prototype._detireminePopoverVerticalOffset=function(){return this.$().parents().hasClass('sapUiSizeCompact')?2:3;};k.prototype._recalculateOverflowButtonSize=function(){var o=this._getOverflowButtonClone().$(),i;if(!this._getOverflowButtonSize()&&o.width()>0){i=o.outerWidth(true);this._iOverflowToolbarButtonSize=i?i:0;}};k.prototype.onThemeChanged=function(){this._resetAndInvalidateToolbar();this._iOverflowToolbarButtonSize=0;this._recalculateOverflowButtonSize();for(var i in this._aControlSizes){if(this._aControlSizes.hasOwnProperty(i)){this._aControlSizes[i]=0;}}};k.prototype.closeOverflow=function(){this._getPopover().close();};return k;});
