/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./SliderUtilities',"sap/ui/core/InvisibleText"],function(S,I){"use strict";var a={apiVersion:2};a.CSS_CLASS="sapMSlider";a.render=function(r,s){var e=s.getEnabled(),t=s.getTooltip_AsString(),C=a.CSS_CLASS,b=s.getAriaLabelledBy().reduce(function(A,i){return A+" "+i;},"");r.openStart("div",s);this.addClass(r,s);if(!e){r.class(C+"Disabled");}r.style("width",s.getWidth());if(t&&s.getShowHandleTooltip()){r.attr("title",s._formatValueByCustomElement(t));}r.openEnd();r.openStart('div',s.getId()+"-inner");this.addInnerClass(r,s);if(!e){r.class(C+"InnerDisabled");}r.openEnd();if(s.getProgress()){this.renderProgressIndicator(r,s,b);}this.renderHandles(r,s,b);r.close("div");if(s.getEnableTickmarks()){this.renderTickmarks(r,s);}this.renderLabels(r,s);if(s.getName()){this.renderInput(r,s);}r.close("div");};a.renderProgressIndicator=function(r,s){r.openStart("div",s.getId()+"-progress");this.addProgressIndicatorClass(r,s);r.style("width",s._sProgressValue);r.attr("aria-hidden","true");r.openEnd().close("div");};a.renderHandles=function(r,s,f){this.renderHandle(r,s,{id:s.getId()+"-handle",forwardedLabels:f});};a.renderHandle=function(r,s,o){var e=s.getEnabled();r.openStart("span",o&&o.id);if(s.getShowHandleTooltip()&&!s.getShowAdvancedTooltip()){this.writeHandleTooltip(r,s);}if(s.getInputsAsTooltips()){r.attr("aria-describedby",I.getStaticId("sap.m","SLIDER_INPUT_TOOLTIP"));e&&r.attr("aria-keyshortcuts","F2");}this.addHandleClass(r,s);r.style(sap.ui.getCore().getConfiguration().getRTL()?"right":"left",s._sProgressValue);this.writeAccessibilityState(r,s,o);if(e){r.attr("tabindex","0");}r.openEnd().close("span");};a.writeHandleTooltip=function(r,s){r.attr("title",s._formatValueByCustomElement(s.toFixed(s.getValue())));};a.renderInput=function(r,s){r.voidStart("input",s.getId()+"-input").attr("type","text");r.class(a.CSS_CLASS+"Input");if(!s.getEnabled()){r.attr("disabled");}r.attr("name",s.getName());r.attr("value",s._formatValueByCustomElement(s.toFixed(s.getValue())));r.voidEnd();};a.writeAccessibilityState=function(r,s,o){var f=s.getValue(),n=s._isElementsFormatterNotNumerical(f),b=s._formatValueByCustomElement(f),v;if(s._getUsedScale()&&!n){v=b;}else{v=s.toFixed(f);}r.accessibilityState(s,{role:"slider",orientation:"horizontal",valuemin:s.toFixed(s.getMin()),valuemax:s.toFixed(s.getMax()),valuenow:v,labelledby:{value:(o.forwardedLabels+" "+s.getAggregation("_handlesLabels")[0].getId()).trim()}});if(n){r.accessibilityState(s,{valuetext:b});}};a.renderTickmarks=function(r,s){var i,t,T,l,f,b,c,o=s._getUsedScale();if(!s.getEnableTickmarks()||!o){return;}b=Math.abs(s.getMin()-s.getMax());c=s.getStep();l=o.getTickmarksBetweenLabels();t=o.calcNumberOfTickmarks(b,c,S.CONSTANTS.TICKMARKS.MAX_POSSIBLE);T=s._getPercentOfValue(this._calcTickmarksDistance(t,s.getMin(),s.getMax(),c));r.openStart("ul").class(a.CSS_CLASS+"Tickmarks").openEnd();this.renderTickmarksLabel(r,s,s.getMin());r.openStart("li").class(a.CSS_CLASS+"Tick").style("width",T+"%;").openEnd().close("li");for(i=1;i<t-1;i++){if(l&&(i%l===0)){f=i*T;this.renderTickmarksLabel(r,s,s._getValueOfPercent(f));}r.openStart("li").class(a.CSS_CLASS+"Tick").style("width",T+"%;").openEnd().close("li");}this.renderTickmarksLabel(r,s,s.getMax());r.openStart("li").class(a.CSS_CLASS+"Tick").style("width","0").openEnd().close("li");r.close("ul");};a.renderTickmarksLabel=function(r,s,v){var o=s._getPercentOfValue(v);var l=sap.ui.getCore().getConfiguration().getRTL()?"right":"left";var V;v=s.toFixed(v,s.getDecimalPrecisionOfNumber(s.getStep()));V=s._formatValueByCustomElement(v,'scale');r.openStart("li").class(a.CSS_CLASS+"TickLabel").style(l,(o+"%")).openEnd();r.openStart("div").class(a.CSS_CLASS+"Label").openEnd().text(V).close("div");r.close("li");};a._calcTickmarksDistance=function(t,s,e,f){var b=Math.abs(s-e),m=Math.floor(b/f),i=Math.ceil(m/t);return s+(i*f);};a.addClass=function(r,s){r.class(a.CSS_CLASS);};a.addInnerClass=function(r,s){r.class(a.CSS_CLASS+"Inner");};a.addProgressIndicatorClass=function(r,s){r.class(a.CSS_CLASS+"Progress");};a.addHandleClass=function(r,s){r.class(a.CSS_CLASS+"Handle");};a.renderLabels=function(r,s){s.getAggregation("_handlesLabels").forEach(r.renderControl,r);};return a;},true);
