/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/m/Button','sap/m/List','sap/m/StandardListItem','sap/m/ResponsivePopover','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/delegate/ScrollEnablement','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','./TokenizerRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/EnabledPropagator","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(l,B,L,S,R,C,c,d,D,I,e,T,f,K,g,E,q){"use strict";var h=l.TokenizerRenderMode,P=l.PlacementType,j=l.ListMode;var k=c.extend("sap.m.Tokenizer",{metadata:{library:"sap.m",properties:{editable:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},renderMode:{type:"string",group:"Misc",defaultValue:h.Loose},hiddenTokensCount:{type:"int",group:"Misc",defaultValue:0,visibility:"hidden"}},defaultAggregation:"tokens",aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},_tokensInfo:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenDelete:{parameters:{tokens:{type:"sap.m.Token[]"},keyCode:{type:"number"}}}}}});var r=C.getLibraryResourceBundle("sap.m");E.apply(k.prototype,[true]);k.prototype.init=function(){this.allowTextSelection(false);this._oTokensWidthMap={};this._oIndicator=null;this._oScroller=new d(this,this.getId()+"-scrollContainer",{horizontal:true,vertical:false,nonTouchScrolling:true});if(C.getConfiguration().getAccessibility()){var a=new I({text:r.getText("TOKENIZER_ARIA_CONTAIN_TOKEN")});this.setAggregation("_tokensInfo",a);}this.attachEvent("delete",function(o){var t=o.getSource();var s=this.getSelectedTokens();this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Removed,token:t,tokens:s.length?s:[t],addedTokens:[],removedTokens:s.length?s:[t]});this.fireTokenUpdate({type:sap.m.Tokenizer.TokenChangeType.Removed,addedTokens:[],removedTokens:s.length?s:[t]});this.fireEvent("tokenDelete",{tokens:[t]});},this);};k.prototype._handleNMoreIndicatorPress=function(){this._togglePopup(this.getTokensPopup());};k.prototype._getTokensList=function(){if(!this._oTokensList){this._oTokensList=new L({width:"auto",mode:j.Delete}).attachDelete(this._handleListItemDelete,this);}return this._oTokensList;};k.prototype._setPopoverMode=function(m){var s={},p=this.getTokensPopup();switch(m){case j.Delete:s={showArrow:false,placement:P.VerticalPreferredBottom};break;default:s={showArrow:true,placement:P.Auto};break;}p.setShowArrow(s.showArrow);p.setPlacement(s.placement);this._getTokensList().setMode(m);};k.prototype._fillTokensList=function(o,F){o.destroyItems();F=F?F:function(){return true;};this.getTokens().filter(F).forEach(function(t){o.addItem(this._mapTokenToListItem(t));},this);};k.prototype._handleListItemDelete=function(o){var a=o.getParameter("listItem");var s=a&&a.data("tokenId");var t;t=this.getTokens().filter(function(b){return(b.getId()===s)&&b.getEditable();})[0];if(t){this.fireTokenUpdate({addedTokens:[],removedTokens:[t],type:k.TokenUpdateType.Removed});this.fireTokenDelete({tokens:[t]});a.destroy();this._adjustTokensVisibility();}};k.prototype.getTokensPopup=function(){if(this._oPopup){return this._oPopup;}this._oPopup=new R({showArrow:false,showHeader:false,placement:P.Auto,offsetX:0,offsetY:3,horizontalScrolling:false,content:this._getTokensList()}).attachBeforeOpen(function(){var w=this.getEditable()?120:0,p=this._oPopup;if(p.getContent&&!p.getContent().length){p.addContent(this._getTokensList());}this._fillTokensList(this._getTokensList());w+=Object.keys(this._oTokensWidthMap).map(function(s){return this._oTokensWidthMap[s];},this).sort(function(a,b){return a-b;}).pop()||0;p.setContentWidth(w+"px");},this);this.addDependent(this._oPopup);if(D.system.phone){this._oPopup.setEndButton(new B({text:r.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),press:function(){this._oPopup.close();}.bind(this)}));}return this._oPopup;};k.prototype._togglePopup=function(p){var o,a=this.getDomRef(),b=p.isOpen(),i=this.getEditable();this._setPopoverMode(i?j.Delete:j.None);if(b){p.close();}else{o=i||this.hasOneTruncatedToken()?a:this._oIndicator[0];o=o&&o.className.indexOf("sapUiHidden")===-1?o:a;p.openBy(o||a);}};k.prototype._mapTokenToListItem=function(t){if(!t){return null;}var o=new S({selected:true}).data("tokenId",t.getId());o.setTitle(t.getText());return o;};k.prototype._getPixelWidth=function(){var m=this.getMaxWidth(),t,o=this.getDomRef(),p;if(!o){return;}p=parseInt(this.$().css("padding-left"));if(m.indexOf("px")===-1){t=o.clientWidth;}else{t=parseInt(this.getMaxWidth());}return t-p;};k.prototype._adjustTokensVisibility=function(){if(!this.getDomRef()){return;}var t=this._getPixelWidth(),a=this._getVisibleTokens().reverse(),i=a.length,b,F,m,n=-1;a.some(function(o,p){t=t-this._oTokensWidthMap[o.getId()];if(t<0){n=p;return true;}else{F=t;}},this);if(i===1&&n!==-1){this.setFirstTokenTruncated(true);return;}else if(i===1&&a[0].getTruncated()){this.setFirstTokenTruncated(false);}if(n>-1){for(m=0;m<i;m++){if(m>=n){a[m].addStyleClass("sapMHiddenToken");}else{a[m].removeStyleClass("sapMHiddenToken");}}this._handleNMoreIndicator(i-n);b=this._oIndicator.width();if(b>=F){n=n-1;this._handleNMoreIndicator(i-n);a[n].addStyleClass("sapMHiddenToken");}this._setHiddenTokensCount(i-n);}else{this._setHiddenTokensCount(0);this._showAllTokens();}};k.prototype.setFirstTokenTruncated=function(v){var t=this.getTokens()[0];t&&t.setTruncated(v);if(v){this.addStyleClass("sapMTokenizerOneLongToken");}else{this.removeStyleClass("sapMTokenizerOneLongToken");this.scrollToEnd();}return this;};k.prototype.hasOneTruncatedToken=function(){return this.getTokens().length===1&&this.getTokens()[0].getTruncated();};k.prototype._handleNMoreIndicator=function(H){if(!this.getDomRef()){return this;}if(H){var s="MULTIINPUT_SHOW_MORE_TOKENS";if(H===this._getVisibleTokens().length){if(H===1){s="TOKENIZER_SHOW_ALL_ITEM";}else{s="TOKENIZER_SHOW_ALL_ITEMS";}}this._oIndicator.html(r.getText(s,H));}return this;};k.prototype._getVisibleTokens=function(){return this.getTokens().filter(function(t){return t.getVisible();});};k.prototype._showAllTokens=function(){this._getVisibleTokens().forEach(function(t){t.removeStyleClass("sapMHiddenToken");});};k.prototype.getScrollDelegate=function(){return this._oScroller;};k.prototype.scrollToEnd=function(){var a=this.getDomRef(),s;if(!this.getDomRef()){return;}s=this.$().find(".sapMTokenizerScrollContainer")[0];if(D.browser.msie){setTimeout(function(){a.scrollLeft=s.scrollWidth;});}else{a.scrollLeft=s.scrollWidth;}};k.prototype._registerResizeHandler=function(){if(!this._sResizeHandlerId){this._sResizeHandlerId=e.register(this.getDomRef(),this._handleResize.bind(this));}};k.prototype._handleResize=function(){this._useCollapsedMode(this.getRenderMode());this.scrollToEnd();};k.prototype.setPixelWidth=function(n){if(typeof n!=="number"){g.warning("Tokenizer.setPixelWidth called with invalid parameter. Expected parameter of type number.");return;}this.setWidth(n+"px");if(this._oScroller){this._oScroller.refresh();}};k.prototype.scrollToStart=function(){var a=this.getDomRef();if(!a){return;}a.scrollLeft=0;};k.prototype.getScrollWidth=function(){if(!this.getDomRef()){return 0;}return this.$().children(".sapMTokenizerScrollContainer")[0].scrollWidth;};k.prototype.onBeforeRendering=function(){var t=this.getTokens();if(t.length===0){this.setFirstTokenTruncated(false);}t.forEach(function(o,i){o.setProperty("editableParent",this.getEditable()&&this.getEnabled(),true);o.setProperty("posinset",i+1,true);o.setProperty("setsize",t.length,true);},this);this._setTokensAria();};k.prototype.onAfterRendering=function(){var s=this.getRenderMode();this._oIndicator=this.$().find(".sapMTokenizerIndicator");if(C.isThemeApplied()){this._storeTokensSizes();}this._useCollapsedMode(s);this._registerResizeHandler();if(s===h.Loose){this.scrollToEnd();}};k.prototype.onThemeChanged=function(){this._storeTokensSizes();this._useCollapsedMode(this.getRenderMode());};k.prototype._storeTokensSizes=function(){var t=this.getTokens();t.forEach(function(o){if(o.getDomRef()&&!o.$().hasClass("sapMHiddenToken")&&!o.getTruncated()){this._oTokensWidthMap[o.getId()]=o.$().outerWidth(true);}},this);};k.prototype._useCollapsedMode=function(s){var t=this._getVisibleTokens();if(!t.length){return;}if(s===h.Narrow){this._adjustTokensVisibility();}else{this._setHiddenTokensCount(0);this._showAllTokens();}};k.prototype.onsapfocusleave=function(o){if(document.activeElement===this.getDomRef()||!this._checkFocus()){this._changeAllTokensSelection(false);this._oSelectionOrigin=null;}};k.prototype.onsapbackspace=function(o){var s=this.getSelectedTokens();var F=this.getTokens().filter(function(t){return t.getFocusDomRef()===document.activeElement;})[0];var a=s.length?s:[F];o.preventDefault();return this.fireTokenDelete({tokens:a,keyCode:o.which});};k.prototype.onsapdelete=k.prototype.onsapbackspace;k.prototype.onkeydown=function(o){var s;if(!this.getEnabled()){return;}if(o.which===K.TAB){this._changeAllTokensSelection(false);}if((o.ctrlKey||o.metaKey)&&o.which===K.A){s=this.getSelectedTokens().length<this._getVisibleTokens().length;if(this._getVisibleTokens().length>0){this.focus();this._changeAllTokensSelection(s);o.preventDefault();o.stopPropagation();}}if((o.ctrlKey||o.metaKey)&&(o.which===K.C||o.which===K.INSERT)){this._copy();}if(((o.ctrlKey||o.metaKey)&&o.which===K.X)||(o.shiftKey&&o.which===K.DELETE)){if(this.getEditable()){this._cut();}else{this._copy();}}};k.prototype.onsappreviousmodifiers=function(o){this.onsapprevious(o);};k.prototype.onsapnextmodifiers=function(o){this.onsapnext(o);};k.prototype.onsaphomemodifiers=function(o){this._selectRange(false);};k.prototype.onsapendmodifiers=function(o){this._selectRange(true);};k.prototype._selectRange=function(F){var o={},t=this._getVisibleTokens(),a=q(document.activeElement).control()[0],b=t.indexOf(a);if(!a||!a.isA("sap.m.Token")){return;}if(F){o.start=b;o.end=t.length-1;}else{o.start=0;o.end=b;}if(o.start<o.end){for(var i=o.start;i<=o.end;i++){t[i].setSelected(true);}}};k.prototype._copy=function(){this._fillClipboard("copy");};k.prototype._fillClipboard=function(s){var a=this.getSelectedTokens();var t=a.map(function(o){return o.getText();}).join("\r\n");var b=function(o){if(o.clipboardData){o.clipboardData.setData('text/plain',t);}else{o.originalEvent.clipboardData.setData('text/plain',t);}o.preventDefault();};if(D.browser.msie&&window.clipboardData){window.clipboardData.setData("text",t);}else{document.addEventListener(s,b);document.execCommand(s);document.removeEventListener(s,b);}};k.prototype._cut=function(){var s=this.getSelectedTokens();this._fillClipboard("cut");this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Removed,token:s,tokens:s,addedTokens:[],removedTokens:s});this.fireTokenUpdate({type:sap.m.Tokenizer.TokenChangeType.Removed,addedTokens:[],removedTokens:s});this.fireTokenDelete({tokens:s});};k.prototype._ensureTokenVisible=function(t){if(!t||!t.getDomRef()||!this.getDomRef()){return;}var i=this.$().offset().left,a=this.$().width(),b=t.$().offset().left,m=t.$().width();if(this._getVisibleTokens().indexOf(t)===0){this.$().scrollLeft(0);return;}if(b<i){this.$().scrollLeft(this.$().scrollLeft()-i+b);}if(b-i+m>a){this.$().scrollLeft(this.$().scrollLeft()+(b-i+m-a));}};k.prototype.ontap=function(o){var s=o.shiftKey,b=(o.ctrlKey||o.metaKey),t=o.getMark("tokenTap"),a=o.getMark("tokenDeletePress"),m=this._getVisibleTokens(),n=m[m.length-1],F,p,u,M,v;if(a||!t||(!s&&b)){this._oSelectionOrigin=null;return;}if(D.browser.msie&&t===n){this.scrollToEnd();}if(!s){this._oSelectionOrigin=t;this._changeAllTokensSelection(false,t,true);}F=t;if(this._oSelectionOrigin){F=this._oSelectionOrigin;}else{this._oSelectionOrigin=F;}if(t&&this.hasOneTruncatedToken()){this._handleNMoreIndicatorPress();return;}p=this.indexOfToken(F);u=this.indexOfToken(t);M=Math.min(p,u);v=Math.max(p,u);m.forEach(function(w,i){if(i>=M&&i<=v){w.setSelected(true);}else if(!b){w.setSelected(false);}});};k.prototype.onsapprevious=function(o){var t=this._getVisibleTokens(),i=t.length;if(i===0){return;}var F=q(document.activeElement).control()[0];var a=F?t.indexOf(F):-1;if(a===0){o.setMarked("forwardFocusToParent");return;}var b,m;if(a>0){b=t[a-1];b.focus();}else{b=t[t.length-1];b.focus({preventScroll:true});}if(o.shiftKey){m=t[a];b.setSelected(true);m.setSelected(true);}o.setMarked();o.preventDefault();};k.prototype.onsapnext=function(o){var t=this._getVisibleTokens(),i=t.length;if(i===0){return;}var F=q(document.activeElement).control()[0];var a=F?t.indexOf(F):-1;if(a<i-1){var n=t[a+1],b=t[a];n.focus();if(o.shiftKey){n.setSelected(true);b.setSelected(true);}this._ensureTokenVisible(n);}else{o.setMarked("forwardFocusToParent");return;}o.setMarked();o.preventDefault();};k.prototype.addValidator=function(v){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};k.prototype.removeValidator=function(v){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};k.prototype.removeAllValidators=function(){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};k.prototype.addValidateToken=function(p){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};k.prototype._parseString=function(s){return s.split(/\r\n|\r|\n/g);};k.prototype._checkFocus=function(){return this.getDomRef()&&f(this.getDomRef(),document.activeElement);};k.prototype.selectAllTokens=function(s){if(s===undefined){s=true;}this._changeAllTokensSelection(s);return this;};k.prototype._changeAllTokensSelection=function(s,t,b){var a=this._getVisibleTokens();a.filter(function(o){return o!==t;}).forEach(function(o){o.setSelected(s);});if(!b){this._doSelect();}return this;};k.prototype.getSelectedTokens=function(){return this._getVisibleTokens().filter(function(t){return t.getSelected();});};k.prototype.onsaphome=function(o){var a=this.getTokens().filter(function(t){return t.getDomRef()&&!t.getDomRef().classList.contains("sapMHiddenToken");});a.length&&a[0].focus();this.scrollToStart();o.preventDefault();};k.prototype.onsapend=function(o){var t=this._getVisibleTokens(),a=t[t.length-1];if(a.getDomRef()!==document.activeElement){a.focus();this.scrollToEnd();o.stopPropagation();}else{o.setMarked("forwardFocusToParent");}o.preventDefault();};k.prototype.onclick=function(o){var F;if(!this.getEnabled()){return;}F=!this.hasStyleClass("sapMTokenizerIndicatorDisabled")&&o.target.classList.contains("sapMTokenizerIndicator");if(F){this._handleNMoreIndicatorPress();}};k.prototype.ontouchstart=function(o){o.setMarked();if(D.browser.chrome&&window.getSelection()){window.getSelection().removeAllRanges();}};k.prototype.exit=function(){this._deregisterResizeHandler();if(this._oTokensList){this._oTokensList.destroy();this._oTokensList=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}this._oTokensWidthMap=null;this._oIndicator=null;this._aTokenValidators=null;};k.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){e.deregister(this._sResizeHandlerId);delete this._sResizeHandlerId;}};k.prototype._setTokensAria=function(){var t=this._getVisibleTokens().length;var i;var s="";var a="";var o={0:"TOKENIZER_ARIA_CONTAIN_TOKEN",1:"TOKENIZER_ARIA_CONTAIN_ONE_TOKEN"};if(C.getConfiguration().getAccessibility()){i=this.getAggregation("_tokensInfo");a=o[t]?o[t]:"TOKENIZER_ARIA_CONTAIN_SEVERAL_TOKENS";s=r.getText(a,t);i.setText(s);}};k.prototype._doSelect=function(){if(this._checkFocus()&&this._bCopyToClipboardSupport){var F=document.activeElement;var s=window.getSelection();s.removeAllRanges();if(this.getSelectedTokens().length){var o=document.createRange();o.selectNodeContents(this.getDomRef("clip"));s.addRange(o);}if(window.clipboardData&&F.id===this.getId()+"-clip"&&this.getDomRef()){this.getDomRef().focus();}}};k.prototype._setHiddenTokensCount=function(i){i=this.validateProperty("hiddenTokensCount",i);return this.setProperty("hiddenTokensCount",i);};k.prototype.getHiddenTokensCount=function(){return this.getProperty("hiddenTokensCount");};k.prototype.getTokensInfoId=function(){return this.getAggregation("_tokensInfo").getId();};k.prototype._handleBackspace=function(i,F){var t=this.getTokens();if(t[i-1]){return t[i-1].focus();}return F();};k.prototype._handleDelete=function(i,F){var t=this.getTokens();if(t[i+1]){return t[i+1].focus();}return F();};k.prototype.focusToken=function(i,o,F){var t=this.getTokens();var b=o.keyCode;var a=o.keyCode===K.BACKSPACE;if(t.length===0){return;}if(!b){return;}if(a){return this._handleBackspace(i,F);}return this._handleDelete(i,F);};k.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};k.TokenUpdateType={Added:"added",Removed:"removed"};return k;});
