/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery",'./library','sap/ui/core/Element','sap/ui/core/Control','sap/m/Popover','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText',"./NavigationListRenderer","sap/base/Log"],function(q,l,E,C,P,I,a,N,L){"use strict";var b=C.extend("sap.tnt.NavigationList",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}}}}});b.prototype.init=function(){this._itemNavigation=new I();this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);this._itemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});if(sap.ui.getCore().getConfiguration().getAccessibility()&&!b._sAriaPopupLabelId){b._sAriaPopupLabelId=new a({text:''}).toStatic().getId();}};b.prototype.onBeforeRendering=function(){var s=this.getSelectedKey();this.setSelectedKey(s);};b.prototype.onAfterRendering=function(){this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(this._getDomRefs());};b.prototype._updateNavItems=function(){this._itemNavigation.setItemDomRefs(this._getDomRefs());};b.prototype._getDomRefs=function(){var d=[],c=this.getItems(),e=this.getExpanded();for(var i=0;i<c.length;i++){if(e){q.merge(d,c[i]._getDomRefs());}else{d.push(c[i].getDomRef());}}return d;};b.prototype._adaptPopoverPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=8;this._offsets=["0 -8","8 0","0 8","-8 0"];this._myPositions=["center bottom","begin top","center top","end top"];this._atPositions=["center top","end top","center bottom","begin top"];}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin top","begin top","end top"];this._atPositions=["begin top","end top","begin bottom","begin top"];}};b.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy();}if(this._popover){this._popover.destroy();}};b.prototype._selectItem=function(p){this.fireItemSelect(p);var i=p.item;this.setSelectedItem(i,true);};b.prototype._findItemByKey=function(s){var g=this.getItems(),c,d,e,i,j;for(i=0;i<g.length;i++){c=g[i];if(c._getUniqueKey()===s){return c;}d=c.getItems();for(j=0;j<d.length;j++){e=d[j];if(e._getUniqueKey()===s){return e;}}}return null;};b.prototype.setSelectedKey=function(s){var i=this._findItemByKey(s);this.setSelectedItem(i,true);this.setProperty('selectedKey',s,true);return this;};b.prototype.getSelectedItem=function(){var s=this.getAssociation('selectedItem');if(!s){return null;}return sap.ui.getCore().byId(s);};b.prototype.setSelectedItem=function(s){var n,c,i;if(this._selectedItem){this._selectedItem._unselect();}if(!s){this._selectedItem=null;}i=s instanceof E&&s.isA("sap.tnt.NavigationListItem");if(typeof s!=='string'&&!i){L.warning('Type of selectedItem association should be string or instance of sap.tnt.NavigationListItem. New value was not set.');this.setAssociation('selectedItem',null,true);return this;}this.setAssociation('selectedItem',s,true);if(typeof s==='string'){n=sap.ui.getCore().byId(s);}else{n=s;}c=n?n._getUniqueKey():'';this.setProperty('selectedKey',c,true);if(n){n._select();this._selectedItem=n;return this;}L.warning('Type of selectedItem association should be a valid NavigationListItem object or ID. New value was not set.');return this;};b.prototype._openPopover=function(s,c){var t=this;var d=c.getSelectedItem();if(d&&c.isGroupSelected){d=null;}var p=this._popover=new P({showHeader:false,horizontalScrolling:false,verticalScrolling:true,initialFocus:d,afterClose:function(){if(t._popover){t._popover.destroy();t._popover=null;}},content:c,ariaLabelledBy:[b._sAriaPopupLabelId]}).addStyleClass('sapContrast sapContrastPlus');p._adaptPositionParams=this._adaptPopoverPositionParams;p.openBy(s);};b.prototype._closePopover=function(){if(this._popover){this._popover.close();}};return b;});
