/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library",'sap/ui/core/Core',"sap/ui/core/Item",'sap/ui/core/Icon','./NavigationList','sap/ui/core/InvisibleText','sap/ui/core/Renderer','sap/ui/core/IconPool',"sap/ui/events/KeyCodes","sap/ui/core/library","sap/ui/util/openWindow","sap/ui/util/defaultLinkTypes","sap/ui/dom/jquery/Aria"],function(l,C,I,a,N,b,R,c,K,d,o,e){"use strict";var T=d.TextAlign;var f=d.TextDirection;var g=I.extend("sap.tnt.NavigationListItem",{metadata:{library:"sap.tnt",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"},_expandIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.ui.core.Item"}}}},designtime:"sap/tnt/designtime/NavigationListItem.designtime"}});g.expandIcon='sap-icon://navigation-right-arrow';g.collapseIcon='sap-icon://navigation-down-arrow';g._getInvisibleText=function(){return this._invisibleText||(this._invisibleText=new b().toStatic());};g.prototype.init=function(){this._resourceBundle=C.getLibraryResourceBundle("sap.ui.core");this._resourceBundleMLib=C.getLibraryResourceBundle("sap.m");this._resourceBundleTNTLib=C.getLibraryResourceBundle("sap.tnt");};g.prototype._getUniqueKey=function(){var k=this.getKey();if(k){return k;}return this.getId();};g.prototype._getExpandIconControl=function(){var h=this.getAggregation('_expandIconControl');if(!h){var i=this.getExpanded();h=new a({src:i?g.collapseIcon:g.expandIcon,visible:this.getItems().length>0&&this.getHasExpander(),useIconTooltip:false,tooltip:this._getExpandIconTooltip(!i)}).addStyleClass('sapTntNavLIExpandIcon');this.setAggregation("_expandIconControl",h,true);}return h;};g.prototype._getExpandIconTooltip=function(h){if(!this.getEnabled()){return'';}var t=h?'Icon.expand':'Icon.collapse';return this._resourceBundle.getText(t);};g.prototype.getLevel=function(){var h=0;var p=this.getParent();if(p.getMetadata().getName()=='sap.tnt.NavigationListItem'){return p.getLevel()+1;}return h;};g.prototype.getNavigationList=function(){var p=this.getParent();while(p&&p.getMetadata().getName()!='sap.tnt.NavigationList'){p=p.getParent();}return p;};g.prototype._isListExpanded=function(){var n=this.getNavigationList();return n.getExpanded()||n.hasStyleClass("sapTntNavLIPopup");};g.prototype.createPopupList=function(){var n=[],h=this.getNavigationList(),s=h.getSelectedItem(),p,j,k,m=this.getItems();for(var i=0;i<m.length;i++){j=m[i];if(j.getVisible()){k=new g({key:j.getId(),text:j.getText(),textDirection:j.getTextDirection(),enabled:j.getEnabled(),href:j.getHref(),target:j.getTarget(),tooltip:j.getTooltip()});n.push(k);if(s===j){p=k;}}}var q=new g({expanded:true,hasExpander:false,key:this.getId(),text:this.getText(),enabled:this.getEnabled(),textDirection:this.getTextDirection(),href:this.getHref(),target:this.getTarget(),tooltip:this.getTooltip(),items:n});var r=new N({itemSelect:this.onPopupItemSelect.bind(this),items:[q]}).addStyleClass('sapTntNavLIPopup');if(s==this){p=q;r.isGroupSelected=true;}r.setSelectedItem(p);return r;};g.prototype.onPopupItemSelect=function(h){var i=h.getParameter('item');i=C.byId(i.getKey());i._selectItem(h);};g.prototype._selectItem=function(h){var p={item:this},n=this.getNavigationList();this.fireSelect(p);n._selectItem(p);this._openUrl();};g.prototype._openUrl=function(){var h=this.getHref();if(h){o(h,this.getTarget()||'_self');}};g.prototype.onkeydown=function(h){if(h.isMarked('subItem')){return;}h.setMarked('subItem');if(this.getLevel()>0){return;}var i=C.getConfiguration().getRTL();if((h.shiftKey&&h.which==189)||h.which==K.NUMPAD_MINUS||(h.which==K.ARROW_RIGHT&&i)||(h.which==K.ARROW_LEFT&&!i)){if(this.collapse()){h.preventDefault();h.stopPropagation();}}else if(h.which==K.NUMPAD_PLUS||(h.shiftKey&&h.which==K.PLUS)||h.which==K.ARROW_LEFT&&i||h.which==K.ARROW_RIGHT&&!i){if(this.expand()){h.preventDefault();h.stopPropagation();}}};g.prototype.expand=function(h){if(this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()>0){return;}this.setProperty('expanded',true,true);this.$().find('.sapTntNavLIGroup').attr('aria-expanded',true);var i=this._getExpandIconControl();i.setSrc(g.collapseIcon);i.setTooltip(this._getExpandIconTooltip(false));var $=this.$().find('.sapTntNavLIGroupItems');$.stop(true,true).slideDown(h||'fast',function(){$.toggleClass('sapTntNavLIHiddenGroupItems');});this.getNavigationList()._updateNavItems();return true;};g.prototype.collapse=function(h){if(!this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()>0){return;}this.setProperty('expanded',false,true);this.$().find('.sapTntNavLIGroup').attr('aria-expanded',false);var i=this._getExpandIconControl();i.setSrc(g.expandIcon);i.setTooltip(this._getExpandIconTooltip(true));var $=this.$().find('.sapTntNavLIGroupItems');$.stop(true,true).slideUp(h||'fast',function(){$.toggleClass('sapTntNavLIHiddenGroupItems');});this.getNavigationList()._updateNavItems();return true;};g.prototype.ontap=function(h){var n=this.getNavigationList(),s=C.byId(h.target.id),i=this.getLevel(),p,j;if(h.isMarked('subItem')){return;}h.setMarked('subItem');if(!this.getEnabled()){return;}if(i===1){p=this.getParent();if(this.getEnabled()&&p.getEnabled()){this._selectItem(h);}return;}if(n.getExpanded()||!this.getItems().length){if(!s||s.getMetadata().getName()!=='sap.ui.core.Icon'||!s.$().hasClass('sapTntNavLIExpandIcon')){this._selectItem(h);return;}h.preventDefault();if(this.getExpanded()){this.collapse();}else{this.expand();}}else{j=this.createPopupList();n._openPopover(this,j);}};g.prototype.onsapenter=g.prototype.ontap;g.prototype.onsapspace=g.prototype.ontap;g.prototype.render=function(r,h){if(!this.getVisible()){return;}if(this.getLevel()===0){this.renderFirstLevelNavItem(r,h);}else{this.renderSecondLevelNavItem(r,h);}};g.prototype.renderGroupItem=function(r,h){var i=this._isListExpanded(),j=this.getExpanded(),k=this._getVisibleItems(this),m=k.length,t=this.getText(),n=this.getHref(),p=this.getTarget(),q,s={level:'1',role:'treeitem',selected:false,roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE_ITEM")};r.openStart("div");r.class("sapTntNavLIItem");r.class("sapTntNavLIGroup");if(h._selectedItem===this){s.selected=true;r.class("sapTntNavLIItemSelected");}if(!this.getEnabled()){r.class("sapTntNavLIItemDisabled");}if(!i&&this._hasSelectedChild(h._selectedItem)){r.class("sapTntNavLIItemSelected");}if(i){q=this.getTooltip_AsString()||t;if(q){r.attr("title",q);}if(this.getEnabled()){r.attr("tabindex","-1");}if(m>0){s.expanded=j;}r.accessibilityState(s);}r.openEnd();r.openStart('a',this.getId()+'-a');r.attr('tabindex','-1');if(n){r.attr('href',n);}if(p){r.attr('target',p);r.attr('rel',e('',p));}r.openEnd();this._renderIcon(r);if(h.getExpanded()){var u=this._getExpandIconControl();u.setVisible(this.getItems().length>0&&this.getHasExpander());u.setSrc(this.getExpanded()?g.collapseIcon:g.expandIcon);u.setTooltip(this._getExpandIconTooltip(!this.getExpanded()));this._renderText(r);r.renderControl(u);}r.close("a");r.close("div");};g.prototype.renderFirstLevelNavItem=function(r,h){var j,k=this._getVisibleItems(this),m=k.length,n=this.getExpanded(),p=this._isListExpanded(),t,q={role:'menuitemradio',checked:false,roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUITEM")};r.openStart("li",this);if(!p){if(this.getEnabled()){r.attr('tabindex','-1');}t=this.getTooltip_AsString()||this.getText();if(t){r.attr("title",t);}if(m>0){if(this.getEnabled()){r.class("sapTnTNavLINotExpandedTriangle");}q.haspopup="tree";}if(h._selectedItem===this){q.checked=true;}r.accessibilityState(q);}else{r.attr('aria-hidden','true');}r.openEnd();this.renderGroupItem(r,h);if(p){r.openStart('ul');r.attr('aria-hidden','true');r.attr('role','group');r.class("sapTntNavLIGroupItems");if(!n){r.class("sapTntNavLIHiddenGroupItems");}r.openEnd();for(var i=0;i<m;i++){j=k[i];j.render(r,h,i,m);}r.close("ul");}r.close("li");};g.prototype.renderSecondLevelNavItem=function(r,h){var i=this.getParent(),j=this.getHref(),t=this.getTarget(),k={role:'treeitem',level:'2',selected:false,roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE_ITEM")};r.openStart('li',this);r.class("sapTntNavLIItem");r.class("sapTntNavLIGroupItem");if(h._selectedItem===this){k.selected=true;r.class("sapTntNavLIItemSelected");}if(!this.getEnabled()||!i.getEnabled()){r.class("sapTntNavLIItemDisabled");}else{r.attr('tabindex','-1');}var m=this.getText();var n=this.getTooltip_AsString()||m;if(n){r.attr("title",n);}r.accessibilityState(k);r.openEnd();r.openStart('a',this.getId()+'-a');r.attr('tabindex','-1');if(j){r.attr('href',j);}if(t){r.attr('target',t);r.attr('rel',e('',t));}r.openEnd();this._renderText(r);r.close('a');r.close('li');};g.prototype._renderIcon=function(r){var i=this.getIcon(),h=c.getIconInfo(i);if(i){r.openStart('span');r.class("sapUiIcon");r.class("sapTntNavLIGroupIcon");r.attr("aria-hidden",true);if(h&&!h.suppressMirroring){r.class("sapUiIconMirrorInRTL");}if(h){r.attr("data-sap-ui-icon-content",h.content);r.style("font-family","'"+h.fontFamily+"'");}r.openEnd();r.close('span');}else{r.openStart('span');r.class('sapUiIcon');r.class('sapTntNavLIGroupIcon');r.attr('aria-hidden',true);r.openEnd();r.close('span');}};g.prototype._renderText=function(r){r.openStart('span');r.class("sapMText");r.class("sapTntNavLIText");r.class("sapMTextNoWrap");var t=this.getTextDirection();if(t!==f.Inherit){r.attr("dir",t.toLowerCase());}var h=R.getTextAlign(T.Begin,t);if(h){r.style("text-align",h);}r.openEnd();r.text(this.getText());r.close('span');};g.prototype._unselect=function(){var $=this.$(),n=this.getNavigationList();if(!n){return;}if(this._isListExpanded()){if(this.getLevel()===0){$=$.find('.sapTntNavLIGroup');}$.attr('aria-selected',false);}else{$.attr('aria-checked',false);$=$.find('.sapTntNavLIGroup');if(this.getParent().isA("sap.tnt.NavigationListItem")){this.getParent().$().find('.sapTntNavLIGroup').removeClass('sapTntNavLIItemSelected');}}$.removeClass('sapTntNavLIItemSelected');};g.prototype._select=function(){var $=this.$(),n=this.getNavigationList();if(!n){return;}if(this._isListExpanded()){if(this.getLevel()===0){$=$.find('.sapTntNavLIGroup');}$.attr('aria-selected',true);}else{$.attr('aria-checked',true);$=$.find('.sapTntNavLIGroup');if(this.getParent().isA("sap.tnt.NavigationListItem")){this.getParent().$().find('.sapTntNavLIGroup').addClass('sapTntNavLIItemSelected');}n._closePopover();}$.addClass('sapTntNavLIItemSelected');};g.prototype._getDomRefs=function(){var h=[];if(!this.getEnabled()){return h;}var $=this.$();h.push($.find('.sapTntNavLIGroup')[0]);if(this.getExpanded()){var s=$.find('.sapTntNavLIGroupItem');for(var i=0;i<s.length;i++){h.push(s[i]);}}return h;};g.prototype._getVisibleItems=function(h){var v=[];var i=h.getItems();var j;for(var k=0;k<i.length;k++){j=i[k];if(j.getVisible()){v.push(j);}}return v;};g.prototype.onclick=function(h){if(this.getHref()){h.preventDefault();}};g.prototype.onmousedown=function(h){if(this.getHref()){h.preventDefault();}};g.prototype.onfocusin=function(h){if(h.srcControl!==this){return;}this._updateAccessibilityText();};g.prototype._updateAccessibilityText=function(){var i=g._getInvisibleText(),n=this.getNavigationList(),h=this._resourceBundleMLib,j=n.getExpanded()?h.getText("ACC_CTR_TYPE_TREEITEM"):'',$=this._getAccessibilityItem(),p=this._getAccessibilityPosition(),k=h.getText("LIST_ITEM_POSITION",[p.index,p.size]),s=n._selectedItem===this?h.getText("LIST_ITEM_SELECTED"):'',m=n.getExpanded()?this.getText():"",t=j+" "+k+" "+s+" "+m;i.setText(t);$.addAriaLabelledBy(i.getId());};g.prototype._getAccessibilityPosition=function(){var p=this.getParent(),v=this._getVisibleItems(p),s=v.length,i=v.indexOf(this)+1;return{index:i,size:s};};g.prototype._getAccessibilityItem=function(){var $=this.$(),n=this.getNavigationList(),i=n.getExpanded();if(i&&this.getLevel()===0){$=$.find('.sapTntNavLIGroup');}return $;};g.prototype._hasSelectedChild=function(s){var h=this.getItems(),i;for(i=0;i<h.length;i++){if(h[i]===s){return true;}}return false;};return g;});
