/*!
* OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./HyphenationTestingWords","sap/ui/base/ManagedObject","sap/base/Log","sap/base/util/deepEqual","sap/ui/core/Locale","sap/ui/Device"],function(H,M,L,d,a,D){"use strict";var t={'bg':true,'ca':true,'hr':true,'cs':false,
// no valid license
'da':true,'nl':true,'en-us':true,'et':true,'fi':true,'fr':true,'de':true,'el-monoton':true,'hi':true,'hu':true,'it':true,'lt':true,'nb-no':true,'pl':false,'pt':true,'ru':true,'sr':false,'sl':true,'es':true,'sv':true,'th':true,'tr':true,'uk':true};var l={"bg":"Bulgarian","ca":"Catalan","hr":"Croatian","cs":"Czech","da":"Danish","nl":"Dutch","en":"English","et":"Estonian","fi":"Finnish","fr":"French","de":"German","el":"Greek","hi":"Hindi","hu":"Hungarian","it":"Italian","lt":"Lithuanian","nb":"Norwegian Bokmål","no":"Norwegian","pl":"Polish","pt":"Portuguese","ru":"Russian","sr":"Serbian","sl":"Slovenian","es":"Spanish","sv":"Swedish","th":"Thai","tr":"Turkish","uk":"Ukrainian"};var b={};var s={};var T={};var h=null;var f=null;var o={};var p={};var c=[];var m={};function i(E,F,G){L.info("[UI5 Hyphenation] Initializing third-party module for language "+z(E),"sap.ui.core.hyphenation.Hyphenation.initialize()");window.hyphenopoly.initializeLanguage(F).then(e.bind(this,E,G));}function r(E,F,G){L.info("[UI5 Hyphenation] Re-initializing third-party module for language "+z(E),"sap.ui.core.hyphenation.Hyphenation.initialize()");window.hyphenopoly.reInitializeLanguage(E,F).then(e.bind(this,E,G));}function e(E,F,G){o[E]=G;h.bIsInitialized=true;if(c.length>0){c.forEach(function(I){i(I.sLanguage,I.oConfig,I.resolve);});c=[];}h.bLoading=false;F(y(E));}function g(E,F){var G={"require":[E],"hyphen":"\u00AD","leftmin":3,"rightmin":3,"compound":"all","path":sap.ui.require.toUrl("sap/ui/thirdparty/hyphenopoly")};if(F){if("hyphen"in F){G.hyphen=F.hyphen;}if("minWordLength"in F){G.minWordLength=F.minWordLength;}if("exceptions"in F){L.info("[UI5 Hyphenation] Add hyphenation exceptions '"+JSON.stringify(F.exceptions)+"' for language "+z(E),"sap.ui.core.hyphenation.Hyphenation");var W=[];Object.keys(F.exceptions).forEach(function(I){W.push(F.exceptions[I]);});if(W.length>0){G.exceptions={};G.exceptions[E]=W.join(", ");}}}return G;}function j(P,F){return new Promise(function(E,G){var I=document.createElement('script');I.async=true;I.src=P+F;I.addEventListener('load',E);I.addEventListener('error',function(){return G('Error loading script: '+F);});I.addEventListener('abort',function(){return G(F+' Script loading aborted.');});document.head.appendChild(I);});}var k=(function F(){var E=["visibility:hidden;","-moz-hyphens:auto;","-webkit-hyphens:auto;","-ms-hyphens:auto;","hyphens:auto;","width:48px;","font-size:12px;","line-height:12px;","border:none;","padding:0;","word-wrap:normal"];return E.join("");}());function n(E){if(!f){f=document.createElement("body");}var F=document.createElement("div");F.lang=E;F.id=E;F.style.cssText=k;F.appendChild(document.createTextNode(H[E.toLowerCase()]));f.appendChild(F);}function q(E){if(f){E.appendChild(f);return f;}return null;}function u(){if(f){f.parentNode.removeChild(f);}}function v(E){return(E.style.hyphens==="auto"||E.style.webkitHyphens==="auto"||E.style.msHyphens==="auto"||E.style["-moz-hyphens"]==="auto");}function w(E){var F;if(E){F=new a(E);}else{F=sap.ui.getCore().getConfiguration().getLocale();}var G=F.getLanguage().toLowerCase();switch(G){case"en":G="en-us";break;case"nb":G="nb-no";break;case"no":G="nb-no";break;case"el":G="el-monoton";break;}return G;}function x(E){if(E){return new a(E).toString();}return sap.ui.getCore().getConfiguration().getLocale().toString();}function y(P){if(typeof P==="string"){return P.substring(0,2);}else{return null;}}function z(P){var E=y(P);if(l.hasOwnProperty(E)){return"'"+l[E]+"' (code:'"+E+"')";}else{return"'"+E+"'";}}function A(E){h.fireError(E);L.error("[UI5 Hyphenation] "+E,"sap.ui.core.hyphenation.Hyphenation");}function B(){return!(D.os.macintosh&&D.browser.chrome);}var C=M.extend("sap.ui.core.hyphenation.Hyphenation",{metadata:{library:"sap.ui.core",events:{error:{parameters:{sErrorMessage:{type:"string"}}}}}});C.prototype.canUseNativeHyphenation=function(E){var F=x(E);var G;if(!this.isLanguageSupported(E)){return null;}if(!b.hasOwnProperty(F)){n(F);var I=q(document.documentElement);if(I!==null){var J=document.getElementById(F);if(B()&&v(J)&&J.offsetHeight>12){G=true;}else{G=false;}u();}b[F]=G;if(G){L.info("[UI5 Hyphenation] Browser-native hyphenation can be used for language "+z(F),"sap.ui.core.hyphenation.Hyphenation.canUseNativeHyphenation()");}else{L.info("[UI5 Hyphenation] Browser-native hyphenation is not supported by current platform for language "+z(F),"sap.ui.core.hyphenation.Hyphenation.canUseNativeHyphenation()");}}else{G=b[F];}return G;};C.prototype.canUseThirdPartyHyphenation=function(E){var F=w(E),G;if(!this.isLanguageSupported(E)){return null;}if(!T.hasOwnProperty(F)){G=t.hasOwnProperty(F)&&t[F];if(G){L.info("[UI5 Hyphenation] Third-party hyphenation can be used for language "+z(F),"sap.ui.core.hyphenation.Hyphenation.canUseThirdPartyHyphenation()");}else{L.info("[UI5 Hyphenation] Third-party hyphenation is not supported for language "+z(F),"sap.ui.core.hyphenation.Hyphenation.canUseThirdPartyHyphenation()");}T[F]=G;}else{G=T[F];}return G;};C.prototype.isLanguageSupported=function(E){var F=w(E),I;if(!s.hasOwnProperty(F)){I=H.hasOwnProperty(F);if(!I){L.info("[UI5 Hyphenation] Language "+z(F)+" is not known to the Hyphenation API","sap.ui.core.hyphenation.Hyphenation.isLanguageSupported()");}s[F]=I;}else{I=s[F];}return I;};C.prototype.hyphenate=function(E,F){var G=w(F);if(!o.hasOwnProperty(G)){A("Language "+z(G)+" is not initialized. You have to initialize it first with method 'initialize()'");return E;}return o[G](E);};C.prototype.getInitializedLanguages=function(){return Object.keys(o).map(function(E){return y(E);});};C.prototype.isLanguageInitialized=function(E){var E=w(E);return Object.keys(o).indexOf(E)!=-1;};C.prototype.getExceptions=function(E){var E=w(E);if(this.isLanguageInitialized(E)){return window.hyphenopoly.languages[E].exceptions;}else{A("Language "+z(E)+" is not initialized. You have to initialize it first with method 'initialize()'");}};C.prototype.addExceptions=function(E,F){var E=w(E);if(this.isLanguageInitialized(E)){L.info("[UI5 Hyphenation] Add hyphenation exceptions '"+JSON.stringify(F)+"' for language "+z(E),"sap.ui.core.hyphenation.Hyphenation.addExceptions()");Object.keys(F).forEach(function(G){window.hyphenopoly.languages[E].cache[G]=F[G];window.hyphenopoly.languages[E].exceptions[G]=F[G];});}else{A("Language "+z(E)+" is not initialized. You have to initialize it first with method 'initialize()'");}};C.prototype.initialize=function(E,F){var G=w(E);var F=g(G,F);var I=true;if(m[G]&&d(m[G],F)){I=false;}m[G]=F;if(t[G]){if(!h.bIsInitialized&&!h.bLoading){h.bLoading=true;p[G]=new Promise(function(K,N){j(F.path,"/hyphenopoly.bundle.js").then(i.bind(this,G,F,K));});return p[G];}else if(h.bLoading&&!o[G]&&p[G]){return p[G];}else if(this.isLanguageInitialized(G)){if(I){p[G]=new Promise(function(K){r(G,F,K);});}}else{p[G]=new Promise(function(K,N){if(!h.bIsInitialized){c.push({sLanguage:G,oConfig:F,resolve:K});}else{i(G,F,K);}});}h.bLoading=true;return p[G];}else{var J="Language "+z(E)+" can not be initialized. It is either not supported by the third-party module or an error occurred";A(J);return new Promise(function(K,N){N(J);});}};C.getInstance=function(){if(!h){h=new C();h.bIsInitialized=false;h.bLoading=false;}return h;};return C;});
