/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./View',"./XMLViewRenderer","sap/base/util/deepExtend",'sap/ui/base/ManagedObject','sap/ui/core/XMLTemplateProcessor','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/core/cache/CacheManager','sap/ui/model/resource/ResourceModel','sap/ui/util/XMLHelper','sap/base/strings/hash','sap/base/Log','sap/base/util/LoaderExtensions',"sap/ui/performance/trace/Interaction"],function(q,V,X,d,M,a,l,C,R,b,c,f,h,L,g,I){"use strict";var j=R.RenderPrefixes,k=l.mvc.ViewType,x="XMLViewCacheError",n={};var m=V.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'},cache:'Object',processingMode:{type:"string",visibility:"hidden"}},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"}});sap.ui.xmlview=function(i,e){return sap.ui.view(i,e,k.XML);};m.create=function(o){var P=d({},o);P.viewContent=P.definition;P.async=true;P.type=k.XML;return V.create(P);};m._sType=k.XML;m.asyncSupport=true;m._bUseCache=sap.ui.getCore().getConfiguration().getViewCache()&&b._isSupportedEnvironment();function v(e){if(e.parseError.errorCode!==0){var P=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}}function p(o,S){if(!S){throw new Error("mSettings must be given");}else if(S.viewName&&S.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((S.viewName||S.viewContent)&&S.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(S.viewName||S.viewContent)&&!S.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}else if(S.cache&&!(S.cache.keys&&S.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.");}}function r(o,S){o.mProperties["viewContent"]=S.viewContent;var e=f.parse(S.viewContent);v(e);return e.documentElement;}function s(o,S){if((o._resourceBundleName||o._resourceBundleUrl)&&(!S.models||!S.models[o._resourceBundleAlias])){var e=new c({bundleName:o._resourceBundleName,bundleUrl:o._resourceBundleUrl,bundleLocale:o._resourceBundleLocale,async:S.async});var i=e.getResourceBundle();if(i instanceof Promise){return i.then(function(){o.setModel(e,o._resourceBundleAlias);});}o.setModel(e,o._resourceBundleAlias);}}function t(o){o.oAfterRenderingNotifier=new G();o.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){o.onAfterRenderingBeforeChildren();}});}function u(S){var e=sap.ui.require("sap/ui/core/Component"),o;while(S&&e){var i=e.getOwnerComponentFor(S);if(i){S=o=i;}else{if(S instanceof e){o=S;}S=S.getParent&&S.getParent();}}return o;}function w(o,e){var i=u(o),H=i?JSON.stringify(i.getManifest()):null,J=[];J=J.concat(A(o,i),D(),B(o),e.keys);return z(o,J).then(function(K){return{key:K+"("+h(H||"")+")",componentManifest:H,additionalData:e.additionalData};});}function y(K){return K;}function z(o,i){return Promise.all(i).then(function(K){K=K.filter(function(H){return H!==n;});if(K.every(y)){return K.join('_');}else{var e=new Error("Provided cache keys may not be empty or undefined.");e.name=x;return Promise.reject(e);}});}function A(o,e){var i=e&&e.getMetadata().getName();return[i||window.location.host+window.location.pathname,o.getId(),sap.ui.getCore().getConfiguration().getLanguageTag()].concat(e&&e.getActiveTerminologies()||[]);}function B(e){var P=e.getPreprocessors(),i=e.getPreprocessorInfo(false),H=[];function J(o){H.push(o.preprocessor.then(function(K){if(K.getCacheKey){return K.getCacheKey(i);}else{return n;}}));}for(var T in P){P[T].forEach(J);}return H;}function D(){return sap.ui.getVersionInfo({async:true}).then(function(i){var T="";if(!i.libraries){T=sap.ui.buildinfo.buildtime;}else{i.libraries.forEach(function(o){T+=o.buildTimestamp;});}return T;}).catch(function(e){L.warning("sap.ui.getVersionInfo could not be retrieved","sap.ui.core.mvc.XMLView");L.debug(e);return"";});}function E(e,i){var K=e.key;delete e.key;e.xml=f.serialize(i);return b.set(K,e);}function F(e){return b.get(e.key).then(function(i){if(i&&i.componentManifest==e.componentManifest){i.xml=f.parse(i.xml,"application/xml").documentElement;if(i.additionalData){d(e.additionalData,i.additionalData);}return i;}});}m.prototype.initViewSettings=function(S){var e=this,_;function i(P){e._xContent=P;if(V._supportInfo){V._supportInfo({context:e._xContent,env:{caller:"view",viewinfo:d({},e),settings:d({},S||{}),type:"xmlview"}});}if(!e.isSubView()){var Q={};a.parseViewAttributes(P,e,Q);if(!S.async){Object.assign(S,Q);}else{e.applySettings(Q);}}else{delete S.controller;}var T=s(e,S);if(T instanceof Promise){return T.then(function(){t(e);});}t(e);}function o(P,Q){if(e.hasPreprocessor("viewxml")){return a.enrichTemplateIdsPromise(P,e,Q).then(function(){return e.runPreprocessor("viewxml",P,!Q);});}return P;}function H(P){var Q=I.notifyAsyncStep("VIEW PREPROCESSING");return e.runPreprocessor("xml",P).then(function(P){return o(P,true);}).finally(Q);}function J(O){return g.loadResource(O,{async:true}).then(function(P){return P.documentElement;});}function K(O,P){return J(O).then(H).then(function(Q){if(P){E(P,Q);}return Q;});}function N(O,P){return w(e,P).then(function(Q){return F(Q).then(function(T){if(!T){return K(O,Q);}else{return T.xml;}});}).catch(function(Q){if(Q.name===x){L.debug(Q.message,Q.name,"sap.ui.core.mvc.XMLView");L.debug("Processing the View without caching.","sap.ui.core.mvc.XMLView");return K(O);}else{return Promise.reject(Q);}});}this._oContainingView=S.containingView||this;this._sProcessingMode=S.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true;}p(this,S);if(S.viewName){var O=S.viewName.replace(/\./g,"/")+".view.xml";if(S.async){if(S.cache&&m._bUseCache){return N(O,S.cache).then(i);}else{return J(O).then(H).then(i);}}else{_=g.loadResource(O).documentElement;}}else if(S.viewContent){if(S.viewContent.nodeType===window.Node.DOCUMENT_NODE){_=S.viewContent.documentElement;}else{_=r(this,S);}}else if(S.xmlNode){_=S.xmlNode;}if(S.async){return H(_).then(i);}else{_=this.runPreprocessor("xml",_,true);_=o(_,false);if(_&&typeof _.getResult==='function'){if(_.isRejected()){throw _.getResult();}_=_.getResult();}i(_);}};m.prototype.onBeforeRendering=function(){var o=this.getDomRef();if(o&&!R.isPreservedContent(o)){R.preserveContent(o,true);}V.prototype.onBeforeRendering.apply(this,arguments);};m.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};m.prototype.onControllerConnected=function(o){var e=this;function i(J){return M.runWithPreprocessors(J,{settings:e._fnSettingsPreprocessor});}if(!this.oAsyncState){this._aParsedContent=i(a.parseTemplate.bind(null,this._xContent,this));}else{var H=I.notifyAsyncStep("VIEW PROCESSING");return a.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:i}).then(function(P){e._aParsedContent=P;delete e.oAsyncState.suppressPreserve;}).finally(H);}};m.prototype.getControllerName=function(){return this._controllerName;};m.prototype.isSubView=function(){return this._oContainingView!=this;};m.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var i=0;i<e.length;i++){var N=document.getElementById(j.Temporary+e[i].getId())||e[i].getDomRef()||document.getElementById(j.Invisible+e[i].getId());if(N){q(document.getElementById(j.Dummy+e[i].getId())).replaceWith(N);}}}q(document.getElementById(j.Temporary+this.getId())).replaceWith(this._$oldContent);}this._$oldContent=undefined;};m.prototype._onChildRerenderedEmpty=function(o,e){q(e).replaceWith('<div id="'+j.Dummy+o.getId()+'" class="sapUiHidden"></div>');return true;};m.registerPreprocessor=function(T,P,S,o,e){T=T.toUpperCase();if(m.PreprocessorType[T]){V.registerPreprocessor(m.PreprocessorType[T],P,this.getMetadata().getClass()._sType,S,o,e);}else{L.error("Preprocessor could not be registered due to unknown sType \""+T+"\"",this.getMetadata().getName());}};m.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};var G=C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{metadata:{library:"sap.ui.core"},renderer:{apiVersion:2,render:function(o,e){o.text("");}}});m.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return m;});
