/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/support/Plugin','sap/ui/core/util/serializer/ViewSerializer','sap/ui/core/util/File','sap/ui/thirdparty/jszip','sap/ui/base/DataType','sap/ui/core/Element','sap/ui/core/ElementMetadata','sap/ui/core/UIArea','sap/ui/core/mvc/View','sap/ui/core/mvc/Controller','sap/ui/model/Binding','sap/ui/model/CompositeBinding','sap/base/util/ObjectPath',"sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/security/encodeXML"],function(P,V,F,J,D,E,a,U,b,C,B,c,O,q,K,e){"use strict";var $=jQuery;var d=P.extend("sap.ui.core.support.plugins.ControlTree",{constructor:function(s){P.apply(this,["sapUiSupportControlTree","Control Tree",s]);this._oStub=s;if(this.runsAsToolPlugin()){this._aEventIds=["sapUiSupportSelectorSelect",this.getId()+"ReceiveControlTree",this.getId()+"ReceiveControlTreeExport",this.getId()+"ReceiveControlTreeExportError",this.getId()+"TriggerRequestProperties",this.getId()+"ReceiveProperties",this.getId()+"ReceiveBindingInfos",this.getId()+"ReceiveMethods",this.getId()+"ReceivePropertiesMethods"];this._breakpointId="sapUiSupportBreakpoint";this._tab={properties:"Properties",bindinginfos:"BindingInfos",breakpoints:"Breakpoints",exports:"Export"};this._currentTab=this._tab.properties;}else{this._aEventIds=[this.getId()+"RequestControlTree",this.getId()+"RequestControlTreeSerialize",this.getId()+"RequestProperties",this.getId()+"RequestBindingInfos",this.getId()+"ChangeProperty",this.getId()+"RefreshBinding"];var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(o){t.oCore=o;},stopPlugin:function(){t.oCore=undefined;}});}}});d.prototype.init=function(s){P.prototype.init.apply(this,arguments);if(this.runsAsToolPlugin()){f.call(this,s);}else{j.call(this,s);}};function f(s){$(document).on("click","li img.sapUiControlTreeIcon",$.proxy(this._onIconClick,this)).on("click","li.sapUiControlTreeElement div",$.proxy(this._onNodeClick,this)).on("click","li.sapUiControlTreeLink div",$.proxy(this._onControlTreeLinkClick,this)).on("click","#sapUiSupportControlTabProperties",$.proxy(this._onPropertiesTab,this)).on("click","#sapUiSupportControlTabBindingInfos",$.proxy(this._onBindingInfosTab,this)).on("click","#sapUiSupportControlTabBreakpoints",$.proxy(this._onMethodsTab,this)).on("click","#sapUiSupportControlTabExport",$.proxy(this._onExportTab,this)).on("change","[data-sap-ui-name]",$.proxy(this._onPropertyChange,this)).on("change","[data-sap-ui-method]",$.proxy(this._onPropertyBreakpointChange,this)).on("keyup",'.sapUiSupportControlMethods input[type="text"]',$.proxy(this._autoComplete,this)).on("blur",'.sapUiSupportControlMethods input[type="text"]',$.proxy(this._updateSelectOptions,this)).on("change",'.sapUiSupportControlMethods select',$.proxy(this._selectOptionsChanged,this)).on("click",'#sapUiSupportControlAddBreakPoint',$.proxy(this._onAddBreakpointClicked,this)).on("click",'#sapUiSupportControlExportToXml',$.proxy(this._onExportToXmlClicked,this)).on("click",'#sapUiSupportControlExportToHtml',$.proxy(this._onExportToHtmlClicked,this)).on("click",'#sapUiSupportControlActiveBreakpoints img.remove-breakpoint',$.proxy(this._onRemoveBreakpointClicked,this)).on("click",'#sapUiSupportControlPropertiesArea a.control-tree',$.proxy(this._onNavToControl,this)).on("click",'#sapUiSupportControlPropertiesArea img.sapUiSupportRefreshBinding',$.proxy(this._onRefreshBinding,this));this.renderContentAreas();}d.prototype.exit=function(s){P.prototype.exit.apply(this,arguments);if(this.runsAsToolPlugin()){$(document).off('click','li img.sapUiControlTreeIcon').off('click','li div').off("click","li.sapUiControlTreeLink").off("click","#sapUiSupportControlTabProperties").off("click","#sapUiSupportControlTabBindings").off("click","#sapUiSupportControlTabBreakpoints").off("click","#sapUiSupportControlTabExport").off('change','[data-sap-ui-name]').off('change','[data-sap-ui-method]').off('keyup','.sapUiSupportControlMethods input[type="text"]').off('blur','.sapUiSupportControlMethods select').off('change','.sapUiSupportControlMethods select').off('click','#sapUiSupportControlAddBreakPoint').off('click','#sapUiSupportControlExportToXml').off('click','#sapUiSupportControlExportToHtml').off('click','#sapUiSupportControlActiveBreakpoints img.remove-breakpoint').off('click','#sapUiSupportControlPropertiesArea a.control-tree').off('click','#sapUiSupportControlPropertiesArea img.sapUiSupportRefreshBinding');}};function g(s){if(s==null){return"";}s=String(s);return s.slice(1+s.lastIndexOf('.'));}function h(s){return s==null?"":e(String(s));}d.prototype.renderContentAreas=function(){var r=sap.ui.getCore().createRenderManager();r.write('<div style="padding: 0.5rem">You can find a control in this tree by clicking it in the application UI while pressing the Ctrl+Alt+Shift keys.</div>');r.write('<div id="sapUiSupportControlTreeArea"><ul class="sapUiSupportControlTreeList"></ul></div>');r.write('<div id="sapUiSupportControlTabs" style="visibility:hidden">');r.write('<button id="sapUiSupportControlTabProperties" class="sapUiSupportBtn sapUiSupportTab sapUiSupportTabLeft">Properties</button>');r.write('<button id="sapUiSupportControlTabBindingInfos" class="sapUiSupportBtn sapUiSupportTab">Binding Infos</button>');r.write('<button id="sapUiSupportControlTabBreakpoints" class="sapUiSupportBtn sapUiSupportTab">Breakpoints</button>');r.write('<button id="sapUiSupportControlTabExport" class="sapUiSupportBtn sapUiSupportTab sapUiSupportTabRight">Export</button>');r.write('</div>');r.write('<div id="sapUiSupportControlPropertiesArea"></div>');r.flush(this.$().get(0));r.destroy();};d.prototype.renderControlTree=function(i){var r=sap.ui.getCore().createRenderManager();function k(I,m){var H=m.aggregation.length>0||m.association.length>0;r.write("<li id=\"sap-debug-controltree-"+h(m.id)+"\" class=\"sapUiControlTreeElement\">");var s=H?"minus":"space";r.write("<img class=\"sapUiControlTreeIcon\" style=\"height: 12px; width: 12px;\" src=\"../../debug/images/"+s+".gif\">");if(m.isAssociation){r.write("<img title=\"Association\" class=\"sapUiControlTreeIcon\" style=\"height: 12px; width: 12px;\" src=\"../../debug/images/link.gif\">");}var l=g(m.type);r.write('<div>');r.write('<span class="name" title="'+h(m.type)+'">'+h(l)+' - '+h(m.id)+'</span>');r.write('<span class="sapUiSupportControlTreeBreakpointCount" title="Number of active breakpoints / methods" style="display:none;"></span>');r.write('</div>');if(m.aggregation.length>0){r.write("<ul>");$.each(m.aggregation,k);r.write("</ul>");}if(m.association.length>0){r.write("<ul>");$.each(m.association,function(I,v){if(v.isAssociationLink){var t=g(v.type);r.write("<li data-sap-ui-controlid=\""+h(v.id)+"\" class=\"sapUiControlTreeLink\">");r.write("<img class=\"sapUiControlTreeIcon\" style=\"height: 12px; width: 12px;\" align=\"middle\" src=\"../../debug/images/space.gif\">");r.write("<img class=\"sapUiControlTreeIcon\" style=\"height: 12px; width: 12px;\" align=\"middle\" src=\"../../debug/images/link.gif\">");r.write("<div><span title=\"Association '"+h(v.name)+"' to '"+h(v.id)+"' with type '"+h(v.type)+"'\">"+h(t)+" - "+h(v.id)+" ("+h(v.name)+")</span></div>");r.write("</li>");}else{k(0,v);}});r.write("</ul>");}r.write("</li>");}$.each(i,k);r.flush(this.$().find("#sapUiSupportControlTreeArea > ul.sapUiSupportControlTreeList").get(0));r.destroy();};d.prototype.renderPropertiesTab=function(i,s){var r=sap.ui.getCore().createRenderManager();r.write('<ul class="sapUiSupportControlTreeList" data-sap-ui-controlid="'+h(s)+'">');$.each(i,function(I,v){r.write("<li>");r.write("<span><label class='sapUiSupportLabel'>BaseType:</label> <code>"+h(v.control)+"</code></span>");if(v.properties.length>0||v.aggregations.length>0){r.write('<div class="get" title="Activate debugger for get-method">G</div><div class="set" title="Activate debugger for set-method">S</div>');r.write("<div class=\"sapUiSupportControlProperties\"><table><colgroup><col width=\"50%\"><col width=\"50%\"></colgroup>");$.each(v.properties,function(I,p){r.write("<tr><td>");r.write("<label class='sapUiSupportLabel'>"+h(p.name)+((p.isBound)?'<img title="Value is bound (see Binding Infos)" src="../../debug/images/link.gif" style="vertical-align:middle;margin-left:3px">':"")+"</label>");r.write("</td><td>");if(p.type==="boolean"){r.write("<input type='checkbox' ");r.write("data-sap-ui-name='"+h(p.name)+"' ");if(p.value==true){r.write("checked='checked'");}r.write(">");}else if(p.enumValues){r.write("<div><select ");r.write("data-sap-ui-name='"+h(p.name)+"'>");$.each(p.enumValues,function(k,l){r.write("<option");if(k===p.value){r.write(" selected");}r.write(">");r.writeEscaped(""+k);r.write("</option>");});r.write("</select></div>");}else{r.write("<div><input type='text' ");r.write("data-sap-ui-name='"+h(p.name)+"' ");if(p.value){r.write("value='");r.writeEscaped(""+p.value);r.write("'");}r.write("></div>");}r.write("</td>");r.write('<td><input type="checkbox" data-sap-ui-method="'+h(p._sGetter)+'" title="Activate debugger for '+h(p._sGetter)+'"');if(p.bp_sGetter){r.write("checked='checked'");}r.write('></td>');r.write('<td><input type="checkbox" data-sap-ui-method="'+h(p._sMutator)+'" title="Activate debugger for '+h(p._sMutator)+'"');if(p.bp_sMutator){r.write("checked='checked'");}r.write('></td>');r.write("</tr>");});$.each(v.aggregations,function(I,A){r.write("<tr><td>");r.write("<label class='sapUiSupportLabel'>"+h(A.name)+"</label>");r.write("</td><td>");r.write(h(A.value));r.write("</td>");r.write('<td><input type="checkbox" data-sap-ui-method="'+h(A._sGetter)+'" title="Activate debugger for '+h(A._sGetter)+'"');if(A.bp_sGetter){r.write("checked='checked'");}r.write('></td>');r.write('<td><input type="checkbox" data-sap-ui-method="'+h(A._sMutator)+'" title="Activate debugger for '+h(A._sMutator)+'"');if(A.bp_sMutator){r.write("checked='checked'");}r.write('></td>');r.write("</tr>");});r.write("</table></div>");}r.write("</li>");});r.write("</ul>");r.flush(this.$().find("#sapUiSupportControlPropertiesArea").get(0));r.destroy();this.$().find("#sapUiSupportControlTabs").css("visibility","");this.selectTab(this._tab.properties);};d.prototype.renderBindingsTab=function(m,s){var r=sap.ui.getCore().createRenderManager();if(m.contexts.length>0){r.write('<h2 style="padding-left:5px">Contexts</h2>');r.write('<ul class="sapUiSupportControlTreeList" data-sap-ui-controlid="'+h(s)+'">');$.each(m.contexts,function(i,o){r.write('<li>');r.write('<span><label class="sapUiSupportLabel">Model Name: '+h(o.modelName)+'</label></span>');r.write('<div class="sapUiSupportControlProperties">');r.write('<table><colgroup><col width="15%"><col width="35%"><col width="50%"></colgroup>');r.write('<tbody>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Path</label>');r.write('</td><td>');r.write('<div><span');if(o.invalidPath){r.write(' style="color:red"');}else if(o.unverifiedPath){r.write(' style="color:orange"');}r.write('>'+h(o.path));if(o.invalidPath){r.write(' (invalid)');}else if(o.unverifiedPath){r.write(' (unverified)');}r.write('</span></div>');r.write('</td></tr>');if(o.location){r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Inherited from</label>');r.write('</td><td>');r.write('<div><a class="control-tree sapUiSupportLink" title="'+h(o.location.name)+'" data-sap-ui-control-id="'+h(o.location.id)+'" href="#">'+h(g(o.location.name))+' ('+h(o.location.id)+')</a></div>');r.write('</td></tr>');}r.write('</tbody></table></div></li>');});r.write('</ul>');}if(m.bindings.length>0){r.write('<h2 style="padding-left:5px">Bindings</h2>');r.write('<ul class="sapUiSupportControlTreeList" data-sap-ui-controlid="'+h(s)+'">');$.each(m.bindings,function(i,o){r.write('<li data-sap-ui-binding-name="'+h(o.name)+'">');r.write('<span>');r.write('<label class="sapUiSupportLabel" style="vertical-align: middle">'+h(o.name)+'</label>');r.write('<img class="sapUiSupportRefreshBinding" title="Refresh Binding" '+'src="../../debug/images/refresh.gif" style="cursor:pointer;margin-left:5px;vertical-align:middle">');r.write('</span>');$.each(o.bindings,function(k,l){r.write('<div class="sapUiSupportControlProperties">');r.write('<table><colgroup><col width="15%"><col width="35%"><col width="50%"></colgroup>');r.write('<tbody>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Path</label>');r.write('</td><td>');r.write('<div><span');if(l.invalidPath){r.write(' style="color:red"');}else if(l.unverifiedPath){r.write(' style="color:orange"');}r.write('>'+h(l.path));if(l.invalidPath){r.write(' (invalid)');}else if(l.unverifiedPath){r.write(' (unverified)');}r.write('</span></div>');r.write('</td></tr>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Absolute Path</label>');r.write('</td><td>');if(typeof l.absolutePath!=='undefined'){r.write('<div>'+h(l.absolutePath)+'</div>');}else{r.write('<div>No binding</div>');}r.write('</td></tr>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Relative</label>');r.write('</td><td>');if(typeof l.isRelative!=='undefined'){r.write('<div>'+h(l.isRelative)+'</div>');}else{r.write('<div>No binding</div>');}r.write('</td></tr>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Binding Type</label>');r.write('</td><td>');if(!o.type){r.write('<div>No binding</div>');}else{r.write('<div title="'+h(o.type)+'">'+h(g(o.type))+'</div>');}r.write('</td></tr>');if(l.mode){r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Binding Mode</label>');r.write('</td><td>');r.write('<div>'+h(l.mode)+'</div>');r.write('</td></tr>');}r.write('<tr><td>');r.write('<label class="sapUiSupportLabel">Model</label>');r.write('</td><td>');r.write('<label class="sapUiSupportLabel">Name</label>');r.write('</td><td>');if(l.model&&l.model.name){r.write('<div>'+h(l.model.name)+'</div>');}else{r.write('<div>No binding</div>');}r.write('</td></tr>');r.write('<tr><td>');r.write('</td><td>');r.write('<label class="sapUiSupportLabel">Type</label>');r.write('</td><td>');if(l.model&&l.model.type){r.write('<div><span title="'+h(l.model.type)+'">'+h(g(l.model.type))+'</span></div>');}else{r.write('<div><span>No binding</span></div>');}r.write('</td></tr>');r.write('<tr><td>');r.write('</td><td>');r.write('<label class="sapUiSupportLabel">Default Binding Mode</label>');r.write('</td><td>');if(l.model&&l.model.bindingMode){r.write('<div><span>'+h(l.model.bindingMode)+'</span></div>');}else{r.write('<div><span>No binding</span></div>');}r.write('</td></tr>');r.write('<tr><td>');r.write('</td><td>');r.write('<label class="sapUiSupportLabel">Location</label>');r.write('</td><td>');if(l.model&&l.model.location&&l.model.location.type){if(l.model.location.type==='control'){r.write('<div><a class="control-tree sapUiSupportLink" title="'+h(l.model.location.name)+'" data-sap-ui-control-id="'+h(l.model.location.id)+'" href="#">'+h(g(l.model.location.name))+' ('+h(l.model.location.id)+')</a></div>');}else{r.write('<div><span title="sap.ui.getCore()">Core</span></div>');}}else{r.write('<div><span>No binding</span></div>');}r.write('</td></tr>');r.write('</tbody></table></div>');});r.write('</li>');});r.write('</ul>');}r.flush(this.$().find("#sapUiSupportControlPropertiesArea").get(0));r.destroy();};d.prototype.renderBreakpointsTab=function(m,s){var r=sap.ui.getCore().createRenderManager();r.write('<div class="sapUiSupportControlMethods" data-sap-ui-controlid="'+h(s)+'">');r.write('<select id="sapUiSupportControlMethodsSelect" class="sapUiSupportAutocomplete sapUiSupportSelect"><option></option>');$.each(m,function(i,v){if(!v.active){r.write('<option>'+h(v.name)+'</option>');}});r.write('</select>');r.write('<input class="sapUiSupportControlBreakpointInput sapUiSupportAutocomplete" type="text">');r.write('<button id="sapUiSupportControlAddBreakPoint" class="sapUiSupportRoundedButton ">Add breakpoint</button>');r.write('<hr class="no-border"><ul id="sapUiSupportControlActiveBreakpoints" class="sapUiSupportList sapUiSupportBreakpointList">');$.each(m,function(i,v){if(!v.active){return;}r.write('<li><span>'+h(v.name)+'</span>'+'<img class="remove-breakpoint" style="cursor:pointer;margin-left:5px" '+'src="../../debug/images/delete.gif"></li>');});r.write('</ul></div>');r.flush(this.$().find("#sapUiSupportControlPropertiesArea").get(0));r.destroy();this.selectTab(this._tab.breakpoints);this.$().find('.sapUiSupportControlBreakpointInput').trigger("focus");};d.prototype.renderExportTab=function(){var r=sap.ui.getCore().createRenderManager();r.write('<button id="sapUiSupportControlExportToXml" class="sapUiSupportRoundedButton sapUiSupportExportButton">Export To XML</button>');r.write('<br><br>');r.write('<button id="sapUiSupportControlExportToHtml" class="sapUiSupportRoundedButton sapUiSupportExportButton">Export To HTML</button>');r.flush(this.$().find("#sapUiSupportControlPropertiesArea").get(0));r.destroy();this.selectTab(this._tab.exports);};d.prototype.requestProperties=function(s){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:s,callback:this.getId()+"ReceivePropertiesMethods"});};d.prototype.updateBreakpointCount=function(s,m){var i=$("#sap-debug-controltree-"+s+" > div span.sapUiSupportControlTreeBreakpointCount");if(m.active>0){i.text(m.active+" / "+m.all).show();}else{i.text("").hide();}};d.prototype.onsapUiSupportControlTreeTriggerRequestProperties=function(o){this.requestProperties(o.getParameter("controlId"));};d.prototype.onsapUiSupportControlTreeReceivePropertiesMethods=function(o){var s=o.getParameter("controlId");this._oStub.sendEvent(this.getId()+"RequestProperties",{id:s,breakpointMethods:o.getParameter("methods")});this.updateBreakpointCount(s,JSON.parse(o.getParameter("breakpointCount")));};d.prototype.onsapUiSupportControlTreeReceiveControlTree=function(o){this.renderControlTree(JSON.parse(o.getParameter("controlTree")));};d.prototype.onsapUiSupportControlTreeReceiveControlTreeExportError=function(o){var s=o.getParameter("errorMessage");this._drawAlert(s);};d.prototype._drawAlert=function(s){alert("ERROR: The selected element cannot not be exported.\nPlease choose an other one.\n\nReason:\n"+s);};d.prototype.onsapUiSupportControlTreeReceiveControlTreeExport=function(o){var z;var v=JSON.parse(o.getParameter("serializedViews"));var t=o.getParameter("sType");if(!$.isEmptyObject(v)){z=new J();for(var i in v){var k=v[i];z.file(i.replace(/\./g,'/')+".view."+t.toLowerCase(),k);}}if(z){var l=z.generate({type:"blob"});F.save(l,t.toUpperCase()+"Export","zip","application/zip");}};d.prototype.onsapUiSupportSelectorSelect=function(o){this.selectControl(o.getParameter("id"));};d.prototype.onsapUiSupportControlTreeReceiveProperties=function(o){this.renderPropertiesTab(JSON.parse(o.getParameter("properties")),o.getParameter("id"));};d.prototype.onsapUiSupportControlTreeReceiveBindingInfos=function(o){this.renderBindingsTab(JSON.parse(o.getParameter("bindinginfos")),o.getParameter("id"));};d.prototype.onsapUiSupportControlTreeReceiveMethods=function(o){var s=o.getParameter("controlId");this.renderBreakpointsTab(JSON.parse(o.getParameter("methods")),s);this.updateBreakpointCount(s,JSON.parse(o.getParameter("breakpointCount")));};d.prototype._onNodeClick=function(o){var i=$(o.target);var k=i.closest("li");if(k.hasClass("sapUiControlTreeElement")){$(".sapUiControlTreeElement > div").removeClass("sapUiSupportControlTreeSelected");k.children("div").addClass("sapUiSupportControlTreeSelected");this._oStub.sendEvent("sapUiSupportSelectorHighlight",{id:k.attr("id").substring("sap-debug-controltree-".length)});var I=k.attr("id").substring("sap-debug-controltree-".length);if(i.hasClass("sapUiSupportControlTreeBreakpointCount")){this._currentTab=this._tab.breakpoints;}this.onAfterControlSelected(I);}o.stopPropagation();};d.prototype._onIconClick=function(o){var i=$(o.target);if(i.parent().attr("data-sap-ui-collapsed")){i.attr("src",i.attr("src").replace("plus","minus")).parent().removeAttr("data-sap-ui-collapsed");i.siblings("ul").show();}else{i.attr("src",i.attr("src").replace("minus","plus")).parent().attr("data-sap-ui-collapsed","true");i.siblings("ul").hide();}if(o.stopPropagation){o.stopPropagation();}};d.prototype._onControlTreeLinkClick=function(o){this.selectControl($(o.target).closest("li").attr("data-sap-ui-controlid"));};d.prototype._onPropertiesTab=function(o){if(this.selectTab(this._tab.properties)){this.requestProperties(this.getSelectedControlId());}};d.prototype._onBindingInfosTab=function(o){if(this.selectTab(this._tab.bindinginfos)){this._oStub.sendEvent(this.getId()+"RequestBindingInfos",{id:this.getSelectedControlId()});}};d.prototype._onMethodsTab=function(o){if(this.selectTab(this._tab.breakpoints)){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:this.getSelectedControlId(),callback:this.getId()+"ReceiveMethods"});}};d.prototype._onExportTab=function(o){if(this.selectTab(this._tab.exports)){this.renderExportTab();}};d.prototype._autoComplete=function(o){if(o.keyCode==K.ENTER){this._updateSelectOptions(o);this._onAddBreakpointClicked();}if(o.keyCode>=K.ARROW_LEFT&&o.keyCode<=K.ARROW_DOWN){return;}var k=$(o.target),l=k.prev("select"),I=k.val();if(I==""){return;}var m=l.find("option").map(function(){return $(this).val();}).get();var s;for(var i=0;i<m.length;i++){s=m[i];if(s.toUpperCase().indexOf(I.toUpperCase())==0){var n=k.cursorPos();if(o.keyCode==K.BACKSPACE){n--;}k.val(s);k.selectText(n,s.length);break;}}return;};d.prototype._updateSelectOptions=function(o){var s=o.target;if(s.tagName=="INPUT"){var v=s.value;s=s.previousSibling;var k=s.options;for(var i=0;i<k.length;i++){var t=k[i].value||k[i].text;if(t.toUpperCase()==v.toUpperCase()){s.selectedIndex=i;break;}}}var l=s.selectedIndex;var m=s.options[l].value||s.options[l].text;if(s.nextSibling&&s.nextSibling.tagName=="INPUT"){s.nextSibling.value=m;}};d.prototype._onAddBreakpointClicked=function(o){var i=this.$().find("#sapUiSupportControlMethodsSelect");this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:i.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid"),methodName:i.val(),active:true,callback:this.getId()+"ReceiveMethods"});};d.prototype._onExportToXmlClicked=function(o){this._startSerializing("XML");};d.prototype._onExportToHtmlClicked=function(o){this._startSerializing("HTML");};d.prototype._startSerializing=function(t){var s=this.getSelectedControlId();if(s){this._oStub.sendEvent(this.getId()+"RequestControlTreeSerialize",{controlID:s,sType:t});}else{this._drawAlert("Nothing to export. Please select an item in the control tree.");}};d.prototype._onRemoveBreakpointClicked=function(o){var i=$(o.target);this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:i.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid"),methodName:i.siblings('span').text(),active:false,callback:this.getId()+"ReceiveMethods"});};d.prototype._selectOptionsChanged=function(o){var s=o.target;var i=s.nextSibling;i.value=s.options[s.selectedIndex].value;};d.prototype._onPropertyChange=function(o){var s=o.target;var i=$(s);var I=i.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid");var v=i.val();if(i.attr("type")==="checkbox"){v=""+i.is(":checked");}this._oStub.sendEvent(this.getId()+"ChangeProperty",{id:I,name:i.attr("data-sap-ui-name"),value:v});};d.prototype._onPropertyBreakpointChange=function(o){var i=$(o.target);this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:i.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid"),methodName:i.attr("data-sap-ui-method"),active:i.is(":checked"),callback:this.getId()+"TriggerRequestProperties"});};d.prototype._onNavToControl=function(o){var i=$(o.target);var I=i.attr("data-sap-ui-control-id");if(I!==this.getSelectedControlId()){this.selectControl(I);}};d.prototype._onRefreshBinding=function(o){var i=$(o.target);var I=i.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid");var n=i.closest("[data-sap-ui-binding-name]").attr("data-sap-ui-binding-name");this._oStub.sendEvent(this.getId()+"RefreshBinding",{id:I,name:n});};d.prototype.selectTab=function(t){var i=this.$().find("#sapUiSupportControlTab"+t);if(i.hasClass("active")){return false;}this.$().find("#sapUiSupportControlTabs button").removeClass("active");i.addClass("active");this._currentTab=t;return true;};d.prototype.getSelectedControlId=function(){var i=this.$().find(".sapUiSupportControlTreeSelected");if(i.length===0){return undefined;}else{return i.parent().attr("id").substring("sap-debug-controltree-".length);}};d.prototype.selectControl=function(s){if(!s){return;}$(".sapUiControlTreeElement > div").removeClass("sapUiSupportControlTreeSelected");var t=this;q(document.getElementById("sap-debug-controltree-"+s)).parents("[data-sap-ui-collapsed]").each(function(i,v){t._onIconClick({target:$(v).find("img:first").get(0)});});var p=q(document.getElementById("sap-debug-controltree-"+s)).children("div").addClass("sapUiSupportControlTreeSelected").position();var S=this.$().find("#sapUiSupportControlTreeArea").scrollTop();this.$().find("#sapUiSupportControlTreeArea").scrollTop(S+p.top);this.onAfterControlSelected(s);};d.prototype.onAfterControlSelected=function(i){if(this._currentTab==this._tab.properties){this.requestProperties(i);}else if(this._currentTab==this._tab.breakpoints){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:i,callback:this.getId()+"ReceiveMethods"});}else if(this._currentTab==this._tab.bindinginfos){this._oStub.sendEvent(this.getId()+"RequestBindingInfos",{id:this.getSelectedControlId()});}};function j(s){this.onsapUiSupportControlTreeRequestControlTree();}d.prototype.onsapUiSupportControlTreeRequestControlTree=function(o){this._oStub.sendEvent(this.getId()+"ReceiveControlTree",{controlTree:JSON.stringify(this.getControlTree())});};d.prototype.onsapUiSupportControlTreeRequestControlTreeSerialize=function(o){var k=this.oCore.byId(o.getParameter("controlID"));var t=o.getParameter("sType");var v;var m;sap.ui.controller(t+"ViewController",{});sap.ui.jsview(t+"ViewExported",{getControllerName:function(){return t+"ViewController";},createContent:function(r){}});sap.ui.controller(t+"ViewController",{});sap.ui.jsview(t+"ViewExported",{getControllerName:function(){return t+"ViewController";},createContent:function(r){}});try{if(k){if(k instanceof b){v=new V(k,window,"sap.m");}else{var l=sap.ui.jsview(t+"ViewExported");l.addContent(k.clone());v=new V(l,window,"sap.m");}m=(t&&t!=="XML")?v.serializeToHTML():v.serializeToXML();}else{var u=this.oCore.getUIArea(o.getParameter("controlID"));var l=sap.ui.jsview(t+"ViewExported");var n=u.getContent();for(var i=0;i<n.length;i++){l.addContent(n[i]);}v=new V(l,window,"sap.m");m=(t&&t!=="XML")?v.serializeToHTML():v.serializeToXML();for(var i=0;i<n.length;i++){u.addContent(n[i]);}}if(v){this._oStub.sendEvent(this.getId()+"ReceiveControlTreeExport",{serializedViews:JSON.stringify(m),sType:t});}}catch(p){this._oStub.sendEvent(this.getId()+"ReceiveControlTreeExportError",{errorMessage:p.message});}};d.prototype.onsapUiSupportControlTreeRequestProperties=function(o){var i=JSON.parse(o.getParameter("breakpointMethods"));var k=this.getControlProperties(o.getParameter("id"),i);this._oStub.sendEvent(this.getId()+"ReceiveProperties",{id:o.getParameter("id"),properties:JSON.stringify(k)});};d.prototype.onsapUiSupportControlTreeChangeProperty=function(o){var i=o.getParameter("id");var k=this.oCore.byId(i);if(k){var n=o.getParameter("name");var v=o.getParameter("value");var p=k.getMetadata().getProperty(n);if(p&&p.type){var t=D.getType(p.type);if(t instanceof D){var l=t.parseValue(v);if(t.isValid(l)&&l!=="(null)"){k[p._sMutator](l);}}else if(t){if(t[v]){k[p._sMutator](v);}}}}};d.prototype.onsapUiSupportControlTreeRequestBindingInfos=function(o){var i=o.getParameter("id");this._oStub.sendEvent(this.getId()+"ReceiveBindingInfos",{id:i,bindinginfos:JSON.stringify(this.getControlBindingInfos(i))});};d.prototype.onsapUiSupportControlTreeRefreshBinding=function(o){var i=o.getParameter("id");var s=o.getParameter("name");this.refreshBinding(i,s);this._oStub.sendEvent(this.getId()+"ReceiveBindingInfos",{id:i,bindinginfos:JSON.stringify(this.getControlBindingInfos(i))});};d.prototype.getControlTree=function(){var o=this.oCore,k=[],A={};function s(i){var m={id:i.getId(),type:"",aggregation:[],association:[]};A[m.id]=m.id;if(i instanceof U){m.library="sap.ui.core";m.type="sap.ui.core.UIArea";$.each(i.getContent(),function(I,i){var y=s(i);m.aggregation.push(y);});}else{m.library=i.getMetadata().getLibraryName();m.type=i.getMetadata().getName();if(i.mAggregations){for(var n in i.mAggregations){var p=i.mAggregations[n];if(p){var r=$.isArray(p)?p:[p];$.each(r,function(I,y){if(y instanceof E){var z=s(y);m.aggregation.push(z);}});}}}if(i.mAssociations){var t=i.getMetadata().getAllAssociations();for(var u in i.mAssociations){var v=i.mAssociations[u];var w=(t[u])?t[u].type:null;if(v&&w){var x=$.isArray(v)?v:[v];$.each(x,function(I,y){m.association.push({id:y,type:w,name:u,isAssociationLink:true});});}}}}return m;}$.each(o.mUIAreas,function(i,u){var m=s(u);k.push(m);});function l(I,m){for(var i=0;i<m.association.length;i++){var n=m.association[i];if(!A[n.id]){var t=O.get(n.type||"");if(!(typeof t==="function")){continue;}var S=t.getMetadata().getStereotype(),p=null;switch(S){case"element":case"control":p=o.byId(n.id);break;case"component":p=o.getComponent(n.id);break;case"template":p=o.getTemplate(n.id);break;default:break;}if(!p){continue;}m.association[i]=s(p);m.association[i].isAssociation=true;l(0,m.association[i]);}}$.each(m.aggregation,l);}$.each(k,l);return k;};d.prototype.getControlProperties=function(i,m){var p=/^((boolean|string|int|float)(\[\])?)$/;var k=[];var l=this.oCore.byId(i);if(!l&&this.oCore.getUIArea(i)){k.push({control:"sap.ui.core.UIArea",properties:[],aggregations:[]});}else if(l){var M=l.getMetadata();while(M instanceof a){var n={control:M.getName(),properties:[],aggregations:[]};var r=M.getProperties();$.each(r,function(s,t){var u={};$.each(t,function(N,v){if(N.substring(0,1)!=="_"||(N=='_sGetter'||N=='_sMutator')){u[N]=v;}if(N=='_sGetter'||N=='_sMutator'){u["bp"+N]=m.filter(function(o){return o.name===v&&o.active;}).length===1;}var T=D.getType(t.type);if(T&&!(T instanceof D)){u["enumValues"]=T;}});u.value=l.getProperty(s);u.isBound=!!l.mBindingInfos[s];n.properties.push(u);});var A=M.getAggregations();$.each(A,function(s,t){if(t.altTypes&&t.altTypes[0]&&p.test(t.altTypes[0])&&typeof(l.getAggregation(s))!=='object'){var u={};$.each(t,function(N,v){if(N.substring(0,1)!=="_"||(N=='_sGetter'||N=='_sMutator')){u[N]=v;}if(N=='_sGetter'||N=='_sMutator'){u["bp"+N]=m.filter(function(o){return o.name===v&&o.active;}).length===1;}});u.value=l.getAggregation(s);n.aggregations.push(u);}});k.push(n);M=M.getParent();}}return k;};d.prototype.getControlBindingInfos=function(i){var m={bindings:[],contexts:[]};var o=this.oCore.byId(i);if(!o){return m;}var k=o.mBindingInfos;var t=this;for(var l in k){if(k.hasOwnProperty(l)){var n=k[l];var p=[];var r,s=[];if($.isArray(n.parts)){r=n.parts;}else{r=[n];}if(n.binding instanceof c){s=n.binding.getBindings();}else if(n.binding instanceof B){s=[n.binding];}$.each(r,function(I,z){var A={};A.invalidPath=true;A.path=z.path;A.mode=z.mode;A.model={name:z.model};if(s.length>I&&s[I]){var G=s[I],M=G.getModel(),H=G.getPath(),L;if(M){L=M.resolve(H,G.getContext());if(M.isA("sap.ui.model.odata.v4.ODataModel")){A.unverifiedPath=true;A.invalidPath=false;}else{if(M.getProperty(L)!==undefined&&M.getProperty(L)!==null){A.invalidPath=false;}else if(M.getProperty(H)!==undefined&&M.getProperty(H)!==null){A.invalidPath=false;L=H;}}}A.absolutePath=(typeof(L)==='undefined')?'Unresolvable':L;A.isRelative=G.isRelative();A.model=t.getBindingModelInfo(G,o);}p.push(A);});m.bindings.push({name:l,type:(n.binding)?n.binding.getMetadata().getName():undefined,bindings:p});}}function u(z,M){var A={modelName:(M==='undefined')?'none (default)':M,path:z.getPath()};if(z.getModel().isA("sap.ui.model.odata.v4.ODataModel")){A.unverifiedPath=true;}else{if(!z.getObject()==null){A.invalidPath=true;}}return A;}var v=o.oBindingContexts;for(var w in v){if(v.hasOwnProperty(w)){m.contexts.push(u(v[w],w));}}var v=o.oPropagatedProperties.oBindingContexts;for(var w in v){if(v.hasOwnProperty(w)&&!o.oBindingContexts[w]){var x=u(v[w],w);var y=o;do{if(y.oBindingContexts[w]==v[w]){x.location={id:y.getId(),name:y.getMetadata().getName()};break;}}while((y=y.getParent()));m.contexts.push(x);}}return m;};d.prototype.getBindingModelInfo=function(o,i){var m={};var k=o.getModel();function l(M){for(var s in M){if(M.hasOwnProperty(s)){if(M[s]===k){return s;}}}return null;}m.name=l(i.oModels)||l(i.oPropagatedProperties.oModels);if(m.name){var n=i;do{if(n.oModels[m.name]===k){m.location={type:'control',id:n.getId(),name:n.getMetadata().getName()};break;}}while((n=n.getParent()));if(!m.location){var p=null;if(m.name==='undefined'){p=this.oCore.getModel();}else{p=this.oCore.getModel(m.name);}if(p){m.location={type:'core'};}}}m.type=k.getMetadata().getName();m.bindingMode=k.getDefaultBindingMode();m.name=(m.name==='undefined')?'none (default)':m.name;return m;};d.prototype.refreshBinding=function(I,s){var o=this.oCore.byId(I);var m=o.mBindingInfos[s];if(!o||!m){return;}var k=m.binding;if(!k){return;}if(k instanceof c){var l=k.getBindings();for(var i=0;i<l.length;i++){l[i].refresh();}}else{k.refresh();}};return d;});
