/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseTreeModifier","sap/ui/base/ManagedObject","sap/ui/base/DataType","sap/base/util/merge","sap/ui/util/XMLHelper","sap/ui/core/mvc/EventHandlerResolver","sap/base/util/includes","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/core/Fragment"],function(B,M,D,m,X,E,a,O,b){"use strict";var C="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var c=m({},B,{targets:"xmlTree",setVisible:function(o,v){if(v){o.removeAttribute("visible");}else{o.setAttribute("visible",v);}},getVisible:function(o){return c.getProperty(o,"visible");},setStashed:function(o,s){if(!s){o.removeAttribute("stashed");}else{o.setAttribute("stashed",s);}c.setVisible(o,!s);},getStashed:function(o){return c.getProperty(o,"stashed")||!c.getProperty(o,"visible");},bindProperty:function(o,p,v){o.setAttribute(p,"{"+v+"}");},unbindProperty:function(o,p){o.removeAttribute(p);},_setProperty:function(o,p,P,e){var v=c._getSerializedValue(P);if(e){v=c._escapeCurlyBracketsInString(v);}o.setAttribute(p,v);},setProperty:function(o,p,P){c._setProperty(o,p,P,true);},getProperty:function(o,p){var P=o.getAttribute(p);var d=c.getControlMetadata(o).getProperty(p);if(d){var t=d.getType();if(p==="value"&&c.getControlType(o)==="sap.ui.core.CustomData"&&c.getProperty(o,"key")==="sap-ui-custom-settings"){t=D.getType("object");}if(P===null){P=d.getDefaultValue()||t.getDefaultValue();}else{var u=M.bindingParser(P,undefined,true);if(b(u)){if(u.path||u.parts){P=undefined;}else{P=u;}}else{P=t.parseValue(u||P);}}}return P;},isPropertyInitial:function(o,p){var P=o.getAttribute(p);return(P==null);},setPropertyBinding:function(o,p,P){if(typeof P!=="string"){throw new Error("For XML, only strings are supported to be set as property binding.");}o.setAttribute(p,P);},getPropertyBinding:function(o,p){var P=o.getAttribute(p);if(P){var u=M.bindingParser(P,undefined,true);if(u&&(u.path||u.parts)){return u;}}},createAndAddCustomData:function(o,s,v){o.setAttributeNS(C,"custom.data.via.modifier:"+s,c._escapeCurlyBracketsInString(v));},createControl:function(s,A,v,S,d,e){var i,l,o;if(!c.bySelector(S,A,v)){var f=s.split('.');var n="";if(f.length>1){l=f.pop();n=f.join('.');}var N=v.ownerDocument.createElementNS(n,l);i=c.getControlIdBySelector(S,A);if(i){N.setAttribute("id",i);}if(d){c.applySettings(N,d);}return e?Promise.resolve(N):N;}else{o=new Error("Can't create a control with duplicated ID "+i);if(e){return Promise.reject(o);}throw o;}},applySettings:function(o,s){var d=c.getControlMetadata(o);var e=d.getJSONKeys();Object.keys(s).forEach(function(k){var K=e[k];var v=s[k];switch(K._iKind){case 0:c._setProperty(o,k,v,false);break;case 3:c.setAssociation(o,k,v);break;default:throw new Error("Unsupported in applySettings on XMLTreeModifier: "+k);}});},_byId:function(i,v){if(v){if(v.ownerDocument&&v.ownerDocument.getElementById&&v.ownerDocument.getElementById(i)){return v.ownerDocument.getElementById(i);}else{return v.querySelector("[id='"+i+"']");}}},getId:function(o){return o.getAttribute("id");},getParent:function(o){var p=o.parentNode;if(!c.getId(p)&&!c._isExtensionPoint(p)){p=p.parentNode;}return p;},_getLocalName:function(x){return x.localName||x.baseName||x.nodeName;},getControlType:function(o){return c._getControlTypeInXml(o);},setAssociation:function(p,n,i){if(typeof i!=="string"){i=c.getId(i);}p.setAttribute(n,i);},getAssociation:function(p,n){return p.getAttribute(n);},getAllAggregations:function(o){var d=c.getControlMetadata(o);return d.getAllAggregations();},getAggregation:function(p,n){var A=c._findAggregationNode(p,n);var s=c._isSingleValueAggregation(p,n);var d=[];if(A){d=c._getControlsInAggregation(p,A);}else if(c._isAltTypeAggregation(p,n)&&s){d.push(c.getProperty(p,n));}if(n==="customData"){var e;var N=Array.prototype.slice.call(p.attributes).reduce(function(f,g){var l=c._getLocalName(g);if(g.namespaceURI===C){var o=p.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key",l);o.setAttribute("value",g.value);f.push(o);}else if(g.namespaceURI&&g.name.indexOf("xmlns:")!==0){if(!e){e={};}if(!e.hasOwnProperty(g.namespaceURI)){e[g.namespaceURI]={};}e[g.namespaceURI][l]=g.nodeValue;}return f;},[]);d=d.concat(N);if(e){var o=p.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key","sap-ui-custom-settings");c.setProperty(o,"value",e);d.push(o);}}return s?d[0]:d;},insertAggregation:function(p,n,o,i,v){var A=c._findAggregationNode(p,n);if(!A){var N=p.namespaceURI;A=c.createControl(N+"."+n,undefined,v);p.appendChild(A);}if(i>=A.childElementCount){A.appendChild(o);}else{var r=c._getControlsInAggregation(p,A)[i];A.insertBefore(o,r);}},removeAggregation:function(p,n,o){var A=c._findAggregationNode(p,n);A.removeChild(o);},removeAllAggregation:function(o,n){var A=c._findAggregationNode(o,n);if(o===A){var d=c._getControlsInAggregation(o,o);d.forEach(function(e){o.removeChild(e);});}else{o.removeChild(A);}},_findAggregationNode:function(p,n){var A;var d=c._children(p);for(var i=0;i<d.length;i++){var N=d[i];if(N.localName===n){A=N;break;}}if(!A&&c._isDefaultAggregation(p,n)){A=p;}return A;},_isDefaultAggregation:function(p,A){var o=c.getControlMetadata(p);var d=o.getDefaultAggregation();return d&&A===d.name;},_isNotNamedAggregationNode:function(p,o){var A=c.getAllAggregations(p);var d=A[o.localName];return p.namespaceURI!==o.namespaceURI||!d;},_isSingleValueAggregation:function(p,A){var d=c.getAllAggregations(p);var o=d[A];return!o.multiple;},_isAltTypeAggregation:function(p,A){var o=c.getControlMetadata(p);var d=o.getAllAggregations()[A];return!!d.altTypes;},_isExtensionPoint:function(o){return c._getControlTypeInXml(o)==="sap.ui.core.ExtensionPoint";},getControlMetadata:function(o){return c._getControlMetadataInXml(o);},_getControlsInAggregation:function(p,A){var d=Array.prototype.slice.call(c._children(A));return d.filter(c._isNotNamedAggregationNode.bind(this,p));},_children:function(p){if(p.children){return p.children;}else{var d=[];for(var i=0;i<p.childNodes.length;i++){var n=p.childNodes[i];if(n.nodeType===n.ELEMENT_NODE){d.push(n);}}return d;}},getBindingTemplate:function(o,A){var d=c._findAggregationNode(o,A);if(d){var e=c._children(d);if(e.length===1){return e[0];}}},updateAggregation:function(o,A){},findIndexInParentAggregation:function(o){var p,A,d;p=c.getParent(o);if(!p){return-1;}A=c.getParentAggregationName(o,p);d=c.getAggregation(p,A);if(Array.isArray(d)){d=d.filter(function(o){if(c._isExtensionPoint(o)){return true;}return!c.getProperty(o,"stashed");});return d.indexOf(o);}else{return 0;}},getParentAggregationName:function(o,p){var n,A;if(!p.isSameNode(o.parentNode)){n=false;}else{n=c._isNotNamedAggregationNode(p,o);}if(n){A=c.getControlMetadata(p).getDefaultAggregationName();}else{A=c._getLocalName(o.parentNode);}return A;},findAggregation:function(o,A){var d=c.getControlMetadata(o);var e=d.getAllAggregations();if(e){return e[A];}},validateType:function(o,A,p,f,i){var t=A.type;if(A.multiple===false&&c.getAggregation(p,A.name)&&c.getAggregation(p,A.name).length>0){return false;}var d=sap.ui.xmlfragment({fragmentContent:f});if(!Array.isArray(d)){d=[d];}var r=d[i].isA(t);d.forEach(function(F){F.destroy();});return r;},instantiateFragment:function(f,n,v){var d;var F=X.parse(f);F=c._checkAndPrefixIdsInFragment(F,n);if(F.localName==="FragmentDefinition"){d=c._getElementNodeChildren(F);}else{d=[F];}d.forEach(function(N){if(c._byId(N.getAttribute("id"),v)){throw Error("The following ID is already in the view: "+N.getAttribute("id"));}});return d;},templateControlFragment:function(f,p){return B._templateFragment(f,p).then(function(F){return c._children(F);});},destroy:function(o){var p=o.parentNode;if(p){p.removeChild(o);}},_getFlexCustomData:function(o,t){if(!o){return undefined;}return o.getAttributeNS("sap.ui.fl",t);},attachEvent:function(n,e,f,d){if(typeof O.get(f)!=="function"){throw new Error("Can't attach event because the event handler function is not found or not a function.");}var v=c.getProperty(n,e)||"";var g=E.parse(v);var s=f;var p=["$event"];if(d){p.push(JSON.stringify(d));}s+="("+p.join(",")+")";if(!a(g,s)){g.push(s);}n.setAttribute(e,g.join(";"));},detachEvent:function(n,e,f){if(typeof O.get(f)!=="function"){throw new Error("Can't attach event because the event handler function is not found or not a function.");}var v=c.getProperty(n,e)||"";var d=E.parse(v);var i=d.findIndex(function(s){return s.includes(f);});if(i>-1){d.splice(i,1);}if(d.length){n.setAttribute(e,d.join(";"));}else{n.removeAttribute(e);}},bindAggregation:function(n,A,v,V){c.bindProperty(n,A,v.path);c.insertAggregation(n,A,v.template,0,V);},unbindAggregation:function(n,A){if(n.hasAttribute(A)){n.removeAttribute(A);c.removeAllAggregation(n,A);}},getExtensionPointInfo:function(e,v){if(v&&e){var d=Array.prototype.slice.call(v.getElementsByTagNameNS("sap.ui.core","ExtensionPoint"));var f=d.filter(function(h){return h.getAttribute("name")===e;});var o=(f.length===1)?f[0]:undefined;if(o){var p=c.getParent(o);var g={parent:p,aggregationName:c.getParentAggregationName(o,p),index:c.findIndexInParentAggregation(o)+1,defaultContent:Array.prototype.slice.call(c._children(o))};return g;}}}});return c;},true);
